/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.control.FinishedRptFactory;
import com.kingdee.eas.mm.control.IFinishedRpt;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.IManufactureRecBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillAgent;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryAgent;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractManufactureRecBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ManufactureRecBillControllerBean
extends AbstractManufactureRecBillControllerBean {
    private static final long serialVersionUID = 5760081897996671969L;
    private Map mapDefaultLocation = null;

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.dealBillCost(ctx, model);
        super.update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealBillCost(Context ctx, CoreBaseInfo model) throws BOSException {
        ManufactureRecBillInfo info = (ManufactureRecBillInfo)model;
        ManufactureRecBillEntryInfo entry = null;
        ManufactureRecBillEntryCollection entries = info.getEntry();
        BigDecimal totalActualCost = new BigDecimal("0.00");
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" from T_IM_ManufactureRecBill bill");
        bf.append(" inner join T_IM_ManufactureRecBillEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            BigDecimal actualCost;
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            int length = entries.size();
            for (int i = 0; i < length; totalActualCost = totalActualCost.add(actualCost), ++i) {
                entry = entries.get(i);
                actualCost = null != entry.getActualCost() ? entry.getActualCost() : new BigDecimal("0.00");
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : new BigDecimal("0.00");
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                pm.setString(1, entry.getId().toString());
                rs = pm.executeQuery();
                if (!rs.next()) continue;
                BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                entry.setReverseQty(reverseQty);
                entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pm, (Connection)conn);
    }

    @Override
    protected IObjectValue _getDefaultCostObject(Context ctx, String materialId, String companyId, String lot) throws BOSException, EASBizException {
        CostObjectInfo costObjectInfo = null;
        MaterialCompanyInfoInfo aMaterialCompanyInfoInfo = MaterialFactory.getLocalInstance((Context)ctx).getCompanyInfo(materialId, companyId);
        if (aMaterialCompanyInfoInfo != null && aMaterialCompanyInfoInfo.getAccountType() != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select bill.fid as FID,bill.FCalculateMode as FCalculateMode ");
            sql.append("from T_BD_CostObject bill ");
            sql.append("inner join T_BD_CostObjectEntry entry on bill.fid=entry.fparentid ");
            sql.append("where bill.FCompanyID=? ");
            sql.append("and entry.FRelatedID=? ");
            sql.append(" and bill.fisforbiden = 0");
            if (lot != null && lot.length() > 0) {
                sql.append("and bill.FBatchNumber = '").append(lot).append("' ");
            } else {
                sql.append("and bill.FBatchNumber is null ");
            }
            String costId = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, materialId});
            try {
                if (rs.next()) {
                    costId = rs.getString("FID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (costId != null) {
                costObjectInfo = CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            }
        }
        return costObjectInfo;
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-0167c0a812fd463ED552";
    }

    @Override
    protected int _associateManufactureRecBill(Context ctx, String fsourcebillid) throws BOSException, EASBizException {
        int billWeight = 0;
        if (fsourcebillid == null || fsourcebillid.trim().length() < 1) {
            return 0;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)fsourcebillid, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        IManufactureRecBill iManufactureRecBill = ManufactureRecBillFactory.getLocalInstance(ctx);
        ManufactureRecBillCollection manufactureRecBillCollection = iManufactureRecBill.getManufactureRecBillCollection(viewInfo);
        if (manufactureRecBillCollection != null && manufactureRecBillCollection.size() > 0) {
            billWeight = 2;
            ManufactureRecBillInfo manufactureRecBillInfo = manufactureRecBillCollection.get(0);
            if (manufactureRecBillInfo != null) {
                billWeight = super._deleteable(ctx, manufactureRecBillInfo.getId().toString()) ? (billWeight += 4) : (billWeight += 8);
            }
        } else {
            billWeight = 1;
        }
        return billWeight;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.writeBackNumberFinishedRpt(ctx, pk);
        super._delete(ctx, pk);
    }

    private void writeBackNumberFinishedRpt(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.mateiral.id"));
        ManufactureRecBillInfo billInfo = this.getManufactureRecBillInfo(ctx, pk, selector);
        ArrayList<String> entryIds = new ArrayList<String>();
        if (billInfo != null && billInfo.getSourceBillType() != null && "e3soUQaBR8un8D2R7UpNwkY+1VI=".equalsIgnoreCase(billInfo.getSourceBillType().getId().toString())) {
            ManufactureRecBillEntryCollection entrys = billInfo.getEntry();
            ManufactureRecBillEntryInfo entry = null;
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                if (entry.getMaterial() == null) continue;
                entryIds.add(entry.getId().toString());
            }
            if (entryIds.size() > 0) {
                IFinishedRpt iFinishedRpt = FinishedRptFactory.getLocalInstance((Context)ctx);
                iFinishedRpt.updateRptTotalQty(billInfo.getId().toString(), entryIds);
            }
        }
    }

    protected List<SelectorItemInfo> getAddedSelector() {
        ArrayList<SelectorItemInfo> selList = new ArrayList<SelectorItemInfo>();
        SelectorItemCollection selector = this.getSelector();
        for (int i = 0; i < selector.size(); ++i) {
            selList.add(selector.get(i));
        }
        return selList;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getManufactureRecBillSelector((boolean)true);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (BatchActionEnum.UNAUDIT.getBizAction().equalsIgnoreCase(name)) {
            HashSet<String> ids = new HashSet<String>();
            CoreBaseCollection coll = null;
            for (int i = 0; i < paramEntries.length; ++i) {
                ids.add(paramEntries[i].toArray()[0].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("transactionType.id"));
            selector.add(new SelectorItemInfo("bizType.id"));
            selector.add(new SelectorItemInfo("sourceBillType.id"));
            view.setSelector(selector);
            coll = this.getCollection(ctx, view);
            if (coll != null && coll.size() > 0) {
                InvBillBaseInfo info = null;
                String sourceBillTypeID = "";
                for (int i = 0; i < coll.size(); ++i) {
                    info = (InvBillBaseInfo)coll.get(i);
                    if (info == null || info.getSourceBillType() == null || info.getSourceBillType().getId() == null) continue;
                    sourceBillTypeID = info.getSourceBillType().getId().toString();
                    if ("WB3X6gEqEADgAAB5fwAAAUY+1VI=".equals(sourceBillTypeID)) {
                        throw new InvBizException(InvBizException.BILL_NOTUNAUDIT_DIRECTDELIVERY);
                    }
                    if (!"EVuaJtWZ4kKbRG9czgLdmkY+1VI=".equals(sourceBillTypeID)) continue;
                    throw new InvBizException(InvBizException.BILL_NOTUNAUDIT_DDMRECEIVALBILL);
                }
            }
        }
        return super.batchExecute(ctx, name, paramTypes, paramEntries);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        ManufactureRecBillInfo info = null;
        ManufactureRecBillEntryInfo entryInfo = null;
        MaterialInfo mi = null;
        WarehouseInfo wi = null;
        LocationInfo location = null;
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue model = collection.getObject(i);
            if (model == null) continue;
            info = (ManufactureRecBillInfo)model;
            try {
                if (info.getStorageOrgUnit() == null) continue;
                this.initBotpData(ctx, (IObjectValue)info);
                this.setStandardCost(ctx, info);
                int size = info.getEntry().size();
                for (int j = 0; j < size; ++j) {
                    entryInfo = info.getEntry().get(j);
                    mi = entryInfo.getMaterial();
                    if (mi == null) continue;
                    wi = entryInfo.getWarehouse();
                    if (!this.isBotpBill(info) || wi == null || entryInfo.getLocation() != null) continue;
                    location = this.getDefaultLocation(ctx, mi.getId().toString(), wi.getId().toString(), info.getStorageOrgUnit().getId().toString());
                    entryInfo.setLocation(location);
                }
                continue;
            }
            catch (Exception e) {
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
        }
    }

    public LocationInfo getDefaultLocation(Context ctx, String materialId, String warehsId, String souID) throws EASBizException, BOSException {
        LocationInfo location;
        if (materialId == null || warehsId == null || souID == null) {
            return null;
        }
        if (this.getMapDefaultLocation() == null) {
            this.mapDefaultLocation = new HashMap(0);
        }
        if ((location = (LocationInfo)this.getMapDefaultLocation().get(materialId + warehsId + souID)) == null && !this.getMapDefaultLocation().containsKey(materialId + warehsId + souID)) {
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number ").append("where storageOrg = '").append(souID).append("' and ").append("material  = '").append(materialId).append("' and ").append("warehouse = '").append(warehsId).append("' and ").append("ISDEFAULTLOCATION = 1 and warehouse.hasLocation=1 ");
            MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
            if (msaCol.size() > 0) {
                MaterialStorageAssignInfo info = msaCol.get(0);
                location = info.getLocation();
                this.putDefaultLocation(materialId, warehsId, souID, location);
            }
        }
        return location;
    }

    public Map getMapDefaultLocation() {
        return this.mapDefaultLocation;
    }

    public void setMapDefaultLocation(Map mapDefaultLocation) {
        this.mapDefaultLocation = mapDefaultLocation;
    }

    public void putDefaultLocation(String materialId, String warehsId, String souID, LocationInfo locInfo) {
        if (materialId == null || warehsId == null) {
            return;
        }
        this.getMapDefaultLocation().put(materialId + warehsId + souID, locInfo);
    }

    private void setStandardCost(Context ctx, ManufactureRecBillInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
        int precision = 2;
        if (cou != null && cou.getBaseCurrency() != null && cou.getBaseCurrency().getId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("precision"));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()), sic);
            precision = currency.getPrecision();
        }
        BigDecimal unitStandardCost = null;
        BigDecimal qty = null;
        BigDecimal standardCost = null;
        ManufactureRecBillEntryCollection col = info.getEntry();
        ManufactureRecBillEntryInfo entryInfo = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = col.get(i);
            unitStandardCost = entryInfo.getUnitStandardCost();
            qty = entryInfo.getQty();
            if (unitStandardCost == null || qty == null) continue;
            standardCost = unitStandardCost.multiply(qty).setScale(precision, 4);
            entryInfo.setStandardCost(standardCost);
        }
    }

    @Override
    protected void setNULLToZERO(IObjectValue invBill) {
        super.setNULLToZERO(invBill);
        ManufactureRecBillInfo billInfo = (ManufactureRecBillInfo)invBill;
        ManufactureRecBillEntryCollection entryCol = billInfo.getEntry();
        ManufactureRecBillEntryInfo entryInfo = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            if (entryInfo.getBizDate() != null) continue;
            entryInfo.setBizDate(billInfo.getBizDate());
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ManufactureRecBillInfo info = this.getManufactureRecBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ManufactureRecBillInfo info = this.getManufactureRecBillInfo(ctx, pk, this.getSelector());
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        ManufactureRecBillInfo info = this.getManufactureRecBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou;
        ManufactureRecBillInfo manufactureRecBillInfo = null;
        manufactureRecBillInfo = isUseAgent ? ManufactureRecBillAgent.create() : new ManufactureRecBillInfo();
        BigDecimal ZERO = BigDecimal.ZERO;
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0167c0a812fd463ED552"));
        aBillTypeInfo.setNumber("105");
        manufactureRecBillInfo.setBillType(aBillTypeInfo);
        manufactureRecBillInfo.setTotalQty(ZERO);
        manufactureRecBillInfo.setTotalStandardCost(ZERO);
        manufactureRecBillInfo.setTotalActualCost(ZERO);
        manufactureRecBillInfo.setTotalAmount(ZERO);
        manufactureRecBillInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        manufactureRecBillInfo.setFiVouchered(false);
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        manufactureRecBillInfo.setCreateTime(ts);
        manufactureRecBillInfo.setBizDate(manufactureRecBillInfo.getCreateTime());
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        manufactureRecBillInfo.setCreator(aUserInfo);
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"Nz878AEgEADgAABFwKg/GiQHQ1w=", (String)"50957179-0105-1000-e000-0167c0a812fd463ED552");
        manufactureRecBillInfo.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-0167c0a812fd463ED552", bizType.getId().toString());
            manufactureRecBillInfo.setTransactionType(tti);
        }
        if ((sou = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "manufacturerec_new")) == null) {
            manufactureRecBillInfo.getEntry().add(this.createNewDetailData(isUseAgent));
            return manufactureRecBillInfo;
        }
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)sou.getId().toString()));
        if (cou != null) {
            manufactureRecBillInfo.setStorageOrgUnit(sou);
        }
        ManufactureRecBillEntryInfo aManufactureRecBillEntryInfo = this.createNewDetailData(isUseAgent);
        aManufactureRecBillEntryInfo.setStorageOrgUnit(sou);
        aManufactureRecBillEntryInfo.setCompanyOrgUnit(cou);
        if (manufactureRecBillInfo.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType(ctx, "50957179-0105-1000-e000-0167c0a812fd463ED552", manufactureRecBillInfo.getTransactionType());
            aManufactureRecBillEntryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        manufactureRecBillInfo.getEntry().add(aManufactureRecBillEntryInfo);
        return manufactureRecBillInfo;
    }

    private ManufactureRecBillEntryInfo createNewDetailData(boolean isUseAgent) throws BOSException, EASBizException {
        BigDecimal ZERO = BigDecimal.ZERO;
        ManufactureRecBillEntryInfo manufactureRecBillEntryInfo = null;
        manufactureRecBillEntryInfo = isUseAgent ? ManufactureRecBillEntryAgent.create() : new ManufactureRecBillEntryInfo();
        manufactureRecBillEntryInfo.setIsPresent(false);
        manufactureRecBillEntryInfo.setQty(ZERO);
        manufactureRecBillEntryInfo.setAssistQty(ZERO);
        manufactureRecBillEntryInfo.setBaseQty(ZERO);
        manufactureRecBillEntryInfo.setReverseQty(ZERO);
        manufactureRecBillEntryInfo.setReceiveQty(ZERO);
        manufactureRecBillEntryInfo.setUnitActualCost(ZERO);
        manufactureRecBillEntryInfo.setActualCost(ZERO);
        manufactureRecBillEntryInfo.setUnitStandardCost(ZERO);
        manufactureRecBillEntryInfo.setStandardCost(ZERO);
        manufactureRecBillEntryInfo.setPrice(ZERO);
        manufactureRecBillEntryInfo.setAmount(ZERO);
        manufactureRecBillEntryInfo.setManuBillEntrySeq(0);
        manufactureRecBillEntryInfo.setSaleOrderEntrySeq(0);
        return manufactureRecBillEntryInfo;
    }
}

