/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.dt.DtTempFacadeFactory;
import com.kingdee.eas.scm.im.dt.IDtTempFacade;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IOtherInWarehsBill;
import com.kingdee.eas.scm.im.inv.IOtherIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillFactory;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryFactory;
import com.kingdee.eas.scm.im.inv.MaterialSNInventoryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.app.AbstractMatAttrChangeBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.CreateVirtualBillForMatattrBotp;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.util.RefreshInventoryUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MatAttrChangeBillControllerBean
extends AbstractMatAttrChangeBillControllerBean {
    private static final long serialVersionUID = 1648939101030350662L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MatAttrChangeBillControllerBean");
    private final String XTZHBISSUE = "XTZH001";
    private final String XTZHAINWAREHS = "XTZH002";
    private final String XTZHAISSUE = "XTZH003";
    private final String XTZHBINWAREHS = "XTZH004";
    private static final String INM210 = "INM210";
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";
    private static final String res = "com.kingdee.eas.scm.im.inv.MatAttrChangeResource";

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null && pk != null) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("transactionType.*"));
            sc.add(new SelectorItemInfo("entry.*"));
            sc.add(new SelectorItemInfo("entry.material.*"));
            sc.add(new SelectorItemInfo("entry.companyOrgUnit.name"));
            sc.add(new SelectorItemInfo("entry1.*"));
            sc.add(new SelectorItemInfo("entry1.material.*"));
            sc.add(new SelectorItemInfo("entry1.companyOrgUnit.name"));
            model = this.getSCMBillBaseInfo(ctx, pk, sc);
        }
        if (pk == null && model != null) {
            pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        }
        if (pk == null && model == null) {
            return;
        }
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        InvServerUtils.checkMatCompanyInfo(ctx, invBillBaseInfo, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
        if (!this.isAddNew(ctx, (IObjectValue)invBillBaseInfo)) {
            InvBillBaseInfo checkInfo = (InvBillBaseInfo)this.getDataNewStatus(ctx, (IObjectValue)invBillBaseInfo);
            this._checkAudit(ctx, (IObjectValue)checkInfo, true);
            this._checkSubmit(ctx, (IObjectValue)checkInfo, false);
        }
        this.isSamePerson4Audit(ctx, invBillBaseInfo);
        if (this.isCheckBizDate()) {
            if (!invBillBaseInfo.isIsInitBill()) {
                this._checkBizDate(ctx, model);
            } else {
                this._checkInitBizDate(ctx, model);
            }
        }
        this.updateAuditStatus(ctx, model);
        invBillBaseInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        MaterialSerialNumberFactory.getLocalInstance(ctx).updateMaterialSN(invBillBaseInfo);
        CreateVirtualBillForMatattrBotp botp = new CreateVirtualBillForMatattrBotp();
        MatAttrChangeBillInfo changeBillInfo = MatAttrChangeBillFactory.getLocalInstance(ctx).getMatAttrChangeBillInfo((IObjectPK)new ObjectStringPK(invBillBaseInfo.getId().toString()));
        String issueBotpNumber = "";
        String inWarehsBotpNumber = "";
        if (changeBillInfo.getBizType().getId().toString().equals("kXeVPjGzchDgQKjAYj1RYCQHQ1w=")) {
            issueBotpNumber = "XTZH003";
            inWarehsBotpNumber = "XTZH004";
        } else {
            issueBotpNumber = "XTZH001";
            inWarehsBotpNumber = "XTZH002";
        }
        try {
            ctx.put((Object)"autoCreateBill", (Object)Boolean.TRUE);
            IMaterialSerialNumber ims = MaterialSerialNumberFactory.getLocalInstance(ctx);
            IOtherIssueBill issueBill = OtherIssueBillFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("baseStatus"));
            InvBillBaseInfo isSueInfo = botp.createInvVirtualBill(ctx, model, issueBill, issueBotpNumber, null);
            ims.doSerialNumberCarry(changeBillInfo, isSueInfo, true);
            issueBill.submit((CoreBaseInfo)isSueInfo);
            isSueInfo = issueBill.getOtherIssueBillInfo((IObjectPK)new ObjectUuidPK(isSueInfo.getId().toString()), selector);
            if (isSueInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                issueBill.audit((IObjectPK)new ObjectUuidPK(isSueInfo.getId().toString()));
            }
            IOtherInWarehsBill inWarehsBill = OtherInWarehsBillFactory.getLocalInstance(ctx);
            InvBillBaseInfo inwarehsInfo = botp.createInvVirtualBill(ctx, model, inWarehsBill, inWarehsBotpNumber, isSueInfo);
            ims.doSerialNumberCarry(changeBillInfo, inwarehsInfo, false);
            inWarehsBill.submit((CoreBaseInfo)inwarehsInfo);
            inwarehsInfo = inWarehsBill.getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(inwarehsInfo.getId().toString()), selector);
            if (inwarehsInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                inWarehsBill.audit((IObjectPK)new ObjectUuidPK(inwarehsInfo.getId().toString()));
            }
        }
        catch (BOSException e) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            ctx.remove((Object)"autoCreateBill");
        }
        if (changeBillInfo.getBizType().getId().toString().equals("kXeVPjHuchDgQKjAYj1RYCQHQ1w=")) {
            this.updateDateOfMinDurability(ctx, pk.toString(), BillBaseStatusEnum.AUDITED);
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        iMaterialSerialNumber.updateMaterialSN(aInvBillBaseInfo);
        return super._save(ctx, model);
    }

    private void checkSerialNumber(Context ctx, InvBillBaseInfo invBillInfo) throws EASBizException, BOSException {
        String orgid = invBillInfo.getStorageOrgUnit().getId().toString();
        String paramValue = SCMUtil.getInvParamValue((Context)ctx, (String)orgid, (String)INM210);
        if (paramValue == null || "false".equalsIgnoreCase(paramValue.trim()) || "0".equalsIgnoreCase(paramValue.trim())) {
            return;
        }
        TransactionTypeInfo tti = invBillInfo.getTransactionType();
        boolean isNegative = invBillInfo.isIsReversed() ^ InvAppUtils.isNegative(tti);
        StringBuffer errorMsg = new StringBuffer();
        IObjectCollection collection = (IObjectCollection)invBillInfo.get("entry");
        InvBillBaseEntryInfo entryInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            entryInfo = (InvBillBaseEntryInfo)collection.getObject(i);
            String billID = invBillInfo.getId().toString();
            String entryID = entryInfo.getId().toString();
            String materialID = entryInfo.getMaterial().getId().toString();
            InvUpdateTypeInfo invUpdateType = entryInfo.getInvUpdateType();
            if ((isNegative || !invUpdateType.isExistingQty() || invUpdateType.isExistingQtyPre()) && (!isNegative || invUpdateType.isExistingQty() || !invUpdateType.isExistingQtyPre()) || entryInfo.getMaterial() == null || entryInfo.getMaterial().getSeqUnit() == null) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("entry.serialNumber"));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)entryID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
            view.setFilter(filter);
            view.setSelector(sc);
            MaterialSerialNumberCollection coll = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(view);
            for (int m = 0; m < coll.size(); ++m) {
                MaterialSerialNumberInfo materialSN = coll.get(m);
                MaterialSerialNumberEntryCollection entryCol = materialSN.getEntry();
                for (int n = 0; n < entryCol.size(); ++n) {
                    MaterialSerialNumberEntryInfo entrySN = entryCol.get(n);
                    String serialNumber = entrySN.getSerialNumber();
                    this.checkSNIsExist4Submit(ctx, serialNumber, materialID, errorMsg, entryInfo);
                }
            }
        }
        if (errorMsg.length() > 0) {
            String msg = EASResource.getString((String)res, (String)"AFTERCHANGE_SERIL", (Object[])new Object[]{errorMsg.toString()});
            throw new InvBizException(InvBizException.COMMON, new Object[]{msg});
        }
    }

    private void checkSNIsExist4Submit(Context ctx, String serialNumber, String materialID, StringBuffer errorMsg, InvBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        EntityViewInfo cview = new EntityViewInfo();
        FilterInfo cfilter = new FilterInfo();
        cfilter.getFilterItems().add(new FilterItemInfo("serialNumber", (Object)serialNumber, CompareType.EQUALS));
        cfilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID, CompareType.EQUALS));
        cview.setFilter(cfilter);
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("snStatus"));
        MaterialSNInventoryCollection sniColl = MaterialSNInventoryFactory.getLocalInstance(ctx).getMaterialSNInventoryCollection(cview);
        if (sniColl == null || sniColl.size() == 0) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_ISEXIST", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
            return;
        }
        MaterialSNInventoryInfo sniInfo = sniColl.get(0);
        if (sniInfo.getSnStatus() == SerialNumberStatusEnum.INWAREHOUSE || sniInfo.getSnStatus() == SerialNumberStatusEnum.OUTTHENIN) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_INWAREHOUSE", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
            return;
        }
        if (sniInfo.getSnStatus() != SerialNumberStatusEnum.SALE && sniInfo.getSnStatus() != SerialNumberStatusEnum.WAITIN) {
            errorMsg.append(EASResource.getString((String)resFile, (String)"SERIALNUMBER_ISEXIST", (Object[])new Object[]{entryInfo.getSeq(), entryInfo.getMaterial().getName(), serialNumber})).append("\n");
        }
    }

    protected void check4AccountClosed(Context ctx, SCMBillBaseInfo model) throws EASBizException, BOSException {
    }

    protected void check4AccountClosed(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return false;
    }

    private void afterAuditBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo billInfo = (InvBillBaseInfo)model;
        Boolean isRefreshing = RefreshInventoryUtil.isRefreshInventory(ctx, billInfo.getStorageOrgUnit().getId().toString());
        if (isRefreshing.booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
        ObjectUuidPK pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        super.check4AccountClosed(ctx, (SCMBillBaseInfo)billInfo);
        this._checkBizDate(ctx, (IObjectValue)billInfo);
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            this.insertLots(ctx, (IObjectPK)pk, billInfo);
        }
        if (paramMap.get("isCloseSerialNum") == null || !((Boolean)paramMap.get("isCloseSerialNum")).booleanValue()) {
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            try {
                iMaterialSerialNumber.updateMaterialSN(billInfo);
                iMaterialSerialNumber.updateSerialInventory(billInfo);
                iMaterialSerialNumber.checkSerialNumberIsNull(billInfo);
            }
            catch (EASBizException e) {
                String msg = e.getMessage();
                if (msg != null) {
                    if (model instanceof OtherIssueBillInfo) {
                        msg = EASResource.getString((String)res, (String)"BEFORECHANGE_SERIL", (Object[])new Object[]{msg});
                        throw new InvBizException(InvBizException.COMMON, new Object[]{msg});
                    }
                    msg = EASResource.getString((String)res, (String)"AFTERCHANGE_SERIL", (Object[])new Object[]{msg});
                    throw new InvBizException(InvBizException.COMMON, new Object[]{msg});
                }
                throw e;
            }
        }
        this.updateInventory(ctx, (IObjectPK)pk, billInfo, BizActionEnum.AUDIT);
        this.calculate(ctx, billInfo);
    }

    protected void importMaterialSN(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        InvBillBaseEntryInfo aInvBillBaseEntryInfo;
        int i;
        if (aInvBillBaseInfo.get("ImportSN") == null) {
            return;
        }
        Hashtable htSN = (Hashtable)aInvBillBaseInfo.get("ImportSN");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.seq"));
        selector.add(new SelectorItemInfo("entry.lot"));
        selector.add(new SelectorItemInfo("entry.material.id"));
        selector.add(new SelectorItemInfo("entry.unit.id"));
        selector.add(new SelectorItemInfo("entry.storageOrgUnit"));
        selector.add(new SelectorItemInfo("entry.seq"));
        aInvBillBaseInfo = this.getInvBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(aInvBillBaseInfo.getId()), selector);
        IObjectCollection iObjectCollection = (IObjectCollection)aInvBillBaseInfo.get("entry");
        String strBillId = aInvBillBaseInfo.getId().toString();
        String strBillNumber = aInvBillBaseInfo.getNumber();
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        Vector<MaterialSerialNumberInfo> vecSNinfo = new Vector<MaterialSerialNumberInfo>(0);
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        HashSet<String> entryIdSet = new HashSet<String>();
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            entryIdSet.add(aInvBillBaseEntryInfo.getId().toString());
        }
        if (entryIdSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", entryIdSet, CompareType.INCLUDE));
            iMaterialSerialNumber.delete(filterInfo);
        }
        for (i = 0; i < iObjectCollection.size(); ++i) {
            aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(i);
            if (aInvBillBaseEntryInfo.getLot() == null) continue;
            String key = null;
            key = null == aInvBillBaseEntryInfo.getLot() ? aInvBillBaseEntryInfo.getMaterial().getId().toString() : aInvBillBaseEntryInfo.getLot().trim() + aInvBillBaseEntryInfo.getMaterial().getId().toString();
            if (!htSN.containsKey(key)) continue;
            Vector vecSN = (Vector)htSN.get(key);
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = new MaterialSerialNumberInfo();
            aMaterialSerialNumberInfo.setBillID(strBillId);
            aMaterialSerialNumberInfo.setBillType(aBillTypeInfo);
            aMaterialSerialNumberInfo.setBillNumber(strBillNumber);
            aMaterialSerialNumberInfo.setSnUnit(aInvBillBaseEntryInfo.getUnit());
            aMaterialSerialNumberInfo.setStorageOrgUnit(aInvBillBaseEntryInfo.getStorageOrgUnit());
            aMaterialSerialNumberInfo.setBillEntryID(aInvBillBaseEntryInfo.getId().toString());
            aMaterialSerialNumberInfo.setBillEntrySeq(aInvBillBaseEntryInfo.getSeq());
            aMaterialSerialNumberInfo.setMaterial(aInvBillBaseEntryInfo.getMaterial());
            BigDecimal bigQty = new BigDecimal(vecSN.size());
            aMaterialSerialNumberInfo.setSnQty(bigQty);
            aMaterialSerialNumberInfo.setIsReversed(false);
            aMaterialSerialNumberInfo.setSnStatus(SerialNumberStatusEnum.OUTTHENIN);
            for (int j = 0; j < vecSN.size(); ++j) {
                MaterialSerialNumberEntryInfo aMaterialSerialNumberEntry = new MaterialSerialNumberEntryInfo();
                aMaterialSerialNumberEntry.setSerialNumber((String)vecSN.get(j));
                aMaterialSerialNumberInfo.getEntry().add(aMaterialSerialNumberEntry);
            }
            vecSNinfo.add(aMaterialSerialNumberInfo);
        }
        CoreBaseCollection newMsnCol = new CoreBaseCollection();
        for (int i2 = 0; i2 < vecSNinfo.size(); ++i2) {
            MaterialSerialNumberInfo aMaterialSerialNumberInfo = (MaterialSerialNumberInfo)vecSNinfo.get(i2);
            newMsnCol.add((CoreBaseInfo)aMaterialSerialNumberInfo);
        }
        if (newMsnCol.size() > 0) {
            iMaterialSerialNumber.addnewBatchData(newMsnCol);
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("entry.*"));
        sc.add(new SelectorItemInfo("entry.material.*"));
        sc.add(new SelectorItemInfo("entry.entry1.*"));
        sc.add(new SelectorItemInfo("entry.entry1.material.*"));
        MatAttrChangeBillInfo info = this.getMatAttrChangeBillInfo(ctx, pk, sc);
        this.checkUnPassAduit(ctx, info);
        this.updateUnAuditStatus(ctx, (IObjectValue)info);
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        MaterialSerialNumberFactory.getLocalInstance(ctx).updateMaterialSN(info);
        this.unAuditDelOther(ctx, (IObjectValue)info);
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        if (aInvBillBaseInfo.getBaseStatus() != null && aInvBillBaseInfo.getBaseStatus().getValue() != 4) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT, new Object[]{aInvBillBaseInfo.getString("number"), ""});
        }
        this._checkUnAuditInParam(ctx, (IObjectValue)aInvBillBaseInfo);
        if (aInvBillBaseInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        this._checkIsVouchered(ctx, (IObjectValue)aInvBillBaseInfo, true);
        this.isSamePerson4UnAudit(ctx, aInvBillBaseInfo);
        Boolean isRefreshing = RefreshInventoryUtil.isRefreshInventory(ctx, aInvBillBaseInfo.getStorageOrgUnit().getId().toString());
        if (isRefreshing.booleanValue()) {
            throw new InvBizException(InvBizException.REFRESH_CANNOTAUDIT);
        }
    }

    public void unAuditDelOther(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model instanceof MatAttrChangeBillInfo) {
            MatAttrChangeBillInfo billInfo = (MatAttrChangeBillInfo)model;
            IOtherInWarehsBill iInWarehs = OtherInWarehsBillFactory.getLocalInstance(ctx);
            String inWarehsID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERINWAREHSBILL", "T_IM_OTHERINWAREHSBILLENTRY");
            if (!StringUtils.isEmpty((String)inWarehsID)) {
                iInWarehs.innerUnAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
                iInWarehs.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)inWarehsID)));
            }
            IOtherIssueBill iIssue = OtherIssueBillFactory.getLocalInstance(ctx);
            String isSueID = this.getOtherID(ctx, billInfo.getId().toString(), "T_IM_OTHERISSUEBILL", "T_IM_OTHERISSUEBILLENTRY");
            if (!StringUtils.isEmpty((String)isSueID)) {
                iIssue.innerUnAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
                iIssue.deleteNocheck((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)isSueID)));
            }
            if (billInfo.getBizType().getId().toString().equals("kXeVPjHuchDgQKjAYj1RYCQHQ1w=")) {
                this.updateDateOfMinDurability(ctx, ((InvBillBaseInfo)model).getId().toString(), BillBaseStatusEnum.SUBMITED);
            }
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(isSueID);
            idList.add(inWarehsID);
            if (idList != null && idList.size() > 0) {
                this.deleteMaterialSerialByUnAudit(ctx, idList);
            }
        }
    }

    private void deleteMaterialSerialByUnAudit(Context ctx, List idList) throws BOSException {
        if (idList != null && idList.size() > 0) {
            Connection conn = this.getConnection(ctx);
            Statement batchStatment = null;
            try {
                String ids = InvServerUtils.getInStringFromList(idList);
                batchStatment = conn.createStatement();
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_IV_MaterialSerialNumberEntry where fparentid in (select fid from ");
                sql.append("T_IV_MaterialSerialNumber where FBillId in ").append(ids).append(" )");
                batchStatment.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("delete from T_IV_MaterialSerialNumber where fbillid in ").append(ids);
                batchStatment.addBatch(sql.toString());
                batchStatment.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatment, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)batchStatment, (Connection)conn);
        }
    }

    public String getOtherID(Context ctx, String sourceBillID, String billTbl, String billEntryTbl) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT OIS.FID FROM " + billTbl + " OIS, " + billEntryTbl + " OISE ");
        sql.append(" WHERE OIS.FID = OISE.FPARENTID AND OISE.Fsourcebillid = ? ");
        String otherID = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            pstm = conn.prepareStatement(sql.toString());
            pstm.setString(1, sourceBillID);
            rs = pstm.executeQuery();
            if (rs.next()) {
                otherID = rs.getString(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstm, (Connection)conn);
        return otherID;
    }

    public void checkOtherBill(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        this._checkIsHaveDestBills(ctx, aInvBillBaseInfo);
    }

    @Override
    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return super._checkDeleted(ctx, model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _revoke(Context ctx, String id) throws BOSException, EASBizException {
        Connection conn = this.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_MatAttrChangeBill SET FBaseStatus = 3 WHERE FID = ? ");
        PreparedStatement pstm = null;
        try {
            pstm = conn.prepareStatement(sql.toString());
            pstm.setString(1, id);
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)pstm, (Connection)conn);
        }
    }

    private void updateDateOfMinDurability(Context ctx, String id, BillBaseStatusEnum status) throws BOSException, EASBizException {
        String rt = " \r\n";
        StringBuffer strSQL = new StringBuffer();
        if (paramMap.size() == 0) {
            IDtTempFacade fcd = DtTempFacadeFactory.getLocalInstance(ctx);
            String[] keys = new String[]{"isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate"};
            paramMap = fcd.getDtTempParams(keys);
        }
        if (status.getValue() == 4) {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatAttrChangeAfterEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in(select entry.FID from T_IM_MatAttrChangeBeforeEntry entry, T_IM_MatAttrChangeBill bill  ").append(rt);
            strSQL.append(" where entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" and entry.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID, max(entry.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatAttrChangeBeforeEntry entry inner join T_IM_MatAttrChangeBill bill  ").append(rt);
            strSQL.append(" on entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID) a ").append(rt);
            strSQL.append(" ) )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        } else {
            strSQL.append(" update T_IM_DateOfMinDurability as t1 set (FMfg,FExp)= (").append(rt);
            strSQL.append(" select FMfg,FExp from T_IM_MatAttrChangeBeforeEntry t2 where  ").append(rt);
            strSQL.append(" t2.FLot is not null and t2.FParentID ").append(rt);
            strSQL.append(" in (select bill.FID from T_IM_MatAttrChangeBill bill  ").append(rt);
            strSQL.append(" where bill.FID='" + id + "'").append(rt);
            strSQL.append(" ) and t2.FSeq in ( ").append(rt);
            strSQL.append(" select FSeq from(select entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID, max(entry.FSeq) FSeq  ").append(rt);
            strSQL.append(" from T_IM_MatAttrChangeBeforeEntry entry inner join T_IM_MatAttrChangeBill bill  ").append(rt);
            strSQL.append(" on entry.FParentID=bill.FID and bill.FID='" + id + "'").append(rt);
            strSQL.append(" group by entry.FStorageOrgUnitID,entry.FLot,entry.FMaterialID) a ").append(rt);
            strSQL.append(" )  ").append(rt);
            strSQL.append(" and t1.FStorageOrgUnitID=t2.FStorageOrgUnitID and ").append(rt);
            strSQL.append(" t1.FMaterialID=t2.FMaterialID and t1.FLot=t2.FLot) ").append(rt);
        }
        if (paramMap.get("isCloseInsertLot") == null || !((Boolean)paramMap.get("isCloseInsertLot")).booleanValue()) {
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
        }
    }

    private void sysOutEntryActualCost(Context ctx, String issueBillID, String inWarehsBillID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entry.id"));
        selector.add(new SelectorItemInfo("entry.qty"));
        selector.add(new SelectorItemInfo("entry.unitActualCost"));
        selector.add(new SelectorItemInfo("entry.actualCost"));
        selector.add(new SelectorItemInfo("entry.sourceBillEntryID"));
        selector.add(new SelectorItemInfo("entry.material.pricePrecision"));
        selector.add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        HashMap<String, MatCostObject> matCostObjMap = new HashMap<String, MatCostObject>();
        OtherIssueBillInfo issueBill = OtherIssueBillFactory.getLocalInstance(ctx).getOtherIssueBillInfo((IObjectPK)new ObjectUuidPK(issueBillID), selector);
        for (int i = 0; i < issueBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, issueBill.getEntry().get(i), true);
        }
        OtherInWarehsBillInfo inWarehsBill = OtherInWarehsBillFactory.getLocalInstance(ctx).getOtherInWarehsBillInfo((IObjectPK)new ObjectUuidPK(inWarehsBillID), selector);
        for (int i = 0; i < inWarehsBill.getEntry().size(); ++i) {
            this.buildMatCostObjectMap(ctx, matCostObjMap, inWarehsBill.getEntry().get(i), false);
        }
        Iterator<MatCostObject> it = matCostObjMap.values().iterator();
        MatCostObject obj = null;
        while (it.hasNext()) {
            obj = it.next();
            if (!obj.isNeedSyncCost()) continue;
            obj.calculateCost();
            obj.updateInWarehsEntryCost(ctx);
        }
    }

    protected void buildMatCostObjectMap(Context ctx, HashMap<String, MatCostObject> matCostObjMap, InvBillBaseEntryInfo entry, boolean isIssueEntry) {
        String sourceEntryID = entry.getSourceBillEntryId();
        MatCostObject vo = matCostObjMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatCostObject(ctx, sourceEntryID);
        }
        if (isIssueEntry) {
            vo.addIssueEntry(entry);
        } else {
            vo.addInWarehsEntry(entry);
        }
        matCostObjMap.put(sourceEntryID, vo);
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initBotpData(ctx, model);
        MatAttrChangeBeforeEntryInfo beforeEntry = null;
        MatAttrChangeAfterEntryInfo afterEntry = null;
        MatAttrChangeBillInfo info = (MatAttrChangeBillInfo)model;
        MatAttrChangeBeforeEntryCollection beforeColl = info.getEntry();
        MatAttrChangeAfterEntryCollection afterColl = null;
        BigDecimal assistQty = null;
        if (beforeColl != null && beforeColl.size() > 0) {
            for (int i = 0; i < beforeColl.size(); ++i) {
                beforeEntry = (MatAttrChangeBeforeEntryInfo)beforeColl.getObject(i);
                if (beforeEntry == null || (afterColl = beforeEntry.getEntry1()) == null || afterColl.size() <= 0) continue;
                for (int j = 0; j < afterColl.size(); ++j) {
                    afterEntry = afterColl.get(j);
                    if (afterEntry.getAssistUnit() == null || afterEntry.getAssistQty() != null) continue;
                    assistQty = InvAppUtils.getMultiUnitQty(ctx, afterEntry.getUnit(), afterEntry.getAssistUnit(), afterEntry.getMaterial(), afterEntry.getQty());
                    afterEntry.setAssistQty(assistQty);
                }
            }
        }
    }

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    class MatCostObject {
        Context ctx;
        String sourceBillEntryID;
        List<InvBillBaseEntryInfo> issueList;
        List<InvBillBaseEntryInfo> inWarehsList;

        public MatCostObject(Context ctx, String sourceBillEntryID) {
            this.ctx = ctx;
            this.sourceBillEntryID = sourceBillEntryID;
            this.issueList = new ArrayList<InvBillBaseEntryInfo>();
            this.inWarehsList = new ArrayList<InvBillBaseEntryInfo>();
        }

        public void addIssueEntry(InvBillBaseEntryInfo entry) {
            this.issueList.add(entry);
        }

        public void addInWarehsEntry(InvBillBaseEntryInfo entry) {
            this.inWarehsList.add(entry);
        }

        public boolean isNeedSyncCost() throws BOSException {
            if (this.issueList.size() <= 0) {
                return false;
            }
            String materialId = this.issueList.get(0).getMaterial().getId().toString();
            String couID = this.issueList.get(0).getCompanyOrgUnit().getId().toString();
            MaterialCompanyInfoInfo matComInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, couID);
            return matComInfo != null && AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType());
        }

        public void calculateCost() {
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            InvBillBaseEntryInfo entry = null;
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                entry = this.inWarehsList.get(i);
                recentCost = totalCost.multiply(entry.getQty().divide(totalQty, 8, 4)).setScale(entry.getCompanyOrgUnit().getBaseCurrency().getPrecision(), 4);
                if (i == this.inWarehsList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                entry.setActualCost(recentCost);
                entry.setUnitActualCost(entry.getActualCost().divide(entry.getQty(), entry.getMaterial().getPricePrecision(), 4));
                entry.setBoolean("isNeedUpdate", true);
                dealCost = dealCost.add(entry.getActualCost());
            }
        }

        public void updateInWarehsEntryCost(Context ctx) throws BOSException {
            String updateSQL = "update t_im_otherinwarehsbillentry set FUnitActualCost = ?, FActualCost = ? where fid = ?";
            Connection conn = null;
            PreparedStatement ps = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(updateSQL);
                InvBillBaseEntryInfo entry = null;
                for (int i = 0; i < this.inWarehsList.size(); ++i) {
                    entry = this.inWarehsList.get(i);
                    ps.setBigDecimal(1, entry.getUnitActualCost());
                    ps.setBigDecimal(2, entry.getActualCost());
                    ps.setString(3, entry.getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.issueList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.issueList.get(i);
                result = result.add(entry.getActualCost());
            }
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.inWarehsList.size(); ++i) {
                InvBillBaseEntryInfo entry = this.inWarehsList.get(i);
                result = result.add(entry.getQty());
            }
            return result;
        }
    }
}

