/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialInventoryForWarnControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class MaterialInventoryForWarnControllerBean
extends AbstractMaterialInventoryForWarnControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MaterialInventoryForWarnControllerBean");

    @Override
    protected void _inSertTableValues(Context ctx) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        String tempTable = null;
        ResultSet rs = null;
        try {
            tempTable = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("materialInvTempTable");
            String createTempTable = this.creatTempTable(tempTable);
            ITableManagerFacade manager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            manager.createTempTable(createTempTable);
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            String realMaterInvString = this.inSertTempData(tempTable);
            stmt.execute(realMaterInvString);
            String getMaxLevelString = "select max(FLevel) as maxLevel from t_org_storage";
            rs = stmt.executeQuery(getMaxLevelString);
            int maxLevel = 1;
            while (rs.next()) {
                maxLevel = rs.getInt("maxLevel");
            }
            String cycleMaterialInvString = null;
            for (int index = maxLevel; index > 1; --index) {
                cycleMaterialInvString = this.inSertCycleMaterialInventoryData(index, tempTable);
                stmt.execute(cycleMaterialInvString);
            }
            String realDataString = this.insertDataToRealTable(tempTable);
            String deleteData = "delete  from T_IM_MaterialInvForWarn";
            stmt.execute(deleteData);
            stmt.execute(realDataString);
            String updateQty = "Update T_IM_MaterialInvForWarn set FTotalBAseQty = 0 where FTotalBAseQty is null ";
            stmt.execute(updateQty);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private String creatTempTable(String tempTableName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE  ");
        stringBuffer.append(tempTableName);
        stringBuffer.append("(FID VARCHAR(44) NOT NULL ,");
        stringBuffer.append("FTotalBAseQty NUMERIC(28,16) DEFAULT 0,");
        stringBuffer.append("FMaterialID VARCHAR(44),");
        stringBuffer.append("FStorageOrgUnitID VARCHAR(44),");
        stringBuffer.append("FLevel INT DEFAULT 0,");
        stringBuffer.append("FParentStorageOrgUnitID VARCHAR(44));");
        return stringBuffer.toString();
    }

    private String inSertTempData(String tempTableName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(tempTableName);
        stringBuffer.append("(FID, ");
        stringBuffer.append("FTotalBAseQty, ");
        stringBuffer.append("FMaterialID, ");
        stringBuffer.append("FStorageOrgUnitID, ");
        stringBuffer.append("FLevel, ");
        stringBuffer.append("FParentStorageOrgUnitID) ");
        stringBuffer.append(" SELECT ");
        stringBuffer.append(" NEWBOSID('C3179CB8'), ");
        stringBuffer.append(" tempInventory.FTotalBaseQty, ");
        stringBuffer.append(" tempInventory.FMaterialID, ");
        stringBuffer.append(" tempInventory.FStorageOrgUnitID, ");
        stringBuffer.append(" storage.FLevel, ");
        stringBuffer.append(" storage.FParentID ");
        stringBuffer.append(" from ( ");
        stringBuffer.append(" select sum(FBaseQty) AS FTotalBaseQty, FMaterialID, FStorageOrgUnitID ");
        stringBuffer.append(" from T_IM_Inventory group by FMaterialID, FStorageOrgUnitID ");
        stringBuffer.append(") tempInventory ");
        stringBuffer.append(" inner join T_Org_Storage storage");
        stringBuffer.append(" on tempInventory.FStorageOrgUnitID = storage.FID");
        return stringBuffer.toString();
    }

    private String inSertCycleMaterialInventoryData(int level, String tempTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(tempTable);
        stringBuffer.append("(FID, ");
        stringBuffer.append("FTotalBAseQty, ");
        stringBuffer.append("FMaterialID, ");
        stringBuffer.append("FStorageOrgUnitID, ");
        stringBuffer.append("FLevel, ");
        stringBuffer.append("FParentStorageOrgUnitID) ");
        stringBuffer.append(" SELECT ");
        stringBuffer.append(" NEWBOSID('C3179CB8'), ");
        stringBuffer.append(" tempInventory.FTotalBAseQty,");
        stringBuffer.append(" tempInventory.FMaterialID, ");
        stringBuffer.append(" tempInventory.FParentStorageOrgUnitID,  ");
        stringBuffer.append(" storage.FLevel,  ");
        stringBuffer.append(" storage.FParentID  ");
        stringBuffer.append(" from (");
        stringBuffer.append(" select sum(FTotalBAseQty) AS FTotalBAseQty ,FMaterialID,FParentStorageOrgUnitID");
        stringBuffer.append(" from ");
        stringBuffer.append(tempTable);
        stringBuffer.append(" where Flevel = " + level + " ");
        stringBuffer.append(" group by FMaterialID,FParentStorageOrgUnitID )");
        stringBuffer.append(" tempInventory");
        stringBuffer.append(" inner join T_Org_Storage storage");
        stringBuffer.append(" on tempInventory.FParentStorageOrgUnitID = storage.FID");
        return stringBuffer.toString();
    }

    private String insertDataToRealTable(String tempTable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO T_IM_MaterialInvForWarn");
        stringBuffer.append("(FID, ");
        stringBuffer.append("FTotalBAseQty, ");
        stringBuffer.append("FQtyMin, ");
        stringBuffer.append("FQtyMax, ");
        stringBuffer.append("FQtySafety, ");
        stringBuffer.append("FBaseConvsRate, ");
        stringBuffer.append("FInvPlannerUserID, ");
        stringBuffer.append("FMaterialID, ");
        stringBuffer.append("FStorageOrgUnitID ) ");
        stringBuffer.append(" SELECT ");
        stringBuffer.append(" NEWBOSID('C3179CB8'), ");
        stringBuffer.append(tempTable + ".FTotalBAseQty, ");
        stringBuffer.append(" tempMI.FQtyMin,");
        stringBuffer.append(" tempMI.FQtyMax,");
        stringBuffer.append(" tempMI.FQtySafety,");
        stringBuffer.append(" measureTable.FBaseConvsRate,");
        stringBuffer.append(" invPlanner.FID,");
        stringBuffer.append(" tempMI.FMaterialID,");
        stringBuffer.append(" tempMI.FOrgUnit");
        stringBuffer.append(" from (\u3000");
        stringBuffer.append(" select FMaterialID, FOrgUnit, FQtyMin, FQtyMax, FQtySafety, FUnitID, FInvPlanner");
        stringBuffer.append(" from T_BD_MaterialInventory");
        stringBuffer.append(" where FInvPlanner is not null and ( FQtyMin is not null or FQtySafety is not null or FQtyMax is not null)  ");
        stringBuffer.append(" ) tempMI");
        stringBuffer.append(" left join " + tempTable);
        stringBuffer.append(" on  tempMI.FMaterialID = " + tempTable + ".FMaterialID");
        stringBuffer.append(" and  tempMI.FOrgUnit = " + tempTable + ".FStorageOrgUnitID");
        stringBuffer.append(" inner join T_BD_MultiMeasureUnit measureTable");
        stringBuffer.append(" on tempMI.FMaterialID = measureTable.FMaterialID");
        stringBuffer.append(" and tempMI.FUnitID = measureTable.FMeasureUnitID");
        stringBuffer.append(" left outer join T_PM_User invPlanner");
        stringBuffer.append(" on tempMI.FInvPlanner = invPlanner.FPersonId");
        stringBuffer.append(" where invPlanner.FID is not null");
        return stringBuffer.toString();
    }
}

