/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CostObjectSuiteInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ClassGroupCollection;
import com.kingdee.eas.mm.basedata.ClassGroupFactory;
import com.kingdee.eas.mm.basedata.ClassGroupInfo;
import com.kingdee.eas.mm.basedata.IClassGroup;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.PLWPStatusEnum;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryFactory;
import com.kingdee.eas.mm.basedata.ProductLineWPEntryInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;

public class MaterialReqImport
extends InvDataImport {
    MaterialReqBillInfo materialReqBillInfo = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private static String invResouces = "com.kingdee.eas.scm.im.inv.InvBillDataImportResource";
    private boolean IsHaveValue = false;
    private boolean IsError = false;
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    private static final String SPLIT_KEY = "$";
    StorageOrgUnitInfo sou = null;
    TransactionTypeInfo tti = null;
    CompanyOrgUnitInfo cou = null;
    String[] STRING_FIELDS = new String[]{"FNumber", "FTransactionType_number", "FStorageOrgUnit_number", "FCostCenterOrgUnit_number", "FAdminOrgUnit_number", "FEntry$material_number", "FEntry$assistProperty_number", "FEntry$material_model", "FEntry$costObject_number", "FEntry$costItem_number", "FEntry$unit_number", "FEntry$assistUnit_number", "FEntry$Warehouse_number", "FEntry$stocker_number", "FEntry$picker_number", "FEntry$Location_number", "FEntry_OrderNumber", "FEntry_remark", "FEntry$project_number", "FEntry$trackNumber_number", "FDescription"};
    String[] DATE_FIELDS = new String[]{"FBizDate", "FEntry_mfg", "FEntry_exp"};
    String[] STRING_FIELDS_EN = new String[]{"FTransactionType_name_l2", "FStorageOrgUnit_name_l2", "FEntry$material_name_l2", "FEntry$costObject_name_l2", "FEntry$costObjectSuite_name_l2", "FEntry$costItem_name_l2"};
    String[] BIGDECIMAL_FIELDS = new String[]{"FEntry_qty", "FEntry_unitStandardCost", "FEntry_unitActualCost"};
    String[] INTEGER_FIELDS = new String[]{"FEntry_lot"};
    private static final String[] QTY_PROPERTY = new String[]{"qty"};
    private static final String[] ASSISTQTY_PROPERTY = new String[]{"assistQty"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL = new String[]{"FEntry_qty", "FEntry_assistQty", "FEntry_unitActualCost", "FEntry_actualCost", "FEntry$SettlePrice"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL_KEY = new String[]{"qty", "assistQty", "unitActualCost", "actualCost", "settleprice"};
    private static final String[] ENTRY_QTY_AMOUNT_FIELDS = new String[]{"qty", "settleprice", "assistQty", "baseQty", "reverseQty", "reverseBaseQty", "returnsQty", "returnBaseQty", "amount", "actualCost", "standardCost", "issueQty", "baseIssueQty"};
    private static final String[] ENTRY_PRICE_FIELDS = new String[]{"price", "unitActualCost", "unitStandardCost", "settleprice"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialReqBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.materialReqBillInfo = null;
        int k = 0;
        MaterialReqBillEntryInfo entryinfo = null;
        MaterialReqBillPriceInfoEntryInfo priceinfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            block8: {
                Map lineData = (Map)hsData.get(new Integer(i));
                if (k == 0) {
                    try {
                        this.materialReqBillInfo = this.transmitHead(lineData, ctx);
                        if (this.materialReqBillInfo == null) {
                            return null;
                        }
                        this.afterBuildHead(ctx, this.materialReqBillInfo, lineData);
                    }
                    catch (TaskExternalException e) {
                        tex.addEntryErrorReason(i, e.getMessage());
                        this.recycleNumber(ctx, this.materialReqBillInfo);
                        break;
                    }
                }
                try {
                    entryinfo = this.transmitEntry(lineData, ctx);
                    int seq = this.materialReqBillInfo.getEntry().size() + 1;
                    entryinfo.setSeq(seq);
                    entryinfo.setParent(this.materialReqBillInfo);
                    entryinfo.setStorageOrgUnit(this.sou);
                    entryinfo.setId(BOSUuid.create((String)"11774BB4"));
                    entryinfo.setCompanyOrgUnit(this.cou);
                    this.afterBuildEntry(ctx, this.materialReqBillInfo, entryinfo, lineData);
                    priceinfo = this.getPriceEntry(this.materialReqBillInfo, entryinfo);
                    this.materialReqBillInfo.getEntry().add(entryinfo);
                    this.materialReqBillInfo.getPriceInfo().add(priceinfo);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    if (tex.getEntryErrorReasons().size() != 1) break block8;
                    this.recycleNumber(ctx, this.materialReqBillInfo);
                }
            }
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.materialReqBillInfo;
    }

    private MaterialReqBillPriceInfoEntryInfo getPriceEntry(MaterialReqBillInfo materialReqBillInfo, MaterialReqBillEntryInfo entryinfo) {
        MaterialReqBillPriceInfoEntryInfo priceinfo = new MaterialReqBillPriceInfoEntryInfo();
        priceinfo.setParent(materialReqBillInfo);
        priceinfo.setMaterialReqEntryID(entryinfo.getId().toString());
        priceinfo.setMaterial(entryinfo.getMaterial());
        priceinfo.setUnit(entryinfo.getUnit());
        priceinfo.setBaseUnit(entryinfo.getBaseUnit());
        priceinfo.setPrice(BigDecimal.ZERO);
        priceinfo.setDiscountType(DiscountModeEnum.PERCENT);
        priceinfo.setRealPrice(BigDecimal.ZERO);
        priceinfo.setTaxRate(BigDecimal.ZERO);
        priceinfo.setRealTaxPrice(BigDecimal.ZERO);
        priceinfo.setAssistProperty(entryinfo.getAssistProperty());
        priceinfo.setSeq(entryinfo.getSeq());
        return priceinfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private MaterialReqBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        StorageOrgUnitInfo supplySou;
        this.materialReqBillInfo = new MaterialReqBillInfo();
        Object data = null;
        Object str = null;
        this.materialReqBillInfo.setId(BOSUuid.create((String)"500AB75E"));
        Object description = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (description != null && description.toString().trim().length() > 0) {
            String DeTemp = (String)description;
            if (DeTemp.length() > 80) {
                DeTemp = DeTemp.substring(0, 80);
            }
            this.materialReqBillInfo.setDescription(DeTemp);
        } else {
            this.materialReqBillInfo.setDescription("");
        }
        try {
            this.loadStorageOrgUnit(lineData, ctx, "number", "FStorageOrgUnit_number");
        }
        catch (Exception e_number) {
            try {
                this.loadStorageOrgUnit(lineData, ctx, "name", "FStorageOrgUnit_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        DataToken temp = (DataToken)lineData.get("FSupplyStoreOrgUnit_number");
        if (null != temp && !StringUtils.isEmpty((String)temp.data.toString())) {
            String supplySouNumber = temp.data.toString();
            supplySou = null;
            try {
                supplySou = this.getStorageOrgUnitByPropertyValue(ctx, "number", supplySouNumber);
            }
            catch (Exception e) {
                temp = (DataToken)lineData.get("FStorageOrgUnit_name_l2");
                String supplySouName = temp.data.toString();
                try {
                    supplySou = this.getStorageOrgUnitByPropertyValue(ctx, "name", supplySouName);
                }
                catch (BOSException e1) {
                    throw new TaskExternalException(e1.getMessage(), e1.getCause());
                }
            }
            if (supplySou == null) {
                throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"supply_storageOrgUnit_isNull", (String)resources));
            }
        } else {
            throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"supply_storageOrgUnit_isNull", (String)resources));
        }
        this.materialReqBillInfo.setSupplyStoreOrgUnit(supplySou);
        if (this.materialReqBillInfo.getSupplyStoreOrgUnit() != null) {
            try {
                CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgFromStorageOrg(ctx, this.materialReqBillInfo.getSupplyStoreOrgUnit());
                this.materialReqBillInfo.setSupplyCompanyOrgUnit(companyOrgUnitInfo);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        try {
            this.loadBizType(lineData, ctx, "number", "FBizType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadBizType(lineData, ctx, "name", "FBizType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadTransaction(lineData, ctx, "number", "FTransactionType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadTransaction(lineData, ctx, "name", "FTransactionType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        if (this.materialReqBillInfo.getTransactionType() != null && this.materialReqBillInfo.getBizType() != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(this.materialReqBillInfo.getBizType().getId().toString())) {
            throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"JUMP_COMPANY_CANNOT_IMPORT", (String)resources));
        }
        this.materialReqBillInfo.setCU(this.sou.getCU());
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        try {
            Date da = ImRptAppUtils.formatNationalDate(ctx, lineData.get("FBizDate").toString());
            this.materialReqBillInfo.setBizDate(da);
        }
        catch (Exception e1) {
            throw new TaskExternalException(lineData.get("FBizDate").toString() + MaterialReqImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)resources));
        }
        if (this.materialReqBillInfo.getBizDate() == null) {
            throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"bizDateCanNotBeNull", (String)resources));
        }
        this.materialReqBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.IsHaveValue = false;
        this.IsError = false;
        data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        UserInfo creator = this.getCreator(ctx, data);
        this.materialReqBillInfo.setCreator(creator);
        this.materialReqBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
        aBillTypeInfo.setNumber("104");
        this.materialReqBillInfo.setBillType(aBillTypeInfo);
        data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo adminOrgUnit = this.getAdminOrgUnit(ctx, "number", data);
        this.materialReqBillInfo.setAdminOrgUnit(adminOrgUnit);
        temp = (DataToken)lineData.get("FSupplier_number");
        if (null != temp) {
            SupplierInfo supplierInfo;
            String supplierNumber = temp.data.toString();
            try {
                supplierInfo = this.getSupplier(ctx, "number", supplierNumber);
            }
            catch (Exception e) {
                temp = (DataToken)lineData.get("FSupplier_name_l2");
                String supplierName = temp.data.toString();
                try {
                    supplierInfo = this.getSupplier(ctx, "name", supplierName);
                }
                catch (Exception e1) {
                    throw new TaskExternalException(e1.getMessage(), e1.getCause());
                }
            }
            this.materialReqBillInfo.setSupplier(supplierInfo);
        }
        if (ctx.get((Object)"isSubContractBill") != null && ctx.get((Object)"isSubContractBill").toString().equals("true")) {
            this.materialReqBillInfo.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
        } else {
            this.materialReqBillInfo.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        }
        return this.materialReqBillInfo;
    }

    private MaterialReqBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        String str;
        Object data;
        MaterialReqBillEntryInfo entryInfo;
        block99: {
            ProjectCollection coll;
            ObjectUuidPK cuPK;
            CtrlUnitInfo cu;
            FilterInfo filter2;
            FilterInfo filter;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            String number;
            block98: {
                Object remarkObj;
                Object orderObj;
                WarehouseInfo warehouseInfo;
                MaterialCompanyInfoInfo materialCompanyInfo;
                MeasureUnitInfo mui;
                MaterialInfo materialInfo;
                block97: {
                    IClassGroup iw;
                    block96: {
                        block95: {
                            MaterialInventoryInfo materialInventory;
                            block94: {
                                entryInfo = new MaterialReqBillEntryInfo();
                                data = null;
                                str = "";
                                materialInfo = new MaterialInfo();
                                mui = new MeasureUnitInfo();
                                materialCompanyInfo = null;
                                materialInventory = null;
                                try {
                                    data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
                                    if (data != null && data.toString().length() > 0) {
                                        if (data == null || data.toString().trim().length() <= 0) break block94;
                                        IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                                        MaterialCollection collection = imaterial.getMaterialCollection(this.getFilter(data.toString()));
                                        if (collection != null && collection.size() > 0) {
                                            materialInfo = collection.get(0);
                                            if (materialInfo != null) {
                                                entryInfo.setMaterial(materialInfo);
                                                materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), this.sou.getId().toString());
                                                if (materialInventory == null) {
                                                    throw new TaskExternalException(materialInfo.getNumber() + " " + this.sou.getNumber() + " " + MaterialReqImport.getResource((Context)ctx, (String)"NO_INVENTORY_PROPERTY", (String)resources));
                                                }
                                                materialCompanyInfo = imaterial.getCompanyInfo(materialInfo.getId().toString(), this.cou.getId().toString());
                                                if (materialCompanyInfo == null) {
                                                    throw new TaskExternalException(materialInfo.getNumber() + " " + this.cou.getNumber() + " " + MaterialReqImport.getResource((Context)ctx, (String)"NO_COMPANY_PROPERTY", (String)resources));
                                                }
                                                break block94;
                                            }
                                            throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                                        }
                                        throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                                    }
                                    throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                                }
                                catch (Exception ex) {
                                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                                }
                            }
                            try {
                                data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
                                boolean flag = this.checkLotInfo(ctx, materialInfo, data, this.sou, entryInfo);
                                if (data == null || data.toString() == null || data.toString().trim().length() == 0 || !flag) {
                                    entryInfo.setLot(null);
                                } else {
                                    entryInfo.setLot(data.toString().trim());
                                }
                                if (data == null || data.toString() == null || data.toString().trim().length() == 0) {
                                    entryInfo.setLot(null);
                                } else {
                                    entryInfo.setLot(data.toString().trim());
                                }
                            }
                            catch (Exception ex) {
                                throw new TaskExternalException(ex.getMessage(), ex.getCause());
                            }
                            String mid = entryInfo.getMaterial().getId().toString();
                            if (materialInventory.isIsPeriodValid()) {
                                String lot = ((DataToken)lineData.get((Object)"FEntry_lot")).data.toString();
                                EntityViewInfo view = new EntityViewInfo();
                                FilterInfo filterInfo = new FilterInfo();
                                filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                                filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
                                filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
                                view.setFilter(filterInfo);
                                DateOfMinDurabilityCollection dateCol = null;
                                try {
                                    dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
                                }
                                catch (BOSException e) {
                                    ExceptionHandler.handle((Throwable)e);
                                }
                                if (dateCol != null && dateCol.size() > 0) {
                                    DateOfMinDurabilityInfo dateInfo = dateCol.get(0);
                                    entryInfo.setMfg(dateInfo.getMfg());
                                    entryInfo.setExp(dateInfo.getExp());
                                } else {
                                    String[] DATE_ENTRY_PROPERTY = new String[]{"FEntry_mfg", "FEntry_exp"};
                                    for (int i = 0; i < DATE_ENTRY_PROPERTY.length; ++i) {
                                        Date value;
                                        Object o = ((DataToken)lineData.get((Object)DATE_ENTRY_PROPERTY[i])).data;
                                        if (o == null || o.toString().length() <= 0 || (o = ImRptAppUtils.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value = (Date)o) == null || !materialInventory.isIsPeriodValid()) continue;
                                        if (i == 0) {
                                            entryInfo.setMfg(value);
                                            continue;
                                        }
                                        entryInfo.setExp(value);
                                    }
                                }
                                if (entryInfo.getExp() == null || entryInfo.getMfg() == null) {
                                    throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"IsPeriodValidNoExpandMfg", (String)resources));
                                }
                            }
                            try {
                                data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
                                if (data == null) {
                                    throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"UnitCanNotBeNull", (String)resources));
                                }
                                str = data.toString();
                                MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, str, materialInfo);
                                this.checkUnit(ctx, materialInfo, measureUnitInfo);
                                entryInfo.setUnit(measureUnitInfo);
                                mui = measureUnitInfo;
                            }
                            catch (Exception ex) {
                                throw new TaskExternalException(ex.getMessage(), ex.getCause());
                            }
                            try {
                                MultiMeasureUnitInfo assistMmu;
                                entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                                if (entryInfo.getAssistUnit() != null && (assistMmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), entryInfo.getAssistUnit().getId().toString())) != null) {
                                    String[] ASSISTQTY_PROPERTY = new String[]{"FEntry_assistQty"};
                                    int assistQtyPrecision = assistMmu.getQtyPrecision();
                                    for (int i = 0; i < ASSISTQTY_PROPERTY.length; ++i) {
                                        if (entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i]) == null) continue;
                                        entryInfo.setBigDecimal(ASSISTQTY_PROPERTY[i], entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i]).setScale(assistQtyPrecision, 4));
                                    }
                                    if (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(ZERO) == 0) {
                                        BigDecimal qty = entryInfo.getQty();
                                        BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty(ctx, mui, entryInfo.getAssistUnit(), materialInfo, qty);
                                        entryInfo.setAssistQty(assisqtyQty);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                throw new TaskExternalException(ex.getMessage(), ex.getCause());
                            }
                            this.checkNumberAndAmount(entryInfo, ctx, lineData, DECIMAL_ENTRY_PROPERTY_ALL, DECIMAL_ENTRY_PROPERTY_ALL_KEY, true);
                            try {
                                String number2;
                                data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
                                this.checkMaterialInfo(ctx, materialInfo, data, 3);
                                if (data == null || (number2 = data.toString()) == null || number2.trim().length() <= 0 || materialInfo == null || materialInfo.getAssistAttr() == null) break block95;
                                IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                                String oql = "";
                                oql = "select id,number,name where number='" + number2 + "' and (compondingType.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "' or basictype.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "')";
                                AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(oql);
                                if (collection != null && collection.size() > 0) {
                                    AsstAttrValueInfo info = collection.get(0);
                                    if (info != null) {
                                        entryInfo.setAssistProperty(info);
                                    }
                                    break block95;
                                }
                                throw new TaskExternalException(number2 + MaterialReqImport.getResource((Context)ctx, (String)"AsstAttrValueExists", (String)resources));
                            }
                            catch (BOSException e) {
                                throw new TaskExternalException(e.getMessage(), e.getCause());
                            }
                        }
                        if (entryInfo.getAssistUnit() != null) {
                            entryInfo.setAssistQty((BigDecimal)entryInfo.get("assistQty"));
                        } else {
                            entryInfo.setAssistQty(ZERO);
                        }
                        data = ((DataToken)lineData.get((Object)"FEntry$costObject_number")).data;
                        if (data != null) {
                            CostObjectInfo costObject = this.getCostObject(ctx, this.cou, data);
                            entryInfo.setCostObject(costObject);
                        }
                        if ((data = ((DataToken)lineData.get((Object)"FEntry$costObjectSuite_number")).data) != null) {
                            CostObjectSuiteInfo costObjectSuite = this.getCostObjectSuite(ctx, data);
                            entryInfo.setCostObjectSuite(costObjectSuite);
                        }
                        data = ((DataToken)lineData.get((Object)"FEntry$costItem_number")).data;
                        CostItemInfo costItem = this.getCostItem(ctx, data);
                        entryInfo.setCostItem(costItem);
                        data = ((DataToken)lineData.get((Object)"FEntry$ProductLine_number")).data;
                        if (data != null && data.toString() != null && data.toString().length() > 0) {
                            ProductLineInfo productLine = this.getProductLineByNumberAndCheck(ctx, data.toString(), resources);
                            entryInfo.setProductLine(productLine);
                        }
                        data = ((DataToken)lineData.get((Object)"FEntry$ClassGroup_number")).data;
                        try {
                            if (data == null || data.toString() == null || data.toString().length() <= 0 || (str = data.toString()) == null) break block96;
                            iw = ClassGroupFactory.getLocalInstance((Context)ctx);
                            ClassGroupCollection collectionClassGroup = iw.getClassGroupCollection(this.getFilter(str));
                            if (collectionClassGroup != null && collectionClassGroup.size() > 0) {
                                ClassGroupInfo info = collectionClassGroup.get(0);
                                if (info != null) {
                                    if (!info.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
                                        throw new TaskExternalException(info.getNumber() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ClassGroupNotActive", (String)resources));
                                    }
                                    entryInfo.setClassGroup(info);
                                    break block96;
                                }
                                throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ClassGroupNotExists", (String)resources));
                            }
                            throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ClassGroupNotExists", (String)resources));
                        }
                        catch (Exception e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                    }
                    data = ((DataToken)lineData.get((Object)"FEntry$ProductLineWPEntry_number")).data;
                    try {
                        if (data == null || data.toString() == null || data.toString().length() <= 0 || (str = data.toString()) == null) break block97;
                        iw = ProductLineWPEntryFactory.getLocalInstance((Context)ctx);
                        ProductLineWPEntryCollection collectionProductLineWP = iw.getProductLineWPEntryCollection(this.getFilter(str));
                        if (collectionProductLineWP != null && collectionProductLineWP.size() > 0) {
                            ProductLineWPEntryInfo info = collectionProductLineWP.get(0);
                            if (info != null) {
                                if (!info.getStatus().equals((Object)PLWPStatusEnum.EFFECTED)) {
                                    throw new TaskExternalException(info.getNumber() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ProductLineWPEntryNotActive", (String)resources));
                                }
                                entryInfo.setProductLineWP(info);
                                break block97;
                            }
                            throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ProductLineWPEntryNotExists", (String)resources));
                        }
                        throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"ProductLineWPEntryNotExists", (String)resources));
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                try {
                    data = ((DataToken)lineData.get((Object)"FEntry$Warehouse_number")).data;
                    warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data);
                    entryInfo.setWarehouse(warehouseInfo);
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
                try {
                    data = ((DataToken)lineData.get((Object)"FEntry$Location_number")).data;
                    LocationInfo location = this.getLocation(ctx, data, warehouseInfo);
                    entryInfo.setLocation(location);
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
                if (!PurchaseTypeEnum.SUBCONTRACT.equals((Object)this.materialReqBillInfo.getPurchaseType())) {
                    WarehouseInfo supplyWarehouseInfo;
                    try {
                        data = ((DataToken)lineData.get((Object)"FEntry$SupplyWarehouse_number")).data;
                        supplyWarehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.materialReqBillInfo.getSupplyStoreOrgUnit(), data);
                        entryInfo.setSupplyWarehouse(supplyWarehouseInfo);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    try {
                        data = ((DataToken)lineData.get((Object)"FEntry$SupplyLocation_number")).data;
                        LocationInfo location = this.getLocation(ctx, data, supplyWarehouseInfo);
                        entryInfo.setSupplyLocation(location);
                    }
                    catch (Exception ex) {
                        throw new TaskExternalException(ex.getMessage(), ex.getCause());
                    }
                }
                data = ((DataToken)lineData.get((Object)"FEntry$person_number")).data;
                PersonInfo person = this.getPerson(ctx, data, resources, "personNotExists");
                entryInfo.setPerson(person);
                data = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
                PersonInfo stocker = this.getStocker(ctx, data);
                entryInfo.setStocker(stocker);
                data = ((DataToken)lineData.get((Object)"FEntry$picker_number")).data;
                PersonInfo picker = this.getPerson(ctx, data, resources, "pickerNotExists");
                entryInfo.setPicker(picker);
                data = ((DataToken)lineData.get((Object)"FSupplier_number")).data;
                if (data != null) {
                    String supplierNumber = data.toString();
                    SupplierInfo supplierInfo = null;
                    try {
                        supplierInfo = this.getSupplier(ctx, "number", supplierNumber);
                    }
                    catch (TaskExternalException e) {
                        data = (DataToken)lineData.get("FSupplier_name_l2");
                        String supplierName = data.toString();
                        try {
                            supplierInfo = this.getSupplier(ctx, "name", supplierName);
                        }
                        catch (TaskExternalException e1) {
                            throw new TaskExternalException(e1.getMessage(), e1.getCause());
                        }
                    }
                    entryInfo.setSupplier(supplierInfo);
                }
                if ((orderObj = ((DataToken)lineData.get((Object)"FEntry_OrderNumber")).data) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)orderObj.toString())) {
                    String orderNumber = orderObj.toString().length() <= 80 ? orderObj.toString() : orderObj.toString().substring(0, 80);
                    entryInfo.setOrderNumber(orderNumber);
                }
                if ((remarkObj = ((DataToken)lineData.get((Object)"FEntry_remark")).data) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)remarkObj.toString())) {
                    String remarkStr = remarkObj.toString().length() <= 255 ? remarkObj.toString() : remarkObj.toString().substring(0, 255);
                    entryInfo.setRemark(remarkStr);
                }
                this.doEntryFilesByRI(entryInfo);
                try {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                    MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                    entryInfo.setBaseUnit(baseUnit);
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
                    entryInfo.setBaseQty(baseQty);
                    if (materialCompanyInfo != null) {
                        BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                        if (AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType()) && standardCost != null) {
                            BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, materialInfo, standardCost, baseUnit, mui);
                            BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                            entryInfo.setUnitStandardCost(unitstandardcost);
                            entryInfo.setStandardCost(standardcost);
                            entryInfo.setUnitActualCost(unitstandardcost);
                            entryInfo.setActualCost(standardcost);
                        } else {
                            entryInfo.setUnitStandardCost(null);
                            entryInfo.setStandardCost(null);
                        }
                        if (!AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType())) {
                            int pricePrecision = materialInfo.getPricePrecision();
                            Object dataActualCost = ((DataToken)lineData.get((Object)"FEntry_actualCost")).data;
                            if (dataActualCost == null || "".equals(dataActualCost.toString().trim())) {
                                dataActualCost = "0";
                            }
                            if (qty != null && qty.compareTo(ZERO) != 0) {
                                BigDecimal dataUnitCost = ImRptAppUtils.getDataDeciaml(ctx, (String)dataActualCost).divide(qty, pricePrecision, 4);
                                entryInfo.setUnitActualCost(dataUnitCost);
                            }
                            entryInfo.setActualCost(ImRptAppUtils.getDataDeciaml(ctx, (String)dataActualCost));
                        }
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    if (null == lineData.get("FEntry$project_number") || (data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data) == null || (number = data.toString()) == null || number.trim().length() <= 0) break block98;
                    IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    status = new HashSet<Integer>();
                    status.add(new Integer(4));
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                    filter2 = new FilterInfo();
                    cu = this.materialReqBillInfo.getStorageOrgUnit().getCU();
                    cuPK = null;
                    cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                    try {
                        filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (filter2 != null) {
                        filter.mergeFilter(filter2, "and");
                    }
                    viewInfo.setFilter(filter);
                    coll = iProject.getProjectCollection(viewInfo);
                    if (coll != null && coll.size() > 0) {
                        ProjectInfo projectInfo = coll.get(0);
                        entryInfo.setProject(projectInfo);
                        break block98;
                    }
                    throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"PROJECT_NUMBER_ERROR", (String)resources));
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            try {
                if (null == lineData.get("FEntry$trackNumber_number") || (data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data) == null || (number = data.toString()) == null || number.trim().length() <= 0) break block99;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                status = new HashSet();
                status.add(new Integer(10));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                filter2 = new FilterInfo();
                cu = this.materialReqBillInfo.getStorageOrgUnit().getCU();
                cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    TrackNumberInfo trackNumberInfo = coll.get(0);
                    entryInfo.setTrackNumber(trackNumberInfo);
                    break block99;
                }
                throw new TaskExternalException(data.toString() + " " + MaterialReqImport.getResource((Context)ctx, (String)"TRACK_NUMBER_ERROR", (String)resources));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        if (null != lineData.get("FEntry$AdminOrgUnit1_number") && (data = ((DataToken)lineData.get((Object)"FEntry$AdminOrgUnit1_number")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && data != null && (str = data.toString()) != null && str.trim().length() > 0) {
            try {
                AdminOrgUnitInfo info;
                IAdminOrgUnit iadminorg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitCollection collection = iadminorg.getAdminOrgUnitCollection(this.getFilter(data.toString().trim()));
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    if (info == null) {
                        throw new TaskExternalException(data.toString() + "  " + MaterialReqImport.getResource((Context)ctx, (String)"ENTRY_ADMINORG_NOT_EXISTS", (String)resources));
                    }
                } else {
                    throw new TaskExternalException(data.toString() + "  " + MaterialReqImport.getResource((Context)ctx, (String)"ENTRY_ADMINORG_NOT_EXISTS", (String)resources));
                }
                entryInfo.setAdminOrgUnit(info);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        this.doEntryInvUpdateType(ctx, lineData, entryInfo);
        try {
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return entryInfo;
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("bizType.number") != null) {
                BizTypeInfo bizType = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo("select id where number='" + rs.getString("bizType.number") + "'");
                if (bizType != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizType.getId().toString())) {
                    throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"JUMP_COMPANY_CANNOT_IMPORT", (String)resources));
                }
                result.put("FBizType_number", rs.getString("bizType.number"));
            }
            if (rs.getString("bizType.name") != null) {
                result.put("FBizType_name_l2", rs.getString("bizType.name"));
            }
            if (rs.getString("TRANSACTIONTYPE.NUMBER") != null) {
                result.put("FTransactionType_number", rs.getString("TRANSACTIONTYPE.NUMBER"));
            }
            if (rs.getString("Number") != null) {
                result.put("FNumber", rs.getString("Number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("TRANSACTIONTYPE.NAME") != null) {
                result.put("FTransactionType_name_l2", rs.getString("TRANSACTIONTYPE.NAME"));
            }
            if (rs.getString("STORAGEORGUNIT.NUMBER") != null) {
                result.put("FStorageOrgUnit_number", rs.getString("STORAGEORGUNIT.NUMBER"));
            }
            if (rs.getString("STORAGEORGUNIT.NAME") != null) {
                result.put("FStorageOrgUnit_name_l2", rs.getString("STORAGEORGUNIT.NAME"));
            }
            if (rs.getString("COSTCENTERORGUNIT.NUMBER") != null) {
                result.put("FCostCenterOrgUnit_number", rs.getString("COSTCENTERORGUNIT.NUMBER"));
            }
            if (rs.getString("ADMINORGUNIT.NUMBER") != null) {
                result.put("FAdminOrgUnit_number", rs.getString("ADMINORGUNIT.NUMBER"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l2", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NUMBER") != null) {
                result.put("FEntry$costObject_number", rs.getString("COSTOBJECT.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NAME") != null) {
                result.put("FEntry$costObject_name_l2", rs.getString("COSTOBJECT.NAME"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("COSTOBJECTSUITE.NUMBER") != null) {
                result.put("FEntry$costObjectSuite_number", rs.getString("COSTOBJECTSUITE.NUMBER"));
            }
            if (rs.getString("COSTOBJECTSUITE.NAME") != null) {
                result.put("FEntry$costObjectSuite_name_l2", rs.getString("COSTOBJECTSUITE.NAME"));
            }
            if (rs.getString("COSTITEM.NUMBER") != null) {
                result.put("FEntry$costItem_number", rs.getString("COSTITEM.NUMBER"));
            }
            if (rs.getString("COSTITEM.NAME") != null) {
                result.put("FEntry$costItem_name_l2", rs.getString("COSTITEM.NAME"));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ASSISTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$Warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("STOCKER.NUMBER") != null) {
                result.put("FEntry$stocker_number", rs.getString("STOCKER.NUMBER"));
            }
            if (rs.getString("LOCATION.NUMBER") != null) {
                result.put("FEntry$Location_number", rs.getString("LOCATION.NUMBER"));
            }
            if (rs.getString("ENTRY.actualCost") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString().length() < 1) {
                    result.put("FEntry_actualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.actualCost"));
                    result.put("FEntry_actualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ENTRY.UNITACTUALCOST") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString().length() < 1) {
                    result.put("FEntry_unitActualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.UNITACTUALCOST"));
                    result.put("FEntry_unitActualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("Entry.orderNumber") != null) {
                result.put("FEntry_OrderNumber", rs.getString("Entry.orderNumber"));
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("Creator.number") != null) {
                result.put("FCreator_number", rs.getString("Creator.number"));
            }
            if (rs.getString("Project.number") != null) {
                result.put("FEntry$project_number", rs.getString("Project.number"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getString("picker.number") != null) {
                result.put("FEntry$picker_number", rs.getString("picker.number"));
            }
            if (rs.getString("stocker.name") != null) {
                result.put("FEntry$Stocker_name", rs.getString("stocker.name"));
            }
            if (rs.getString("entry.settlePrice") != null) {
                result.put("FEntry$SettlePrice", rs.getString("entry.settlePrice"));
            }
            if (rs.getString("supplyLocation.number") != null) {
                result.put("FEntry$SupplyLocation_number", rs.getString("supplyLocation.number"));
            }
            if (rs.getString("supplyWarehouse.number") != null) {
                result.put("FEntry$SupplyWarehouse_number", rs.getString("supplyWarehouse.number"));
            }
            if (rs.getString("demandCompanyOrgUnit.name") != null) {
                result.put("FDemandCompanyOrgUnit_number", rs.getString("demandCompanyOrgUnit.name"));
            }
            if (rs.getString("supplyCompanyOrgUnit.name") != null) {
                result.put("FSupplyCompanyOrgUnit_number", rs.getString("supplyCompanyOrgUnit.name"));
            }
            if (rs.getString("supplyStoreOrgUnit.number") != null) {
                result.put("FSupplyStoreOrgUnit_number", rs.getString("supplyStoreOrgUnit.number"));
            }
            if (rs.getString("adminOrgUnit1.name") != null) {
                result.put("FEntry$AdminOrgUnit1_name", rs.getString("adminOrgUnit1.name"));
            }
            if (rs.getString("adminOrgUnit1.number") != null) {
                result.put("FEntry$AdminOrgUnit1_number", rs.getString("adminOrgUnit1.number"));
            }
            if (rs.getString("costCenterOrgUnit1.name") != null) {
                result.put("FEntry$CostCenterOrgUnit1_name", rs.getString("costCenterOrgUnit1.name"));
            }
            if (rs.getString("costCenterOrgUnit1.number") != null) {
                result.put("FEntry$CostCenterOrgUnit1_number", rs.getString("costCenterOrgUnit1.number"));
            }
            if (rs.getString("invUpdateType.number") != null) {
                result.put("FInvUpdateType_number", rs.getString("invUpdateType.number"));
            }
            if (rs.getString("invUpdateType.name") != null) {
                result.put("FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
            }
            if (rs.getString("supplier.name") != null) {
                result.put("FSupplier_name_l2", rs.getString("supplier.name"));
            }
            if (rs.getString("supplier.number") != null) {
                result.put("FSupplier_number", rs.getString("supplier.number"));
            }
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception Ex) {
            Logger.error((Throwable)Ex);
            throw new TaskExternalException(Ex.getMessage(), (Throwable)Ex);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.MaterialReqDataImportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "materialreq_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((String)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, MaterialReqBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        MaterialInventoryInfo materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
        boolean isLotNumber = materialInventoryInfo.isIsLotNumber();
        if (!isLotNumber && data != null && data.toString().length() > 0) {
            return false;
        }
        if (isLotNumber && (data == null || data.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
        }
        return true;
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + MaterialReqImport.getResource((Context)ctx, (String)"RelationNotExists", (String)resources));
        }
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"NotSetAssistProperty", (String)resources));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"SetAssistProperty", (String)resources));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"NotSetAssistUnit", (String)resources));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialReqImport.getResource((Context)ctx, (String)"SetAssistUnit", (String)resources));
            }
        }
    }

    private void loadTransaction(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        TransactionTypeInfo transaction;
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.tti = transaction = this.getTransaction(ctx, byProperty, souData, "50957179-0105-1000-e000-0163c0a812fd463ED552", this.materialReqBillInfo.getBizType());
        this.materialReqBillInfo.setTransactionType(this.tti);
    }

    private void loadBizType(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        if (souData == null || souData.toString().trim().length() == 0) {
            throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"BizTypeNotNull", (String)resources));
        }
        BizTypeInfo bizType = this.getBizType(ctx, "50957179-0105-1000-e000-0163c0a812fd463ED552", byProperty, souData);
        this.materialReqBillInfo.setBizType(bizType);
    }

    private void loadStorageOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        StorageOrgUnitInfo storageOrgUnit;
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.sou = storageOrgUnit = this.getStorageOrgUnit(ctx, byProperty, souData);
        this.materialReqBillInfo.setStorageOrgUnit(storageOrgUnit);
    }

    private StorageOrgUnitInfo getStorageOrgUnitByPropertyValue(Context ctx, String property, String value) throws BOSException {
        StorageOrgUnitCollection collection;
        if (property == null || "".equals(property) || value == null || "".equals(value)) {
            return null;
        }
        String key = value + SPLIT_KEY + property;
        StorageOrgUnitInfo storageOrgUnitInfo = this.dataPool.getStorageOrgUnitInfo(key);
        if (storageOrgUnitInfo == null && (collection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(this.getFilter(value, property))) != null && collection.size() > 0) {
            storageOrgUnitInfo = collection.get(0);
            this.dataPool.setStorageOrgUnitInfo(key, storageOrgUnitInfo);
        }
        return storageOrgUnitInfo;
    }

    private void checkNumberAndAmount(MaterialReqBillEntryInfo entryInfo, Context ctx, Map lineData, String[] checkList, String[] setList, boolean checkBackType) throws TaskExternalException {
        for (int i = 0; i < checkList.length; ++i) {
            try {
                Object o = ((DataToken)lineData.get((Object)checkList[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    o = ((String)o).replace(",", "");
                    BigDecimal value = new BigDecimal(o.toString());
                    entryInfo.setBigDecimal(setList[i], value);
                    if (value.compareTo(ZERO) != 0 || !setList[i].equalsIgnoreCase(QTY_PROPERTY[0])) continue;
                    throw new TaskExternalException(MaterialReqImport.getResource((Context)ctx, (String)"qtyGreaterZero", (String)resources));
                }
                if (checkList[i].equalsIgnoreCase(QTY_PROPERTY[0])) {
                    throw new TaskExternalException(checkList[i] + MaterialReqImport.getResource((Context)ctx, (String)"Numbercannotbenull", (String)resources));
                }
                if (checkList[i].equals(ASSISTQTY_PROPERTY[0])) continue;
                entryInfo.setBigDecimal(setList[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(checkList[i] + MaterialReqImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
            }
        }
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = MaterialReqImport.getMulUnit(mui, mi, ctx);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = MaterialReqImport.getMulUnit(baseUnit, mi, ctx);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi, Context ctx) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private void doEntryFilesByRI(MaterialReqBillEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : ENTRY_PRICE_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
        boolean flag = !InvAppUtils.isNegative(this.materialReqBillInfo.getTransactionType());
        for (String entryField2 : ENTRY_QTY_AMOUNT_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            if (flag) {
                value = (BigDecimal)entryInfo.get(entryField2);
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    private void doEntryInvUpdateType(Context ctx, Map lineData, MaterialReqBillEntryInfo entryInfo) throws TaskExternalException {
        try {
            this.loadInvUpdateType(lineData, ctx, "number", "FInvUpdateType_number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadInvUpdateType(lineData, ctx, "name", "FInvUpdateType_name_l2", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadInvUpdateType(Map lineData, Context ctx, String byProperty, String propertyName, MaterialReqBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        boolean flag;
        TransactionInvUpdateTypeCollection collections;
        InvUpdateTypeInfo invUpdateTypeInfo;
        block11: {
            boolean flag2;
            Object souData;
            block10: {
                souData = ((DataToken)lineData.get((Object)propertyName)).data;
                invUpdateTypeInfo = null;
                if (souData != null && souData.toString().trim().length() > 0) {
                    TransactionTypeInfo transInfo = this.materialReqBillInfo.getTransactionType();
                    collections = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, this.getFilter(transInfo.getId().toString(), "transactiontype"));
                    if (this.dataPool.getInvUpdateTypeInfo(souData.toString().trim()) == null) {
                        InvUpdateTypeCollection collection = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(this.getFilter(souData.toString().trim(), byProperty));
                        if (collection != null && collection.size() > 0 && collections != null && collections.size() > 0) {
                            invUpdateTypeInfo = collection.get(0);
                            flag2 = false;
                            break block10;
                        } else {
                            String str = MaterialReqImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                            throw new TaskExternalException(str);
                        }
                    }
                    if (collections != null && collections.size() > 0) {
                        invUpdateTypeInfo = this.dataPool.getInvUpdateTypeInfo(souData.toString().trim());
                        flag = false;
                        break block11;
                    } else {
                        String str = MaterialReqImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                        throw new TaskExternalException(str);
                    }
                }
                String str = MaterialReqImport.getResource((Context)ctx, (String)"InvUpdateType_isNull", (String)invResouces);
                throw new TaskExternalException(str);
            }
            for (int i = 0; i < collections.size(); ++i) {
                TransactionInvUpdateTypeInfo tt = collections.get(i);
                if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
                flag2 = true;
                break;
            }
            if (flag2) {
                entryInfo.setInvUpdateType(invUpdateTypeInfo);
                this.dataPool.setInvUpdateTypeMapInfo(souData.toString().trim(), invUpdateTypeInfo);
                return;
            }
            String str = MaterialReqImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
            throw new TaskExternalException(str);
        }
        for (int i = 0; i < collections.size(); ++i) {
            TransactionInvUpdateTypeInfo tt = collections.get(i);
            if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
            return;
        }
        String str = MaterialReqImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
        throw new TaskExternalException(str);
    }

    public String getImportPermissionItem() {
        return "materialreq_new";
    }

    protected String[] getLocalAmountFields() {
        return new String[]{"standardCost", "actualCost"};
    }

    protected String[] getPriceFields() {
        return new String[]{"unitStandardCost", "unitActualCost"};
    }
}

