/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryAgent;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialReqWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialReqWebFacadeControllerBean
extends AbstractMaterialReqWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MaterialReqWebFacadeControllerBean");

    public void initData(Context context, Map map, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, map, model);
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        CompanyOrgUnitInfo cou = null;
        Map paramMap = null;
        if (info.getStorageOrgUnit() == null) {
            throw new InvBizException(InvBizException.NO_MATREQ_PERMISSION);
        }
        cou = this.getCouBySou(context, info.getStorageOrgUnit().getId().toString());
        paramMap = this.getParamsMap(context, info.getStorageOrgUnit().getId().toString(), cou.getId().toString());
        map.put("baseCurrency", this.getBaseCurrencyByCou(context, cou));
        boolean costManageIsStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.COSTMANAGEMENT, (CompanyOrgUnitInfo)cou);
        map.put("costManageIsStart", costManageIsStart);
        map.put("params", paramMap);
        map.put("sourceBillType", info.getSourceBillType());
        String storageOrgFilter = "id in " + this.getStoOrgFilter(context);
        map.put("f7_mainOrgUnit", storageOrgFilter);
    }

    private String getStoOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Storage, null, "materialreq_new");
        OrgUnitCollection Coll = new OrgUnitCollection();
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            iSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        StorageOrgUnitCollection stoOrgColl = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        for (int i = 0; i < stoOrgColl.size(); ++i) {
            Coll.add((OrgUnitInfo)stoOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, Coll);
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        MaterialReqBillInfo info = null;
        StorageOrgUnitInfo sou = null;
        CompanyOrgUnitInfo cou = null;
        info = new MaterialReqBillInfo();
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0163c0a812fd463ED552"));
        aBillTypeInfo.setNumber("104");
        info.setBillType(aBillTypeInfo);
        info.setTotalStandardCost(SCMConstant.BIGDECIMAL_ZERO);
        info.setTotalActualCost(SCMConstant.BIGDECIMAL_ZERO);
        info.setTotalAmount(SCMConstant.BIGDECIMAL_ZERO);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setFiVouchered(false);
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)context).getUserInfo(context.getCaller());
        info.setCreator(aUserInfo);
        sou = info.getStorageOrgUnit() != null ? info.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(context, OrgType.Storage, "materialreq_new");
        if (sou != null) {
            info.setCU(sou.getCU());
            cou = this.getCouBySou(context, sou.getId().toString());
        }
        if (cou != null) {
            info.setStorageOrgUnit(sou);
            info.setSupplyStoreOrgUnit(sou);
        }
        BizTypeInfo bizTypeInfo = null;
        bizTypeInfo = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)"0rSFjAEeEADgAAyMwKgSQiQHQ1w=", (String)"50957179-0105-1000-e000-0163c0a812fd463ED552");
        info.setBizType(bizTypeInfo);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        info.setBizDate(curDate);
        info.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        if (bizTypeInfo != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-0163c0a812fd463ED552", bizTypeInfo.getId().toString());
            info.setTransactionType(tti);
        }
        if (info.getEntry() != null) {
            for (int i = 0; i < 5; ++i) {
                MaterialReqBillEntryInfo entry = (MaterialReqBillEntryInfo)this.createNewDetailData(context, model);
                if (info.getTransactionType() != null) {
                    InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType("50957179-0105-1000-e000-0163c0a812fd463ED552", info.getTransactionType());
                    entry.setInvUpdateType(invUpdateTypeInfo);
                }
                entry.setStorageOrgUnit(sou);
                entry.setCompanyOrgUnit(cou);
                info.getEntry().add(entry);
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException {
        MaterialReqBillEntryAgent materialReqBillEntryInfo = MaterialReqBillEntryAgent.create();
        if (materialReqBillEntryInfo.getSubWrittenOffQty() == null) {
            materialReqBillEntryInfo.setSubWrittenOffQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getSubUnWriteOffQty() == null) {
            materialReqBillEntryInfo.setSubUnWriteOffQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getScWrittenOffAmount() == null) {
            materialReqBillEntryInfo.setScWrittenOffAmount(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getBaseIssueQty() == null) {
            materialReqBillEntryInfo.setBaseIssueQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getSubUnWriteOffBaseQty() == null) {
            materialReqBillEntryInfo.setSubUnWriteOffBaseQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getSubWrittenOffBaseQty() == null) {
            materialReqBillEntryInfo.setSubWrittenOffBaseQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        if (materialReqBillEntryInfo.getIssueQty() == null) {
            materialReqBillEntryInfo.setIssueQty(SCMConstant.BIGDECIMAL_ZERO);
        }
        materialReqBillEntryInfo.setSettlePrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setIsPresent(false);
        materialReqBillEntryInfo.setId(BOSUuid.create((String)"11774BB4"));
        materialReqBillEntryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setBaseQty(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setReverseQty(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setUnReturnedBaseQty(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setUnitActualCost(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setActualCost(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setUnitStandardCost(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setStandardCost(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setAmount(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setReturnBaseQty(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setPrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        materialReqBillEntryInfo.setIsAdmeasure(false);
        materialReqBillEntryInfo.setIsReWork(false);
        materialReqBillEntryInfo.setCostObject(null);
        materialReqBillEntryInfo.setCostObjectSuite(null);
        materialReqBillEntryInfo.setWarehouse(null);
        materialReqBillEntryInfo.setStocker(null);
        materialReqBillEntryInfo.setPicker(null);
        materialReqBillEntryInfo.setLocation(null);
        materialReqBillEntryInfo.setSupplier(null);
        materialReqBillEntryInfo.setCustomer(null);
        materialReqBillEntryInfo.setPrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setTaxPrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setRealPrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setRealTaxPrice(SCMConstant.BIGDECIMAL_ZERO);
        materialReqBillEntryInfo.setDiscount(SCMConstant.BIGDECIMAL_ZERO);
        return materialReqBillEntryInfo;
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "storageOrgUnit";
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "materialreq_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "materialreq_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "materialreq_view";
        }
        return "materialreq_new";
    }

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return MaterialReqBillFactory.getLocalInstance(context);
    }

    @Override
    protected Map _getDataForOrgChanged(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = (String)requestMap.get("orgId");
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        MaterialReqBillInfo info = new MaterialReqBillInfo();
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        info.setStorageOrgUnit(sou);
        info.setCU(sou.getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, orgId);
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)info, orgId));
            }
        }
        responseMap.put("cou", cou);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        return responseMap;
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM100", "INM008"});
        paramMap.putAll(souParamMap);
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[]{"CONSIGNSALES", "AR_032"});
        paramMap.putAll(couParamMap);
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    @Override
    protected Map _getJumpCompanyForbizType(Context ctx, Map resquestMap) throws BOSException, EASBizException {
        HashMap<String, String> data = new HashMap<String, String>();
        String userId = (String)resquestMap.get("userID");
        String[] fromStIds = new String[]{null};
        String[] fromCpIds = new String[]{null};
        BizRoleTypeEnum[] fromTypes = new BizRoleTypeEnum[]{null};
        String id = (String)resquestMap.get("id");
        if (id != null) {
            fromStIds[0] = id;
            CompanyOrgUnitInfo cou = this.getCouBySou(ctx, id);
            fromCpIds[0] = cou.getId().toString();
        }
        if (id != null) {
            fromTypes[0] = BizRoleTypeEnum.RequireSide;
        }
        Set filterID = this.getStorageOrgUnitViewBySupplyRelation(id, "d8e80652-0117-1000-e000-04c5c0a812202407435C", fromStIds, fromCpIds, fromTypes, BizRoleTypeEnum.SupplySide, "transferorder_new", null, null, null, userId);
        Iterator it = filterID.iterator();
        String str = "";
        while (it.hasNext()) {
            str = str + "'" + (String)it.next() + "',";
        }
        str = str.substring(0, str.length() - 1);
        data.put("filter", str);
        return data;
    }

    private Set getStorageOrgUnitViewBySupplyRelation(String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, String permItem, Map couMap, Map authOrgMap, String parameter, String userId) {
        HashSet<Object> setDestSouID;
        block66: {
            setDestSouID = new HashSet<Object>();
            try {
                String param = "false";
                if (parameter != null) {
                    param = parameter;
                } else if (mainOrgID != null) {
                    IParamControl ipc = ParamControlFactory.getRemoteInstance();
                    param = ipc.getParamValue((IObjectPK)new ObjectUuidPK(mainOrgID), "INM007");
                }
                if ("false".equalsIgnoreCase(param)) {
                    HashMap<String, Map> map = new HashMap<String, Map>();
                    map.put(userId, PermissionFactory.getRemoteInstance().getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userId), OrgType.Storage, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000074F2827FD"), null, null));
                    Map map1 = (Map)map.get(userId);
                    Iterator iter = map1.keySet().iterator();
                    while (iter.hasNext()) {
                        setDestSouID.add(iter.next());
                    }
                }
                if (!StringUtils.isEmpty((String)bizTypeID) && "true".equalsIgnoreCase(param)) {
                    if (fromRoles != null) {
                        EntityViewInfo viewRule = new EntityViewInfo();
                        FilterInfo filterRule = new FilterInfo();
                        filterRule.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
                        filterRule.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizTypeID));
                        int n = fromRoles.length;
                        for (int i = 0; i < n; ++i) {
                            if (fromStorageIDs[i] == null) continue;
                            if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                                filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                                continue;
                            }
                            if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                                filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                                continue;
                            }
                            if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                                filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                                continue;
                            }
                            if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                        }
                        viewRule.setFilter(filterRule);
                        ITransferRule itr = null;
                        SelectorItemCollection selector = null;
                        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
                            itr = TransferRule2Factory.getRemoteInstance();
                            selector = new TransferRule2Info().getSelectorItemCollection();
                        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
                            itr = TransferRule3Factory.getRemoteInstance();
                            selector = new TransferRule3Info().getSelectorItemCollection();
                        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
                            itr = TransferRule4Factory.getRemoteInstance();
                            selector = new TransferRule4Info().getSelectorItemCollection();
                        }
                        if (selector != null) {
                            viewRule.setSelector(selector);
                        }
                        if (null == itr) {
                            throw new IllegalArgumentException("this bizTypeID is not supported !");
                        }
                        TransferRuleCollection rules = itr.getTransferRuleCollection(viewRule);
                        int n2 = rules.size();
                        for (int i = 0; i < n2; ++i) {
                            String souID = "";
                            if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                                souID = rules.get(i).getSupplyRelation().getRequireStorageOrgUnit().getId().toString();
                            } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                                souID = rules.get(i).getSupplyRelation().getSupplyStorageOrgUnit().getId().toString();
                            } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                                souID = rules.get(i).getSupplyRelation().getIssueStorageOrgUnit().getId().toString();
                            } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                                souID = rules.get(i).getSupplyRelation().getReceiveStorageOrgUnit().getId().toString();
                            }
                            setDestSouID.add(souID);
                        }
                    }
                    break block66;
                }
                EntityViewInfo viewRelation = new EntityViewInfo();
                FilterInfo filterRelation = new FilterInfo();
                if (fromRoles != null) {
                    int n = fromRoles.length;
                    for (int i = 0; i < n; ++i) {
                        if (fromStorageIDs[i] == null) continue;
                        if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                        filterRelation.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                    }
                }
                viewRelation.setFilter(filterRelation);
                viewRelation.getSelector().add(new SelectorItemInfo("id"));
                viewRelation.getSelector().add(new SelectorItemInfo("status"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireStorageOrgUnit.id"));
                SupplyRelationCollection relations = SupplyRelationFactory.getRemoteInstance().getSupplyRelationCollection(viewRelation);
                int n = relations.size();
                for (int i = 0; i < n; ++i) {
                    String souID = "";
                    if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                        souID = relations.get(i).getRequireStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                        souID = relations.get(i).getSupplyStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                        souID = relations.get(i).getIssueStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                        souID = relations.get(i).getReceiveStorageOrgUnit().getId().toString();
                    }
                    setDestSouID.add(souID);
                }
                if (fromRoles == null || fromCompanyIDs == null) break block66;
                String couId = null;
                String souId = null;
                Object[] souIds = setDestSouID.toArray();
                HashSet<String> result = new HashSet<String>(souIds.length);
                boolean shouldAdd = true;
                int count = setDestSouID.size();
                BOSUuid[] bosSouIds = new BOSUuid[count];
                Iterator iterator = setDestSouID.iterator();
                int k = 0;
                while (iterator.hasNext()) {
                    bosSouIds[k] = BOSUuid.read((String)iterator.next().toString());
                    ++k;
                }
                Map couMaps = SCMBillCommonFacadeFactory.getRemoteInstance().getCompanyInfos(bosSouIds);
                CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[bosSouIds.length];
                int length = bosSouIds.length;
                for (int i = 0; i < length && bosSouIds[i] != null; ++i) {
                    couInfos[i] = (CompanyOrgUnitInfo)couMaps.get(bosSouIds[i].toString());
                }
                for (int j = 0; j < couInfos.length; ++j) {
                    int i;
                    int size;
                    souId = (String)souIds[j];
                    if (couInfos[j] == null) continue;
                    couId = couInfos[j].getId().toString();
                    shouldAdd = true;
                    if (BizRoleTypeEnum.SupplySide.equals((Object)toRole) && bizTypeID == null) {
                        size = fromStorageIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                            break;
                        }
                    } else if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                        size = fromStorageIDs.length;
                        for (i = 0; i < size; ++i) {
                            if ((BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if ((BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && !"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                            break;
                        }
                    }
                    if (!shouldAdd) continue;
                    result.add(souId);
                }
                setDestSouID = result;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        setDestSouID.add("111__not__existed__id");
        return setDestSouID;
    }
}

