/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillAgent;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialRequestBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.UpdatePurRequestForMaterialReqUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class MaterialRequestBillControllerBean
extends AbstractMaterialRequestBillControllerBean {
    private static final long serialVersionUID = -6912939134868745582L;

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return false;
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return false;
    }

    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = "T_IM_MaterialRequestBill";
        String entryTableName = "T_IM_MaterialRequestBillEntry";
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmtHead = null;
        PreparedStatement preStmtEntry = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            StringBuffer entrySqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            entrySqlBuff.append("Update ");
            entrySqlBuff.append(entryTableName);
            entrySqlBuff.append(" SET fassociateQty = abs(FApprovedBaseQty),FBaseStatus = ? ");
            entrySqlBuff.append(" WHERE FParentid = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmtHead = conn.prepareStatement(sqlBuff.toString());
            preStmtEntry = conn.prepareStatement(entrySqlBuff.toString());
            Date now = new Date();
            preStmtHead.setTimestamp(1, new Timestamp(now.getTime()));
            UserInfo aUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            preStmtHead.setString(2, aUserInfo.getId().toString());
            preStmtHead.setInt(3, 4);
            preStmtHead.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmtHead.execute();
            preStmtEntry.setInt(1, 4);
            preStmtEntry.setString(2, aSCMBillBaseInfo.getId().toString());
            preStmtEntry.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmtHead, conn);
                SQLUtils.cleanup(preStmtEntry, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmtHead, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmtEntry, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
        UpdatePurRequestForMaterialReqUtils.writeBackForPurRequest(ctx, model, true);
    }

    protected OrgUnitCollection _getAuthOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK, IMetaDataPK queryPK) throws BOSException, EASBizException {
        return super._getAuthOrgsByRelation(ctx, destOrgType, srcOrgType, orgPK, queryPK);
    }

    public void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        String tableName = "T_IM_MaterialRequestBill";
        String entryTableName = "T_IM_MaterialRequestBillEntry";
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        Connection conn = null;
        PreparedStatement preStmtHead = null;
        PreparedStatement preStmtEntry = null;
        Statement sm = null;
        try {
            StringBuffer sqlBuff = new StringBuffer();
            StringBuffer entrySqlBuff = new StringBuffer();
            sqlBuff.append("Update ");
            sqlBuff.append(tableName);
            sqlBuff.append(" SET FAuditTime = ?, FAuditorID = ? , FBaseStatus = ? ");
            sqlBuff.append(" WHERE FID = ? ");
            entrySqlBuff.append("Update ");
            entrySqlBuff.append(entryTableName);
            entrySqlBuff.append(" SET  FBaseStatus = ? ");
            entrySqlBuff.append(" WHERE FParentid = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmtHead = conn.prepareStatement(sqlBuff.toString());
            preStmtEntry = conn.prepareStatement(entrySqlBuff.toString());
            preStmtHead.setTimestamp(1, null);
            preStmtHead.setString(2, null);
            preStmtHead.setInt(3, 1);
            preStmtHead.setString(4, aSCMBillBaseInfo.getId().toString());
            preStmtHead.execute();
            preStmtEntry.setInt(1, 1);
            preStmtEntry.setString(2, aSCMBillBaseInfo.getId().toString());
            preStmtEntry.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmtHead, conn);
                SQLUtils.cleanup(preStmtEntry, conn);
                SQLUtils.cleanup(sm, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmtHead, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmtEntry, (Connection)conn);
        SQLUtils.cleanup(sm, (Connection)conn);
        UpdatePurRequestForMaterialReqUtils.writeBackForPurRequest(ctx, model, false);
    }

    @Override
    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MaterialRequestBillInfo aMaterialRequestBillInfo = (MaterialRequestBillInfo)model;
        if (aMaterialRequestBillInfo.getBillType() != null) {
            String billTypeId = aMaterialRequestBillInfo.getBillType().getId().toString();
            String orgUnitID = aMaterialRequestBillInfo.getRequestOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 0, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().equalsIgnoreCase("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        super.update(ctx, pk, model);
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selectorCol = super.getSelector();
        selectorCol.add("requestOrgUnit.id");
        selectorCol.add("entry.*");
        return selectorCol;
    }

    @Override
    protected void setUnAssociationQtyByQty(IObjectCollection entrys) throws BOSException, EASBizException {
    }

    protected String getBillTypeId() {
        return "XlazxwEREADgAAAEwKgSxUY+1VI=";
    }

    @Override
    protected boolean checkEntryCoreBillType(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        MaterialRequestBillInfo billInfo = (MaterialRequestBillInfo)aInvBillBaseInfo;
        MaterialRequestBillEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || CoreBillTypeid == null) continue;
            return false;
        }
        return true;
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        MaterialRequestBillInfo matRequestInfo = null;
        matRequestInfo = isUseAgent ? MaterialRequestBillAgent.create() : new MaterialRequestBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        matRequestInfo.setCreateTime(ts);
        matRequestInfo.setBizDate(curDate);
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"0rSFjAEeEADgAAyMwKgSQiQHQ1w=", (String)"XlazxwEREADgAAAEwKgSxUY+1VI=");
        matRequestInfo.setBizType(bizType);
        return matRequestInfo;
    }

    public void isSamePerson4Audit(Context ctx, SCMBillBaseInfo info) throws EASBizException, BOSException {
        UserInfo userInfo;
        String creatorID = "";
        String currentUserId = "";
        String orgUnitID = null;
        if (info.get(info.getBizOrgPropertyName()) != null) {
            orgUnitID = ((CoreBaseInfo)info.get(info.getBizOrgPropertyName())).getId().toString();
        }
        if (info.getCreator() != null) {
            creatorID = info.getCreator().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        String billTypeId = info.getBillType().getId().toString();
        String flag = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("SCM_SamePersonAudit_02", 0, orgUnitID, billTypeId);
        if (flag != null && flag.length() > 0 && flag.equals("1") && creatorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_CREATOR_ISSAME);
        }
    }

    public void isSamePerson4UnAudit(Context ctx, SCMBillBaseInfo info) throws EASBizException, BOSException {
        UserInfo userInfo;
        String auditorID = "";
        String currentUserId = "";
        String orgUnitID = null;
        if (info.get(info.getBizOrgPropertyName()) != null) {
            orgUnitID = ((CoreBaseInfo)info.get(info.getBizOrgPropertyName())).getId().toString();
        }
        if (info.getAuditor() != null) {
            auditorID = info.getAuditor().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        String billTypeId = info.getBillType().getId().toString();
        String flag = SCMBillParamFactory.getLocalInstance((Context)ctx).getParamByBillTypeID("SCM_SamePersonAudit_01", 0, orgUnitID, billTypeId);
        if (flag != null && flag.length() > 0 && flag.equals("1") && !auditorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_UNAUDITOR_NOTSAME);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialRequestBillInfo info = this.getMaterialRequestBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        MaterialRequestBillInfo info = this.getMaterialRequestBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo company = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            MaterialRequestBillInfo info = (MaterialRequestBillInfo)collection.getObject(i);
            if (info.getAdminOrgUnit() == null || (company = (CompanyOrgUnitInfo)InvServerUtils.getOrgInfoFromOrgInfo(ctx, (OrgUnitInfo)info.getAdminOrgUnit(), 0, 1, company)) != null && company.getId() != null) continue;
            throw new InvBizException(InvBizException.ADMINORG_HASNOTCOMPANY, new String[]{info.getAdminOrgUnit().getName(), info.getAdminOrgUnit().getNumber()});
        }
        super._handleAfterTransform(ctx, action, collection);
    }
}

