/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMaterialRequestBillEntryControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashSet;
import java.util.Map;

public class MaterialRequestBillEntryControllerBean
extends AbstractMaterialRequestBillEntryControllerBean {
    @Override
    protected void _handleClose(Context ctx, IObjectPK billId, IObjectPK entryId, String reason) throws BOSException, EASBizException {
        this.handleCloseOrUnClose(ctx, billId, entryId, true, reason);
    }

    @Override
    protected void _handleUnClose(Context ctx, IObjectPK billId, IObjectPK entryId) throws BOSException, EASBizException {
        this.handleCloseOrUnClose(ctx, billId, entryId, false, null);
    }

    protected void handleCloseOrUnClose(Context ctx, IObjectPK billId, IObjectPK entryId, boolean isClose, String reason) throws BOSException, EASBizException {
        if (entryId != null) {
            EntryBaseStatusEnum checkStatus;
            MaterialRequestBillEntryInfo entryInfo = this.getMaterialRequestBillEntryInfo(ctx, entryId, SCMSelectorFactory.getMaterialRequestEntrySelector4CloseOrUnClose());
            if (entryInfo == null) {
                throw new ObjectNotFoundException();
            }
            EntryBaseStatusEnum entryBaseStatusEnum = checkStatus = isClose ? EntryBaseStatusEnum.AUDITED : EntryBaseStatusEnum.CLOSED;
            if (entryInfo.getBaseStatus() != checkStatus) {
                throw new InvBizException(isClose ? InvBizException.ERROR_NOT_AUDIT_CANT_CLOSE : InvBizException.ERROR_NOT_CLOSED_CAN_UNCLOSE);
            }
            String tableName = "T_IM_MaterialRequestBillEntry";
            this.executeBizFlow(ctx, tableName, entryId, isClose ? BatchActionEnum.CLOSE : BatchActionEnum.UNCLOSE);
            StringBuilder sql = new StringBuilder();
            if (isClose) {
                sql.append("update ").append(tableName).append(" set FBaseStatus = 7,FReason = '").append(reason).append("' where FID = '").append(entryId.toString()).append("'");
            } else {
                sql.append("update ").append(tableName).append(" set FBaseStatus = 4,FReason = null where FID = '").append(entryId).append("'");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            if (isClose) {
                sql.append("update T_IM_MaterialRequestBill set FBaseStatus = 7 where fid = ").append("'").append(billId).append("'");
                sql.append(" and FID not in (select FParentId from T_IM_MaterialRequestBillEntry where FParentId = ");
                sql.append("'").append(billId).append("'").append(" and FBaseStatus <> 7 )");
            } else {
                sql.append("update T_IM_MaterialRequestBill set FBaseStatus = ");
                sql.append(4);
                sql.append(" where FId in (select FParentId from T_IM_MaterialRequestBillEntry where FParentId = ");
                sql.append("'").append(billId).append("'").append(" and FBaseStatus = ").append(4);
                sql.append(") and FBaseStatus = ").append(7);
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            this.writeLog(ctx, entryInfo, isClose);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialRequestBillEntryInfo entry = (MaterialRequestBillEntryInfo)this.getValue(ctx, pk);
        MaterialRequestBillInfo bill = MaterialRequestBillFactory.getLocalInstance(ctx).getMaterialRequestBillInfo((IObjectPK)new ObjectUuidPK(entry.getParent().getId()));
        return bill.getNumber() + "  " + entry.getSeq();
    }

    private void executeBizFlow(Context ctx, String tableName, IObjectPK entryId, BatchActionEnum action) throws BOSException, EASBizException {
        HashSet<IObjectPK> entryIdSet = new HashSet<IObjectPK>();
        entryIdSet.add(entryId);
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            MaterialRequestBillCollection coll = MaterialRequestBillFactory.getLocalInstance(ctx).getMaterialRequestBillCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    MaterialRequestBillInfo bill = coll.get(i);
                    MaterialRequestBillEntryCollection entryColl = (MaterialRequestBillEntryCollection)((Object)bill.getEntry().clone());
                    bill.getEntry().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        MaterialRequestBillEntryInfo entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        bill.getEntry().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)bill, (BatchActionEnum)action);
                }
            }
        }
    }

    private void writeLog(Context ctx, MaterialRequestBillEntryInfo entryInfo, boolean isClose) throws EASBizException, BOSException {
        int checkStatus;
        String resName = isClose ? "OPERATOR_CLOSE" : "OPERATOR_UNCLOSE";
        int n = checkStatus = isClose ? 4 : 7;
        if (checkStatus == entryInfo.getBaseStatus().getValue()) {
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), entryInfo.getParent().getRequestOrgUnit().getId().toString(), "_handleClose", "manual_default_logitem", "com.kingdee.eas.scm.im.inv.InvAddResource", resName, false, true);
        } else {
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), entryInfo.getParent().getRequestOrgUnit().getId().toString(), "_handleClose", "manual_default_logitem", "com.kingdee.eas.scm.im.inv.InvAddResource", resName, false, false);
        }
    }
}

