/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MaterialRequestImport
extends InvDataImport {
    MaterialRequestBillInfo materialRequestBillInfo = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private boolean IsHaveValue = false;
    private boolean IsError = false;
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    private AdminOrgUnitInfo adm = null;
    private CompanyOrgUnitInfo cou = null;
    private static final String[] ASSISTQTY_PROPERTY = new String[]{"assistQty", "approvedAssitQty"};
    private static final String[] QTY_PROPERTY = new String[]{"qty", "approvedQty"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL = new String[]{"FEntry_qty", "FEntry_assistQty", "FEntry_baseQty", "FEntry_quarityOverRate", "FEntry_quarityArreRate", "FEntry_approvedQty", "FEntry_approvedBaseQty", "FEntry_approvedAssitQty"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL_KEY = new String[]{"qty", "assistQty", "baseQty", "quarityOverRate", "quarityArreRate", "approvedQty", "approvedBaseQty", "approvedAssitQty"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String SPLIT_KEY = "$";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MaterialRequestBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.materialRequestBillInfo = null;
        int k = 0;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            block8: {
                Map lineData = (Map)hsData.get(new Integer(i));
                if (k == 0) {
                    try {
                        this.materialRequestBillInfo = this.transmitHead(lineData, ctx);
                        if (this.materialRequestBillInfo == null) {
                            return null;
                        }
                        this.afterBuildHead(ctx, this.materialRequestBillInfo, lineData);
                    }
                    catch (TaskExternalException ex) {
                        tex.addEntryErrorReason(i, ex.getMessage());
                        this.recycleNumber(ctx, this.materialRequestBillInfo);
                        break;
                    }
                }
                try {
                    MaterialRequestBillEntryInfo entryinfo = this.transmitEntry(lineData, ctx);
                    int seq = this.materialRequestBillInfo.getEntry().size() + 1;
                    entryinfo.setSeq(seq);
                    entryinfo.setParent(this.materialRequestBillInfo);
                    entryinfo.setCompanyOrgUnit(this.cou);
                    this.materialRequestBillInfo.getEntry().add(entryinfo);
                }
                catch (TaskExternalException ex) {
                    tex.addEntryErrorReason(i, ex.getMessage());
                    if (tex.getEntryErrorReasons().size() != 1) break block8;
                    this.recycleNumber(ctx, this.materialRequestBillInfo);
                }
            }
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.materialRequestBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private MaterialRequestBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.materialRequestBillInfo = new MaterialRequestBillInfo();
        Object data = null;
        String str = null;
        try {
            this.loadBizType(ctx, lineData, "number", "FBizType_number");
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        try {
            Object bizDate = ((DataToken)lineData.get((Object)"FBizDate")).data;
            if (bizDate == null || bizDate.toString().trim().length() <= 0) {
                throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"bizDateCanNotBeNull", (String)resources));
            }
            Date da = ImRptAppUtils.formatNationalDate(ctx, lineData.get("FBizDate").toString());
            this.materialRequestBillInfo.setBizDate(da);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        Object requstOrgNum = ((DataToken)lineData.get((Object)"FRequestOrgUnit_number")).data;
        if (requstOrgNum != null && requstOrgNum.toString().trim().length() > 0) {
            String orgNumber = requstOrgNum.toString().trim();
            AdminOrgUnitInfo requestOrg = null;
            try {
                requestOrg = this.getAdminOrgUnit(ctx, "number", orgNumber);
                if (requestOrg == null) {
                    throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"REQEUESTORG_NOT_EXISTS", (String)resources));
                }
                this.adm = requestOrg;
                this.materialRequestBillInfo.setRequestOrgUnit(requestOrg);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        } else {
            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"REQUESTORG_NOT_NULL", (String)resources));
        }
        try {
            String adminOrgId = this.adm.getId().toString();
            CompanyOrgUnitInfo companyOrgUnitInfo = this.dataPool.getCompanyOrgUnitInfo(adminOrgId);
            if (companyOrgUnitInfo == null) {
                OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminOrgId, 0, 1);
                if (orgCol == null || orgCol.size() == 0 || orgCol.get(0) == null) {
                    throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"NoCompanyOrgUnit", (String)resources));
                }
                companyOrgUnitInfo = (CompanyOrgUnitInfo)orgCol.get(0);
                this.dataPool.setCompanyOrgUnitInfo(adminOrgId, companyOrgUnitInfo);
            }
            this.cou = companyOrgUnitInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        data = ((DataToken)lineData.get((Object)"FRequestPerson_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            try {
                PersonInfo personInfo = this.dataPool.getPersonInfo(str);
                if (personInfo == null) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0");
                    viewInfo.setFilter(filter);
                    PersonCollection collection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
                    if (collection != null && collection.size() > 0 && collection.get(0) != null) {
                        personInfo = collection.get(0);
                        this.dataPool.setPersonInfo(str, personInfo);
                    }
                }
                this.materialRequestBillInfo.setRequestPerson(personInfo);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        this.materialRequestBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        Object description = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (description != null && description.toString().trim().length() > 0) {
            String DeTemp = (String)description;
            if (DeTemp.length() > 80) {
                DeTemp = DeTemp.substring(0, 80);
            }
            this.materialRequestBillInfo.setDescription(DeTemp);
        } else {
            this.materialRequestBillInfo.setDescription("");
        }
        if (this.materialRequestBillInfo.getBizType() != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(this.materialRequestBillInfo.getBizType().getId().toString())) {
            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"JUMP_COMPANY_CANNOT_IMPORT", (String)resources));
        }
        this.materialRequestBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.IsHaveValue = false;
        this.IsError = false;
        data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        UserInfo creator = this.getCreator(ctx, data);
        this.materialRequestBillInfo.setCreator(creator);
        this.IsHaveValue = false;
        this.IsError = false;
        this.materialRequestBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"XlazxwEREADgAAAEwKgSxUY+1VI="));
        aBillTypeInfo.setNumber("160");
        this.materialRequestBillInfo.setBillType(aBillTypeInfo);
        return this.materialRequestBillInfo;
    }

    private MaterialRequestBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        Object data;
        MaterialRequestBillEntryInfo entryInfo;
        block56: {
            ProjectCollection coll;
            ObjectUuidPK cuPK;
            CtrlUnitInfo cu;
            FilterInfo filter2;
            FilterInfo filter;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            String number;
            block55: {
                StorageOrgUnitInfo sou;
                MeasureUnitInfo mui;
                MaterialInfo materialInfo;
                block54: {
                    entryInfo = new MaterialRequestBillEntryInfo();
                    data = null;
                    String str = "";
                    materialInfo = new MaterialInfo();
                    mui = new MeasureUnitInfo();
                    Object materialCompanyInfo = null;
                    MaterialInventoryInfo materialInventory = null;
                    Object outmaterialInventory = null;
                    sou = null;
                    data = ((DataToken)lineData.get((Object)"FEntry$storageOrgUnit_number")).data;
                    if (data == null || data.toString().trim().length() <= 0) {
                        throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"StorageOrgUnitNotNull", (String)resources));
                    }
                    sou = this.getStorageOrgUnit(ctx, "number", data.toString().trim());
                    entryInfo.setStorageOrgUnit(sou);
                    data = ((DataToken)lineData.get((Object)"FEntry$receiveStorage_number")).data;
                    if (data != null && data.toString().trim().length() > 0) {
                        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(this.materialRequestBillInfo.getBizType().getId().toString()) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(this.materialRequestBillInfo.getBizType().getId().toString())) {
                            StorageOrgUnitInfo recSou = this.getStorageOrgUnit(ctx, "number", data.toString().trim());
                            entryInfo.setReceiveStorage(recSou);
                        } else {
                            entryInfo.setReceiveStorage(sou);
                        }
                    } else {
                        entryInfo.setReceiveStorage(sou);
                    }
                    data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
                    materialInfo = this.getMaterial(ctx, data, new OrgUnitInfo[]{entryInfo.getReceiveStorage(), entryInfo.getStorageOrgUnit(), this.cou});
                    materialInventory = this.getMaterialInventory(ctx, materialInfo, entryInfo.getReceiveStorage());
                    entryInfo.setMaterial(materialInfo);
                    try {
                        data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
                        if (this.checkLotInfo(materialInventory)) {
                            if (data == null || data.toString() == null || data.toString().trim().length() == 0) {
                                entryInfo.setLot(null);
                            } else {
                                entryInfo.setLot(data.toString().trim());
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw new TaskExternalException(ex.getMessage(), ex.getCause());
                    }
                    if (materialInventory.isIsPeriodValid()) {
                        String lot = ((DataToken)lineData.get((Object)"FEntry_lot")).data.toString();
                        Date[] mfgAndExp = this.getMfgAndExp(ctx, entryInfo.getMaterial(), lot, entryInfo.getReceiveStorage());
                        if (mfgAndExp != null) {
                            entryInfo.setMfg(mfgAndExp[0]);
                            entryInfo.setExp(mfgAndExp[1]);
                        }
                    }
                    this.checkNumberAndAmount(ctx, entryInfo, lineData, DECIMAL_ENTRY_PROPERTY_ALL, DECIMAL_ENTRY_PROPERTY_ALL_KEY, true);
                    try {
                        data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
                        if (data == null) {
                            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"UnitCanNotBeNull", (String)resources));
                        }
                        str = data.toString();
                        if (str == null || str.trim().length() == 0) {
                            throw new TaskExternalException(data.toString() + " " + MaterialRequestImport.getResource((Context)ctx, (String)"UnitCanNotBeNull", (String)resources));
                        }
                        MeasureUnitInfo measureUnitInfo = this.getMeasureUnitByNumber(ctx, str);
                        if (measureUnitInfo == null) {
                            throw new TaskExternalException(data.toString() + " " + MaterialRequestImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
                        }
                        this.checkUnit(ctx, materialInfo, measureUnitInfo);
                        entryInfo.setUnit(measureUnitInfo);
                        mui = measureUnitInfo;
                    }
                    catch (Exception ex) {
                        throw new TaskExternalException(ex.getMessage(), ex.getCause());
                    }
                    try {
                        entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                        if (entryInfo.getAssistUnit() != null) {
                            MultiMeasureUnitInfo assistMmu = this.getMultiAssistMeasureUnitInfo(ctx, materialInfo.getId().toString(), entryInfo.getAssistUnit().getId().toString());
                            if (assistMmu != null) {
                                int assistQtyPrecision = assistMmu.getQtyPrecision();
                                for (int i = 0; i < ASSISTQTY_PROPERTY.length; ++i) {
                                    if (entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i]) != null && entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i]).compareTo(ZERO) != 0 && entryInfo.getBigDecimal(QTY_PROPERTY[i]).compareTo(ZERO) != 0) {
                                        BigDecimal assistQty = entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i]).setScale(assistQtyPrecision, 4);
                                        assistQty = assistQty.compareTo(ZERO) < 0 ? assistQty.negate() : assistQty;
                                        entryInfo.setBigDecimal(ASSISTQTY_PROPERTY[i], assistQty);
                                        continue;
                                    }
                                    BigDecimal qty = entryInfo.getBigDecimal(QTY_PROPERTY[i]);
                                    BigDecimal assistQty = InvAppUtils.getMultiUnitQty(ctx, mui, entryInfo.getAssistUnit(), materialInfo, qty);
                                    assistQty = assistQty.compareTo(ZERO) < 0 ? assistQty.negate() : assistQty;
                                    entryInfo.setBigDecimal(ASSISTQTY_PROPERTY[i], assistQty);
                                }
                            }
                        } else {
                            for (int i = 0; i < ASSISTQTY_PROPERTY.length; ++i) {
                                entryInfo.setBigDecimal(ASSISTQTY_PROPERTY[i], ZERO);
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw new TaskExternalException(ex.getMessage(), ex.getCause());
                    }
                    try {
                        String number2;
                        data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
                        if (data == null || (number2 = data.toString()) == null || number2.trim().length() <= 0 || materialInfo == null || materialInfo.getAssistAttr() == null) break block54;
                        IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                        String oql = "";
                        oql = number2.indexOf("/") > 0 ? "select id,number,name where number='" + number2 + "' and compondingType.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "'" : "select id,number,name where number='" + number2 + "' and basictype.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "'";
                        AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(oql);
                        if (collection != null && collection.size() > 0) {
                            AsstAttrValueInfo info = collection.get(0);
                            if (info != null) {
                                entryInfo.setAssistProperty(info);
                            }
                            break block54;
                        }
                        throw new TaskExternalException(number2 + MaterialRequestImport.getResource((Context)ctx, (String)"AsstAttrValueExists", (String)resources));
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                data = ((DataToken)lineData.get((Object)"FEntry$productLine_number")).data;
                if (data != null && data.toString() != null && data.toString().length() > 0) {
                    ProductLineInfo productLine = this.getProductLineByNumberAndCheck(ctx, data.toString(), resources);
                    entryInfo.setProductLine(productLine);
                }
                data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
                WarehouseInfo warehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)sou, data, resources, "WarehouseNotActive", "WarehouseNotExists", null, "RelationNotExists");
                entryInfo.setWarehouse(warehouse);
                data = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
                if (data != null && data.toString().trim().length() > 0) {
                    String remark = data.toString().length() > 255 ? StringUtils.substring((String)data.toString(), (int)0, (int)255) : data.toString();
                    entryInfo.setRemark(remark);
                }
                try {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                    MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                    entryInfo.setBaseUnit(baseUnit);
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
                    entryInfo.setBaseQty(baseQty);
                    BigDecimal approvedQty = entryInfo.getApprovedQty();
                    BigDecimal approvedBaseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, approvedQty);
                    entryInfo.setApprovedBaseQty(approvedBaseQty);
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    if (null == lineData.get("FEntry$project_number") || (data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data) == null || (number = data.toString()) == null || number.trim().length() <= 0) break block55;
                    IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    status = new HashSet<Integer>();
                    status.add(new Integer(4));
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                    filter2 = new FilterInfo();
                    cu = null;
                    if (this.materialRequestBillInfo.getStorageOrgUnit() != null) {
                        cu = this.materialRequestBillInfo.getStorageOrgUnit().getCU();
                    }
                    cuPK = null;
                    cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                    try {
                        filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (filter2 != null) {
                        filter.mergeFilter(filter2, "and");
                    }
                    viewInfo.setFilter(filter);
                    coll = iProject.getProjectCollection(viewInfo);
                    if (coll != null && coll.size() > 0) {
                        ProjectInfo projectInfo = coll.get(0);
                        entryInfo.setProject(projectInfo);
                        break block55;
                    }
                    throw new TaskExternalException(data.toString() + " " + MaterialRequestImport.getResource((Context)ctx, (String)"PROJECT_NUMBER_ERROR", (String)resources));
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            try {
                if (null == lineData.get("FEntry$trackNumber_number") || (data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data) == null || (number = data.toString()) == null || number.trim().length() <= 0) break block56;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                status = new HashSet();
                status.add(new Integer(10));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                filter2 = new FilterInfo();
                cu = null;
                if (this.materialRequestBillInfo.getStorageOrgUnit() != null) {
                    cu = this.materialRequestBillInfo.getStorageOrgUnit().getCU();
                }
                cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    TrackNumberInfo trackNumberInfo = coll.get(0);
                    entryInfo.setTrackNumber(trackNumberInfo);
                    break block56;
                }
                throw new TaskExternalException(data.toString() + " " + MaterialRequestImport.getResource((Context)ctx, (String)"TRACK_NUMBER_ERROR", (String)resources));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        data = ((DataToken)lineData.get((Object)"FEntry_quarityUnCtrl")).data;
        if (data != null && data.toString().trim().length() > 0) {
            String quarityUnCtrl = data.toString().trim();
            if ("true".equalsIgnoreCase(quarityUnCtrl)) {
                entryInfo.setQuarityUnCtrl(true);
                entryInfo.setQuarityOverRate(ZERO);
                entryInfo.setQuarityArreRate(ZERO);
            } else {
                entryInfo.setQuarityUnCtrl(false);
            }
        }
        try {
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return entryInfo;
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + MaterialRequestImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("bizType.number") != null) {
                BizTypeInfo bizType = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo("select id where number='" + rs.getString("bizType.number") + "'");
                if (bizType != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizType.getId().toString())) {
                    throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"JUMP_COMPANY_CANNOT_IMPORT", (String)resources));
                }
                result.put("FBizType_number", rs.getString("bizType.number"));
            }
            if (rs.getString("number") != null) {
                result.put("FNumber", rs.getString("number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("requestOrgUnit.number") != null) {
                result.put("FRequestOrgUnit_number", rs.getString("requestOrgUnit.number"));
            }
            if (rs.getString("requestOrgUnit.name") != null) {
                result.put("FRequestOrgUnit_name_l1", rs.getString("requestOrgUnit.name"));
            }
            if (rs.getString("companyOrgUnit.number") != null) {
                result.put("FCompanyOrgUnit_number", rs.getString("companyOrgUnit.number"));
            }
            if (rs.getString("requestPerson.number") != null) {
                result.put("FRequestPerson_number", rs.getString("requestPerson.number"));
            }
            if (rs.getString("baseStatus") != null) {
                result.put("FBaseStatus", rs.getString("baseStatus"));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getString("receiveStorage.number") != null) {
                result.put("FEntry$receiveStorage_number", rs.getString("receiveStorage.number"));
            }
            if (rs.getString("storageOrgUnit.number") != null) {
                result.put("FEntry$storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l1", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("baseUnit.NUMBER") != null) {
                result.put("FEntry$baseUnit_number", rs.getString("baseUnit.NUMBER"));
            }
            if (rs.getString("ENTRY.baseQty") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.baseQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.baseQty")).toString().length() < 1) {
                    result.put("FEntry_baseQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.baseQty"));
                    result.put("FEntry_baseQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ASSISTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("Project.number") != null) {
                result.put("FEntry$project_number", rs.getString("Project.number"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("Creator.number") != null) {
                result.put("FCreator_number", rs.getString("Creator.number"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("productLine.number") != null) {
                result.put("FEntry$productLine_number", rs.getString("productLine.number"));
            }
            if (rs.getString("entry.quarityUnCtrl") != null) {
                result.put("FEntry_quarityUnCtrl", rs.getString("entry.quarityUnCtrl"));
            }
            if (rs.getString("entry.quarityOverRate") != null) {
                result.put("FEntry_quarityOverRate", rs.getString("entry.quarityOverRate"));
            }
            if (rs.getString("entry.quarityArreRate") != null) {
                result.put("FEntry_quarityArreRate", rs.getString("entry.quarityArreRate"));
            }
            if (rs.getString("entry.approvedQty") != null) {
                result.put("FEntry_approvedQty", rs.getString("entry.approvedQty"));
            }
            if (rs.getString("entry.approvedAssitQty") != null) {
                result.put("FEntry_approvedAssitQty", rs.getString("entry.approvedAssitQty"));
            }
            if (rs.getString("entry.approvedBaseQty") != null) {
                result.put("FEntry_approvedBaseQty", rs.getString("entry.approvedBaseQty"));
            }
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception Ex) {
            Logger.error((Throwable)Ex);
            throw new TaskExternalException(Ex.getMessage(), (Throwable)Ex);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.MaterialRequestDataImportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        Object collection = null;
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    private boolean checkLotInfo(MaterialInventoryInfo materialInventoryInfo) throws TaskExternalException, BOSException, EASBizException {
        if (materialInventoryInfo != null) {
            return materialInventoryInfo.isIsLotNumber();
        }
        return false;
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + MaterialRequestImport.getResource((Context)ctx, (String)"RelationNotExists", (String)resources));
        }
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialRequestImport.getResource((Context)ctx, (String)"NotSetAssistProperty", (String)resources));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialRequestImport.getResource((Context)ctx, (String)"SetAssistProperty", (String)resources));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialRequestImport.getResource((Context)ctx, (String)"NotSetAssistUnit", (String)resources));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + MaterialRequestImport.getResource((Context)ctx, (String)"SetAssistUnit", (String)resources));
            }
        }
    }

    private void loadBizType(Context ctx, Map lineData, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        BizTypeInfo bizType = this.getBizType(ctx, "XlazxwEREADgAAAEwKgSxUY+1VI=", byProperty, souData);
        this.materialRequestBillInfo.setBizType(bizType);
    }

    private void checkNumberAndAmount(Context ctx, MaterialRequestBillEntryInfo entryInfo, Map lineData, String[] checkList, String[] setList, boolean checkBackType) throws TaskExternalException {
        for (int i = 0; i < checkList.length; ++i) {
            try {
                Object o = ((DataToken)lineData.get((Object)checkList[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = ImRptAppUtils.getDataDeciaml(ctx, o.toString());
                    this.checkRateColumn(ctx, value, setList[i]);
                    if (value == null) {
                        if (setList[i].equalsIgnoreCase("approvedQty")) {
                            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"APPROVEDQTY_NOT_NULL", (String)resources));
                        }
                        entryInfo.setBigDecimal(setList[i], ZERO);
                    }
                    entryInfo.setBigDecimal(setList[i], value);
                    continue;
                }
                if (setList[i].equalsIgnoreCase("approvedQty")) {
                    throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"APPROVEDQTY_NOT_NULL", (String)resources));
                }
                entryInfo.setBigDecimal(setList[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(checkList[i] + MaterialRequestImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
            }
        }
    }

    private void checkRateColumn(Context ctx, BigDecimal value, String field) throws TaskExternalException {
        if (StringUtils.equals((CharSequence)field, (CharSequence)"quarityOverRate") && ZERO.compareTo(value) > 0) {
            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"QuarityOverRateNotCorrect", (String)resources));
        }
        if (StringUtils.equals((CharSequence)field, (CharSequence)"quarityArreRate") && (ZERO.compareTo(value) > 0 || value.compareTo(new BigDecimal(100)) > 0)) {
            throw new TaskExternalException(MaterialRequestImport.getResource((Context)ctx, (String)"QuarityArreRateNotCorrect", (String)resources));
        }
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = MaterialRequestImport.getMulUnit(ctx, mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = MaterialRequestImport.getMulUnit(ctx, baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public String getImportPermissionItem() {
        return "materialRequest_new";
    }
}

