/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.validator.beanvalidation.PropertyValidationException;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MoveLocationBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveLocationBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMoveLocationBillControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Locale;

public class MoveLocationBillControllerBean
extends AbstractMoveLocationBillControllerBean {
    private static final long serialVersionUID = 8927699917881981279L;
    protected String invAddResource = "com.kingdee.eas.scm.im.inv.InvAddResource";

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.fillEntryData(ctx, model);
        return super._save(ctx, model);
    }

    private void fillEntryData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectValue entry = null;
        MaterialInfo material = null;
        MeasureUnitInfo assistUnit = null;
        MoveLocationBillInfo info = (MoveLocationBillInfo)model;
        IObjectCollection entryColl = info.getEntries();
        StorageOrgUnitInfo sou = info.getStorageOrgUnit();
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(sou.getId());
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entry = entryColl.getObject(i);
            info.getEntry().get(i).setStorageOrgUnit(sou);
            info.getEntry().get(i).setCompanyOrgUnit(cou);
            material = (MaterialInfo)entry.getObjectValue("material");
            if (material == null || (assistUnit = material.getAssistUnit()) == null) continue;
            if (entry.get("assistUnit") == null) {
                entry.put("assistUnit", (Object)assistUnit);
            }
            if (entry.get("assistQty") != null) continue;
            entry.put("assistQty", (Object)BigDecimal.ZERO);
        }
    }

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected void updateInventory(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo, BizActionEnum bizAction) throws EASBizException, BOSException {
        InventoryUpdateFactory.getLocalInstance((Context)ctx).updateInventory(pk.toString(), bizAction);
    }

    @Override
    protected String getAuditPermissionItem() {
        return "movelocation_audit";
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.fillEntryData(ctx, model);
        MoveLocationBillInfo info = (MoveLocationBillInfo)model;
        this.checkForSubmit(ctx, info);
        return super._submit(ctx, model);
    }

    @Override
    protected void _submitInBatch(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MoveLocationBillInfo info = (MoveLocationBillInfo)model;
        this._submit(ctx, (IObjectValue)info);
    }

    private void checkForSubmit(Context ctx, MoveLocationBillInfo info) throws BOSException, EASBizException {
        this.checkStatus4Submit(ctx, (IObjectValue)info);
        MeasureUnitInfo unit = null;
        WarehouseInfo warehouse = null;
        LocationInfo location = null;
        LocationInfo InLocation = null;
        StoreTypeInfo storeType = null;
        StoreStateInfo storeState = null;
        PersonInfo stocker = null;
        StringBuffer errors = new StringBuffer();
        BigDecimal qty = new BigDecimal(0);
        BigDecimal qtyZero = new BigDecimal(0);
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            MoveLocationBillEntryInfo entryInfo = info.getEntry().get(i);
            warehouse = entryInfo.getWarehouse();
            location = entryInfo.getLocation();
            InLocation = entryInfo.getReceiptLocation();
            storeType = entryInfo.getStoreType();
            storeState = entryInfo.getStoreStatus();
            unit = entryInfo.getUnit();
            stocker = entryInfo.getStocker();
            qty = entryInfo.getQty();
            if (unit == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"UNIT_IS_NOYNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (warehouse == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"WAREHOUSE_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (location == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"LOCATION_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (InLocation == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"INLOCATION_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (storeType == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"STOREYPE_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (storeState == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"STORESTATE_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (stocker == null) {
                errors.append(ResourceBase.getString((String)this.invAddResource, (String)"STOCKER_IS_NOTNULL", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (InLocation != null && location != null && InLocation.getId().equals((Object)location.getId())) {
                errors.append(ResourceUtil.getMessage((String)this.invAddResource, (String)"InLocationEqualIssueLocation", (String[])new String[]{String.valueOf(i + 1)}));
                errors.append("\r\n");
            }
            if (qty.compareTo(qtyZero) != 0) continue;
            errors.append(ResourceBase.getString((String)this.invAddResource, (String)"QtyGreaterZero", (Locale)ctx.getLocale(), (Object[])new String[]{String.valueOf(i + 1)}));
            errors.append("\r\n");
        }
        if (errors.length() > 0) {
            throw new PropertyValidationException(PropertyValidationException.VALIDATEFAILD, new Object[]{errors});
        }
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
        if (!CollectionUtil.isEmpty((IObjectCollection)collection)) {
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setNumber("120");
            billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e001-1152c0a812fd463ED552"));
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue object = collection.getObject(i);
                if (!(object instanceof MoveLocationBillInfo)) continue;
                MoveLocationBillInfo info = (MoveLocationBillInfo)object;
                info.setBillType(billTypeInfo);
            }
        }
    }

    private void checkStatus4Submit(Context ctx, IObjectValue info) throws EASBizException, BOSException {
        this._checkAudit(ctx, info, true);
        this._checkClosed(ctx, info, true);
        this._checkDeleted(ctx, info, true);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
        if (model == null) {
            model = this.getSCMBillBaseInfo(ctx, pk, this.getSelector());
        }
        MoveLocationBillInfo bill = (MoveLocationBillInfo)model;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK companyPk = new ObjectUuidPK(bill.getEntry().get(0).getCompanyOrgUnit().getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo cou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPk, sic);
        String calType = ipc.getParamValue((IObjectPK)companyPk, "SCM_CAL_002");
        BigDecimal minValueByScale = RecentCostHelp.getMinValueByScale((int)cou.getBaseCurrency().getPrecision(), (int)1);
        StringBuffer standardUpdateSql = new StringBuffer();
        StringBuffer moveUpdateSql = new StringBuffer();
        standardUpdateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select ").append(" case when ROUND(T.FBASEQTY*matCon.FSTANDARDCOST,CURRENCY.FPRECISION) = 0 then ROUND(").append(minValueByScale).append("/T.FQTY, mat.FPRICEPRECISION)").append(" else Round(ROUND(T.FBASEQTY*matCon.FSTANDARDCOST,CURRENCY.FPRECISION)/T.FQTY, mat.FPRICEPRECISION) end, ").append(" case when ROUND(T.FBASEQTY*matCon.FSTANDARDCOST,CURRENCY.FPRECISION) = 0 then ").append(minValueByScale).append(" else ROUND(T.FBASEQTY*matCon.FSTANDARDCOST,CURRENCY.FPRECISION) end").append(" from T_IM_MOVELOCATIONBILLENTRY entry inner join T_IM_MOVELOCATIONBILL bill on entry.FPARENTID = bill.FID ").append(" inner join T_IM_STORETYPE store on entry.FSTORETYPEID = store.FID ").append(" inner join T_BD_MATERIAL mat on mat.FID = entry.FMATERIALID ").append(" inner join T_BD_MATERIALCOMPANYINFO matCon on matCon.FMATERIALID = entry.FMATERIALID and matCon.FCOMPANYID = entry.FCOMPANYORGUNITID ").append(" INNER JOIN T_ORG_Company AS COMPANY ON entry.FCompanyOrgUnitID = COMPANY.FID").append(" inner join T_BD_Currency AS CURRENCY ON COMPANY.FBaseCurrencyID = CURRENCY.FID").append(" where T.FID = entry.FID and matCon.FACCOUNTTYPE = 2 and store.FISFORWARDAMT = 1 ");
        moveUpdateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select ").append(" case when ROUND(T.FBASEQTY*cost.FPRICE,CURRENCY.FPRECISION) = 0 then ROUND(").append(minValueByScale).append("/T.FQTY,mat.FPRICEPRECISION)").append(" else Round(ROUND(T.FBASEQTY*cost.FPRICE,CURRENCY.FPRECISION)/T.FQTY,mat.FPRICEPRECISION) end, ").append(" case when ROUND(T.FBASEQTY*cost.FPRICE,CURRENCY.FPRECISION) = 0 then ").append(minValueByScale).append(" else ROUND(T.FBASEQTY*cost.FPRICE,CURRENCY.FPRECISION) end ").append(" from T_IM_MOVELOCATIONBILLENTRY entry inner join T_IM_MOVELOCATIONBILL bill on entry.FPARENTID = bill.FID ").append(" inner join T_BD_MATERIAL mat on mat.FID = entry.FMATERIALID ").append(" inner join T_IM_STORETYPE store on entry.FSTORETYPEID = store.FID ").append(" inner join T_BD_MATERIALCOMPANYINFO matCon on matCon.FMATERIALID = entry.FMATERIALID and matCon.FCOMPANYID = entry.FCOMPANYORGUNITID ").append(" inner join T_CL_RecentCost cost on cost.FMATERIALID = entry.FMATERIALID and cost.FCOMPANYORGUNITID = entry.FCOMPANYORGUNITID ").append(" INNER JOIN T_ORG_Company AS COMPANY ON entry.FCompanyOrgUnitID = COMPANY.FID").append(" inner join T_BD_Currency AS CURRENCY ON COMPANY.FBaseCurrencyID = CURRENCY.FID").append(" where T.FID = entry.FID and matCon.FACCOUNTTYPE = 1 and store.FISFORWARDAMT = 1 ");
        StringBuffer sql = new StringBuffer();
        int sqlSize = bill.getEntry().size() * 2 > 500 ? 500 : bill.getEntry().size() * 2;
        String[] updateSqls = new String[sqlSize];
        int updateCount = 0;
        int size = bill.getEntry().size();
        for (int i = 0; i < size; ++i) {
            MoveLocationBillEntryInfo entryInfo = bill.getEntry().get(i);
            sql.setLength(0);
            sql.append(standardUpdateSql);
            sql.append(" and entry.fid='").append(entryInfo.getId()).append("' ");
            sql.append(")");
            updateSqls[updateCount++] = sql.toString();
            sql.setLength(0);
            sql.append(moveUpdateSql);
            sql.append(" and entry.fid='").append(entryInfo.getId()).append("' ");
            if ("2".equals(calType)) {
                if (entryInfo.getStorageOrgUnit() != null && entryInfo.getStorageOrgUnit().getId() != null) {
                    sql.append(" AND cost.FSTORAGEORGUNITID = '").append(entryInfo.getStorageOrgUnit().getId()).append("' ");
                }
                if (entryInfo.getWarehouse() != null && entryInfo.getWarehouse().getId() != null) {
                    sql.append(" AND cost.FWAREHOUSEID = '").append(entryInfo.getWarehouse().getId()).append("' ");
                }
            }
            sql.append(" )");
            updateSqls[updateCount++] = sql.toString();
            if (updateCount <= 500) continue;
            DBUtil.execute((Context)ctx, (String[])updateSqls);
            updateCount = 0;
            updateSqls = new String[sqlSize];
        }
        if (updateCount > 0) {
            DBUtil.execute((Context)ctx, (String[])updateSqls);
        }
    }
}

