/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferFacade;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.ITransferRule2;
import com.kingdee.eas.scm.im.inv.ITransferRule3;
import com.kingdee.eas.scm.im.inv.ITransferRule4;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferException;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferFacadeFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Collection;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.im.inv.TransferRule3Collection;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Collection;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMultiSidesTransferFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.SupplyRelationServerUtils;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class MultiSidesTransferFacadeControllerBean
extends AbstractMultiSidesTransferFacadeControllerBean {
    private static final long serialVersionUID = -8034832589109702688L;

    @Override
    protected IObjectCollection _getTransferRuleCollection(Context ctx, String supplyRelationID) throws BOSException, EASBizException {
        ITransferRule4 itf4;
        ITransferRule3 itf3;
        TransferRuleCollection transferRules = new TransferRuleCollection();
        EntityViewInfo evi = this.getEntityViewInfo(supplyRelationID);
        FilterInfo fi = evi.getFilter();
        ITransferRule2 itf2 = TransferRule2Factory.getLocalInstance(ctx);
        if (itf2.exists(fi)) {
            TransferRule2Collection tr2c = itf2.getTransferRule2Collection(evi);
            TransferRule2Info tr2 = tr2c.get(0);
            tr2 = itf2.getTransferRule2Info((IObjectPK)new ObjectUuidPK(tr2.getId()), tr2.getSelectorItemCollection());
            transferRules.add(tr2);
        }
        if ((itf3 = TransferRule3Factory.getLocalInstance(ctx)).exists(fi)) {
            TransferRule3Collection tr3c = itf3.getTransferRule3Collection(evi);
            TransferRule3Info tr3 = tr3c.get(0);
            tr3 = itf3.getTransferRule3Info((IObjectPK)new ObjectUuidPK(tr3.getId()), tr3.getSelectorItemCollection());
            transferRules.add(tr3);
        }
        if ((itf4 = TransferRule4Factory.getLocalInstance(ctx)).exists(fi)) {
            TransferRule4Collection tr4c = itf4.getTransferRule4Collection(evi);
            TransferRule4Info tr4 = tr4c.get(0);
            tr4 = itf4.getTransferRule4Info((IObjectPK)new ObjectUuidPK(tr4.getId()), tr4.getSelectorItemCollection());
            transferRules.add(tr4);
        }
        return transferRules;
    }

    private EntityViewInfo getEntityViewInfo(String supplyRelationID) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("supplyRelation", (Object)supplyRelationID, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        return evi;
    }

    @Override
    protected Map _save(Context ctx, IObjectValue supplyRelatinInfo, IObjectCollection transferRules) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> map = new HashMap<String, IObjectPK>();
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        IObjectPK pkSupplyRelation = null;
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelatinInfo;
        if (sri.getId() != null) {
            pkSupplyRelation = new ObjectUuidPK(sri.getId());
            isr.update(pkSupplyRelation, (CoreBaseInfo)supplyRelatinInfo);
        } else {
            pkSupplyRelation = isr.save((CoreBaseInfo)supplyRelatinInfo);
        }
        map.put("supplyRelationPK", pkSupplyRelation);
        sri.setId(BOSUuid.read((String)map.get("supplyRelationPK").toString()));
        TransferRuleInfo tri = null;
        for (int i = 0; i < transferRules.size(); ++i) {
            IObjectPK pk;
            tri = (TransferRuleInfo)transferRules.getObject(i);
            tri.getSupplyRelation().setId(BOSUuid.read((String)pkSupplyRelation.getKeyValue("id").toString()));
            if (tri.getBizType().getId().toString().equals("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
                pk = null;
                ITransferRule2 itr2 = TransferRule2Factory.getLocalInstance(ctx);
                if (tri.getId() != null) {
                    pk = new ObjectUuidPK(tri.getId());
                    itr2.update((IObjectPK)new ObjectUuidPK(tri.getId()), tri);
                } else {
                    pk = itr2.save(tri);
                }
                map.put("transferRule2PK", pk);
                tri.setId(BOSUuid.read((String)map.get("transferRule2PK").toString()));
                continue;
            }
            if (tri.getBizType().getId().toString().equals("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=")) {
                pk = null;
                ITransferRule3 itr3 = TransferRule3Factory.getLocalInstance(ctx);
                if (tri.getId() != null) {
                    pk = new ObjectUuidPK(tri.getId());
                    itr3.update((IObjectPK)new ObjectUuidPK(tri.getId()), tri);
                } else {
                    pk = itr3.save(tri);
                }
                map.put("transferRule3PK", pk);
                tri.setId(BOSUuid.read((String)map.get("transferRule3PK").toString()));
                continue;
            }
            if (tri.getBizType().getId().toString().equals("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=")) {
                pk = null;
                ITransferRule4 itr4 = TransferRule4Factory.getLocalInstance(ctx);
                if (tri.getId() != null) {
                    pk = new ObjectUuidPK(tri.getId());
                    itr4.update((IObjectPK)new ObjectUuidPK(tri.getId()), tri);
                } else {
                    pk = itr4.save(tri);
                }
                map.put("transferRule4PK", pk);
                tri.setId(BOSUuid.read((String)map.get("transferRule4PK").toString()));
                continue;
            }
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"42_MultiSidesTransferFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return map;
    }

    @Override
    protected void _activeTransferRule(Context ctx, IObjectValue transferRuleInfo, IObjectValue supplyRelationInfo) throws BOSException, EASBizException {
        TransferRuleInfo tri = (TransferRuleInfo)transferRuleInfo;
        ITransferRule itr = null;
        if (tri.getBizType().getId().toString().equals("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            this.verifyBeforeActiveFor2(ctx, supplyRelationInfo);
            itr = TransferRule2Factory.getLocalInstance(ctx);
        } else if (tri.getBizType().getId().toString().equals("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=")) {
            this.verifyBeforeActiveFor3(ctx, supplyRelationInfo);
            itr = TransferRule3Factory.getLocalInstance(ctx);
        } else if (tri.getBizType().getId().toString().equals("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=")) {
            this.verifyBeforeActiveFor4(ctx, supplyRelationInfo);
            itr = TransferRule4Factory.getLocalInstance(ctx);
        }
        tri.setStatus(UseStatusEnum.ACTIVE);
        if (itr != null) {
            itr.update((IObjectPK)new ObjectUuidPK(tri.getId()), tri);
        }
    }

    private void verifyBeforeActiveFor2(Context ctx, IObjectValue supplyRelationInfo) throws BOSException, EASBizException {
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelationInfo;
        Map[] paramsSupplier = new Map[1];
        Map[] paramsCustomer = new Map[1];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("internalcompanyorg", sri.getIssueCompanyOrgUnit());
        map.put("controlunit", sri.getReceiveCompanyOrgUnit().getCU());
        paramsSupplier[0] = map;
        this._checkInnerSuppliers(ctx, paramsSupplier);
        map = new HashMap();
        map.put("internalcompanyorg", sri.getReceiveCompanyOrgUnit());
        map.put("controlunit", sri.getIssueCompanyOrgUnit().getCU());
        paramsCustomer[0] = map;
        this._checkInnerCustomers(ctx, paramsCustomer);
    }

    private void verifyBeforeActiveFor3(Context ctx, IObjectValue supplyRelationInfo) throws BOSException, EASBizException {
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelationInfo;
        Map[] paramsSupplier = new Map[2];
        Map[] paramsCustomer = new Map[2];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("internalcompanyorg", sri.getIssueCompanyOrgUnit());
        map.put("controlunit", sri.getSupplyCompanyOrgUnit().getCU());
        paramsSupplier[0] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getSupplyCompanyOrgUnit());
        map.put("controlunit", sri.getReceiveCompanyOrgUnit().getCU());
        paramsSupplier[1] = map;
        this._checkInnerSuppliers(ctx, paramsSupplier);
        map = new HashMap();
        map.put("internalcompanyorg", sri.getReceiveCompanyOrgUnit());
        map.put("controlunit", sri.getSupplyCompanyOrgUnit().getCU());
        paramsCustomer[0] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getSupplyCompanyOrgUnit());
        map.put("controlunit", sri.getIssueCompanyOrgUnit().getCU());
        paramsCustomer[1] = map;
        this._checkInnerCustomers(ctx, paramsCustomer);
    }

    private void verifyBeforeActiveFor4(Context ctx, IObjectValue supplyRelationInfo) throws BOSException, EASBizException {
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelationInfo;
        Map[] paramsSupplier = new Map[3];
        Map[] paramsCustomer = new Map[3];
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("internalcompanyorg", sri.getIssueCompanyOrgUnit());
        map.put("controlunit", sri.getSupplyCompanyOrgUnit().getCU());
        paramsSupplier[0] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getSupplyCompanyOrgUnit());
        map.put("controlunit", sri.getRequireCompanyOrgUnit().getCU());
        paramsSupplier[1] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getRequireCompanyOrgUnit());
        map.put("controlunit", sri.getReceiveCompanyOrgUnit().getCU());
        paramsSupplier[2] = map;
        this._checkInnerSuppliers(ctx, paramsSupplier);
        map = new HashMap();
        map.put("internalcompanyorg", sri.getReceiveCompanyOrgUnit());
        map.put("controlunit", sri.getRequireCompanyOrgUnit().getCU());
        paramsCustomer[0] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getRequireCompanyOrgUnit());
        map.put("controlunit", sri.getSupplyCompanyOrgUnit().getCU());
        paramsCustomer[1] = map;
        map = new HashMap();
        map.put("internalcompanyorg", sri.getSupplyCompanyOrgUnit());
        map.put("controlunit", sri.getIssueCompanyOrgUnit().getCU());
        paramsCustomer[2] = map;
        this._checkInnerCustomers(ctx, paramsCustomer);
    }

    @Override
    protected void _inactiveTransferRule(Context ctx, IObjectValue transferRuleInfo) throws BOSException, EASBizException {
        TransferRuleInfo tri = (TransferRuleInfo)transferRuleInfo;
        if (!tri.getStatus().equals((Object)UseStatusEnum.ACTIVE)) {
            throw new MultiSidesTransferException(MultiSidesTransferException.INACTIVENOTISACTIVE);
        }
        ITransferRule itr = null;
        if (tri.getBizType().getId().toString().equals("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
            itr = TransferRule2Factory.getLocalInstance(ctx);
        } else if (tri.getBizType().getId().toString().equals("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=")) {
            itr = TransferRule3Factory.getLocalInstance(ctx);
        } else if (tri.getBizType().getId().toString().equals("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=")) {
            itr = TransferRule4Factory.getLocalInstance(ctx);
        }
        tri.setStatus(UseStatusEnum.INACTIVE);
        if (itr != null) {
            itr.update((IObjectPK)new ObjectUuidPK(tri.getId()), tri);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectValue supplyRelatinInfo) throws BOSException, EASBizException {
        this.verifyStatusBeforeDelete(ctx, supplyRelatinInfo);
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelatinInfo;
        FilterInfo fi = this.getEntityViewInfo(sri.getId().toString()).getFilter();
        ITransferRule2 itr2 = TransferRule2Factory.getLocalInstance(ctx);
        itr2.delete(fi);
        ITransferRule3 itr3 = TransferRule3Factory.getLocalInstance(ctx);
        itr3.delete(fi);
        ITransferRule4 itr4 = TransferRule4Factory.getLocalInstance(ctx);
        itr4.delete(fi);
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        isr.delete((IObjectPK)new ObjectUuidPK(sri.getId()));
    }

    private void verifyStatusBeforeDelete(Context ctx, IObjectValue supplyRelatinInfo) throws BOSException, EASBizException {
        boolean var = true;
        SupplyRelationInfo sri = (SupplyRelationInfo)supplyRelatinInfo;
        IMultiSidesTransferFacade ims = MultiSidesTransferFacadeFactory.getLocalInstance(ctx);
        TransferRuleCollection transferRules = ims.getTransferRuleCollection(sri.getId().toString());
        if (transferRules != null) {
            for (int i = 0; i < transferRules.size(); ++i) {
                TransferRule4Info transferRule4Info;
                if (transferRules.get(i).getBizType().getId().toString().equals("d8e80652-0117-1000-e000-04c5c0a812202407435C")) {
                    TransferRule2Info transferRule2Info = (TransferRule2Info)transferRules.get(i);
                    if (!transferRule2Info.getStatus().equals((Object)UseStatusEnum.ACTIVE)) continue;
                    var = false;
                    continue;
                }
                if (transferRules.get(i).getBizType().getId().toString().equals("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=")) {
                    TransferRule3Info transferRule3Info = (TransferRule3Info)transferRules.get(i);
                    if (!transferRule3Info.getStatus().equals((Object)UseStatusEnum.ACTIVE)) continue;
                    var = false;
                    continue;
                }
                if (!transferRules.get(i).getBizType().getId().toString().equals("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=") || !(transferRule4Info = (TransferRule4Info)transferRules.get(i)).getStatus().equals((Object)UseStatusEnum.ACTIVE)) continue;
                var = false;
            }
        }
        if (!var) {
            throw new MultiSidesTransferException(MultiSidesTransferException.HASACTIVESTATUS);
        }
    }

    private EntityViewInfo getEntityViewInfo(String[] supplyRelationID, String bizTypeId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        HashSet<String> srIdSet = new HashSet<String>(supplyRelationID.length);
        int length = supplyRelationID.length;
        for (int i = 0; i < length; ++i) {
            if (supplyRelationID[i] == null) continue;
            srIdSet.add(supplyRelationID[i]);
        }
        if (srIdSet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("supplyRelation", srIdSet, CompareType.INCLUDE));
        } else {
            fi.appendFilterItem("bizType", (Object)"nonexistdsupplyrealtionId");
        }
        fi.appendFilterItem("bizType", (Object)bizTypeId);
        evi.setFilter(fi);
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            evi.getSelector().addObjectCollection((IObjectCollection)new TransferRule2Info().getSelectorItemCollection());
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            evi.getSelector().addObjectCollection((IObjectCollection)new TransferRule3Info().getSelectorItemCollection());
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            evi.getSelector().addObjectCollection((IObjectCollection)new TransferRule4Info().getSelectorItemCollection());
        }
        return evi;
    }

    @Override
    protected Map _getTransferRuleInfos(Context ctx, String[] srIds, String bizTypeId) throws BOSException, EASBizException {
        HashMap<String, TransferRuleInfo> map = new HashMap<String, TransferRuleInfo>(srIds.length);
        if (bizTypeId == null) {
            return map;
        }
        int length = srIds.length;
        for (int i = 0; i < length; ++i) {
            if (srIds[i] == null) continue;
            map.put(srIds[i] + bizTypeId, null);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizCategory.id"));
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeId), sic);
        TransferRuleCollection col = SupplyRelationServerUtils.getTransferRuleByBizCategoryId(ctx, bizTypeInfo.getBizCategory().getId().toString()).getTransferRuleCollection(this.getEntityViewInfo(srIds, bizTypeId));
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            map.put(col.get(i).getSupplyRelation().getId().toString() + bizTypeId, col.get(i));
        }
        return map;
    }

    @Override
    protected IObjectValue _getTransferRuleInfo(Context ctx, String supplyRelationID, String bizTypeID) throws BOSException, EASBizException {
        ITransferRule4 itf4;
        TransferRule4Collection tr4c;
        TransferRule4Info tr4;
        ITransferRule3 itf3;
        TransferRule3Collection tr3c;
        TransferRule3Info tr3;
        ITransferRule2 itf2;
        TransferRule2Collection tr2c;
        TransferRule2Info tr2;
        TransferRuleInfo tri = null;
        EntityViewInfo evi = this.getEntityViewInfo(supplyRelationID);
        if (bizTypeID.equals("d8e80652-0117-1000-e000-04c5c0a812202407435C") && (tr2 = (tr2c = (itf2 = TransferRule2Factory.getLocalInstance(ctx)).getTransferRule2Collection(evi)).get(0)) != null) {
            tri = tr2 = itf2.getTransferRule2Info((IObjectPK)new ObjectUuidPK(tr2.getId()), tr2.getSelectorItemCollection());
        }
        if (bizTypeID.equals("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=") && (tr3 = (tr3c = (itf3 = TransferRule3Factory.getLocalInstance(ctx)).getTransferRule3Collection(evi)).get(0)) != null) {
            tr3 = itf3.getTransferRule3Info((IObjectPK)new ObjectUuidPK(tr3.getId()), tr3.getSelectorItemCollection());
            tri = tr3;
        }
        if (bizTypeID.equals("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=") && (tr4 = (tr4c = (itf4 = TransferRule4Factory.getLocalInstance(ctx)).getTransferRule4Collection(evi)).get(0)) != null) {
            tr4 = itf4.getTransferRule4Info((IObjectPK)new ObjectUuidPK(tr4.getId()), tr4.getSelectorItemCollection());
            tri = tr4;
        }
        return tri;
    }

    @Override
    protected void _checkInnerCustomers(Context ctx, Map[] params) throws BOSException, EASBizException {
        if (params == null || params.length == 0) {
            return;
        }
        CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[params.length];
        CtrlUnitInfo[] cuInfos = new CtrlUnitInfo[params.length];
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            couInfos[i] = (CompanyOrgUnitInfo)params[i].get("internalcompanyorg");
            cuInfos[i] = (CtrlUnitInfo)params[i].get("controlunit");
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(2);
        map.put("internalcompanyorg", couInfos);
        map.put("controlunit", cuInfos);
        this._checkInnerCustomer(ctx, map);
    }

    @Override
    protected void _checkInnerCustomer(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        ICustomer iCus = CustomerFactory.getLocalInstance((Context)ctx);
        iCus.createCustomerByTransfer(param);
    }

    @Override
    protected void _checkInnerSuppliers(Context ctx, Map[] params) throws BOSException, EASBizException {
        if (params == null || params.length == 0) {
            return;
        }
        CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[params.length];
        CtrlUnitInfo[] cuInfos = new CtrlUnitInfo[params.length];
        int length = params.length;
        for (int i = 0; i < length; ++i) {
            couInfos[i] = (CompanyOrgUnitInfo)params[i].get("internalcompanyorg");
            cuInfos[i] = (CtrlUnitInfo)params[i].get("controlunit");
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(2);
        map.put("internalcompanyorg", couInfos);
        map.put("controlunit", cuInfos);
        this._checkInnerSupplier(ctx, map);
    }

    @Override
    protected void _checkInnerSupplier(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null) {
            return;
        }
        ISupplier iSup = SupplierFactory.getLocalInstance((Context)ctx);
        iSup.createSupplierByTransfer(param);
    }
}

