/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrices;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesCollection;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesInfo;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractMultiSidesTransferPricesControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiSidesTransferPricesControllerBean
extends AbstractMultiSidesTransferPricesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.MultiSidesTransferPricesControllerBean");
    private static final BigDecimal zero = new BigDecimal("0.00");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _saveByPriceInfo(Context ctx, List list, IObjectValue model) throws BOSException, EASBizException {
        PriceInfo priceInfo = null;
        if (list == null) return;
        if (list.size() <= 0) return;
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)model;
        TransferOrderBillEntryInfo entryInfo = null;
        PreparedStatement addStmt = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            stmt.execute("delete from T_IM_MultiSidesTransferPrices where FTransferBillId = '" + billInfo.getId() + "'");
            StringBuffer sql = new StringBuffer("insert into T_IM_MultiSidesTransferPrices");
            sql.append("(FID,FTransferBillID,FTransferBillEntryID,FSupplyRelationID,FBizRole,FTaxRate");
            sql.append(",FDiscountType,FDiscountRate,FPrice,FActualPrcie,FTaxPrice,FActualTaxPrice)");
            sql.append("values (?,?,?,?,?,?,?,?,?,?,?,?)");
            addStmt = conn.prepareStatement(sql.toString());
            int stmtSize = 0;
            int size = list.size();
            for (int i = 0; i < size; ++i, ++stmtSize) {
                priceInfo = (PriceInfo)list.get(i);
                if (priceInfo != null && !(entryInfo = billInfo.getEntry().get(i % billInfo.getEntry().size())).isIsPresent() && entryInfo.getSupplyRelation() != null && priceInfo.getBizRoleType() != null) {
                    addStmt.setString(1, BOSUuid.create((String)"31C6DAB6").toString());
                    addStmt.setString(2, billInfo.getId().toString());
                    addStmt.setString(3, entryInfo.getId().toString());
                    addStmt.setString(4, entryInfo.getSupplyRelation().getId().toString());
                    addStmt.setInt(5, priceInfo.getBizRoleType().getValue());
                    addStmt.setBigDecimal(6, entryInfo.getTaxRate());
                    if (priceInfo.getPrice() == null || priceInfo.getPrice().compareTo(zero) <= 0) {
                        addStmt.setInt(7, entryInfo.getDiscountType().getValue());
                        addStmt.setBigDecimal(8, entryInfo.getDiscountRate());
                        addStmt.setBigDecimal(9, entryInfo.getPrice());
                        addStmt.setBigDecimal(10, entryInfo.getActualPrice());
                        addStmt.setBigDecimal(11, entryInfo.getTaxPrice());
                        addStmt.setBigDecimal(12, entryInfo.getActualTaxPrice());
                    } else {
                        addStmt.setInt(7, priceInfo.getDiscountType().getValue());
                        addStmt.setBigDecimal(8, priceInfo.getDiscountRate());
                        addStmt.setBigDecimal(9, priceInfo.getPrice());
                        addStmt.setBigDecimal(10, priceInfo.getActualPrice());
                        addStmt.setBigDecimal(11, priceInfo.getTaxPrice());
                        addStmt.setBigDecimal(12, priceInfo.getActualTaxPrice());
                    }
                    addStmt.addBatch();
                }
                if (stmtSize <= 500) continue;
                stmtSize = 0;
                addStmt.executeBatch();
                addStmt.clearBatch();
            }
            addStmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException(e.getCause());
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.cleanup(stmt);
                    SQLUtils.cleanup(addStmt);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new BOSException(e2.getCause());
                }
            }
        }
        try {
            SQLUtils.cleanup((Statement)stmt);
            SQLUtils.cleanup((Statement)addStmt);
            SQLUtils.cleanup((Connection)conn);
            return;
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
    }

    @Override
    protected Map _getPriceInfos(Context ctx, String[] coreBillEntryIDs, String companyOrgUnitID, String billTypeNO, String bizTypeID) throws BOSException, EASBizException {
        HashMap<String, MultiSidesTransferPricesInfo> map = new HashMap<String, MultiSidesTransferPricesInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        IMultiSidesTransferPrices ims = MultiSidesTransferPricesFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = evi.getSelector();
        selector.add("*");
        selector.add("supplyRelation.issueCompanyOrgUnit");
        selector.add("supplyRelation.receiveCompanyOrgUnit");
        selector.add("supplyRelation.requireCompanyOrgUnit");
        selector.add("supplyRelation.supplyCompanyOrgUnit");
        FilterInfo fi = new FilterInfo();
        String strIdLists = BOTMappingHelper.objectArray2String((Object[])coreBillEntryIDs, (String)",");
        fi.getFilterItems().add(new FilterItemInfo("transferBillEntry", (Object)strIdLists, CompareType.INCLUDE));
        evi.setFilter(fi);
        MultiSidesTransferPricesCollection infos = ims.getMultiSidesTransferPricesCollection(evi);
        block0: for (int i = 0; i < coreBillEntryIDs.length; ++i) {
            map.put(coreBillEntryIDs[i], null);
            for (int j = 0; j < infos.size(); ++j) {
                MultiSidesTransferPricesInfo priceinfo = infos.get(j);
                if (priceinfo == null || priceinfo.getTransferBillEntry() == null || priceinfo.getSupplyRelation() == null || !priceinfo.getTransferBillEntry().getId().toString().equals(coreBillEntryIDs[i])) continue;
                BizRoleTypeEnum roletype = this.getPriceType(priceinfo.getSupplyRelation(), billTypeNO, bizTypeID, companyOrgUnitID);
                if (!priceinfo.getBizRole().equals((Object)roletype)) continue;
                map.put(coreBillEntryIDs[i], priceinfo);
                continue block0;
            }
        }
        return map;
    }

    private BizRoleTypeEnum getBizRoleType(String bizTypeID, SupplyRelationInfo supplyRelationInfo, String companyOrgUnitID) {
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
            if (supplyRelationInfo.getReceiveCompanyOrgUnit().getId().toString().equals(companyOrgUnitID)) {
                return BizRoleTypeEnum.ReceiveSide;
            }
            if (supplyRelationInfo.getIssueCompanyOrgUnit().getId().toString().equals(companyOrgUnitID)) {
                return BizRoleTypeEnum.IssueSide;
            }
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
            if (supplyRelationInfo.getReceiveCompanyOrgUnit().getId().toString().equals(companyOrgUnitID)) {
                return BizRoleTypeEnum.ReceiveSide;
            }
            if (supplyRelationInfo.getSupplyCompanyOrgUnit().getId().toString().equals(companyOrgUnitID)) {
                return BizRoleTypeEnum.SupplySide;
            }
            if (supplyRelationInfo.getIssueCompanyOrgUnit().getId().toString().equals(companyOrgUnitID)) {
                return BizRoleTypeEnum.IssueSide;
            }
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
            if (companyOrgUnitID.equals(supplyRelationInfo.getRequireCompanyOrgUnit().getId().toString())) {
                return BizRoleTypeEnum.RequireSide;
            }
            if (companyOrgUnitID.equals(supplyRelationInfo.getReceiveCompanyOrgUnit().getId().toString())) {
                return BizRoleTypeEnum.ReceiveSide;
            }
            if (companyOrgUnitID.equals(supplyRelationInfo.getSupplyCompanyOrgUnit().getId().toString())) {
                return BizRoleTypeEnum.SupplySide;
            }
            if (companyOrgUnitID.equals(supplyRelationInfo.getIssueCompanyOrgUnit().getId().toString())) {
                return BizRoleTypeEnum.IssueSide;
            }
        }
        return null;
    }

    private BizRoleTypeEnum getPriceType(SupplyRelationInfo supplyRelationInfo, String billTypeNo, String bizTypeID, String companyOrgUnitID) {
        BizRoleTypeEnum bizRoleType = this.getBizRoleType(bizTypeID, supplyRelationInfo, companyOrgUnitID);
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
            if ("102".equals(billTypeNo)) {
                return BizRoleTypeEnum.IssueSide;
            }
            if ("103".equals(billTypeNo)) {
                return BizRoleTypeEnum.IssueSide;
            }
            if ("1001".equals(billTypeNo)) {
                return BizRoleTypeEnum.IssueSide;
            }
            if ("2001".equals(billTypeNo)) {
                return BizRoleTypeEnum.IssueSide;
            }
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
            if ("102".equals(billTypeNo)) {
                if (BizRoleTypeEnum.IssueSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
            } else if ("103".equals(billTypeNo)) {
                if (BizRoleTypeEnum.ReceiveSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
            } else if ("1001".equals(billTypeNo)) {
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.IssueSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
            } else if ("2001".equals(billTypeNo)) {
                if (BizRoleTypeEnum.ReceiveSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
            }
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
            if ("102".equals(billTypeNo)) {
                if (BizRoleTypeEnum.IssueSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.RequireSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.RequireSide;
                }
            } else if ("103".equals(billTypeNo)) {
                if (BizRoleTypeEnum.ReceiveSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.RequireSide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
                if (BizRoleTypeEnum.RequireSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.RequireSide;
                }
            } else if ("1001".equals(billTypeNo)) {
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.IssueSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
                if (BizRoleTypeEnum.RequireSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.RequireSide;
                }
            } else if ("2001".equals(billTypeNo)) {
                if (BizRoleTypeEnum.RequireSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.SupplySide;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.IssueSide;
                }
                if (BizRoleTypeEnum.ReceiveSide.equals((Object)bizRoleType)) {
                    return BizRoleTypeEnum.RequireSide;
                }
            }
        }
        return null;
    }
}

