/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.ncm.common.NCMCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.im.inv.IOtherIssueBillEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillAgent;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractOtherInWarehsBillControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OtherInWarehsBillControllerBean
extends AbstractOtherInWarehsBillControllerBean {
    private static final long serialVersionUID = 7995874962327588061L;

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        OtherInWarehsBillInfo aOtherInWarehsBillInfo = null;
        aOtherInWarehsBillInfo = isUseAgent ? OtherInWarehsBillAgent.create() : new OtherInWarehsBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        aOtherInWarehsBillInfo.setBizDate(curDate);
        aOtherInWarehsBillInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return aOtherInWarehsBillInfo;
    }

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        OtherInWarehsBillInfo bill = this.getOtherInWarehsBillInfo(ctx, pk, selector);
        if (bill != null && bill.getSourceBillType() != null && "50957179-0105-1000-e004-4152c0a812fd463ED552".equals(bill.getSourceBillType().getId().toString())) {
            throw new InvBizException(InvBizException.COUNT_NOREMOVE, new String[]{bill.getNumber()});
        }
        super._delete(ctx, pk);
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.dealBillCost(ctx, model);
        super.update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dealBillCost(Context ctx, CoreBaseInfo model) throws BOSException {
        OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
        OtherInWarehsBillEntryInfo entry = null;
        OtherInWarehsBillEntryCollection entries = info.getEntry();
        BigDecimal totalActualCost = new BigDecimal("0.00");
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" from T_IM_OtherInWarehsBill bill");
        bf.append(" inner join T_IM_OtherInWarehsBillEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            BigDecimal actualCost;
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            int length = entries.size();
            for (int i = 0; i < length; totalActualCost = totalActualCost.add(actualCost), ++i) {
                entry = entries.get(i);
                actualCost = null != entry.getActualCost() ? entry.getActualCost() : new BigDecimal("0.00");
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : new BigDecimal("0.00");
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                pm.setString(1, entry.getId().toString());
                rs = pm.executeQuery();
                if (!rs.next()) continue;
                BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                entry.setReverseQty(reverseQty);
                entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pm, (Connection)conn);
    }

    @Override
    protected void _deleteNocheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._deleteNoCheck(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherInWarehsBillInfo bill = (OtherInWarehsBillInfo)model;
        if (bill.getId() != null) {
            boolean isCountingBill = false;
            if (bill.getTransactionType() != null) {
                TransactionTypeInfo aTransactionTypeInfo = bill.getTransactionType();
                if (bill.getSourceBillType() == null) {
                    ITransactionType iTransactionType = TransactionTypeFactory.getLocalInstance((Context)ctx);
                    aTransactionTypeInfo = iTransactionType.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(aTransactionTypeInfo.getId()));
                }
                if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("50957179-0105-1000-e004-4152c0a812fd463ED552")) {
                    isCountingBill = true;
                }
            }
            if (isCountingBill) {
                throw new InvBizException(InvBizException.BILL_REMOVEBYCOUNT);
            }
        }
        this.handleDataForSmartCalculate(ctx, bill, true);
        return super._addnew(ctx, model);
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-017bc0a812fd463ED552";
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
        if (info.getSourceBillType() != null && "50957179-0105-1000-e000-888880a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            return true;
        }
        return super._checkUnAuditInParam(ctx, (IObjectValue)info);
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue model = collection.getObject(i);
            OtherInWarehsBillInfo otherInwarehsBillInfo = (OtherInWarehsBillInfo)model;
            try {
                this.checkCalcBizDate(ctx, otherInwarehsBillInfo);
                this.calByUnitSource(ctx, otherInwarehsBillInfo, (IObjectCollection)otherInwarehsBillInfo.getEntry());
                this.initBotpData(ctx, model);
                OtherInWarehsBillInfo info = (OtherInWarehsBillInfo)model;
                if (info == null) continue;
                this.setCostItemInfoOfEntry(ctx, info);
                continue;
            }
            catch (Exception e) {
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
        }
    }

    public void checkCalcBizDate(Context ctx, OtherInWarehsBillInfo bill) throws BOSException, EASBizException {
        if (this.isSpecialChangeBill(bill.getSourceBillType().getId().toString())) {
            IOtherIssueBillEntry iOtherIssueBillEntry = OtherIssueBillEntryFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.year"));
            sic.add(new SelectorItemInfo("parent.period"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)bill.getEntry().get(0).getSourceBillId()));
            view.setSelector(sic);
            view.setFilter(filterInfo);
            OtherIssueBillEntryCollection coll = iOtherIssueBillEntry.getOtherIssueBillEntryCollection(view);
            if (coll.size() > 0 && bill.getYear() * 100 + bill.getPeriod() < coll.get(0).getParent().getYear() * 100 + coll.get(0).getParent().getPeriod()) {
                throw new SCMBillException(SCMBillException.CHANGE_PERIOD_ERROR);
            }
        }
    }

    public boolean isSpecialChangeBill(String billTypeId) {
        return "50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeId) || "CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(billTypeId) || "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(billTypeId);
    }

    public void handleDataForSmartCalculate(Context ctx, OtherInWarehsBillInfo bill, boolean isAudit) throws BOSException, EASBizException {
    }

    public String convertIdSet2String(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        ids.append("(");
        for (String s : idSet) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        ids.append(")");
        return ids.toString();
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getOtherInWarehsBillSelector((boolean)true);
    }

    private void setCostItemInfoOfEntry(Context ctx, OtherInWarehsBillInfo info) throws EASBizException, BOSException {
        Set keys;
        if (info == null || info.getStorageOrgUnit() == null) {
            return;
        }
        OtherInWarehsBillEntryInfo entry = null;
        MaterialInfo materialInfo = null;
        ArrayList<String> materialIds = new ArrayList<String>();
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            entry = info.getEntry().get(i);
            materialInfo = entry.getMaterial();
            materialIds.add(materialInfo.getId().toString());
        }
        Map costItemInfos = null;
        if (materialIds != null && info.getStorageOrgUnit() != null) {
            costItemInfos = NCMCommonFacadeFactory.getLocalInstance((Context)ctx).getCostItemInfoByMatIDs(info.getStorageOrgUnit(), materialIds);
        }
        if (costItemInfos != null && (keys = costItemInfos.keySet()) != null) {
            Iterator iterator = keys.iterator();
            block1: while (iterator.hasNext()) {
                String key = iterator.next().toString();
                String materialId = null;
                int n2 = info.getEntry().size();
                for (int i = 0; i < n2; ++i) {
                    materialId = info.getEntry().get(i).getMaterial().getId().toString();
                    if (!materialId.equals(key)) continue;
                    CostItemInfo value = (CostItemInfo)costItemInfos.get(key);
                    info.getEntry().get(i).setCostItem(value);
                    continue block1;
                }
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        OtherInWarehsBillInfo info = this.getOtherInWarehsBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        OtherInWarehsBillInfo info = this.getOtherInWarehsBillInfo(ctx, pk, this.getSelector());
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        OtherInWarehsBillInfo info = this.getOtherInWarehsBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _innerUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        OtherInWarehsBillInfo info = this.getOtherInWarehsBillInfo(ctx, pk, this.getSelector());
        info.put("innerAudit", true);
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
        this.handleDataForSmartCalculate(ctx, info, false);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        OtherInWarehsBillEntryInfo otherInwarehsBillEntryInfo = (OtherInWarehsBillEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = otherInwarehsBillEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = otherInwarehsBillEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = otherInwarehsBillEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)otherInwarehsBillEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)otherInwarehsBillEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        otherInwarehsBillEntryInfo.setQty(qty);
        OtherInWarehsBillInfo otherInwarehsBillInfo = (OtherInWarehsBillInfo)scmBillBaseInfo;
        this.reCalCost4UnitSource(ctx, otherInwarehsBillInfo, otherInwarehsBillEntryInfo, sourceUnitId);
    }

    @Override
    protected boolean _isFromMatAttrChangeBill(Context ctx, Set idSet) throws BOSException {
        HashSet<String> bizTypeSet = new HashSet<String>();
        bizTypeSet.add("kXeVPjE9chDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeVPjF4chDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeVPjGzchDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeUoXWkByTgQKjAYj1F6CQHQ1w=");
        bizTypeSet.add("kXeUoXXfByTgQKjAYj1F6CQHQ1w=");
        bizTypeSet.add("kXeVPjHuchDgQKjAYj1RYCQHQ1w=");
        try {
            String sql = "select fid from t_im_otherinwarehsbill where fid in (" + this.convertSetToStr(idSet) + ") and fbiztypeid in (" + this.convertSetToStr(bizTypeSet) + ")";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, null);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        return false;
    }

    private String convertSetToStr(Set set) {
        String str = "";
        for (Object obj : set) {
            str = str + "'" + obj.toString() + "',";
        }
        str = str.substring(0, str.lastIndexOf(","));
        return str;
    }

    private String getMd5CalKey(Context ctx, String calType, String materialId, String couId, String souId, String warehouseId, String lot, String assistPropertyId, String projectId, String trackNumberId, Map matComMap) throws NoSuchAlgorithmException, BOSException, SQLException {
        String insertSql = "insert into T_CL_CalculateKeyMapping(fid,FMD5Key,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) values (newbosid('243A15B2'),?,?,?,?,?,?,?,?)";
        Object[] param = new String[8];
        StringBuffer calKey = new StringBuffer();
        if ("0".equals(calType)) {
            calKey.append(couId);
            param[1] = couId;
        } else if ("1".equals(calType)) {
            calKey.append(couId).append(souId);
            param[1] = couId;
            param[2] = souId;
        } else if ("2".equals(calType)) {
            calKey.append(couId).append(souId).append(warehouseId);
            param[1] = couId;
            param[2] = souId;
            param[3] = warehouseId;
        }
        if (matComMap.get(materialId) != null) {
            HashMap specialCalKeyMap = (HashMap)matComMap.get(materialId);
            if (Integer.parseInt(specialCalKeyMap.get("FISLOT").toString()) == 1) {
                calKey.append(lot);
                param[4] = lot;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISASSISTPROPERTY").toString()) == 1) {
                calKey.append(assistPropertyId);
                param[5] = assistPropertyId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISPROJECT").toString()) == 1) {
                calKey.append(projectId);
                param[6] = projectId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISTRACKNUMBER").toString()) == 1) {
                calKey.append(trackNumberId);
                param[7] = trackNumberId;
            }
        }
        String md5Key = BalanceUtil.getMd5((String)calKey.toString());
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)("select count(1) count from T_CL_CalculateKeyMapping where FMD5Key = '" + md5Key + "'"));
        while (result.next()) {
            if (result.getInt("count") != 0) continue;
            param[0] = md5Key;
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])param);
        }
        return md5Key;
    }
}

