/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractOtherInWarehsBillEditUIHandler;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class OtherInWarehsBillEditUIHandler
extends AbstractOtherInWarehsBillEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)request.getValue();
            this.fillParamValue(request, response, context);
            this.fillSaleOrgBySou(request, response, context);
            if (ivbInfo != null && ivbInfo.get("currency") != null) {
                ObjectUuidPK pk = new ObjectUuidPK(((CurrencyInfo)ivbInfo.get("currency")).getId());
                CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)pk);
            }
            this.fillTransactionCollection(request, response, context);
            this.fillInitFiledProperty(request, response, context);
            this.fillPersonalParam(request, response, context);
            this.fillCostCenterOrgUnitSet(request, response, context);
        }
    }

    @Override
    protected void _handleactionOffset(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void fillTransactionType(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        super.fillTransactionType(request, response, ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("riType.bizDirection"));
        InvBillBaseInfo invInfo = (InvBillBaseInfo)request.getValue();
        if (invInfo != null && invInfo.getTransactionType() != null && invInfo.getTransactionType().getId() != null) {
            TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(invInfo.getTransactionType().getId()), sic);
        } else {
            InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552");
        }
    }

    private void fillSaleOrgBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)request.getValue();
        StorageOrgUnitInfo souInfo = ivbInfo.getStorageOrgUnit();
        if (souInfo != null && souInfo.getId() != null) {
            SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(souInfo.getId().toString());
        }
    }

    private void fillParamValue(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        InvBillBaseInfo invInfo = (InvBillBaseInfo)request.getValue();
        String souId = (String)request.get("STORAGE_ORGUNIT_ID");
        if ((invInfo == null || invInfo.getStorageOrgUnit() == null) && souId == null) {
            return;
        }
        String souPk = souId == null ? invInfo.getStorageOrgUnit().getId().toString() : souId;
        ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(souPk), "INM120");
    }

    private void fillSaleOrgColBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)request.getValue();
        StorageOrgUnitInfo souInfo = ivbInfo.getStorageOrgUnit();
        if (souInfo != null && souInfo.getId() != null) {
            OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(souInfo.getId().toString(), 4, 2);
        }
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.createNewData(request, response, context);
        boolean isUseAgent = Boolean.TRUE.equals(request.get("isUseAgent"));
        OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)OtherInWarehsBillFactory.getLocalInstance(context).createNewData(isUseAgent);
        ivbInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        request.setValue((CoreBaseInfo)ivbInfo);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        this.fillAdminOrgUnitInfo(ivbInfo.getStorageOrgUnit(), response, context);
        this.fillSaleOrgBySou(request, response, context);
        this.fillSaleOrgColBySou(request, response, context);
        this.fillPrimaryAdminOrgUnit(request, response, context);
        this.fillCostCenterOrgUnitSet(request, response, context);
        this.fillParamValue(request, response, context);
        this.fillLocalCurrency(request, response, context);
        return request.getValue();
    }

    private void fillTransactionCollection(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String bizTypeID = null;
        String srcBillTypeID = null;
        OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)request.getValue();
        if (ivbInfo.getBizType() != null && ivbInfo.getSourceBillType() != null) {
            bizTypeID = ivbInfo.getBizType().getId().toString();
            srcBillTypeID = ivbInfo.getSourceBillType().getId().toString();
        }
        if (bizTypeID != null && srcBillTypeID != null) {
            TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection("50957179-0105-1000-e000-017bc0a812fd463ED552", bizTypeID);
        }
        InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552");
        StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6")));
    }

    private void fillInitFiledProperty(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        OtherInWarehsBillInfo siInfo = (OtherInWarehsBillInfo)request.getValue();
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        } else {
            if (siInfo.getStorageOrgUnit() == null) {
                return;
            }
            cou = InvServerUtils.getCompanyInfoForStorage(ctx, siInfo.getStorageOrgUnit());
        }
        ArrayList<MaterialInfo> materials = new ArrayList<MaterialInfo>();
        OtherInWarehsBillEntryCollection entries = siInfo.getEntry();
        int rows = entries.size();
        if (rows > 0 && cou != null) {
            for (int i = 0; i < rows; ++i) {
                MaterialInfo mi = entries.get(i).getMaterial();
                if (mi == null) continue;
                materials.add(mi);
            }
            if (materials.size() > 0) {
                StringBuffer oqlWhere = new StringBuffer();
                oqlWhere.append("select id,mateial.id,company.id where ");
                oqlWhere.append("mateial.id  in(");
                int size = materials.size();
                for (int i = 0; i < size; ++i) {
                    if (StringUtils.isEmpty((String)((MaterialInfo)materials.get(i)).getId().toString())) continue;
                    oqlWhere.append("'").append(((MaterialInfo)materials.get(i)).getId().toString()).append("',");
                }
                oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
                oqlWhere.append(")");
                oqlWhere.append(" and company.id = '").append(cou.getId().toString()).append("' ");
                SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getMaterialCompanyCollection(oqlWhere.toString());
            }
        }
    }

    private void fillPersonalParam(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String osql = "where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection(osql);
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='returnOlnyRecord'");
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='f7CapitalSensitiveQuery'");
    }

    private void fillCostCenterOrgUnitSet(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null && cou.getId() != null) {
            OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(cou.getId().toString(), 1, 5);
        }
        AdminOrgUnitInfo primaryAdmin = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            primaryAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(userInfo.getPerson().getId());
        }
        if (null != primaryAdmin && null != primaryAdmin.getId()) {
            OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(primaryAdmin.getId().toString(), 0, 5);
        }
    }

    private void fillPrimaryAdminOrgUnit(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        OtherInWarehsBillInfo ivbInfo = (OtherInWarehsBillInfo)request.getValue();
        StorageOrgUnitInfo souInfo = ivbInfo.getStorageOrgUnit();
        UserInfo user = (UserInfo)request.get("CurrentUser");
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitInfo primaryAdmin = null;
        if (user.getPerson() != null && user.getPerson().getId() != null) {
            primaryAdmin = iPerson.getPrimaryAdminOrgUnit(user.getPerson().getId());
        }
        if (primaryAdmin != null && souInfo != null && souInfo.getId() != null) {
            IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            iOrgUnitRel.getFromUnit(souInfo.getId().toString(), 0, 5);
        }
    }
}

