/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OtherInWarehsBillImport
extends InvDataImport {
    OtherInWarehsBillInfo otherInWarehsBillInfo = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    StorageOrgUnitInfo sou = null;
    TransactionTypeInfo tti = null;
    CompanyOrgUnitInfo cou = null;
    String[] STRING_FIELDS = new String[]{"FNumber", "FTransactionType_number", "FStorageOrgUnit_number", "FCostCenterOrgUnit_number", "FAdminOrgUnit_number", "FEntry$material_number", "FEntry$assistProperty_number", "FEntry$material_model", "FEntry$costObject_number", "FEntry$costItem_number", "FEntry$unit_number", "FEntry$assistUnit_number", "FEntry$storeType_number", "FEntry$storeStatus_number", "FEntry$warehouse_number", "FEntry$stocker_number", "FEntry$location_number", "FEntry$customer_number", "FEntry$supplier_number", "FEntry_remark", "FEntry$project_number", "FEntry$trackNumber_number", "FDescription"};
    String[] DATE_FIELDS = new String[]{"FBizDate", "FEntry_mfg", "FEntry_exp"};
    String[] STRING_FIELDS_EN = new String[]{"FTransactionType_name_l2", "FStorageOrgUnit_name_l2", "FEntry$material_name_l2", "FEntry$costObject_name_l2", "FEntry$costObjectSuite_name_l2", "FEntry$costItem_name_l2"};
    String[] BIGDECIMAL_FIELDS = new String[]{"FEntry_qty", "FEntry_unitStandardCost", "FEntry_unitActualCost"};
    String[] INTEGER_FIELDS = new String[]{"FEntry_lot"};
    String[] BOOLEAN_FIELDS = new String[]{"FEntry_isPresent"};
    private static final String[] QTY_PROPERTY = new String[]{"qty"};
    private static final String[] ASSISTQTY_PROPERTY = new String[]{"assistQty"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL = new String[]{"FEntry_qty", "FEntry_assistQty", "FEntry_unitActualCost", "FEntry_actualCost"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL_KEY = new String[]{"qty", "assistQty", "unitActualCost", "actualCost"};
    private static final String[] ENTRY_QTY_AMOUNT_FIELDS = new String[]{"qty", "assistQty", "baseQty", "reverseQty", "reverseBaseQty", "returnsQty", "returnBaseQty", "amount", "actualCost", "standardCost"};
    private static final String[] ENTRY_PRICE_FIELDS = new String[]{"price", "unitActualCost", "unitStandardCost"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherInWarehsBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.otherInWarehsBillInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.otherInWarehsBillInfo = this.transmitHead(lineData, ctx);
                    if (this.otherInWarehsBillInfo == null) {
                        return null;
                    }
                    this.afterBuildHead(ctx, this.otherInWarehsBillInfo, lineData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.otherInWarehsBillInfo);
                    break;
                }
            }
            try {
                OtherInWarehsBillEntryInfo entryinfo = this.transmitEntry(lineData, ctx);
                int seq = this.otherInWarehsBillInfo.getEntry().size() + 1;
                entryinfo.setSeq(seq);
                entryinfo.setParent(this.otherInWarehsBillInfo);
                entryinfo.setStorageOrgUnit(this.sou);
                entryinfo.setCompanyOrgUnit(this.cou);
                this.afterBuildEntry(ctx, this.otherInWarehsBillInfo, entryinfo, lineData);
                this.otherInWarehsBillInfo.getEntry().add(entryinfo);
                continue;
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.otherInWarehsBillInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.otherInWarehsBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private OtherInWarehsBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.otherInWarehsBillInfo = new OtherInWarehsBillInfo();
        Object data = null;
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-017bc0a812fd463ED552"));
        aBillTypeInfo.setNumber("109");
        this.otherInWarehsBillInfo.setBillType(aBillTypeInfo);
        Object descriptionObj = lineData.get("FDescription");
        if (null != descriptionObj && descriptionObj instanceof DataToken) {
            Object description = ((DataToken)descriptionObj).data;
            if (description != null && description.toString().trim().length() > 0) {
                String DeTemp = (String)description;
                if (DeTemp.length() > 255) {
                    DeTemp = DeTemp.substring(0, 255);
                }
                this.otherInWarehsBillInfo.setDescription(DeTemp);
            } else {
                this.otherInWarehsBillInfo.setDescription("");
            }
        } else {
            this.otherInWarehsBillInfo.setDescription("");
        }
        data = ((DataToken)lineData.get((Object)"FStorageOrgUnit_number")).data;
        this.sou = this.getStorageOrgUnit(ctx, "number", data);
        this.otherInWarehsBillInfo.setStorageOrgUnit(this.sou);
        BizTypeInfo bizType = null;
        try {
            data = ((DataToken)lineData.get((Object)"FBizType_number")).data;
            bizType = this.getBizType(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552", "number", data);
        }
        catch (TaskExternalException e) {
            data = ((DataToken)lineData.get((Object)"FBizType_name_l2")).data;
            bizType = this.getBizType(ctx, "50957179-0105-1000-e000-017bc0a812fd463ED552", "name", data);
        }
        this.otherInWarehsBillInfo.setBizType(bizType);
        try {
            data = ((DataToken)lineData.get((Object)"FTransactionType_number")).data;
            this.otherInWarehsBillInfo.setTransactionType(this.getTransaction(ctx, "number", data, aBillTypeInfo.getId().toString(), bizType));
        }
        catch (TaskExternalException e) {
            data = ((DataToken)lineData.get((Object)"FTransactionType_name_l2")).data;
            this.otherInWarehsBillInfo.setTransactionType(this.getTransaction(ctx, "name", data, aBillTypeInfo.getId().toString(), bizType));
        }
        this.otherInWarehsBillInfo.setCU(this.sou.getCU());
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        Object bizdate = null;
        bizdate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (bizdate == null || bizdate.toString().length() <= 0) {
            throw new TaskExternalException(OtherInWarehsBillImport.getResource((Context)ctx, (String)"bizDateCanNotBeNull", (String)resources));
        }
        bizdate = ImRptAppUtils.formatNationalDate(ctx, bizdate.toString());
        this.otherInWarehsBillInfo.setBizDate((Date)bizdate);
        this.otherInWarehsBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        this.otherInWarehsBillInfo.setCreator(this.getCreator(ctx, data));
        Date date = new Date();
        this.otherInWarehsBillInfo.setCreateTime(new Timestamp(date.getTime()));
        this.otherInWarehsBillInfo.setYear(2999);
        this.otherInWarehsBillInfo.setPeriod(1);
        data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        this.otherInWarehsBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, "number", data));
        return this.otherInWarehsBillInfo;
    }

    private OtherInWarehsBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        OtherInWarehsBillEntryInfo entryInfo = new OtherInWarehsBillEntryInfo();
        Object data = null;
        String str = "";
        MaterialInfo materialInfo = new MaterialInfo();
        MaterialCompanyInfoInfo materialCompanyInfo = null;
        data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        materialInfo = this.getMaterial(ctx, data, new OrgUnitInfo[0]);
        entryInfo.setMaterial(materialInfo);
        materialCompanyInfo = this.getMaterialCompany(ctx, materialInfo, this.cou);
        data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
        if (this.checkLotInfo(ctx, materialInfo, this.sou)) {
            if (data == null || data.toString().length() == 0) {
                throw new TaskExternalException(materialInfo.getNumber() + OtherInWarehsBillImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
            }
            entryInfo.setLot(data.toString().trim());
        } else {
            entryInfo.setLot(null);
        }
        data = ((DataToken)lineData.get((Object)"FEntry_mfg")).data;
        Object exp = ((DataToken)lineData.get((Object)"FEntry_exp")).data;
        Date[] date = this.getMfgAndExp(ctx, materialInfo, entryInfo.getLot(), this.sou, data, exp);
        if (date != null) {
            entryInfo.setMfg(date[0]);
            entryInfo.setExp(date[1]);
        }
        data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        MeasureUnitInfo mui = this.getMeasureUnit(ctx, data, materialInfo);
        entryInfo.setUnit(mui);
        entryInfo.setAssistUnit(materialInfo.getAssistUnit());
        this.checkNumberAndAmount(entryInfo, ctx, lineData, DECIMAL_ENTRY_PROPERTY_ALL, DECIMAL_ENTRY_PROPERTY_ALL_KEY, true);
        if (entryInfo.getAssistUnit() != null && (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(ZERO) == 0)) {
            BigDecimal qty = entryInfo.getQty();
            try {
                BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty(ctx, mui, entryInfo.getAssistUnit(), materialInfo, qty);
                entryInfo.setAssistQty(assisqtyQty);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        entryInfo.setAssistProperty(this.getAsstAttr(ctx, data, materialInfo.getAssistAttr()));
        data = ((DataToken)lineData.get((Object)"FEntry$costObject_number")).data;
        if (data != null) {
            entryInfo.setCostObject(this.getCostObject(ctx, this.cou, data));
        }
        data = ((DataToken)lineData.get((Object)"FEntry$costObjectSuite_number")).data;
        entryInfo.setCostObjectSuite(this.getCostObjectSuite(ctx, data));
        data = ((DataToken)lineData.get((Object)"FEntry$costItem_number")).data;
        entryInfo.setCostItem(this.getCostItem(ctx, data));
        data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
        if (data == null || data.toString() == null || data.toString().length() <= 0) {
            throw new TaskExternalException(OtherInWarehsBillImport.getResource((Context)ctx, (String)"WarehouseNotExists", (String)resources));
        }
        entryInfo.setWarehouse(this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data));
        data = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
        entryInfo.setStocker(this.getStocker(ctx, data));
        data = ((DataToken)lineData.get((Object)"FEntry$location_number")).data;
        entryInfo.setLocation(this.getLocation(ctx, data, entryInfo.getWarehouse()));
        data = ((DataToken)lineData.get((Object)"FEntry$customer_number")).data;
        entryInfo.setCustomer(this.getCustomer(ctx, data));
        data = ((DataToken)lineData.get((Object)"FEntry$supplier_number")).data;
        entryInfo.setSupplier(this.getSupplier(ctx, "number", data));
        for (int i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_FIELDS[i], DataImportUtils.getBooleanValue((Object)value, (boolean)false));
        }
        entryInfo.setIsPresent(entryInfo.getBoolean(this.BOOLEAN_FIELDS[0]));
        Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (o != null && o.toString().trim().length() > 0) {
            String remark = o.toString().trim();
            if (remark.length() > 255) {
                remark = remark.substring(0, 255);
            }
            entryInfo.setRemark(remark);
        }
        this.doEntryFilesByRI(entryInfo);
        if ((entryInfo.getUnitActualCost().compareTo(ZERO) != 0 || entryInfo.getActualCost().compareTo(ZERO) != 0) && entryInfo.getQty() != null) {
            BigDecimal unitActualCost = entryInfo.getUnitActualCost();
            BigDecimal actualCost = entryInfo.getActualCost();
            BigDecimal qty = entryInfo.getQty();
            int localPrecision = 0;
            if (this.cou.getBaseCurrency() == null) {
                CompanyOrgUnitInfo couTemp = null;
                try {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("baseCurrency.id"));
                    sic.add(new SelectorItemInfo("baseCurrency.number"));
                    sic.add(new SelectorItemInfo("baseCurrency.name"));
                    sic.add(new SelectorItemInfo("baseCurrency.precision"));
                    couTemp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.cou.getId().toString()), sic);
                    this.cou.setBaseCurrency(couTemp.getBaseCurrency());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            if (this.cou.getBaseCurrency() != null) {
                localPrecision = this.cou.getBaseCurrency().getPrecision();
            }
            if (qty.multiply(unitActualCost).setScale(localPrecision, 4).compareTo(actualCost) != 0 && actualCost.divide(qty, localPrecision, 4).compareTo(unitActualCost) != 0) {
                throw new TaskExternalException(OtherInWarehsBillImport.getResource((Context)ctx, (String)"CANNOT_IMPORT_ACTUALPRICE", (String)resources));
            }
        }
        try {
            MeasureUnitInfo baseUnit = materialInfo.getBaseUnit();
            entryInfo.setBaseUnit(baseUnit);
            BigDecimal qty = entryInfo.getQty();
            BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
            entryInfo.setBaseQty(baseQty);
            if (materialCompanyInfo != null) {
                BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                if (standardCost != null) {
                    BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, materialInfo, standardCost, baseUnit, mui);
                    BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                    entryInfo.setUnitStandardCost(unitstandardcost);
                    entryInfo.setStandardCost(standardcost);
                } else {
                    entryInfo.setUnitStandardCost(null);
                    entryInfo.setStandardCost(null);
                }
                if (!AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType())) {
                    int pricePrecision = materialInfo.getPricePrecision();
                    Object dataActualCost = ((DataToken)lineData.get((Object)"FEntry_actualCost")).data;
                    BigDecimal actualCost = BigDecimal.ZERO;
                    if (dataActualCost != null && !StringUtil.isEmptyString((String)dataActualCost.toString())) {
                        actualCost = ImRptAppUtils.getDataDeciaml(ctx, dataActualCost.toString());
                    }
                    BigDecimal dataUnitCost = actualCost.divide(qty, pricePrecision, 4);
                    entryInfo.setUnitActualCost(dataUnitCost);
                    entryInfo.setActualCost(actualCost);
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        entryInfo.setProject(this.getProject(ctx, data, this.sou.getCU()));
        data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        entryInfo.setTrackNumber(this.getTrackNumber(ctx, data, this.sou.getCU()));
        try {
            data = ((DataToken)lineData.get((Object)"FInvUpdateType_number")).data;
            entryInfo.setInvUpdateType(this.getInvUpdateType(ctx, "number", this.otherInWarehsBillInfo.getTransactionType(), data));
        }
        catch (TaskExternalException e) {
            data = ((DataToken)lineData.get((Object)"FInvUpdateType_name_l2")).data;
            entryInfo.setInvUpdateType(this.getInvUpdateType(ctx, "name", this.otherInWarehsBillInfo.getTransactionType(), data));
        }
        try {
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return entryInfo;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("Number") != null) {
                result.put("FNumber", rs.getString("Number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("bizType.number") != null) {
                result.put("FBizType_number", rs.getString("bizType.number"));
            }
            if (rs.getString("bizType.name") != null) {
                result.put("FBizType_name_l2", rs.getString("bizType.name"));
            }
            if (rs.getString("TRANSACTIONTYPE.NUMBER") != null) {
                result.put("FTransactionType_number", rs.getString("TRANSACTIONTYPE.NUMBER"));
            }
            if (rs.getString("TRANSACTIONTYPE.NAME") != null) {
                result.put("FTransactionType_name_l2", rs.getString("TRANSACTIONTYPE.NAME"));
            }
            if (rs.getString("STORAGEORGUNIT.NUMBER") != null) {
                result.put("FStorageOrgUnit_number", rs.getString("STORAGEORGUNIT.NUMBER"));
            }
            if (rs.getString("STORAGEORGUNIT.NAME") != null) {
                result.put("FStorageOrgUnit_name_l2", rs.getString("STORAGEORGUNIT.NAME"));
            }
            if (rs.getString("COSTCENTERORGUNIT.NUMBER") != null) {
                result.put("FCostCenterOrgUnit_number", rs.getString("COSTCENTERORGUNIT.NUMBER"));
            }
            if (rs.getString("ADMINORGUNIT.NUMBER") != null) {
                result.put("FAdminOrgUnit_number", rs.getString("ADMINORGUNIT.NUMBER"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l2", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NUMBER") != null) {
                result.put("FEntry$costObject_number", rs.getString("COSTOBJECT.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NAME") != null) {
                result.put("FEntry$costObject_name_l2", rs.getString("COSTOBJECT.NAME"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("COSTOBJECTSUITE.NUMBER") != null) {
                result.put("FEntry$costObjectSuite_number", rs.getString("COSTOBJECTSUITE.NUMBER"));
            }
            if (rs.getString("COSTOBJECTSUITE.NAME") != null) {
                result.put("FEntry$costObjectSuite_name_l2", rs.getString("COSTOBJECTSUITE.NAME"));
            }
            if (rs.getString("COSTITEM.NUMBER") != null) {
                result.put("FEntry$costItem_number", rs.getString("COSTITEM.NUMBER"));
            }
            if (rs.getString("COSTITEM.NAME") != null) {
                result.put("FEntry$costItem_name_l2", rs.getString("COSTITEM.NAME"));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ASSISTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("STOCKER.NUMBER") != null) {
                result.put("FEntry$stocker_number", rs.getString("STOCKER.NUMBER"));
            }
            if (rs.getString("LOCATION.NUMBER") != null) {
                result.put("FEntry$location_number", rs.getString("LOCATION.NUMBER"));
            }
            if (rs.getString("CUSTOMER.NUMBER") != null) {
                result.put("FEntry$customer_number", rs.getString("CUSTOMER.NUMBER"));
            }
            if (rs.getString("SUPPLIER.NUMBER") != null) {
                result.put("FEntry$supplier_number", rs.getString("SUPPLIER.NUMBER"));
            }
            if (rs.getString("Entry.isPresent") != null) {
                result.put("FEntry_isPresent", rs.getString("Entry.isPresent"));
            }
            if (rs.getString("ENTRY.actualCost") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString().length() < 1) {
                    result.put("FEntry_actualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.actualCost"));
                    result.put("FEntry_actualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ENTRY.UNITACTUALCOST") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString().length() < 1) {
                    result.put("FEntry_unitActualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.UNITACTUALCOST"));
                    result.put("FEntry_unitActualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("Creator.number") != null) {
                result.put("FCreator_number", rs.getString("Creator.number"));
            }
            if (rs.getString("Project.number") != null) {
                result.put("FEntry$project_number", rs.getString("Project.number"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getString("invUpdateType.number") != null) {
                result.put("FInvUpdateType_number", rs.getString("invUpdateType.number"));
            }
            if (rs.getString("invUpdateType.name") != null) {
                result.put("FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
            }
        }
        catch (SQLException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.OtherInWarehsDataImportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "otherinwarehs_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    private void checkNumberAndAmount(OtherInWarehsBillEntryInfo entryInfo, Context ctx, Map lineData, String[] checkList, String[] setList, boolean checkBackType) throws TaskExternalException {
        for (int i = 0; i < checkList.length; ++i) {
            try {
                Object o = ((DataToken)lineData.get((Object)checkList[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = new BigDecimal((o = ((String)o).replace(",", "")).toString());
                    if (value.compareTo(ZERO) == 0 && setList[i].equalsIgnoreCase(QTY_PROPERTY[0])) {
                        throw new TaskExternalException(OtherInWarehsBillImport.getResource((Context)ctx, (String)"qtyGreaterZero", (String)resources));
                    }
                    if (checkList[i].equals(ASSISTQTY_PROPERTY[0]) && entryInfo.getAssistUnit() == null) {
                        value = null;
                    }
                    entryInfo.setBigDecimal(setList[i], value);
                    continue;
                }
                if (setList[i].equalsIgnoreCase(QTY_PROPERTY[0])) {
                    throw new TaskExternalException(checkList[i] + OtherInWarehsBillImport.getResource((Context)ctx, (String)"Numbercannotbenull", (String)resources));
                }
                entryInfo.setBigDecimal(setList[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(checkList[i] + OtherInWarehsBillImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
            }
        }
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private void doEntryFilesByRI(OtherInWarehsBillEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : ENTRY_PRICE_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
        boolean flag = !InvAppUtils.isNegative(this.otherInWarehsBillInfo.getTransactionType());
        for (String entryField2 : ENTRY_QTY_AMOUNT_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            if (flag) {
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    public String getImportPermissionItem() {
        return "otherinwarehs_new";
    }

    protected String[] getLocalAmountFields() {
        return new String[]{"standardCost", "actualCost"};
    }

    protected String[] getPriceFields() {
        return new String[]{"unitStandardCost", "unitActualCost"};
    }
}

