/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.OtherIssueBillAgent;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractOtherIssueBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OtherIssueBillControllerBean
extends AbstractOtherIssueBillControllerBean {
    private static final long serialVersionUID = -5013477024497835419L;
    private static BigDecimal ZERO = new BigDecimal("0.00");
    private static final String TABLENAME = "T_IM_OtherIssueBill";

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        OtherIssueBillInfo bill = this.getOtherIssueBillInfo(ctx, pk, selector);
        if (bill.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            boolean falg = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getIsBillMultiapprove(new String[]{pk.toString()});
            if (falg) {
                Map result;
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                String[] billIds = new String[]{pk.toString()};
                String bizPackage = "com.kingdee.eas.scm.im.inv";
                try {
                    result = service.getCurrentAssignIds(user.getId().toString(), billIds, bizPackage, "OtherIssueFunction", "ActionRemove");
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
                List value = (List)result.get(pk.toString());
                if (value == null || value.size() == 0) {
                    throw new InvBizException(InvBizException.IS_IN_WF, new String[]{bill.getNumber()});
                }
            }
        }
        if (bill != null && bill.getSourceBillType() != null && "50957179-0105-1000-e004-4152c0a812fd463ED552".equals(bill.getSourceBillType().getId().toString())) {
            throw new InvBizException(InvBizException.COUNT_NOREMOVE, new String[]{bill.getNumber()});
        }
        super._delete(ctx, pk);
    }

    public SelectorItemCollection getBOTPSelectors() {
        return this.getSelector();
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.dealBillCost(ctx, model);
        super.update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dealBillCost(Context ctx, CoreBaseInfo model) throws BOSException {
        OtherIssueBillInfo info = (OtherIssueBillInfo)model;
        OtherIssueBillEntryInfo entry = null;
        OtherIssueBillEntryCollection entries = info.getEntry();
        BigDecimal totalActualCost = new BigDecimal("0.00");
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" from T_IM_OtherIssueBill bill");
        bf.append(" inner join T_IM_OtherIssueBillEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            BigDecimal actualCost;
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            int length = entries.size();
            for (int i = 0; i < length; totalActualCost = totalActualCost.add(actualCost), ++i) {
                entry = entries.get(i);
                actualCost = null != entry.getActualCost() ? entry.getActualCost() : new BigDecimal("0.00");
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : new BigDecimal("0.00");
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                pm.setString(1, entry.getId().toString());
                rs = pm.executeQuery();
                if (!rs.next()) continue;
                BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                entry.setReverseQty(reverseQty);
                entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pm, (Connection)conn);
    }

    @Override
    protected void _deleteNocheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._deleteNoCheck(ctx, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OtherIssueBillInfo bill = (OtherIssueBillInfo)model;
        if (bill.getId() != null) {
            boolean isCountingBill = false;
            if (bill.getTransactionType() != null) {
                TransactionTypeInfo aTransactionTypeInfo = bill.getTransactionType();
                if (bill.getSourceBillType() == null) {
                    ITransactionType iTransactionType = TransactionTypeFactory.getLocalInstance((Context)ctx);
                    aTransactionTypeInfo = iTransactionType.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(aTransactionTypeInfo.getId()));
                }
                if (bill.getSourceBillType() != null && bill.getSourceBillType().getId().toString().equals("50957179-0105-1000-e004-4152c0a812fd463ED552")) {
                    isCountingBill = true;
                }
            }
            if (isCountingBill) {
                throw new InvBizException(InvBizException.BILL_REMOVEBYCOUNT);
            }
        }
        return super._addnew(ctx, model);
    }

    public IObjectValue createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        OtherIssueBillInfo otherIssuebillInfo = null;
        otherIssuebillInfo = isUseAgent ? OtherIssueBillAgent.create() : new OtherIssueBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        otherIssuebillInfo.setBizDate(curDate);
        otherIssuebillInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return otherIssuebillInfo;
    }

    @Override
    protected boolean isCheckMaterialCost() {
        return true;
    }

    protected List getAddedSelector() {
        ArrayList<SelectorItemInfo> selList = new ArrayList<SelectorItemInfo>();
        SelectorItemCollection selector = this.getSelector();
        for (int i = 0; i < selector.size(); ++i) {
            selList.add(selector.get(i));
        }
        return selList;
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-0177c0a812fd463ED552";
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            this.initBotpData(ctx, collection.getObject(i));
        }
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OtherIssueBillInfo info = (OtherIssueBillInfo)model;
        this.calByUnitSource(ctx, info, (IObjectCollection)info.getEntry());
        try {
            super.initBotpData(ctx, model);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (info == null || info.getStorageOrgUnit() == null || info.getSourceBillType() == null) {
            return;
        }
        BillTypeInfo billTypeInfo = info.getBillType();
        if (billTypeInfo == null) {
            billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0177c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        info.setFiVouchered(false);
        StorageOrgUnitInfo storageOrgUnitInfo = info.getStorageOrgUnit();
        String storageOrgUnitID = storageOrgUnitInfo.getId().toString();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)storageOrgUnitID);
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        OtherIssueBillEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        String materialID = null;
        MaterialInventoryInfo materialInventoryInfo = null;
        MaterialCompanyInfoInfo materialCompanyInfo = null;
        String lot = null;
        WarehouseInfo wareHouseInfo = null;
        BigDecimal qty = SysConstant.BIGZERO;
        BigDecimal baseQty = SysConstant.BIGZERO;
        BigDecimal totalStandardCost = SysConstant.BIGZERO;
        BigDecimal totalActualCost = SysConstant.BIGZERO;
        int currencyPrecision = 2;
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getBaseCurrency() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId());
            currencyPrecision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)pk).getPrecision();
        }
        HashMap baseUnitMap = this.getBaseUnits(ctx, info);
        IMaterial material = MaterialFactory.getLocalInstance((Context)ctx);
        IDateOfMinDurability dateOfMinDurability = DateOfMinDurabilityFactory.getLocalInstance(ctx);
        int entrySize = info.getEntry().size();
        for (int i = 0; i < entrySize; ++i) {
            entryInfo = info.getEntry().get(i);
            materialInfo = entryInfo.getMaterial();
            if (entryInfo == null || materialInfo == null) continue;
            materialID = materialInfo.getId().toString();
            materialInventoryInfo = null;
            if (materialInfo != null && storageOrgUnitInfo != null) {
                materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialID, storageOrgUnitID);
            }
            if (materialInventoryInfo == null) continue;
            if (null != baseUnitMap.get(entryInfo.getBaseUnit().getId().toString())) {
                entryInfo.setBaseUnit((MeasureUnitInfo)baseUnitMap.get(entryInfo.getBaseUnit().getId().toString()));
            }
            if (materialInventoryInfo.isIsLotNumber() && entryInfo.getLot() == null) {
                AsstAttrValueInfo assistPropertyInfo = entryInfo.getAssistProperty();
                lot = assistPropertyInfo == null ? dateOfMinDurability.getLot(materialID, storageOrgUnitID, materialInventoryInfo.getIssuePriorityMode()) : dateOfMinDurability.getLot(materialID, storageOrgUnitID, materialInventoryInfo.getIssuePriorityMode(), assistPropertyInfo.getId().toString());
                entryInfo.setLot(lot);
            }
            if (entryInfo.getWarehouse() == null) {
                wareHouseInfo = InvServerUtils.getDefaultWarehouse(ctx, storageOrgUnitInfo, materialInfo, 1);
                entryInfo.setWarehouse(wareHouseInfo);
            }
            if (wareHouseInfo != null && entryInfo.getStocker() == null) {
                entryInfo.setStocker(wareHouseInfo.getWhman());
            }
            if (wareHouseInfo != null && entryInfo.getLocation() == null) {
                entryInfo.setLocation(InvServerUtils.getDefaultLocation(ctx, storageOrgUnitInfo, materialInfo, wareHouseInfo));
            }
            MaterialInfo tempInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            MeasureUnitInfo measureUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(tempInfo.getBaseUnit().getId()));
            materialInfo.setBaseUnit(measureUnitInfo);
            qty = entryInfo.getQty();
            if (materialInfo != null && qty != null) {
                baseQty = InvServerUtils.getBaseUnitQty(ctx, entryInfo.getUnit(), materialInfo, qty);
                if (baseQty == null) {
                    throw new SCMBillException(SCMBillException.BASEUNIT_ERROR, new Object[]{i + 1, materialInfo.getNumber()});
                }
                entryInfo.setBaseQty(baseQty);
                if (entryInfo.getAssistUnit() != null && entryInfo.getAssistQty() == null) {
                    entryInfo.setAssistQty(InvServerUtils.getAssUnitQty(ctx, entryInfo.getAssistUnit(), materialInfo, baseQty));
                }
            }
            if (qty == null) {
                qty = SysConstant.BIGZERO;
                entryInfo.setQty(qty);
            }
            if (baseQty == null) {
                baseQty = SysConstant.BIGZERO;
                entryInfo.setBaseQty(baseQty);
            }
            if (entryInfo.getReturnBaseQty() == null) {
                entryInfo.setReturnBaseQty(SysConstant.BIGZERO);
            }
            entryInfo.setAssociateQty(entryInfo.getBaseQty().abs());
            if (entryInfo.getPrice() == null) {
                entryInfo.setPrice(SysConstant.BIGZERO);
            }
            BigDecimal amount = entryInfo.getPrice().multiply(entryInfo.getQty()).setScale(currencyPrecision, 4);
            entryInfo.setAmount(amount);
            if (companyOrgUnitInfo != null) {
                materialCompanyInfo = material.getCompanyInfo(materialID, companyOrgUnitInfo.getId().toString());
            }
            if (materialCompanyInfo == null) continue;
            BigDecimal basePrice = SysConstant.BIGZERO;
            if (materialCompanyInfo.getStandardCost() != null) {
                basePrice = materialCompanyInfo.getStandardCost();
            }
            BigDecimal unitstandardCost = InvServerUtils.getUnitPrice(ctx, entryInfo.getUnit(), materialInfo, basePrice);
            entryInfo.setUnitStandardCost(unitstandardCost);
            BigDecimal standardCost = unitstandardCost.multiply(qty).setScale(currencyPrecision, 4);
            entryInfo.setStandardCost(standardCost);
            totalStandardCost = totalStandardCost.add(standardCost);
            if (materialCompanyInfo.getAccountType().equals((Object)AccountType.STANDARDCOST)) {
                if (entryInfo.getUnitActualCost() == null || ZERO.compareTo(entryInfo.getUnitActualCost()) == 0) {
                    entryInfo.setUnitActualCost(unitstandardCost);
                }
                if (entryInfo.getActualCost() == null || ZERO.compareTo(entryInfo.getActualCost()) == 0) {
                    entryInfo.setActualCost(standardCost);
                }
                totalActualCost = totalActualCost.add(entryInfo.getActualCost());
                continue;
            }
            if (entryInfo.getUnitActualCost() != null) {
                BigDecimal actualCost = entryInfo.getUnitActualCost().multiply(qty).setScale(currencyPrecision, 4);
                entryInfo.setActualCost(actualCost);
            }
            if (entryInfo.getActualCost() == null) continue;
            totalActualCost = totalActualCost.add(entryInfo.getActualCost());
        }
        totalStandardCost = totalStandardCost.setScale(currencyPrecision, 4);
        info.setTotalStandardCost(totalStandardCost);
        totalActualCost = totalActualCost.setScale(currencyPrecision, 4);
        info.setTotalActualCost(totalActualCost);
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    @Override
    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        OtherIssueBillInfo info = (OtherIssueBillInfo)model;
        if (info.getSourceBillType() != null && "50957179-0105-1000-e000-888880a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            return true;
        }
        return super._checkUnAuditInParam(ctx, (IObjectValue)info);
    }

    @Override
    protected void setNULLToZERO(IObjectValue invBill) {
        super.setNULLToZERO(invBill);
        OtherIssueBillInfo info = (OtherIssueBillInfo)invBill;
        if (info != null) {
            OtherIssueBillEntryCollection coll = info.getEntry();
            OtherIssueBillEntryInfo entryInfo = null;
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = coll.get(i);
                    if (entryInfo == null) continue;
                    if (entryInfo.getAssCoefficient() == null) {
                        entryInfo.setAssCoefficient(ZERO);
                    }
                    if (entryInfo.getReturnBaseQty() == null) {
                        entryInfo.setReturnBaseQty(ZERO);
                    }
                    if (entryInfo.getReturnsQty() != null) continue;
                    entryInfo.setReturnsQty(ZERO);
                }
            }
        }
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getOtherIssueBillSelector((boolean)true);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        OtherIssueBillInfo info = this.getOtherIssueBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)TABLENAME);
        OtherIssueBillInfo info = this.getOtherIssueBillInfo(ctx, pk, this.getSelector());
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)TABLENAME);
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        OtherIssueBillInfo info = this.getOtherIssueBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _innerUnAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        OtherIssueBillInfo info = this.getOtherIssueBillInfo(ctx, pk, this.getSelector());
        info.put("innerAudit", true);
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._unAudit(ctx, pk);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        OtherIssueBillEntryInfo otherIssueBillEntryInfo = (OtherIssueBillEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = otherIssueBillEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = otherIssueBillEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = otherIssueBillEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)otherIssueBillEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)otherIssueBillEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        otherIssueBillEntryInfo.setQty(qty);
        OtherIssueBillInfo otherIssueBillInfo = (OtherIssueBillInfo)scmBillBaseInfo;
        this.reCalCost4UnitSource(ctx, otherIssueBillInfo, otherIssueBillEntryInfo, sourceUnitId);
    }

    protected HashMap getBaseUnits(Context ctx, OtherIssueBillInfo info) throws BOSException {
        HashMap<String, MeasureUnitInfo> baseUnitMap = new HashMap<String, MeasureUnitInfo>();
        HashSet<String> baseUnitIDSet = new HashSet<String>();
        int entrySize = info.getEntry().size();
        for (int i = 0; i < entrySize; ++i) {
            baseUnitIDSet.add(info.getEntry().get(i).getBaseUnit().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemInfo fii = new FilterItemInfo("id", baseUnitIDSet, CompareType.INCLUDE);
        MeasureUnitCollection baseUnitColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
        if (baseUnitColl != null) {
            MeasureUnitInfo mu = null;
            for (int i = 0; i < baseUnitColl.size(); ++i) {
                mu = baseUnitColl.get(i);
                baseUnitMap.put(mu.getId().toString(), mu);
            }
        }
        return baseUnitMap;
    }

    @Override
    protected boolean _isFromMatAttrChangeBill(Context ctx, Set idSet) throws BOSException {
        HashSet<String> bizTypeSet = new HashSet<String>();
        bizTypeSet.add("kXeVPjE9chDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeVPjF4chDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeVPjGzchDgQKjAYj1RYCQHQ1w=");
        bizTypeSet.add("kXeUoXWkByTgQKjAYj1F6CQHQ1w=");
        bizTypeSet.add("kXeUoXXfByTgQKjAYj1F6CQHQ1w=");
        bizTypeSet.add("kXeVPjHuchDgQKjAYj1RYCQHQ1w=");
        try {
            String sql = "select fid from t_im_otherissuebill where fid in (" + this.convertSetToStr(idSet) + ") and fbiztypeid in (" + this.convertSetToStr(bizTypeSet) + ")";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, null);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
        return false;
    }

    private String convertSetToStr(Set set) {
        String str = "";
        for (Object obj : set) {
            str = str + "'" + obj.toString() + "',";
        }
        str = str.substring(0, str.lastIndexOf(","));
        return str;
    }
}

