/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class OtherIssueImport
extends InvDataImport {
    OtherIssueBillInfo otherIssueBillInfo = null;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    private static String invResouces = "com.kingdee.eas.scm.im.inv.InvBillDataImportResource";
    private boolean IsHaveValue = false;
    private boolean IsError = false;
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    StorageOrgUnitInfo sou = null;
    TransactionTypeInfo tti = null;
    ImportDataCache dataPool = new ImportDataCache();
    CompanyOrgUnitInfo cou = null;
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL = new String[]{"FEntry_qty", "FEntry_assistQty", "FEntry_unitActualCost", "FEntry_actualCost"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_ALL_KEY = new String[]{"qty", "assistQty", "unitActualCost", "actualCost"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT_KEY = new String[]{"qty", "assistQty", "actualCost"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_PRICE_KEY = new String[]{"unitActualCost"};
    String[] BOOLEAN_FIELDS = new String[]{"FEntry_isPresent"};
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OtherIssueBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.otherIssueBillInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.otherIssueBillInfo = this.transmitHead(lineData, ctx);
                    if (this.otherIssueBillInfo == null) {
                        return null;
                    }
                    this.afterBuildHead(ctx, this.otherIssueBillInfo, lineData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.otherIssueBillInfo);
                    break;
                }
            }
            try {
                OtherIssueBillEntryInfo entryinfo = this.transmitEntry(lineData, ctx);
                int seq = this.otherIssueBillInfo.getEntry().size() + 1;
                entryinfo.setSeq(seq);
                entryinfo.setParent(this.otherIssueBillInfo);
                entryinfo.setStorageOrgUnit(this.sou);
                entryinfo.setCompanyOrgUnit(this.cou);
                this.afterBuildEntry(ctx, this.otherIssueBillInfo, entryinfo, lineData);
                this.otherIssueBillInfo.getEntry().add(entryinfo);
                continue;
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.otherIssueBillInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.otherIssueBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    private OtherIssueBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.otherIssueBillInfo = new OtherIssueBillInfo();
        Object data = null;
        Object str = null;
        Object description = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (description != null && description.toString().trim().length() > 0) {
            String DeTemp = (String)description;
            if (DeTemp.length() > 80) {
                DeTemp = DeTemp.substring(0, 80);
            }
            this.otherIssueBillInfo.setDescription(DeTemp);
        } else {
            this.otherIssueBillInfo.setDescription("");
        }
        try {
            this.loadStorageOrgUnit(lineData, ctx, "number", "FStorageOrgUnit_number");
        }
        catch (Exception e_number) {
            try {
                this.loadStorageOrgUnit(lineData, ctx, "name", "FStorageOrgUnit_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadBizType(lineData, ctx, "number", "FBizType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadBizType(lineData, ctx, "name", "FBizType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        try {
            this.loadTransaction(lineData, ctx, "number", "FTransactionType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadTransaction(lineData, ctx, "name", "FTransactionType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
        Object bizdate = null;
        bizdate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (bizdate != null && bizdate.toString().length() > 0) {
            try {
                bizdate = ImRptAppUtils.formatNationalDate(ctx, bizdate.toString());
                this.otherIssueBillInfo.setBizDate((Date)bizdate);
            }
            catch (Exception e) {
                throw new TaskExternalException(bizdate.toString() + OtherIssueImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)resources));
            }
        } else {
            throw new TaskExternalException(OtherIssueImport.getResource((Context)ctx, (String)"bizDateCanNotBeNull", (String)resources));
        }
        this.otherIssueBillInfo.setCU(this.sou.getCU());
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        this.otherIssueBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.IsHaveValue = false;
        this.IsError = false;
        data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        UserInfo creator = this.getCreator(ctx, data);
        this.otherIssueBillInfo.setCreator(creator);
        this.IsHaveValue = false;
        this.IsError = false;
        this.otherIssueBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0177c0a812fd463ED552"));
        aBillTypeInfo.setNumber("108");
        this.otherIssueBillInfo.setBillType(aBillTypeInfo);
        data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo adminOrgUnit = this.getAdminOrgUnit(ctx, "number", data);
        this.otherIssueBillInfo.setAdminOrgUnit(adminOrgUnit);
        return this.otherIssueBillInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OtherIssueBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        OtherIssueBillEntryInfo entryInfo;
        block44: {
            ProjectCollection coll;
            ObjectUuidPK cuPK;
            CtrlUnitInfo cu;
            FilterInfo filter2;
            FilterInfo filter;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            String number;
            Object data;
            block43: {
                entryInfo = new OtherIssueBillEntryInfo();
                data = null;
                String str = "";
                MaterialInfo materialInfo = new MaterialInfo();
                MeasureUnitInfo mui = new MeasureUnitInfo();
                Object materialCompanyInfo = null;
                MaterialInventoryInfo materialInventory = null;
                data = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
                materialInfo = this.getMaterial(ctx, data, new OrgUnitInfo[]{this.sou, this.cou});
                entryInfo.setMaterial(materialInfo);
                materialInventory = this.getMaterialInventory(ctx, materialInfo, this.sou);
                this.doEntryQty(lineData, ctx, entryInfo);
                String mid = entryInfo.getMaterial().getId().toString();
                if (materialInventory.isIsPeriodValid()) {
                    String lot = ((DataToken)lineData.get((Object)"FEntry_lot")).data.toString();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    DateOfMinDurabilityCollection dateCol = null;
                    try {
                        dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (dateCol != null && dateCol.size() > 0) {
                        DateOfMinDurabilityInfo dateInfo = dateCol.get(0);
                        entryInfo.setMfg(dateInfo.getMfg());
                        entryInfo.setExp(dateInfo.getExp());
                    } else {
                        String[] DATE_ENTRY_PROPERTY = new String[]{"FEntry_mfg", "FEntry_exp"};
                        for (int i = 0; i < DATE_ENTRY_PROPERTY.length; ++i) {
                            Date value;
                            Object o = ((DataToken)lineData.get((Object)DATE_ENTRY_PROPERTY[i])).data;
                            if (o == null || o.toString().length() <= 0 || (o = ImRptAppUtils.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value = (Date)o) == null || !materialInventory.isIsPeriodValid()) continue;
                            if (i == 0) {
                                entryInfo.setMfg(value);
                                continue;
                            }
                            entryInfo.setExp(value);
                        }
                    }
                    if (entryInfo.getExp() == null || entryInfo.getMfg() == null) {
                        throw new TaskExternalException(OtherIssueImport.getResource((Context)ctx, (String)"IsPeriodValidNoExpandMfg", (String)resources));
                    }
                }
                try {
                    data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
                    if (this.checkLotInfo(ctx, materialInfo, data, this.sou, entryInfo)) {
                        if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
                        entryInfo.setLot(data.toString().trim());
                    } else {
                        entryInfo.setLot(null);
                    }
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
                try {
                    data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
                    MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, data, materialInfo);
                    entryInfo.setUnit(measureUnitInfo);
                    mui = measureUnitInfo;
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
                try {
                    entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
                this.doEntryAmountPriceField(ctx, entryInfo, lineData);
                this.doEntryFilesByRI(entryInfo);
                try {
                    String number2;
                    data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
                    this.checkMaterialInfo(ctx, materialInfo, data, 3);
                    if (data != null && (number2 = data.toString()) != null && number2.trim().length() > 0) {
                        AsstAttrValueInfo asstAttr = this.getAsstAttr(ctx, data, entryInfo.getMaterial().getAssistAttr());
                        entryInfo.setAssistProperty(asstAttr);
                    }
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (entryInfo.getAssistUnit() != null) {
                    entryInfo.setAssistQty((BigDecimal)entryInfo.get("assistQty"));
                } else {
                    entryInfo.setAssistQty(ZERO);
                }
                data = ((DataToken)lineData.get((Object)"FEntry$costObject_number")).data;
                CostObjectInfo costObject = this.getCostObject(ctx, this.cou, data);
                entryInfo.setCostObject(costObject);
                data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
                WarehouseInfo warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data);
                entryInfo.setWarehouse(warehouseInfo);
                data = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
                PersonInfo stocker = this.getStocker(ctx, data);
                entryInfo.setStocker(stocker);
                data = ((DataToken)lineData.get((Object)"FEntry$location_number")).data;
                LocationInfo location = this.getLocation(ctx, data, warehouseInfo);
                entryInfo.setLocation(location);
                data = ((DataToken)lineData.get((Object)"FEntry$customer_number")).data;
                CustomerInfo customerInfo = this.getCustomer(ctx, data);
                entryInfo.setCustomer(customerInfo);
                data = ((DataToken)lineData.get((Object)"FEntry$supplier_number")).data;
                SupplierInfo supplierInfo = this.getSupplier(ctx, "number", data);
                entryInfo.setSupplier(supplierInfo);
                for (int i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
                    String value;
                    Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
                    if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
                    entryInfo.setBoolean(this.BOOLEAN_FIELDS[i], DataImportUtils.getBooleanValue((Object)value, (boolean)false));
                }
                entryInfo.setIsPresent(entryInfo.getBoolean(this.BOOLEAN_FIELDS[0]));
                Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
                if (o != null && o.toString().trim().length() > 0 && o != null && o.toString().length() > 0) {
                    entryInfo.setRemark(o.toString());
                }
                try {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                    MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                    entryInfo.setBaseUnit(baseUnit);
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
                    entryInfo.setBaseQty(baseQty);
                    if (materialCompanyInfo != null) {
                        BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                        if (AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType()) && standardCost != null) {
                            BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, materialInfo, standardCost, baseUnit, mui);
                            BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                            entryInfo.setUnitStandardCost(unitstandardcost);
                            entryInfo.setStandardCost(standardcost);
                            entryInfo.setUnitActualCost(unitstandardcost);
                            entryInfo.setActualCost(standardcost);
                        } else {
                            entryInfo.setUnitStandardCost(null);
                            entryInfo.setStandardCost(null);
                        }
                        if (!AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType())) {
                            int pricePrecision = materialInfo.getPricePrecision();
                            Object dataActualCost = ((DataToken)lineData.get((Object)"FEntry_actualCost")).data;
                            BigDecimal dataUnitCost = ImRptAppUtils.getDataDeciaml(ctx, (String)dataActualCost).divide(qty, pricePrecision, 4);
                            entryInfo.setUnitActualCost(dataUnitCost);
                            entryInfo.setActualCost(ImRptAppUtils.getDataDeciaml(ctx, (String)dataActualCost));
                        }
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
                    if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block43;
                    IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    status = new HashSet<Integer>();
                    status.add(new Integer(4));
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                    filter2 = new FilterInfo();
                    cu = this.otherIssueBillInfo.getStorageOrgUnit().getCU();
                    cuPK = null;
                    cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                    try {
                        filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (filter2 != null) {
                        filter.mergeFilter(filter2, "and");
                    }
                    viewInfo.setFilter(filter);
                    coll = iProject.getProjectCollection(viewInfo);
                    if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + OtherIssueImport.getResource((Context)ctx, (String)"PROJECT_NUMBER_ERROR", (String)resources));
                    ProjectInfo projectInfo = coll.get(0);
                    entryInfo.setProject(projectInfo);
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            try {
                data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block44;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                status = new HashSet();
                status.add(new Integer(10));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                filter2 = new FilterInfo();
                cu = this.otherIssueBillInfo.getStorageOrgUnit().getCU();
                cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + OtherIssueImport.getResource((Context)ctx, (String)"TRACK_NUMBER_ERROR", (String)resources));
                TrackNumberInfo trackNumberInfo = coll.get(0);
                entryInfo.setTrackNumber(trackNumberInfo);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        this.doEntryInvUpdateType(ctx, lineData, entryInfo);
        try {
            this.checkQtyPrecision(ctx, entryInfo);
            return entryInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doEntryQty(Map lineData, Context ctx, OtherIssueBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data != null && data.toString().length() > 0) {
            try {
                data = ((String)data).replace(",", "");
                BigDecimal qty = new BigDecimal(data.toString());
                entryInfo.setQty(qty);
            }
            catch (Exception e) {
                throw new TaskExternalException(OtherIssueImport.getResource(ctx, "QTY_ERROR"));
            }
        } else {
            throw new TaskExternalException(OtherIssueImport.getResource(ctx, "QTY_ERROR"));
        }
        if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(ZERO) == 0) {
            throw new TaskExternalException(OtherIssueImport.getResource(ctx, "QTY_ERROR"));
        }
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resources, (String)strKey, (Context)ctx);
    }

    private void doEntryAmountPriceField(Context ctx, OtherIssueBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        BigDecimal value = null;
        for (int i = 0; i < DECIMAL_ENTRY_PROPERTY_ALL.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)OtherIssueImport.DECIMAL_ENTRY_PROPERTY_ALL[i])).data;
            try {
                value = ImRptAppUtils.getDataDeciaml(ctx, o.toString());
            }
            catch (Exception e) {
                continue;
            }
            entryInfo.put(DECIMAL_ENTRY_PROPERTY_ALL_KEY[i], value.abs());
        }
    }

    private void doEntryFilesByRI(OtherIssueBillEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : DECIMAL_ENTRY_PROPERTY_PRICE_KEY) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
        for (String entryField2 : DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT_KEY) {
            if (entryInfo.get(entryField2) == null) continue;
            if (InvAppUtils.isNegative(this.tti)) {
                value = (BigDecimal)entryInfo.get(entryField2);
                entryInfo.put(entryField2, value.abs().negate());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            if (rs.getString("Number") != null) {
                result.put("FNumber", rs.getString("Number"));
            }
            if (rs.getString("BizDate") != null) {
                result.put("FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("BizDate")));
            }
            if (rs.getString("bizType.number") != null) {
                result.put("FBizType_number", rs.getString("bizType.number"));
            }
            if (rs.getString("bizType.name") != null) {
                result.put("FBizType_name_l2", rs.getString("bizType.name"));
            }
            if (rs.getString("TRANSACTIONTYPE.NUMBER") != null) {
                result.put("FTransactionType_number", rs.getString("TRANSACTIONTYPE.NUMBER"));
            }
            if (rs.getString("TRANSACTIONTYPE.NAME") != null) {
                result.put("FTransactionType_name_l2", rs.getString("TRANSACTIONTYPE.NAME"));
            }
            if (rs.getString("STORAGEORGUNIT.NUMBER") != null) {
                result.put("FStorageOrgUnit_number", rs.getString("STORAGEORGUNIT.NUMBER"));
            }
            if (rs.getString("STORAGEORGUNIT.NAME") != null) {
                result.put("FStorageOrgUnit_name_l2", rs.getString("STORAGEORGUNIT.NAME"));
            }
            if (rs.getString("COSTCENTERORGUNIT.NUMBER") != null) {
                result.put("FCostCenterOrgUnit_number", rs.getString("COSTCENTERORGUNIT.NUMBER"));
            }
            if (rs.getString("ADMINORGUNIT.NUMBER") != null) {
                result.put("FAdminOrgUnit_number", rs.getString("ADMINORGUNIT.NUMBER"));
            }
            if (rs.getString("MATERIAL.NUMBER") != null) {
                result.put("FEntry$material_number", rs.getString("MATERIAL.NUMBER"));
            }
            if (rs.getString("MATERIAL.NAME") != null) {
                result.put("FEntry$material_name_l2", rs.getString("MATERIAL.NAME"));
            }
            if (rs.getString("MATERIAL.MODEL") != null) {
                result.put("FEntry$material_model", rs.getString("MATERIAL.MODEL"));
            }
            if (rs.getString("ASSISTPROPERTY.NUMBER") != null) {
                result.put("FEntry$assistProperty_number", rs.getString("ASSISTPROPERTY.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NUMBER") != null) {
                result.put("FEntry$costObject_number", rs.getString("COSTOBJECT.NUMBER"));
            }
            if (rs.getString("COSTOBJECT.NAME") != null) {
                result.put("FEntry$costObject_name_l2", rs.getString("COSTOBJECT.NAME"));
            }
            if (rs.getString("ENTRY.LOT") != null) {
                result.put("FEntry_lot", rs.getString("ENTRY.LOT"));
            }
            if (rs.getString("ENTRY.MFG") != null) {
                result.put("FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.MFG")));
            }
            if (rs.getString("ENTRY.EXP") != null) {
                result.put("FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRY.EXP")));
            }
            if (rs.getString("UNIT.NUMBER") != null) {
                result.put("FEntry$unit_number", rs.getString("UNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.QTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.QTY")).toString().length() < 1) {
                    result.put("FEntry_qty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.QTY"));
                    result.put("FEntry_qty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ASSISTUNIT.NUMBER") != null) {
                result.put("FEntry$assistUnit_number", rs.getString("ASSISTUNIT.NUMBER"));
            }
            if (rs.getString("ENTRY.ASSISTQTY") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.ASSISTQTY")).toString().length() < 1) {
                    result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.ASSISTQTY"));
                    result.put("FEntry_assistQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("WAREHOUSE.NUMBER") != null) {
                result.put("FEntry$warehouse_number", rs.getString("WAREHOUSE.NUMBER"));
            }
            if (rs.getString("STOCKER1.NUMBER") != null) {
                result.put("FEntry$stocker_number", rs.getString("STOCKER1.NUMBER"));
            }
            if (rs.getString("LOCATION.NUMBER") != null) {
                result.put("FEntry$location_number", rs.getString("LOCATION.NUMBER"));
            }
            if (rs.getString("CUSTOMER.NUMBER") != null) {
                result.put("FEntry$customer_number", rs.getString("CUSTOMER.NUMBER"));
            }
            if (rs.getString("SUPPLIER.NUMBER") != null) {
                result.put("FEntry$supplier_number", rs.getString("SUPPLIER.NUMBER"));
            }
            if (rs.getString("Entry.isPresent") != null) {
                result.put("FEntry_isPresent", rs.getString("Entry.isPresent"));
            }
            if (rs.getString("ENTRY.actualCost") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.actualCost")).toString().length() < 1) {
                    result.put("FEntry_actualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.actualCost"));
                    result.put("FEntry_actualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("ENTRY.UNITACTUALCOST") != null) {
                if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString()) || DataImportUtils.transformValue((Object)rs.getString("ENTRY.UNITACTUALCOST")).toString().length() < 1) {
                    result.put("FEntry_unitActualCost", DataImportUtils.transformValue(null));
                } else {
                    qty = new BigDecimal(rs.getString("ENTRY.UNITACTUALCOST"));
                    result.put("FEntry_unitActualCost", ImRptAppUtils.fmtDecimalStr(ctx, qty));
                }
            }
            if (rs.getString("Entry.remark") != null) {
                result.put("FEntry_remark", rs.getString("Entry.remark"));
            }
            if (rs.getString("CreateTime") != null) {
                result.put("FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("CreateTime")));
            }
            if (rs.getString("Creator.number") != null) {
                result.put("FCreator_number", rs.getString("Creator.number"));
            }
            if (rs.getString("Project.number") != null) {
                result.put("FEntry$project_number", rs.getString("Project.number"));
            }
            if (rs.getString("TrackNumber.number") != null) {
                result.put("FEntry$trackNumber_number", rs.getString("TrackNumber.number"));
            }
            if (rs.getString("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getString("invUpdateType.number") != null) {
                result.put("FInvUpdateType_number", rs.getString("invUpdateType.number"));
            }
            if (rs.getString("invUpdateType.name") != null) {
                result.put("FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
            }
        }
        catch (Exception Ex) {
            Logger.error((Throwable)Ex);
            throw new TaskExternalException("", (Throwable)Ex);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.app.OtherIssueDataImportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "otherissue_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, OtherIssueBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        MaterialInventoryInfo materialInventoryInfo = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
        boolean isLotNumber = materialInventoryInfo.isIsLotNumber();
        return isLotNumber;
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + OtherIssueImport.getResource((Context)ctx, (String)"RelationNotExists", (String)resources));
        }
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"NotSetAssistProperty", (String)resources));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"SetAssistProperty", (String)resources));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"NotSetAssistUnit", (String)resources));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + OtherIssueImport.getResource((Context)ctx, (String)"SetAssistUnit", (String)resources));
            }
        }
    }

    private void loadBizType(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        BizTypeInfo bizType = this.getBizType(ctx, "50957179-0105-1000-e000-0177c0a812fd463ED552", byProperty, souData);
        this.otherIssueBillInfo.setBizType(bizType);
    }

    private void loadTransaction(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        TransactionTypeInfo transaction;
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.tti = transaction = this.getTransaction(ctx, byProperty, souData, "50957179-0105-1000-e000-0177c0a812fd463ED552", this.otherIssueBillInfo.getBizType());
        this.otherIssueBillInfo.setTransactionType(transaction);
    }

    private void loadStorageOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        StorageOrgUnitInfo storageOrgUnit;
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.sou = storageOrgUnit = this.getStorageOrgUnit(ctx, byProperty, souData);
        this.otherIssueBillInfo.setStorageOrgUnit(storageOrgUnit);
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = OtherIssueImport.getMulUnit(mui, mi, ctx);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = OtherIssueImport.getMulUnit(baseUnit, mi, ctx);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi, Context ctx) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private void doEntryInvUpdateType(Context ctx, Map lineData, OtherIssueBillEntryInfo entryInfo) throws TaskExternalException {
        try {
            this.loadInvUpdateType(lineData, ctx, "number", "FInvUpdateType_number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadInvUpdateType(lineData, ctx, "name", "FInvUpdateType_name_l2", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadInvUpdateType(Map lineData, Context ctx, String byProperty, String propertyName, OtherIssueBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        boolean flag;
        TransactionInvUpdateTypeCollection collections;
        InvUpdateTypeInfo invUpdateTypeInfo;
        block11: {
            boolean flag2;
            Object souData;
            block10: {
                souData = ((DataToken)lineData.get((Object)propertyName)).data;
                invUpdateTypeInfo = null;
                if (souData != null && souData.toString().trim().length() > 0) {
                    TransactionTypeInfo transInfo = this.otherIssueBillInfo.getTransactionType();
                    collections = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, this.getFilter(transInfo.getId().toString(), "transactiontype"));
                    if (this.dataPool.getInvUpdateTypeInfo(souData.toString().trim()) == null) {
                        InvUpdateTypeCollection collection = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(this.getFilter(souData.toString().trim(), byProperty));
                        if (collection != null && collection.size() > 0 && collections != null && collections.size() > 0) {
                            invUpdateTypeInfo = collection.get(0);
                            flag2 = false;
                            break block10;
                        } else {
                            String str = OtherIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                            throw new TaskExternalException(str);
                        }
                    }
                    if (collections != null && collections.size() > 0) {
                        invUpdateTypeInfo = this.dataPool.getInvUpdateTypeInfo(souData.toString().trim());
                        flag = false;
                        break block11;
                    } else {
                        String str = OtherIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                        throw new TaskExternalException(str);
                    }
                }
                String str = OtherIssueImport.getResource((Context)ctx, (String)"InvUpdateType_isNull", (String)invResouces);
                throw new TaskExternalException(str);
            }
            for (int i = 0; i < collections.size(); ++i) {
                TransactionInvUpdateTypeInfo tt = collections.get(i);
                if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
                flag2 = true;
                break;
            }
            if (flag2) {
                entryInfo.setInvUpdateType(invUpdateTypeInfo);
                this.dataPool.setInvUpdateTypeMapInfo(souData.toString().trim(), invUpdateTypeInfo);
                return;
            }
            String str = OtherIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
            throw new TaskExternalException(str);
        }
        for (int i = 0; i < collections.size(); ++i) {
            TransactionInvUpdateTypeInfo tt = collections.get(i);
            if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
            return;
        }
        String str = OtherIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
        throw new TaskExternalException(str);
    }

    public String getImportPermissionItem() {
        return "otherissue_new";
    }

    protected String[] getLocalAmountFields() {
        return new String[]{"standardCost", "actualCost"};
    }

    protected String[] getPriceFields() {
        return new String[]{"unitStandardCost", "unitActualCost"};
    }
}

