/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.FetchPriceEnum;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillRelationOptionEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.IDateOfMinDurability;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrices;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesInfo;
import com.kingdee.eas.scm.im.inv.PurInAlgorithm;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.PurInWarehsServerutils;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PurInAlgorithmForInfo
extends PurInAlgorithm {
    private PurInWarehsBillInfo info;
    private int localAmountPrecision;
    private int amountPrecision;
    private HashMap<String, BigDecimal> poBaseQtyMap = null;
    private HashMap<String, BigDecimal> poAssociateMap = null;
    private HashMap<String, BigDecimal> subBaseQtyMap = null;
    private HashMap<String, BigDecimal> subAssociateMap = null;
    Map<String, PurOrderInfo> orderMap = new HashMap<String, PurOrderInfo>();
    Map<String, PurOrderEntryInfo> orderEntryMap = new HashMap<String, PurOrderEntryInfo>();
    private final String res = "com.kingdee.eas.scm.im.inv.WarehsManageResource";

    public PurInAlgorithmForInfo(PurInWarehsBillInfo info, Context ctx) {
        this.info = info;
        this.ctx = ctx;
    }

    public void revalue() throws EASBizException, BOSException {
        String bizTypeId;
        this.sou = this.info.getStorageOrgUnit();
        if (this.sou == null) {
            this.sou = (StorageOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.ctx, (OrgType)OrgType.Storage);
            this.info.setStorageOrgUnit(this.sou);
        }
        this.cou = null;
        if (this.sou != null) {
            this.cou = PurInWarehsServerutils.getCompany(this.ctx, this.sou);
        } else if (this.info.getEntry().get(0).getCompanyOrgUnit() != null) {
            this.cou = this.info.getEntry().get(0).getCompanyOrgUnit();
        }
        if (this.cou == null) {
            throw new InvBizException(InvBizException.COMPANYISNULL);
        }
        String oql = "SELECT *, baseCurrency.precision WHERE id ='" + this.cou.getId().toString() + "'";
        this.cou = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo(oql);
        this.localAmountPrecision = this.cou.getBaseCurrency().getPrecision();
        this.amountPrecision = 2;
        if (this.info.getCurrency() != null) {
            CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)this.ctx).getValue("SELECT id, precision WHERE id = '" + this.info.getCurrency().getId().toString() + "'");
            this.info.setCurrency(currency);
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        if (this.info.getSourceBillType() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString()) && this.info.get("IS_VMI_BIZ") == null && this.info.getSupplier() == null) {
            this.setSupplierFromInner(this.info, this.cou, this.ctx);
        }
        if (this.info.getEntry().get(0) == null) {
            return;
        }
        BillTypeInfo corebillType = this.info.getEntry().get(0).getCoreBillType();
        String corebillTypeID = corebillType == null ? null : corebillType.getId().toString();
        String string = bizTypeId = this.info.getBizType() == null ? null : this.info.getBizType().getId().toString();
        if (!this.info.isIsSysBill()) {
            if (this.info.getEntry().get(0) != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(corebillTypeID)) {
                if (this.info.get("settlementRelation") == null) {
                    this.reValueForCoreIsPurOrder(this.info, this.cou, this.ctx);
                } else if (this.info.get("VT_CompanyOrgUnitID") != null) {
                    CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.info.get("VT_CompanyOrgUnitID").toString()));
                    this.initExchange(sourceCompanyOrgUnitInfo);
                }
            } else if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equalsIgnoreCase(bizTypeId)) {
                this.reValueForTransfer2Sides(this.info, this.ctx);
            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equalsIgnoreCase(bizTypeId)) {
                this.reValueForTransfer3Sides(this.info, this.ctx);
            } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equalsIgnoreCase(bizTypeId)) {
                this.reValueForTransfer4Sides(this.info, this.cou, this.ctx);
            } else if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(corebillTypeID)) {
                this.reValueForCoreIsPurReturns(this.info, this.cou, this.ctx);
            }
            for (int i = 0; i < this.info.getEntry().size(); ++i) {
                MaterialInventoryInfo materialInventory;
                PurInWarehsEntryInfo entry = this.info.getEntry().get(i);
                if (entry.getMaterial() != null && entry.getWarehouse() == null && (materialInventory = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString())) != null && materialInventory.getDefaultWarehouse() != null) {
                    entry.setWarehouse(materialInventory.getDefaultWarehouse());
                }
                if (entry.getMaterial() == null || entry.getWarehouse() == null || entry.getLocation() != null) continue;
                entry.setLocation(this.getDefaultLocation(entry.getMaterial().getId().toString(), entry.getWarehouse().getId().toString(), this.sou.getId().toString()));
            }
        } else {
            if (!(this.info.getCurrency().getId().equals((Object)this.cou.getBaseCurrency().getId()) || this.cou.getBaseExchangeTable() != null && PurInWarehsServerutils.getExchangeRate(this.ctx, this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId())) != null)) {
                throw new InvBizException(InvBizException.NULL_EXCHANGERATETABLE, new String[]{""});
            }
            if (this.info.get("isIsSquareBalance") == null) {
                if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(corebillTypeID)) {
                    this.reValueForVirtualBillIssuing();
                } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(corebillTypeID)) {
                    this.revalueForVirtualBillPurchasing();
                } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(corebillTypeID)) {
                    this.reValueForVirtualBillSaleBacking();
                } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(corebillTypeID)) {
                    this.reValueForVirtualBillTransferring((AbstractCoreBaseInfo)this.cou);
                }
                if (this.info.get("IS_VMI_BIZ") != null) {
                    // empty if block
                }
            } else {
                if (this.info.getEntry().get(0).getCoreBillType() == null) {
                    return;
                }
                String companyID = "";
                CurrencyInfo currency = null;
                if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(this.info.getEntry().get(0).getCoreBillType().getId().toString())) {
                    SaleReturnsInfo st = SaleReturnsFactory.getLocalInstance((Context)this.ctx).getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getPurOrder()));
                    currency = st.getCurrency();
                    companyID = st.getCompanyOrgUnit().getId().toString();
                }
                if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(this.info.getEntry().get(0).getCoreBillType().getId().toString())) {
                    SaleOrderInfo saleOrderInfo = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getPurOrder()));
                    currency = saleOrderInfo.getCurrency();
                    companyID = saleOrderInfo.getCompanyOrgUnit().getId().toString();
                }
                CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                if (currency != null) {
                    currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)this.ctx).getValue("SELECT id, precision WHERE id = '" + this.info.getCurrency().getId().toString() + "'");
                    this.info.setCurrency(currency);
                    this.amountPrecision = currency.getPrecision();
                }
                this.initExchange(sourceCompanyOrgUnitInfo);
            }
            WarehouseInfo warehouseInfo = this.getDefaultWarehouseByStorageUnit(this.ctx, this.info.getStorageOrgUnit().getId().toString());
            for (int i = 0; i < this.info.getEntry().size(); ++i) {
                PurInWarehsEntryInfo entry = this.info.getEntry().get(i);
                MaterialInventoryInfo materialInventory = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString());
                if (entry.getWarehouse() == null) {
                    if (materialInventory != null && materialInventory.getDefaultWarehouse() != null) {
                        entry.setWarehouse(materialInventory.getDefaultWarehouse());
                    } else if (warehouseInfo != null) {
                        entry.setWarehouse(warehouseInfo);
                    } else {
                        throw new InvBizException(InvBizException.NOWAREHOUSEINVIRTUALBILL);
                    }
                }
                if (entry.getWarehouse() != null && entry.getWarehouse().isHasLocation() && entry.getLocation() == null) {
                    LocationInfo location = this.getDefaultLocation(entry.getMaterial().getId().toString(), entry.getWarehouse().getId().toString(), this.sou.getId().toString());
                    if (location == null) {
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)entry.getWarehouse().getId().toString(), CompareType.EQUALS));
                        view.setFilter(filter);
                        LocationCollection locationcoll = LocationFactory.getLocalInstance((Context)this.ctx).getLocationCollection(view);
                        if (locationcoll != null && locationcoll.size() > 0) {
                            location = locationcoll.get(0);
                        }
                    }
                    entry.setLocation(location);
                }
                if (entry.getWarehouse() == null || entry.getStocker() != null) continue;
                entry.setStocker(entry.getWarehouse().getWhman());
            }
        }
        this.reValueInfo(this.info, this.sou, this.cou, this.ctx);
    }

    private void setDefaultValue() throws EASBizException, BOSException {
        if (this.info.getPaymentType() == null) {
            this.info.setPaymentType(this.getDefaultAPaymentTypeInfo());
        }
    }

    private SelectorItemCollection getTransferOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.precision"));
        return sic;
    }

    private void reValueForVirtualBillTransferring(AbstractCoreBaseInfo cou) throws BOSException, EASBizException {
        PurInWarehsEntryInfo eie;
        SupplierInfo supplierHead = null;
        SupplierInfo supplier = null;
        PurInWarehsEntryInfo entryInfo = null;
        TransferOrderBillEntryInfo transferOrderEntryInfo = null;
        TransferOrderBillInfo orderBillInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        this.getCoreBillInfoMap(this.ctx, orderMap, orderEntryMap);
        boolean is4Sides = false;
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString()) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString())) {
            is4Sides = true;
        }
        if ((eie = this.info.getEntry().get(0)) == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)eie.getPurOrderEntry()) && (transferOrderEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(eie.getPurOrderEntry())) != null && transferOrderEntryInfo.getIssueCompanyOrgUnit() != null) {
            supplierHead = SupplierFactory.getLocalInstance((Context)this.ctx).getInterSupplierCollection(transferOrderEntryInfo.getIssueCompanyOrgUnit().getId().toString(), null).get(0);
        }
        if (!StringUtils.isEmpty((String)eie.getPurOrder()) && (orderBillInfo = (TransferOrderBillInfo)orderMap.get(eie.getPurOrder())) != null) {
            if (this.info.getSourceBillType() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
                sourceCompanyOrgUnitInfo = orderBillInfo.getIssueCompanyOrgUnit();
            }
            if (orderBillInfo.getCurrency() != null) {
                this.info.setCurrency(orderBillInfo.getCurrency());
                this.amountPrecision = this.info.getCurrency().getPrecision();
            }
            if (orderBillInfo.getIssueCompanyOrgUnit() != null) {
                supplier = SupplierFactory.getLocalInstance((Context)this.ctx).getInterSupplierCollection(orderBillInfo.getIssueCompanyOrgUnit().getId().toString(), null).get(0);
                this.info.setSupplier(supplierHead);
            }
        }
        String bizType = this.info.getBizType().getId().toString();
        String[] coreBillEntryIDs = new String[this.info.getEntry().size()];
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            PurInWarehsEntryInfo entry = this.info.getEntry().get(i);
            coreBillEntryIDs[i] = entry.getPurOrderEntry();
        }
        IMultiSidesTransferPrices ims = null;
        ims = MultiSidesTransferPricesFactory.getLocalInstance(this.ctx);
        Map priceMap = ims.getPriceInfos(coreBillEntryIDs, cou.getId().toString(), "103", bizType);
        PurInWarehsEntryCollection purInWarehsEntryCol = this.info.getEntry();
        int count = purInWarehsEntryCol.size();
        for (int i = 0; i < count; ++i) {
            MultiSidesTransferPricesInfo priceInfo;
            entryInfo = purInWarehsEntryCol.get(i);
            if (is4Sides) {
                if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
                    entryInfo.setBalanceSupplier(supplierHead);
                } else {
                    entryInfo.setBalanceSupplier(supplier);
                }
            } else {
                entryInfo.setBalanceSupplier(supplierHead);
            }
            if (!StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) {
                transferOrderEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(entryInfo.getPurOrderEntry());
            }
            if (transferOrderEntryInfo == null) continue;
            if (sourceCompanyOrgUnitInfo == null) {
                sourceCompanyOrgUnitInfo = transferOrderEntryInfo.getIssueCompanyOrgUnit();
            }
            if (is4Sides && this.info.getSourceBillType() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
                BigDecimal conversionRate;
                entryUnit = entryInfo.getUnit();
                orderUnit = transferOrderEntryInfo.getUnit();
                if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
                if (this.info.isIsInTax()) {
                    BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                    taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                    entryInfo.setTaxPrice(taxPrice);
                } else {
                    BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
                    price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                    entryInfo.setPrice(price);
                }
            }
            if ((priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entryInfo.getPurOrderEntry())) == null) continue;
            if (priceInfo.getDiscountType().getValue() == 1 && (double)priceInfo.getTaxPrice().longValue() > 0.0) {
                entryInfo.setDiscountRate(priceInfo.getDiscountRate().divide(priceInfo.getTaxPrice(), 8, 6).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED));
                continue;
            }
            entryInfo.setDiscountRate(priceInfo.getDiscountRate());
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
    }

    private void reValueForVirtualBillSaleBacking() throws EASBizException, BOSException {
        SaleReturnsInfo saleReturnsInfo;
        PurInWarehsEntryInfo entryInfo = null;
        SaleReturnsEntryInfo saleReturnsEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        CustomerInfo customerInfo = null;
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        if (this.info.getEntry().get(0) == null) {
            return;
        }
        this.getCoreBillInfoMap(this.ctx, orderMap, orderEntryMap);
        if (!StringUtils.isEmpty((String)this.info.getEntry().get(0).getPurOrder()) && (saleReturnsInfo = (SaleReturnsInfo)orderMap.get(this.info.getEntry().get(0).getPurOrder())) != null && saleReturnsInfo.getCompanyOrgUnit() != null) {
            customerInfo = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleReturnsInfo.getCompanyOrgUnit().getId().toString(), null).get(0);
        }
        PurInWarehsEntryCollection purInWarehsEntryCol = this.info.getEntry();
        int count = purInWarehsEntryCol.size();
        for (int i = 0; i < count; ++i) {
            BigDecimal conversionRate;
            entryInfo = purInWarehsEntryCol.get(i);
            entryInfo.setCustomer(customerInfo);
            SaleReturnInnerDealPriceInfo priceInfo = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entryInfo.getPurOrderEntry());
            if (null == this.info.getPriceSource()) {
                this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo != null && this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entryInfo.setPrice(priceInfo.getPrice());
                entryInfo.setTaxRate(priceInfo.getTaxRate());
                if (priceInfo.getDiscountMode().getValue() == 1 && (double)priceInfo.getTaxPrice().longValue() > 0.0) {
                    entryInfo.setDiscountRate(priceInfo.getDiscount().divide(priceInfo.getTaxPrice(), 8, 6).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED));
                } else {
                    entryInfo.setDiscountRate(priceInfo.getDiscount());
                }
                entryInfo.setTaxPrice(priceInfo.getTaxPrice());
            }
            entryInfo.setBalanceSupplier(this.info.getSupplier());
            if (!StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) {
                saleReturnsEntryInfo = (SaleReturnsEntryInfo)orderEntryMap.get(entryInfo.getPurOrderEntry());
            }
            if (saleReturnsEntryInfo == null) continue;
            if (sourceCompanyOrgUnitInfo == null) {
                sourceCompanyOrgUnitInfo = saleReturnsEntryInfo.getCompanyOrgUnit();
            }
            entryUnit = entryInfo.getUnit();
            orderUnit = saleReturnsEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
    }

    private void reValueForVirtualBillIssuing() throws EASBizException, BOSException {
        if (this.info.getEntry().get(0).getPurOrder() == null) {
            return;
        }
        PurInWarehsEntryInfo entryInfo = null;
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        SaleOrderInfo saleOrderInfo = null;
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        HashMap<String, CustomerInfo> mapSOCompanyInfo = new HashMap<String, CustomerInfo>();
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        this.getCoreBillInfoMap(this.ctx, orderMap, orderEntryMap);
        PurInWarehsEntryCollection purInWarehsEntryCol = this.info.getEntry();
        int size = this.info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            BigDecimal conversionRate;
            entryInfo = purInWarehsEntryCol.get(i);
            if (entryInfo == null || entryInfo.getPurOrder() == null) continue;
            saleOrderInfo = (SaleOrderInfo)orderMap.get(entryInfo.getPurOrder());
            if (!mapSOCompanyInfo.containsKey(entryInfo.getPurOrder())) {
                mapSOCompanyInfo.put(entryInfo.getPurOrder(), CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleOrderInfo.getCompanyOrgUnit().getId().toString(), null).get(0));
            }
            entryInfo.setCustomer((CustomerInfo)mapSOCompanyInfo.get(entryInfo.getPurOrder()));
            entryInfo.setBalanceSupplier(this.info.getSupplier());
            SaleInnerDealPriceInfo priceInfo = SaleInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entryInfo.getPurOrder(), entryInfo.getPurOrderEntry());
            if (null == this.info.getPriceSource()) {
                this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo != null && this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entryInfo.setPrice(priceInfo.getPrice().multiply((BigDecimal)saleOrderInfo.get("exchangerate")));
                entryInfo.setTaxRate(priceInfo.getTaxRate());
                if (priceInfo.getDiscountMode().getValue() == 1 && (double)priceInfo.getTaxPrice().longValue() > 0.0) {
                    entryInfo.setDiscountRate(priceInfo.getDiscount().divide(priceInfo.getTaxPrice(), 8, 6).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED));
                } else {
                    entryInfo.setDiscountRate(priceInfo.getDiscount());
                }
                entryInfo.setTaxPrice(priceInfo.getTaxPrice().multiply((BigDecimal)saleOrderInfo.get("exchangerate")));
            }
            if (entryInfo.isIsPresent()) {
                entryInfo.setPrice(SysConstant.BIGZERO);
                entryInfo.setTaxRate(SysConstant.BIGZERO);
                entryInfo.setDiscountRate(SysConstant.BIGZERO);
                entryInfo.setTaxPrice(SysConstant.BIGZERO);
            }
            if (!StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) {
                saleOrderEntryInfo = (SaleOrderEntryInfo)orderEntryMap.get(entryInfo.getPurOrderEntry());
            }
            if (saleOrderEntryInfo == null) continue;
            if (sourceCompanyOrgUnitInfo == null) {
                sourceCompanyOrgUnitInfo = saleOrderEntryInfo.getCompanyOrgUnit();
            }
            entryUnit = entryInfo.getUnit();
            orderUnit = saleOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
    }

    @Override
    protected BigDecimal getActualCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getActualCost());
    }

    @Override
    protected BigDecimal getActualPrice(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getActualPrice());
    }

    @Override
    protected BigDecimal getAmount(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getAmount());
    }

    @Override
    protected int getAmountPrecision() {
        return this.amountPrecision;
    }

    @Override
    protected MeasureUnitInfo getAssistUnit(int i) {
        return this.info.getEntry().get(i).getAssistUnit();
    }

    @Override
    protected BigDecimal getBaseQty(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getBaseQty());
    }

    @Override
    protected ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    protected BigDecimal getDiscountAmount(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getDiscountAmount());
    }

    @Override
    protected BigDecimal getDiscountRate(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getDiscountRate());
    }

    @Override
    protected int getEntrySize() {
        return this.info.getEntry().size();
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return this.nullToZero(this.info.getExchangeRate());
    }

    @Override
    protected BigDecimal getLocalAmount(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getLocalAmount());
    }

    @Override
    protected int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    @Override
    protected BigDecimal getLocalPrice(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getLocalPrice());
    }

    @Override
    protected BigDecimal getLocalTax(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getLocalTax());
    }

    @Override
    protected BigDecimal getLocalTaxAmount(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getLocalTaxAmount());
    }

    @Override
    protected MaterialInfo getMaterial(int i) {
        return this.info.getEntry().get(i).getMaterial();
    }

    @Override
    protected BigDecimal getMaterialCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getMaterialCost());
    }

    @Override
    protected BigDecimal getPrice(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getPrice());
    }

    @Override
    protected int getPricePrecision(int i) {
        if (this.info.getEntry().get(i).getMaterial() == null) {
            return 0;
        }
        return this.info.getEntry().get(i).getMaterial().getPricePrecision();
    }

    @Override
    protected BigDecimal getPurchaseCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getPurchaseCost());
    }

    @Override
    protected BigDecimal getPurchaseFee(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getPurchaseFee());
    }

    @Override
    protected BigDecimal getQty(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getQty());
    }

    protected BigDecimal getUnitMaterialCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getUnitMaterialCost());
    }

    @Override
    protected StorageOrgUnitInfo getReceiveStorageOrgUnit(int i) {
        return this.info.getEntry().get(i).getReceiveStorageOrgUnit();
    }

    @Override
    protected BigDecimal getReturnBaseQty(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getReturnBaseQty());
    }

    @Override
    protected BigDecimal getStandardCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getStandardCost());
    }

    @Override
    protected BigDecimal getTax(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getTax());
    }

    @Override
    protected BigDecimal getTaxAmount(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getTaxAmount());
    }

    @Override
    protected BigDecimal getTaxPrice(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getTaxPrice());
    }

    @Override
    protected BigDecimal getTaxRate(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getTaxRate());
    }

    @Override
    protected TransactionTypeInfo getTransactionType() {
        return this.info.getTransactionType();
    }

    @Override
    protected MeasureUnitInfo getUnit(int i) {
        return this.info.getEntry().get(i).getUnit();
    }

    @Override
    protected WarehouseInfo getWarehouse(int i) {
        return this.info.getEntry().get(i).getWarehouse();
    }

    @Override
    protected BigDecimal getUnitPurchaseCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getUnitPurchaseCost());
    }

    @Override
    protected BigDecimal getUnitStandardCost(int i) {
        return this.nullToZero(this.info.getEntry().get(i).getUnitStandardCost());
    }

    @Override
    protected boolean isInTax() {
        return this.info.isIsInTax();
    }

    @Override
    protected boolean isIsPresent(int i) {
        return this.info.getEntry().get(i).isIsPresent();
    }

    @Override
    protected boolean isIsReversed() {
        return this.info.isIsReversed();
    }

    @Override
    protected boolean isPriceInTax() {
        return this.info.isIsPriceInTax();
    }

    @Override
    protected void setMaterial(MaterialInfo materialInfo, int i) {
        this.info.getEntry().get(i).setMaterial(materialInfo);
    }

    @Override
    protected void setActualCost(BigDecimal setScale, int i) {
        this.info.getEntry().get(i).setActualCost(setScale);
    }

    @Override
    protected void setActualPrice(BigDecimal price, int i) {
        this.info.getEntry().get(i).setActualPrice(price);
    }

    @Override
    protected void setActualTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntry().get(i).setActualTaxPrice(taxPrice);
    }

    @Override
    protected void setAmount(BigDecimal bigzero, int i) {
        this.info.getEntry().get(i).setAmount(bigzero);
    }

    @Override
    protected void setAssistQty(BigDecimal assistQty, int i) {
        this.info.getEntry().get(i).setAssistQty(assistQty);
    }

    @Override
    protected void setAssociateQty(BigDecimal associateQty, int i) {
        this.info.getEntry().get(i).setAssociateQty(associateQty);
    }

    @Override
    protected void setBaseQty(BigDecimal baseQty, int i) {
        this.info.getEntry().get(i).setBaseQty(baseQty);
    }

    @Override
    protected void setCanDirectReqBaseQty(BigDecimal canDirectReqBaseQty, int i) {
        this.info.getEntry().get(i).setCanDirectReqBaseQty(canDirectReqBaseQty);
    }

    @Override
    protected void setCanDirectReqQty(BigDecimal canDirectReqQty, int i) {
        this.info.getEntry().get(i).setCanDirectReqQty(canDirectReqQty);
    }

    @Override
    protected void setCompanyOrgUnit(CompanyOrgUnitInfo cou, int i) {
        this.info.getEntry().get(i).setCompanyOrgUnit(cou);
    }

    @Override
    protected void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.info.getEntry().get(i).setDiscountAmount(discountAmount);
    }

    @Override
    protected void setLocalAmount(BigDecimal localAmount, int i) {
        this.info.getEntry().get(i).setLocalAmount(localAmount);
    }

    @Override
    protected void setLocalPrice(BigDecimal localPrice, int i) {
        this.info.getEntry().get(i).setLocalPrice(localPrice);
    }

    @Override
    protected void setLocalTax(BigDecimal setScale, int i) {
        this.info.getEntry().get(i).setLocalTax(setScale);
    }

    @Override
    protected void setLocalTaxAmount(BigDecimal setScale, int i) {
        this.info.getEntry().get(i).setLocalTaxAmount(setScale);
    }

    @Override
    protected void setPrice(BigDecimal price, int i) {
        this.info.getEntry().get(i).setPrice(price);
    }

    @Override
    protected void setPurchaseCost(BigDecimal purchaseCost, int i) {
        this.info.getEntry().get(i).setPurchaseCost(purchaseCost);
    }

    protected void setPurchaseFee(BigDecimal purchaseFee, int i) {
        this.info.getEntry().get(i).setPurchaseFee(purchaseFee);
    }

    protected void setMaterialCost(BigDecimal materialCost, int i) {
        this.info.getEntry().get(i).setMaterialCost(materialCost);
    }

    @Override
    protected void setQty(BigDecimal qty, int i) {
        this.info.getEntry().get(i).setQty(qty);
    }

    @Override
    protected void setReceiveStorageOrgUnit(StorageOrgUnitInfo sou, int i) {
        this.info.getEntry().get(i).setReceiveStorageOrgUnit(sou);
    }

    @Override
    protected void setReturnBaseQty(BigDecimal returnBaseQty, int i) {
        this.info.getEntry().get(i).setReturnBaseQty(returnBaseQty);
    }

    @Override
    protected void setStandardCost(BigDecimal standardCost, int i) {
        this.info.getEntry().get(i).setStandardCost(standardCost);
    }

    @Override
    protected void setTax(BigDecimal tax, int i) {
        this.info.getEntry().get(i).setTax(tax);
    }

    @Override
    protected void setTaxAmount(BigDecimal taxAmount, int i) {
        this.info.getEntry().get(i).setTaxAmount(taxAmount);
    }

    @Override
    protected void setTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntry().get(i).setTaxPrice(taxPrice);
    }

    @Override
    protected void setTotalActualCost(BigDecimal totalActualCost) {
        this.info.setTotalActualCost(totalActualCost);
    }

    @Override
    protected void setTotalAmount(BigDecimal totalAmount) {
        this.info.setTotalAmount(totalAmount);
    }

    @Override
    protected void setTotalLocalAmount(BigDecimal totalLocalAmount) {
        this.info.setTotalLocalAmount(totalLocalAmount);
    }

    @Override
    protected void setTotalStandardCost(BigDecimal totalStandardCost) {
        this.info.setTotalStandardCost(totalStandardCost);
    }

    @Override
    protected void setUnitActualCost(BigDecimal divide, int i) {
        this.info.getEntry().get(i).setUnitActualCost(divide);
    }

    @Override
    protected void setUnitPurchaseCost(BigDecimal actualPrice, int i) {
        this.info.getEntry().get(i).setUnitPurchaseCost(actualPrice);
    }

    @Override
    protected void setUnitStandardCost(BigDecimal unitStandardCost, int i) {
        this.info.getEntry().get(i).setUnitStandardCost(unitStandardCost);
    }

    @Override
    protected void setUnReturnedBaseQty(BigDecimal unReturnedBaseQty, int i) {
        this.info.getEntry().get(i).setUnReturnedBaseQty(unReturnedBaseQty);
    }

    @Override
    protected void setUnWriteOffAmount(BigDecimal unWriteOffAmount, int i) {
        this.info.getEntry().get(i).setUnWriteOffAmount(unWriteOffAmount);
    }

    @Override
    protected void setUnWriteOffBaseQty(BigDecimal unWriteOffBaseQty, int i) {
        this.info.getEntry().get(i).setUnWriteOffBaseQty(unWriteOffBaseQty);
    }

    @Override
    protected void setUnWriteOffQty(BigDecimal unWriteOffQty, int i) {
        this.info.getEntry().get(i).setUnWriteOffQty(unWriteOffQty);
    }

    @Override
    protected void setWrittenOffAmount(BigDecimal writtenOffAmount, int i) {
        this.info.getEntry().get(i).setWrittenOffAmount(writtenOffAmount);
    }

    @Override
    protected void setWrittenOffBaseQty(BigDecimal writtenOffBaseQty, int i) {
        this.info.getEntry().get(i).setWrittenOffBaseQty(writtenOffBaseQty);
    }

    @Override
    protected void setWrittenOffQty(BigDecimal writtenOffQty, int i) {
        this.info.getEntry().get(i).setWrittenOffQty(writtenOffQty);
    }

    private void reCalQtyFields() throws EASBizException, BOSException {
        boolean isNegativeBill = this.isNegativeBill();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.getQty(i) == null) {
                this.setQty(SysConstant.BIGZERO, i);
            }
            this.setQty(isNegativeBill ? this.getQty(i).abs().negate() : this.getQty(i).abs(), i);
            this.calBaseQtyByQty(i);
            if (!(this.info.getEntry().get(i).getAssistUnit() == null || this.info.getSourceBillType() != null && this.info.getEntry().get(i).getAssistQty() != null || this.info.getBoolean("fromMerge"))) {
                this.calAssistQtyByBaseQty(i);
            }
            this.setReturnBaseQty(this.nullToZero(this.getReturnBaseQty(i)), i);
            this.setAssociateQty(this.getBaseQty(i).abs(), i);
            this.setUnReturnedBaseQty(this.getBaseQty(i).abs().subtract(this.getReturnBaseQty(i).abs()), i);
            this.setCanDirectReqQty(this.getQty(i), i);
            this.setCanDirectReqBaseQty(this.getBaseQty(i), i);
        }
    }

    private void reCalStandardCostFields() throws EASBizException, BOSException {
        if (this.cou == null && this.sou != null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(this.sou.getId().toString(), 4, 1);
            this.cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.sou == null || this.sou.getId() == null) {
                this.setUnitStandardCost(SysConstant.BIGZERO, i);
                this.setStandardCost(SysConstant.BIGZERO, i);
                continue;
            }
            this.calUnitStandardCost(i);
            this.calStandardCostByUnitStandardCost(i);
        }
    }

    private void reCalWriteOffFields() throws EASBizException, BOSException {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (!this.isIsPresent(i)) {
                this.setUnWriteOffQty(this.getQty(i), i);
                this.setUnWriteOffAmount(this.getPurchaseCost(i), i);
                this.setUnWriteOffBaseQty(this.getBaseQty(i), i);
                this.setWrittenOffQty(SysConstant.BIGZERO, i);
                this.setWrittenOffBaseQty(SysConstant.BIGZERO, i);
                this.setWrittenOffAmount(SysConstant.BIGZERO, i);
                continue;
            }
            this.setUnWriteOffQty(SysConstant.BIGZERO, i);
            this.setUnWriteOffBaseQty(SysConstant.BIGZERO, i);
            this.setUnWriteOffAmount(SysConstant.BIGZERO, i);
            this.setWrittenOffQty(this.getQty(i), i);
            this.setWrittenOffBaseQty(this.getBaseQty(i), i);
            this.setWrittenOffAmount(this.getPurchaseCost(i), i);
        }
    }

    private void reCalPurchaseFee() throws EASBizException, BOSException {
        boolean isNegativeBill = this.isNegativeBill();
        if (isNegativeBill) {
            int size = this.getEntrySize();
            for (int i = 0; i < size; ++i) {
                this.setPurchaseFee(this.getPurchaseFee(i).abs().negate(), i);
            }
        }
    }

    private void reCalLocalPriceAndAmount(StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou) {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.setCompanyOrgUnit(cou, i);
            if (this.getReceiveStorageOrgUnit(i) == null) {
                this.setReceiveStorageOrgUnit(sou, i);
            }
            if (this.getPrice(i) == null) {
                this.setPrice(SysConstant.BIGZERO, i);
            }
            if (this.getLocalPrice(i) == null) {
                this.setLocalPrice(SysConstant.BIGZERO, i);
            }
            BigDecimal localPrice = SysConstant.BIGZERO;
            if (this.getLocalPrice(i).compareTo(SysConstant.BIGZERO) == 0) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
                    localPrice = this.getPrice(i).multiply(this.getExchangeRate());
                    localPrice = localPrice.setScale(this.getPricePrecision(i), 4);
                }
                this.setLocalPrice(localPrice, i);
            } else {
                localPrice = this.getLocalPrice(i);
                localPrice = localPrice.setScale(this.getPricePrecision(i), 4);
                this.setLocalPrice(localPrice, i);
            }
            BigDecimal localAmount = SysConstant.BIGZERO;
            if (this.getLocalAmount(i) == null || this.getLocalAmount(i).compareTo(SysConstant.BIGZERO) == 0) {
                localAmount = this.getLocalPrice(i).multiply(this.getQty(i));
                localAmount = localAmount.setScale(this.getLocalAmountPrecision(), 4);
                this.setLocalAmount(localAmount, i);
                continue;
            }
            this.setLocalAmount(this.getLocalAmount(i).setScale(this.getLocalAmountPrecision(), 4), i);
        }
    }

    private void reCalculate(StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        this.reCalQtyFields();
        this.reCalPurchaseFee();
        this.reCalMaterialCost();
        this.reCalEntryFields();
        this.reCalStandardCostFields();
        this.reCalWriteOffFields();
        this.reCalLocalPriceAndAmount(sou, cou);
        this.reCalTotalFields();
    }

    private void reCalMaterialCost() throws EASBizException, BOSException {
        int size = this.getEntrySize();
        for (int i = 0; i < size; ++i) {
            this.setMaterialCost(this.getQty(i).multiply(this.getUnitMaterialCost(i)), i);
        }
    }

    private void reValueForCoreIsPurOrder(PurInWarehsBillInfo info, CompanyOrgUnitInfo cou, Context ctx) throws EASBizException, BOSException {
        String strPurOrder = info.getEntry().get(0).getPurOrder();
        PurOrderInfo orderInfo = null;
        CompanyOrgUnitInfo purCouInfo = null;
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        IPurOrder ip = PurOrderFactory.getLocalInstance((Context)ctx);
        PurOrderInfo poi = null;
        HashMap<String, SupplierInfo> mapPOCompanyInfo = new HashMap<String, SupplierInfo>();
        HashMap<String, PurOrderInfo> mapPOBillInfo = new HashMap<String, PurOrderInfo>();
        PurInWarehsEntryCollection purInWarehsEntryCol = info.getEntry();
        PurInWarehsEntryInfo entry = null;
        PurOrderEntryInfo purOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        PurInnerDealPriceInfo priceInfo = null;
        boolean isCenterBalance = false;
        Map<String, PurInnerDealPriceInfo> priceMap = null;
        HashMap<String, SupplierInfo> balanceSupplierMap = new HashMap<String, SupplierInfo>();
        this.orderMap = new HashMap<String, PurOrderInfo>();
        this.orderEntryMap = new HashMap<String, PurOrderEntryInfo>();
        this.getCoreBillInfoMap(ctx, this.orderMap, this.orderEntryMap);
        int size = purInWarehsEntryCol.size();
        for (int i = 0; i < size; ++i) {
            entry = purInWarehsEntryCol.get(i);
            if (entry == null || !entry.isIsCenterBalance() || !entry.isIsBetweenCompanySend()) continue;
            isCenterBalance = true;
            break;
        }
        if (null == info.getPriceSource()) {
            info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
        }
        if (isCenterBalance && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL)) {
            priceMap = this.getInnerDealPrice(ctx);
            if (priceMap != null && priceMap.containsKey(entry.getPurOrderEntry()) && (priceInfo = priceMap.get(purInWarehsEntryCol.get(0).getPurOrderEntry())) != null) {
                info.setCurrency(priceInfo.getCurrency());
                this.amountPrecision = priceInfo.getCurrency().getPrecision();
                info.setExchangeRate(priceInfo.getExchangeRate());
            }
        } else if (!StringUtils.isEmpty((String)strPurOrder) && this.orderMap.get(strPurOrder) != null && (orderInfo = this.orderMap.get(strPurOrder)) != null) {
            if (orderInfo.getCurrency() != null) {
                CurrencyInfo currencyInfo = orderInfo.getCurrency();
                info.setCurrency(currencyInfo);
                this.amountPrecision = currencyInfo.getPrecision();
            }
            if (orderInfo.getCompanyOrgUnit() != null) {
                purCouInfo = orderInfo.getCompanyOrgUnit();
            }
            this.initExchange(purCouInfo);
        }
        PurPriceInfoCollection cols = this.getPurPriceInfoCollection(ctx, info);
        int size2 = purInWarehsEntryCol.size();
        for (int i = 0; i < size2; ++i) {
            BigDecimal conversionRate;
            entry = purInWarehsEntryCol.get(i);
            if (entry == null || StringUtils.isEmpty((String)entry.getPurOrder())) continue;
            if (entry.isIsCenterBalance() && entry.isIsBetweenCompanySend()) {
                if (priceMap != null && priceMap.containsKey(entry.getPurOrderEntry())) {
                    priceInfo = priceMap.get(entry.getPurOrderEntry());
                    if (priceInfo == null) continue;
                    if (!(info.getPriceSource() != null && !info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO))) {
                        entry.setPrice(priceInfo.getPrice());
                        entry.setTaxRate(priceInfo.getTaxRate());
                        if (priceInfo.getDiscountMode().getValue() == 1 && (double)priceInfo.getTaxPrice().longValue() > 0.0) {
                            entry.setDiscountRate(priceInfo.getDiscount().divide(priceInfo.getTaxPrice(), 8, 6).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED));
                        } else {
                            entry.setDiscountRate(priceInfo.getDiscount());
                        }
                        entry.setTaxPrice(priceInfo.getTaxPrice());
                        if (entry.getWarehouse() == null) {
                            entry.setWarehouse(priceInfo.getRecWareHouse());
                        }
                    }
                    if (priceInfo.getSupCompanyOrg() != null) {
                        SupplierCollection innerSupplierCollection;
                        if (!balanceSupplierMap.containsKey(priceInfo.getSupCompanyOrg().getId().toString()) && (innerSupplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getInterSupplierCollection(priceInfo.getSupCompanyOrg().getId().toString(), null)) != null && innerSupplierCollection.size() > 0) {
                            balanceSupplierMap.put(priceInfo.getSupCompanyOrg().getId().toString(), innerSupplierCollection.get(0));
                        }
                        entry.setBalanceSupplier((SupplierInfo)balanceSupplierMap.get(priceInfo.getSupCompanyOrg().getId().toString()));
                    }
                } else {
                    if (!mapPOBillInfo.containsKey(entry.getPurOrder())) {
                        poi = ip.getPurOrderInfo((IObjectPK)new ObjectUuidPK(entry.getPurOrder()));
                        mapPOBillInfo.put(entry.getPurOrder(), poi);
                    } else {
                        poi = (PurOrderInfo)mapPOBillInfo.get(entry.getPurOrder());
                    }
                    if (!mapPOCompanyInfo.containsKey(entry.getPurOrder())) {
                        orderInfo = this.orderMap.get(entry.getPurOrder());
                        mapPOCompanyInfo.put(entry.getPurOrder(), iSupplier.getInterSupplierCollection(orderInfo.getCompanyOrgUnit().getId().toString(), null).get(0));
                    }
                    entry.setBalanceSupplier((SupplierInfo)mapPOCompanyInfo.get(entry.getPurOrder()));
                }
            } else {
                entry.setBalanceSupplier(info.getSupplier());
                if (!BillRelationOptionEnum.BRINGIN.equals((Object)info.getBillRelationOption())) {
                    this.fetchPrice(ctx, info, cols);
                }
            }
            if (!StringUtils.isEmpty((String)entry.getPurOrderEntry())) {
                purOrderEntryInfo = this.orderEntryMap.get(entry.getPurOrderEntry());
            }
            if (purOrderEntryInfo == null) continue;
            entryUnit = entry.getUnit();
            orderUnit = purOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entry.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (info.isIsInTax()) {
                BigDecimal taxPrice = SysConstant.BIGZERO;
                taxPrice = entry.isIsCenterBalance() && entry.isIsBetweenCompanySend() && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) ? entry.getTaxPrice() : (purOrderEntryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : purOrderEntryInfo.getTaxPrice());
                taxPrice = taxPrice.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
                entry.setTaxPrice(taxPrice);
                this.calByTaxPrice(i);
                continue;
            }
            BigDecimal price = SysConstant.BIGZERO;
            price = entry.isIsCenterBalance() && entry.isIsBetweenCompanySend() && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) ? entry.getPrice() : (purOrderEntryInfo.getPrice() == null ? SysConstant.BIGZERO : purOrderEntryInfo.getPrice());
            price = price.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
            entry.setPrice(price);
            this.calByPrice(i);
        }
    }

    private PurPriceInfoCollection getPurPriceInfoCollection(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        PurPriceInfoCollection cols = null;
        PurInWarehsEntryInfo entryInfo = null;
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBizTypeId(info.getBizType().getId().toString());
        paramCol.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        BizTypeInfo bizType = info.getBizType();
        String bizCategoryId = null;
        if (bizType != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("bizCategory.id"));
            try {
                bizType = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizType.getId()), selector);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bizType != null && bizType.getBizCategory() != null) {
                bizCategoryId = bizType.getBizCategory().getId().toString();
            }
        }
        for (int j = 0; j < info.getEntries().size(); ++j) {
            entryInfo = info.getEntry().get(j);
            if (entryInfo.getStorageOrgUnit() == null || entryInfo.getMaterial() == null || entryInfo.isIsPresent()) continue;
            PurPriceParam param = this.getPriceParam(info, entryInfo, j, bizCategoryId);
            paramCol.addPurPriceParam(param);
        }
        if (paramCol.size() > 0) {
            cols = PurServiceFacadeFactory.getLocalInstance((Context)ctx).fetchPrice(paramCol);
        }
        return cols;
    }

    private void reValueForCoreIsPurReturns(PurInWarehsBillInfo info, CompanyOrgUnitInfo cou, Context ctx) throws EASBizException, BOSException {
        PurReturnsInfo purReturns = PurReturnsFactory.getLocalInstance((Context)ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(info.getEntry().get(0).getPurOrder()));
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = cou;
        if (purReturns.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(purReturns.getCurrency().getId()));
            info.setCurrency(currency);
            this.amountPrecision = info.getCurrency().getPrecision();
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
        PurPriceInfoCollection cols = this.getPurPriceInfoCollection(ctx, info);
        this.fetchPrice(ctx, info, cols);
    }

    private void reValueForTransfer2Sides(PurInWarehsBillInfo info, Context ctx) throws BOSException, EASBizException {
        TransferOrderBillInfo sourceInfo;
        String strCoreOrderId;
        TransferOrderBillEntryInfo sourceEntryInfo;
        SupplierInfo supplierEntry = null;
        PurInWarehsEntryInfo entry = null;
        TransferOrderBillEntryInfo transferOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        this.getCoreBillInfoMap(ctx, orderMap, orderEntryMap);
        PurInWarehsEntryInfo eie = info.getEntry().get(0);
        if (eie == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)eie.getPurOrderEntry()) && (sourceEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(eie.getPurOrderEntry())) != null && sourceEntryInfo.getIssueCompanyOrgUnit() != null) {
            supplierEntry = SupplierFactory.getLocalInstance((Context)ctx).getInterSupplierCollection(sourceEntryInfo.getIssueCompanyOrgUnit().getId().toString(), null).get(0);
        }
        if (!StringUtils.isEmpty((String)(strCoreOrderId = eie.getPurOrder())) && (sourceInfo = (TransferOrderBillInfo)orderMap.get(strCoreOrderId)) != null) {
            if (sourceInfo.getCurrency() != null) {
                CurrencyInfo currency = sourceInfo.getCurrency();
                info.setCurrency(currency);
                info.setExchangeRate(sourceInfo.getExchangeRate());
                this.amountPrecision = info.getCurrency().getPrecision();
            }
            this.initExchange(sourceInfo.getIssueCompanyOrgUnit());
        }
        IMultiSidesTransferPrices ims = MultiSidesTransferPricesFactory.getLocalInstance(ctx);
        String bizType = info.getBizType().getId().toString();
        if (bizType.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            bizType = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            bizType = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            bizType = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        String[] coreBillEntryIDs = new String[info.getEntry().size()];
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entry = info.getEntry().get(i);
            coreBillEntryIDs[i] = entry.getPurOrderEntry();
        }
        Map priceMap = ims.getPriceInfos(coreBillEntryIDs, this.cou.getId().toString(), "103", bizType);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            BigDecimal conversionRate;
            entry = info.getEntry().get(i);
            entry.setBalanceSupplier(supplierEntry);
            MultiSidesTransferPricesInfo priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entry.getPurOrderEntry());
            if (null == info.getPriceSource()) {
                info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo != null && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entry.setPrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscountRate(priceInfo.getDiscountRate());
                entry.setTaxPrice(priceInfo.getTaxPrice());
            }
            if (!StringUtils.isEmpty((String)entry.getPurOrderEntry())) {
                transferOrderEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(entry.getPurOrderEntry());
            }
            if (transferOrderEntryInfo == null) continue;
            entryUnit = entry.getUnit();
            orderUnit = transferOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entry.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (info.isIsInTax()) {
                BigDecimal taxPrice = entry.getTaxPrice() == null ? SysConstant.BIGZERO : entry.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
                entry.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entry.getPrice() == null ? SysConstant.BIGZERO : entry.getPrice();
            price = price.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
            entry.setPrice(price);
        }
    }

    private void reValueForTransfer3Sides(PurInWarehsBillInfo info, Context ctx) throws BOSException, EASBizException {
        TransferOrderBillInfo sourceInfo;
        SupplierInfo supplierEntry = null;
        PurInWarehsEntryInfo entry = null;
        TransferOrderBillEntryInfo transferOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        this.getCoreBillInfoMap(ctx, orderMap, orderEntryMap);
        PurInWarehsEntryInfo eie = info.getEntry().get(0);
        if (!StringUtils.isEmpty((String)eie.getPurOrder()) && (sourceInfo = (TransferOrderBillInfo)orderMap.get(eie.getPurOrder())) != null) {
            CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
            if (sourceInfo.getIssueCompanyOrgUnit() != null) {
                sourceCompanyOrgUnitInfo = sourceInfo.getIssueCompanyOrgUnit();
                supplierEntry = SupplierFactory.getLocalInstance((Context)ctx).getInterSupplierCollection(sourceCompanyOrgUnitInfo.getId().toString(), null).get(0);
            }
            if (sourceInfo.getCurrency() != null) {
                CurrencyInfo currency = sourceInfo.getCurrency();
                info.setCurrency(currency);
                this.amountPrecision = info.getCurrency().getPrecision();
            }
            this.initExchange(sourceCompanyOrgUnitInfo);
        }
        IMultiSidesTransferPrices ims = MultiSidesTransferPricesFactory.getLocalInstance(ctx);
        String bizType = info.getBizType().getId().toString();
        if (bizType.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            bizType = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            bizType = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            bizType = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        String[] coreBillEntryIDs = new String[info.getEntry().size()];
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entry = info.getEntry().get(i);
            coreBillEntryIDs[i] = entry.getPurOrderEntry();
        }
        Map priceMap = ims.getPriceInfos(coreBillEntryIDs, this.cou.getId().toString(), "103", bizType);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            BigDecimal conversionRate;
            entry = info.getEntry().get(i);
            entry.setBalanceSupplier(supplierEntry);
            MultiSidesTransferPricesInfo priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entry.getPurOrderEntry());
            if (null == info.getPriceSource()) {
                info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo != null && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entry.setPrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscountRate(priceInfo.getDiscountRate());
                entry.setTaxPrice(priceInfo.getTaxPrice());
            }
            if (!StringUtils.isEmpty((String)entry.getPurOrderEntry())) {
                transferOrderEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(entry.getPurOrderEntry());
            }
            if (transferOrderEntryInfo == null) continue;
            entryUnit = entry.getUnit();
            orderUnit = transferOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entry.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (info.isIsInTax()) {
                BigDecimal taxPrice = entry.getTaxPrice() == null ? SysConstant.BIGZERO : entry.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
                entry.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entry.getPrice() == null ? SysConstant.BIGZERO : entry.getPrice();
            price = price.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
            entry.setPrice(price);
        }
    }

    private void reValueForTransfer4Sides(PurInWarehsBillInfo info, CompanyOrgUnitInfo cou, Context ctx) throws EASBizException, BOSException {
        TransferOrderBillInfo orderBillInfo;
        SupplierInfo supplierEntry = null;
        Map priceMap = null;
        PurInWarehsEntryInfo entry = null;
        TransferOrderBillEntryInfo transferOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        HashMap orderMap = new HashMap();
        HashMap orderEntryMap = new HashMap();
        PurInWarehsEntryInfo eie = info.getEntry().get(0);
        if (eie == null) {
            return;
        }
        this.getCoreBillInfoMap(ctx, orderMap, orderEntryMap);
        if (!StringUtils.isEmpty((String)eie.getPurOrder()) && (orderBillInfo = (TransferOrderBillInfo)orderMap.get(eie.getPurOrder())) != null) {
            if (orderBillInfo.getIssueCompanyOrgUnit() != null) {
                sourceCompanyOrgUnitInfo = orderBillInfo.getIssueCompanyOrgUnit();
            }
            if (orderBillInfo.getCurrency() != null) {
                CurrencyInfo currency = orderBillInfo.getCurrency();
                info.setCurrency(currency);
                this.amountPrecision = info.getCurrency().getPrecision();
            }
            if (orderBillInfo.getReceiptCompanyOrgUnit() != null) {
                supplierEntry = SupplierFactory.getLocalInstance((Context)ctx).getInterSupplierCollection(orderBillInfo.getReceiptCompanyOrgUnit().getId().toString(), null).get(0);
            }
            this.initExchange(sourceCompanyOrgUnitInfo);
        }
        String[] coreBillEntryIDs = new String[info.getEntry().size()];
        for (int i = 0; i < info.getEntry().size(); ++i) {
            entry = info.getEntry().get(i);
            coreBillEntryIDs[i] = entry.getPurOrderEntry();
        }
        IMultiSidesTransferPrices ims = null;
        ims = MultiSidesTransferPricesFactory.getLocalInstance(ctx);
        String bizType = info.getBizType().getId().toString();
        if (bizType.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            bizType = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            bizType = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            bizType = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        priceMap = ims.getPriceInfos(coreBillEntryIDs, cou.getId().toString(), "103", bizType);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            BigDecimal conversionRate;
            entry = info.getEntry().get(i);
            MultiSidesTransferPricesInfo priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entry.getPurOrderEntry());
            if (null == info.getPriceSource()) {
                info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo != null && info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entry.setPrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscountRate(priceInfo.getDiscountRate());
                entry.setTaxPrice(priceInfo.getTaxPrice());
            }
            entry.setBalanceSupplier(supplierEntry);
            if (!StringUtils.isEmpty((String)entry.getPurOrderEntry())) {
                transferOrderEntryInfo = (TransferOrderBillEntryInfo)orderEntryMap.get(entry.getPurOrderEntry());
            }
            if (transferOrderEntryInfo == null) continue;
            entryUnit = entry.getUnit();
            orderUnit = transferOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entry.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (info.isIsInTax()) {
                BigDecimal taxPrice = entry.getTaxPrice() == null ? SysConstant.BIGZERO : entry.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
                entry.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entry.getPrice() == null ? SysConstant.BIGZERO : entry.getPrice();
            price = price.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
            entry.setPrice(price);
        }
    }

    private void setTaxRate(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        boolean isGetValue = true;
        if (info.getEntry().get(0).getCoreBillType() != null && !StringUtils.isEmpty((String)info.getEntry().get(0).getPurOrder())) {
            PurOrderInfo coreBillInfo;
            String coreBillTypeId = info.getEntry().get(0).getCoreBillType().getId().toString();
            String coreBillId = info.getEntry().get(0).getPurOrder();
            String companyId = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
            if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId)) {
                coreBillInfo = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(coreBillId), sic);
                if (coreBillInfo != null && coreBillInfo.getCompanyOrgUnit() != null) {
                    companyId = coreBillInfo.getCompanyOrgUnit().getId().toString();
                }
            } else if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(coreBillTypeId) && (coreBillInfo = PurReturnsFactory.getLocalInstance((Context)ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(coreBillId), sic)) != null && coreBillInfo.getEntries().get(0) != null && coreBillInfo.getEntries().get(0).getCompanyOrgUnit() != null) {
                companyId = coreBillInfo.getEntries().get(0).getCompanyOrgUnit().getId().toString();
            }
            if (!StringUtils.isEmpty(companyId) && this.cou != null && this.cou.getId().toString().equals(companyId)) {
                isGetValue = false;
            }
        }
        if (info.getSupplier() != null && isGetValue) {
            if (info.getSupplier().getTaxRate() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("taxRate"));
                SupplierInfo suppInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getSupplier().getId().toString()), sic);
                info.getSupplier().setTaxRate(suppInfo.getTaxRate());
            }
            BigDecimal taxRate = info.getSupplier().getTaxRate();
            PurInWarehsEntryInfo entryInfo = null;
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = info.getEntry().get(i);
            }
        }
    }

    private void setTaxRate(Context ctx, PurInWarehsBillInfo info, PurInWarehsEntryInfo entryInfo) throws EASBizException, BOSException {
        if ((entryInfo.getTaxRate() == null || BigDecimal.ZERO.equals(entryInfo.getTaxRate())) && info.getSupplier() != null) {
            if (info.getSupplier().getTaxRate() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("taxRate"));
                SupplierInfo suppInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getSupplier().getId().toString()), sic);
                info.getSupplier().setTaxRate(suppInfo.getTaxRate());
            }
            BigDecimal taxRate = info.getSupplier().getTaxRate();
            entryInfo.setTaxRate(taxRate);
        }
    }

    private void reValueInfo(PurInWarehsBillInfo info, StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou, Context ctx) throws EASBizException, BOSException {
        this.resetEntryMaterialInfo();
        this.setGuaranteePeriodByLot(info, sou, ctx);
        BillTypeInfo sourceBillType = info.getSourceBillType();
        String sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        this.setDefaultValue();
        boolean isBillRelatin = BillRelationOptionEnum.BRINGIN.equals((Object)info.getBillRelationOption());
        if (!isBillRelatin) {
            this.calByUnitSource(ctx, (InvBillBaseInfo)info, (IObjectCollection)info.getEntry());
            this.setTaxRate(ctx, info);
            this.reCalculate(sou, cou);
        } else {
            this.dealSubOrderBillRelation(sourceBillTypeID, sou, cou);
            this.dealPurOrderBillRelation(sourceBillTypeID, sou, cou);
        }
    }

    private void dealSubOrderBillRelation(String sourceBillTypeID, StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        if ("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(sourceBillTypeID)) {
            boolean isCanBillRelation = false;
            if (!this.info.isIsSysBill()) {
                isCanBillRelation = true;
            }
            if (!isCanBillRelation) {
                this.setTaxRate(this.ctx, this.info);
                this.reCalculate(sou, cou);
            } else {
                this.reCalQtyFields();
                this.getsubOrderEntryBaseQty();
                this.reCalPurchaseFee();
                String key = null;
                PurInWarehsEntryInfo entry = null;
                BigDecimal baseQty = new BigDecimal("0.00");
                int size = this.info.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    entry = this.info.getEntry().get(i);
                    key = entry.getSourceBillEntryId();
                    baseQty = this.subBaseQtyMap.get(key);
                    if (baseQty.compareTo(entry.getBaseQty()) == 0) {
                        this.checkBotp(entry);
                        this.reCalPurchaseCost(i);
                        this.reCalUnitPurchaseCost(i);
                        this.calActualCost(i);
                        this.calUnitActualCost(i);
                        this.reCalEntryFields4UnitSource(i);
                        continue;
                    }
                    this.reCalEntryFields(i);
                }
                this.reCalStandardCostFields();
                this.reCalWriteOffFields();
                this.reCalLocalPriceAndAmount(sou, cou);
                this.reCalTotalFields();
            }
        }
    }

    private void dealPurOrderBillRelation(String sourceBillTypeID, StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        String coreBillTypeID;
        BillTypeInfo coreBillType = this.info.getEntry().get(0).getCoreBillType();
        String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(sourceBillTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeID)) {
            this.reCalQtyFields();
            this.getPurOrderEntryQty();
            this.reCalPurchaseFee();
            String key = null;
            PurInWarehsEntryInfo entry = null;
            BigDecimal baseQty = new BigDecimal("0.00");
            int size = this.info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entry = this.info.getEntry().get(i);
                if (entry.isIsBetweenCompanySend()) {
                    this.setTaxRate(this.ctx, this.info, entry);
                    this.reCalEntryFields(i);
                    continue;
                }
                key = entry.getSourceBillEntryId();
                if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeID)) {
                    key = entry.getPurOrderEntry();
                }
                baseQty = this.poBaseQtyMap.get(key);
                baseQty = this.poBaseQtyMap.get(key);
                if (baseQty.compareTo(entry.getBaseQty()) == 0) {
                    this.checkBotp(entry);
                    this.reCalPurchaseCost(i);
                    this.reCalUnitPurchaseCost(i);
                    this.calActualCost(i);
                    this.calUnitActualCost(i);
                    this.reCalEntryFields4UnitSource(i);
                    continue;
                }
                this.reCalEntryFields(i);
            }
            this.reCalStandardCostFields();
            this.reCalWriteOffFields();
            this.reCalLocalPriceAndAmount(sou, cou);
            this.reCalTotalFields();
        }
    }

    private void getPurOrderEntryQty() throws EASBizException, BOSException {
        String coreBillTypeID;
        this.poBaseQtyMap = new HashMap();
        this.poAssociateMap = new HashMap();
        BillTypeInfo sourceBillType = this.info.getSourceBillType();
        String sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        BillTypeInfo coreBillType = this.info.getEntry().get(0).getCoreBillType();
        String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(sourceBillTypeID) || "50957179-0105-1000-e000-0157c0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeID)) {
            if (this.orderMap.isEmpty()) {
                this.getCoreBillInfoMap(this.ctx, this.orderMap, this.orderEntryMap);
            }
            Map.Entry<String, PurOrderEntryInfo> mapEntry2 = null;
            for (Map.Entry<String, PurOrderEntryInfo> mapEntry2 : this.orderEntryMap.entrySet()) {
                this.poBaseQtyMap.put(mapEntry2.getKey(), mapEntry2.getValue().getBaseQty());
                this.poAssociateMap.put(mapEntry2.getKey(), mapEntry2.getValue().getAssociateQty());
            }
        }
    }

    private void getsubOrderEntryBaseQty() throws EASBizException, BOSException {
        String sourceBillTypeID;
        this.subBaseQtyMap = new HashMap();
        this.subAssociateMap = new HashMap();
        BillTypeInfo sourceBillType = this.info.getSourceBillType();
        String string = sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        if ("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=".equals(sourceBillTypeID)) {
            SubContractOrderInfo subOrderInfo = SubContractOrderFactory.getLocalInstance((Context)this.ctx).getSubContractOrderInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSourceBillId()));
            SubContractOrderEntryInfo subEntry = null;
            if (subOrderInfo != null) {
                for (int i = 0; i < subOrderInfo.getEntries().size(); ++i) {
                    subEntry = subOrderInfo.getEntries().get(i);
                    this.subBaseQtyMap.put(subEntry.getId().toString(), subEntry.getBaseQty());
                    this.subAssociateMap.put(subEntry.getId().toString(), subEntry.getAssociateQty());
                }
            }
        }
    }

    private void checkBotp(PurInWarehsEntryInfo entry) throws BOSException, EASBizException {
        if (entry == null) {
            return;
        }
        StringBuffer detail = new StringBuffer();
        StringBuffer errorMsg = new StringBuffer();
        if (!entry.isIsPresent()) {
            if (entry.getPrice() == null || BigDecimal.ZERO.compareTo(entry.getPrice()) == 0) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SALEPRICE", (Context)this.ctx)).append(", ");
            }
            if (entry.getTaxPrice() == null || BigDecimal.ZERO.compareTo(entry.getTaxPrice()) == 0) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAXPRICE", (Context)this.ctx)).append(", ");
            }
            if (entry.getDiscountRate() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"DISCOUNT", (Context)this.ctx)).append(", ");
            }
            if (entry.getDiscountAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"DISCOUNTAMOUNT", (Context)this.ctx)).append(", ");
            }
            if (entry.getActualPrice() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ACTUALPRICE", (Context)this.ctx)).append(", ");
            }
            if (entry.getActualTaxPrice() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"PRICE", (Context)this.ctx)).append(", ");
            }
            boolean isIgnore = false;
            if (entry.getDiscountRate().compareTo(new BigDecimal("100")) == 0) {
                isIgnore = true;
            }
            if (!(isIgnore || entry.getAmount() != null && BigDecimal.ZERO.compareTo(entry.getAmount()) != 0)) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"NONTAXAMOUNT", (Context)this.ctx)).append(", ");
            }
            if (entry.getLocalAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALNONTAXMOUNT", (Context)this.ctx)).append(", ");
            }
            if (entry.getTaxRate() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAXRATE", (Context)this.ctx)).append(", ");
            }
            if (entry.getTax() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAX", (Context)this.ctx)).append(", ");
            }
            if (entry.getLocalTax() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALTAX", (Context)this.ctx)).append(", ");
            }
            if (entry.getTaxAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AMOUNT", (Context)this.ctx)).append(", ");
            }
            if (entry.getLocalTaxAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALAMOUNT", (Context)this.ctx));
            }
            if (detail.length() > 0) {
                errorMsg.append("\n");
                errorMsg.append(detail);
                throw new InvBizException(InvBizException.BILLRELATIONFIELDNOTNULL, new String[]{errorMsg.toString()});
            }
        }
    }

    private void setGuaranteePeriodByLot(PurInWarehsBillInfo info, StorageOrgUnitInfo sou, Context ctx) throws BOSException {
        Map<String, DateOfMinDurabilityInfo> DateOfMinMap = this.getDateOfMinDurabilityMap();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            String key;
            DateOfMinDurabilityInfo dod;
            PurInWarehsEntryInfo entry = info.getEntry().get(i);
            if (StringUtils.isEmpty((String)entry.getLot()) || (dod = DateOfMinMap.get(key = entry.getMaterial().getId().toString() + entry.getLot())) == null) continue;
            entry.setMfg(dod.getMfg());
            entry.setExp(dod.getExp());
        }
    }

    private Map<String, DateOfMinDurabilityInfo> getDateOfMinDurabilityMap() throws BOSException {
        HashMap<String, DateOfMinDurabilityInfo> DateOfMinMap = new HashMap<String, DateOfMinDurabilityInfo>();
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> lotSet = new HashSet<String>();
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            PurInWarehsEntryInfo entry = this.info.getEntry().get(i);
            if (StringUtils.isEmpty((String)entry.getLot())) continue;
            materialIdSet.add(entry.getMaterial().getId().toString());
            lotSet.add(entry.getLot());
        }
        IDateOfMinDurability ido = DateOfMinDurabilityFactory.getLocalInstance(this.ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)this.sou.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("material", materialIdSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("lot", lotSet, CompareType.INCLUDE));
        evi.setFilter(fi);
        DateOfMinDurabilityCollection coll = ido.getDateOfMinDurabilityCollection(evi);
        for (int i = 0; i < coll.size(); ++i) {
            DateOfMinDurabilityInfo dod = coll.get(0);
            String key = dod.getMaterial().getId().toString() + dod.getLot();
            DateOfMinMap.put(key, dod);
        }
        return DateOfMinMap;
    }

    private void setSupplierFromInner(PurInWarehsBillInfo info, CompanyOrgUnitInfo cou, Context ctx) throws BOSException, EASBizException {
        SupplierCollection innerSupplierCollection;
        CompanyOrgUnitInfo siCou;
        PurInWarehsEntryInfo entry;
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        ISaleIssueBill isi = SaleIssueBillFactory.getLocalInstance(ctx);
        SaleIssueBillInfo si = isi.getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK((entry = info.getEntry().get(0)).getSourceBillId()));
        if (si != null && !this.check(si) && (siCou = si.getEntry().get(0).getCompanyOrgUnit()) != null && (innerSupplierCollection = iSupplier.getInterSupplierCollection(siCou.getId().toString(), null)) != null && innerSupplierCollection.size() > 0) {
            for (int i = 0; i < innerSupplierCollection.size(); ++i) {
                SupplierInfo innerSupplier = innerSupplierCollection.get(i);
                if (iSupplier.getCompanyInfo(innerSupplier.getNumber(), cou.getNumber()) == null) continue;
                info.setSupplier(innerSupplier);
                break;
            }
        }
    }

    private boolean check(SaleIssueBillInfo saleIssueBillInfo) {
        if (saleIssueBillInfo.isIsReversed()) {
            return false;
        }
        boolean flag = false;
        if (saleIssueBillInfo.getEntry().get(0).getCoreBillType() != null && ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString()) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString()))) {
            flag = saleIssueBillInfo.getEntry().get(0).isIsCenterBalance() && saleIssueBillInfo.getEntry().get(0).isIsSquareBalance() && saleIssueBillInfo.getEntry().get(0).isIsBetweenCompanySend();
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initExchange(CompanyOrgUnitInfo sourceCompanyOrgUnitInfo) throws EASBizException, BOSException {
        if (this.info.getCurrency() == null || this.cou == null || this.cou.getBaseCurrency() == null || sourceCompanyOrgUnitInfo == null || sourceCompanyOrgUnitInfo.getBaseCurrency() == null) {
            this.info.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
            return;
        }
        if (!this.info.getCurrency().getId().equals((Object)this.cou.getBaseCurrency().getId())) {
            ExchangeRateInfo exchangeRateInfo = null;
            if (this.cou.getBaseCurrency().getId().equals((Object)sourceCompanyOrgUnitInfo.getBaseCurrency().getId())) {
                if (this.info.get("exchangeRate") != null) return;
                exchangeRateInfo = PurInWarehsServerutils.getExchangeRate(this.ctx, this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
            } else {
                exchangeRateInfo = PurInWarehsServerutils.getExchangeRate(this.ctx, this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
            }
            if (exchangeRateInfo == null) throw new InvBizException(InvBizException.RATEINFOISNULL);
            this.info.setExchangeRate(exchangeRateInfo.getConvertRate());
            return;
        } else {
            this.info.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
        }
    }

    private void revalueForVirtualBillPurchasing() throws BOSException, EASBizException {
        CompanyOrgUnitInfo purCouInfo = null;
        PurInnerDealPriceInfo priceInfo = null;
        PurInWarehsEntryInfo entryInfo = null;
        PurOrderInfo orderInfo = null;
        PurOrderEntryInfo orderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        SupplierInfo supplier = null;
        Map<String, PurInnerDealPriceInfo> priceMap = null;
        PurInWarehsEntryCollection purInWarehsEntryCol = this.info.getEntry();
        if (this.info.get("PurInnerDealPrice") != null) {
            PurInnerDealPriceCollection purPriceCol = (PurInnerDealPriceCollection)this.info.get("PurInnerDealPrice");
            priceInfo = purPriceCol.get(0);
            if (priceInfo != null) {
                SupplierCollection innerSupplierCollection;
                if (priceInfo.getSupCompanyOrg() != null && (innerSupplierCollection = SupplierFactory.getLocalInstance((Context)this.ctx).getInterSupplierCollection(priceInfo.getSupCompanyOrg().getId().toString(), null)) != null && innerSupplierCollection.size() > 0) {
                    supplier = innerSupplierCollection.get(0);
                    this.info.setSupplier(supplier);
                }
                this.info.setCurrency(priceInfo.getCurrency());
                this.amountPrecision = priceInfo.getCurrency().getPrecision();
                this.info.setExchangeRate(priceInfo.getExchangeRate());
            }
            priceMap = this.mapInnerDealPrice(purPriceCol);
        } else {
            this.orderMap = new HashMap<String, PurOrderInfo>();
            this.orderEntryMap = new HashMap<String, PurOrderEntryInfo>();
            this.getCoreBillInfoMap(this.ctx, this.orderMap, this.orderEntryMap);
            String strPurOrder = this.info.getEntry().get(0).getPurOrder();
            if (!StringUtils.isEmpty((String)strPurOrder) && this.orderMap.get(strPurOrder) != null && (orderInfo = this.orderMap.get(strPurOrder)) != null) {
                if (orderInfo.getCurrency() != null) {
                    CurrencyInfo currencyInfo = orderInfo.getCurrency();
                    this.info.setCurrency(currencyInfo);
                    this.amountPrecision = currencyInfo.getPrecision();
                }
                if (orderInfo.getCompanyOrgUnit() != null) {
                    purCouInfo = orderInfo.getCompanyOrgUnit();
                }
                this.initExchange(purCouInfo);
            }
        }
        int count = purInWarehsEntryCol.size();
        for (int i = 0; i < count; ++i) {
            BigDecimal conversionRate;
            entryInfo = purInWarehsEntryCol.get(i);
            if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) continue;
            if ((this.info.getPriceSource() == null || this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL)) && priceMap != null && null != priceMap && priceMap.size() > 0 && priceMap.containsKey(entryInfo.getPurOrderEntry())) {
                priceInfo = priceMap.get(entryInfo.getPurOrderEntry());
                if (priceInfo != null) {
                    entryInfo.setPrice(priceInfo.getPrice());
                    entryInfo.setTaxPrice(priceInfo.getTaxPrice());
                    entryInfo.setTaxRate(priceInfo.getTaxRate());
                    entryInfo.setDiscountRate(priceInfo.getDiscount());
                    entryInfo.setWarehouse(priceInfo.getRecWareHouse());
                    entryInfo.setBalanceSupplier(supplier);
                    orderUnit = priceInfo.getUnit();
                }
            } else {
                orderEntryInfo = this.orderEntryMap.get(entryInfo.getPurOrderEntry());
                if (orderEntryInfo == null) continue;
                orderUnit = orderEntryInfo.getUnit();
            }
            if ((entryUnit = entryInfo.getUnit()) == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
    }

    private BigDecimal getConversionRate(MaterialInfo materialInfo, MeasureUnitInfo fromUnit, MeasureUnitInfo toUnit) throws EASBizException, BOSException {
        if (materialInfo == null || fromUnit == null || toUnit == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        String[] materialIds = new String[]{materialInfo.getId().toString(), materialInfo.getId().toString()};
        String[] unitIds = new String[]{fromUnit.getId().toString(), toUnit.getId().toString()};
        Map conversionRateMap = iMultiMeasureUnit.getConvRatesByMaterial(materialIds, unitIds);
        BigDecimal fromBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + fromUnit.getId().toString());
        BigDecimal toBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + toUnit.getId().toString());
        if (fromBaseConv == null || toBaseConv == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        return fromBaseConv.divide(toBaseConv, 10, 4);
    }

    private PaymentTypeInfo getDefaultAPaymentTypeInfo() throws EASBizException, BOSException {
        return PaymentTypeFactory.getLocalInstance((Context)this.ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
    }

    private SelectorItemCollection getOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.taxPrice"));
        sic.add(new SelectorItemInfo("entries.baseQty"));
        sic.add(new SelectorItemInfo("entries.associateQty"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        return sic;
    }

    private void getCoreBillInfoMap(Context ctx, Map coreBillMap, Map coreBillEntryMap) throws BOSException {
        String coreBillTypeId = this.info.getEntry().get(0).getCoreBillTypeId();
        if (coreBillTypeId == null) {
            return;
        }
        PurInWarehsEntryInfo entry = null;
        HashSet<String> orderIdSet = new HashSet<String>();
        PurInWarehsEntryCollection purInWarehsEntryCol = this.info.getEntry();
        int size = purInWarehsEntryCol.size();
        for (int i = 0; i < size; ++i) {
            entry = purInWarehsEntryCol.get(i);
            if (entry == null || StringUtils.isEmpty((String)entry.getPurOrder())) continue;
            orderIdSet.add(entry.getPurOrder());
        }
        if (orderIdSet.size() == 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orderIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId)) {
            viewInfo.setSelector(this.getOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)PurOrderFactory.getLocalInstance((Context)ctx), viewInfo, "entries");
        } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeId)) {
            viewInfo.setSelector(this.getTransferOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, TransferOrderBillFactory.getLocalInstance(ctx), viewInfo, "entry");
        } else if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId)) {
            viewInfo.setSelector(this.getOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)SaleOrderFactory.getLocalInstance((Context)ctx), viewInfo, "entries");
        } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeId)) {
            viewInfo.setSelector(this.getOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)SaleReturnsFactory.getLocalInstance((Context)ctx), viewInfo, "entries");
        }
    }

    private void getCoreBillInfoMap(Context ctx, Map coreBillMap, Map coreBillEntryMap, ISCMBillBase bizInterface, EntityViewInfo viewInfo, String entryKey) throws BOSException {
        CoreBaseCollection billCol = bizInterface.getCollection(viewInfo);
        IObjectCollection entryCol = null;
        IObjectValue billInfo = null;
        IObjectValue billEntryInfo = null;
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            billInfo = billCol.getObject(i);
            if (billInfo == null || billInfo.get("id") == null) continue;
            coreBillMap.put(billInfo.get("id").toString(), billInfo);
            entryCol = (IObjectCollection)billInfo.get(entryKey);
            int eSize = entryCol.size();
            for (int j = 0; j < eSize; ++j) {
                billEntryInfo = entryCol.getObject(j);
                if (billEntryInfo == null || billEntryInfo.get("id") == null) continue;
                coreBillEntryMap.put(billEntryInfo.get("id").toString(), billEntryInfo);
            }
        }
    }

    protected void fetchPrice(Context ctx, PurInWarehsBillInfo info, PurPriceInfoCollection cols) throws EASBizException, BOSException {
        PurInWarehsEntryInfo entryInfo = null;
        for (int j = 0; j < info.getEntries().size(); ++j) {
            entryInfo = info.getEntry().get(j);
            if (null == cols || null == cols.getSeq2PriceInfo() || cols.getSeq2PriceInfo().size() <= 0) continue;
            PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(j);
            this.handleAfterGetPrice(info, entryInfo, priceInfo);
        }
    }

    protected void handleAfterGetPrice(PurInWarehsBillInfo info, PurInWarehsEntryInfo entryInfo, PurPriceInfo priceInfo) {
        if (priceInfo != null && priceInfo.getPrice() != null) {
            if (priceInfo.getDiscountRate() != null) {
                entryInfo.setDiscountRate(priceInfo.getDiscountRate());
            }
            BigDecimal taxRate = entryInfo.getTaxRate();
            if (priceInfo.getTaxRate() != null) {
                taxRate = priceInfo.getTaxRate();
                entryInfo.setTaxRate(taxRate);
            }
            int pricePrecision = entryInfo.getMaterial().getPricePrecision();
            if (info.isIsInTax()) {
                if (!priceInfo.isInTaxPrice()) {
                    BigDecimal price = priceInfo.getPrice();
                    entryInfo.setPrice(price);
                    BigDecimal taxPrice = new BigDecimal("0.00");
                    taxPrice = info.isIsPriceInTax() ? CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)pricePrecision) : CalculateUtils.calTaxPriceByPurchaseCost((BigDecimal)price, (BigDecimal)taxRate, (int)pricePrecision);
                    entryInfo.setTaxPrice(taxPrice);
                } else {
                    entryInfo.setTaxPrice(priceInfo.getPrice());
                }
            } else if (priceInfo.isInTaxPrice()) {
                BigDecimal taxPrice = priceInfo.getPrice();
                entryInfo.setTaxPrice(taxPrice);
                BigDecimal price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)pricePrecision);
                entryInfo.setPrice(price);
            } else {
                entryInfo.setPrice(priceInfo.getPrice());
            }
            entryInfo.setDiscountRate(priceInfo.getDiscountRate());
        }
    }

    protected PurPriceParam getPriceParam(PurInWarehsBillInfo info, PurInWarehsEntryInfo entryInfo, int seq) throws BOSException {
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        param.setSeq(seq);
        param.setPurOrgUnitId(entryInfo.getPurchaseOrgUnit() != null ? entryInfo.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(info.getSupplier() != null ? info.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        BizTypeInfo bizType = info.getBizType();
        if (bizType != null) {
            String bizCategoryId = new String();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT bizT.FID as bizTId ,bizC.FID as bizCId FROM T_SCM_BizType as bizT LEFT OUTER JOIN T_SCM_BIZCATEGORY as bizC on bizT.FBIZCATEGORYID = bizC.FID where bizT.FID = '");
            sql.append(bizType.getId()).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                while (rs.next()) {
                    bizCategoryId = rs.getString("bizCId");
                }
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
            if ("+f4mYqj4xUGaNf69/HWRdqk4kCA=".equals(bizCategoryId) || "6LFeB81CJ0mD3wyAekUV7Kk4kCA=".equals(bizCategoryId)) {
                param.setMaterialPurchaseType(1);
            } else {
                param.setMaterialPurchaseType(0);
            }
        }
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setRecOrgUnitId(info.getStorageOrgUnit() != null ? info.getStorageOrgUnit().getId().toString() : null);
        param.setBizTypeId(bizType != null ? bizType.getId().toString() : null);
        return param;
    }

    protected PurPriceParam getPriceParam(PurInWarehsBillInfo info, PurInWarehsEntryInfo entryInfo, int seq, String bizCategoryId) throws BOSException {
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        param.setSeq(seq);
        param.setPurOrgUnitId(entryInfo.getPurchaseOrgUnit() != null ? entryInfo.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(info.getSupplier() != null ? info.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        if ("+f4mYqj4xUGaNf69/HWRdqk4kCA=".equals(bizCategoryId) || "6LFeB81CJ0mD3wyAekUV7Kk4kCA=".equals(bizCategoryId)) {
            param.setMaterialPurchaseType(1);
        } else {
            param.setMaterialPurchaseType(0);
        }
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setRecOrgUnitId(info.getStorageOrgUnit() != null ? info.getStorageOrgUnit().getId().toString() : null);
        BizTypeInfo bizType = info.getBizType();
        param.setBizTypeId(bizType != null ? bizType.getId().toString() : null);
        return param;
    }

    @Override
    protected void calByUnitSource(Context ctx, InvBillBaseInfo invBillBaseInfo, InvBillBaseEntryInfo invBillBaseEntryInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, invBillBaseInfo, invBillBaseEntryInfo);
        PurInWarehsEntryInfo purInwarehsEntryInfo = (PurInWarehsEntryInfo)invBillBaseEntryInfo;
        String sourceBillEntryId = purInwarehsEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = purInwarehsEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = purInwarehsEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)purInwarehsEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)purInwarehsEntryInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)purInwarehsEntryInfo.getQty(), (SCMBillEntryBaseInfo)purInwarehsEntryInfo, (String)sourceUnitId);
        purInwarehsEntryInfo.setQty(qty);
        PurInWarehsBillInfo purInwarehsBillInfo = (PurInWarehsBillInfo)invBillBaseInfo;
        BigDecimal price = null;
        if (purInwarehsBillInfo.isIsInTax()) {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)purInwarehsEntryInfo.getTaxPrice(), (SCMBillEntryBaseInfo)purInwarehsEntryInfo, (String)sourceUnitId);
            purInwarehsEntryInfo.setTaxPrice(price);
        } else {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)purInwarehsEntryInfo.getPrice(), (SCMBillEntryBaseInfo)purInwarehsEntryInfo, (String)sourceUnitId);
            purInwarehsEntryInfo.setPrice(price);
        }
    }

    private Set<String> getCoreEntryIdSet(PurInWarehsBillInfo info) {
        if (info == null) {
            return null;
        }
        PurInWarehsEntryInfo entryInfo = null;
        HashSet<String> ids = new HashSet<String>();
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) continue;
            ids.add(entryInfo.getPurOrderEntry());
        }
        return ids;
    }

    private Map<String, PurInnerDealPriceInfo> getInnerDealPrice(Context ctx) throws EASBizException, BOSException {
        if (this.cou == null) {
            return null;
        }
        Set<String> coreEntryIds = this.getCoreEntryIdSet(this.info);
        if (coreEntryIds == null || coreEntryIds.size() == 0) {
            return null;
        }
        PurInnerDealPriceCollection coll = PurInnerDealPriceFactory.getLocalInstance((Context)ctx).getInnerDealPrice(coreEntryIds, "recCompanyOrg.id", this.cou.getId().toString());
        return this.mapInnerDealPrice(coll);
    }

    private Map<String, PurInnerDealPriceInfo> mapInnerDealPrice(PurInnerDealPriceCollection coll) {
        if (coll != null && coll.size() > 0) {
            PurInnerDealPriceInfo priceInfo = null;
            HashMap<String, PurInnerDealPriceInfo> map = new HashMap<String, PurInnerDealPriceInfo>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                priceInfo = coll.get(i);
                map.put(priceInfo.getPurOrderEntry().getId().toString(), priceInfo);
            }
            return map;
        }
        return null;
    }

    private void reValueForVirtualBillVMI() throws EASBizException, BOSException {
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = this.cou;
        this.initExchange(sourceCompanyOrgUnitInfo);
        PurPriceInfoCollection cols = this.getPurPriceInfoCollection(this.ctx, this.info);
        this.fetchPrice(this.ctx, this.info, cols);
    }
}

