/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PurInWareImport
extends InvDataImport {
    private static final String RESOURCE = "com.kingdee.eas.scm.im.inv.app.PurInImportResource";
    private static final String RESOURCES_OF_OTHER = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    PurInWarehsBillInfo purInWarehsBill = null;
    CompanyOrgUnitInfo cou = null;
    StorageOrgUnitInfo sou = null;
    ExchangeRateInfo exchangeRateInfo = null;
    private boolean EVALUATE_TEMP = true;
    private static final String[] BIGDECIMAL_FIELDS = new String[]{"FEntry_unitPurchaseCost", "FEntry_purchaseCost", "FEntry_actualCost", "FEntry_discountRate", "FEntry_discountAmount", "FEntry_price", "FEntry_taxPrice", "FEntry_actualPrice", "FEntry_actualTaxPrice", "FEntry_amount", "FEntry_tax", "FEntry_taxAmount", "FEntry_unitMaterialCost", "FEntry_materialCost"};
    private static final String[] BIGDECIMAL_OBJ_EN = new String[]{"unitPurchaseCost", "purchaseCost", "actualCost", "discountRate", "discountAmount", "price", "taxPrice", "actualPrice", "actualTaxPrice", "amount", "tax", "taxAmount", "unitMaterialCost", "materialCost"};
    private static final String[] ZERO_WHEN_ISPRESENT = new String[]{"unitPurchaseCost", "purchaseCost", "unitActualCost", "actualCost", "discountAmount", "price", "taxPrice", "actualPrice", "actualTaxPrice", "amount", "tax", "localTax", "taxAmount", "localTaxAmount", "purchaseFee"};
    private static final String[] ENTRY_QTY_AMOUNT_FIELDS = new String[]{"qty", "assistQty", "baseQty", "reverseQty", "reverseBaseQty", "returnsQty", "returnBaseQty", "amount", "actualCost", "standardCost", "purchaseCost", "purchaseFee", "materialCost", "tax", "taxAmount", "localAmount", "discountAmount", "localTax", "localTaxAmount"};
    private static final String[] ENTRY_PRICE_FIELDS = new String[]{"price", "actualPrice", "taxRate", "localPrice", "unitActualCost", "taxPrice", "discountRate", "unitMaterialCost"};
    private final String[] priceFields = new String[]{"unitPurchaseCost", "price", "taxPrice", "actualPrice", "actualTaxPrice", "unitMaterialCost"};
    private final String[] amountFields = new String[]{"discountAmount", "amount", "tax", "taxAmount", "discountAmount"};
    private final String[] localAmountFields = new String[]{"localTax", "localTaxAmount", "localAmount", "purchaseCost", "actualCost", "materialCost", "standardCost", "purchaseFee"};
    private int cprecision = 2;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurInWarehsBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.purInWarehsBill = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(i);
            if (i == 0) {
                try {
                    this.purInWarehsBill = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, this.purInWarehsBill, lineData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.purInWarehsBill);
                    break;
                }
                if (this.purInWarehsBill == null) {
                    return null;
                }
            }
            PurInWarehsEntryInfo entryInfo = null;
            try {
                entryInfo = this.transmitEntry(lineData, ctx);
                this.afterBuildEntry(entryInfo);
                this.afterBuildEntry(ctx, this.purInWarehsBill, entryInfo, lineData);
                continue;
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.purInWarehsBill);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.purInWarehsBill;
    }

    private void afterBuildEntry(PurInWarehsEntryInfo entryInfo) {
        int seq = this.purInWarehsBill.getEntry().size() + 1;
        entryInfo.setSeq(seq);
        entryInfo.setParent(this.purInWarehsBill);
        entryInfo.setStorageOrgUnit(this.sou);
        entryInfo.setCompanyOrgUnit(this.cou);
        this.purInWarehsBill.getEntry().add(entryInfo);
    }

    public int getSubmitType() {
        return 1;
    }

    private void doEntryBaseUnit(Context ctx, Map lineData, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        MaterialInfo material = entryInfo.getMaterial();
        if (material != null && material.getBaseUnit() != null) {
            MeasureUnitInfo baseUnit = material.getBaseUnit();
            entryInfo.setBaseUnit(baseUnit);
            if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                try {
                    entryInfo.setBaseQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)material.getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)baseUnit, (BigDecimal)entryInfo.getQty()));
                }
                catch (BaseException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private PurInWarehsEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        PurInWarehsEntryInfo entryInfo = new PurInWarehsEntryInfo();
        this.doEntryMaterial(lineData, ctx, entryInfo);
        this.doEntryAssistProperty(lineData, ctx, entryInfo);
        this.doEntryLot(lineData, ctx, entryInfo);
        this.doEntrySupplierLot(lineData, ctx, entryInfo);
        this.doEntryMfgExp(ctx, lineData, entryInfo);
        this.doEntryUnit(lineData, ctx, entryInfo);
        this.doEntryQty(lineData, ctx, entryInfo);
        this.doEntryTaxRate(lineData, ctx, entryInfo);
        this.doEntryBaseUnit(ctx, lineData, entryInfo);
        this.doEntryAssistUnit(ctx, entryInfo, lineData);
        this.doEntryWarehouse(lineData, ctx, entryInfo);
        this.doEntryLocation(lineData, ctx, entryInfo);
        this.doEntryPurchaseOrgUnit(lineData, ctx, entryInfo);
        this.doEntryPurchaseGroup(lineData, ctx, entryInfo);
        this.doEntryPersonFiled(lineData, ctx, entryInfo);
        this.doEntryStandardCost(ctx, entryInfo);
        this.doEntryAmountPriceField(ctx, entryInfo, lineData);
        this.doEntryPurchaseFee(ctx, lineData, entryInfo);
        this.doEntryFilesByPurType(ctx, lineData, entryInfo);
        this.doEntryFilesByRI(entryInfo);
        this.doEntryPrice(ctx, entryInfo);
        this.doEntryOtherField(lineData, entryInfo);
        this.doEntryProjectNum(ctx, lineData, entryInfo);
        this.doEntryTrackNum(ctx, lineData, entryInfo);
        this.doEntryInvUpdateType(ctx, lineData, entryInfo);
        try {
            this.calLocalTaxAndAmount(ctx, entryInfo);
            this.checkEntryValue(ctx, entryInfo);
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return entryInfo;
    }

    private void calLocalTaxAndAmount(Context ctx, PurInWarehsEntryInfo entry) throws BOSException, EASBizException {
        int scale = this.cou.getBaseCurrency().getPrecision();
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = this.purInWarehsBill.getExchangeRate();
        if (this.exchangeRateInfo != null && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            if (this.exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
            entry.setLocalAmount(entry.getLocalTaxAmount().subtract(entry.getLocalTax()));
        } else {
            entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        }
    }

    private void doEntryFilesByPurType(Context ctx, Map lineData, PurInWarehsEntryInfo entry) throws TaskExternalException {
        Object unitMaterialData = ((DataToken)lineData.get((Object)"FEntry_unitMaterialCost")).data;
        Object materialData = ((DataToken)lineData.get((Object)"FEntry_materialCost")).data;
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)this.purInWarehsBill.getPurchaseType())) {
            BigDecimal value;
            if (unitMaterialData != null && unitMaterialData.toString().trim().length() > 0) {
                value = DataImportUtils.getDataDeciaml((Context)ctx, (String)unitMaterialData.toString());
                entry.setUnitMaterialCost(value);
            } else {
                entry.setUnitMaterialCost(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (materialData != null && materialData.toString().trim().length() > 0) {
                value = DataImportUtils.getDataDeciaml((Context)ctx, (String)materialData.toString());
                entry.setMaterialCost(value);
            } else {
                entry.setMaterialCost(SCMConstant.BIGDECIMAL_ZERO);
            }
        } else if (PurchaseTypeEnum.PURCHASE.equals((Object)this.purInWarehsBill.getPurchaseType())) {
            entry.setUnitMaterialCost(SCMConstant.BIGDECIMAL_ZERO);
            entry.setMaterialCost(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryPurchaseFee(Context ctx, Map lineData, PurInWarehsEntryInfo entry) throws TaskExternalException {
        if (this.purInWarehsBill.getStorageOrgUnit() != null) {
            this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
            if (this.cou == null) {
                this.EVALUATE_TEMP = false;
            } else {
                try {
                    IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
                    this.EVALUATE_TEMP = Boolean.parseBoolean(iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(this.cou.getId().toString()), "SCM_CAL_011"));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        Object data = ((DataToken)lineData.get((Object)"FEntry_purchaseFee")).data;
        if (this.EVALUATE_TEMP) {
            if (data != null && data.toString().trim().length() > 0) {
                BigDecimal value = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
                entry.setPurchaseFee(value);
            }
        } else {
            entry.setPurchaseFee(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryProjectNum(Context ctx, Map lineData, PurInWarehsEntryInfo entry) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        ProjectInfo project = this.getProject(ctx, data, this.sou.getCU());
        entry.setProject(project);
    }

    private void doEntryTrackNum(Context ctx, Map lineData, PurInWarehsEntryInfo entry) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        TrackNumberInfo trackNumber = this.getTrackNumber(ctx, data, this.sou.getCU());
        entry.setTrackNumber(trackNumber);
    }

    private void doEntryPrice(Context ctx, PurInWarehsEntryInfo entry) throws TaskExternalException {
        BigDecimal price = entry.getPrice();
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal taxRate = entry.getTaxRate();
        BigDecimal actualCost = entry.getActualCost();
        BigDecimal qty = entry.getQty();
        int precision = entry.getMaterial().getPricePrecision();
        if (qty != null && qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) {
            BigDecimal unitActualCost = this.setNullToZero(actualCost).divide(qty, precision, 4);
            entry.setUnitActualCost(unitActualCost);
        }
        if (taxRate == null) {
            taxRate = SCMConstant.BIGDECIMAL_ZERO;
            entry.setTaxRate(taxRate);
        }
        taxRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 2, 4);
        if (this.purInWarehsBill.isIsInTax()) {
            price = this.purInWarehsBill.isIsPriceInTax() ? taxPrice.divide(SCMConstant.BIGDECIMAL_ONE.add(taxRate), precision, 4) : taxPrice.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(taxRate));
        } else {
            taxPrice = price.multiply(SCMConstant.BIGDECIMAL_ONE.add(taxRate));
        }
        entry.setPrice(price.abs());
        entry.setTaxPrice(taxPrice);
    }

    private void checkEntryValue(Context ctx, PurInWarehsEntryInfo entry) throws TaskExternalException {
        BigDecimal localTax;
        boolean purCostEqualsTaxAmount;
        BigDecimal fee = this.setNullToZero(entry.getPurchaseFee());
        BigDecimal materialCost = this.setNullToZero(entry.getMaterialCost());
        BigDecimal purchaseCost = this.setNullToZero(entry.getPurchaseCost());
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)this.purInWarehsBill.getPurchaseType())) {
            if (fee.add(materialCost).add(purchaseCost).compareTo(this.setNullToZero(entry.getActualCost())) != 0) {
                String str = PurInWareImport.getResource(ctx, "ACTUALCOST_NOTEQUALS_OTHERFEE");
                throw new TaskExternalException(str);
            }
        } else if (PurchaseTypeEnum.PURCHASE.equals((Object)this.purInWarehsBill.getPurchaseType()) && fee.add(purchaseCost).compareTo(this.setNullToZero(entry.getActualCost())) != 0) {
            String str = PurInWareImport.getResource(ctx, "ACTUALCOST_NOTEQUALS_OTHERFEE");
            throw new TaskExternalException(str);
        }
        BigDecimal tax = this.setNullToZero(entry.getTax());
        BigDecimal amount = this.setNullToZero(entry.getAmount());
        BigDecimal taxAmount = this.setNullToZero(entry.getTaxAmount());
        if (tax.add(amount).compareTo(taxAmount) != 0) {
            String str = PurInWareImport.getResource(ctx, "TAXAMOUNT_NOTEQUALS_OTHERAMOUNT");
            throw new TaskExternalException(str);
        }
        BigDecimal unitPurchaseCost = this.setNullToZero(entry.getUnitPurchaseCost());
        BigDecimal qty = entry.getQty();
        BigDecimal localTaxAmount = this.setNullToZero(entry.getLocalTaxAmount());
        boolean bl = purCostEqualsTaxAmount = localTaxAmount.subtract(localTax = this.setNullToZero(entry.getLocalTax())).compareTo(purchaseCost) != 0;
        if (PurchaseTypeEnum.PURCHASE.equals((Object)this.purInWarehsBill.getPurchaseType())) {
            if (qty != null && qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) {
                int mprecision = 4;
                if (entry.getMaterial() != null) {
                    mprecision = entry.getMaterial().getPricePrecision();
                }
                if (unitPurchaseCost.multiply(qty).setScale(this.cprecision, 4).compareTo(purchaseCost) != 0 && purchaseCost.divide(qty, mprecision, 4).compareTo(unitPurchaseCost) != 0 && purCostEqualsTaxAmount) {
                    String str = PurInWareImport.getResource(ctx, "PURCOST_NOTEQUALS_OTHERUNITCOSTQTY_AND_TAXAMOUNT");
                    throw new TaskExternalException(str);
                }
            } else if (purchaseCost.compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) {
                String str = PurInWareImport.getResource(ctx, "PURCOST_NOTEQUALS_OTHERUNITCOSTQTY");
                throw new TaskExternalException(str);
            }
        } else if (purCostEqualsTaxAmount) {
            String str = PurInWareImport.getResource(ctx, "PURCOST_NOTEQUALS_OTHERTAXAMOUNT");
            throw new TaskExternalException(str);
        }
    }

    private void doEntryFilesByRI(PurInWarehsEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : ENTRY_PRICE_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs());
        }
        boolean flag = !InvAppUtils.isNegative(this.purInWarehsBill.getTransactionType());
        for (String entryField2 : ENTRY_QTY_AMOUNT_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            if (flag) {
                value = (BigDecimal)entryInfo.get(entryField2);
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    private void doEntryAmountPriceField(Context ctx, PurInWarehsEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        for (int i = 0; i < BIGDECIMAL_FIELDS.length; ++i) {
            BigDecimal value;
            Object o = ((DataToken)lineData.get((Object)PurInWareImport.BIGDECIMAL_FIELDS[i])).data;
            try {
                if (o.toString().trim().length() == 0) {
                    o = SCMConstant.BIGDECIMAL_ZERO;
                }
                value = DataImportUtils.getDataDeciaml((Context)ctx, (String)o.toString());
            }
            catch (Exception e) {
                continue;
            }
            entryInfo.put(BIGDECIMAL_OBJ_EN[i], value.abs());
        }
    }

    private void doEntryStandardCost(Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        String mid = entryInfo.getMaterial().getId().toString();
        String couID = this.cou.getId().toString();
        String key = mid + couID;
        MaterialCompanyInfoInfo materialCompanyInfo = this.dataPool.getMaterialCompanyInfoInfo(key);
        if (materialCompanyInfo == null) {
            return;
        }
        MeasureUnitInfo unit = entryInfo.getUnit();
        MeasureUnitInfo baseUnit = entryInfo.getBaseUnit();
        BigDecimal unitStandardcost = materialCompanyInfo.getStandardCost();
        try {
            if (unitStandardcost != null) {
                BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, entryInfo.getMaterial(), unitStandardcost, baseUnit, unit);
                BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                entryInfo.setUnitStandardCost(unitstandardcost);
                entryInfo.setStandardCost(standardcost);
                entryInfo.setUnitActualCost(unitstandardcost);
                entryInfo.setActualCost(standardcost);
            } else {
                entryInfo.setUnitStandardCost(SCMConstant.BIGDECIMAL_ZERO);
                entryInfo.setStandardCost(SCMConstant.BIGDECIMAL_ZERO);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doEntryUnit(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, data, entryInfo.getMaterial());
        entryInfo.setUnit(measureUnitInfo);
    }

    private void doEntryAssistUnit(Context ctx, PurInWarehsEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
        if (entryInfo.getAssistUnit() != null) {
            Object cellData = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
            try {
                BigDecimal assistQty = DataImportUtils.getDataDeciaml((Context)ctx, (String)cellData.toString());
                entryInfo.setAssistQty(assistQty);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        } else {
            entryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryAssistProperty(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        AsstAttrValueInfo info = this.getAsstAttr(ctx, data, entryInfo.getMaterial().getAssistAttr());
        entryInfo.setAssistProperty(info);
        if (entryInfo.getMaterial().getAssistAttr() != null && entryInfo.getAssistProperty() == null) {
            throw new TaskExternalException(PurInWareImport.getResource(ctx, "MATERIAL_NOT_NULL"));
        }
    }

    private void doEntryMaterial(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object materialNumber = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        MaterialInfo materialInfo = this.getMaterial(ctx, materialNumber, new OrgUnitInfo[]{this.cou, this.sou});
        entryInfo.setMaterial(materialInfo);
    }

    private void doEntryLocation(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        LocationInfo location = this.getLocation(ctx, ((DataToken)lineData.get((Object)"FEntry$location_number")).data, entryInfo.getWarehouse());
        entryInfo.setLocation(location);
    }

    private void doEntryPersonFiled(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object filterData = ((DataToken)lineData.get((Object)"FEntry$stocker_number")).data;
        entryInfo.setStocker(this.getStocker(ctx, filterData));
        filterData = ((DataToken)lineData.get((Object)"FEntry$purchasePerson_number")).data;
        entryInfo.setPurchasePerson(this.getPurchasePerson(ctx, "number", entryInfo.getPurchaseGroup(), filterData));
    }

    private void doEntryWarehouse(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        WarehouseInfo warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data);
        entryInfo.setWarehouse(warehouseInfo);
    }

    private void doEntryPurchaseOrgUnit(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$purchaseOrgUnit_number")).data;
        PurchaseOrgUnitInfo purchaseOrgUnit = this.getPurchaseOrgUnit(ctx, "number", data);
        entryInfo.setPurchaseOrgUnit(purchaseOrgUnit);
    }

    private void doEntryPurchaseGroup(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$purchaseGroup_number")).data;
        PurchaseGroupInfo purchaseGroup = this.getPurchaseGroup(ctx, "number", entryInfo.getPurchaseOrgUnit(), data, false);
        entryInfo.setPurchaseGroup(purchaseGroup);
    }

    private void doEntryMfgExp(Context ctx, Map lineData, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object mfg = ((DataToken)lineData.get((Object)"FEntry_mfg")).data;
        Object exp = ((DataToken)lineData.get((Object)"FEntry_exp")).data;
        Date[] mfgAndExp = this.getMfgAndExp(ctx, entryInfo.getMaterial(), entryInfo.getLot(), this.sou, mfg, exp);
        if (mfgAndExp != null) {
            entryInfo.setMfg(mfgAndExp[0]);
            entryInfo.setExp(mfgAndExp[1]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEntryLot(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        if (this.checkLotInfo(ctx, entryInfo.getMaterial(), this.sou)) {
            Object data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
            if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(PurInWareImport.getResource(ctx, "LOT_NOT_NULL"));
            entryInfo.setLot(data.toString().trim());
            return;
        } else {
            entryInfo.setLot(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEntrySupplierLot(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        if (this.checkSupplierLotInfo(ctx, entryInfo.getMaterial(), this.sou)) {
            Object data = ((DataToken)lineData.get((Object)"FEntry_supplierLotNo")).data;
            if (data == null || data.toString().trim().length() <= 0) throw new TaskExternalException(PurInWareImport.getResource(ctx, "SUPPLIERLOT_NOT_NULL"));
            entryInfo.setSupplierLotNo(data.toString().trim());
            return;
        } else {
            entryInfo.setSupplierLotNo(null);
        }
    }

    private void doEntryOtherField(Map lineData, PurInWarehsEntryInfo entryInfo) {
        entryInfo.setImputedCost(SCMConstant.BIGDECIMAL_ZERO);
        entryInfo.setReceiveStorageOrgUnit(this.sou);
        entryInfo.setBalanceSupplier(this.purInWarehsBill.getSupplier());
        Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (o != null) {
            String remark = o.toString().trim();
            if (remark.length() > 255) {
                remark = remark.substring(0, 255);
            }
            entryInfo.setRemark(remark);
        }
        entryInfo.setIsPresent(DataImportUtils.getBooleanValue((Object)((DataToken)lineData.get((Object)"FEntry_isPresent")).data, (boolean)false));
        if (entryInfo.isIsPresent()) {
            for (String s : ZERO_WHEN_ISPRESENT) {
                entryInfo.put(s, SCMConstant.BIGDECIMAL_ZERO);
            }
        }
        entryInfo.setIsFullWriteOff(DataImportUtils.getBooleanValue((Object)((DataToken)lineData.get((Object)"FEntry_isFullWriteOff")).data, (boolean)false));
    }

    private void doEntryQty(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        BigDecimal qty;
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data != null && data.toString().length() > 0) {
            qty = null;
            try {
                qty = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
            }
            catch (Exception e) {
                throw new TaskExternalException(PurInWareImport.getResource(ctx, "QTY_ERROR"));
            }
            if (qty != null && qty.compareTo(BigDecimal.ZERO) == 0) {
                throw new TaskExternalException(PurInWareImport.getResource(ctx, "QTY_NOT_ERROR"));
            }
        } else {
            throw new TaskExternalException(PurInWareImport.getResource(ctx, "QTY_NOT_ERROR"));
        }
        entryInfo.setQty(qty);
    }

    private void doEntryTaxRate(Map lineData, Context ctx, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_taxRate")).data;
        BigDecimal taxRate = this.getTaxRate(ctx, data);
        if (taxRate == null) {
            taxRate = SCMConstant.BIGDECIMAL_ZERO;
        }
        entryInfo.setTaxRate(taxRate);
    }

    private void doBillType(Context ctx) {
        BillTypeInfo billTypeinfo = new BillTypeInfo();
        billTypeinfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
        this.purInWarehsBill.setBillType(billTypeinfo);
    }

    private void doOtherField(Context ctx) {
        this.purInWarehsBill.setCU(this.sou.getCU());
        this.purInWarehsBill.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.purInWarehsBill.setIsCentralBalance(false);
        this.purInWarehsBill.setVoucher(null);
        this.purInWarehsBill.setIsReversed(false);
        this.purInWarehsBill.setSourceBillId(null);
        this.purInWarehsBill.setSourceBillType(null);
        this.purInWarehsBill.setFiVouchered(false);
    }

    private void doPaymentType(Context ctx, Map lineData) throws TaskExternalException {
        Object paymentTypeData = ((DataToken)lineData.get((Object)"FPaymentType_name_l2")).data;
        PaymentTypeInfo paymentType = this.getPaymentType(ctx, "name", paymentTypeData, "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
        this.purInWarehsBill.setPaymentType(paymentType);
    }

    private PurInWarehsBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.purInWarehsBill = new PurInWarehsBillInfo();
        this.doPurchaseType(ctx);
        this.doStorageOrgUnit(ctx, lineData);
        this.doCompanyOrgUnit(ctx);
        this.doCurrency(ctx, lineData);
        this.doBizTypeInfo(ctx, lineData);
        this.doTransactionInfo(ctx, lineData);
        this.doSupplier(ctx, lineData);
        this.doAdminOrgUnit(ctx, lineData);
        this.doPaymentType(ctx, lineData);
        this.doOtherField(ctx);
        this.doIsInitBill(lineData);
        this.doIsInTax(ctx, lineData);
        this.doCreator(ctx, lineData);
        this.doCreateDate();
        this.doBillType(ctx);
        this.doBizDate(lineData, ctx);
        this.doDescription(lineData);
        this.doExchangeRate(lineData, ctx);
        return this.purInWarehsBill;
    }

    private void doExchangeRate(Map lineData, Context ctx) throws TaskExternalException {
        try {
            CurrencyInfo currency = this.purInWarehsBill.getCurrency();
            if (currency != null) {
                this.exchangeRateInfo = SCMUtils.getExchangeRateInfo((Context)ctx, (CompanyOrgUnitInfo)this.cou, (CurrencyInfo)this.purInWarehsBill.getCurrency(), (CurrencyInfo)this.cou.getBaseCurrency(), (Date)this.purInWarehsBill.getBizDate());
            }
            if (currency != null && this.cou != null && this.cou.getBaseCurrency() != null && this.cou.getBaseCurrency().getId().equals((Object)currency.getId())) {
                this.purInWarehsBill.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
            } else {
                BigDecimal exchangeRate = null;
                if (this.exchangeRateInfo != null) {
                    this.purInWarehsBill.setExchangeRate(this.exchangeRateInfo.getConvertRate());
                } else {
                    Object exchangeRateData = ((DataToken)lineData.get((Object)"FExchangeRate")).data;
                    if (StringUtil.isEmptyString((String)((String)exchangeRateData))) {
                        String str = PurInWareImport.getResource(ctx, "EXCHANGERATE_NOT_NULL");
                        throw new TaskExternalException(str);
                    }
                    exchangeRate = DataImportUtils.getDataDeciaml((Context)ctx, (String)exchangeRateData.toString());
                    this.purInWarehsBill.setExchangeRate(exchangeRate);
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void doDescription(Map lineData) {
        Object descriptionObj = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (descriptionObj != null) {
            String description = descriptionObj.toString().trim();
            if (description.length() > 255) {
                description = description.substring(0, 255);
            }
            this.purInWarehsBill.setDescription(description);
        }
    }

    private void doIsInTax(Context ctx, Map lineData) throws TaskExternalException {
        boolean isInTax = DataImportUtils.getBooleanValue((Object)((DataToken)lineData.get((Object)"FIsInTax")).data, (boolean)true);
        boolean isPriceInTax = DataImportUtils.getBooleanValue((Object)((DataToken)lineData.get((Object)"FIsPriceInTax")).data, (boolean)true);
        if (!isInTax && !isPriceInTax) {
            throw new TaskExternalException(PurInWareImport.getResource(ctx, "BOTHNOT_FALSE"));
        }
        this.purInWarehsBill.setIsInTax(isInTax);
        this.purInWarehsBill.setIsPriceInTax(isPriceInTax);
    }

    private void doPurchaseType(Context ctx) {
        if (ctx.get((Object)"isSubContractBill") == null) {
            this.purInWarehsBill.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        } else if (ctx.get((Object)"isSubContractBill").toString().equals("true")) {
            this.purInWarehsBill.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
        } else {
            this.purInWarehsBill.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        }
    }

    private void doCreateDate() {
        this.purInWarehsBill.setCreateTime(new Timestamp(new Date().getTime()));
    }

    private void doCreator(Context ctx, Map lineData) throws TaskExternalException {
        Object creatorData = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        UserInfo creator = this.getCreator(ctx, creatorData);
        this.purInWarehsBill.setCreator(creator);
    }

    private void doAdminOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data);
        this.purInWarehsBill.setAdminOrgUnit(info);
    }

    private void doSupplier(Context ctx, Map lineData) throws TaskExternalException {
        SupplierInfo supplierInfo;
        Object filterData = ((DataToken)lineData.get((Object)"FSupplier_number")).data;
        try {
            supplierInfo = this.getSupplier(ctx, "number", filterData);
        }
        catch (TaskExternalException numberException) {
            filterData = ((DataToken)lineData.get((Object)"FSupplier_name_l2")).data;
            try {
                supplierInfo = this.getSupplier(ctx, "name", filterData);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        if (supplierInfo == null) {
            throw new TaskExternalException(PurInWareImport.getResource(ctx, "SUPPLIER_NOT_NULL"));
        }
        this.checkSupplierEnableThrow(ctx, supplierInfo, null == filterData ? "" : filterData.toString());
        this.purInWarehsBill.setSupplier(supplierInfo);
    }

    private void doBizDate(Map lineData, Context ctx) throws TaskExternalException {
        Object bizdate = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (bizdate != null && bizdate.toString().length() > 0) {
            try {
                bizdate = DataImportUtils.formatNationalDate((Context)ctx, (String)bizdate.toString());
                this.purInWarehsBill.setBizDate((Date)bizdate);
            }
            catch (Exception e) {
                throw new TaskExternalException(bizdate.toString() + SCMUtils.getResource((String)RESOURCES_OF_OTHER, (String)"InvalidDateFormat", (Context)ctx));
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)RESOURCES_OF_OTHER, (String)"bizDateCanNotBeNull", (Context)ctx));
        }
    }

    private void doCompanyOrgUnit(Context ctx) throws TaskExternalException {
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
    }

    private void doCurrency(Context ctx, Map lineData) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)"FCurrency_number")).data;
        CurrencyInfo info = null;
        if (souData != null && souData.toString().trim().length() > 0) {
            String currencyNumber = souData.toString().trim();
            if (this.dataPool.getCurrencyInfo(currencyNumber) == null) {
                CurrencyCollection currencyColl = null;
                try {
                    ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    currencyColl = iCurrency.getCurrencyCollection(this.getCurrencyFilter(currencyNumber, "number"));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (currencyColl != null && currencyColl.size() > 0) {
                    info = currencyColl.get(0);
                    this.purInWarehsBill.setCurrency(info);
                    this.dataPool.setCurrencyInfo(currencyNumber, info);
                }
            } else {
                info = this.dataPool.getCurrencyInfo(currencyNumber);
                this.purInWarehsBill.setCurrency(info);
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)RESOURCES_OF_OTHER, (String)"CurrencyNotNull", (Context)ctx));
        }
        if (info == null && this.cou != null && this.cou.getBaseCurrency() != null) {
            CurrencyInfo currencyInfo = null;
            try {
                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()), this.getCurrencySelector());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.purInWarehsBill.setCurrency(currencyInfo);
        }
        if (this.purInWarehsBill.getCurrency() != null) {
            this.cprecision = this.purInWarehsBill.getCurrency().getPrecision();
        }
    }

    private void doBizTypeInfo(Context ctx, Map lineData) throws TaskExternalException {
        BizTypeInfo bizTypeInfo;
        Object filterDate = ((DataToken)lineData.get((Object)"FBizType_number")).data;
        try {
            bizTypeInfo = this.getBizType(ctx, "50957179-0105-1000-e000-015fc0a812fd463ED552", "number", filterDate);
        }
        catch (TaskExternalException numberException) {
            filterDate = ((DataToken)lineData.get((Object)"FBizType_name_l2")).data;
            try {
                bizTypeInfo = this.getBizType(ctx, "50957179-0105-1000-e000-015fc0a812fd463ED552", "name", filterDate);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.purInWarehsBill.setBizType(bizTypeInfo);
    }

    private void doTransactionInfo(Context ctx, Map lineData) throws TaskExternalException {
        TransactionTypeInfo transactionTypeInfo;
        Object filterData = ((DataToken)lineData.get((Object)"FTransactionType_number")).data;
        try {
            transactionTypeInfo = this.getTransaction(ctx, "number", filterData, "50957179-0105-1000-e000-015fc0a812fd463ED552", this.purInWarehsBill.getBizType());
        }
        catch (TaskExternalException numberException) {
            filterData = ((DataToken)lineData.get((Object)"FTransactionType_name_l2")).data;
            try {
                transactionTypeInfo = this.getTransaction(ctx, "name", filterData, "50957179-0105-1000-e000-015fc0a812fd463ED552", this.purInWarehsBill.getBizType());
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.purInWarehsBill.setTransactionType(transactionTypeInfo);
    }

    private void doStorageOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        StorageOrgUnitInfo storageOrgUnitInfo;
        Object filterData = ((DataToken)lineData.get((Object)"FStorageOrgUnit_number")).data;
        try {
            storageOrgUnitInfo = this.getStorageOrgUnit(ctx, "number", filterData);
        }
        catch (TaskExternalException numberException) {
            filterData = ((DataToken)lineData.get((Object)"FStorageOrgUnit_name_l2")).data;
            try {
                storageOrgUnitInfo = this.getStorageOrgUnit(ctx, "name", filterData);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        this.sou = storageOrgUnitInfo;
        this.purInWarehsBill.setStorageOrgUnit(storageOrgUnitInfo);
    }

    private void doIsInitBill(Map lineData) {
        this.purInWarehsBill.setIsInitBill(DataImportUtils.getBooleanValue((Object)((DataToken)lineData.get((Object)"FIsInitBill")).data, (boolean)false));
    }

    private EntityViewInfo getCurrencyFilter(String value, String byProperty) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getCurrencySelector());
        return viewInfo;
    }

    private SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)RESOURCE, (String)strKey, (Context)ctx);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "purinwarehs_export");
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.PurInWarehsQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal assistQty;
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            this.putTable(result, "FTransactionType_number", rs.getString("transactionType.number"));
            this.putTable(result, "FTransactionType_name_l2", rs.getString("transactionType.name"));
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name_l2", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FCostCenterOrgUnit_name_l2", rs.getString("costCenterOrgUnit.name"));
            this.putTable(result, "FCostCenterOrgUnit_number", rs.getString("costCenterOrgUnit.number"));
            this.putTable(result, "FIsInitBill", rs.getString("isInitBill"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$material_name_l2", rs.getString("material.name"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry_lot", rs.getString("entry.lot"));
            this.putTable(result, "FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.mfg")));
            this.putTable(result, "FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.exp")));
            this.putTable(result, "FEntry$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString().length() < 1) {
                result.put("FEntry_qty", DataImportUtils.transformValue(null));
            } else {
                BigDecimal qty = new BigDecimal(rs.getString("entry.qty"));
                result.put("FEntry_qty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)qty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString().length() < 1) {
                result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
            } else {
                assistQty = new BigDecimal(rs.getString("entry.assistQty"));
                result.put("FEntry_assistQty", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)assistQty));
            }
            this.putTable(result, "FEntry$warehouse_number", rs.getString("warehouse.number"));
            this.putTable(result, "FEntry$location_number", rs.getString("location.number"));
            this.putTable(result, "FEntry_isPresent", rs.getString("entry.isPresent"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.actualCost")).toString().length() < 1) {
                result.put("FEntry_actualCost", DataImportUtils.transformValue(null));
            } else {
                assistQty = new BigDecimal(rs.getString("entry.actualCost"));
                result.put("FEntry_actualCost", DataImportUtils.fmtDecimalStr((Context)ctx, (BigDecimal)assistQty));
            }
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
            this.putTable(result, "FCreator_number", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("createTime")));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("exchangeRate")));
            this.putTable(result, "FIsInTax", rs.getString("isInTax"));
            this.putTable(result, "FEntry_price", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.price")));
            this.putTable(result, "FEntry_taxRate", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.taxRate")));
            this.putTable(result, "FEntry_taxPrice", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.taxPrice")));
            this.putTable(result, "FEntry_discountAmount", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.discountAmount")));
            this.putTable(result, "FEntry_actualPrice", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.actualPrice")));
            this.putTable(result, "FEntry_actualTaxPrice", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.actualTaxPrice")));
            this.putTable(result, "FEntry_amount", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.amount")));
            this.putTable(result, "FEntry_tax", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.tax")));
            this.putTable(result, "FEntry_localTax", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.localTax")));
            this.putTable(result, "FEntry_taxAmount", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.taxAmount")));
            this.putTable(result, "FEntry_localTaxAmount", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.localTaxAmount")));
            this.putTable(result, "FEntry$purchaseOrgUnit_number", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FEntry$purchaseGroup_number", rs.getString("purchaseGroup.number"));
            this.putTable(result, "FPaymentType_name_l2", rs.getString("paymentType.name"));
            this.putTable(result, "FSupplier_number", rs.getString("supplier.number"));
            this.putTable(result, "FSupplier_name_l2", rs.getString("supplier.name"));
            this.putTable(result, "FEntry_materialCost", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.materialCost")));
            this.putTable(result, "FEntry_unitMaterialCost", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.unitMaterialCost")));
            this.putTable(result, "FEntry_supplierLotNo", rs.getString("entry.supplierLotNo"));
            this.putTable(result, "FEntry_purchaseFee", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.purchaseFee")));
            this.putTable(result, "FEntry_purchaseCost", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.purchaseCost")));
            this.putTable(result, "FEntry_discountRate", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.discountRate")));
            this.putTable(result, "FEntry$purchasePerson_number", rs.getString("purchasePerson.number"));
            this.putTable(result, "FIsPriceInTax", rs.getString("isPriceInTax"));
            this.putTable(result, "FEntry_unitPurchaseCost", DataImportUtils.fmtDecimalStr((Context)ctx, (String)rs.getString("entry.unitPurchaseCost")));
            this.putTable(result, "FEntry$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntry$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FInvUpdateType_number", rs.getString("invUpdateType.number"));
            this.putTable(result, "FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void doEntryInvUpdateType(Context ctx, Map lineData, PurInWarehsEntryInfo entryInfo) throws TaskExternalException {
        InvUpdateTypeInfo invUpdateType;
        Object filterData = ((DataToken)lineData.get((Object)"FInvUpdateType_number")).data;
        try {
            invUpdateType = this.getInvUpdateType(ctx, "number", this.purInWarehsBill.getTransactionType(), filterData);
        }
        catch (TaskExternalException numberException) {
            filterData = ((DataToken)lineData.get((Object)"FInvUpdateType_name_l2")).data;
            try {
                invUpdateType = this.getInvUpdateType(ctx, "name", this.purInWarehsBill.getTransactionType(), filterData);
            }
            catch (TaskExternalException nameException) {
                throw numberException;
            }
        }
        entryInfo.setInvUpdateType(invUpdateType);
    }

    @Override
    public Boolean isCheckCompany4CostCenter() {
        return false;
    }

    protected String[] getPriceFields() {
        return this.priceFields;
    }

    protected String[] getAmountFields() {
        return this.amountFields;
    }

    protected String[] getLocalAmountFields() {
        return this.localAmountFields;
    }

    protected String getDiscountField() {
        return "discountRate";
    }

    protected String getTaxRateField() {
        return "taxRate";
    }

    public String getImportPermissionItem() {
        return "purinwarehs_new";
    }
}

