/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.rewrite.IRewrite;
import com.kingdee.eas.scm.common.app.rewrite.RewriterFactory;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.im.inv.DischargeTypeEnum;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsVoucher;
import com.kingdee.eas.scm.im.inv.IRelationOfChildAndParentFacade;
import com.kingdee.eas.scm.im.inv.ISysBillFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillAgent;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryAgent;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherInfo;
import com.kingdee.eas.scm.im.inv.RelationOfChildAndParentFacadeFactory;
import com.kingdee.eas.scm.im.inv.SimplePurInWarehsEntryVO;
import com.kingdee.eas.scm.im.inv.SimpleSupplyInfoVO;
import com.kingdee.eas.scm.im.inv.SplitBillEntryRelationInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.SplitBillInventoryLog;
import com.kingdee.eas.scm.im.inv.SplitBillRelationInfo;
import com.kingdee.eas.scm.im.inv.SplitBillTotalAmount;
import com.kingdee.eas.scm.im.inv.SysBillFacadeFactory;
import com.kingdee.eas.scm.im.inv.app.AbstractPurInWarehsBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.AutoPurInProcessor;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurInWarehsBillControllerBean
extends AbstractPurInWarehsBillControllerBean {
    private static final long serialVersionUID = -33399998820093L;
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.PurInWarehsBillControllerBean");
    public static final String RES_InvUI = "com.kingdee.eas.scm.im.inv.app.RelationOfChildAndParentResource";
    private HashMap purOrder002Map = new HashMap();
    private HashMap materialPurchaseMap = new HashMap();
    private List purchaseList = new ArrayList();
    private static HashMap evaluateMap = new HashMap();
    private static HashMap sou2couMap = new HashMap();
    private Map qtyPrecisionMap = null;
    private Map baseConvsRateMap = null;
    private static final String ENTRY_TABLE_NAME = "T_IM_PurInwarehsEntry";
    private static final BigDecimal ZERO = SysConstant.BIGZERO;

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_SALEISSUE, SCMConstant.BOSTYPE_PurOrder});
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PurInWarehsBillInfo model = (PurInWarehsBillInfo)collection.getObject(i);
            this.initBotpData(ctx, (IObjectValue)model);
            String coreOrderId = model.getEntry().get(0).getPurOrder();
            boolean isCoreOrder = false;
            String coreOrderBosType = null;
            if (!StringUtils.isEmpty((String)coreOrderId)) {
                coreOrderBosType = BOSUuid.read((String)coreOrderId).getType().toString();
            }
            if (coreOrderBosType != null && coreOrderBosType.equals(SCMConstant.BOSTYPE_PurOrder)) {
                isCoreOrder = true;
            }
            if (isCoreOrder && model.isIsSysBill()) continue;
            this.setCurrency(ctx, (IObjectValue)model, (AbstractObjectCollection)model.get("entry"));
        }
    }

    protected void initBOTPOfMultSettledRelaTakePrice(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dealBillCost(Context ctx, CoreBaseInfo model) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.fqty as qty");
        bf.append(" ,entry.fdrewQty as drewQty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" ,entry.fwrittenOffQty as writtenOffQty ");
        bf.append(" ,entry.funWriteOffQty as unWriteOffQty");
        bf.append(" ,entry.fwrittenOffAmount as writtenOffAmount");
        bf.append(" ,entry.funWriteOffAmount as unWriteOffAmount");
        bf.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf.append(" from t_im_purinwarehsbill bill");
        bf.append(" inner join t_im_purinwarehsentry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            BigDecimal actualCost;
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
            PurInWarehsEntryCollection entries = info.getEntry();
            BigDecimal totalActualCost = SysConstant.BIGZERO;
            int length = entries.size();
            for (int i = 0; i < length; totalActualCost = totalActualCost.add(actualCost), ++i) {
                PurInWarehsEntryInfo entry = entries.get(i);
                actualCost = null != entry.getActualCost() ? entry.getActualCost() : SysConstant.BIGZERO;
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : SysConstant.BIGZERO;
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                pm.setString(1, entry.getId().toString());
                rs = pm.executeQuery();
                if (!rs.next()) continue;
                int amtPrecision = rs.getInt("fprecision");
                BigDecimal writtenOffQty = rs.getBigDecimal("writtenOffQty");
                BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                BigDecimal drewQty = rs.getBigDecimal("drewQty");
                BigDecimal writtenOffAmount = writtenOffQty.compareTo(rs.getBigDecimal("qty")) == 0 ? actualCost : writtenOffQty.multiply(unitActualCost).setScale(amtPrecision, 4);
                BigDecimal unWriteOffAmount = actualCost.subtract(writtenOffAmount);
                entry.setReverseQty(reverseQty);
                entry.setWrittenOffQty(writtenOffQty);
                entry.setUnWriteOffQty(rs.getBigDecimal("unWriteOffQty"));
                entry.setWrittenOffAmount(writtenOffAmount);
                entry.setUnWriteOffAmount(unWriteOffAmount);
                entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
                if (SysConstant.BIGZERO.compareTo(drewQty) == 0) continue;
                entry.setActualCost(rs.getBigDecimal("actualCost"));
                entry.setUnitActualCost(rs.getBigDecimal("unitActualCost"));
                entry.setWrittenOffAmount(rs.getBigDecimal("writtenOffAmount"));
                entry.setUnWriteOffAmount(rs.getBigDecimal("unWriteOffAmount"));
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pm, (Connection)conn);
    }

    private void initQtyPrecisionAndBaseConvsrate(Context ctx, List materialIdList, List unitIdList, List baseUnitIdList, List assitUnitIdList) throws BOSException {
        this.qtyPrecisionMap = new HashMap();
        this.baseConvsRateMap = new HashMap();
        if (null == materialIdList || materialIdList.size() == 0 || null == unitIdList || unitIdList.size() == 0 || null == baseUnitIdList || baseUnitIdList.size() == 0) {
            return;
        }
        int idSize = materialIdList.size();
        if (idSize > unitIdList.size()) {
            idSize = unitIdList.size();
        }
        if (idSize > baseUnitIdList.size()) {
            idSize = baseUnitIdList.size();
        }
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        for (int i = 0; i < idSize; ++i) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdList.get(i)));
            filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdList.get(i)));
            maskString.append(" (#").append(index).append(" and #").append(index + 1).append(") or");
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", materialIdList.get(i)));
            filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", baseUnitIdList.get(i)));
            maskString.append(" (#").append(index + 2).append(" and #").append(index + 3).append(") or");
            index += 4;
        }
        if (maskString.length() > 2) {
            maskString.setLength(maskString.length() - 2);
        }
        if (assitUnitIdList != null && assitUnitIdList.size() > 0) {
            int i;
            StringBuffer maskStr = new StringBuffer();
            HashSet<String> assistSet = new HashSet<String>();
            HashSet<String> mSet = new HashSet<String>();
            int size = assitUnitIdList.size();
            for (i = 0; i < size; ++i) {
                assistSet.add(assitUnitIdList.get(i).toString());
            }
            size = materialIdList.size();
            for (i = 0; i < size; ++i) {
                mSet.add(materialIdList.get(i).toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", mSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", assistSet, CompareType.INCLUDE));
            maskStr.append(" or (#").append(index).append(" and #").append(index + 1).append(") ");
            maskString.append(maskStr);
        }
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("measureUnit.id"));
        selector.add(new SelectorItemInfo("qtyPrecision"));
        selector.add(new SelectorItemInfo("baseConvsRate"));
        entityViewInfo.setSelector(selector);
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (col == null || col.size() == 0) {
            return;
        }
        MultiMeasureUnitInfo mmu = null;
        String key = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            mmu = col.get(i);
            key = mmu.getMaterial().getId().toString() + mmu.getMeasureUnit().getId().toString();
            this.qtyPrecisionMap.put(key, new Integer(mmu.getQtyPrecision()));
            this.baseConvsRateMap.put(key, mmu.getBaseConvsRate());
        }
    }

    private int getQtyPrecision(String materialId, String measureUnitId) {
        int qtyPricesion = 2;
        if (materialId == null || measureUnitId == null) {
            return qtyPricesion;
        }
        Integer qtyPreInteger = null;
        String key = materialId + measureUnitId;
        if (null != this.qtyPrecisionMap && this.qtyPrecisionMap.containsKey(key)) {
            qtyPreInteger = (Integer)this.qtyPrecisionMap.get(key);
        }
        if (null != qtyPreInteger) {
            qtyPricesion = qtyPreInteger;
        }
        return qtyPricesion;
    }

    private BigDecimal getBaseConvsrate(String materialId, String measureUnitId) {
        if (materialId == null || measureUnitId == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        BigDecimal baseConvsrate = null;
        String key = materialId + measureUnitId;
        if (null != this.baseConvsRateMap && this.baseConvsRateMap.containsKey(key)) {
            baseConvsrate = (BigDecimal)this.baseConvsRateMap.get(key);
        }
        if (null == baseConvsrate) {
            baseConvsrate = SCMConstant.BIGDECIMAL_ONE;
        }
        return baseConvsrate;
    }

    private void doSplitBillEntryByHand(Context ctx, PurInWarehsBillInfo motherInfo, PurInWarehsBillInfo childInfo, Map entryId2SplitQtyMap) throws BOSException, EASBizException {
        int i;
        PurInWarehsEntryInfo motherEntryInfo = null;
        PurInWarehsEntryInfo childEntryInfo = null;
        PurInWarehsEntryInfo cMotherEntryInfo = null;
        if (motherInfo == null || childInfo == null || entryId2SplitQtyMap == null || entryId2SplitQtyMap.size() == 0 || motherInfo.getCurrency() == null) {
            return;
        }
        IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getLocalInstance(ctx);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("motherId", motherInfo.getId().toString());
        String rootId = null;
        HashMap resultMap = (HashMap)iRelationOfChildAndParentFacade.queryInfoByMap(map);
        if (resultMap.get("FRootID") != null) {
            rootId = (String)resultMap.get("FRootID");
        } else {
            rootId = motherInfo.getId().toString();
            this.insertRootSplitRelation(ctx, motherInfo);
        }
        BigDecimal splitQty = ZERO;
        PurInWarehsEntryCollection childEntryCol = childInfo.getEntry();
        int currencyPrecision = motherInfo.getCurrency().getPrecision();
        ArrayList<String> mList = new ArrayList<String>();
        ArrayList<String> uList = new ArrayList<String>();
        ArrayList<String> bList = new ArrayList<String>();
        ArrayList<String> aList = new ArrayList<String>();
        int size = childEntryCol.size();
        for (i = 0; i < size; ++i) {
            childEntryInfo = childEntryCol.get(i);
            if (childEntryInfo.getMaterial() == null || childEntryInfo.getUnit() == null || childEntryInfo.getBaseUnit() == null) continue;
            mList.add(childEntryInfo.getMaterial().getId().toString());
            uList.add(childEntryInfo.getUnit().getId().toString());
            bList.add(childEntryInfo.getBaseUnit().getId().toString());
            if (childEntryInfo.getAssistUnit() == null) continue;
            aList.add(childEntryInfo.getAssistUnit().getId().toString());
        }
        this.initQtyPrecisionAndBaseConvsrate(ctx, mList, uList, bList, aList);
        size = childEntryCol.size();
        for (i = childEntryCol.size() - 1; i >= 0; --i) {
            childEntryInfo = childEntryCol.get(i);
            motherEntryInfo = motherInfo.getEntry().get(BOSUuid.read((String)childEntryInfo.getMotherEntryID()));
            cMotherEntryInfo = (PurInWarehsEntryInfo)motherEntryInfo.clone();
            if (entryId2SplitQtyMap.containsKey(motherEntryInfo.getId().toString())) {
                splitQty = (BigDecimal)entryId2SplitQtyMap.get(motherEntryInfo.getId().toString());
            }
            if (splitQty.compareTo(ZERO) == 0) {
                motherInfo.getEntry().remove(motherEntryInfo);
                StringBuffer sql = new StringBuffer();
                sql.append("update T_IV_MATERIALSERIALNUMBER set fbillentryid = '" + childEntryInfo.getId().toString() + "',fbillid = '" + childInfo.getId().toString() + "',fbillNUMBER = '" + childInfo.getNumber().toString() + "'  where fbillentryid = '" + motherEntryInfo.getId().toString() + "'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                iRelationOfChildAndParentFacade.purInWarehsAddChildOrderToParent(motherInfo, childInfo, " ", childEntryInfo.getId().toString(), rootId);
                continue;
            }
            if (splitQty.compareTo(childEntryInfo.getQty()) == 0) {
                childEntryCol.remove(childEntryInfo);
                continue;
            }
            iRelationOfChildAndParentFacade.purInWarehsAddChildOrderToParent(motherInfo, childInfo, motherEntryInfo.getId().toString(), childEntryInfo.getId().toString(), rootId);
            this.dealWithMotherEntryInfo(motherInfo, motherEntryInfo, splitQty, currencyPrecision);
            this.dealWithChildEntryInfo(motherInfo, cMotherEntryInfo, motherEntryInfo, childEntryInfo);
            this.dealWithSpcialField(cMotherEntryInfo, motherEntryInfo, childEntryInfo);
        }
    }

    private void calEntryBaseQtyBySplitQty(PurInWarehsEntryInfo entryInfo) {
        if (entryInfo == null || entryInfo.getMaterial() == null || entryInfo.getUnit() == null) {
            return;
        }
        String materialInfoId = entryInfo.getMaterial().getId().toString();
        int baseQtyPrecision = this.getQtyPrecision(materialInfoId, entryInfo.getBaseUnit().getId().toString());
        BigDecimal baseConvsRate = this.getBaseConvsrate(materialInfoId, entryInfo.getUnit().getId().toString());
        entryInfo.setBaseQty(entryInfo.getQty().multiply(baseConvsRate).setScale(baseQtyPrecision, 4));
    }

    private void dealWithMotherEntryInfo(PurInWarehsBillInfo motherInfo, PurInWarehsEntryInfo motherEntryInfo, BigDecimal splitQty, int currencyPrecision) {
        int localPrecision = 2;
        if (motherEntryInfo.getCompanyOrgUnit() != null && motherEntryInfo.getCompanyOrgUnit().getBaseCurrency() != null) {
            localPrecision = motherEntryInfo.getCompanyOrgUnit().getBaseCurrency().getPrecision();
        }
        BigDecimal rate = splitQty.divide(motherEntryInfo.getQty(), 10, 4);
        motherEntryInfo.setQty(splitQty);
        this.calEntryBaseQtyBySplitQty(motherEntryInfo);
        if (motherEntryInfo.getAssistUnit() == null) {
            motherEntryInfo.setAssistQty(ZERO);
        } else {
            int assistQtyPrecision = this.getQtyPrecision(motherEntryInfo.getMaterial().getId().toString(), motherEntryInfo.getAssistUnit().getId().toString());
            motherEntryInfo.setAssistQty(rate.multiply(motherEntryInfo.getAssistQty()).setScale(assistQtyPrecision, 4));
        }
        motherEntryInfo.setPurchaseCost(rate.multiply(motherEntryInfo.getPurchaseCost()).setScale(localPrecision, 4));
        motherEntryInfo.setMaterialCost(rate.multiply(motherEntryInfo.getMaterialCost()).setScale(localPrecision, 4));
        motherEntryInfo.setPurchaseFee(rate.multiply(motherEntryInfo.getPurchaseFee()).setScale(localPrecision, 4));
        motherEntryInfo.setActualCost(motherEntryInfo.getPurchaseCost().add(motherEntryInfo.getPurchaseFee()).add(motherEntryInfo.getMaterialCost()));
        motherEntryInfo.setStandardCost(rate.multiply(motherEntryInfo.getStandardCost()).setScale(localPrecision, 4));
        motherEntryInfo.setWrittenOffQty(ZERO);
        motherEntryInfo.setWrittenOffAmount(ZERO);
        motherEntryInfo.setUnWriteOffQty(splitQty);
        motherEntryInfo.setUnWriteOffBaseQty(motherEntryInfo.getBaseQty());
        motherEntryInfo.setUnWriteOffAmount(motherEntryInfo.getPurchaseCost().subtract(motherEntryInfo.getWrittenOffAmount()));
        motherEntryInfo.setAmount(rate.multiply(motherEntryInfo.getAmount()).setScale(currencyPrecision, 4));
        motherEntryInfo.setLocalAmount(rate.multiply(motherEntryInfo.getLocalAmount()).setScale(currencyPrecision, 4));
        motherEntryInfo.setTaxAmount(rate.multiply(motherEntryInfo.getTaxAmount()).setScale(currencyPrecision, 4));
        motherEntryInfo.setLocalTaxAmount(rate.multiply(motherEntryInfo.getLocalTaxAmount()).setScale(localPrecision, 4));
        motherEntryInfo.setTax(motherEntryInfo.getTaxAmount().subtract(motherEntryInfo.getAmount()).setScale(currencyPrecision, 4));
        motherEntryInfo.setLocalTax(motherEntryInfo.getLocalTaxAmount().subtract(motherEntryInfo.getLocalAmount()).setScale(localPrecision, 4));
        if (motherEntryInfo.getDiscountAmount().compareTo(ZERO) == 0) {
            motherEntryInfo.setDiscountAmount(ZERO);
        } else {
            motherEntryInfo.setDiscountAmount(rate.multiply(motherEntryInfo.getDiscountAmount()).setScale(currencyPrecision, 4));
        }
        if (motherInfo.getPurchaseType().equals((Object)PurchaseTypeEnum.SUBCONTRACT)) {
            motherEntryInfo.setScWrittenOffQty(ZERO);
            motherEntryInfo.setScWrittenOffBaseQty(ZERO);
            motherEntryInfo.setScUnWrittenOffQty(splitQty.subtract(motherEntryInfo.getScWrittenOffQty()));
            motherEntryInfo.setScUnWrittenOffBaseQty(motherEntryInfo.getBaseQty().subtract(motherEntryInfo.getScWrittenOffBaseQty()));
        }
    }

    private void dealWithChildEntryInfo(PurInWarehsBillInfo motherInfo, PurInWarehsEntryInfo cMotherEntryInfo, PurInWarehsEntryInfo motherEntryInfo, PurInWarehsEntryInfo childEntryInfo) {
        childEntryInfo.setQty(cMotherEntryInfo.getQty().subtract(motherEntryInfo.getQty()));
        this.calEntryBaseQtyBySplitQty(childEntryInfo);
        if (childEntryInfo.getAssistUnit() == null) {
            childEntryInfo.setAssistQty(ZERO);
        } else {
            childEntryInfo.setAssistQty(cMotherEntryInfo.getAssistQty().subtract(motherEntryInfo.getAssistQty()));
        }
        childEntryInfo.setActualCost(cMotherEntryInfo.getActualCost().subtract(motherEntryInfo.getActualCost()));
        childEntryInfo.setStandardCost(cMotherEntryInfo.getStandardCost().subtract(motherEntryInfo.getStandardCost()));
        childEntryInfo.setPurchaseCost(cMotherEntryInfo.getPurchaseCost().subtract(motherEntryInfo.getPurchaseCost()));
        childEntryInfo.setMaterialCost(cMotherEntryInfo.getMaterialCost().subtract(motherEntryInfo.getMaterialCost()));
        childEntryInfo.setPurchaseFee(cMotherEntryInfo.getPurchaseFee().subtract(motherEntryInfo.getPurchaseFee()));
        childEntryInfo.setWrittenOffQty(ZERO);
        childEntryInfo.setWrittenOffBaseQty(ZERO);
        childEntryInfo.setWrittenOffAmount(ZERO);
        childEntryInfo.setUnWriteOffQty(childEntryInfo.getQty());
        childEntryInfo.setUnWriteOffBaseQty(childEntryInfo.getBaseQty());
        childEntryInfo.setUnWriteOffAmount(childEntryInfo.getActualCost());
        childEntryInfo.setAmount(cMotherEntryInfo.getAmount().subtract(motherEntryInfo.getAmount()));
        childEntryInfo.setLocalAmount(cMotherEntryInfo.getLocalAmount().subtract(motherEntryInfo.getLocalAmount()));
        childEntryInfo.setTaxAmount(cMotherEntryInfo.getTaxAmount().subtract(motherEntryInfo.getTaxAmount()));
        childEntryInfo.setLocalTaxAmount(cMotherEntryInfo.getLocalTaxAmount().subtract(motherEntryInfo.getLocalTaxAmount()));
        childEntryInfo.setTax(childEntryInfo.getTaxAmount().subtract(childEntryInfo.getAmount()));
        childEntryInfo.setLocalTax(childEntryInfo.getLocalTaxAmount().subtract(childEntryInfo.getLocalAmount()));
        if (cMotherEntryInfo.getDiscountAmount().compareTo(ZERO) == 0) {
            childEntryInfo.setDiscountAmount(ZERO);
        } else {
            childEntryInfo.setDiscountAmount(cMotherEntryInfo.getDiscountAmount().subtract(motherEntryInfo.getDiscountAmount()));
        }
        if (motherInfo.getPurchaseType().equals((Object)PurchaseTypeEnum.SUBCONTRACT)) {
            childEntryInfo.setScWrittenOffQty(ZERO);
            childEntryInfo.setScWrittenOffBaseQty(ZERO);
            childEntryInfo.setScUnWrittenOffQty(childEntryInfo.getQty());
            childEntryInfo.setScUnWrittenOffBaseQty(childEntryInfo.getBaseQty());
        }
    }

    private void dealWithSpcialField(PurInWarehsEntryInfo cMotherEntryInfo, PurInWarehsEntryInfo motherEntryInfo, PurInWarehsEntryInfo childEntryInfo) {
        if (cMotherEntryInfo.getUnReturnedBaseQty().abs().compareTo(childEntryInfo.getBaseQty().abs()) > 0) {
            motherEntryInfo.setUnReturnedBaseQty(cMotherEntryInfo.getUnReturnedBaseQty().subtract(childEntryInfo.getBaseQty()));
            childEntryInfo.setUnReturnedBaseQty(childEntryInfo.getBaseQty());
        } else {
            motherEntryInfo.setUnReturnedBaseQty(ZERO);
        }
        if (cMotherEntryInfo.getReturnsQty().abs().compareTo(motherEntryInfo.getQty().abs()) > 0) {
            motherEntryInfo.setReturnsQty(motherEntryInfo.getQty());
            childEntryInfo.setReturnsQty(cMotherEntryInfo.getReturnsQty().subtract(motherEntryInfo.getReturnsQty()));
        } else {
            childEntryInfo.setReturnsQty(ZERO);
        }
        if (cMotherEntryInfo.getReturnBaseQty().abs().compareTo(motherEntryInfo.getBaseQty().abs()) > 0) {
            motherEntryInfo.setReturnBaseQty(motherEntryInfo.getBaseQty());
            childEntryInfo.setReturnBaseQty(cMotherEntryInfo.getReturnBaseQty().subtract(motherEntryInfo.getReturnBaseQty()));
        } else {
            childEntryInfo.setReturnBaseQty(ZERO);
        }
        if (cMotherEntryInfo.getTotalMoveQty().abs().compareTo(motherEntryInfo.getQty().abs()) > 0) {
            motherEntryInfo.setTotalMoveQty(motherEntryInfo.getQty());
            childEntryInfo.setTotalMoveQty(cMotherEntryInfo.getTotalMoveQty().subtract(motherEntryInfo.getTotalMoveQty()));
        } else {
            childEntryInfo.setTotalMoveQty(ZERO);
        }
        if (cMotherEntryInfo.getCanDirectReqQty().abs().compareTo(childEntryInfo.getQty().abs()) > 0) {
            childEntryInfo.setCanDirectReqQty(childEntryInfo.getQty());
            motherEntryInfo.setCanDirectReqQty(cMotherEntryInfo.getCanDirectReqQty().subtract(childEntryInfo.getQty()));
        } else {
            motherEntryInfo.setCanDirectReqQty(ZERO);
        }
        if (cMotherEntryInfo.getCanDirectReqBaseQty().abs().compareTo(childEntryInfo.getBaseQty().abs()) <= 0) {
            motherEntryInfo.setCanDirectReqBaseQty(ZERO);
        } else {
            childEntryInfo.setCanDirectReqBaseQty(childEntryInfo.getBaseQty());
            motherEntryInfo.setCanDirectReqBaseQty(cMotherEntryInfo.getCanDirectReqBaseQty().subtract(childEntryInfo.getBaseQty()));
        }
        if (cMotherEntryInfo.getAssociateQty().abs().compareTo(childEntryInfo.getBaseQty().abs()) > 0) {
            childEntryInfo.setAssociateQty(childEntryInfo.getBaseQty());
            motherEntryInfo.setAssociateQty(cMotherEntryInfo.getAssociateQty().subtract(childEntryInfo.getBaseQty()));
        } else {
            motherEntryInfo.setAssociateQty(ZERO);
        }
        if (cMotherEntryInfo.getDrewQty().abs().compareTo(motherEntryInfo.getQty().abs()) <= 0) {
            childEntryInfo.setDrewQty(ZERO);
        } else {
            motherEntryInfo.setDrewQty(motherEntryInfo.getQty());
            childEntryInfo.setDrewQty(cMotherEntryInfo.getDrewQty().subtract(motherEntryInfo.getDrewQty()));
        }
        if (cMotherEntryInfo.getDrewBaseQty().abs().compareTo(motherEntryInfo.getBaseQty().abs()) <= 0) {
            childEntryInfo.setDrewBaseQty(ZERO);
        } else {
            motherEntryInfo.setDrewBaseQty(motherEntryInfo.getBaseQty());
            childEntryInfo.setDrewBaseQty(cMotherEntryInfo.getDrewBaseQty().subtract(motherEntryInfo.getDrewBaseQty()));
        }
        if (cMotherEntryInfo.getReverseQty().abs().compareTo(motherEntryInfo.getQty().abs()) <= 0) {
            childEntryInfo.setReverseQty(ZERO);
        } else {
            motherEntryInfo.setReverseQty(motherEntryInfo.getQty());
            childEntryInfo.setReverseQty(cMotherEntryInfo.getReverseQty().subtract(motherEntryInfo.getReverseBaseQty()));
        }
        if (cMotherEntryInfo.getReverseBaseQty().abs().compareTo(motherEntryInfo.getBaseQty().abs()) <= 0) {
            childEntryInfo.setReverseBaseQty(ZERO);
        } else {
            motherEntryInfo.setReverseBaseQty(motherEntryInfo.getBaseQty());
            childEntryInfo.setReverseBaseQty(cMotherEntryInfo.getReverseBaseQty().subtract(motherEntryInfo.getReverseBaseQty()));
        }
    }

    private void doSplitBillEntry(PurInWarehsEntryInfo aMotherEntryInfo, PurInWarehsEntryInfo aChildEntryInfo, PurInWarehsBillInfo aPurInWarehsBillInfo, int precision, Context ctx) throws EASBizException, BOSException {
        BigDecimal tempTaxRate;
        BigDecimal ZERO = SysConstant.BIGZERO;
        BigDecimal ONE = new BigDecimal("1.00");
        BigDecimal PPH = new BigDecimal("0.01");
        BigDecimal coefficient = null;
        int localPrecision = precision;
        int multiPrecision = precision;
        int currencyPrecision = aPurInWarehsBillInfo.getCurrency().getPrecision();
        int materialPrecision = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(aChildEntryInfo.getMaterial().getId().toString())).getPricePrecision();
        MeasureUnitInfo muBase = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(aChildEntryInfo.getMaterial().getId().toString())).getBaseUnit();
        multiPrecision = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getQtyPrecision(aChildEntryInfo.getMaterial().getId().toString(), muBase.getId().toString());
        if (aMotherEntryInfo.getCompanyOrgUnit() != null && aMotherEntryInfo.getCompanyOrgUnit().getBaseCurrency() != null) {
            localPrecision = aMotherEntryInfo.getCompanyOrgUnit().getBaseCurrency().getPrecision();
        }
        PurInWarehsEntryInfo aColneMotherEntryInfo = (PurInWarehsEntryInfo)aMotherEntryInfo.clone();
        aMotherEntryInfo.setQty(aColneMotherEntryInfo.getWrittenOffQty());
        aChildEntryInfo.setQty(aColneMotherEntryInfo.getUnWriteOffQty());
        aChildEntryInfo.setBaseQty(aColneMotherEntryInfo.getUnWriteOffBaseQty());
        aMotherEntryInfo.setBaseQty(aColneMotherEntryInfo.getWrittenOffBaseQty());
        coefficient = aChildEntryInfo.getQty().divide(aColneMotherEntryInfo.getQty(), 10, 4);
        aChildEntryInfo.setAssistQty(coefficient.multiply(aColneMotherEntryInfo.getAssistQty()).setScale(multiPrecision, 4));
        aMotherEntryInfo.setAssistQty(aColneMotherEntryInfo.getAssistQty().subtract(aChildEntryInfo.getAssistQty()));
        aMotherEntryInfo.setPurchaseCost(aColneMotherEntryInfo.getWrittenOffAmount());
        aChildEntryInfo.setPurchaseCost(aColneMotherEntryInfo.getPurchaseCost().subtract(aColneMotherEntryInfo.getWrittenOffAmount()));
        aChildEntryInfo.setPurchaseFee(coefficient.multiply(aColneMotherEntryInfo.getPurchaseFee().setScale(localPrecision, 4)));
        aMotherEntryInfo.setPurchaseFee(aColneMotherEntryInfo.getPurchaseFee().subtract(aChildEntryInfo.getPurchaseFee()));
        if (aColneMotherEntryInfo.getUnitMaterialCost() == null) {
            aColneMotherEntryInfo.setUnitMaterialCost(ZERO);
        }
        aMotherEntryInfo.setUnitMaterialCost(aColneMotherEntryInfo.getUnitMaterialCost());
        aChildEntryInfo.setUnitMaterialCost(aColneMotherEntryInfo.getUnitMaterialCost());
        aChildEntryInfo.setMaterialCost(aChildEntryInfo.getUnitMaterialCost().multiply(aChildEntryInfo.getQty()).setScale(localPrecision, 4));
        aMotherEntryInfo.setMaterialCost(aColneMotherEntryInfo.getMaterialCost().subtract(aChildEntryInfo.getMaterialCost()));
        if (aColneMotherEntryInfo.getUnitActualCost() == null) {
            aColneMotherEntryInfo.setUnitActualCost(ZERO);
        }
        aChildEntryInfo.setActualCost(aChildEntryInfo.getPurchaseCost().add(aChildEntryInfo.getPurchaseFee()).add(aChildEntryInfo.getMaterialCost()));
        aMotherEntryInfo.setActualCost(aColneMotherEntryInfo.getActualCost().subtract(aChildEntryInfo.getActualCost()));
        aChildEntryInfo.setUnitActualCost(aChildEntryInfo.getActualCost().divide(aChildEntryInfo.getQty(), materialPrecision, 4));
        aMotherEntryInfo.setUnitActualCost(aColneMotherEntryInfo.getUnitActualCost());
        aChildEntryInfo.setStandardCost(aChildEntryInfo.getQty().multiply(aChildEntryInfo.getUnitStandardCost()).setScale(localPrecision, 4));
        aMotherEntryInfo.setStandardCost(aColneMotherEntryInfo.getStandardCost().subtract(aChildEntryInfo.getStandardCost()));
        aChildEntryInfo.setTaxRate(aColneMotherEntryInfo.getTaxRate());
        aMotherEntryInfo.setTaxRate(aColneMotherEntryInfo.getTaxRate());
        aChildEntryInfo.setTaxRate(aColneMotherEntryInfo.getTaxRate());
        aMotherEntryInfo.setTaxRate(aColneMotherEntryInfo.getTaxRate());
        if (aPurInWarehsBillInfo.isIsInTax() && !aPurInWarehsBillInfo.isIsPriceInTax()) {
            aChildEntryInfo.setTaxPrice(aColneMotherEntryInfo.getTaxPrice());
            aMotherEntryInfo.setTaxPrice(aColneMotherEntryInfo.getTaxPrice());
            BigDecimal taxrate = aChildEntryInfo.getTaxRate().multiply(PPH);
            aChildEntryInfo.setPrice(aChildEntryInfo.getTaxPrice().divide(ONE.subtract(taxrate), materialPrecision, 4));
            aMotherEntryInfo.setPrice(aColneMotherEntryInfo.getPrice());
        } else if (aPurInWarehsBillInfo.isIsInTax() && aPurInWarehsBillInfo.isIsPriceInTax()) {
            aChildEntryInfo.setTaxPrice(aColneMotherEntryInfo.getTaxPrice());
            aMotherEntryInfo.setTaxPrice(aColneMotherEntryInfo.getTaxPrice());
            aChildEntryInfo.setPrice(aChildEntryInfo.getTaxPrice().divide(aChildEntryInfo.getTaxRate().multiply(PPH).add(ONE), materialPrecision, 4));
            aMotherEntryInfo.setPrice(aColneMotherEntryInfo.getPrice());
        } else {
            aChildEntryInfo.setPrice(aColneMotherEntryInfo.getPrice());
            aMotherEntryInfo.setPrice(aColneMotherEntryInfo.getPrice());
            tempTaxRate = aChildEntryInfo.getTaxRate().multiply(PPH).setScale(10, 4);
            aChildEntryInfo.setTaxPrice(aChildEntryInfo.getPrice().multiply(tempTaxRate.add(ONE)).setScale(materialPrecision, 4));
            aMotherEntryInfo.setTaxPrice(aColneMotherEntryInfo.getTaxPrice());
        }
        aChildEntryInfo.setDiscountRate(aColneMotherEntryInfo.getDiscountRate());
        aMotherEntryInfo.setDiscountRate(aColneMotherEntryInfo.getDiscountRate());
        aChildEntryInfo.setDiscountAmount(aChildEntryInfo.getTaxPrice().multiply(aChildEntryInfo.getQty()).multiply(aChildEntryInfo.getDiscountRate().multiply(PPH)).setScale(currencyPrecision, 4));
        aMotherEntryInfo.setDiscountAmount(aColneMotherEntryInfo.getDiscountAmount().subtract(aChildEntryInfo.getDiscountAmount()));
        if (aPurInWarehsBillInfo.isIsInTax() && !aPurInWarehsBillInfo.isIsPriceInTax()) {
            tempTaxRate = aMotherEntryInfo.getTaxRate().multiply(PPH);
            BigDecimal taxAmountloc = aMotherEntryInfo.getPurchaseCost().divide(ONE.subtract(tempTaxRate), localPrecision, 4);
            if (aPurInWarehsBillInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
                aMotherEntryInfo.setTaxAmount(taxAmountloc.divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
            } else {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
                aMotherEntryInfo.setTaxAmount(taxAmountloc.multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
            }
            aMotherEntryInfo.setTax(aMotherEntryInfo.getTaxAmount().subtract(aMotherEntryInfo.getAmount()));
        } else if (aPurInWarehsBillInfo.isIsInTax() && aPurInWarehsBillInfo.isIsPriceInTax()) {
            tempTaxRate = aMotherEntryInfo.getTaxRate().multiply(PPH);
            BigDecimal taxLoc = aMotherEntryInfo.getPurchaseCost().multiply(tempTaxRate).setScale(localPrecision, 4);
            if (aPurInWarehsBillInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
                aMotherEntryInfo.setTax(taxLoc.divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
            } else {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
                aMotherEntryInfo.setTax(taxLoc.multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
            }
            aMotherEntryInfo.setTaxAmount(aMotherEntryInfo.getAmount().add(aMotherEntryInfo.getTax()).setScale(currencyPrecision, 4));
        } else {
            tempTaxRate = aMotherEntryInfo.getTaxRate().multiply(PPH);
            BigDecimal taxLoc = aMotherEntryInfo.getPurchaseCost().multiply(tempTaxRate).setScale(localPrecision, 4);
            if (aPurInWarehsBillInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
                aMotherEntryInfo.setTax(taxLoc.divide(aPurInWarehsBillInfo.getExchangeRate(), currencyPrecision, 4));
            } else {
                aMotherEntryInfo.setAmount(aMotherEntryInfo.getPurchaseCost().multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
                aMotherEntryInfo.setTax(taxLoc.multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(currencyPrecision, 4));
            }
            aMotherEntryInfo.setTaxAmount(aMotherEntryInfo.getAmount().add(aMotherEntryInfo.getTax()).setScale(currencyPrecision, 4));
        }
        aChildEntryInfo.setTaxAmount(aColneMotherEntryInfo.getTaxAmount().subtract(aMotherEntryInfo.getTaxAmount()));
        aChildEntryInfo.setTax(aColneMotherEntryInfo.getTax().subtract(aMotherEntryInfo.getTax()));
        aChildEntryInfo.setAmount(aColneMotherEntryInfo.getAmount().subtract(aMotherEntryInfo.getAmount()));
        if (aChildEntryInfo.getDiscountRate().compareTo(ZERO) == 0) {
            aChildEntryInfo.setActualPrice(aChildEntryInfo.getPrice());
        } else {
            aChildEntryInfo.setActualPrice(aChildEntryInfo.getAmount().divide(aChildEntryInfo.getQty(), materialPrecision, 4));
        }
        aMotherEntryInfo.setActualPrice(aColneMotherEntryInfo.getActualPrice());
        if (aPurInWarehsBillInfo.getExchangeRate().compareTo(ONE) == 0) {
            aChildEntryInfo.setUnitPurchaseCost(aChildEntryInfo.getActualPrice());
        } else {
            aChildEntryInfo.setUnitPurchaseCost(aChildEntryInfo.getPurchaseCost().divide(aChildEntryInfo.getQty(), materialPrecision, 4));
        }
        if (aChildEntryInfo.getDiscountRate().compareTo(ZERO) == 0) {
            aChildEntryInfo.setActualTaxPrice(aChildEntryInfo.getTaxPrice());
        } else {
            aChildEntryInfo.setActualTaxPrice(aChildEntryInfo.getTaxAmount().divide(aChildEntryInfo.getQty(), materialPrecision, 4));
        }
        aMotherEntryInfo.setActualTaxPrice(aColneMotherEntryInfo.getActualTaxPrice());
        if (aPurInWarehsBillInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            aChildEntryInfo.setLocalTax(aChildEntryInfo.getTax().multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(localPrecision, 4));
            aMotherEntryInfo.setLocalTax(aColneMotherEntryInfo.getLocalTax().subtract(aChildEntryInfo.getLocalTax()));
            aChildEntryInfo.setLocalTaxAmount(aChildEntryInfo.getTaxAmount().multiply(aPurInWarehsBillInfo.getExchangeRate()).setScale(localPrecision, 4));
            aMotherEntryInfo.setLocalTaxAmount(aColneMotherEntryInfo.getLocalTaxAmount().subtract(aChildEntryInfo.getLocalTaxAmount()));
        } else {
            aChildEntryInfo.setLocalTax(aChildEntryInfo.getTax().divide(aPurInWarehsBillInfo.getExchangeRate(), localPrecision, 4));
            aMotherEntryInfo.setLocalTax(aColneMotherEntryInfo.getLocalTax().subtract(aChildEntryInfo.getLocalTax()));
            aChildEntryInfo.setLocalTaxAmount(aChildEntryInfo.getTaxAmount().divide(aPurInWarehsBillInfo.getExchangeRate(), localPrecision, 4));
            aMotherEntryInfo.setLocalTaxAmount(aColneMotherEntryInfo.getLocalTaxAmount().subtract(aChildEntryInfo.getLocalTaxAmount()));
        }
        aChildEntryInfo.setWrittenOffQty(ZERO);
        aChildEntryInfo.setWrittenOffBaseQty(ZERO);
        aChildEntryInfo.setWrittenOffAmount(ZERO);
        aMotherEntryInfo.setUnWriteOffQty(ZERO);
        aChildEntryInfo.setUnWriteOffQty(aChildEntryInfo.getQty());
        aMotherEntryInfo.setUnWriteOffBaseQty(ZERO);
        aChildEntryInfo.setUnWriteOffBaseQty(aChildEntryInfo.getBaseQty());
        if (aPurInWarehsBillInfo.getPurchaseType().getValue() == 1) {
            aMotherEntryInfo.setScUnWrittenOffQty(aMotherEntryInfo.getQty().subtract(aMotherEntryInfo.getScWrittenOffQty()));
            aMotherEntryInfo.setScUnWrittenOffBaseQty(aMotherEntryInfo.getBaseQty().subtract(aMotherEntryInfo.getScWrittenOffBaseQty()));
            aChildEntryInfo.setScUnWrittenOffQty(aChildEntryInfo.getQty().subtract(aChildEntryInfo.getScWrittenOffQty()));
            aChildEntryInfo.setScUnWrittenOffBaseQty(aChildEntryInfo.getBaseQty().subtract(aChildEntryInfo.getScWrittenOffBaseQty()));
        }
        aMotherEntryInfo.setUnWriteOffAmount(ZERO);
        aChildEntryInfo.setUnWriteOffAmount(aChildEntryInfo.getPurchaseCost());
        if (aColneMotherEntryInfo.getAssociateQty().abs().compareTo(aChildEntryInfo.getQty().abs()) <= 0) {
            aChildEntryInfo.setAssociateQty(aColneMotherEntryInfo.getAssociateQty());
            aMotherEntryInfo.setAssociateQty(ZERO);
        } else {
            aChildEntryInfo.setAssociateQty(aChildEntryInfo.getQty());
            aMotherEntryInfo.setAssociateQty(aColneMotherEntryInfo.getAssociateQty().subtract(aChildEntryInfo.getAssociateQty()));
        }
        if (aColneMotherEntryInfo.getReverseQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setReverseQty(aColneMotherEntryInfo.getReverseQty());
            aChildEntryInfo.setReverseQty(ZERO);
        } else {
            aMotherEntryInfo.setReverseQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setReverseQty(aColneMotherEntryInfo.getReverseQty().subtract(aMotherEntryInfo.getReverseQty()));
        }
        if (aColneMotherEntryInfo.getReverseBaseQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setReverseBaseQty(aColneMotherEntryInfo.getReverseBaseQty());
            aChildEntryInfo.setReverseBaseQty(ZERO);
        } else {
            aMotherEntryInfo.setReverseBaseQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setReverseBaseQty(aColneMotherEntryInfo.getReverseBaseQty().subtract(aMotherEntryInfo.getReverseBaseQty()));
        }
        if (aColneMotherEntryInfo.getReturnsQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setReturnsQty(aColneMotherEntryInfo.getReturnsQty());
            aChildEntryInfo.setReturnsQty(ZERO);
        } else {
            aMotherEntryInfo.setReturnsQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setReturnsQty(aColneMotherEntryInfo.getReturnsQty().subtract(aMotherEntryInfo.getReturnsQty()));
        }
        if (aColneMotherEntryInfo.getReturnBaseQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setReturnBaseQty(aColneMotherEntryInfo.getReturnBaseQty());
            aChildEntryInfo.setReturnBaseQty(ZERO);
        } else {
            aMotherEntryInfo.setReturnBaseQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setReturnBaseQty(aColneMotherEntryInfo.getReturnBaseQty().subtract(aMotherEntryInfo.getReturnBaseQty()));
        }
        if (aColneMotherEntryInfo.getUnReturnedBaseQty().abs().compareTo(aChildEntryInfo.getQty().abs()) <= 0) {
            aChildEntryInfo.setUnReturnedBaseQty(aColneMotherEntryInfo.getUnReturnedBaseQty());
            aMotherEntryInfo.setUnReturnedBaseQty(ZERO);
        } else {
            aChildEntryInfo.setUnReturnedBaseQty(aChildEntryInfo.getQty());
            aMotherEntryInfo.setUnReturnedBaseQty(aColneMotherEntryInfo.getUnReturnedBaseQty().subtract(aChildEntryInfo.getUnReturnedBaseQty()));
        }
        if (aColneMotherEntryInfo.getDrewQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setDrewQty(aColneMotherEntryInfo.getDrewQty());
            aChildEntryInfo.setDrewQty(ZERO);
        } else {
            aMotherEntryInfo.setDrewQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setDrewQty(aColneMotherEntryInfo.getDrewQty().subtract(aMotherEntryInfo.getDrewQty()));
        }
        if (aColneMotherEntryInfo.getDrewBaseQty().abs().compareTo(aMotherEntryInfo.getBaseQty().abs()) <= 0) {
            aMotherEntryInfo.setDrewBaseQty(aColneMotherEntryInfo.getDrewBaseQty());
            aChildEntryInfo.setDrewBaseQty(ZERO);
        } else {
            aMotherEntryInfo.setDrewBaseQty(aMotherEntryInfo.getDrewBaseQty());
            aChildEntryInfo.setDrewBaseQty(aColneMotherEntryInfo.getDrewBaseQty().subtract(aMotherEntryInfo.getDrewBaseQty()));
        }
        if (aColneMotherEntryInfo.getTotalMoveQty().abs().compareTo(aMotherEntryInfo.getQty().abs()) <= 0) {
            aMotherEntryInfo.setTotalMoveQty(aColneMotherEntryInfo.getTotalMoveQty());
            aChildEntryInfo.setTotalMoveQty(ZERO);
        } else {
            aMotherEntryInfo.setTotalMoveQty(aMotherEntryInfo.getQty());
            aChildEntryInfo.setTotalMoveQty(aColneMotherEntryInfo.getTotalMoveQty().subtract(aMotherEntryInfo.getTotalMoveQty()));
        }
        if (aColneMotherEntryInfo.getCanDirectReqQty().abs().compareTo(aChildEntryInfo.getQty().abs()) <= 0) {
            aChildEntryInfo.setCanDirectReqQty(aColneMotherEntryInfo.getCanDirectReqQty());
            aMotherEntryInfo.setCanDirectReqQty(ZERO);
        } else {
            aChildEntryInfo.setCanDirectReqQty(aChildEntryInfo.getQty());
            aMotherEntryInfo.setCanDirectReqQty(aColneMotherEntryInfo.getCanDirectReqQty().subtract(aChildEntryInfo.getCanDirectReqQty()));
        }
        if (aColneMotherEntryInfo.getCanDirectReqBaseQty().abs().compareTo(aChildEntryInfo.getQty().abs()) <= 0) {
            aChildEntryInfo.setCanDirectReqBaseQty(aColneMotherEntryInfo.getCanDirectReqBaseQty());
            aMotherEntryInfo.setCanDirectReqBaseQty(ZERO);
        } else {
            aChildEntryInfo.setCanDirectReqBaseQty(aChildEntryInfo.getQty());
            aMotherEntryInfo.setCanDirectReqBaseQty(aColneMotherEntryInfo.getCanDirectReqBaseQty().subtract(aChildEntryInfo.getCanDirectReqBaseQty()));
        }
    }

    public String getChildNumber(Context ctx, String number, int n) throws EASBizException, BOSException {
        String maxNumber;
        int index;
        String newNumber = null;
        String fillNumber = null;
        String subNumber = null;
        int count = 0;
        if ((number = this.getOldNumber(ctx, number)) == null || "".equals(number.trim())) {
            number = "purInwarehsSplitNumber";
        }
        if ((index = (maxNumber = this.getMaxNumber(ctx, number)).lastIndexOf("_C")) == -1) {
            newNumber = maxNumber + "_C001";
        } else {
            subNumber = maxNumber.substring(index + 2, maxNumber.length());
            try {
                count = Integer.parseInt(subNumber);
                fillNumber = this.fillSign(String.valueOf(++count), 3, "0");
                newNumber = number + "_C" + fillNumber;
            }
            catch (NumberFormatException e) {
                newNumber = maxNumber + "_C001";
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return newNumber;
    }

    private String getOldNumber(Context ctx, String number) throws BOSException {
        if (null == number || "".equals(number.trim())) {
            return null;
        }
        String oldNumber = null;
        String subNumber = null;
        int index = number.indexOf("_");
        if (index == -1) {
            oldNumber = number;
        } else {
            subNumber = number.substring(0, number.indexOf("_"));
            while (!this.existNumber(ctx, subNumber)) {
                if ((number = number.substring(number.indexOf("_") + 1)).indexOf("_") == -1) {
                    subNumber = subNumber + "_" + number;
                    continue;
                }
                subNumber = subNumber + "_" + number.substring(0, number.indexOf("_"));
            }
            oldNumber = subNumber;
        }
        if (this.existNumber(ctx, oldNumber)) {
            return oldNumber;
        }
        return null;
    }

    private String getMaxNumber(Context ctx, String number) throws BOSException {
        if (this.existNumber(ctx, number)) {
            String sql = "select max(fnumber) as fnumber from T_IM_PurInwarehsBill where fnumber like '" + number.trim() + "%'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (null != rowSet && rowSet.next()) {
                    return rowSet.getString("fnumber");
                }
                return null;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return number;
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        super.update(ctx, pk, model);
    }

    protected void _checkDestIncVisualBills(Context ctx, InvBillBaseInfo ivbInfo, Connection conn) throws EASBizException, BOSException {
        super._checkDestIncVisualBills(ctx, ivbInfo);
    }

    @Override
    protected void _checkIsHaveDestBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)aInvBillBaseInfo;
        if (piwInfo.isIsSysBill()) {
            throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
        }
        AutoPurInProcessor.getInstance().autoDelete(ctx, aInvBillBaseInfo);
        this._checkDestIncVisualBills(ctx, aInvBillBaseInfo);
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
        super._generateVoucher(ctx, mode);
    }

    @Override
    protected void _writeBackSupplierInvoice(Context ctx, IObjectValue model, IObjectPK[] pks, boolean flag, boolean isSucceed) throws BOSException, EASBizException {
    }

    public boolean isPurInReturnBill(Context ctx, PurInWarehsBillInfo model) throws BOSException, EASBizException {
        if (model == null) {
            return true;
        }
        TransactionTypeInfo trans = model.getTransactionType();
        if (trans == null) {
            return true;
        }
        if (trans.getId() == null) {
            return true;
        }
        if ("d8e80652-0107-1000-e000-04c5c0a812202407435C".equals(model.getBizTypeId())) {
            return true;
        }
        String srcBillId = model.getEntry().get(0).getSourceBillId();
        if (srcBillId == null || "".equals(srcBillId)) {
            return true;
        }
        BillTypeInfo billType = model.getEntry().get(0).getSourceBillType();
        if (billType != null && billType.getId() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType.getId().toString())) {
            ObjectUuidPK srcpk = new ObjectUuidPK(srcBillId);
            SCMBillBaseInfo srcmodel = this.getSCMBillBaseInfo(ctx, (IObjectPK)srcpk);
            PurInWarehsBillInfo srcinfo = null;
            if (srcmodel instanceof PurInWarehsBillInfo) {
                srcinfo = (PurInWarehsBillInfo)srcmodel;
                return this.isPurInReturnBill(ctx, srcinfo);
            }
        }
        return false;
    }

    @Override
    protected void _submitSplitBillByHand(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int i;
        HashSet<String> idSet = new HashSet<String>();
        PurInWarehsBillInfo childInfo = (PurInWarehsBillInfo)model;
        String motherBillId = (String)childInfo.get("motherBillId");
        if (model.get("SplitByHand") == null) {
            throw new SplitBillException(SplitBillException.SPLITQTYERROR);
        }
        Map entryId2SplitQtyMap = (Map)model.get("SplitByHand");
        if (null == entryId2SplitQtyMap || entryId2SplitQtyMap.size() == 0) {
            throw new SplitBillException(SplitBillException.SPLITQTYERROR);
        }
        SelectorItemCollection sic = this.getSelector();
        sic.add("currency.precision");
        sic.add("entry.companyOrgUnit.baseCurrency.id");
        sic.add("entry.companyOrgUnit.baseCurrency.precision");
        PurInWarehsBillInfo motherInfo = this.getPurInWarehsBillInfo(ctx, (IObjectPK)new ObjectUuidPK(motherBillId), sic);
        SplitBillTotalAmount motherSplitBillTotalAmount = new SplitBillTotalAmount();
        SplitBillTotalAmount childSplitBillTotalAmount = new SplitBillTotalAmount();
        this.checkCanSplitBill(childInfo, motherInfo);
        childInfo.setId(BOSUuid.create((BOSObjectType)childInfo.getBOSType()));
        childInfo.setNumber(this.getChildNumber(ctx, motherInfo.getNumber()));
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"submitSplitBillByHand", (BOSObjectType)BOSObjectType.create((String)"783061E3"), (IObjectPK)new ObjectUuidPK(motherBillId.toString()), (String)motherInfo.getNumber(), (String)"im_purInWarehs_splitBill");
        IObjectPK logchildPK = LogUtil.beginLog((Context)ctx, (String)"submitSplitBillByHand", (BOSObjectType)BOSObjectType.create((String)"783061E3"), (IObjectPK)new ObjectUuidPK(childInfo.getId().toString()), (String)childInfo.getNumber(), (String)"im_purInWarehs_addnew");
        PurInWarehsEntryCollection entrys = childInfo.getEntry();
        BOSObjectType entryBosType = entrys.get(0).getBOSType();
        for (int i2 = 0; i2 < entrys.size(); ++i2) {
            entrys.get(i2).setId(BOSUuid.create((BOSObjectType)entryBosType));
        }
        Vector hasEntryRelation = new Vector(0);
        Vector<SplitBillRelationInfo> vecSBRelation = new Vector<SplitBillRelationInfo>(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryRelation = new Vector<SplitBillEntryRelationInfo>(0);
        HashMap hsSB = new HashMap();
        boolean a = false;
        childInfo.setFiVouchered(motherInfo.isFiVouchered());
        childInfo.setVoucher(motherInfo.getVoucher());
        int count = childInfo.getEntry().size();
        for (int i3 = 0; i3 < count; ++i3) {
            PurInWarehsEntryInfo entry = childInfo.getEntry().get(i3);
            PurInWarehsEntryInfo soureEntry = motherInfo.getEntry().get(BOSUuid.read((String)entry.getMotherEntryID()));
            idSet.add(soureEntry.getId().toString());
            SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
            aSplitBillEntryRelationInfo.setMotherBillEntryID(soureEntry.getId().toString());
            aSplitBillEntryRelationInfo.setChildBillEntryID(entry.getId().toString());
            aSplitBillEntryRelationInfo.setSplitQty(entry.getQty());
            vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
            this.addRelationForSplitBillByHand(hasEntryRelation, soureEntry, entry, null, childInfo);
        }
        this.doSplitBillEntryByHand(ctx, motherInfo, childInfo, entryId2SplitQtyMap);
        boolean allMotherBaseQtyZero = true;
        boolean allChildBaseQtyZero = true;
        for (i = motherInfo.getEntry().size() - 1; i >= 0; --i) {
            if (motherInfo.getEntry().get(i).getBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
            allMotherBaseQtyZero = false;
            break;
        }
        for (i = childInfo.getEntry().size() - 1; i >= 0; --i) {
            if (childInfo.getEntry().get(i).getBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
            allChildBaseQtyZero = false;
            break;
        }
        if (allMotherBaseQtyZero || allChildBaseQtyZero) {
            throw new InvBizException(InvBizException.ALLSPLITBASEQTYZERO);
        }
        ArrayList zeroEntry = new ArrayList();
        int count2 = childInfo.getEntry().size();
        for (int i4 = 0; i4 < count2; ++i4) {
            PurInWarehsEntryInfo entry = childInfo.getEntry().get(i4);
            PurInWarehsEntryInfo soureEntry = motherInfo.getEntry().get(BOSUuid.read((String)entry.getMotherEntryID()));
            if (soureEntry != null) {
                this.calHeadTotal(motherSplitBillTotalAmount, soureEntry);
                soureEntry.setUnReturnedBaseQty(soureEntry.getBaseQty());
                soureEntry.setCanDirectReqQty(soureEntry.getQty());
                soureEntry.setCanDirectReqBaseQty(soureEntry.getBaseQty());
            }
            if (entry == null) continue;
            this.calHeadTotal(childSplitBillTotalAmount, entry);
        }
        motherInfo.setTotalQty(motherSplitBillTotalAmount.getTotalQty());
        motherInfo.setTotalAmount(motherSplitBillTotalAmount.getTTotalAmount());
        motherInfo.setTotalLocalAmount(motherSplitBillTotalAmount.getTotalLocalAmount());
        motherInfo.setTotalStandardCost(motherSplitBillTotalAmount.getTotalStandardCost());
        motherInfo.setTotalActualCost(motherSplitBillTotalAmount.getTotalActualCost());
        childInfo.setTotalQty(childSplitBillTotalAmount.getTotalQty());
        childInfo.setTotalAmount(childSplitBillTotalAmount.getTTotalAmount());
        childInfo.setTotalLocalAmount(childSplitBillTotalAmount.getTotalLocalAmount());
        childInfo.setTotalStandardCost(childSplitBillTotalAmount.getTotalStandardCost());
        childInfo.setTotalActualCost(childSplitBillTotalAmount.getTotalActualCost());
        motherInfo.setSplitNumCount(motherInfo.getSplitNumCount() + 1);
        Map<String, String> flowMap = InvServerUtils.getBillBizFlowRelation(ctx, idSet, ENTRY_TABLE_NAME);
        ISysBillFacade sysBillFacade = SysBillFacadeFactory.getLocalInstance(ctx);
        ObjectUuidPK motherPk = new ObjectUuidPK(motherInfo.getId().toString());
        ObjectUuidPK childPk = new ObjectUuidPK(childInfo.getId().toString());
        boolean flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, false);
        IObjectPK changePK = LogUtil.beginLog((Context)ctx, (String)"submitSplitBillByHand", (BOSObjectType)BOSObjectType.create((String)"783061E3"), (IObjectPK)new ObjectUuidPK(motherInfo.getId().toString()), (String)motherInfo.getNumber(), (String)"im_purInWarehs_update");
        if (motherInfo.getEntry().size() > 0) {
            this._update(ctx, (IObjectPK)new ObjectUuidPK(motherInfo.getId()), (IObjectValue)motherInfo);
        } else {
            motherInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            this._update(ctx, (IObjectPK)new ObjectUuidPK(motherInfo.getId()), (IObjectValue)motherInfo);
            try {
                this._delete(ctx, (IObjectPK)new ObjectUuidPK(motherInfo.getId()));
            }
            catch (Exception e) {
                throw new InvBizException(InvBizException.IFDOWNRE_SPLITNUM, new Object[]{motherInfo.getNumber()});
            }
        }
        int count3 = zeroEntry.size();
        for (int i5 = 0; i5 < count3; ++i5) {
            childInfo.getEntry().remove((PurInWarehsEntryInfo)zeroEntry.get(i5));
        }
        childInfo.setDischargeType(motherInfo.getDischargeType());
        childInfo.setSplitNumCount(0);
        int[] period = this.convertBizPeriod(ctx, (IObjectValue)childInfo);
        childInfo.setYear(period[0]);
        childInfo.setPeriod(period[1]);
        this._addnew(ctx, (IObjectValue)childInfo);
        if (flag) {
            this.cleanSysbillInfo(motherInfo, childInfo);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)motherPk, motherInfo, true);
            sysBillFacade.buildOrderOrReturnBill((IObjectPK)childPk, childInfo, false);
        }
        this.handleChildBillVoucher(ctx, motherInfo, childInfo);
        SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = null;
        if (flowMap != null && flowMap.size() > 0 && hasEntryRelation != null && hasEntryRelation.size() > 0) {
            String bizFlowRelation = "";
            HashMap<String, String> clildFlowMap = new HashMap<String, String>();
            int num = hasEntryRelation.size();
            for (int i6 = 0; i6 < num; ++i6) {
                aSplitBillEntryRelationInfo = (SplitBillEntryRelationInfo)hasEntryRelation.get(i6);
                if (aSplitBillEntryRelationInfo == null || StringUtils.isEmpty((String)aSplitBillEntryRelationInfo.getMotherBillEntryID()) || StringUtils.isEmpty((String)aSplitBillEntryRelationInfo.getChildBillEntryID()) || !flowMap.containsKey(aSplitBillEntryRelationInfo.getMotherBillEntryID())) continue;
                bizFlowRelation = flowMap.get(aSplitBillEntryRelationInfo.getMotherBillEntryID()) + "#" + aSplitBillEntryRelationInfo.getChildBillEntryID();
                clildFlowMap.put(aSplitBillEntryRelationInfo.getChildBillEntryID(), bizFlowRelation);
            }
            if (clildFlowMap != null && clildFlowMap.size() > 0) {
                InvServerUtils.writeBizFlowRelation(ctx, clildFlowMap, ENTRY_TABLE_NAME);
            }
        }
        hsSB.put("hsRe", hasEntryRelation);
        SplitBillRelationInfo aSplitBillRelationInfo = new SplitBillRelationInfo();
        aSplitBillRelationInfo.setMotherBillID(motherBillId);
        aSplitBillRelationInfo.setMotherBillNumber(motherInfo.getNumber());
        aSplitBillRelationInfo.setChildBillID(childInfo.getId().toString());
        aSplitBillRelationInfo.setChildBillNumber(childInfo.getNumber());
        aSplitBillRelationInfo.setStorageOrgUnit(motherInfo.getStorageOrgUnit());
        aSplitBillRelationInfo.setBillType(motherInfo.getBillType());
        aSplitBillRelationInfo.setSplitTime(new Timestamp(new Date().getTime()));
        vecSBRelation.add(aSplitBillRelationInfo);
        this.saveBotpRelation(ctx, aSplitBillRelationInfo, hsSB);
        this.saveSplitBillRelation(ctx, vecSBRelation, vecSBEntryRelation);
        childInfo.setId(motherInfo.getId());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        LogUtil.afterLog((Context)ctx, (IObjectPK)changePK);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logchildPK);
    }

    private void cleanSysbillInfo(PurInWarehsBillInfo motherInfo, PurInWarehsBillInfo childInfo) {
        int i;
        PurInWarehsEntryCollection entries = motherInfo.getEntry();
        PurInWarehsEntryInfo entryInfo = null;
        for (i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            entryInfo.setPurOrder(null);
            entryInfo.setPurOrderEntry(null);
            entryInfo.setPurOrderNumber(null);
        }
        entries = childInfo.getEntry();
        for (i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            entryInfo.setPurOrder(null);
            entryInfo.setPurOrderEntry(null);
            entryInfo.setPurOrderNumber(null);
        }
    }

    private void checkCanSplitBill(PurInWarehsBillInfo childInfo, PurInWarehsBillInfo motherInfo) throws InvBizException {
        StringBuffer errorMsg = new StringBuffer();
        for (int i = 0; i < childInfo.getEntry().size(); ++i) {
            PurInWarehsEntryInfo entry = childInfo.getEntry().get(i);
            PurInWarehsEntryInfo soureEntry = motherInfo.getEntry().get(BOSUuid.read((String)entry.getMotherEntryID()));
            if (entry.getQty().abs().compareTo(soureEntry.getUnWriteOffQty().abs()) <= 0) continue;
            errorMsg.append(i + 1 + ",");
        }
        if (errorMsg.length() > 0) {
            throw new InvBizException(InvBizException.QTY_OVER_SOURCE_UNWRITEOFFQTY, new Object[]{errorMsg.substring(0, errorMsg.length() - 1)});
        }
    }

    private void addRelationForSplitBillByHand(Vector vecSBEntryRelation, PurInWarehsEntryInfo sourceEntry, PurInWarehsEntryInfo entry, PurInWarehsBillInfo sourceBill, PurInWarehsBillInfo bill) {
        SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
        aSplitBillEntryRelationInfo.setMotherBillEntryID(sourceEntry.getId().toString());
        aSplitBillEntryRelationInfo.setChildBillEntryID(entry.getId().toString());
        aSplitBillEntryRelationInfo.setSplitQty(entry.getQty());
        vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
    }

    @Override
    protected HashMap _splitBillByHandByWrittenOffQty(Context ctx, String[] idList, HashMap param) throws BOSException, EASBizException {
        HashMap<String, StringBuffer> msgHm = new HashMap<String, StringBuffer>();
        StringBuffer notSplitMsg = new StringBuffer();
        PurInWarehsBillInfo aPurInWarehsBillInfo = this.getPurInWarehsBillInfo(ctx, (IObjectPK)new ObjectUuidPK(idList[0]), this.getSelector());
        String resource = "com.kingdee.eas.scm.im.inv.InvAddResource";
        String extendMsg = "";
        if (aPurInWarehsBillInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotAudit", (Context)ctx)).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        if (aPurInWarehsBillInfo.isIsReversed()) {
            notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ReversedCanNotSplit", (Context)ctx)).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        if (this.checkExistsNextBillBySplit(ctx, this.getDestTableName(), aPurInWarehsBillInfo.getId().toString())) {
            notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasNextBillNotAudit", (Context)ctx)).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        extendMsg = this.checkNextBillBySplitExtend(ctx, aPurInWarehsBillInfo);
        if (!StringUtil.isEmpty((String)extendMsg)) {
            notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(extendMsg).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        String writeoffVouchered = this.checkWriteoffVouchered(ctx, new String[]{aPurInWarehsBillInfo.getId().toString()});
        if (writeoffVouchered.length() > 0) {
            notSplitMsg.append("[").append(writeoffVouchered).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"writeoff_vouchered", (Context)ctx)).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        PurInWarehsEntryCollection entryColl = aPurInWarehsBillInfo.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            if (entryColl.get(i).getWrittenOffQty().compareTo(SysConstant.BIGZERO) != 0) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx)).append("[").append(i + 1).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"WrittenOffQtyOverZeroBySplitBill", (Context)ctx)).append("\t\n ");
                msgHm.put("error", notSplitMsg);
                return msgHm;
            }
            if (entryColl.get(i).getImputedCost().compareTo(SysConstant.BIGZERO) != 0) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx)).append("[").append(i + 1).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"IMPUTEDCOST_NOTEQUAL_ZERO", (Context)ctx)).append("\t\n ");
                msgHm.put("error", notSplitMsg);
                return msgHm;
            }
            if (aPurInWarehsBillInfo.getPurchaseType().getValue() == 1 && entryColl.get(i).getWrittenOffBaseQty().compareTo(entryColl.get(i).getScWrittenOffBaseQty()) < 0) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx)).append("[").append(i + 1).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"SCWRITTENQTY_OVER_WRITTENQTY", (Context)ctx)).append("\t\n ");
                msgHm.put("error", notSplitMsg);
                return msgHm;
            }
            if (entryColl.get(i).getScWrittenOffQty().compareTo(SysConstant.BIGZERO) == 0) continue;
            notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx)).append("[").append(i + 1).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ScWriteOff", (Context)ctx)).append("\t\n ");
            msgHm.put("error", notSplitMsg);
            return msgHm;
        }
        this.checkInvoiced(ctx, Arrays.asList(idList));
        return msgHm;
    }

    private boolean isHasSnBySplitBillByHand(Context ctx, PurInWarehsBillInfo purInWarehsBillInfo) throws BOSException, EASBizException {
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)purInWarehsBillInfo.getId().toString()));
        filter.setMaskString("");
        return iMaterialSerialNumber.exists(filter);
    }

    private String[][] getDestTableName() {
        String[][] tableName = new String[][]{{"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_StockTransferBill", "T_IM_StockTransferBillEntry"}, {"T_SM_PurReturns", "T_SM_PurReturnsEntry"}, {"T_IM_TransferOrderBill", "T_IM_TransferOrderBillEntry"}, {"T_AP_OtherBill", "T_AP_OtherBillEntry"}, {"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}};
        return tableName;
    }

    private boolean checkExistsNextBillBySplit(Context ctx, String[][] tableName, String id) throws BOSException {
        boolean isExists = false;
        if (tableName != null && tableName.length > 0) {
            int billCount = tableName.length;
            StringBuffer sql = new StringBuffer();
            for (int i = 0; i < billCount; ++i) {
                if (i > 0) {
                    sql.append(" union all ");
                }
                sql.append(this.getBillSql(tableName[i][0], tableName[i][1], id));
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    isExists = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isExists;
    }

    private String getBillSql(String headTable, String entryTable, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append("select entry.FID from ").append(entryTable).append(" entry \n ");
        sql.append("inner join ").append(headTable).append(" bill on bill.FID=entry.FParentID \n");
        sql.append("inner join T_IM_PurInwarehsEntry srcEntry on entry.FSourceBillEntryID = srcEntry.FID \n");
        sql.append("and srcEntry.FParentID = '").append(id).append("' and ");
        if ("T_AP_OtherBill".equals(headTable)) {
            sql.append(" ( bill.FBillStatus in (1,2) or ( bill.FBillStatus = 3 and bill.FISBIZBILL = 1 )) ");
        } else if ("T_SM_PurReturns".equals(headTable)) {
            sql.append("bill.FBaseStatus not in (3,4,6,7) ");
        } else {
            sql.append("bill.FBaseStatus in (1,2) ");
        }
        return sql.toString();
    }

    public String checkNextBillBySplitExtend(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        return "";
    }

    private String checkWriteoffVouchered(Context ctx, String[] ids) throws BOSException {
        StringBuilder id = new StringBuilder();
        id.append("(");
        for (String s : ids) {
            id.append("'").append(s).append("',");
        }
        id.setLength(id.length() - 1);
        id.append(")");
        StringBuilder result = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        sql.append("select FBILLNUMBER FROM T_IM_PURINWAREHSBILL bill INNER JOIN T_CL_WRITEOFFRECORD r on r.FBILLID = bill.FID ");
        sql.append("INNER JOIN T_CL_WRITEOFFGROUP g on g.FID = r.FPARENTID ");
        sql.append("where bill.FID in ").append((CharSequence)id).append(" and g.FFIVOUCHERED = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                result.append(rowSet.getString("FBILLNUMBER")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    private boolean isWriteOffOver(PurInWarehsBillInfo billInfo) {
        PurInWarehsEntryCollection entryCol = billInfo.getEntry();
        boolean isWriteOffOver = true;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (null == entryCol.get(i).getUnWriteOffQty() || entryCol.get(i).getUnWriteOffQty().abs().compareTo(SysConstant.BIGZERO) <= 0) continue;
            isWriteOffOver = false;
            break;
        }
        return isWriteOffOver;
    }

    @Override
    protected HashMap _checkForSplitBill(Context ctx, String[] ids, HashMap param) throws BOSException, EASBizException {
        String writeoffVouchered;
        HashMap<String, Object> msgHm = new HashMap<String, Object>(0);
        StringBuffer notSplitMsg = new StringBuffer();
        boolean isFromSaleIssue = Boolean.TRUE.equals(param.get("isFromSaleIssue"));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(this.getSelector());
        ev.getSelector().add(new SelectorItemInfo("currency.precision"));
        ev.getSelector().add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        ev.getSelector().add(new SelectorItemInfo("entry.accountViewIn"));
        ev.getSelector().add(new SelectorItemInfo("entry.accountViewOut"));
        FilterInfo filter = new FilterInfo();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        PurInWarehsBillCollection coll = this.getPurInWarehsBillCollection(ctx, ev);
        BigDecimal ZERO = SysConstant.BIGZERO;
        String resource = "com.kingdee.eas.scm.im.inv.InvAddResource";
        String msgNotAudit = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotAudit", (Context)ctx);
        String msgEntry = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx);
        String msgWrittenOffQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotWritenoff", (Context)ctx);
        String msgUnWrittenOffQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"UnWrittenOffQty", (Context)ctx);
        String msgHasNextBill = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasNextBillNotAudit", (Context)ctx);
        String msgScWrtQtyOver = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"SCWRITTENQTY_OVER_WRITTENQTY", (Context)ctx);
        String msgScWrtOff = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ScWriteOff", (Context)ctx);
        PurInWarehsBillInfo purInBillInfo = null;
        String motherBillID = "";
        String motherNumber = "";
        String extendMsg = "";
        boolean isPastPeriod = false;
        boolean isBillSplitChangeDate = false;
        StorageOrgUnitInfo sou = coll.get(0).getStorageOrgUnit();
        Date billBizDate = coll.get(0).getBizDate();
        boolean isInitBill = coll.get(0).isIsInitBill();
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, sou);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)billBizDate, (CompanyOrgUnitInfo)cou);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Date childBizdate = (Date)param.get("SplitDate");
        boolean isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        boolean billInCurPeriod = false;
        if (isClose) {
            PeriodInfo childPeriodInfo;
            if (childBizdate != null && (childPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)childBizdate, (CompanyOrgUnitInfo)cou)).getId().equals((Object)currentPeriodinfo.getId())) {
                billInCurPeriod = true;
            }
            if (billPeriodInfo.getId().equals((Object)currentPeriodinfo.getId())) {
                billInCurPeriod = true;
            }
            if (billInCurPeriod) {
                throw new SplitBillException(SplitBillException.BILLPERIODCLOSE);
            }
        }
        if (isInitBill) {
            isPastPeriod = true;
        } else if (!isInitBill && billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate())) {
            isPastPeriod = true;
        }
        if (!isPastPeriod) {
            ArrayList<String> orgIdStrList = new ArrayList<String>();
            ArrayList<String> paramNumberList = new ArrayList<String>();
            paramNumberList.add("INM101");
            for (int i = 0; i < coll.size(); ++i) {
                purInBillInfo = coll.get(i);
                if (orgIdStrList.contains(purInBillInfo.getStorageOrgUnit().getId().toString())) continue;
                orgIdStrList.add(purInBillInfo.getStorageOrgUnit().getId().toString());
            }
            ArrayList paramList = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMapBatch(paramNumberList, orgIdStrList);
            ParamSimpleInfo paramInfo = null;
            if (paramList.size() > 0) {
                paramInfo = (ParamSimpleInfo)paramList.get(0);
                isBillSplitChangeDate = Boolean.TRUE.toString().equals(paramInfo.getParamValue());
            }
        }
        if ((writeoffVouchered = this.checkWriteoffVouchered(ctx, ids)).length() > 0) {
            notSplitMsg.append("[").append(writeoffVouchered).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"writeoff_vouchered", (Context)ctx)).append("\t\n ");
            msgHm.put("NotSplitMsg", notSplitMsg.toString());
            return msgHm;
        }
        for (int i = 0; i < coll.size(); ++i) {
            PurInWarehsBillInfo aPurInWarehsBillInfo = coll.get(i);
            motherBillID = aPurInWarehsBillInfo.getId().toString();
            motherNumber = aPurInWarehsBillInfo.getNumber();
            if (param.get("WrittenOffSplit") != null && "WrittenOffSplit".equals(param.get("WrittenOffSplit").toString()) && this.isWriteOffOver(aPurInWarehsBillInfo)) continue;
            if (aPurInWarehsBillInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                notSplitMsg.append("[");
                notSplitMsg.append(motherNumber);
                notSplitMsg.append("]\t ");
                notSplitMsg.append(msgNotAudit);
                notSplitMsg.append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            if (this.checkExistsNextBillBySplit(ctx, this.getDestTableName(), aPurInWarehsBillInfo.getId().toString())) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(msgHasNextBill).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            extendMsg = this.checkNextBillBySplitExtend(ctx, aPurInWarehsBillInfo);
            if (!StringUtil.isEmpty((String)extendMsg)) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(extendMsg).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            PurInWarehsEntryCollection entryColl = aPurInWarehsBillInfo.getEntry();
            boolean isEntryWrite = false;
            boolean isEntryUnWrite = false;
            boolean isEntryPartWrite = false;
            boolean isScQtyOverWriOff = false;
            boolean isScWriOff = false;
            StringBuffer splitWriteMsg = new StringBuffer();
            for (int j = 0; j < entryColl.size(); ++j) {
                PurInWarehsEntryInfo aPurInWarehsEntryInfo = entryColl.get(j);
                if (aPurInWarehsEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgEntry);
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgWrittenOffQty);
                    splitWriteMsg.append("\t\n ");
                    isEntryUnWrite = true;
                } else if (aPurInWarehsEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgEntry);
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgUnWrittenOffQty);
                    splitWriteMsg.append("\t\n ");
                    isEntryWrite = true;
                } else {
                    isEntryPartWrite = true;
                    if (aPurInWarehsBillInfo.getPurchaseType().getValue() == 1 && aPurInWarehsEntryInfo.getWrittenOffBaseQty().compareTo(aPurInWarehsEntryInfo.getScWrittenOffBaseQty()) < 0) {
                        splitWriteMsg.append("[");
                        splitWriteMsg.append(motherNumber);
                        splitWriteMsg.append("]\t ");
                        splitWriteMsg.append(msgEntry);
                        splitWriteMsg.append("[");
                        splitWriteMsg.append(j + 1);
                        splitWriteMsg.append("]\t ");
                        splitWriteMsg.append(msgScWrtQtyOver);
                        splitWriteMsg.append("\t\n ");
                        isScQtyOverWriOff = true;
                    }
                }
                if (aPurInWarehsBillInfo.getPurchaseType().getValue() == 1 && aPurInWarehsEntryInfo.getScWrittenOffQty().compareTo(SysConstant.BIGZERO) != 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgEntry);
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgScWrtOff);
                    splitWriteMsg.append("\t\n ");
                    isScWriOff = true;
                }
                if (aPurInWarehsEntryInfo.getImputedCost().compareTo(SysConstant.BIGZERO) == 0) continue;
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx)).append("[").append(j + 1).append("]\t ").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"IMPUTEDCOST_NOTEQUAL_ZERO", (Context)ctx)).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
            }
            if (isEntryWrite && !isEntryUnWrite && !isEntryPartWrite) {
                notSplitMsg.append(splitWriteMsg);
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            if (!(!isEntryUnWrite || isEntryWrite || isEntryPartWrite || !isPastPeriod && isBillSplitChangeDate)) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"NoneWrittenOff_SplitChangeDateFalse_pastPeriod", (Locale)ctx.getLocale())).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            if (isEntryPartWrite && isScQtyOverWriOff) {
                notSplitMsg.append(splitWriteMsg);
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            if (!isScWriOff) continue;
            notSplitMsg.append(splitWriteMsg);
            msgHm.put(motherBillID, motherBillID);
        }
        if (notSplitMsg.toString() != null && notSplitMsg.toString().length() > 0) {
            msgHm.put("NotSplitMsg", notSplitMsg.toString());
        }
        if (msgHm != null && msgHm.size() > 0) {
            PurInWarehsBillCollection collection = new PurInWarehsBillCollection();
            for (int i = 0; i < coll.size(); ++i) {
                PurInWarehsBillInfo aPurInWarehsBillInfo = coll.get(i);
                if (aPurInWarehsBillInfo == null || aPurInWarehsBillInfo.getId() == null || msgHm.get(aPurInWarehsBillInfo.getId().toString()) != null && msgHm.get(aPurInWarehsBillInfo.getId().toString()).equals(aPurInWarehsBillInfo.getId().toString())) continue;
                collection.add(aPurInWarehsBillInfo);
            }
            if (collection != null && collection.size() > 0) {
                msgHm.put("collection", (Object)collection);
            }
        } else {
            msgHm.put("collection", (Object)coll);
        }
        return msgHm;
    }

    @Override
    protected HashMap _splitBillByWrittenOffQty(Context ctx, String[] idList, HashMap param) throws BOSException, EASBizException {
        HashMap<String, String> msgHm = new HashMap<String, String>(0);
        StringBuffer notSplitMsg = new StringBuffer();
        Date splitDate = null;
        boolean isFromSaleIssue = Boolean.TRUE.equals(param.get("isFromSaleIssue"));
        if (!isFromSaleIssue && param.get("SplitDate") != null) {
            splitDate = (Date)param.get("SplitDate");
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(this.getSelector());
        ev.getSelector().add(new SelectorItemInfo("currency.precision"));
        ev.getSelector().add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        FilterInfo filter = new FilterInfo();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < idList.length; ++i) {
            set.add(idList[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        PurInWarehsBillCollection coll = this.getPurInWarehsBillCollection(ctx, ev);
        BigDecimal ZERO = SysConstant.BIGZERO;
        String resource = "com.kingdee.eas.scm.im.inv.InvAddResource";
        String msgNotAudit = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotAudit", (Context)ctx);
        String msgEntry = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"Entry", (Context)ctx);
        String msgWrittenOffQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotWritenoff", (Context)ctx);
        String msgUnWrittenOffQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"UnWrittenOffQty", (Context)ctx);
        String msgHasNextBill = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasNextBillNotAudit", (Context)ctx);
        String msgScWrtQtyOver = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"SCWRITTENQTY_OVER_WRITTENQTY", (Context)ctx);
        String motherBillID = "";
        String childBillID = "";
        String motherNumber = "";
        String childNumber = "";
        String motherBillEntryID = "";
        String childBillEntryID = "";
        String extendMsg = "";
        Date now = new Date();
        int precision = 2;
        Vector<SplitBillRelationInfo> vecSBRelation = new Vector<SplitBillRelationInfo>(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryRelation = new Vector<SplitBillEntryRelationInfo>(0);
        HashMap hsSB = new HashMap(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryByOneSB = new Vector<SplitBillEntryRelationInfo>(0);
        Vector<SplitBillInventoryLog> vecInvLog = new Vector<SplitBillInventoryLog>(0);
        for (int i = 0; i < coll.size(); ++i) {
            PurInWarehsBillInfo aPurInWarehsBillInfo = coll.get(i);
            motherBillID = aPurInWarehsBillInfo.getId().toString();
            motherNumber = aPurInWarehsBillInfo.getNumber();
            SplitBillTotalAmount motherSplitBillTotalAmount = new SplitBillTotalAmount();
            SplitBillTotalAmount childSplitBillTotalAmount = new SplitBillTotalAmount();
            precision = 2;
            vecSBEntryByOneSB.clear();
            if (aPurInWarehsBillInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                notSplitMsg.append("[");
                notSplitMsg.append(motherNumber);
                notSplitMsg.append("]\t ");
                notSplitMsg.append(msgNotAudit);
                notSplitMsg.append("\t\n ");
                continue;
            }
            if (this.checkExistsNextBillBySplit(ctx, this.getDestTableName(), aPurInWarehsBillInfo.getId().toString())) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(msgHasNextBill).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            extendMsg = this.checkNextBillBySplitExtend(ctx, aPurInWarehsBillInfo);
            if (!StringUtil.isEmpty((String)extendMsg)) {
                notSplitMsg.append("[").append(aPurInWarehsBillInfo.getNumber()).append("]\t ").append(extendMsg).append("\t\n ");
                msgHm.put(motherBillID, motherBillID);
                continue;
            }
            PurInWarehsBillInfo aSplitBillInfo = (PurInWarehsBillInfo)aPurInWarehsBillInfo.clone();
            aSplitBillInfo.setId(BOSUuid.create((BOSObjectType)aSplitBillInfo.getBOSType()));
            childBillID = aSplitBillInfo.getId().toString();
            childNumber = this.getChildNumber(ctx, aPurInWarehsBillInfo.getNumber(), 0);
            aSplitBillInfo.setNumber(childNumber);
            if (splitDate != null) {
                aSplitBillInfo.setBizDate(splitDate);
                int[] period = this.convertBizPeriod(ctx, (IObjectValue)aSplitBillInfo);
                aSplitBillInfo.setYear(period[0]);
                aSplitBillInfo.setPeriod(period[1]);
            }
            aSplitBillInfo.getEntry().clear();
            if (aPurInWarehsBillInfo.getCurrency() != null) {
                precision = aPurInWarehsBillInfo.getCurrency().getPrecision();
            }
            PurInWarehsEntryCollection entryColl = aPurInWarehsBillInfo.getEntry();
            boolean isEntryWrite = false;
            boolean isEntryUnWrite = false;
            boolean isEntryPartWrite = false;
            boolean isScQtyOverWriOff = false;
            StringBuffer splitWriteMsg = new StringBuffer();
            for (int j = 0; j < entryColl.size(); ++j) {
                PurInWarehsEntryInfo aPurInWarehsEntryInfo = entryColl.get(j);
                motherBillEntryID = aPurInWarehsEntryInfo.getId().toString();
                if (aPurInWarehsEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgEntry);
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgWrittenOffQty);
                    splitWriteMsg.append("\t\n ");
                    isEntryUnWrite = true;
                    continue;
                }
                if (aPurInWarehsEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgEntry);
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(msgUnWrittenOffQty);
                    splitWriteMsg.append("\t\n ");
                    isEntryWrite = true;
                    continue;
                }
                isEntryPartWrite = true;
                if (aPurInWarehsBillInfo.getPurchaseType().getValue() != 1 || aPurInWarehsEntryInfo.getWrittenOffBaseQty().compareTo(aPurInWarehsEntryInfo.getScWrittenOffBaseQty()) >= 0) continue;
                splitWriteMsg.append("[");
                splitWriteMsg.append(motherNumber);
                splitWriteMsg.append("]\t ");
                splitWriteMsg.append(msgEntry);
                splitWriteMsg.append("[");
                splitWriteMsg.append(j + 1);
                splitWriteMsg.append("]\t ");
                splitWriteMsg.append(msgScWrtQtyOver);
                splitWriteMsg.append("\t\n ");
                isScQtyOverWriOff = true;
            }
            if (isEntryWrite && !isEntryUnWrite && !isEntryPartWrite || !isFromSaleIssue && isEntryUnWrite && !isEntryWrite && !isEntryPartWrite) {
                notSplitMsg.append(splitWriteMsg);
                continue;
            }
            if (isEntryUnWrite && !isEntryWrite && !isEntryPartWrite) {
                if (!isFromSaleIssue) continue;
                aPurInWarehsBillInfo.setNumber(aPurInWarehsBillInfo.getNumber() + "_A");
                ObjectUuidPK pk = new ObjectUuidPK(aPurInWarehsBillInfo.getId());
                this._update(ctx, (IObjectPK)pk, (IObjectValue)aPurInWarehsBillInfo);
                continue;
            }
            if (isEntryPartWrite && isScQtyOverWriOff) {
                notSplitMsg.append(splitWriteMsg);
                continue;
            }
            Vector<PurInWarehsEntryInfo> vMatherBillEntry = new Vector<PurInWarehsEntryInfo>(0);
            for (int j = 0; j < entryColl.size(); ++j) {
                PurInWarehsEntryInfo aClildEntryInfo;
                PurInWarehsEntryInfo aPurInWarehsEntryInfo = entryColl.get(j);
                motherBillEntryID = aPurInWarehsEntryInfo.getId().toString();
                if (aPurInWarehsEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    aClildEntryInfo = (PurInWarehsEntryInfo)aPurInWarehsEntryInfo.clone();
                    aClildEntryInfo.setId(BOSUuid.create((BOSObjectType)aClildEntryInfo.getBOSType()));
                    this.calHeadTotal(childSplitBillTotalAmount, aClildEntryInfo);
                    aSplitBillInfo.getEntry().add(aClildEntryInfo);
                    continue;
                }
                if (aPurInWarehsEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    this.calHeadTotal(motherSplitBillTotalAmount, aPurInWarehsEntryInfo);
                    vMatherBillEntry.add(aPurInWarehsEntryInfo);
                    continue;
                }
                vMatherBillEntry.add(aPurInWarehsEntryInfo);
                aClildEntryInfo = (PurInWarehsEntryInfo)aPurInWarehsEntryInfo.clone();
                aClildEntryInfo.setId(BOSUuid.create((BOSObjectType)aClildEntryInfo.getBOSType()));
                childBillEntryID = aClildEntryInfo.getId().toString();
                this.doSplitBillEntry(aPurInWarehsEntryInfo, aClildEntryInfo, aPurInWarehsBillInfo, precision, ctx);
                SplitBillInventoryLog aSplitBillInventoryLog = new SplitBillInventoryLog();
                aSplitBillInventoryLog.setEntryID(motherBillEntryID);
                aSplitBillInventoryLog.setChildEntryID(childBillEntryID);
                aSplitBillInventoryLog.setChildBillID(childBillID);
                aSplitBillInventoryLog.setChildBillNumber(childNumber);
                aSplitBillInventoryLog.setMotherQty(aPurInWarehsEntryInfo.getQty());
                aSplitBillInventoryLog.setMotherBaseQty(aPurInWarehsEntryInfo.getBaseQty());
                aSplitBillInventoryLog.setMotherStandardCost(aPurInWarehsEntryInfo.getStandardCost());
                aSplitBillInventoryLog.setMotherActualCost(aPurInWarehsEntryInfo.getActualCost());
                aSplitBillInventoryLog.setChildQty(aClildEntryInfo.getQty());
                aSplitBillInventoryLog.setChildBaseQty(aClildEntryInfo.getBaseQty());
                aSplitBillInventoryLog.setChildStandardCost(aClildEntryInfo.getStandardCost());
                aSplitBillInventoryLog.setChildActualCost(aClildEntryInfo.getActualCost());
                aSplitBillInventoryLog.setYear(aSplitBillInfo.getYear());
                aSplitBillInventoryLog.setPeriod(aSplitBillInfo.getPeriod());
                aSplitBillInventoryLog.setChildBizDate(aSplitBillInfo.getBizDate());
                vecInvLog.add(aSplitBillInventoryLog);
                this.calHeadTotal(motherSplitBillTotalAmount, aPurInWarehsEntryInfo);
                this.calHeadTotal(childSplitBillTotalAmount, aClildEntryInfo);
                aSplitBillInfo.getEntry().add(aClildEntryInfo);
                SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
                aSplitBillEntryRelationInfo.setMotherBillEntryID(motherBillEntryID);
                aSplitBillEntryRelationInfo.setChildBillEntryID(childBillEntryID);
                aSplitBillEntryRelationInfo.setSplitQty(aClildEntryInfo.getQty());
                vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
                vecSBEntryByOneSB.add(aSplitBillEntryRelationInfo);
            }
            aPurInWarehsBillInfo.getEntry().clear();
            for (int m = 0; m < vMatherBillEntry.size(); ++m) {
                aPurInWarehsBillInfo.getEntry().add((PurInWarehsEntryInfo)vMatherBillEntry.get(m));
            }
            aPurInWarehsBillInfo.setTotalQty(motherSplitBillTotalAmount.getTotalQty());
            aPurInWarehsBillInfo.setTotalAmount(motherSplitBillTotalAmount.getTTotalAmount());
            aPurInWarehsBillInfo.setTotalLocalAmount(motherSplitBillTotalAmount.getTotalLocalAmount());
            aPurInWarehsBillInfo.setTotalStandardCost(motherSplitBillTotalAmount.getTotalStandardCost());
            aPurInWarehsBillInfo.setTotalActualCost(motherSplitBillTotalAmount.getTotalActualCost());
            aSplitBillInfo.setTotalQty(childSplitBillTotalAmount.getTotalQty());
            aSplitBillInfo.setTotalAmount(childSplitBillTotalAmount.getTTotalAmount());
            aSplitBillInfo.setTotalLocalAmount(childSplitBillTotalAmount.getTotalLocalAmount());
            aSplitBillInfo.setTotalStandardCost(childSplitBillTotalAmount.getTotalStandardCost());
            aSplitBillInfo.setTotalActualCost(childSplitBillTotalAmount.getTotalActualCost());
            ObjectUuidPK pk = new ObjectUuidPK(aPurInWarehsBillInfo.getId());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)aPurInWarehsBillInfo);
            this._addnew(ctx, (IObjectValue)aSplitBillInfo);
            msgHm.put("vritualPurInWarehsId", aSplitBillInfo.getId().toString());
            SplitBillRelationInfo aSplitBillRelationInfo = new SplitBillRelationInfo();
            aSplitBillRelationInfo.setMotherBillID(motherBillID);
            aSplitBillRelationInfo.setMotherBillNumber(motherNumber);
            aSplitBillRelationInfo.setChildBillID(childBillID);
            aSplitBillRelationInfo.setChildBillNumber(childNumber);
            aSplitBillRelationInfo.setStorageOrgUnit(aPurInWarehsBillInfo.getStorageOrgUnit());
            aSplitBillRelationInfo.setBillType(aPurInWarehsBillInfo.getBillType());
            aSplitBillRelationInfo.setSplitTime(new Timestamp(now.getTime()));
            vecSBRelation.add(aSplitBillRelationInfo);
            hsSB.put(motherBillID, vecSBEntryByOneSB);
        }
        String relationId = this.saveBotpRelation(ctx, vecSBRelation, hsSB);
        msgHm.put("vritualPurInWarehsRelationId", relationId);
        this.saveSplitBillRelation(ctx, vecSBRelation, vecSBEntryRelation);
        if (notSplitMsg.toString() != null && notSplitMsg.toString().length() > 0) {
            msgHm.put("NotSplitMsg", notSplitMsg.toString());
        }
        return msgHm;
    }

    protected void checkMoveAveMatForSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        if (info.getPurchaseType() != null && info.getPurchaseType().getValue() == 1) {
            ArrayList<String> matNumList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct mi.FNumber ");
            sb.append(" from T_IM_PurInWarehsEntry entry ");
            sb.append(" left join T_IM_PurInWarehsBill bill on entry.FParentID = bill.FID ");
            sb.append(" left join T_BD_MaterialCompanyInfo mc on entry.FMaterialID = mc.FMaterialID ");
            sb.append(" inner join T_BD_Material mi on entry.FMaterialID = mi.FID ");
            sb.append(" where bill.FID = '").append(pk.toString()).append("'");
            sb.append(" and mi.FIsOutsourcedPart = 1 ");
            sb.append(" and mc.FAccountType = ").append(1);
            sb.append(" and mc.FCompanyID in ");
            sb.append(" (select top 1 FToUnitID from T_ORG_UnitRelation ur ");
            sb.append(" inner join T_ORG_TypeRelation tr on ur.FTypeRelationID = tr.FID ");
            sb.append(" where FFromUnitID = (select FStorageOrgUnitID from T_IM_PurInWarehsBill where FID ='").append(pk.toString()).append("') ");
            sb.append(" and tr.FFromType = ").append(4);
            sb.append(" and tr.FToType = ").append(1).append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    matNumList.add(rs.getString("FNumber"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sb.setLength(0);
            sb.append("\n");
            int count = matNumList.size();
            for (int i = 0; i < count; ++i) {
                sb.append(matNumList.get(i)).append("\r\n");
            }
            if (count > 0) {
                throw new SCMBillException(SCMBillException.CANNOT_BE_MOVEAGEMAT_IN_SUBCONSTRACT, new Object[]{sb.toString()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _writeBackSettlementPrice(Context ctx, Map priceMap) throws BOSException {
        String tempTable = null;
        try {
            tempTable = this.createTempTable4Settlement(ctx, this.getIdsFromKeyOfMap(priceMap));
            Map[] checkedMap = this.checkBeforeWriteBack(ctx, tempTable);
            Map exceptionMap = checkedMap[0];
            Map excludePrEntryIdMap = checkedMap[1];
            if (excludePrEntryIdMap.size() != priceMap.size()) {
                Iterator iter = excludePrEntryIdMap.keySet().iterator();
                while (iter.hasNext()) {
                    priceMap.remove(iter.next().toString());
                }
                this.doWriteBackPrice(ctx, tempTable, priceMap);
            }
            Map map = exceptionMap;
            return map;
        }
        finally {
            if (tempTable != null) {
                KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
            }
        }
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        PurInWarehsEntryCollection purEntry;
        PurInWarehsBillInfo purBill;
        super.checkUnPassAduit(ctx, aInvBillBaseInfo);
        try {
            purBill = (PurInWarehsBillInfo)aInvBillBaseInfo;
            purEntry = purBill.getEntry();
            String sql = "";
            StringBuffer message = new StringBuffer();
            boolean check = false;
            for (int i = 0; i < purEntry.size(); ++i) {
                String entryId = purEntry.get(i).getId().toString();
                sql = "select  FId from T_CL_ExpenseApportionEntry where Fsourceentryid='" + entryId + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rs.next()) continue;
                message.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"The", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"Row", (Locale)ctx.getLocale()));
                check = true;
            }
            if (check) {
                throw new InvBizException(InvBizException.CHECK_PURCHASE_UNAUDIT, new Object[]{message});
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        purBill = (PurInWarehsBillInfo)aInvBillBaseInfo;
        purEntry = purBill.getEntry();
        StringBuffer message = new StringBuffer();
        boolean check = false;
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)purBill.getPurchaseType())) {
            for (int i = 0; i < purEntry.size(); ++i) {
                BigDecimal scQty = purEntry.get(i).getScWrittenOffBaseQty();
                if (DosingTypeEnum.NONE.equals((Object)purEntry.get(i).getDosingType()) || scQty == null || scQty.compareTo(SysConstant.BIGZERO) <= 0) continue;
                message.append(ResourceBase.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"The", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.scm.im.SCM_IMResource", (String)"Row", (Locale)ctx.getLocale()));
                check = true;
            }
        }
        if (check) {
            throw new InvBizException(InvBizException.CHECK_SUBWRITTENOFF_UNAUDIT, new Object[]{message});
        }
    }

    protected List getAddedSelector() {
        ArrayList<SelectorItemInfo> selList = new ArrayList<SelectorItemInfo>();
        selList.add(new SelectorItemInfo("*"));
        selList.add(new SelectorItemInfo("transactionType.*"));
        selList.add(new SelectorItemInfo("entry.*"));
        selList.add(new SelectorItemInfo("entry.material.*"));
        selList.add(new SelectorItemInfo("entry.warehouse.*"));
        return selList;
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-015fc0a812fd463ED552";
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.initBotpData(ctx, model);
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        this.checkBotp(info);
        this._fillLotFrame(ctx, model);
        this.setTransType4RetTransferOrder(ctx, info);
        new PurInAlgorithmForInfo(info, ctx).revalue();
        this.dealPurChaseFee(ctx, info);
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = info.getEntry().get(0).getCompanyOrgUnit();
        if (company != null) {
            String dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_001");
            if (dischargeType.equals("1") && info.isIsInitBill()) {
                dischargeType = "2";
            }
            int temp = 1;
            try {
                temp = Integer.parseInt(dischargeType);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            info.setDischargeType(DischargeTypeEnum.getEnum(temp));
        }
    }

    private void doBillCostCenter(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        String companyOrgUnitID = null;
        if (info.getCostCenterOrgUnit() == null && info.getAdminOrgUnit() != null) {
            CostCenterOrgUnitInfo costCenter = SCMUtils.getCostCenterByAdminOrgInfo((Context)ctx, (String)info.getAdminOrgUnit().getId().toString());
            info.setCostCenterOrgUnit(costCenter);
        }
        if (info.getEntry().get(0).getCompanyOrgUnit() != null && info.getEntry().get(0).getCompanyOrgUnit().getId() != null) {
            companyOrgUnitID = info.getEntry().get(0).getCompanyOrgUnit().getId().toString();
        }
        this.isRemoveCostCenter(ctx, info, companyOrgUnitID);
    }

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected boolean isCheckMatCompanyInfo() {
        return true;
    }

    @Override
    protected boolean isCheckSourceBill() {
        return true;
    }

    protected void sendCenterMessage(Context ctx, String salerID, String messageString) throws EASBizException, BOSException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = PurInWarehsBillControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"PurInwarehsBillMessage", (Locale)locale2), locale2);
            message.setLocaleStringHeader("sender", "", locale2);
            StringBuffer messageContent = new StringBuffer();
            messageContent.append(SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"PurInwarehsBillMessage", (Locale)locale2) + "\n");
            String[] messageList = messageString.split(",");
            int size = messageList.length;
            for (int index = 0; index < size; ++index) {
                String[] contextList = messageList[index].split("@");
                if (contextList.length < 2) continue;
                messageContent.append(contextList[0] + SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"PurInwarehsMessageContext", (Locale)locale2) + contextList[1] + "\n");
            }
            message.setLocaleStringHeader("body", messageContent.toString(), locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", salerID);
        senderAgent.sendMessage(message);
    }

    protected void sendMessage(Context ctx, String salerID, String messageString) throws EASBizException, BOSException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = PurInWarehsBillControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SaleOrderForPurToSale", (Locale)locale2), locale2);
            message.setLocaleStringHeader("sender", "", locale2);
            StringBuffer messageContent = new StringBuffer();
            messageContent.append(SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SaleOrderForPurToSale", (Locale)locale2) + "\n");
            String[] orderNumList = messageString.split(",");
            int size = orderNumList.length;
            for (int index = 0; index < size; ++index) {
                messageContent.append(SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SaleOrderForPurAccrodingSale", (Locale)locale2) + orderNumList[index] + SCMUtils.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SaleOrderHaveReceived", (Locale)locale2) + "\n");
            }
            message.setLocaleStringHeader("body", messageContent.toString(), locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", salerID);
        senderAgent.sendMessage(message);
    }

    protected void sendMessageToSales(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        boolean hasMsg = false;
        if (pk == null) {
            return;
        }
        ArrayList userList = new ArrayList();
        ArrayList messageList = new ArrayList();
        hasMsg = this.sendMessageToSales(ctx, pk, userList, messageList);
        if (hasMsg && userList.size() != 0 && userList.size() == messageList.size()) {
            int count = userList.size();
            for (int index = 0; index < count; ++index) {
                String personString = (String)userList.get(index);
                StringBuffer messageString = (StringBuffer)messageList.get(index);
                this.sendMessage(ctx, personString, messageString.toString());
            }
        }
    }

    protected void sendMessageWhenCentrePurAndSale(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        boolean hasMsg = false;
        if (pk == null) {
            return;
        }
        ArrayList userList = new ArrayList();
        ArrayList messageList = new ArrayList();
        hasMsg = this.getMessageContext(ctx, pk, userList, messageList);
        if (hasMsg && userList.size() != 0 && userList.size() == userList.size()) {
            int count = userList.size();
            for (int index = 0; index < count; ++index) {
                String personString = (String)userList.get(index);
                StringBuffer messageString = (StringBuffer)messageList.get(index);
                this.sendCenterMessage(ctx, personString, messageString.toString());
            }
        }
    }

    private void calHeadTotal(SplitBillTotalAmount splitBillTotalAmount, PurInWarehsEntryInfo aPurInWarehsEntryInfo) {
        if (aPurInWarehsEntryInfo.getQty() != null) {
            splitBillTotalAmount.setTotalQty(splitBillTotalAmount.getTotalQty().add(aPurInWarehsEntryInfo.getQty()));
        }
        if (aPurInWarehsEntryInfo.getAmount() != null) {
            splitBillTotalAmount.setTTotalAmount(splitBillTotalAmount.getTTotalAmount().add(aPurInWarehsEntryInfo.getAmount()));
        }
        if (aPurInWarehsEntryInfo.getLocalAmount() != null) {
            splitBillTotalAmount.setTotalLocalAmount(splitBillTotalAmount.getTotalLocalAmount().add(aPurInWarehsEntryInfo.getLocalAmount()));
        }
        if (aPurInWarehsEntryInfo.getStandardCost() != null) {
            splitBillTotalAmount.setTotalStandardCost(splitBillTotalAmount.getTotalStandardCost().add(aPurInWarehsEntryInfo.getStandardCost()));
        }
        if (aPurInWarehsEntryInfo.getActualCost() != null) {
            splitBillTotalAmount.setTotalActualCost(splitBillTotalAmount.getTotalActualCost().add(aPurInWarehsEntryInfo.getActualCost()));
        }
    }

    private Map[] checkBeforeWriteBack(Context ctx, String tmpTableName) throws BOSException {
        Map[] mapArray;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT DISTINCT fsrcentryid,fnumber,fentryid,fseq,ftype FROM (");
        sql.append("\t\t  SELECT fsourcebillentryid as Fsrcentryid,fnumber,fentryid,-1 as fseq,0 AS ftype");
        sql.append("          FROM   t_tmp_purinwarehsbill where fid is null ");
        sql.append("          UNION ALL");
        sql.append("\t\t  SELECT fsourcebillentryid as Fsrcentryid,fnumber,fentryid, - 1 AS fseq,1 AS ftype");
        sql.append("          FROM t_tmp_purinwarehsbill WHERE  ffivouchered = 1");
        sql.append("          UNION ALL");
        sql.append("          SELECT  tmp.fsourcebillentryid as Fsrcentryid,tmp.fnumber as fnumber,tmp.fentryid as fentryid,- 1 AS fseq,2 AS ftype");
        sql.append("          FROM   t_tmp_purinwarehsbill tmp");
        sql.append("                 LEFT JOIN t_bd_systemstatusctrol ssc ON ssc.fcompanyid = tmp.fcompanyorgunitid");
        sql.append("                 LEFT JOIN t_bd_systemstatus ss ON ss.fid = ssc.fsystemstatusid");
        sql.append("                 LEFT JOIN t_bd_period period  ON period.fid = ssc.fcurrentperiodid");
        sql.append("          WHERE  ss.fname = ").append(2);
        sql.append(" \t\t\t\tAND period.fbegindate > tmp.fbizdate");
        sql.append("          UNION ALL");
        sql.append("          SELECT fsourcebillentryid as Fsrcentryid,fnumber,fentryid,fseq,3 AS ftype");
        sql.append("          FROM   t_tmp_purinwarehsbill WHERE fwrittenoffqty <> 0");
        sql.append("          UNION ALL");
        sql.append("          SELECT tmp.fsourcebillentryid as Fsrcentryid,tmp.fnumber as fnumber,tmp.fentryid as fentryid,tmp.fseq as fseq,4 AS ftype");
        sql.append("          FROM   t_tmp_purinwarehsbill tmp");
        sql.append("\t\t  LEFT JOIN t_bd_materialcompanyinfo mc ON mc.fcompanyid = tmp.fcompanyorgunitid ");
        sql.append("\t\t\t\tAND mc.fmaterialid = tmp.fmaterialid");
        sql.append("          WHERE  mc.faccounttype = ").append(1).append(") ttmp ");
        sql.append("ORDER BY ftype asc;");
        IRowSet rs = null;
        NumericExceptionSubItem[] items = new NumericExceptionSubItem[]{InvBizException.PURREC_HAS_NOT_GEN_PURIN, InvBizException.BILL_HAS_VOUCHERED, InvBizException.BILL_BIZDATE_BEFORE_BEGINDATA, InvBizException.BILLENTRY_HAS_WRITTENOFF, InvBizException.MATERIAL_IS_MOVE_ADD_AVERAGE_VALUE};
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString().replaceAll("t_tmp_purinwarehsbill", tmpTableName));
            HashMap<String, String> resultMap = new HashMap<String, String>();
            HashMap<String, String> excludePrEntryIdMap = new HashMap<String, String>();
            while (rs.next()) {
                String fsrcentryid = rs.getString("fsrcentryid");
                int fType = rs.getInt("ftype");
                excludePrEntryIdMap.put(fsrcentryid, fsrcentryid);
                if (resultMap.containsKey(fsrcentryid)) continue;
                if (fType == 0) {
                    resultMap.put(fsrcentryid, new InvBizException(items[fType]).getLocalizedMessage());
                    continue;
                }
                if (fType == 1 || fType == 2) {
                    resultMap.put(fsrcentryid, new InvBizException(items[fType], new String[]{rs.getString("fnumber")}).getLocalizedMessage());
                    continue;
                }
                resultMap.put(fsrcentryid, new InvBizException(items[fType], new String[]{rs.getString("fnumber"), String.valueOf(rs.getInt("fseq"))}).getMessage(ctx.getLocale()));
            }
            mapArray = new Map[]{resultMap, excludePrEntryIdMap};
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(rs, null, null);
                throw throwable;
            }
        }
        DBUtils.cleanup((ResultSet)rs, null, null);
        return mapArray;
    }

    private String createTempTable4Settlement(Context ctx, String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE t_tmp_purinwarehsbill (");
        sql.append("fid                VARCHAR(44),");
        sql.append("fnumber            VARCHAR(80),");
        sql.append("fbizdate           TIMESTAMP,");
        sql.append("ffivouchered       INT,");
        sql.append("fcompanyorgunitid  VARCHAR(80),");
        sql.append("fentryid           VARCHAR(44),");
        sql.append("fseq               INT,");
        sql.append("fmaterialid        VARCHAR(44),");
        sql.append("FCurrencyId varchar(44),");
        sql.append("fwrittenoffqty     NUMERIC(21,8),");
        sql.append("fsourcebillid      VARCHAR(44),");
        sql.append("fsourcebillentryid VARCHAR(44),");
        sql.append("FConvertMode int not null default 0,");
        sql.append("FIsPriceInTax int not null default 0,");
        sql.append("FTaxPrice       Numeric(21,8) not null default 0,");
        sql.append("FExchangeRate   Numeric(21,8) not null default 0");
        sql.append(");");
        String tempTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO ").append(tempTable).append(" (");
        sql.append("fid,");
        sql.append("fnumber,");
        sql.append("fconvertmode,");
        sql.append("fispriceintax,");
        sql.append("fentryid,");
        sql.append("fseq,");
        sql.append("fsourcebillid,");
        sql.append("fsourcebillentryid,");
        sql.append("fbizdate,");
        sql.append("ffivouchered,");
        sql.append("fcompanyorgunitid,");
        sql.append("fmaterialid,");
        sql.append("fwrittenoffqty,");
        sql.append("fcurrencyid,");
        sql.append("fexchangerate)");
        sql.append("SELECT piw.fid,");
        sql.append("piw.fnumber,");
        sql.append("isnull(piw.fconvertmode,0),");
        sql.append("isnull(piw.fispriceintax,0),");
        sql.append("piwe.fid,");
        sql.append("piwe.fseq,");
        sql.append("piwe.fsourcebillid,");
        sql.append("pre.fid,");
        sql.append("piw.fbizdate,");
        sql.append("piw.ffivouchered,");
        sql.append("piwe.fcompanyorgunitid,");
        sql.append("piwe.fmaterialid,");
        sql.append("piwe.fwrittenoffqty,");
        sql.append("piw.fcurrencyid,");
        sql.append("isnull(piw.FExchangeRate,0) ");
        sql.append("FROM t_im_purreceivalentry pre ");
        sql.append("LEFT JOIN t_im_purinwarehsentry piwe ON piwe.fsourcebillentryid = pre.fid ");
        sql.append("LEFT JOIN t_im_purinwarehsbill piw ON piwe.fparentid = piw.fid ");
        sql.append("WHERE pre.fid IN (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return tempTable;
    }

    private void doWriteBackPrice(Context ctx, String tmpTableName, Map priceMap) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tmpTableName).append(" set FTaxPrice = ? where FSourceBillEntryId = ? ");
        Iterator iter = priceMap.keySet().iterator();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        while (iter.hasNext()) {
            String purEntryId = (String)iter.next();
            paramList.add(new Object[]{priceMap.get(purEntryId), purEntryId});
        }
        String preIds = this.getIdsFromKeyOfMap(priceMap);
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
        sql.setLength(0);
        sql.append("update T_IM_PurInWarehsEntry set  ");
        sql.append("(FDiscountRate,FDiscountAmount,FTaxPrice,FPrice,FTaxAmount,FLocalTaxAmount,FTax,");
        sql.append("FLocalTax,FAmount,FActualTaxPrice,FActualPrice,FPurchaseCost,");
        sql.append("FUnitPurchaseCost,FActualCost,FUnitActualCost,FUnWriteOffAmount) =  ");
        sql.append("(select 0,0,tmp.FTaxPrice,");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append("then round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) ");
        sql.append("else round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) end,");
        sql.append("round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision),");
        sql.append("case tmp.FConvertMode when 0 ");
        sql.append("then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * tmp.FExchangeRate,base.FPrecision) ");
        sql.append("else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / tmp.FExchangeRate,base.FPrecision) end,");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(decimal(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),21,8) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision) end,");
        sql.append("case tmp.FConvertMode when 0 ");
        sql.append(" then case tmp.FIsPriceInTax when 1 then round(round(decimal(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),21,8) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision) * tmp.FExchangeRate,base.FPrecision) ");
        sql.append("  else round( round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision)* tmp.FExchangeRate,base.FPrecision) end  ");
        sql.append(" else case tmp.FIsPriceInTax when 1 then round(round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision) / tmp.FExchangeRate,base.FPrecision) ");
        sql.append("  else round( round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8),cur.FPrecision)* tmp.FExchangeRate,base.FPrecision) end  ");
        sql.append(" end,");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) end,");
        sql.append("tmp.FTaxPrice,");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append("then round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) ");
        sql.append("else round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) end,");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) end,");
        sql.append("CASE t_im_purinwarehsentry.fqty WHEN 0 THEN 0 ELSE case tmp.FConvertMode when 1 ");
        sql.append("then case tmp.FIsPriceInTax when 1 ");
        sql.append("  then round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) ");
        sql.append("  else round(tmp.FTaxPrice / (1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),mat.FPricePrecision) end  ");
        sql.append("else case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(decimal(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),21,8) / T_IM_PurInWarehsEntry.FQty,mat.FPricePrecision) ");
        sql.append(" else round(decimal(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),21,8) / T_IM_PurInWarehsEntry.FQty,mat.FPricePrecision) end ");
        sql.append("end END,");
        sql.append("T_IM_PurInWarehsEntry.FPurchaseFee + T_IM_PurInWarehsEntry.FMaterialCost + ");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) end,");
        sql.append("CASE t_im_purinwarehsentry.fqty WHEN 0 THEN 0 ELSE round((T_IM_PurInWarehsEntry.FPurchaseFee + T_IM_PurInWarehsEntry.FMaterialCost + ");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) end");
        sql.append(")/ T_IM_PurInWarehsEntry.FQty,mat.FPricePrecision) END, ");
        sql.append("case tmp.FIsPriceInTax when 1 ");
        sql.append(" then round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) / ( 1 + decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) ");
        sql.append(" else round(round(tmp.FTaxPrice * T_IM_PurInWarehsEntry.FQty,cur.FPrecision) * (1 - decimal(T_IM_PurInWarehsEntry.FTaxRate / 100,21,8)),cur.FPrecision) end ");
        sql.append("from ").append(tmpTableName).append(" tmp  ");
        sql.append("left join t_bd_material mat on tmp.fmaterialid = mat.fid ");
        sql.append("left join t_bd_currency cur on cur.fid = tmp.fcurrencyid ");
        sql.append("left join T_Org_Company cou on cou.fid = tmp.fcompanyorgunitid ");
        sql.append("left join t_bd_currency base on base.fid = cou.fbasecurrencyid ");
        sql.append("where tmp.FentryId = T_IM_PurInWarehsEntry.fid) ");
        sql.append(" where exists(select fid from ").append(tmpTableName);
        sql.append(" where fentryid = T_IM_PurInWarehsEntry.fid and fsourcebillentryid in(");
        sql.append(preIds).append("))");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getIdsFromKeyOfMap(Map map) {
        Iterator iter = map.keySet().iterator();
        StringBuffer ids = new StringBuffer();
        while (iter.hasNext()) {
            ids.append("'").append(iter.next()).append("',");
        }
        ids.append("' '");
        return ids.toString();
    }

    private boolean getMessageContext(Context ctx, IObjectPK pk, List userList, List messageList) throws EASBizException, BOSException {
        String sqlString = this.getMessageToPurchsSql(pk.toString());
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlString);
            String purOrderNumber = null;
            String creatorID = null;
            String purchID = null;
            String reqOrgNumber = null;
            String reqOrgName = null;
            String nameString = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
            String messageStr = null;
            int index = -1;
            StringBuffer messageBuff = null;
            while (rs.next()) {
                StringBuffer newBuffer;
                purOrderNumber = rs.getString("purOrderNum");
                if (rs.getString("creatorID") != null && !rs.getString("creatorID").equals("")) {
                    creatorID = rs.getString("creatorID");
                }
                if (rs.getString("purPersonID") != null && !rs.getString("purPersonID").equals("")) {
                    purchID = rs.getString("purPersonID");
                }
                reqOrgNumber = rs.getString("orgNum");
                reqOrgName = rs.getString(nameString);
                messageStr = purOrderNumber + "@" + reqOrgNumber + "(" + reqOrgName + ")";
                if (creatorID != null && !creatorID.equals("")) {
                    index = userList.indexOf(creatorID);
                    if (index != -1) {
                        messageBuff = (StringBuffer)messageList.get(index);
                        if (messageBuff.indexOf(messageStr) == -1) {
                            messageBuff.append(messageStr + ",");
                        }
                    } else {
                        userList.add(creatorID);
                        newBuffer = new StringBuffer();
                        newBuffer.append(messageStr + ",");
                        messageList.add(newBuffer);
                    }
                }
                if (purchID == null || purchID.equals("")) continue;
                index = userList.indexOf(purchID);
                if (index != -1) {
                    messageBuff = (StringBuffer)messageList.get(index);
                    if (messageBuff.indexOf(messageStr) != -1) continue;
                    messageBuff.append(messageStr + ",");
                    continue;
                }
                userList.add(purchID);
                newBuffer = new StringBuffer();
                newBuffer.append(messageStr + ",");
                messageList.add(newBuffer);
            }
            return userList.size() > 0;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private String getMessageToPurchsSql(String purinwarhsBillID) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select purOrder.FNumber AS purOrderNum, ");
        sqlBuffer.append("storageOrgUnit.FNumber AS orgNum, ");
        sqlBuffer.append("storageOrgUnit.FName_L1 AS L1,  ");
        sqlBuffer.append("storageOrgUnit.FName_L2 AS L2, ");
        sqlBuffer.append("storageOrgUnit.FName_L3 AS L3, ");
        sqlBuffer.append("purOrder.FCreatorID AS creatorID, ");
        sqlBuffer.append("userTablePurPerson.FID AS PurPersonID ");
        sqlBuffer.append("from T_IM_PurInWarehsBill purInWarehsBill ");
        sqlBuffer.append("left outer join t_im_purinwarehsentry  purInEntry ");
        sqlBuffer.append("on purInWarehsBill.fid = purInEntry.fparentid ");
        sqlBuffer.append("inner join t_sm_purorder purOrder ");
        sqlBuffer.append("on purInEntry.FPurOrderID = purOrder.fid ");
        sqlBuffer.append("inner join t_sm_purorderentry purOrderEntry ");
        sqlBuffer.append("on purInEntry.FPurOrderEntryID = purOrderEntry.fid ");
        sqlBuffer.append("inner join T_ORG_Storage storageOrgUnit ");
        sqlBuffer.append("on purOrderEntry.FRequestOrgUnitID = storageOrgUnit.fid ");
        sqlBuffer.append("left outer join t_pm_user userTablePurPerson ");
        sqlBuffer.append("on purOrder.FPurchasePersonID = userTablePurPerson.FPersonId ");
        sqlBuffer.append("where purOrderEntry.FStorageOrgUnitID <> purOrderEntry.FRequestOrgUnitID ");
        sqlBuffer.append("and purInWarehsBill.fid = '" + purinwarhsBillID + "'  ");
        sqlBuffer.append("order by purOrderNum asc ");
        return sqlBuffer.toString();
    }

    private String getMessToSalesSql(String purinwarhsBillID) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select saleOrder.fnumber AS saleNumber, ");
        sqlBuffer.append("saleOrder.FCreatorID AS creatorID,");
        sqlBuffer.append("userTableSalePerson.fid AS salePersonID ");
        sqlBuffer.append("from T_IM_PurInWarehsBill purInWarehsBill ");
        sqlBuffer.append("left outer join t_im_purinwarehsentry  purInEntry ");
        sqlBuffer.append("on purInWarehsBill.fid = purInEntry.fparentid ");
        sqlBuffer.append("inner join t_sm_purorder purOrder ");
        sqlBuffer.append("on purInEntry.FPurOrderID = purOrder.fid ");
        sqlBuffer.append("inner join t_sm_purorderentry purOrderEntry ");
        sqlBuffer.append("on purInEntry.FPurOrderEntryID = purOrderEntry.fid ");
        sqlBuffer.append("inner join t_sd_saleorder saleOrder ");
        sqlBuffer.append("on purOrderEntry.FSourceBillID = saleOrder.fid ");
        sqlBuffer.append("inner join t_sd_saleorderentry saleOrderEntry ");
        sqlBuffer.append("on purOrderEntry.FSourceBillEntryID = saleOrderEntry.fid ");
        sqlBuffer.append("left outer join t_pm_user userTableSalePerson ");
        sqlBuffer.append("on saleOrder.FSalePersonID = userTableSalePerson.FPersonId ");
        sqlBuffer.append("where purInWarehsBill.fid = '" + purinwarhsBillID + "' and ");
        sqlBuffer.append(" saleOrder.fnumber is not null ");
        sqlBuffer.append("order by saleNumber asc ");
        return sqlBuffer.toString();
    }

    private BOTRelationInfo getRelationInfoBySrcObjectId(BOTRelationCollection relationCollection, String srcObjectId) {
        for (int j = 0; j < relationCollection.size(); ++j) {
            BOTRelationInfo relationInfo = relationCollection.get(j);
            if (!relationInfo.getSrcObjectID().equals(srcObjectId)) continue;
            return relationInfo;
        }
        return null;
    }

    private boolean sendMessageToSales(Context ctx, IObjectPK pk, List userList, List messageList) throws EASBizException, BOSException {
        String sqlString = this.getMessToSalesSql(pk.toString());
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlString);
            String saleOrderNumber = null;
            String creatorID = null;
            String salePersonID = null;
            int index = -1;
            StringBuffer messageBuff = null;
            while (rs.next()) {
                StringBuffer newBuffer;
                saleOrderNumber = rs.getString("saleNumber");
                if (!rs.getString("creatorID").equals("")) {
                    creatorID = rs.getString("creatorID");
                }
                if (!rs.getString("salePersonID").equals("")) {
                    salePersonID = rs.getString("salePersonID");
                }
                if (creatorID != null && !creatorID.equals("")) {
                    index = userList.indexOf(creatorID);
                    if (index != -1) {
                        messageBuff = (StringBuffer)messageList.get(index);
                        if (messageBuff.indexOf(saleOrderNumber) == -1) {
                            messageBuff.append(saleOrderNumber + ",");
                        }
                    } else {
                        userList.add(creatorID);
                        newBuffer = new StringBuffer();
                        newBuffer.append(saleOrderNumber + ",");
                        messageList.add(newBuffer);
                    }
                }
                if (salePersonID == null || salePersonID.equals("")) continue;
                index = userList.indexOf(salePersonID);
                if (index != -1) {
                    messageBuff = (StringBuffer)messageList.get(index);
                    if (messageBuff.indexOf(saleOrderNumber) != -1) continue;
                    messageBuff.append(saleOrderNumber + ",");
                    continue;
                }
                userList.add(salePersonID);
                newBuffer = new StringBuffer();
                newBuffer.append(saleOrderNumber + ",");
                messageList.add(newBuffer);
            }
            return userList.size() > 0;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void batchReverseVoucher(Context ctx, String idStr, BOTBillOperStateEnum billOperStateEnum, BOTRelationCollection relationCollection, Set<String> voucherIdSet) throws BOSException, EASBizException {
        IRowSet rs;
        PreparedStatement deleteDisChargePS;
        PreparedStatement deletePS;
        PreparedStatement updatePS;
        PreparedStatement insertPS;
        Connection conn;
        block19: {
            String getPurInfoSql = "select bill.fid,bill.FVoucherId,entry.FCompanyOrgUnitId,bill.FPurchaseType,bill.FDischargeType,bill.FISINITBILL   from t_im_purinwarehsbill bill inner join t_im_purinwarehsentry entry on bill.fid=entry.fparentid  where bill.fid in ({0}) group by bill.fid,bill.FVoucherId,entry.FCompanyOrgUnitId,bill.FPurchaseType,bill.FDischargeType,bill.FISINITBILL";
            String insertPurVoucherSql = "insert into t_im_purinwarehsvoucher(FID,FYear,FPeriod,FCompanyOrgUnitId,FBillId,FVoucherId,FVoucherType,FCreateTime) values(?,?,?,?,?,?,?,?)";
            String updateFFiVouchered = "update t_im_purinwarehsbill set FFiVouchered = ?, FVoucherId = ? where FId = ?";
            String deletePurVoucherSql = "delete from t_im_purinwarehsvoucher where FVoucherId = ? and FVoucherType = 1";
            String deleteDischargeVoucherSql = "delete from t_im_purinwarehsvoucher where FVoucherId = ? and FVoucherType = 2";
            conn = null;
            insertPS = null;
            updatePS = null;
            deletePS = null;
            deleteDisChargePS = null;
            boolean isNeedExecuteBatch = false;
            boolean isNeedExecuteDisChargeBatch = false;
            BOTRelationInfo relationInfo = null;
            String billId = null;
            String companyId = null;
            String voucherId = null;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("period.periodYear"));
            selector.add(new SelectorItemInfo("period.periodNumber"));
            rs = DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(getPurInfoSql, idStr));
            try {
                conn = this.getConnection(ctx);
                IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) {
                    PurInWarehsVoucherInfo voucherInfo = new PurInWarehsVoucherInfo();
                    updatePS = conn.prepareStatement(updateFFiVouchered);
                    insertPS = conn.prepareStatement(insertPurVoucherSql);
                    StringBuffer lockPks = new StringBuffer("");
                    while (rs.next()) {
                        billId = rs.getString("FId");
                        lockPks.append("'").append(billId).append("'");
                        lockPks.append(",");
                        companyId = rs.getString("FCompanyOrgUnitId");
                        relationInfo = this.getRelationInfoBySrcObjectId(relationCollection, billId);
                        updatePS.setInt(1, 1);
                        updatePS.setString(2, relationInfo.getDestObjectID());
                        updatePS.setString(3, billId);
                        updatePS.addBatch();
                        if (rs.getInt("FDischargeType") == 0) continue;
                        VoucherInfo voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(relationInfo.getDestObjectID()), selector);
                        insertPS.setString(1, BOSUuid.create((BOSObjectType)voucherInfo.getBOSType()).toString());
                        insertPS.setInt(2, voucher.getPeriod().getPeriodYear());
                        insertPS.setInt(3, voucher.getPeriod().getPeriodNumber());
                        insertPS.setString(4, companyId);
                        insertPS.setString(5, billId);
                        insertPS.setString(6, relationInfo.getDestObjectID());
                        insertPS.setInt(7, rs.getInt("FISINITBILL") == 0 ? 1 : 2);
                        insertPS.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
                        insertPS.addBatch();
                        isNeedExecuteBatch = true;
                    }
                    if (lockPks.length() > 0) {
                        lockPks.deleteCharAt(lockPks.length() - 1);
                    }
                    String lockSql = "UPDATE t_im_purinwarehsbill SET FID = FID WHERE FID IN (" + lockPks.toString() + ")";
                    DbUtil.execute((Context)ctx, (String)lockSql);
                    StringBuffer checkSql = new StringBuffer("");
                    checkSql.append("SELECT fid  FROM t_im_purinwarehsbill");
                    checkSql.append(" WHERE FID IN (").append(lockPks.toString()).append(") and ffivouchered = 1");
                    IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                    if (checkResult.next()) {
                        throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK);
                    }
                    updatePS.executeBatch();
                    if (isNeedExecuteBatch) {
                        insertPS.executeBatch();
                    }
                    break block19;
                }
                if (BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) {
                    updatePS = conn.prepareStatement(updateFFiVouchered);
                    deletePS = conn.prepareStatement(deletePurVoucherSql);
                    deleteDisChargePS = conn.prepareStatement(deleteDischargeVoucherSql);
                    IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                    String dischargeType = null;
                    int i = 0;
                    while (rs.next()) {
                        billId = rs.getString("FId");
                        voucherId = rs.getString("FVoucherId");
                        companyId = rs.getString("FCompanyOrgUnitId");
                        relationInfo = this.getRelationInfoBySrcObjectId(relationCollection, billId);
                        if (0 == i) {
                            dischargeType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_001");
                        }
                        if (relationInfo.getDestObjectID().equals(voucherId)) {
                            updatePS.setInt(1, 0);
                            updatePS.setString(2, null);
                            updatePS.setString(3, billId);
                            updatePS.addBatch();
                        }
                        if (rs.getInt("FDischargeType") != 0) {
                            deletePS.setString(1, relationInfo.getDestObjectID());
                            deletePS.addBatch();
                            isNeedExecuteBatch = true;
                        }
                        if ("1".equals(dischargeType) && rs.getInt("FISINITBILL") == 1) {
                            deleteDisChargePS.setString(1, relationInfo.getDestObjectID());
                            deleteDisChargePS.addBatch();
                            isNeedExecuteDisChargeBatch = true;
                        }
                        ++i;
                    }
                    updatePS.executeBatch();
                    if (isNeedExecuteBatch) {
                        deletePS.executeBatch();
                    }
                    if (isNeedExecuteDisChargeBatch) {
                        deleteDisChargePS.executeBatch();
                    }
                    break block19;
                }
                if (!BOTBillOperStateEnum.EDIT.equals((Object)billOperStateEnum)) break block19;
                String updateSql = "UPDATE T_IM_PURINWAREHSVOUCHER SET FYEAR = ?, FPERIOD = ? WHERE FVOUCHERID = ? AND FVOUCHERTYPE = 1 ";
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", voucherIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                view.setSelector(selector);
                VoucherCollection colls = iVoucher.getVoucherCollection(view);
                Object[] param = null;
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (int i = 0; i < colls.size(); ++i) {
                    VoucherInfo voucher = colls.get(i);
                    param = new Object[]{voucher.getPeriod().getPeriodYear(), voucher.getPeriod().getPeriodNumber(), voucher.getId().toString()};
                    params.add(param);
                }
                if (params.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)updateSql, params);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(updatePS);
                    SQLUtils.cleanup(deletePS);
                    SQLUtils.cleanup(deleteDisChargePS);
                    SQLUtils.cleanup((ResultSet)rs, insertPS, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)updatePS);
        SQLUtils.cleanup((Statement)deletePS);
        SQLUtils.cleanup(deleteDisChargePS);
        SQLUtils.cleanup((ResultSet)rs, (Statement)insertPS, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        PurInWarehsBillInfo coreBillInfo = (PurInWarehsBillInfo)this.getCoreBillBaseInfo(ctx, sourceBillPk);
        if (coreBillInfo.getVoucher() == null) {
            return false;
        }
        BillTypeInfo billType = coreBillInfo.getBillType();
        String billNumber = coreBillInfo.getNumber();
        String billId = coreBillInfo.getId().toString();
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)coreBillInfo.getEntries().getObject(0).get("companyOrgUnit");
        ArrayList<String> billNumberList = new ArrayList<String>();
        billNumberList.add(billNumber);
        ArrayList<String> billIdList = new ArrayList<String>();
        billIdList.add(billId);
        boolean checkMutex = false;
        try {
            if (billType != null && billNumber != null && billId != null && cou != null && (billType.getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-017bc0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-0172c0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-0167c0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-0163c0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-016ec0a812fd463ED552") || billType.getId().toString().equals("50957179-0105-1000-e000-0177c0a812fd463ED552")) && CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                IRowSet rs1 = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)cou.getId().toString(), (boolean)true);
                if (rs1.size() > 0) {
                    throw new SCMBillException(SCMBillException.IS_CALCULATING_EXCEPTION);
                }
                checkMutex = true;
                this.insertGenVoucherTable(ctx, cou.getId().toString(), billNumberList, billIdList, billType.getName(), ctx.getUserName(), "DELETE_VOUCHER");
            }
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            iVoucher.delete((IObjectPK)new ObjectUuidPK(coreBillInfo.getVoucher().getId()));
            IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            dapTransformer.undoTransformFromVoucher((BaseVoucherInfo)coreBillInfo.getVoucher());
            boolean bl = true;
            return bl;
        }
        finally {
            if (checkMutex) {
                this.deleteGenVoucherTable(ctx, cou.getId().toString(), billIdList, "DELETE_VOUCHER");
            }
        }
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        if (new PcVoucherInfo().getBOSType().toString().equals(bOTRelationInfos.get(0).getDestEntityID())) {
            this.savePCVoucher(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
            return;
        }
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        logger.debug((Object)("botRelation.destEntityId:" + botRelation.getDestEntityID()));
        logger.debug((Object)("botRelation.srcEntityId:" + botRelation.getSrcEntityID()));
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        this.checkDelVoucher(ctx, srcBillPKs, bOTBillOperStateEnum, botRelation.getDestObjectID());
        String entityID = "";
        StringBuffer sqlin = new StringBuffer();
        HashSet<String> destIds = new HashSet<String>();
        int size = bOTRelationInfos.size();
        for (int i = 0; i < size; ++i) {
            entityID = bOTRelationInfos.get(i).getSrcEntityID();
            if (!"783061E3".equals(entityID)) continue;
            if (i % 200 != 0 && sqlin.length() > 0) {
                sqlin.append(",");
            }
            sqlin.append("'").append(bOTRelationInfos.get(i).getSrcObjectID()).append("'");
            destIds.add(bOTRelationInfos.get(i).getDestObjectID());
            if ((i + 1) % 200 != 0) continue;
            this.batchReverseVoucher(ctx, sqlin.toString(), bOTBillOperStateEnum, bOTRelationInfos, destIds);
            sqlin.setLength(0);
            destIds = new HashSet();
        }
        if (!sqlin.toString().equals("")) {
            this.batchReverseVoucher(ctx, sqlin.toString(), bOTBillOperStateEnum, bOTRelationInfos, destIds);
        }
        logger.debug((Object)("batchReverseSave spent:" + (System.currentTimeMillis() - t1) + "ms"));
    }

    private void checkDelVoucher(Context ctx, IObjectPK[] srcBillPKs, BOTBillOperStateEnum bOTBillOperStateEnum, String voucherId) throws BOSException, EASBizException {
        if (bOTBillOperStateEnum == BOTBillOperStateEnum.DELETE && srcBillPKs.length == 1) {
            try {
                StringBuilder checkSql = new StringBuilder();
                checkSql.append("SELECT b.FCOMPANYORGUNITID  FROM t_im_purinwarehsBill a inner join T_IM_PURINWAREHSENTRY  b ON A.FID = B.FPARENTID ");
                checkSql.append("where a.fid = '").append(srcBillPKs[0]).append("' and b.fseq = 1");
                IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                PeriodInfo periodInfo = null;
                while (checkRs.next()) {
                    CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
                    cou.setId(BOSUuid.read((String)checkRs.getString("FCOMPANYORGUNITID")));
                    periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
                    IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                    int companyDisChargeType = Integer.parseInt(ipc.getParamValue((IObjectPK)new ObjectUuidPK(checkRs.getString("FCOMPANYORGUNITID")), "SCM_CAL_001"));
                    if (0 != companyDisChargeType) continue;
                    return;
                }
                if (periodInfo != null) {
                    checkSql.setLength(0);
                    checkSql.append("SELECT FVOUCHERTYPE FROM T_IM_PURINWAREHSVOUCHER where FVOUCHERID = '").append(voucherId).append("'");
                    checkRs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                    if (checkRs.size() == 0) {
                        return;
                    }
                    int voucherType = -1;
                    while (checkRs.next()) {
                        voucherType = checkRs.getInt("FVOUCHERTYPE");
                        if (1 == voucherType) continue;
                        return;
                    }
                    checkSql.setLength(0);
                    checkSql.append("select bill.FWriteOffYear FWriteOffYear,bill.FWriteOffPeriod FWriteOffPeriod,bill.FIsDischarged FIsDischarged,purBill.fnumber fnumber ");
                    checkSql.append("from t_cl_writeoffgroup bill ");
                    checkSql.append("inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid ");
                    checkSql.append("inner join t_im_purinwarehsBill purBill on purBill.fid = entry.fbillid ");
                    checkSql.append("where purBill.fid = '").append(srcBillPKs[0]).append("' ");
                    checkSql.append("and (bill.FWriteOffYear * 100 + bill.FWriteOffPeriod) >= ").append(periodInfo.getNumber());
                    checkRs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                    while (checkRs.next()) {
                        if (checkRs.getInt("FWriteOffYear") * 100 + checkRs.getInt("FWriteOffPeriod") > periodInfo.getNumber()) {
                            throw new CalculateException(CalculateException.NOTDEL_HAS_OHTERWRITEOFF);
                        }
                        if (checkRs.getInt("FIsDischarged") != 1) continue;
                        throw new CalculateException(CalculateException.WRITEOFF_DISCHARGEVOUCHER_EXIST, (Object[])new String[]{checkRs.getString("fnumber")});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void checkBotp(PurInWarehsBillInfo info) throws InvBizException {
        if (info.get("isInTax") == null) {
            throw new InvBizException(InvBizException.BOTP_ISINTAXNOTCONFIG);
        }
        if (info.get("isPriceInTax") == null) {
            throw new InvBizException(InvBizException.BOTP_ISPRICEINTAXNOTCONFIG);
        }
        if (info.isIsInTax()) {
            if (info.getEntry().get(0).get("taxPrice") == null && info.getEntry().get(0).get("taxAmount") == null) {
                throw new InvBizException(InvBizException.BOTP_TAXPRICEORTAXAMOUNTNOTCONFIG);
            }
        } else if (info.getEntry().get(0).get("price") == null && info.getEntry().get(0).get("amount") == null) {
            throw new InvBizException(InvBizException.BOTP_PRICEORAMOUNTNOTCONFIG);
        }
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        this.setWriteOffField(info, ctx);
        this.checkBotp(info);
        if (!this.isCostEqual(info)) {
            try {
                new PurInAlgorithmForInfo(info, ctx).revalue();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        this.setWriteOffField(info, ctx);
        return super._addnew(ctx, model);
    }

    private void setWriteOffField(PurInWarehsBillInfo info, Context ctx) throws BOSException {
        String paramValue = "false";
        CompanyOrgUnitInfo company = info.getEntry().get(0).getCompanyOrgUnit();
        try {
            if (company != null) {
                IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
                paramValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId().toString()), "AP_032");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        boolean isPresentToAp = false;
        if ("true".equals(paramValue)) {
            isPresentToAp = true;
        }
        PurInWarehsEntryCollection entrys = info.getEntry();
        PurInWarehsEntryInfo entry = null;
        BigDecimal zero = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            if (entry.isIsPresent() && !isPresentToAp) {
                entry.setWrittenOffQty(entry.getQty());
                entry.setWrittenOffBaseQty(entry.getBaseQty());
                entry.setWrittenOffAmount(entry.getPurchaseCost());
                entry.setUnWriteOffQty(zero);
                entry.setUnWriteOffBaseQty(zero);
                entry.setUnWriteOffAmount(zero);
                continue;
            }
            entry.setUnWriteOffQty(entry.getQty());
            entry.setUnWriteOffBaseQty(entry.getBaseQty());
            entry.setUnWriteOffAmount(entry.getPurchaseCost());
            entry.setWrittenOffQty(zero);
            entry.setWrittenOffBaseQty(zero);
            entry.setWrittenOffAmount(zero);
        }
    }

    private boolean isCostEqual(PurInWarehsBillInfo info) {
        for (int i = 0; i < info.getEntry().size(); ++i) {
            PurInWarehsEntryInfo entry = info.getEntry().get(i);
            BigDecimal purchaseFee = entry.getPurchaseFee();
            BigDecimal materialCost = entry.getMaterialCost();
            BigDecimal purchaseCost = entry.getPurchaseCost();
            BigDecimal actualCost = entry.getActualCost();
            if (purchaseFee == null || materialCost == null || purchaseCost == null || actualCost == null) {
                return false;
            }
            if (purchaseFee.add(materialCost).add(purchaseCost).compareTo(actualCost) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void afterPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        IRewrite iSrcRewrite;
        IRewrite iCoreRewrite;
        super.afterPassAudit(ctx, pk, billInfo);
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)billInfo;
        PurInWarehsEntryInfo firstEntry = info.getEntry().get(0);
        if (firstEntry.getCoreBillType() != null && (iCoreRewrite = RewriterFactory.getRewriter((String)firstEntry.getCoreBillType().getId().toString(), (String)info.getBillType().getId().toString())) != null) {
            iCoreRewrite.rewrite((IObjectValue)info, 103, ctx);
        }
        if (firstEntry.getSourceBillType() != null && (iSrcRewrite = RewriterFactory.getRewriter((String)firstEntry.getSourceBillType().getId().toString(), (String)info.getBillType().getId().toString())) != null) {
            iSrcRewrite.rewrite((IObjectValue)info, 103, ctx);
        }
    }

    @Override
    protected void afterUnPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        IRewrite iSrcRewrite;
        IRewrite iCoreRewrite;
        super.afterUnPassAudit(ctx, pk, invBillBaseInfo);
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)invBillBaseInfo;
        PurInWarehsEntryInfo firstEntry = info.getEntry().get(0);
        if (firstEntry.getCoreBillType() != null && (iCoreRewrite = RewriterFactory.getRewriter((String)firstEntry.getCoreBillType().getId().toString(), (String)info.getBillType().getId().toString())) != null) {
            iCoreRewrite.rewrite((IObjectValue)info, 109, ctx);
        }
        if (firstEntry.getSourceBillType() != null && (iSrcRewrite = RewriterFactory.getRewriter((String)firstEntry.getSourceBillType().getId().toString(), (String)info.getBillType().getId().toString())) != null) {
            iSrcRewrite.rewrite((IObjectValue)info, 109, ctx);
        }
    }

    @Override
    protected String getCoreBillEntryId(Context ctx, InvBillBaseInfo info) {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)info;
        PurInWarehsEntryCollection col = billInfo.getEntry();
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getPurOrderEntry() == null) continue;
            inSql.append("'").append(col.get(i).getPurOrderEntry()).append("',");
        }
        if (inSql.length() > 0) {
            inSql.setLength(inSql.length() - 1);
            return inSql.toString();
        }
        return null;
    }

    @Override
    protected Map getCoreBillType(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)info;
        PurInWarehsEntryCollection col = billInfo.getEntry();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getCoreBillType() == null || col.get(i).getCoreBillType().getId() == null) continue;
            map.put(col.get(i).getCoreBillType().getId().toString(), col.get(i).getCoreBillType().getId().toString());
        }
        if (map.size() > 0) {
            return map;
        }
        return null;
    }

    @Override
    protected boolean checkEntryCoreBillType(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)aInvBillBaseInfo;
        PurInWarehsEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || CoreBillTypeid == null) continue;
            return false;
        }
        return true;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (name.equals("unAudit")) {
            HashSet<String> ids = new HashSet<String>();
            CoreBaseCollection coll = null;
            for (int i = 0; i < paramEntries.length; ++i) {
                ids.add(paramEntries[i].toArray()[0].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("transactionType.id"));
            selector.add(new SelectorItemInfo("bizType.id"));
            selector.add(new SelectorItemInfo("sourceBillType.id"));
            view.setSelector(selector);
            coll = this.getCollection(ctx, view);
            if (coll != null && coll.size() > 0) {
                InvBillBaseInfo info = null;
                for (int i = 0; i < coll.size(); ++i) {
                    info = (InvBillBaseInfo)coll.get(i);
                    if ("bsBvQE5PP4DgQKjAYj0d/CQHQ1w=".equals(info.getBizType().getId().toString())) {
                        throw new InvBizException(InvBizException.CANNOTUNAUDIT_MATERREQFORMM4, new Object[]{info.getNumber()});
                    }
                    if (info.getBizType() == null || info.getSourceBillType() == null || !info.getBizType().getId().toString().equals("bsBvQE5PP4DgQKjAYj0d/CQHQ1w=") || !info.getSourceBillType().getId().toString().equals("EVuaJtWZ4kKbRG9czgLdmkY+1VI=")) continue;
                    throw new InvBizException(InvBizException.CHECK_DIRECT_MATERIAL_PURINWAREHS_UNAUDIT);
                }
            }
        }
        return super.batchExecute(ctx, name, paramTypes, paramEntries);
    }

    private void setTransType4RetTransferOrder(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        if (info.getBizType() != null) {
            String bizType = info.getBizType().getId().toString();
            boolean isSysBill = info.isIsSysBill();
            String billType = "50957179-0105-1000-e000-015fc0a812fd463ED552";
            TransactionTypeInfo transactionTypeInfo = null;
            TransactionTypeCollection ttcol = null;
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            if ((!this.isBotpConfigTransactionType.booleanValue() && "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType) || !isSysBill && ("ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType))) && (ttcol = itt.getCollection(billType, bizType)) != null && ttcol.size() > 0) {
                transactionTypeInfo = ttcol.get(0);
            }
            if (transactionTypeInfo != null) {
                info.setTransactionType(transactionTypeInfo);
                int size = info.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    PurInWarehsEntryInfo entryInfo = info.getEntry().get(i);
                    this.inverseEntryInfo(entryInfo);
                }
            }
        }
    }

    @Override
    protected boolean isCheckMaterialInventory() {
        return true;
    }

    @Override
    protected void setUnAssociationQtyByQty(IObjectCollection entrys) throws BOSException, EASBizException {
        for (int i = 0; i < entrys.size(); ++i) {
            PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)entrys.getObject(i);
            if (entry.getBaseQty() == null) {
                entry.setBaseQty(SysConstant.BIGZERO);
            }
            entry.setAssociateQty(entry.getBaseQty().abs());
        }
    }

    @Override
    protected boolean isUseBusinessChain() {
        return false;
    }

    public BigDecimal formatBigDecimal(BigDecimal value) {
        return value == null ? SysConstant.BIGZERO : value;
    }

    private void inverseEntryInfo(PurInWarehsEntryInfo entryInfo) {
        entryInfo.setQty(this.formatBigDecimal(entryInfo.getQty()).abs().negate());
        entryInfo.setBaseQty(this.formatBigDecimal(entryInfo.getBaseQty()).abs().negate());
        entryInfo.setAssistQty(this.formatBigDecimal(entryInfo.getAssistQty()).abs().negate());
        entryInfo.setAmount(this.formatBigDecimal(entryInfo.getAmount()).abs().negate());
        entryInfo.setLocalAmount(this.formatBigDecimal(entryInfo.getLocalAmount()).abs().negate());
        entryInfo.setStandardCost(this.formatBigDecimal(entryInfo.getStandardCost()).abs().negate());
        entryInfo.setActualCost(this.formatBigDecimal(entryInfo.getActualCost()).abs().negate());
        entryInfo.setWrittenOffAmount(this.formatBigDecimal(entryInfo.getWrittenOffAmount()).abs().negate());
        entryInfo.setUnWriteOffAmount(this.formatBigDecimal(entryInfo.getUnWriteOffAmount()).abs().negate());
        entryInfo.setWrittenOffQty(this.formatBigDecimal(entryInfo.getWrittenOffQty()).abs().negate());
        entryInfo.setUnWriteOffQty(this.formatBigDecimal(entryInfo.getUnWriteOffQty()).abs().negate());
        entryInfo.setUnWriteOffBaseQty(this.formatBigDecimal(entryInfo.getUnWriteOffBaseQty()).abs().negate());
        entryInfo.setLocalAmount(this.formatBigDecimal(entryInfo.getLocalAmount().abs().negate()));
        entryInfo.setLocalTax(this.formatBigDecimal(entryInfo.getLocalTax()).abs().negate());
        entryInfo.setTax(this.formatBigDecimal(entryInfo.getTax()).abs().negate());
        entryInfo.setPurchaseCost(this.formatBigDecimal(entryInfo.getPurchaseCost()).abs().negate());
        entryInfo.setPurchaseFee(this.formatBigDecimal(entryInfo.getPurchaseFee()).abs().negate());
        entryInfo.setDiscountAmount(this.formatBigDecimal(entryInfo.getDiscountAmount()).abs().negate());
        entryInfo.setTaxAmount(this.formatBigDecimal(entryInfo.getTaxAmount()).abs().negate());
        entryInfo.setLocalTaxAmount(this.formatBigDecimal(entryInfo.getLocalTaxAmount()).abs().negate());
        entryInfo.setImputedCost(this.formatBigDecimal(entryInfo.getImputedCost()).abs().negate());
        entryInfo.setAssociateQty(this.formatBigDecimal(entryInfo.getAssociateQty()).abs().negate());
    }

    @Override
    public HashMap _getSupplyPrice(Context ctx, List list) throws BOSException, EASBizException {
        HashMap<String, SimpleSupplyInfoVO> map = new HashMap<String, SimpleSupplyInfoVO>();
        if (list.isEmpty()) {
            return map;
        }
        this.initParams(ctx, list);
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            SimplePurInWarehsEntryVO vo = (SimplePurInWarehsEntryVO)list.get(i);
            if (vo.getMaterialID() == null || vo.getPurchaseOrgID() == null) continue;
            if (vo.getBizDate() == null || StringUtils.isEmpty((String)vo.getSupplierID()) || StringUtils.isEmpty((String)vo.getUnitID())) {
                SimpleSupplyInfoVO ssVo = this.getSupplyInfoMapByMatPurchase(ctx, vo);
                map.put(vo.getMaterialID() + vo.getPurchaseOrgID() + vo.getUnitID(), ssVo);
                continue;
            }
            String materialId = vo.getMaterialID();
            String purchaseId = vo.getPurchaseOrgID();
            String supplierId = vo.getSupplierID();
            Date bizDate = vo.getBizDate();
            String unitID = vo.getUnitID();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialId));
            filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierId));
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purchaseId));
            filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)unitID));
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)bizDate, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)bizDate, CompareType.GREATER_EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("price"));
            sic.add(new SelectorItemInfo("isTaxPrice"));
            sic.add(new SelectorItemInfo("discountRate"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("effectualDate"));
            sic.add(new SelectorItemInfo("uneffectualDate"));
            viewInfo.setSelector(sic);
            SupplyInfoCollection supplyColl = SupplyInfoFactory.getLocalInstance((Context)ctx).getSupplyInfoCollection(viewInfo);
            int size = supplyColl.size();
            for (int j = 0; j < size; ++j) {
                SupplyInfoInfo supplyInfoInfo = supplyColl.get(j);
                int effect = InvCommonUtils.getNumFromCalendar(supplyInfoInfo.getEffectualDate());
                int uneffect = InvCommonUtils.getNumFromCalendar(supplyInfoInfo.getUneffectualDate());
                int bizDateNum = InvCommonUtils.getNumFromCalendar(bizDate);
                if (effect == uneffect || bizDateNum != uneffect) continue;
                supplyColl.remove(supplyInfoInfo);
            }
            SupplyInfoInfo supplyInfo = null;
            if (supplyColl.isEmpty()) {
                SimpleSupplyInfoVO ssVo = this.getSupplyInfoMapByMatPurchase(ctx, vo);
                map.put(vo.getMaterialID() + vo.getPurchaseOrgID() + vo.getUnitID(), ssVo);
            } else {
                int num = supplyColl.size();
                if (num == 1) {
                    supplyInfo = supplyColl.get(0);
                } else {
                    int x = 0;
                    for (int j = 1; j < num; ++j) {
                        if (supplyColl.get(x).getAuditDate() == null || !supplyColl.get(j).getAuditDate().after(supplyColl.get(x).getAuditDate())) continue;
                        x = j;
                    }
                    supplyInfo = supplyColl.get(x);
                }
            }
            if (supplyInfo == null) continue;
            BigDecimal price = supplyInfo.getPrice() != null ? supplyInfo.getPrice() : SCMConstant.BIGDECIMAL_ZERO;
            SimpleSupplyInfoVO simpleSupplyInfoVO = new SimpleSupplyInfoVO();
            simpleSupplyInfoVO.setPrice(price);
            simpleSupplyInfoVO.setInTax(supplyInfo.isIsTaxPrice());
            simpleSupplyInfoVO.setDiscountRate(supplyInfo.getDiscountRate());
            map.put(vo.getMaterialID() + vo.getPurchaseOrgID() + vo.getUnitID(), simpleSupplyInfoVO);
        }
        return map;
    }

    private void initParams(Context ctx, List list) throws BOSException, EASBizException {
        if (list.isEmpty()) {
            return;
        }
        String[] params = new String[]{"PURORDER002"};
        HashMap valueMap = new HashMap();
        HashMap purMaterialMap = new HashMap();
        HashSet<String> purMaterialSet = null;
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            SimplePurInWarehsEntryVO vo = (SimplePurInWarehsEntryVO)list.get(i);
            if (vo.getMaterialID() == null || vo.getPurchaseOrgID() == null) continue;
            String materialId = vo.getMaterialID();
            String purchaseId = vo.getPurchaseOrgID();
            if (!this.purchaseList.contains(purchaseId)) {
                this.purchaseList.add(purchaseId);
                valueMap = this.getParamControl(ctx).getParamHashMap(params, purchaseId);
                if (valueMap != null) {
                    this.purOrder002Map.put(purchaseId, valueMap.get("PURORDER002"));
                }
            }
            if ((purMaterialSet = (HashSet<String>)purMaterialMap.get(purchaseId)) == null) {
                purMaterialSet = new HashSet<String>();
                purMaterialSet.add(materialId);
                purMaterialMap.put(purchaseId, purMaterialSet);
                continue;
            }
            if (purMaterialSet.contains(materialId)) continue;
            purMaterialSet.add(materialId);
        }
        EntityViewInfo view = null;
        FilterInfo filter = null;
        MaterialPurchasingCollection matPurColl = null;
        Iterator it = purMaterialMap.entrySet().iterator();
        while (it.hasNext()) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            Map.Entry entry = it.next();
            filter.getFilterItems().add(new FilterItemInfo("material", entry.getValue(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)entry.getKey().toString()));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            view.setFilter(filter);
            matPurColl = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
            int count2 = matPurColl.size();
            for (int i = 0; i < count2; ++i) {
                MaterialPurchasingInfo matPurInfo = matPurColl.get(i);
                this.materialPurchaseMap.put(matPurInfo.getMaterial().getId().toString() + entry.getKey().toString(), matPurInfo);
            }
        }
    }

    private IParamControl getParamControl(Context ctx) throws BOSException {
        return ParamControlFactory.getLocalInstance((Context)ctx);
    }

    private SimpleSupplyInfoVO getSupplyInfoMapByMatPurchase(Context ctx, SimplePurInWarehsEntryVO vo) throws BOSException, EASBizException {
        String materialId = vo.getMaterialID();
        String purchaseId = vo.getPurchaseOrgID();
        String unitId = vo.getUnitID();
        String baseUnitID = vo.getBaseUnitID();
        if (StringUtils.isEmpty((String)unitId)) {
            unitId = baseUnitID;
        }
        String paramValue = (String)this.purOrder002Map.get(purchaseId);
        MaterialPurchasingInfo materialPurInfo = (MaterialPurchasingInfo)this.materialPurchaseMap.get(materialId + purchaseId);
        if (materialPurInfo == null) {
            SimpleSupplyInfoVO simpleSupplyInfoVO = new SimpleSupplyInfoVO();
            simpleSupplyInfoVO.setPrice(SCMConstant.BIGDECIMAL_ZERO);
            simpleSupplyInfoVO.setInTax(this.isPurParamPUR(paramValue, true));
            simpleSupplyInfoVO.setDiscountRate(SCMConstant.BIGDECIMAL_ZERO);
            return simpleSupplyInfoVO;
        }
        BigDecimal price = materialPurInfo.getPrice() != null ? materialPurInfo.getPrice() : SCMConstant.BIGDECIMAL_ZERO;
        String materialPurUnitId = materialPurInfo.getUnit().getId().toString();
        BigDecimal convsRate = new BigDecimal("1.00");
        if (!materialPurUnitId.equals(unitId)) {
            StringBuffer sb = new StringBuffer();
            sb.append("select top 1 decimal(b.FBaseConvsRate/a.FBaseConvsRate,28,16) convsRate ");
            sb.append("from T_BD_MultiMeasureUnit a, ");
            sb.append("(select FMaterialID,FBaseConvsRate from T_BD_MultiMeasureUnit where FMaterialID =? and FMeasureUnitID=?) b ");
            sb.append("where a.FMaterialID =?  ");
            sb.append("and a.FMeasureUnitID=? ");
            sb.append("and a.FMaterialID = b.FMaterialID ");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{materialId, unitId, materialId, materialPurUnitId});
            try {
                if (rs.next()) {
                    convsRate = rs.getBigDecimal("convsRate");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        SimpleSupplyInfoVO simpleSupplyInfoVO = new SimpleSupplyInfoVO();
        simpleSupplyInfoVO.setPrice(price.multiply(convsRate));
        simpleSupplyInfoVO.setInTax(this.isPurParamPUR(paramValue, true));
        simpleSupplyInfoVO.setDiscountRate(SCMConstant.BIGDECIMAL_ZERO);
        return simpleSupplyInfoVO;
    }

    public boolean isPurParamPUR(String paramValue, boolean defaultValue) {
        boolean isPurParam = defaultValue;
        if (!StringUtils.isEmpty((String)paramValue)) {
            if (paramValue.trim().equalsIgnoreCase("true")) {
                isPurParam = true;
            }
            if (paramValue.trim().equalsIgnoreCase("false")) {
                isPurParam = false;
            }
        }
        return isPurParam;
    }

    @Override
    protected LotFrame fillLotNumber(Context ctx, IObjectValue model, LotFrame lotFrame, InvBillBaseEntryInfo entryInfo) throws EASBizException, BOSException {
        if (model == null) {
            return lotFrame;
        }
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        SupplierInfo supplier = info.getSupplier();
        if (supplier != null && supplier.getId() != null && supplier.getNumber() == null) {
            ObjectUuidPK pk = new ObjectUuidPK(supplier.getId());
            supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)pk);
            info.setSupplier(supplier);
        }
        if (supplier != null) {
            lotFrame.setSupplier(supplier.getNumber());
        } else {
            lotFrame.setSupplier(null);
        }
        if (entryInfo == null) {
            return lotFrame;
        }
        PurInWarehsEntryInfo entry = (PurInWarehsEntryInfo)entryInfo;
        CustomerInfo customer = entry.getCustomer();
        if (customer != null && customer.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(customer.getId());
            customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)pk);
        }
        if (customer != null) {
            lotFrame.setCustomer(customer.getNumber());
        } else {
            lotFrame.setCustomer(null);
        }
        String supplierLotNo = entry.getSupplierLotNo();
        if (supplierLotNo != null) {
            lotFrame.setSupplierlotno(supplierLotNo);
        } else {
            lotFrame.setSupplierlotno(null);
        }
        return lotFrame;
    }

    private Date getNextPeriodBeginDate(Context ctx, PurInWarehsBillInfo billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo cou = null;
        ISCMBillCommonFacade iSCMBillCommonFacade = null;
        StorageOrgUnitInfo sou = billInfo.getStorageOrgUnit();
        iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        cou = iSCMBillCommonFacade.getCompanyInfo(sou.getId());
        boolean isChangeDate = this.isPurInBillSplitChangeDate(ctx, sou.getId().toString());
        if (!isChangeDate) {
            return null;
        }
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        PeriodInfo bizPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)billInfo.getBizDate(), (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
        boolean ischecked = PeriodUtils.PeriodCompare((PeriodInfo)bizPeriodInfo, (PeriodInfo)currentPeriodInfo);
        if (!ischecked) {
            return null;
        }
        Date bizDate = null;
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)bizPeriodInfo);
        bizDate = nextPeriodInfo.isIsAdjustPeriod() ? PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo).getBeginDate() : nextPeriodInfo.getBeginDate();
        return bizDate;
    }

    private boolean isPurInBillSplitChangeDate(Context ctx, String companyInfoID) throws BOSException, EASBizException {
        String per;
        ObjectUuidPK pk;
        boolean isChangeDate = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String strChangeDate = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyInfoID)), per = "INM101");
        if (strChangeDate != null && strChangeDate.trim().length() != 0 && strChangeDate.trim().equalsIgnoreCase("true")) {
            isChangeDate = true;
        }
        return isChangeDate;
    }

    @Override
    protected void _splitBill(Context ctx, PurInWarehsBillCollection collection, HashMap param) throws BOSException, EASBizException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        this.checkSplit(ctx, collection, param);
        Date splitDate = null;
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, String> flowMap = new HashMap<String, String>();
        boolean isFromSaleIssue = Boolean.TRUE.equals(param.get("isFromSaleIssue"));
        if (!isFromSaleIssue && param.get("SplitDate") != null) {
            splitDate = (Date)param.get("SplitDate");
        }
        BigDecimal ZERO = SysConstant.BIGZERO;
        String motherBillID = "";
        String childBillID = "";
        String motherNumber = "";
        String childNumber = "";
        String motherBillEntryID = "";
        String childBillEntryID = "";
        Date now = new Date();
        int precision = 2;
        Vector<SplitBillRelationInfo> vecSBRelation = new Vector<SplitBillRelationInfo>(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryRelation = new Vector<SplitBillEntryRelationInfo>(0);
        HashMap hsSB = new HashMap(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryByOneSB = new Vector<SplitBillEntryRelationInfo>(0);
        HashMap<String, BOSUuid> voucherRelation = new HashMap<String, BOSUuid>();
        Vector<SplitBillInventoryLog> vecInvLog = new Vector<SplitBillInventoryLog>(0);
        for (int i = 0; i < collection.size(); ++i) {
            idSet.clear();
            PurInWarehsBillInfo aPurInWarehsBillInfo = collection.get(i);
            motherBillID = aPurInWarehsBillInfo.getId().toString();
            motherNumber = aPurInWarehsBillInfo.getNumber();
            if (param.get("WrittenOffSplit") != null && "WrittenOffSplit".equals(param.get("WrittenOffSplit").toString()) && this.isWriteOffOver(aPurInWarehsBillInfo)) continue;
            SplitBillTotalAmount motherSplitBillTotalAmount = new SplitBillTotalAmount();
            SplitBillTotalAmount childSplitBillTotalAmount = new SplitBillTotalAmount();
            precision = 2;
            vecSBEntryByOneSB.clear();
            PurInWarehsBillInfo aSplitBillInfo = (PurInWarehsBillInfo)aPurInWarehsBillInfo.clone();
            aSplitBillInfo.setId(BOSUuid.create((BOSObjectType)aSplitBillInfo.getBOSType()));
            childBillID = aSplitBillInfo.getId().toString();
            childNumber = this.getChildNumber(ctx, aPurInWarehsBillInfo.getNumber(), 0);
            aSplitBillInfo.setNumber(childNumber);
            if (param.get("WrittenOffSplit") != null && "WrittenOffSplit".equals(param.get("WrittenOffSplit").toString())) {
                Date bizDate = this.getNextPeriodBeginDate(ctx, aSplitBillInfo);
                if (bizDate != null) {
                    aSplitBillInfo.setBizDate(bizDate);
                }
            } else if (splitDate != null) {
                aSplitBillInfo.setBizDate(splitDate);
            }
            if (aSplitBillInfo.getBizDate() != null) {
                int[] period = this.convertBizPeriod(ctx, (IObjectValue)aSplitBillInfo);
                aSplitBillInfo.setYear(period[0]);
                aSplitBillInfo.setPeriod(period[1]);
                SimpleDateFormat df1 = new SimpleDateFormat("yyyyMM");
                SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
                String str1 = df1.format(aSplitBillInfo.getBizDate());
                String str2 = df2.format(aSplitBillInfo.getBizDate());
                aSplitBillInfo.setMonth(Integer.parseInt(str1));
                aSplitBillInfo.setDay(Integer.parseInt(str2));
            }
            aSplitBillInfo.getEntry().clear();
            if (aPurInWarehsBillInfo.getCurrency() != null) {
                precision = aPurInWarehsBillInfo.getCurrency().getPrecision();
            }
            PurInWarehsEntryCollection entryColl = aPurInWarehsBillInfo.getEntry();
            boolean isEntryWrite = false;
            boolean isEntryUnWrite = false;
            boolean isEntryPartWrite = false;
            for (int j = 0; j < entryColl.size(); ++j) {
                PurInWarehsEntryInfo aPurInWarehsEntryInfo = entryColl.get(j);
                motherBillEntryID = aPurInWarehsEntryInfo.getId().toString();
                if (aPurInWarehsEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    isEntryUnWrite = true;
                    continue;
                }
                if (aPurInWarehsEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    isEntryWrite = true;
                    continue;
                }
                isEntryPartWrite = true;
            }
            if (isEntryUnWrite && !isEntryWrite && !isEntryPartWrite) {
                if (isFromSaleIssue) {
                    aPurInWarehsBillInfo.setNumber(aPurInWarehsBillInfo.getNumber() + "_A");
                    ObjectUuidPK pk = new ObjectUuidPK(aPurInWarehsBillInfo.getId());
                    this._update(ctx, (IObjectPK)pk, (IObjectValue)aPurInWarehsBillInfo);
                    continue;
                }
                this.allUnWritedSplit(ctx, aPurInWarehsBillInfo, splitDate, true);
                continue;
            }
            IRelationOfChildAndParentFacade iRelationOfChildAndParentFacade = RelationOfChildAndParentFacadeFactory.getLocalInstance(ctx);
            Vector<PurInWarehsEntryInfo> vMatherBillEntry = new Vector<PurInWarehsEntryInfo>(0);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("motherId", aPurInWarehsBillInfo.getId().toString());
            String rootId = null;
            HashMap resultMap = (HashMap)iRelationOfChildAndParentFacade.queryInfoByMap(map);
            if (resultMap.get("FRootID") != null) {
                rootId = (String)resultMap.get("FRootID");
            } else {
                rootId = aPurInWarehsBillInfo.getId().toString();
                this.insertRootSplitRelation(ctx, aPurInWarehsBillInfo);
            }
            for (int j = 0; j < entryColl.size(); ++j) {
                PurInWarehsEntryInfo aClildEntryInfo;
                PurInWarehsEntryInfo aPurInWarehsEntryInfo = entryColl.get(j);
                motherBillEntryID = aPurInWarehsEntryInfo.getId().toString();
                if (aPurInWarehsEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    aClildEntryInfo = (PurInWarehsEntryInfo)aPurInWarehsEntryInfo.clone();
                    String id = aClildEntryInfo.getId().toString();
                    aClildEntryInfo.setId(BOSUuid.create((BOSObjectType)aClildEntryInfo.getBOSType()));
                    aClildEntryInfo.setBizDate(aSplitBillInfo.getBizDate());
                    childBillEntryID = aClildEntryInfo.getId().toString();
                    this.calHeadTotal(childSplitBillTotalAmount, aClildEntryInfo);
                    aSplitBillInfo.getEntry().add(aClildEntryInfo);
                    StringBuffer sql = new StringBuffer();
                    sql.append("update T_IV_MATERIALSERIALNUMBER set fbillentryid = '" + aClildEntryInfo.getId().toString() + "',fbillid = '" + childBillID + "',fbillNUMBER = '" + childNumber + "'  where fbillentryid = '" + id + "'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
                    aSplitBillEntryRelationInfo.setMotherBillEntryID(motherBillEntryID);
                    aSplitBillEntryRelationInfo.setChildBillEntryID(childBillEntryID);
                    aSplitBillEntryRelationInfo.setSplitQty(aClildEntryInfo.getQty());
                    vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
                    vecSBEntryByOneSB.add(aSplitBillEntryRelationInfo);
                    iRelationOfChildAndParentFacade.purInWarehsAddChildOrderToParent(aPurInWarehsBillInfo, aSplitBillInfo, " ", aClildEntryInfo.getId().toString(), rootId);
                } else if (aPurInWarehsEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    this.calHeadTotal(motherSplitBillTotalAmount, aPurInWarehsEntryInfo);
                    vMatherBillEntry.add(aPurInWarehsEntryInfo);
                } else {
                    vMatherBillEntry.add(aPurInWarehsEntryInfo);
                    aClildEntryInfo = (PurInWarehsEntryInfo)aPurInWarehsEntryInfo.clone();
                    aClildEntryInfo.setId(BOSUuid.create((BOSObjectType)aClildEntryInfo.getBOSType()));
                    aClildEntryInfo.setBizDate(aSplitBillInfo.getBizDate());
                    childBillEntryID = aClildEntryInfo.getId().toString();
                    this.doSplitBillEntry(aPurInWarehsEntryInfo, aClildEntryInfo, aPurInWarehsBillInfo, precision, ctx);
                    iRelationOfChildAndParentFacade.purInWarehsAddChildOrderToParent(aPurInWarehsBillInfo, aSplitBillInfo, aPurInWarehsEntryInfo.getId().toString(), aClildEntryInfo.getId().toString(), rootId);
                    SplitBillInventoryLog aSplitBillInventoryLog = new SplitBillInventoryLog();
                    aSplitBillInventoryLog.setEntryID(motherBillEntryID);
                    aSplitBillInventoryLog.setChildEntryID(childBillEntryID);
                    aSplitBillInventoryLog.setChildBillID(childBillID);
                    aSplitBillInventoryLog.setChildBillNumber(childNumber);
                    aSplitBillInventoryLog.setMotherQty(aPurInWarehsEntryInfo.getQty());
                    aSplitBillInventoryLog.setMotherBaseQty(aPurInWarehsEntryInfo.getBaseQty());
                    aSplitBillInventoryLog.setMotherStandardCost(aPurInWarehsEntryInfo.getStandardCost());
                    aSplitBillInventoryLog.setMotherActualCost(aPurInWarehsEntryInfo.getActualCost());
                    aSplitBillInventoryLog.setChildQty(aClildEntryInfo.getQty());
                    aSplitBillInventoryLog.setChildBaseQty(aClildEntryInfo.getBaseQty());
                    aSplitBillInventoryLog.setChildStandardCost(aClildEntryInfo.getStandardCost());
                    aSplitBillInventoryLog.setChildActualCost(aClildEntryInfo.getActualCost());
                    aSplitBillInventoryLog.setYear(aSplitBillInfo.getYear());
                    aSplitBillInventoryLog.setPeriod(aSplitBillInfo.getPeriod());
                    aSplitBillInventoryLog.setChildBizDate(aSplitBillInfo.getBizDate());
                    vecInvLog.add(aSplitBillInventoryLog);
                    this.calHeadTotal(motherSplitBillTotalAmount, aPurInWarehsEntryInfo);
                    this.calHeadTotal(childSplitBillTotalAmount, aClildEntryInfo);
                    aSplitBillInfo.getEntry().add(aClildEntryInfo);
                    SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
                    aSplitBillEntryRelationInfo.setMotherBillEntryID(motherBillEntryID);
                    aSplitBillEntryRelationInfo.setChildBillEntryID(childBillEntryID);
                    aSplitBillEntryRelationInfo.setSplitQty(aClildEntryInfo.getQty());
                    vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
                    vecSBEntryByOneSB.add(aSplitBillEntryRelationInfo);
                }
                idSet.add(motherBillEntryID);
            }
            aPurInWarehsBillInfo.getEntry().clear();
            for (int m = 0; m < vMatherBillEntry.size(); ++m) {
                aPurInWarehsBillInfo.getEntry().add((PurInWarehsEntryInfo)vMatherBillEntry.get(m));
            }
            aPurInWarehsBillInfo.setTotalQty(motherSplitBillTotalAmount.getTotalQty());
            aPurInWarehsBillInfo.setTotalAmount(motherSplitBillTotalAmount.getTTotalAmount());
            aPurInWarehsBillInfo.setTotalLocalAmount(motherSplitBillTotalAmount.getTotalLocalAmount());
            aPurInWarehsBillInfo.setTotalStandardCost(motherSplitBillTotalAmount.getTotalStandardCost());
            aPurInWarehsBillInfo.setTotalActualCost(motherSplitBillTotalAmount.getTotalActualCost());
            aSplitBillInfo.setTotalQty(childSplitBillTotalAmount.getTotalQty());
            aSplitBillInfo.setTotalAmount(childSplitBillTotalAmount.getTTotalAmount());
            aSplitBillInfo.setTotalLocalAmount(childSplitBillTotalAmount.getTotalLocalAmount());
            aSplitBillInfo.setTotalStandardCost(childSplitBillTotalAmount.getTotalStandardCost());
            aSplitBillInfo.setTotalActualCost(childSplitBillTotalAmount.getTotalActualCost());
            flowMap.putAll(InvServerUtils.getBillBizFlowRelation(ctx, idSet, ENTRY_TABLE_NAME));
            ObjectUuidPK pk = new ObjectUuidPK(aPurInWarehsBillInfo.getId());
            this._update(ctx, (IObjectPK)pk, (IObjectValue)aPurInWarehsBillInfo);
            ISysBillFacade sysBillFacade = SysBillFacadeFactory.getLocalInstance(ctx);
            ObjectUuidPK motherPk = new ObjectUuidPK(aPurInWarehsBillInfo.getId().toString());
            ObjectUuidPK childPk = new ObjectUuidPK(aSplitBillInfo.getId().toString());
            EntityViewInfo mView = new EntityViewInfo();
            FilterInfo mfilter = new FilterInfo();
            mfilter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)("*" + aPurInWarehsBillInfo.getNumber())));
            mView.setFilter(mfilter);
            SelectorItemCollection mSelector = new SelectorItemCollection();
            mSelector = new SelectorItemCollection();
            mSelector.add("id");
            mSelector.add("totalInvoicedQty");
            mSelector.add("totalInvoicedBaseQty");
            mSelector.add("totalInvoicedAmount");
            mView.setSelector(mSelector);
            PurOrderEntryCollection purOrderEntrys = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(mView);
            boolean flag = sysBillFacade.delBuildOrderOrReturnBill((IObjectPK)motherPk, aPurInWarehsBillInfo, false);
            aSplitBillInfo.setFiVouchered(aPurInWarehsBillInfo.isFiVouchered());
            aSplitBillInfo.setVoucher(aPurInWarehsBillInfo.getVoucher());
            if (aPurInWarehsBillInfo.isFiVouchered()) {
                voucherRelation.put(aPurInWarehsBillInfo.getId().toString(), aSplitBillInfo.getId());
            }
            this._addnew(ctx, (IObjectValue)aSplitBillInfo);
            if (flag) {
                this.cleanSysbillInfo(aPurInWarehsBillInfo, aSplitBillInfo);
                sysBillFacade.buildOrderOrReturnBill((IObjectPK)motherPk, aPurInWarehsBillInfo, true);
                sysBillFacade.buildOrderOrReturnBill((IObjectPK)childPk, aSplitBillInfo, false);
                if (purOrderEntrys != null && purOrderEntrys.size() > 0) {
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                    Object[] params = null;
                    PurOrderEntryInfo entry = null;
                    String updateSql = "update t_sm_purorderentry set FTotalInvoicedQty = ?,ftotalInvoicedBaseQty = ?,ftotalInvoicedAmount = ? where fid = ?";
                    for (int j = 0; j < purOrderEntrys.size(); ++j) {
                        entry = purOrderEntrys.get(j);
                        params = new Object[]{entry.getTotalInvoicedQty(), entry.getTotalInvoicedBaseQty(), entry.getTotalInvoicedAmount(), entry.getId().toString()};
                        paramList.add(params);
                    }
                    DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
                }
            }
            SplitBillRelationInfo aSplitBillRelationInfo = new SplitBillRelationInfo();
            aSplitBillRelationInfo.setMotherBillID(motherBillID);
            aSplitBillRelationInfo.setMotherBillNumber(motherNumber);
            aSplitBillRelationInfo.setChildBillID(childBillID);
            aSplitBillRelationInfo.setChildBillNumber(childNumber);
            aSplitBillRelationInfo.setStorageOrgUnit(aPurInWarehsBillInfo.getStorageOrgUnit());
            aSplitBillRelationInfo.setBillType(aPurInWarehsBillInfo.getBillType());
            aSplitBillRelationInfo.setSplitTime(new Timestamp(now.getTime()));
            vecSBRelation.add(aSplitBillRelationInfo);
            hsSB.put(motherBillID, vecSBEntryByOneSB);
        }
        this.saveSplitBillRelation(ctx, vecSBRelation, vecSBEntryRelation);
        this.saveBotpRelation(ctx, vecSBRelation);
        this.handleChildBillVoucherBatch(ctx, voucherRelation);
        if (flowMap != null && flowMap.size() > 0 && vecSBEntryRelation != null && vecSBEntryRelation.size() > 0) {
            SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = null;
            String bizFlowRelation = "";
            HashMap<String, String> clildFlowMap = new HashMap<String, String>();
            int num = vecSBEntryRelation.size();
            for (int i = 0; i < num; ++i) {
                aSplitBillEntryRelationInfo = (SplitBillEntryRelationInfo)vecSBEntryRelation.get(i);
                if (aSplitBillEntryRelationInfo == null || StringUtils.isEmpty((String)aSplitBillEntryRelationInfo.getMotherBillEntryID()) || StringUtils.isEmpty((String)aSplitBillEntryRelationInfo.getChildBillEntryID()) || !flowMap.containsKey(aSplitBillEntryRelationInfo.getMotherBillEntryID())) continue;
                bizFlowRelation = (String)flowMap.get(aSplitBillEntryRelationInfo.getMotherBillEntryID()) + "#" + aSplitBillEntryRelationInfo.getChildBillEntryID();
                clildFlowMap.put(aSplitBillEntryRelationInfo.getChildBillEntryID(), bizFlowRelation);
            }
            if (clildFlowMap != null && clildFlowMap.size() > 0) {
                InvServerUtils.writeBizFlowRelation(ctx, clildFlowMap, ENTRY_TABLE_NAME);
            }
        }
    }

    private void handleChildBillVoucherBatch(Context ctx, HashMap voucherRelation) throws EASBizException, BOSException {
        Set set = voucherRelation.keySet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billid", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        IPurInWarehsVoucher ipurWarehs = PurInWarehsVoucherFactory.getLocalInstance(ctx);
        PurInWarehsVoucherCollection purVoucherColl = ipurWarehs.getPurInWarehsVoucherCollection(view);
        PurInWarehsVoucherInfo childPurVoucher = null;
        PurInWarehsVoucherInfo motherPurVoucher = null;
        CoreBaseCollection purChildVoucherColl = new CoreBaseCollection();
        for (int i = 0; i < purVoucherColl.size(); ++i) {
            motherPurVoucher = purVoucherColl.get(i);
            childPurVoucher = (PurInWarehsVoucherInfo)motherPurVoucher.clone();
            childPurVoucher.setId(BOSUuid.create((BOSObjectType)motherPurVoucher.getBOSType()));
            childPurVoucher.setBillID((BOSUuid)voucherRelation.get(motherPurVoucher.getBillID().toString()));
            purChildVoucherColl.add((CoreBaseInfo)childPurVoucher);
        }
        ipurWarehs.save(purChildVoucherColl);
    }

    private void handleChildBillVoucher(Context ctx, PurInWarehsBillInfo motherInfo, PurInWarehsBillInfo childInfo) throws EASBizException, BOSException {
        if (motherInfo.isFiVouchered()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fid from t_im_purinwarehsvoucher where fbillid = '" + motherInfo.getId().toString() + "'"));
            ObjectUuidPK pk = null;
            try {
                while (rs.next()) {
                    pk = new ObjectUuidPK(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (pk == null) {
                return;
            }
            IPurInWarehsVoucher ipurWarehs = PurInWarehsVoucherFactory.getLocalInstance(ctx);
            PurInWarehsVoucherInfo purVoucher = ipurWarehs.getPurInWarehsVoucherInfo((IObjectPK)pk);
            PurInWarehsVoucherInfo childPurVoucher = (PurInWarehsVoucherInfo)purVoucher.clone();
            childPurVoucher.setId(BOSUuid.create((BOSObjectType)purVoucher.getBOSType()));
            childPurVoucher.setBillID(childInfo.getId());
            ipurWarehs.save(childPurVoucher);
        }
    }

    private void saveBotpRelation(Context ctx, Vector vecSBRelation) throws EASBizException, BOSException {
        if (null == vecSBRelation || vecSBRelation.size() == 0) {
            return;
        }
        String insertBotpRelationSql = "insert into T_BOT_RELATION (FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FDate,FOperatorID,FisEffected,FBOTMappingID,FType) values (?,?,?,?,?,?,?,?,?,?)";
        String insertBotpRelationEntrySql = "insert into T_BOT_RelationEntry(FID, FSRCOBJECTID, FDESTOBJECTID, FSRCENTRYID, FDESTENTRYID, FSRCENTRYPROPNAME, FDESTENTRYPROPNAME, FSRCPROPERTYNAME, FDESTPROPERTYNAME, FVALUE, FKEYID)values (?, ?, ?, ?, ?, N'__src.entry', N'__dest.entry', null, N'id', null, ?)";
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        PreparedStatement insertMotherRelationStmt = null;
        String motherBillID = null;
        String keyID = null;
        BOTRelationInfo aBOTRelationInfo = null;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            insertMotherRelationStmt = conn.prepareStatement(insertBotpRelationSql);
            for (int i = 0; i < vecSBRelation.size(); ++i) {
                int n;
                SplitBillRelationInfo aSplitBillRelationInfo = (SplitBillRelationInfo)vecSBRelation.get(i);
                motherBillID = aSplitBillRelationInfo.getMotherBillID();
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)motherBillID));
                ev.setFilter(filter);
                BOTRelationCollection botpColl = ibotRelation.getCollection(ev);
                for (int n2 = 0; n2 < botpColl.size(); ++n2) {
                    aBOTRelationInfo = botpColl.get(n2);
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, true);
                }
                filter.getFilterItems().clear();
                botpColl = null;
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)motherBillID));
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"48DA3A71"));
                ev.setFilter(filter);
                botpColl = ibotRelation.getCollection(ev);
                String selectSql = "select FIsBizBill From T_AP_OtherBill Where Fid = ''{0}''";
                String formatSql = null;
                IRowSet rs = null;
                aBOTRelationInfo = null;
                keyID = "";
                boolean isBizBill = false;
                int nCount = botpColl.size();
                for (n = 0; n < nCount; ++n) {
                    aBOTRelationInfo = botpColl.get(n);
                    formatSql = MessageFormat.format(selectSql, aBOTRelationInfo.getDestObjectID());
                    rs = DBUtil.executeQuery((Context)ctx, (String)formatSql);
                    if (!rs.next() || !(isBizBill = rs.getBoolean("FIsBizBill"))) continue;
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, false);
                }
                filter.getFilterItems().clear();
                botpColl = null;
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)motherBillID));
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"48DA3A71", CompareType.NOTEQUALS));
                ev.setFilter(filter);
                botpColl = ibotRelation.getCollection(ev);
                nCount = botpColl.size();
                for (n = 0; n < nCount; ++n) {
                    aBOTRelationInfo = botpColl.get(n);
                    keyID = BOSUuid.create((BOSObjectType)aBOTRelationInfo.getBOSType()).toString();
                    this.setMotherRelationStmt(insertMotherRelationStmt, keyID, aBOTRelationInfo, aSplitBillRelationInfo, false);
                }
            }
            insertMotherRelationStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (insertMotherRelationStmt != null) {
                    insertMotherRelationStmt.clearBatch();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            SQLUtils.cleanup((Statement)insertMotherRelationStmt);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void setNULLToZERO(IObjectValue invBill) {
        super.setNULLToZERO(invBill);
        PurInWarehsBillInfo billInfo = (PurInWarehsBillInfo)invBill;
        PurInWarehsEntryCollection entryCol = billInfo.getEntry();
        PurInWarehsEntryInfo entryInfo = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            if (entryInfo.getBizDate() != null) continue;
            entryInfo.setBizDate(billInfo.getBizDate());
        }
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getPurInWarehsBillSelector((boolean)true);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInWarehsBillInfo info = this.getPurInWarehsBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PurInWarehsBillInfo info = this.getPurInWarehsBillInfo(ctx, pk, this.getSelector());
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)"T_IM_PurInWarehsBill");
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurInWarehsBillInfo info = this.getPurInWarehsBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurInWarehsBillInfo info = this.getPurInWarehsBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected String _getChildNumber(Context ctx, String number) throws BOSException, EASBizException {
        return this.getChildNumber(ctx, number, 0);
    }

    private boolean getIsEvaluate(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo) throws BOSException, EASBizException {
        boolean isEvaluate = true;
        if (null != evaluateMap.get(ficompanyOrgInfo.getId().toString())) {
            isEvaluate = (Boolean)evaluateMap.get(ficompanyOrgInfo.getId().toString());
            return isEvaluate;
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        if (ficompanyOrgInfo != null && ficompanyOrgInfo.getId() != null) {
            isEvaluate = Boolean.valueOf(iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId().toString()), "SCM_CAL_011"));
            evaluateMap.put(ficompanyOrgInfo.getId().toString(), isEvaluate);
        }
        return isEvaluate;
    }

    public CompanyOrgUnitInfo getCompanyInfo(Context ctx, BOSUuid souId) throws EASBizException, BOSException {
        if (souId == null) {
            return null;
        }
        if (null != sou2couMap.get(souId.toString())) {
            return (CompanyOrgUnitInfo)sou2couMap.get(souId.toString());
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
        sou2couMap.put(souId.toString(), ret);
        return ret;
    }

    private void dealPurChaseFee(Context ctx, PurInWarehsBillInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo ficompanyOrgInfo = this.getCompanyInfo(ctx, info.getStorageOrgUnit().getId());
        boolean isEvaluate = this.getIsEvaluate(ctx, ficompanyOrgInfo);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            PurInWarehsEntryInfo entry = info.getEntry().get(i);
            if (!entry.isIsPresent() && isEvaluate) continue;
            entry.setPurchaseFee(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private String fillSign(String str, int totalLength, Object fillSign) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= totalLength || fillSign == null || fillSign.toString().trim().length() == 0) {
            return str;
        }
        StringBuffer sbStr = new StringBuffer();
        StringBuffer sbFill = new StringBuffer();
        sbStr.append(str);
        for (int i = 0; i < totalLength - str.length(); ++i) {
            sbFill.append(fillSign);
        }
        return sbFill.append(sbStr).toString();
    }

    private boolean existNumber(Context ctx, String number) throws BOSException {
        if (null == number || "".equals(number.trim())) {
            return false;
        }
        String sql = "select fid from T_IM_PurInwarehsBill where fnumber ='" + number.trim() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        return null != rowSet && rowSet.size() > 0;
    }

    @Override
    protected void setBotpRelationEntry(Context ctx, PreparedStatement insertBotpRelationEntryStmt, String srcObjectID, String destObjectID, String keyID, boolean isChildBill) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if (isChildBill) {
            sql.append(" select sb.FChildBillEntryID as fsrcentryid, e.fid as fdestentryid ").append(" from t_ap_otherbillentry e ").append(" inner join t_ap_otherbill b on e.fparentid = b.fid ").append(" inner join T_IM_SplitBillEntryRelation sb on sb.FMotherBillEntryID = e.FSourceBillEntryID ").append(" where b.fid = '").append(destObjectID).append("' ");
            this.setBotpRelationEntry(ctx, sql.toString(), insertBotpRelationEntryStmt, srcObjectID, destObjectID, keyID);
            sql.setLength(0);
            sql.append(" select b.fid as fdestobjid, sb.FChildBillEntryID as fsrcentryid, e.fid as fdestentryid ").append(" from t_ap_otherbillentry e ").append(" inner join t_ap_otherbill b on e.fparentid = b.fid ").append(" inner join t_ap_otherbillentry ee on e.fsourcebillentryid = ee.fid ").append(" inner join T_IM_SplitBillEntryRelation sb on sb.FMotherBillEntryID = ee.FSourceBillEntryID ").append(" where b.fid = '").append(destObjectID).append("' ");
            this.setBotpRelationEntry(ctx, sql.toString(), insertBotpRelationEntryStmt, srcObjectID, null, keyID);
        } else {
            sql.append(" select e.FSourceBillEntryID as fsrcentryid, e.fid as fdestentryid ").append(" from t_ap_otherbillentry e ").append(" inner join t_ap_otherbill b on e.fparentid = b.fid ").append(" where b.fid = '").append(destObjectID).append("' ");
            this.setBotpRelationEntry(ctx, sql.toString(), insertBotpRelationEntryStmt, srcObjectID, destObjectID, keyID);
            sql.setLength(0);
            sql.append(" select b.fid as fdestobjid, ee.FSourceBillEntryID as fsrcentryid, e.fid as fdestentryid ").append(" from t_ap_otherbillentry e ").append(" inner join t_ap_otherbill b on e.fparentid = b.fid ").append(" inner join t_ap_otherbillentry ee on e.fsourcebillentryid = ee.fid ").append(" where b.fid = '").append(destObjectID).append("' ");
            this.setBotpRelationEntry(ctx, sql.toString(), insertBotpRelationEntryStmt, srcObjectID, null, keyID);
        }
    }

    protected void setBotpRelationEntry(Context ctx, String sql, PreparedStatement insertBotpRelationEntryStmt, String srcObjectID, String destObjectID, String keyID) throws SQLException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String srcEntryID = null;
        String destEntryID = null;
        String id = null;
        while (rs.next()) {
            srcEntryID = rs.getString("fsrcentryid");
            destEntryID = rs.getString("fdestentryid");
            if (StringUtil.isEmpty((String)srcEntryID) || StringUtil.isEmpty((String)destEntryID)) continue;
            id = BOSUuid.create((String)"B99C354C").toString();
            insertBotpRelationEntryStmt.setString(1, id);
            insertBotpRelationEntryStmt.setString(2, srcObjectID);
            if (StringUtil.isEmpty((String)destObjectID)) {
                destObjectID = rs.getString("fdestobjid");
            }
            insertBotpRelationEntryStmt.setString(3, destObjectID);
            insertBotpRelationEntryStmt.setString(4, srcEntryID);
            insertBotpRelationEntryStmt.setString(5, destEntryID);
            insertBotpRelationEntryStmt.setString(6, keyID);
            insertBotpRelationEntryStmt.addBatch();
        }
    }

    protected void allUnWritedSplit(Context ctx, PurInWarehsBillInfo model, Date bizDate, boolean isBillSplitChangeDate) throws BOSException, EASBizException {
        if (model == null || !(model instanceof PurInWarehsBillInfo)) {
            throw new SplitBillException(SplitBillException.BILLNULLORBILLTYPEERROR);
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getId());
        SelectorItemCollection selector = SCMSelectorFactory.getPurInWarehsBillSelector((boolean)true);
        PurInWarehsBillInfo childInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)pk, this.addSelectors(selector));
        if (null != bizDate) {
            childInfo.setBizDate(bizDate);
            StorageOrgUnitInfo sou = childInfo.getStorageOrgUnit();
            CompanyOrgUnitInfo cou = null;
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            cou = iSCMBillCommonFacade.getCompanyInfo(sou.getId());
            PeriodInfo bizPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)childInfo.getBizDate(), (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
            childInfo.setYear(bizPeriodInfo.getPeriodYear());
            childInfo.setPeriod(bizPeriodInfo.getPeriodNumber());
            SimpleDateFormat df1 = new SimpleDateFormat("yyyyMM");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd");
            String str1 = df1.format(bizDate);
            String str2 = df2.format(bizDate);
            childInfo.setMonth(Integer.parseInt(str1));
            childInfo.setDay(Integer.parseInt(str2));
            int size = childInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                childInfo.getEntry().get(i).setBizDate(bizDate);
            }
        }
        ctx.put((Object)"SPLIT_ACTION", (Object)Boolean.TRUE);
        IPurInWarehsBill purInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        purInWarehsBill.update((IObjectPK)new ObjectUuidPK(childInfo.getId()), (CoreBaseInfo)childInfo);
    }

    protected SelectorItemCollection addSelectors(SelectorItemCollection selector) {
        return selector;
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurInWarehsBillInfo billInfo = null;
        billInfo = isUseAgent ? PurInWarehsBillAgent.create() : new PurInWarehsBillInfo();
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "purinwarehs_new");
        if (sou == null) {
            return billInfo;
        }
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)sou.getId().toString()));
        if (cou != null && cou.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = cou.getBaseCurrency().getName() != null ? cou.getBaseCurrency() : CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()), this.getCurrencySelectors());
            billInfo.setCurrency(baseCurrInfo);
            billInfo.setExchangeRate(new BigDecimal(1));
        }
        billInfo.setPaymentType(this.getAPaymentTypeInfo(ctx));
        if (cou != null) {
            billInfo.setStorageOrgUnit(sou);
        }
        billInfo.setTotalStandardCost(ZERO);
        billInfo.setTotalActualCost(ZERO);
        billInfo.setReceiptAmount(ZERO);
        billInfo.setTotalQty(ZERO);
        billInfo.setHasEffected(false);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        billInfo.setIsInTax(true);
        billInfo.setIsPriceInTax(true);
        Calendar cal = Calendar.getInstance();
        Timestamp date = new Timestamp(cal.getTimeInMillis());
        billInfo.setBizDate(date);
        billInfo.setCreateTime(date);
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        billInfo.setCreator(aUserInfo);
        String bizTypeID = "";
        boolean isSubContractBill = false;
        if (ctx.get((Object)"isSubContractBill") != null) {
            isSubContractBill = (Boolean)ctx.get((Object)"isSubContractBill");
        }
        bizTypeID = isSubContractBill ? "1x7KMBq4mUmpj58T4jNPqiQHQ1w=" : "d8e80652-0106-1000-e000-04c5c0a812202407435C";
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)bizTypeID, (String)"50957179-0105-1000-e000-015fc0a812fd463ED552");
        billInfo.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-015fc0a812fd463ED552", bizType.getId().toString());
            billInfo.setTransactionType(tti);
        }
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
        aBillTypeInfo.setNumber("103");
        billInfo.setBillType(aBillTypeInfo);
        billInfo.setFiVouchered(false);
        billInfo.setExchangeRate(SCMUtil.BIGDECIMAL_ONE);
        PurInWarehsEntryInfo entryInfo = (PurInWarehsEntryInfo)this.createNewDetailData(ctx);
        PurchaseOrgUnitInfo aPurchaseOrgUnitInfo = this.getPurchaseOrgUnitBySou(ctx, sou.getId().toString());
        entryInfo.setPurchaseOrgUnit(aPurchaseOrgUnitInfo);
        entryInfo.setStorageOrgUnit(sou);
        entryInfo.setCompanyOrgUnit(cou);
        if (billInfo.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType(ctx, "50957179-0105-1000-e000-015fc0a812fd463ED552", billInfo.getTransactionType());
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        billInfo.getEntry().add(entryInfo);
        billInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        return billInfo;
    }

    public PaymentTypeInfo getAPaymentTypeInfo(Context ctx) throws BOSException, EASBizException {
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("name"));
        selectorItemCollection.add(new SelectorItemInfo("number"));
        PaymentTypeInfo aPaymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"), selectorItemCollection);
        return aPaymentTypeInfo;
    }

    public IObjectValue createNewDetailData(Context ctx) throws BOSException, EASBizException {
        PurInWarehsEntryAgent entryInfo = PurInWarehsEntryAgent.create();
        entryInfo.setBaseStatus(EntryBaseStatusEnum.NULL);
        entryInfo.setUnWriteOffQty(ZERO);
        entryInfo.setBaseQty(ZERO);
        entryInfo.setWrittenOffQty(ZERO);
        entryInfo.setWrittenOffAmount(ZERO);
        entryInfo.setUnWriteOffBaseQty(ZERO);
        entryInfo.setUnWriteOffAmount(ZERO);
        entryInfo.setUnitActualCost(ZERO);
        entryInfo.setActualCost(ZERO);
        entryInfo.setAssociateQty(ZERO);
        entryInfo.setUnReturnedBaseQty(ZERO);
        entryInfo.setPrice(ZERO);
        entryInfo.setTax(ZERO);
        entryInfo.setTaxPrice(ZERO);
        entryInfo.setDiscountAmount(ZERO);
        entryInfo.setDiscountRate(ZERO);
        entryInfo.setActualPrice(ZERO);
        entryInfo.setActualTaxPrice(ZERO);
        entryInfo.setLocalTax(ZERO);
        entryInfo.setAmount(ZERO);
        entryInfo.setTaxAmount(ZERO);
        entryInfo.setPurchaseCost(ZERO);
        entryInfo.setPurchaseFee(ZERO);
        entryInfo.setUnitPurchaseCost(ZERO);
        entryInfo.setLocalTax(ZERO);
        entryInfo.setLocalTaxAmount(ZERO);
        entryInfo.setUnitActualCost(ZERO);
        entryInfo.setActualCost(ZERO);
        entryInfo.setUnitStandardCost(ZERO);
        entryInfo.setStandardCost(ZERO);
        entryInfo.setMaterialCost(ZERO);
        entryInfo.setAssociateQty(ZERO);
        entryInfo.setUnReturnedBaseQty(ZERO);
        entryInfo.setDosingType(DosingTypeEnum.MANUAL);
        entryInfo.setReverseQty(ZERO);
        entryInfo.setReverseBaseQty(ZERO);
        entryInfo.setScWrittenOffBaseQty(ZERO);
        entryInfo.setScWrittenOffQty(ZERO);
        entryInfo.setImputedCost(ZERO);
        entryInfo.setScUnWrittenOffBaseQty(ZERO);
        entryInfo.setScUnWrittenOffQty(ZERO);
        entryInfo.setReturnBaseQty(ZERO);
        entryInfo.setReturnsQty(ZERO);
        entryInfo.setReceiveAmount(ZERO);
        entryInfo.setDrewBaseQty(ZERO);
        entryInfo.setDrewQty(ZERO);
        return entryInfo;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        OrgUnitCollection coll;
        PurchaseOrgUnitInfo pou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        pou = (PurchaseOrgUnitInfo)iOrgUnitRelation.getDefaultToUnit(souId, 4, 3);
        if (pou == null && (coll = iOrgUnitRelation.getToUnit(souId, 4, 3)) != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(souId)) continue;
                pou = (PurchaseOrgUnitInfo)coll.get(i);
                break;
            }
            if (pou == null && coll.get(0) != null) {
                pou = (PurchaseOrgUnitInfo)coll.get(0);
            }
        }
        return pou;
    }

    private SelectorItemCollection getCurrencySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private void insertRootSplitRelation(Context ctx, PurInWarehsBillInfo aPurInWarehsBillInfo) throws BOSException {
        String rootId = aPurInWarehsBillInfo.getId().toString();
        String billNumber = aPurInWarehsBillInfo.getNumber();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_IV_RelationOfChildAndParent (FID,FDocumentType,FMotherNumber,FMotherId,FMotherEntryId,FChildNumber,FChildId,FChildEntryId,FIsUnAudit,FRootID) ");
        sql.append(" VALUES ( ?,?,?,?,?,?,?,?,?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BOSUuid.create((String)"88888888").toString(), EASResource.getString((String)RES_InvUI, (String)"PurInWarehs"), " ", " ", " ", billNumber, rootId, " ", 0, rootId});
    }

    @Override
    public void synUnWriteOffQty(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallServices();
        super.synUnWriteOffQty(ctx, pk);
    }

    private void checkInvoiced(Context ctx, List<String> idSet) throws BOSException, InvBizException {
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        if (!CommonUtils.hasCFField((Context)ctx)) {
            return;
        }
        StringBuffer idStr = new StringBuffer();
        for (String purId : idSet) {
            idStr.append("'");
            idStr.append(purId);
            idStr.append("',");
        }
        idStr.deleteCharAt(idStr.length() - 1);
        StringBuffer sql = new StringBuffer();
        sql.append("select b.fnumber as num from T_IM_PURINWAREHSENTRY en ");
        sql.append("inner join T_IM_PURINWAREHSBILL b on b.FID = en.FPARENTID ");
        sql.append("inner join T_BD_SUPPLIER s on s.fid = b.fsupplierid ");
        sql.append("where b.FID in (" + idStr + ") and en.CFisContrastDrew = 1 and s.cfIsSrm = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new InvBizException(InvBizException.PURINWAREHS_INVOICED, new Object[]{rs.getString("num")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkSplit(Context ctx, PurInWarehsBillCollection collection, HashMap param) throws BOSException, InvBizException {
        Boolean isWriteOffOver = true;
        PurInWarehsBillInfo aPurInWarehsBillInfo = null;
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < collection.size(); ++i) {
            ids.add(collection.get(i).getId().toString());
            aPurInWarehsBillInfo = collection.get(i);
            if (param.get("WrittenOffSplit") == null || !"WrittenOffSplit".equals(param.get("WrittenOffSplit").toString()) || this.isWriteOffOver(aPurInWarehsBillInfo)) continue;
            isWriteOffOver = false;
            break;
        }
        if (!isWriteOffOver.booleanValue()) {
            this.checkInvoiced(ctx, ids);
        }
    }

    @Override
    public void synPurInrehsBill4VMI(Context ctx, List pks) throws BOSException, EASBizException {
        ServiceStateManager.getInstance().enableNextCallServices();
        super.synPurInrehsBill4VMI(ctx, pks);
    }

    @Override
    protected void _synPurInrehsBill4VMI(Context ctx, List pks) throws BOSException, EASBizException {
    }
}

