/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.app.AbstractPurInWarehsWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.PurContractCollection;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.util.InvWebUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurInWarehsWebFacadeControllerBean
extends AbstractPurInWarehsWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.PurInWarehsWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        Map<String, BillTypeInfo> map = new HashMap();
        if (StringUtils.isEmpty((String)oprtState)) {
            return null;
        }
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            map = this.getMap(ctx, null);
        } else if (!OprtStateConstant.EDIT.equals(oprtState) && OprtStateConstant.VIEW.equals(oprtState)) {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            PurInWarehsBillInfo info = this.getBillInfoById(ctx, id);
            map.put("sourceBillType", info.getSourceBillType());
            map.putAll(this._getInitData(ctx, (IObjectValue)info, oprtState));
        }
        return map;
    }

    private PurInWarehsBillInfo getBillInfoById(Context ctx, String id) throws BOSException, EASBizException {
        return PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(id));
    }

    private Map getMap(Context ctx, PurInWarehsBillInfo info) {
        return null;
    }

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou;
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        info.setPaymentType(this.getAPaymentTypeInfo(ctx));
        info.setTotalStandardCost(ZERO);
        info.setTotalActualCost(ZERO);
        info.setReceiptAmount(ZERO);
        info.setTotalQty(ZERO);
        info.setHasEffected(false);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setIsInTax(true);
        info.setIsPriceInTax(true);
        Timestamp date = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        info.setBizDate(date);
        info.setCreateTime(date);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setCreator(user);
        String bizTypeID = "";
        bizTypeID = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)bizTypeID, (String)"50957179-0105-1000-e000-015fc0a812fd463ED552");
        info.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-015fc0a812fd463ED552", bizType.getId().toString());
            info.setTransactionType(tti);
        }
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
        aBillTypeInfo.setNumber("103");
        info.setBillType(aBillTypeInfo);
        info.setFiVouchered(false);
        info.setPcVouchered(false);
        info.setExchangeRate(SCMUtil.BIGDECIMAL_ONE);
        PurInWarehsEntryInfo entryInfo = (PurInWarehsEntryInfo)this.createNewDetailData(ctx, (IObjectValue)info);
        info.getEntry().add(entryInfo);
        StorageOrgUnitInfo sou = null;
        sou = info.getStorageOrgUnit() != null ? info.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "purinwarehs_new");
        info.setStorageOrgUnit(sou);
        if (sou == null) {
            return info;
        }
        if (sou.getCU() != null) {
            info.setCU(sou.getCU());
        }
        if ((cou = this.getCouBySou(ctx, sou.getId().toString())) != null && cou.getBaseCurrency() != null) {
            info.setCurrency(this.getBaseCurrencyByCou(ctx, cou));
            info.setExchangeRate(new BigDecimal(1));
        }
        entryInfo.setPurchaseOrgUnit(this.getPurchaseOrgUnitBySou(ctx, sou.getId().toString()));
        entryInfo.setStorageOrgUnit(sou);
        entryInfo.setCompanyOrgUnit(cou);
        if (info.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType("50957179-0105-1000-e000-015fc0a812fd463ED552", info.getTransactionType());
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        info.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        return info;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager;
        CodingRuleInfo ruleInfo;
        int i;
        FilterInfo filter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        String storageOrgFilter = this.getMainOrgFilter(ctx);
        map.put("storageOrgFilter", storageOrgFilter);
        if (info.getStorageOrgUnit() == null) {
            return map;
        }
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getStorageOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        if (info.getSourceBillType() == null) {
            map.put("pou", this.getPurchaseOrgUnitBySou(ctx, info.getStorageOrgUnit().getId().toString()));
        }
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        if (info.getSupplier() != null) {
            map.put("supplier", SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getSupplier().getId().toString())));
        }
        if (info.getTransactionType() != null) {
            map.put("transactionType", this.getTransactionTypeInfo(ctx, info.getTransactionType().getId().toString()));
        }
        PurInWarehsEntryInfo entry = null;
        PurchaseOrgUnitInfo pou = null;
        WarehouseInfo warehouseInfo = null;
        HashSet<String> warehouseIdSet = new HashSet<String>();
        HashSet<String> contractNumberSet = new HashSet<String>();
        PurInWarehsEntryCollection entryColl = info.getEntry();
        HashMap<String, Map> entryParamMap = new HashMap<String, Map>();
        for (int i2 = 0; i2 < entryColl.size(); ++i2) {
            entry = entryColl.get(i2);
            pou = entry.getPurchaseOrgUnit();
            if (pou != null && !entryParamMap.containsKey(pou.getId().toString())) {
                entryParamMap.put(pou.getId().toString(), this.batchGetParamValue(ctx, pou.getId().toString(), new String[]{"PURORDER003", "PURJICHU001"}));
            }
            if ((warehouseInfo = entry.getWarehouse()) != null) {
                warehouseIdSet.add(warehouseInfo.getId().toString());
            }
            if (entry.getContractNumber() == null) continue;
            contractNumberSet.add(entry.getContractNumber());
        }
        map.put("entryParamMap", entryParamMap);
        if (warehouseIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("hasLocation"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", warehouseIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            WarehouseCollection warehouseCollection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
            HashMap<String, WarehouseInfo> warehouseMap = new HashMap<String, WarehouseInfo>();
            for (i = 0; i < warehouseCollection.size(); ++i) {
                warehouseMap.put(warehouseCollection.get(i).getId().toString(), warehouseCollection.get(i));
            }
            map.put("warehouseMap", warehouseMap);
        }
        if (contractNumberSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", contractNumberSet, CompareType.INCLUDE));
            view.setFilter(filter);
            PurContractCollection purContractCollection = PurContractFactory.getLocalInstance((Context)ctx).getPurContractCollection(view);
            HashMap<String, PurContractInfo> contractMap = new HashMap<String, PurContractInfo>();
            for (i = 0; i < purContractCollection.size(); ++i) {
                contractMap.put(purContractCollection.get(i).getNumber(), purContractCollection.get(i));
            }
            map.put("contractMap", contractMap);
        }
        Map paramMap = this.getParamsMap(ctx, info.getStorageOrgUnit().getId().toString(), cou.getId().toString());
        map.put("params", paramMap);
        String isSplitBill = (String)info.get("isSplitBill");
        if (Boolean.TRUE.toString().equals(paramMap.get("INM101")) && isSplitBill != null && "1".equals(isSplitBill)) {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo(null, (Date)info.getBizDate(), (CompanyOrgUnitInfo)cou);
            if (pInfo.getNumber() >= periodInfo.getNumber()) {
                PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)pInfo);
                if (nextPeriodInfo == null) {
                    throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"nextAccountingPeriod")});
                }
                if (nextPeriodInfo.isIsAdjustPeriod()) {
                    map.put("childDate", PeriodUtils.getNextPeriodInfo((PeriodInfo)nextPeriodInfo).getBeginDate());
                } else {
                    map.put("childDate", nextPeriodInfo.getBeginDate());
                }
            }
        }
        if (info.getStorageOrgUnit().getCU() != null) {
            info.setCU(info.getStorageOrgUnit().getCU());
        }
        if ((ruleInfo = (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).getCodingRule((IObjectValue)new PurInWarehsBillInfo(), info.getStorageOrgUnit().getId().toString())) != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        return map;
    }

    private TransactionTypeInfo getTransactionTypeInfo(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("isWriteOff"));
        sic.add(new SelectorItemInfo("isCalculate"));
        sic.add(new SelectorItemInfo("isManuCostCalculate"));
        sic.add(new SelectorItemInfo("isManuCheckAccount"));
        sic.add(new SelectorItemInfo("riType.id"));
        sic.add(new SelectorItemInfo("riType.bizDirection"));
        sic.add(new SelectorItemInfo("riType.rI"));
        TransactionTypeInfo info = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    @Override
    protected Map _handleOrgChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = (String)requestMap.get("orgId");
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        responseMap.put("cou", cou);
        PurchaseOrgUnitInfo pou = this.getPurchaseOrgUnitBySou(ctx, orgId);
        responseMap.put("pou", pou);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        responseMap.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        HashMap<String, Map> entryParamMap = new HashMap<String, Map>();
        if (pou != null) {
            entryParamMap.put(pou.getId().toString(), this.batchGetParamValue(ctx, pou.getId().toString(), new String[]{"PURORDER003"}));
        }
        responseMap.put("entryParamMap", entryParamMap);
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        return responseMap;
    }

    public PaymentTypeInfo getAPaymentTypeInfo(Context ctx) throws BOSException, EASBizException {
        PaymentTypeInfo aPaymentTypeInfo = null;
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        selectorItemCollection.add(new SelectorItemInfo("name"));
        selectorItemCollection.add(new SelectorItemInfo("number"));
        aPaymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"), selectorItemCollection);
        return aPaymentTypeInfo;
    }

    public IObjectValue createNewDetailData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInWarehsEntryInfo entryInfo = new PurInWarehsEntryInfo();
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        entryInfo.setPurchaseCost(ZERO);
        entryInfo.setIsPresent(false);
        entryInfo.setDosingType(DosingTypeEnum.MANUAL);
        return entryInfo;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        OrgUnitCollection coll;
        PurchaseOrgUnitInfo pou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        pou = (PurchaseOrgUnitInfo)iOrgUnitRelation.getDefaultToUnit(souId, 4, 3);
        if (pou == null && (coll = iOrgUnitRelation.getToUnit(souId, 4, 3)) != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(souId)) continue;
                pou = (PurchaseOrgUnitInfo)coll.get(i);
                break;
            }
            if (pou == null && coll.get(0) != null) {
                pou = (PurchaseOrgUnitInfo)coll.get(0);
            }
        }
        return pou;
    }

    public String getPermissionItem() {
        return "purinwarehs_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        Map paramMap = this.batchGetParamValue(ctx, souId, new String[]{"INM101", "INM008", "PURINWAREHS_COST_ISFILTER"});
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[]{"SCM_CAL_011"});
        paramMap.putAll(couParamMap);
        return paramMap;
    }

    @Override
    protected void _checkSplitBillByWrittenOff(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList orgIDs = (ArrayList)paramMap.get("ids");
        String billIdStr = (String)paramMap.get("billIds");
        String[] billIdArr = billIdStr.split(",");
        List<String> billIds = Arrays.asList(billIdArr);
        this.checkBillSamePeriod(ctx, billIds);
        this.chekOrgSamePeriod(ctx, orgIDs);
    }

    private void checkBillSamePeriod(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids.size() <= 1) {
            return;
        }
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("period"));
        selector.add(new SelectorItemInfo("year"));
        view.setSelector(selector);
        PurInWarehsBillCollection collection = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(view);
        if (collection != null && collection.size() <= 1) {
            return;
        }
        HashSet<Integer> yearSet = new HashSet<Integer>();
        HashSet<Integer> periodSet = new HashSet<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            yearSet.add(collection.get(i).getYear());
            periodSet.add(collection.get(i).getPeriod());
        }
        if (yearSet.size() > 1 || periodSet.size() > 1) {
            String errHeadStr = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SplitBillResource", (String)"allBillHasNotSamePeriod");
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{errHeadStr});
        }
    }

    private void chekOrgSamePeriod(Context ctx, List orgIDs) throws BOSException, EASBizException, SplitBillException {
        Object errHeadStr = null;
        if (orgIDs != null && orgIDs.size() > 1) {
            int size = orgIDs.size();
            BOSUuid[] bosIDs = new BOSUuid[size];
            for (int index = 0; index < size; ++index) {
                if (orgIDs.get(index) == null) continue;
                bosIDs[index] = BOSUuid.read((String)((String)orgIDs.get(index)));
            }
            ISCMBillCommonFacade iScmBillCommon = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            Map map = iScmBillCommon.getCompanyInfos(bosIDs);
            HashMap compareMap = new HashMap();
            HashSet<String> couSet = new HashSet<String>();
            if (map != null) {
                Set set = map.keySet();
                for (String id : set) {
                    CompanyOrgUnitInfo company;
                    if (map.get(id) == null || (company = (CompanyOrgUnitInfo)map.get(id)) == null) continue;
                    couSet.add(company.getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", couSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)SystemEnum.INVENTORYMANAGEMENT));
                view.setFilter(filter);
                SystemStatusCtrolCollection coll = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(view);
                HashSet<String> periodIdSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    periodIdSet.add(coll.get(i).getCurrentPeriod() == null ? null : coll.get(i).getCurrentPeriod().getId().toString());
                }
                if (periodIdSet.size() > 1) {
                    throw new SplitBillException(SplitBillException.ALLCOUHASNOTSAMEPERIOD);
                }
            }
        }
    }

    @Override
    protected Map _isPurInWarehsBillSplitChangeDate(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Comparable<Boolean>> resultMap = new HashMap<String, Comparable<Boolean>>();
        String billTypeId = (String)paramMap.get("billTypeId");
        String storageUnitID = (String)paramMap.get("souId");
        String billBizDate = (String)paramMap.get("billBizDate");
        boolean isChangeDate = false;
        Date bizDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (billBizDate != null) {
                bizDate = dateFormat.parse(billBizDate);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        sou.setId(BOSUuid.read((String)storageUnitID));
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, sou);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Timestamp currentLastDate = null;
        currentLastDate = billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate()) ? currentPeriodinfo.getEndDate() : billPeriodInfo.getEndDate();
        long time = ((Date)currentLastDate).getTime() + 86400000L;
        Date nextDate = new Date(time);
        if (!billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate())) {
            isChangeDate = InvWebUtils.isSaleIssueBillSplitChangeDate((String)billTypeId, (String)storageUnitID);
        }
        resultMap.put("isChangeDate", Boolean.valueOf(isChangeDate));
        resultMap.put("nextDate", nextDate);
        resultMap.put("beginDate", currentPeriodinfo.getBeginDate());
        return resultMap;
    }
}

