/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotFrame;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.FetchSupplyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.BatchFetchDataUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.PurReceivalBillAgent;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryAgent;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalException;
import com.kingdee.eas.scm.im.inv.app.AbstractPurReceivalBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurReceivalBillControllerBean
extends AbstractPurReceivalBillControllerBean {
    private static final long serialVersionUID = -4455363194637923283L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.PurReceivalBillControllerBean");

    @Override
    protected boolean isCheckBizDate() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected boolean isCheckSourceBill() {
        return true;
    }

    protected void checkMoveAveMatForSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurReceivalBillInfo info = (PurReceivalBillInfo)model;
        if (info.getPurchaseType() != null && info.getPurchaseType().getValue() == 1) {
            ArrayList<String> matNumList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct mi.FNumber ");
            sb.append(" from T_IM_PurReceivalEntry entry ");
            sb.append(" left join T_IM_PurReceivalBill bill on entry.FParentID = bill.FID ");
            sb.append(" left join T_BD_MaterialCompanyInfo mc on entry.FMaterialID = mc.FMaterialID ");
            sb.append(" inner join T_BD_Material mi on entry.FMaterialID = mi.FID ");
            sb.append(" where bill.FID = '").append(pk.toString()).append("'");
            sb.append(" and mi.FIsOutsourcedPart = 1 ");
            sb.append(" and mc.FAccountType = ").append(1);
            sb.append(" and mc.FCompanyID in ");
            sb.append(" (select top 1 FToUnitID from T_ORG_UnitRelation ur ");
            sb.append(" inner join T_ORG_TypeRelation tr on ur.FTypeRelationID = tr.FID ");
            sb.append(" where FFromUnitID = (select FStorageOrgUnitID from T_IM_PurReceivalBill where FID ='").append(pk.toString()).append("') ");
            sb.append(" and tr.FFromType = ").append(4);
            sb.append(" and tr.FToType = ").append(1).append(") ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    matNumList.add(rs.getString("FNumber"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sb.setLength(0);
            sb.append("\n");
            int count = matNumList.size();
            for (int i = 0; i < count; ++i) {
                sb.append(matNumList.get(i)).append("\r\n");
            }
            if (count > 0) {
                throw new SCMBillException(SCMBillException.CANNOT_BE_MOVEAGEMAT_IN_SUBCONSTRACT, new Object[]{sb.toString()});
            }
        }
    }

    protected void checkIsStart(Context ctx, PurReceivalBillInfo purReceivalBillInfo) throws BOSException, EASBizException {
        TransactionTypeInfo transactionTypeInfo = purReceivalBillInfo.getTransactionType();
        IObjectCollection entrys = null;
        entrys = (IObjectCollection)purReceivalBillInfo.get("entry");
        Object[] msgs = new String[1];
        if (transactionTypeInfo != null) {
            msgs[0] = this.checkIsStarted(ctx, transactionTypeInfo, entrys, purReceivalBillInfo);
            if (msgs[0].length() > 0) {
                throw new InvBizException(InvBizException.ISNOTSTARTED, msgs);
            }
        }
    }

    private String checkIsStarted(Context ctx, TransactionTypeInfo tti, IObjectCollection iObjectCollection, PurReceivalBillInfo purReceivalBillInfo) throws BOSException, EASBizException {
        String msg = "";
        if (purReceivalBillInfo.isIsInitBill()) {
            return msg.toString();
        }
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            PurReceivalEntryInfo purReceivalEntryInfo = (PurReceivalEntryInfo)iObjectCollection.getObject(0);
            StorageOrgUnitInfo sou = null;
            String storageOrgUnitID = "";
            if (purReceivalEntryInfo.getStorageOrgUnit() != null) {
                storageOrgUnitID = purReceivalEntryInfo.getStorageOrgUnit().getId().toString();
                sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)storageOrgUnitID)));
                Vector<BOSUuid> vctSou = new Vector<BOSUuid>();
                for (int i = 0; i < iObjectCollection.size(); ++i) {
                    purReceivalEntryInfo = (PurReceivalEntryInfo)iObjectCollection.getObject(i);
                    if (purReceivalEntryInfo.getWarehouse() == null || vctSou.contains(purReceivalEntryInfo.getWarehouse().getId())) continue;
                    vctSou.add(purReceivalEntryInfo.getWarehouse().getId());
                }
                Object[] warehouses = null;
                if (vctSou.size() > 0) {
                    ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
                    warehouses = iso.isStarted(storageOrgUnitID, vctSou.toArray(), false);
                }
                if (warehouses != null) {
                    for (int i = 0; i < warehouses.length; ++i) {
                        msg = msg + "\n" + sou.getName() + " - " + warehouses[i].toString();
                    }
                }
            }
        }
        return msg;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = super.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.number"));
        selector.add(new SelectorItemInfo("entry.billRowType.isHasMaterialNumber"));
        return selector;
    }

    public void updateAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.updateAuditStatus(ctx, model);
        PurReceivalBillInfo info = (PurReceivalBillInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Update T_IM_PurReceivalEntry SET  FBaseStatus = ");
            sql.append(4);
            sql.append(" WHERE FParentID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sql.toString());
            preStmt.setString(1, info.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    public void updateUnAuditStatus(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.updateUnAuditStatus(ctx, model);
        PurReceivalBillInfo info = (PurReceivalBillInfo)model;
        Connection conn = null;
        PreparedStatement preStmt = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Update T_IM_PurReceivalEntry SET  FBaseStatus = ");
            sql.append(1);
            sql.append(" WHERE FParentID = ? ");
            conn = EJBFactory.getConnection((Context)ctx);
            preStmt = conn.prepareStatement(sql.toString());
            preStmt.setString(1, info.getId().toString());
            preStmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(preStmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)preStmt, (Connection)conn);
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        super.checkUnPassAduit(ctx, invBillBaseInfo);
        this.checkEntryBaseStatus(invBillBaseInfo);
        if (this.isExistQualityCheckInfo(ctx, invBillBaseInfo.getId().toString())) {
            throw new PurReceivalException(PurReceivalException.EXISTS_QUALITY_CHECK_INFO_CANNOT_UNAUDIT);
        }
    }

    private void checkEntryBaseStatus(SCMBillBaseInfo info) throws SCMBillException {
        PurReceivalBillInfo realInfo = (PurReceivalBillInfo)info;
        int size = realInfo.getEntry().size();
        for (int j = 0; j < size; ++j) {
            if (realInfo.getEntry().get(j).getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            throw new SCMBillException(SCMBillException.ENTRIESISNOTAUDIT_CANNOTUNAUDIT);
        }
    }

    protected boolean isExistQualityCheckInfo(Context ctx, String billID) throws EASBizException, BOSException {
        boolean isExist = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select COUNT(prec.FID) CNT");
        sql.append(" from T_IM_PurReceivalEntry pre");
        sql.append(" inner join T_IM_PurReceivalEntryCheck prec on prec.FParentID=pre.FID");
        sql.append(" where pre.FParentID='").append(billID).append("'");
        sql.append(" and (pre.FIsCheck=1 and pre.FIsUrgentPass=0)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next() && rs.getInt(1) > 0) {
                isExist = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!isExist) {
            sql.setLength(0);
            sql.append("select COUNT(pre.FID) CNT");
            sql.append(" from T_IM_PurReceivalEntry pre");
            sql.append(" where pre.FParentID='").append(billID).append("'");
            sql.append(" and pre.FCheckQty>0");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next() && rs.getInt(1) > 0) {
                    isExist = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isExist;
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-0157c0a812fd463ED552";
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() <= 0) {
            return;
        }
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_PurOrder});
        PurReceivalBillInfo prInfo = null;
        PurReceivalEntryCollection preCollection = null;
        PurReceivalEntryInfo prEntryInfo = null;
        LocationInfo locationInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            try {
                prInfo = (PurReceivalBillInfo)collection.getObject(i);
                this.calByUnitSource(ctx, prInfo, (IObjectCollection)prInfo.getEntry());
                this.initBotpData(ctx, (IObjectValue)prInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.resetEntryMaterialInfo(ctx, prInfo);
            if ((this.isBotpBill(prInfo, "510b6503-0105-1000-e000-010bc0a812fd463ED552") || this.isBotpBill(prInfo, "kvQieV/4TJ+1ipJVFBlPx0Y+1VI=") || this.isBotpBill(prInfo, "18b7FpLNSrmaD8V9SPcOhkY+1VI=")) && prInfo.getStorageOrgUnit() != null) {
                preCollection = prInfo.getEntry();
                Map<String, MaterialInventoryInfo> wsMap = this.getMaterialInventory(ctx, prInfo);
                int m = preCollection.size();
                for (int j = 0; j < m; ++j) {
                    prEntryInfo = preCollection.get(j);
                    if (prEntryInfo.getMaterial() != null && prEntryInfo.getWarehouse() == null) {
                        prEntryInfo.setWarehouse(wsMap.get(prEntryInfo.getMaterial().getId().toString()).getDefaultWarehouse());
                    }
                    if (prEntryInfo.getMaterial() != null && prEntryInfo.getWarehouse() != null && prEntryInfo.getLocation() == null) {
                        locationInfo = InvServerUtils.getDefaultLocation(ctx, prInfo.getStorageOrgUnit(), prEntryInfo.getMaterial(), prEntryInfo.getWarehouse());
                        prEntryInfo.setLocation(locationInfo);
                    }
                    this.carryFromMaterialPurchaseInfo(ctx, prInfo, prEntryInfo);
                    this.carryFromApprovedSupplierInfo(ctx, prInfo, prEntryInfo);
                }
            }
            this._fillLotFrame(ctx, (IObjectValue)prInfo);
        }
    }

    private Map<String, MaterialInventoryInfo> getMaterialInventory(Context ctx, PurReceivalBillInfo prInfo) throws BOSException {
        PurReceivalEntryCollection preCollection = prInfo.getEntry();
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int j = 0; j < preCollection.size(); ++j) {
            if (preCollection.get(j).getMaterial() == null) continue;
            materialIdSet.add(preCollection.get(j).getMaterial().getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)prInfo.getStorageOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        si.add(new SelectorItemInfo("material.id"));
        si.add(new SelectorItemInfo("defaultWarehouse.id"));
        entityViewInfo.setSelector(si);
        MaterialInventoryCollection mInvColl = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(entityViewInfo);
        HashMap<String, MaterialInventoryInfo> wsMap = new HashMap<String, MaterialInventoryInfo>();
        for (int j = 0; j < mInvColl.size(); ++j) {
            MaterialInventoryInfo mInv = mInvColl.get(j);
            wsMap.put(mInv.getMaterial().getId().toString(), mInv);
        }
        return wsMap;
    }

    private void resetEntryMaterialInfo(Context ctx, PurReceivalBillInfo info) throws BOSException {
        int i;
        HashSet<String> materialIdSet = new HashSet<String>();
        PurReceivalEntryInfo entry = null;
        MaterialInfo materialInfo = null;
        if (info == null || info.getEntry() == null) {
            return;
        }
        int size = info.getEntry().size();
        for (int i2 = 0; i2 < size; ++i2) {
            entry = info.getEntry().get(i2);
            materialInfo = entry.getMaterial();
            if (materialInfo == null) continue;
            materialIdSet.add(materialInfo.getId().toString());
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MaterialCollection mCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(entityViewInfo);
        if (mCol == null || mCol.size() == 0) {
            return;
        }
        HashMap<String, MaterialInfo> materialId2Info = new HashMap<String, MaterialInfo>();
        int size2 = mCol.size();
        for (i = 0; i < size2; ++i) {
            materialInfo = mCol.get(i);
            materialId2Info.put(materialInfo.getId().toString(), materialInfo);
        }
        size2 = info.getEntry().size();
        for (i = 0; i < size2; ++i) {
            entry = info.getEntry().get(i);
            materialInfo = entry.getMaterial();
            if (materialInfo == null) continue;
            materialInfo = (MaterialInfo)materialId2Info.get(materialInfo.getId().toString());
            entry.setMaterial(materialInfo);
        }
    }

    private void carryFromMaterialPurchaseInfo(Context ctx, PurReceivalBillInfo prInfo, PurReceivalEntryInfo prEntryInfo) throws EASBizException, BOSException {
        if (prEntryInfo.getMaterial() != null && prEntryInfo.getPurchaseOrgUnit() != null) {
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("isPurchaseCheck");
            sic.add("qualityOrg.*");
            evi.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("material", (Object)prEntryInfo.getMaterial().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)prEntryInfo.getPurchaseOrgUnit().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            evi.setFilter(filterInfo);
            IMaterialPurchasing mp = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
            MaterialPurchasingCollection mpCollection = mp.getMaterialPurchasingCollection(evi);
            if (mpCollection != null && mpCollection.size() > 0) {
                MaterialPurchasingInfo mpInfo = mpCollection.get(0);
                prEntryInfo.setIsCheck(mpInfo.isIsPurchaseCheck());
                prEntryInfo.setQualityOrgUnit(mpInfo.getQualityOrg());
            }
        }
    }

    private void carryFromApprovedSupplierInfo(Context ctx, PurReceivalBillInfo prInfo, PurReceivalEntryInfo prEntryInfo) throws EASBizException, BOSException {
        if (prInfo.getSupplier() != null && prEntryInfo.getMaterial() != null && prEntryInfo.getPurchaseOrgUnit() != null) {
            FetchSupplyInfo fetchSupplyInfo;
            String materialID = prEntryInfo.getMaterial().getId().toString();
            HashMap<String, Object> materialMap = new HashMap<String, Object>(1);
            materialMap.put(materialID, null);
            Map supplyInfoMap = BatchFetchDataUtils.getFetchSupplyInfoMap((Context)ctx, materialMap, (String)prEntryInfo.getPurchaseOrgUnit().getId().toString(), (String)prInfo.getSupplier().getId().toString(), (Date)prInfo.getBizDate(), (boolean)false, (int)0);
            if (supplyInfoMap != null && supplyInfoMap.containsKey(materialID) && (fetchSupplyInfo = (FetchSupplyInfo)supplyInfoMap.get(materialID)) != null && fetchSupplyInfo.getApprovedSuppInfo() != null) {
                ApprovedSupplierInfo approvedSupplierInfo = fetchSupplyInfo.getApprovedSuppInfo();
                if (!approvedSupplierInfo.isIsCheck() && prEntryInfo.isIsCheck()) {
                    return;
                }
                prEntryInfo.setIsCheck(approvedSupplierInfo.isIsCheck());
            }
        }
    }

    protected boolean _checkBizDate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PurReceivalBillInfo billInfo = (PurReceivalBillInfo)model;
        TransactionTypeInfo ttInfo = billInfo.getTransactionType();
        if (!SCMUtils.isEffectExistingQty((Context)ctx, (TransactionTypeInfo)ttInfo)) {
            return true;
        }
        if (billInfo.isIsReversed()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("bizDate");
            PurReceivalBillInfo prBillInfo = this.getPurReceivalBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getEntry().get(0).getSourceBillId()), sic);
            Calendar srcBizDate = Calendar.getInstance();
            srcBizDate.setTime(prBillInfo.getBizDate());
            Object[] temp = new String[1];
            StringBuffer sb = new StringBuffer();
            sb.append(srcBizDate.get(1));
            sb.append("-");
            int month = srcBizDate.get(2) + 1;
            if (month < 10) {
                sb.append("0");
            }
            sb.append(month);
            sb.append("-");
            int date = srcBizDate.get(5);
            if (date < 10) {
                sb.append("0");
            }
            sb.append(date);
            temp[0] = sb.toString();
            if (billInfo.getBizDate() != null && billInfo.getBizDate().before(prBillInfo.getBizDate())) {
                throw new PurReceivalException(PurReceivalException.BIZDATE_REVERSE_CANNOT_BEFORE_ORIGINAL, temp);
            }
        }
        return super._checkBizDate(ctx, model);
    }

    @Override
    protected boolean isCheckMatCompanyInfo() {
        return true;
    }

    @Override
    protected String getCoreBillEntryId(Context ctx, InvBillBaseInfo info) {
        PurReceivalBillInfo billInfo = (PurReceivalBillInfo)info;
        PurReceivalEntryCollection col = billInfo.getEntry();
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getCoreBillEntryID() == null) continue;
            inSql.append("'").append(col.get(i).getCoreBillEntryID()).append("',");
        }
        if (inSql.length() > 0) {
            inSql.setLength(inSql.length() - 1);
            return inSql.toString();
        }
        return null;
    }

    @Override
    protected void _updateCheckUnReturnQty(Context ctx, String[] ids) throws BOSException, EASBizException {
        String updateSQL = "update T_IM_PurReceivalEntry as T set (FCheckUnAssociateQty) = ( select T1.Qty from ( select checktry.FParentId,sum(ISNULL(checktry.FAssociateQty, 0)) as Qty from T_IM_PurReceivalEntryCheck checktry, T_IM_PurReceivalEntry entry where entry.FID = checktry.FParentId and entry.FParentId in ({0}) group by checktry.FParentId) T1 where T.FID = T1.FParentId)";
        if (ids == null || ids.length == 0) {
            return;
        }
        StringBuffer idWhere = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (i != 0) {
                idWhere.append(",");
            }
            idWhere.append("'").append(ids[i]).append("'");
        }
        String sSQL = MessageFormat.format("update T_IM_PurReceivalEntry as T set (FCheckUnAssociateQty) = ( select T1.Qty from ( select checktry.FParentId,sum(ISNULL(checktry.FAssociateQty, 0)) as Qty from T_IM_PurReceivalEntryCheck checktry, T_IM_PurReceivalEntry entry where entry.FID = checktry.FParentId and entry.FParentId in ({0}) group by checktry.FParentId) T1 where T.FID = T1.FParentId)", idWhere.toString());
        DbUtil.execute((Context)ctx, (String)sSQL);
    }

    @Override
    protected LotFrame fillLotNumber(Context ctx, IObjectValue model, LotFrame lotFrame, InvBillBaseEntryInfo entryInfo) throws EASBizException, BOSException {
        if (model == null) {
            return lotFrame;
        }
        PurReceivalBillInfo info = (PurReceivalBillInfo)model;
        SupplierInfo supplier = info.getSupplier();
        if (supplier != null && supplier.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(supplier.getId());
            supplier = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)pk);
        }
        if (supplier != null) {
            lotFrame.setSupplier(supplier.getNumber());
        } else {
            lotFrame.setSupplier(null);
        }
        CustomerInfo customer = info.getCustomer();
        if (customer != null && customer.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(customer.getId());
            customer = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)pk);
        }
        if (customer != null) {
            lotFrame.setCustomer(customer.getNumber());
        } else {
            lotFrame.setCustomer(null);
        }
        if (entryInfo == null) {
            return lotFrame;
        }
        PurReceivalEntryInfo entry = (PurReceivalEntryInfo)entryInfo;
        String supplierLotNo = entry.getSupplierLotNo();
        if (supplierLotNo != null) {
            lotFrame.setSupplierlotno(supplierLotNo);
        } else {
            lotFrame.setSupplierlotno(null);
        }
        return lotFrame;
    }

    @Override
    protected void setNULLToZERO(IObjectValue invBill) {
        super.setNULLToZERO(invBill);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReceivalBillInfo info = this.getPurReceivalBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurReceivalBillInfo info = this.getPurReceivalBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        PurReceivalEntryInfo purReceivalEntryInfo = (PurReceivalEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = purReceivalEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = purReceivalEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = purReceivalEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)purReceivalEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)purReceivalEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        purReceivalEntryInfo.setQty(qty);
    }

    @Override
    protected void _discard(Context ctx, String billId) throws BOSException, EASBizException {
        BatchExecuteParamsEntry entry = new BatchExecuteParamsEntry(new Class[]{String.class}, new Object[]{billId});
        BatchExecuteParamsEntry[] entrys = new BatchExecuteParamsEntry[]{entry};
        BatchActionResults result = this.batchDiscard(ctx, entrys);
        result.throwExceptions();
    }

    public BatchActionResults batchDiscard(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults result = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        Set idSet = result.getToDoIdsSet();
        this.reservationCheck(ctx, idSet);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("baseStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(this.getBOSType(), view);
        IObjectValue obj = null;
        String id = null;
        StringBuilder sb = new StringBuilder(1024);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            obj = coll.getObject(i);
            id = String.valueOf(obj.get("id"));
            if (1 == (Integer)obj.get("baseStatus") || 2 == (Integer)obj.get("baseStatus")) {
                result.addSuccess(id);
                sb.append("'").append(id).append("',");
                continue;
            }
            result.addError(id, (Exception)new SCMBillException(SCMBillException.CANNOT_DISCARD));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            DbUtil.execute((Context)ctx, (String)("UPDATE T_IM_PurReceivalBill SET FBaseStatus = 3 WHERE FID IN (" + sb.toString() + ")"));
            DbUtil.execute((Context)ctx, (String)("UPDATE T_IM_PurReceivalEntry SET FBaseStatus = 3 WHERE FPARENTID IN (" + sb.toString() + ")"));
        }
        return result;
    }

    public void reservationCheck(Context ctx, Set IDs) throws BOSException {
        try {
            Object[] oArray = IDs.toArray(new Object[0]);
            String ids = ArrayUtil.getStringFromArr((Object[])oArray);
            String filter = "(RequireBillID IN (" + ids + ") OR SupplierBillID IN (" + ids + ")) AND isAutoReservation <> 1";
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            ReservationCollection reservationcoll = ReservationFactory.getLocalInstance(ctx).getReservationCollection(view);
            if (reservationcoll.size() > 0) {
                String error = ResourceBase.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"ISEXIST_HANDRESERVATION_RECORD", (Locale)ctx.getLocale());
                throw new BOSException(error);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        BigDecimal ZERO = BigDecimal.ZERO;
        PurReceivalBillInfo recBill = null;
        recBill = isUseAgent ? PurReceivalBillAgent.create() : new PurReceivalBillInfo();
        recBill.setBaseStatus(BillBaseStatusEnum.ADD);
        recBill.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0157c0a812fd463ED552"));
        billTypeInfo.setNumber("101");
        recBill.setBillType(billTypeInfo);
        recBill.setHasEffected(false);
        recBill.setTotalAmount(ZERO);
        recBill.setTotalActualCost(ZERO);
        recBill.setTotalStandardCost(ZERO);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        recBill.setBizDate(curDate);
        boolean isSubContractBill = false;
        if (ctx.get((Object)"isSubContractBill") != null) {
            isSubContractBill = (Boolean)ctx.get((Object)"isSubContractBill");
        }
        BizTypeInfo bizType = null;
        bizType = isSubContractBill ? SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"1x7KMBq4mUmpj58T4jNPqiQHQ1w=", (String)"50957179-0105-1000-e000-0157c0a812fd463ED552") : SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"d8e80652-0106-1000-e000-04c5c0a812202407435C", (String)"50957179-0105-1000-e000-0157c0a812fd463ED552");
        recBill.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-0157c0a812fd463ED552", bizType.getId().toString());
            recBill.setTransactionType(tti);
        }
        recBill.setFiVouchered(false);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "purreceival_new");
        if (sou == null) {
            recBill.getEntry().add((PurReceivalEntryInfo)this.createNewDetailData(isUseAgent));
            return recBill;
        }
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)sou.getId().toString()));
        if (cou != null) {
            recBill.setStorageOrgUnit(sou);
        }
        PurReceivalEntryInfo aPurReceivalEntryInfo = (PurReceivalEntryInfo)this.createNewDetailData(isUseAgent);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("requestOrgType"));
        sic.add(new SelectorItemInfo("isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("projectType"));
        RowTypeInfo rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectStringPK("00000000-0000-0000-0000-0000000000017C7DC4A3"), sic);
        aPurReceivalEntryInfo.setBillRowType(rowType);
        aPurReceivalEntryInfo.setCompanyOrgUnit(cou);
        aPurReceivalEntryInfo.setStorageOrgUnit(sou);
        if (recBill.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType(ctx, "50957179-0105-1000-e000-0157c0a812fd463ED552", recBill.getTransactionType());
            aPurReceivalEntryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        recBill.getEntry().add(aPurReceivalEntryInfo);
        return recBill;
    }

    private IObjectValue createNewDetailData(boolean isUseAgent) throws BOSException, EASBizException {
        BigDecimal ZERO = BigDecimal.ZERO;
        PurReceivalEntryInfo recEntry = null;
        recEntry = isUseAgent ? PurReceivalEntryAgent.create() : new PurReceivalEntryInfo();
        recEntry.setReceiptQty(ZERO);
        recEntry.setUnitActualCost(ZERO);
        recEntry.setActualCost(ZERO);
        recEntry.setUnitStandardCost(ZERO);
        recEntry.setStandardCost(ZERO);
        recEntry.setQty(ZERO);
        recEntry.setBaseStatus(EntryBaseStatusEnum.ADD);
        recEntry.setAmount(ZERO);
        recEntry.setReverseQty(ZERO);
        return recEntry;
    }
}

