/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IPurReceivalBill;
import com.kingdee.eas.scm.im.inv.IPurReceivalEntry;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalException;
import com.kingdee.eas.scm.im.inv.app.AbstractPurReceivalEntryControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurReceivalEntryControllerBean
extends AbstractPurReceivalEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.PurReceivalEntryControllerBean");

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
        this.checkPurReceivalEntryHandClose(ctx, iPurReceivalEntry, pk);
        this.changePurReceivalEntryStatus(iPurReceivalEntry, pk, EntryBaseStatusEnum.CLOSED, (ReasonCodeInfo)reasonCode);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.CLOSED)) {
            this.changePurReceivalStatus(ctx, pk, BillBaseStatusEnum.CLOSED);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurReceivalEntryHandClose(ctx, pks);
        if (pks != null) {
            IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentPurPK = null;
            ObjectUuidPK purPK = null;
            ObjectUuidPK parentEntryPK = null;
            PurReceivalBillInfo purInfo = new PurReceivalBillInfo();
            PurReceivalEntryInfo PurReceivalEntryInfo2 = null;
            ReasonCodeInfo reasonCodeInfo = null;
            if (pks == null || pks.length == 0) {
                return;
            }
            int length = pks.length;
            HashSet<String> entryIdSet = new HashSet<String>();
            for (int i = 0; i < length; ++i) {
                entryIdSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection entrySic = new SelectorItemCollection();
            entrySic.add(new SelectorItemInfo("baseStatus"));
            entrySic.add(new SelectorItemInfo("parent.id"));
            entrySic.add(new SelectorItemInfo("parent.number"));
            entrySic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
            entrySic.add(new SelectorItemInfo("reason"));
            view.setSelector(entrySic);
            PurReceivalEntryCollection coll = this.getPurReceivalEntryCollection(ctx, view);
            if (coll == null || coll.size() == 0) {
                return;
            }
            HashSet<String> orgIdSet = new HashSet<String>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                PurReceivalEntryInfo2 = coll.get(i);
                orgIdSet.add(PurReceivalEntryInfo2.getParent().getStorageOrgUnit().getId().toString());
            }
            for (String orgId : orgIdSet) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgId), "purreceival_unClose");
            }
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : (ReasonCodeInfo)reasonCodes[i];
                this.changePurReceivalEntryStatus(iPurReceivalEntry, pks[i], EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                PurReceivalEntryInfo2 = iPurReceivalEntry.getPurReceivalEntryInfo(pks[i]);
                purPK = new ObjectUuidPK(PurReceivalEntryInfo2.getParent().getId());
                if (parentEntryPK == null) {
                    parentEntryPK = purPK;
                    parentEntryPK = pks[i];
                    purInfo = this.getPurReceivalBill(ctx, purPK.toString());
                } else if (parentPurPK == null || !parentPurPK.equals((Object)purPK)) {
                    if (this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                        this.changePurReceivalStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
                    }
                    parentPurPK = purPK;
                    parentEntryPK = pks[i];
                    purInfo = this.getPurReceivalBill(ctx, purPK.toString());
                    purInfo.getEntry().clear();
                }
                purInfo.getEntry().add(PurReceivalEntryInfo2);
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changePurReceivalStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, String reasonCode) throws BOSException, EASBizException {
        IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
        this.checkPurReceivalEntryHandClose(ctx, iPurReceivalEntry, pk);
        this.changePurReceivalEntryStatus(iPurReceivalEntry, pk, EntryBaseStatusEnum.CLOSED, reasonCode);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.CLOSED)) {
            this.changePurReceivalStatus(ctx, pk, BillBaseStatusEnum.CLOSED);
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, String[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurReceivalEntryHandClose(ctx, pks);
        if (pks != null) {
            IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentPurPK = null;
            ObjectUuidPK purPK = null;
            ObjectUuidPK parentEntryPK = null;
            PurReceivalBillInfo purInfo = new PurReceivalBillInfo();
            PurReceivalEntryInfo PurReceivalEntryInfo2 = null;
            String reasonCodeInfo = null;
            if (pks == null || pks.length == 0) {
                return;
            }
            int length = pks.length;
            HashSet<String> entryIdSet = new HashSet<String>();
            for (int i = 0; i < length; ++i) {
                entryIdSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection entrySic = new SelectorItemCollection();
            entrySic.add(new SelectorItemInfo("baseStatus"));
            entrySic.add(new SelectorItemInfo("parent.id"));
            entrySic.add(new SelectorItemInfo("parent.number"));
            entrySic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
            entrySic.add(new SelectorItemInfo("reason"));
            view.setSelector(entrySic);
            PurReceivalEntryCollection coll = this.getPurReceivalEntryCollection(ctx, view);
            if (coll == null || coll.size() == 0) {
                return;
            }
            HashSet<String> orgIdSet = new HashSet<String>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                PurReceivalEntryInfo2 = coll.get(i);
                orgIdSet.add(PurReceivalEntryInfo2.getParent().getStorageOrgUnit().getId().toString());
            }
            for (String orgId : orgIdSet) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgId), "purreceival_unClose");
            }
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : reasonCodes[i];
                this.changePurReceivalEntryStatus(iPurReceivalEntry, pks[i], EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                PurReceivalEntryInfo2 = iPurReceivalEntry.getPurReceivalEntryInfo(pks[i]);
                purPK = new ObjectUuidPK(PurReceivalEntryInfo2.getParent().getId());
                if (parentEntryPK == null) {
                    parentEntryPK = purPK;
                    parentEntryPK = pks[i];
                    purInfo = this.getPurReceivalBill(ctx, purPK.toString());
                } else if (parentPurPK == null || !parentPurPK.equals((Object)purPK)) {
                    if (this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                        this.changePurReceivalStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
                    }
                    parentPurPK = purPK;
                    parentEntryPK = pks[i];
                    purInfo = this.getPurReceivalBill(ctx, purPK.toString());
                    purInfo.getEntry().clear();
                }
                purInfo.getEntry().add(PurReceivalEntryInfo2);
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changePurReceivalStatus(ctx, (IObjectPK)parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
        }
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        int length = pks.length;
        PurReceivalBillInfo info = null;
        PurReceivalEntryInfo entryInfo = null;
        PurReceivalEntryCollection entryColl = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        String tableName = "T_IM_PurReceivalEntry";
        for (int i = 0; i < length; ++i) {
            entryIdSet.add(pks[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection entrySic = new SelectorItemCollection();
        entrySic.add(new SelectorItemInfo("baseStatus"));
        entrySic.add(new SelectorItemInfo("parent.id"));
        entrySic.add(new SelectorItemInfo("parent.number"));
        entrySic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        entrySic.add(new SelectorItemInfo("reason"));
        view.setSelector(entrySic);
        PurReceivalEntryCollection coll = this.getPurReceivalEntryCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet<String> orgIdSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            orgIdSet.add(entryInfo.getParent().getStorageOrgUnit().getId().toString());
        }
        for (String orgId : orgIdSet) {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgId), "purreceival_unClose");
        }
        ArrayList list = new ArrayList();
        Set idSet = this.handleEntryAndReturnParentPK(ctx, list, coll);
        this.handleCanNotUnclosePur(ctx, list);
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            PurReceivalBillCollection billColl = PurReceivalBillFactory.getLocalInstance(ctx).getPurReceivalBillCollection(viewInfo);
            if (billColl != null && billColl.size() >= 0) {
                int size2 = billColl.size();
                for (int i = 0; i < size2; ++i) {
                    info = billColl.get(i);
                    entryColl = (PurReceivalEntryCollection)((Object)info.getEntry().clone());
                    info.getEntry().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntry().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tableName).append(" set FBaseStatus = 4,FReason = '' where fid in ").append(SCMServerUtils.getInStringFromSet(entryIdSet));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (idSet != null && idSet.size() > 0) {
            sql.setLength(0);
            sql.append("update T_IM_PurReceivalBill set FBaseStatus = 4 where FID in ").append(SCMServerUtils.getInStringFromSet((Set)idSet));
            sql.append(" and FID not in (select FParentID from ").append(tableName).append(" where FBaseStatus = -2 ");
            sql.append(" and FParentID in ").append(SCMServerUtils.getInStringFromSet((Set)idSet)).append(" )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private Set handleEntryAndReturnParentPK(Context ctx, List list, PurReceivalEntryCollection coll) throws BOSException, EASBizException {
        PurReceivalEntryInfo purReceivalEntryInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        if (coll == null || coll.size() == 0) {
            return null;
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            purReceivalEntryInfo = coll.get(i);
            if (EntryBaseStatusEnum.CLOSED != purReceivalEntryInfo.getBaseStatus()) {
                list.add(purReceivalEntryInfo);
                continue;
            }
            idSet.add(purReceivalEntryInfo.getParent().getId().toString());
        }
        return idSet;
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._handleUnclose(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _canHandleClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkPurReceivalEntryHandClose(ctx, pks);
    }

    private void handleCanNotUnclosePur(Context ctx, List list) throws EASBizException {
        if (list.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("purException", this.getResource(ctx, "CAN_NOT_UNCLOSE_ENTRY")));
        }
    }

    private PurReceivalBillInfo getPurReceivalBill(Context ctx, String orderId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("baseStatus"));
        PurReceivalBillInfo purInfo = PurReceivalBillFactory.getLocalInstance(ctx).getPurReceivalBillInfo((IObjectPK)new ObjectStringPK(orderId), selectors);
        purInfo.getEntry().clear();
        return purInfo;
    }

    private void changePurReceivalStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        if (entryPk == null) {
            return;
        }
        IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
        PurReceivalEntryInfo purReceivalEntryInfo = iPurReceivalEntry.getPurReceivalEntryInfo(entryPk);
        IPurReceivalBill iPurReceival = PurReceivalBillFactory.getLocalInstance(ctx);
        ObjectUuidPK purPK = new ObjectUuidPK(purReceivalEntryInfo.getParent().getId());
        PurReceivalBillInfo purInfo = iPurReceival.getPurReceivalBillInfo((IObjectPK)purPK);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseStatus"));
        purInfo.setBaseStatus(newStatus);
        iPurReceival.updatePartial((CoreBaseInfo)purInfo, selector);
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
        PurReceivalEntryInfo purReceivalEntryInfo = iPurReceivalEntry.getPurReceivalEntryInfo(entryPk);
        IPurReceivalBill iPurReceival = PurReceivalBillFactory.getLocalInstance(ctx);
        ObjectUuidPK purPK = new ObjectUuidPK(purReceivalEntryInfo.getParent().getId());
        PurReceivalBillInfo purInfo = iPurReceival.getPurReceivalBillInfo((IObjectPK)purPK);
        PurReceivalEntryCollection purReceivalCollenction = purInfo.getEntry();
        int num = purReceivalCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (purReceivalCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    protected void changePurReceivalEntryStatus(IPurReceivalEntry iPurReceivalEntry, IObjectPK pk, EntryBaseStatusEnum newStatus, ReasonCodeInfo reasonCodeInfo) throws EASBizException, BOSException {
        PurReceivalEntryInfo purReceivalEntryInfo = iPurReceivalEntry.getPurReceivalEntryInfo(pk);
        purReceivalEntryInfo.setBaseStatus(newStatus);
        if (reasonCodeInfo != null) {
            purReceivalEntryInfo.setReason(reasonCodeInfo.getName());
        }
        iPurReceivalEntry.update(pk, (CoreBaseInfo)purReceivalEntryInfo);
    }

    protected void changePurReceivalEntryStatus(IPurReceivalEntry iPurReceivalEntry, IObjectPK pk, EntryBaseStatusEnum newStatus, String reasonCodeInfo) throws EASBizException, BOSException {
        PurReceivalEntryInfo purReceivalEntryInfo = iPurReceivalEntry.getPurReceivalEntryInfo(pk);
        purReceivalEntryInfo.setBaseStatus(newStatus);
        purReceivalEntryInfo.setReason(reasonCodeInfo);
        iPurReceivalEntry.update(pk, (CoreBaseInfo)purReceivalEntryInfo);
    }

    protected void checkPurReceivalEntryHandClose(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IPurReceivalEntry iPurReceivalEntry = PurReceivalEntryFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkPurReceivalEntryHandClose(ctx, iPurReceivalEntry, pks[i]);
                    continue;
                }
                catch (Exception ex) {
                    if (num > 1) {
                        throw new PurReceivalException(PurReceivalException.PUR_PARTCANNOT_OPERATOR, new String[]{this.getResource(ctx, "OPERATOR_CLOSE")});
                    }
                    throw new BOSException((Throwable)ex);
                }
            }
        }
    }

    public void checkPurReceivalEntryHandClose(Context ctx, IPurReceivalEntry iPurReceivalEntry, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent.id"));
        PurReceivalEntryInfo purReceivalEntryInfo = iPurReceivalEntry.getPurReceivalEntryInfo(pk, sic);
        if (purReceivalEntryInfo.getBaseStatus().getValue() != 4) {
            throw new PurReceivalException(PurReceivalException.PUR_CANNOT_CLOSE, new String[]{purReceivalEntryInfo.getBaseStatus().toString()});
        }
        BOSUuid parentid = purReceivalEntryInfo.getParent().getId();
        ObjectUuidPK parentpk = new ObjectUuidPK(parentid);
        IPurReceivalBill iPurReceival = PurReceivalBillFactory.getLocalInstance(ctx);
        PurReceivalBillInfo purInfo = iPurReceival.getPurReceivalBillInfo((IObjectPK)parentpk);
        if (purInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.REVERSE_ORDER_CANNOT_CLOSE);
        }
        String tableName = "T_IM_PurReceivalEntry";
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(pk.toString());
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, idSet)) {
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)purInfo, (BatchActionEnum)BatchActionEnum.CLOSE);
        }
    }

    protected String getResource(Context ctx, String msgResource) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)msgResource, (Locale)ctx.getLocale());
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select pr.FNumber number,pre.FSeq seq from T_IM_PurReceivalEntry pre inner join T_IM_PurReceivalBill pr on pre.FParentID = pr.FId ");
        sql.append("where pre.FID = '").append(pk.toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String str = "";
        try {
            if (rs.next()) {
                if (!StringUtil.isEmpty((String)rs.getString("number"))) {
                    str = str + rs.getString("number");
                    str = str + " ";
                }
                if (!StringUtil.isEmpty((String)rs.getString("seq"))) {
                    str = str + rs.getString("seq");
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return str;
    }
}

