/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PurReceivalImport
extends InvDataImport {
    private static String resources = "com.kingdee.eas.scm.im.inv.app.PurInImportResource";
    private static String resourcesofother = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    ImportDataCache dataPool = new ImportDataCache();
    PurReceivalBillInfo purReceivalBill = null;
    TransactionTypeInfo tti = null;
    CompanyOrgUnitInfo cou = null;
    StorageOrgUnitInfo sou = null;
    private static final String[] ENTRY_PERSON_FIELDS = new String[]{"FEntry$stocker_number"};
    private static final String[] ENTRY_PERSON_OBJ_EN = new String[]{"stocker"};
    private static final String[] ENTRY_QTY_AMOUNT_FIELDS = new String[]{"qty", "assistQty", "baseQty", "reverseQty", "reverseBaseQty", "returnsQty", "returnBaseQty", "amount", "actualCost", "standardCost", "checkQty", "checkBaseQty", "checkReturnedQty", "checkReturnedBaseQty", "qualifiedQty", "unqualifiedQty", "unqualifiedBaseQty"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurReceivalBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.purReceivalBill = null;
        int k = 0;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            PurReceivalEntryInfo entryInfo;
            Hashtable lineData;
            block8: {
                lineData = (Hashtable)hsData.get(new Integer(i));
                if (k == 0) {
                    try {
                        this.purReceivalBill = this.transmitHead(lineData, ctx);
                        this.afterBuildHead(ctx, this.purReceivalBill, lineData);
                    }
                    catch (Exception e) {
                        tex.addEntryErrorReason(k, e.getMessage());
                        this.recycleNumber(ctx, this.purReceivalBill);
                        break;
                    }
                    if (this.purReceivalBill == null) {
                        return null;
                    }
                }
                entryInfo = null;
                try {
                    entryInfo = this.transmitEntry(lineData, ctx);
                }
                catch (Exception e) {
                    tex.addEntryErrorReason(k, e.getMessage());
                    if (tex.getEntryErrorReasons().size() != 1) break block8;
                    this.recycleNumber(ctx, this.purReceivalBill);
                }
            }
            this.afterBuildEntry(entryInfo);
            this.afterBuildEntry(ctx, this.purReceivalBill, entryInfo, lineData);
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.purReceivalBill;
    }

    private void afterBuildEntry(PurReceivalEntryInfo entryInfo) {
        int seq = this.purReceivalBill.getEntry().size() + 1;
        entryInfo.setSeq(seq);
        entryInfo.setParent(this.purReceivalBill);
        entryInfo.setStorageOrgUnit(this.sou);
        entryInfo.setCompanyOrgUnit(this.cou);
        this.purReceivalBill.getEntry().add(entryInfo);
    }

    private PurReceivalBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        this.purReceivalBill = new PurReceivalBillInfo();
        this.doPurchaseType(ctx);
        this.doStorageOrgUnit(ctx, lineData);
        this.doCompanyOrgUnit(ctx);
        this.doBizTypeInfo(ctx, lineData);
        this.doTransactionInfo(ctx, lineData);
        this.doSuppiler(ctx, lineData);
        this.doAdminOrgUnit(ctx, lineData);
        this.doOtherField(ctx);
        this.doIsInitBill(lineData);
        this.doCreator(ctx, lineData);
        this.doCreateDate(lineData);
        this.doBillType(ctx);
        this.doBizDate(lineData, ctx);
        this.doDescription(lineData);
        return this.purReceivalBill;
    }

    private PurReceivalEntryInfo transmitEntry(Hashtable lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        PurReceivalEntryInfo entryInfo = new PurReceivalEntryInfo();
        this.doEntryMaterial(lineData, ctx, entryInfo);
        this.doEntryAssistProperty(lineData, ctx, entryInfo);
        this.doEntryLot(lineData, ctx, entryInfo);
        this.doEntrySupplierLot(lineData, ctx, entryInfo);
        this.doEntryMfgExp(ctx, lineData, entryInfo);
        this.doEntryUnit(lineData, ctx, entryInfo);
        this.doEntryQty(lineData, ctx, entryInfo);
        this.doEntryBaseUnit(ctx, lineData, entryInfo);
        this.doEntryAssistUnit(ctx, entryInfo, lineData);
        this.doEntryWarehs(lineData, ctx, entryInfo);
        this.doEntryLocation(lineData, ctx, entryInfo);
        this.doEntryStocker(lineData, ctx, entryInfo);
        this.doEntryStandardCost(ctx, entryInfo);
        this.doEntryPurchaseOrgUnit(lineData, ctx, entryInfo);
        this.doEntryFilesByRI(entryInfo);
        this.doEntryOtherField(lineData, entryInfo);
        this.doEntryProjectNum(ctx, lineData, entryInfo);
        this.doEntryTrackNum(ctx, lineData, entryInfo);
        this.checkQtyPrecision(ctx, entryInfo);
        return entryInfo;
    }

    private void doStorageOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException {
        try {
            this.loadstorageOrgUnit(lineData, ctx, "number", "FStorageOrgUnit_number");
        }
        catch (Exception e_number) {
            try {
                this.loadstorageOrgUnit(lineData, ctx, "name", "FStorageOrgUnit_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadstorageOrgUnit(Hashtable lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        if (souData != null && souData.toString().trim().length() > 0) {
            StorageOrgUnitInfo storageOrgUnitInfo = this.dataPool.getStorageOrgUnitInfo(souData.toString().trim());
            if (storageOrgUnitInfo != null) {
                this.sou = storageOrgUnitInfo;
                this.purReceivalBill.setStorageOrgUnit(storageOrgUnitInfo);
                return;
            }
            IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = isou.getStorageOrgUnitCollection(this.getFilter(souData.toString().trim(), byProperty));
            if (collection != null && collection.size() > 0) {
                this.sou = storageOrgUnitInfo = collection.get(0);
                this.purReceivalBill.setStorageOrgUnit(storageOrgUnitInfo);
                this.dataPool.setStorageOrgUnitInfo(souData.toString().trim(), storageOrgUnitInfo);
                return;
            }
            String str = PurReceivalImport.getResource(ctx, "STORAGE_NOT_EXIST");
            throw new TaskExternalException(str);
        }
        String str = PurReceivalImport.getResource(ctx, "STORAGE_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resources, (String)strKey, (Context)ctx);
    }

    private void doPurchaseType(Context ctx) {
        if (ctx.get((Object)"isSubContractBill") == null) {
            this.purReceivalBill.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        } else if (ctx.get((Object)"isSubContractBill").toString().equals("true")) {
            this.purReceivalBill.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
        } else {
            this.purReceivalBill.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doCompanyOrgUnit(Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String souID = this.sou.getId().toString();
        if (this.dataPool.getCompanyOrgUnitInfo(souID) != null) {
            this.cou = this.dataPool.getCompanyOrgUnitInfo(souID);
            return;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(souID, 4, 1);
        if (orgCol.get(0) != null) {
            this.cou = (CompanyOrgUnitInfo)orgCol.get(0);
            return;
        }
        String str = PurReceivalImport.getResource(ctx, "STORAGE_NOT_COMPANY");
        throw new TaskExternalException(str);
    }

    private void doBizTypeInfo(Context ctx, Hashtable lineData) throws TaskExternalException {
        try {
            this.loadBizType(lineData, ctx, "number", "FBizType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadBizType(lineData, ctx, "name", "FBizType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    private void loadBizType(Hashtable lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        try {
            BizTypeCollection collection;
            Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
            if (souData != null && souData.toString().trim().length() > 0) {
                collection = InvCommonUtils.getBizTypeCollection(ctx, "50957179-0105-1000-e000-0157c0a812fd463ED552", this.getFilter(souData.toString().trim(), byProperty));
                if (collection == null || collection.size() <= 0) {
                    String str = PurReceivalImport.getResource(ctx, "BIZTYPE_NOT_EXIST");
                    throw new TaskExternalException(str);
                }
            } else {
                String str = PurReceivalImport.getResource(ctx, "BIZTYPE_NOT_NULL");
                throw new TaskExternalException(str);
            }
            this.purReceivalBill.setBizType(collection.get(0));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doTransactionInfo(Context ctx, Hashtable lineData) throws TaskExternalException {
        try {
            this.loadTransaction(lineData, ctx, "number", "FTransactionType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadTransaction(lineData, ctx, "name", "FTransactionType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadTransaction(Hashtable lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        if (souData != null && souData.toString().trim().length() > 0) {
            if (this.dataPool.getTransactionTypeInfo(souData.toString().trim()) != null) {
                this.tti = this.dataPool.getTransactionTypeInfo(souData.toString().trim());
                this.purReceivalBill.setTransactionType(this.tti);
                return;
            }
            TransactionTypeCollection collection = InvCommonUtils.getTransactionTypeCollection(ctx, "50957179-0105-1000-e000-0157c0a812fd463ED552", this.purReceivalBill.getBizType().getId().toString(), this.getFilter(souData.toString().trim(), byProperty));
            if (collection != null && collection.size() > 0) {
                this.tti = collection.get(0);
                this.purReceivalBill.setTransactionType(this.tti);
                this.dataPool.setTransactionTypeInfo(souData.toString().trim(), this.tti);
                return;
            }
            String str = PurReceivalImport.getResource(ctx, "TRANSACTIONTYPE_NOT_EXIST");
            throw new TaskExternalException(str);
        }
        String str = PurReceivalImport.getResource(ctx, "TRANSACTIONTYPE_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private void doSuppiler(Context ctx, Hashtable lineData) throws BOSException, TaskExternalException {
        try {
            this.loadSuppiler(lineData, ctx, "number", "FSupplier_number");
        }
        catch (Exception e_number) {
            try {
                this.loadSuppiler(lineData, ctx, "name", "FSupplier_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadSuppiler(Hashtable lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException, BOSException {
        SupplierInfo info;
        block4: {
            String supplierNumber;
            block5: {
                Object data = ((DataToken)lineData.get((Object)propertyName)).data;
                info = null;
                if (data == null) break block4;
                supplierNumber = data.toString().trim();
                if (this.dataPool.getSupplierInfo(supplierNumber) != null) break block5;
                if (supplierNumber == null || supplierNumber.length() <= 0) break block4;
                ISupplier isupplier = SupplierFactory.getLocalInstance((Context)ctx);
                SupplierCollection collection = isupplier.getSupplierCollection(this.getFilter(supplierNumber, byProperty));
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    if (info != null) {
                        this.purReceivalBill.setSupplier(info);
                        this.dataPool.setSupplierInfo(supplierNumber, info);
                    }
                    break block4;
                } else {
                    String str = PurReceivalImport.getResource(ctx, "SUPPLIER_NOT_EXIST");
                    throw new TaskExternalException(str);
                }
            }
            info = this.dataPool.getSupplierInfo(supplierNumber);
            this.purReceivalBill.setSupplier(info);
        }
        if (info == null) {
            String str = PurReceivalImport.getResource(ctx, "SUPPLIER_NOT_NULL");
            throw new TaskExternalException(str);
        }
    }

    private void doAdminOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException {
        IAdminOrgUnit iadminorg;
        AdminOrgUnitCollection collection;
        String adminOrgUnitNum;
        Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo info = null;
        if (data != null && data.toString().length() > 0 && (adminOrgUnitNum = data.toString()) != null && adminOrgUnitNum.length() > 0 && (collection = (iadminorg = AdminOrgUnitFactory.getLocalInstance((Context)ctx)).getAdminOrgUnitCollection(this.getFilter(data.toString().trim()))) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
            this.purReceivalBill.setAdminOrgUnit(info);
        }
    }

    private void doCreator(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException {
        UserInfo info;
        IUser iUser;
        UserCollection collection;
        String number;
        Object data = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        if (data != null && data.toString().trim().length() > 0 && this.dataPool.getUserInfo(number = data.toString().trim()) == null && (collection = (iUser = UserFactory.getLocalInstance((Context)ctx)).getUserCollection(this.getFilter(number, "number"))) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
            this.purReceivalBill.setCreator(info);
            this.dataPool.setUserInfo(number, info);
        }
        if (this.purReceivalBill.getCreator() == null) {
            UserInfo userinfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            this.purReceivalBill.setCreator(userinfo);
        }
    }

    private void doCreateDate(Hashtable lineData) {
        Object createdate = ((DataToken)lineData.get((Object)"FCreateTime")).data;
        if (createdate != null && createdate.toString().length() > 0) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                createdate = df.parseObject(createdate.toString());
                this.purReceivalBill.setCreateTime(new Timestamp(((Date)createdate).getTime()));
            }
            catch (ParseException df) {
                // empty catch block
            }
        }
        if (this.purReceivalBill.getCreateTime() == null) {
            Date date = new Date();
            this.purReceivalBill.setCreateTime(new Timestamp(date.getTime()));
        }
    }

    private void doIsInitBill(Hashtable lineData) {
        Object souData = ((DataToken)lineData.get((Object)"FIsInitBill")).data;
        if (souData != null && souData.toString().trim().length() > 0 && ("true".equals(souData) || "\u662f".equals(souData) || "YES".equals(souData) || "yes".equals(souData))) {
            this.purReceivalBill.setIsInitBill(true);
        } else {
            this.purReceivalBill.setIsInitBill(false);
        }
    }

    private void doBillType(Context ctx) throws BOSException {
        BillTypeInfo billTypeinfo = new BillTypeInfo();
        billTypeinfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0157c0a812fd463ED552"));
        this.purReceivalBill.setBillType(billTypeinfo);
    }

    private void doBizDate(Hashtable lineData, Context ctx) throws TaskExternalException {
        Date da = ImRptAppUtils.formatNationalDate(ctx, lineData.get("FBizDate").toString());
        this.purReceivalBill.setBizDate(da);
    }

    private void doDescription(Hashtable lineData) {
        Object o = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (o != null) {
            String description = o.toString().trim();
            if (description.length() > 255) {
                description = description.substring(0, 255);
            }
            this.purReceivalBill.setDescription(description);
        }
    }

    private void doOtherField(Context ctx) {
        this.purReceivalBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.purReceivalBill.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.purReceivalBill.setIsCentralBalance(false);
        this.purReceivalBill.setVoucher(null);
        this.purReceivalBill.setIsReversed(false);
        this.purReceivalBill.setSourceBillId(null);
        this.purReceivalBill.setSourceBillType(null);
        this.purReceivalBill.setFiVouchered(false);
    }

    private void doEntryProjectNum(Context ctx, Hashtable lineData, PurReceivalEntryInfo entry) throws TaskExternalException, BOSException, EASBizException {
        String number;
        Object data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        if (data != null && (number = data.toString()) != null && number.trim().length() > 0) {
            IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(4));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = this.purReceivalBill.getStorageOrgUnit().getCU();
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            ProjectCollection coll = iProject.getProjectCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                ProjectInfo projectInfo = coll.get(0);
                entry.setProject(projectInfo);
            } else {
                throw new TaskExternalException(data.toString() + " " + PurReceivalImport.getResource(ctx, "PROJECT_NUMBER_ERROR"));
            }
        }
    }

    private void doEntryTrackNum(Context ctx, Hashtable lineData, PurReceivalEntryInfo entry) throws TaskExternalException, BOSException, EASBizException {
        String number;
        Object data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        if (data != null && (number = data.toString()) != null && number.trim().length() > 0) {
            ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            HashSet<Integer> status = new HashSet<Integer>();
            status.add(new Integer(10));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
            FilterInfo filter2 = new FilterInfo();
            CtrlUnitInfo cu = this.purReceivalBill.getStorageOrgUnit().getCU();
            ObjectUuidPK cuPK = null;
            cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
            try {
                filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            if (filter2 != null) {
                filter.mergeFilter(filter2, "and");
            }
            viewInfo.setFilter(filter);
            TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                TrackNumberInfo trackNumberInfo = coll.get(0);
                entry.setTrackNumber(trackNumberInfo);
            } else {
                throw new TaskExternalException(data.toString() + " " + PurReceivalImport.getResource(ctx, "TRACK_NUMBER_ERROR"));
            }
        }
    }

    private void doEntryMaterial(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        MaterialInfo materialInfo;
        Object cellData = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        if (cellData != null && cellData.toString().trim().length() > 0) {
            String materialNum = cellData.toString().trim();
            materialInfo = null;
            if (this.dataPool.getMaterialInfoInfo(materialNum) == null) {
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                MaterialCollection collection = imaterial.getMaterialCollection(this.getFilter(materialNum));
                if (collection != null && collection.size() > 0) {
                    materialInfo = collection.get(0);
                }
            } else {
                materialInfo = this.dataPool.getMaterialInfoInfo(materialNum);
            }
            if (materialInfo == null) {
                String str = PurReceivalImport.getResource(ctx, "MATERIAL_NOT_FIND");
                throw new TaskExternalException(str);
            }
        } else {
            String str = PurReceivalImport.getResource(ctx, "MATERIAL_NOT_NULL");
            throw new TaskExternalException(str);
        }
        entryInfo.setMaterial(materialInfo);
        this.loadMaterialOtherInfo(ctx, entryInfo);
    }

    private void loadMaterialOtherInfo(Context ctx, PurReceivalEntryInfo entryInfo) throws BOSException, TaskExternalException {
        if (this.sou == null || this.cou == null) {
            return;
        }
        String mID = entryInfo.getMaterial().getId().toString();
        String compayID = this.cou.getId().toString();
        String ckey = mID + compayID;
        if (this.dataPool.getMaterialCompanyInfoInfo(ckey) == null) {
            Map cmap = InvServerUtils.getMatCompanyInfoCollection(ctx, new String[]{mID}, new String[]{compayID});
            if (cmap != null && cmap.size() > 0) {
                MaterialCompanyInfoInfo cInfo = (MaterialCompanyInfoInfo)cmap.get(ckey);
                this.dataPool.setMaterialCompanyInfoInfo(ckey, cInfo);
            } else {
                String str = PurReceivalImport.getResource(ctx, "MATERIAL_COMPANY_NOT_NULL");
                throw new TaskExternalException(str);
            }
        }
        String invID = this.sou.getId().toString();
        String invKey = mID + invID;
        if (this.dataPool.getMaterialInventoryInfo(invKey) == null) {
            Map invMap = InvServerUtils.getMatInventoryInfoCollection(ctx, new String[]{mID}, new String[]{invID});
            if (invMap != null && invMap.size() > 0) {
                MaterialInventoryInfo invInfo = (MaterialInventoryInfo)invMap.get(invKey);
                this.dataPool.setMaterialInventoryInfo(invKey, invInfo);
            } else {
                String str = PurReceivalImport.getResource(ctx, "MATERIAL_STORAGE_NOT_NULL");
                throw new TaskExternalException(str);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntryAssistProperty(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException {
        AsstAttrValueInfo info;
        block5: {
            block6: {
                if (entryInfo.getMaterial().getAssistAttr() == null) {
                    return;
                }
                Object data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
                info = null;
                if (data == null || data.toString().trim().length() <= 0) break block6;
                String number = data.toString();
                if (this.dataPool.getAsstAttrValueInfo(number) == null) {
                    if (entryInfo != null && entryInfo.getMaterial() != null && entryInfo.getMaterial().getAssistAttr() != null) {
                        IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                        String oql = "";
                        oql = number.indexOf("/") > 0 ? "select id,number,name where number='" + number + "' and compondingType.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "'" : "select id,number,name where number='" + number + "' and basictype.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "'";
                        AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(oql);
                        if (collection != null && collection.size() > 0) {
                            info = collection.get(0);
                            break block5;
                        } else {
                            String str = PurReceivalImport.getResource(ctx, "ASSTATTR_NOT_FIND");
                            throw new TaskExternalException(str);
                        }
                    }
                    info = this.dataPool.getAsstAttrValueInfo(number);
                }
                break block5;
            }
            String str = PurReceivalImport.getResource(ctx, "ASSTATTR_NOT_NULL");
            throw new TaskExternalException(str);
        }
        entryInfo.setAssistProperty(info);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntryLot(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws BOSException, EASBizException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
        if (!this.checkLotInfo(ctx, entryInfo.getMaterial(), data, entryInfo)) {
            entryInfo.setLot(null);
            return;
        }
        if (data != null && data.toString().trim().length() > 0) {
            entryInfo.setLot(data.toString().trim());
            return;
        }
        String str = PurReceivalImport.getResource(ctx, "LOT_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, PurReceivalEntryInfo entryInfo) throws BOSException, EASBizException, TaskExternalException {
        String mid = materialInfo.getId().toString();
        String key = mid + this.sou.getId().toString();
        MaterialInventoryInfo materialInventoryInfo = this.dataPool.getMaterialInventoryInfo(key);
        return materialInventoryInfo.isIsLotNumber();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntrySupplierLot(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws BOSException, EASBizException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_supplierLotNo")).data;
        if (!this.checkSupplierLotInfo(ctx, entryInfo.getMaterial(), data, entryInfo)) {
            entryInfo.setSupplierLotNo(null);
            return;
        }
        if (data != null && data.toString().trim().length() > 0) {
            entryInfo.setSupplierLotNo(data.toString().trim());
            return;
        }
        String str = PurReceivalImport.getResource(ctx, "SUPPLIERLOT_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private boolean checkSupplierLotInfo(Context ctx, MaterialInfo materialInfo, Object data, PurReceivalEntryInfo entryInfo) throws BOSException, EASBizException, TaskExternalException {
        String mid = materialInfo.getId().toString();
        String key = mid + this.sou.getId().toString();
        MaterialInventoryInfo materialInventoryInfo = this.dataPool.getMaterialInventoryInfo(key);
        return materialInventoryInfo.isIsBatchNo();
    }

    private void doEntryMfgExp(Context ctx, Hashtable lineData, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        String mid = entryInfo.getMaterial().getId().toString();
        String key = mid + this.sou.getId().toString();
        MaterialInventoryInfo materialInventory = this.dataPool.getMaterialInventoryInfo(key);
        if (materialInventory.isIsPeriodValid()) {
            String lot = ((DataToken)lineData.get((Object)"FEntry_lot")).data.toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            DateOfMinDurabilityCollection dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
            if (dateCol != null && dateCol.size() > 0) {
                DateOfMinDurabilityInfo dateInfo = dateCol.get(0);
                entryInfo.setMfg(dateInfo.getMfg());
                entryInfo.setExp(dateInfo.getExp());
            } else {
                String[] DATE_ENTRY_PROPERTY = new String[]{"FEntry_mfg", "FEntry_exp"};
                for (int i = 0; i < DATE_ENTRY_PROPERTY.length; ++i) {
                    Date value;
                    Object o = ((DataToken)lineData.get((Object)DATE_ENTRY_PROPERTY[i])).data;
                    if (o == null || o.toString().length() <= 0 || (o = ImRptAppUtils.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value = (Date)o) == null || !materialInventory.isIsPeriodValid()) continue;
                    if (i == 0) {
                        entryInfo.setMfg(value);
                        continue;
                    }
                    entryInfo.setExp(value);
                }
                if (materialInventory.isIsPeriodValid() && (entryInfo.getExp() == null || entryInfo.getMfg() == null)) {
                    throw new TaskExternalException(SCMUtils.getResource((String)resourcesofother, (String)"IsPeriodValidNoExpandMfg", (Context)ctx));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntryUnit(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        MeasureUnitInfo measureUnitInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            String unitNumber;
            block4: {
                unitNumber = data.toString().trim();
                if (this.dataPool.getMeasureUnitInfo(unitNumber) == null) {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    MeasureUnitCollection collection = imu.getMeasureUnitCollection(this.getFilter(unitNumber));
                    if (collection != null && collection.size() > 0) {
                        measureUnitInfo = collection.get(0);
                        break block4;
                    } else {
                        String str = PurReceivalImport.getResource(ctx, "UNTI_NOT_FIND");
                        throw new TaskExternalException(str);
                    }
                }
                measureUnitInfo = this.dataPool.getMeasureUnitInfo(unitNumber);
            }
            this.checkUnit(ctx, entryInfo.getMaterial(), measureUnitInfo);
            entryInfo.setUnit(measureUnitInfo);
            this.dataPool.setMeasureUnitInfo(unitNumber, measureUnitInfo);
            return;
        }
        String str = PurReceivalImport.getResource(ctx, "UNTI_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo aMultiMeasureUnitInfo = null;
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)mui.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("measureUnitType", (Object)2, CompareType.NOTEQUALS));
        entity.setFilter(filter);
        SelectorItemCollection sc = entity.getSelector();
        sc.add(new SelectorItemInfo("id"));
        MultiMeasureUnitCollection coll = immu.getMultiMeasureUnitCollection(entity);
        if (coll != null && coll.size() != 0) {
            aMultiMeasureUnitInfo = coll.get(0);
        }
        if (aMultiMeasureUnitInfo == null) {
            throw new TaskExternalException(materialInfo.getNumber() + PurReceivalImport.getResource(ctx, "UNTI_NOT_FIND"));
        }
    }

    private void doEntryQty(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data != null && data.toString().length() > 0) {
            try {
                BigDecimal qty = ImRptAppUtils.getDataDeciaml(ctx, data.toString());
                entryInfo.setQty(qty);
            }
            catch (Exception e) {
                String str = PurReceivalImport.getResource(ctx, "QTY_ERROR");
                throw new TaskExternalException(str);
            }
        } else {
            String str = PurReceivalImport.getResource(ctx, "QTY_NOT_ERROR");
            throw new TaskExternalException(str);
        }
    }

    private void doEntryBaseUnit(Context ctx, Hashtable lineData, PurReceivalEntryInfo entryInfo) throws BOSException, EASBizException {
        if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getBaseUnit().getId() != null) {
            MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getBaseUnit().getId()));
            entryInfo.setBaseUnit(baseUnitInfo);
            if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                entryInfo.setBaseQty(baseUnitQty);
            }
        }
    }

    private void doEntryAssistUnit(Context ctx, PurReceivalEntryInfo entryInfo, Hashtable lineData) throws TaskExternalException, EASBizException, BOSException {
        entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
        if (entryInfo.getAssistUnit() != null) {
            Object cellData = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
            try {
                BigDecimal assistQty = ImRptAppUtils.getDataDeciaml(ctx, cellData.toString());
                entryInfo.setAssistQty(assistQty);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        } else {
            entryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntryWarehs(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$warehouse_number")).data;
        WarehouseInfo warehouseInfo = null;
        if (data != null && data.toString() != null && data.toString().length() > 0) {
            block4: {
                String warehsNumber = data.toString();
                if (this.dataPool.getWarehouseInfo(warehsNumber) == null) {
                    IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
                    WarehouseCollection collection = iw.getWarehouseCollection(this.getFilter(warehsNumber));
                    if (collection != null && collection.size() > 0) {
                        warehouseInfo = collection.get(0);
                        this.checkWarehouse(ctx, warehouseInfo, this.sou);
                        this.dataPool.setWarehouseInfo(warehsNumber, warehouseInfo);
                        break block4;
                    } else {
                        String str = PurReceivalImport.getResource(ctx, "WAREHS_NOT_EXIST");
                        throw new TaskExternalException(str);
                    }
                }
                warehouseInfo = this.dataPool.getWarehouseInfo(warehsNumber);
            }
            entryInfo.setWarehouse(warehouseInfo);
            return;
        }
        String str = PurReceivalImport.getResource(ctx, "WAREHS_NOT_NULL");
        throw new TaskExternalException(str);
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws BOSException, TaskExternalException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        try {
            if (!iso.exists(fi)) {
                throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + PurReceivalImport.getResource(ctx, "RelationNotExists"));
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doEntryLocation(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException {
        LocationCollection collection;
        LocationInfo info;
        Object data = ((DataToken)lineData.get((Object)"FEntry$location_number")).data;
        WarehouseInfo warehouseInfo = entryInfo.getWarehouse();
        if (warehouseInfo == null || !warehouseInfo.isHasLocation()) {
            return;
        }
        if (data != null && data.toString().trim().length() > 0) {
            String warehsNumber = data.toString().trim();
            info = null;
            ILocation il = LocationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)warehsNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filter);
            collection = il.getLocationCollection(viewInfo);
            if (collection == null || collection.size() <= 0) {
                String str = PurReceivalImport.getResource(ctx, "LOCATION_NOT_FIND");
                throw new TaskExternalException(str);
            }
        } else {
            String str = PurReceivalImport.getResource(ctx, "LOCATION_NOT_NULL");
            throw new TaskExternalException(str);
        }
        info = collection.get(0);
        entryInfo.setLocation(info);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEntryStocker(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException {
        int i = 0;
        while (i < ENTRY_PERSON_FIELDS.length) {
            Object data = ((DataToken)lineData.get((Object)PurReceivalImport.ENTRY_PERSON_FIELDS[i])).data;
            if (data != null && data.toString().trim().length() > 0) {
                String personNumber = data.toString().trim();
                PersonInfo info = null;
                if (this.dataPool.getPersonInfo(personNumber) == null) {
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection collection = iPerson.getPersonCollection(this.getFilter(personNumber));
                    if (collection != null && collection.size() > 0) {
                        info = collection.get(0);
                        if (info == null) {
                            String str = PurReceivalImport.getResource(ctx, "ENTRY_PERSION_ERROR");
                            throw new TaskExternalException(str);
                        }
                        this.dataPool.setPersonInfo(personNumber, info);
                    }
                } else {
                    info = this.dataPool.getPersonInfo(personNumber);
                }
                entryInfo.put(ENTRY_PERSON_OBJ_EN[i], info);
            }
            ++i;
        }
        return;
    }

    private void doEntryStandardCost(Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException {
        String mid = entryInfo.getMaterial().getId().toString();
        String couID = this.cou.getId().toString();
        String key = mid + couID;
        MaterialCompanyInfoInfo materialCompanyInfo = this.dataPool.getMaterialCompanyInfoInfo(key);
        if (materialCompanyInfo != null) {
            BigDecimal unitStandardcost = materialCompanyInfo.getStandardCost();
            if (unitStandardcost != null) {
                BigDecimal standardcost = unitStandardcost.multiply(entryInfo.getQty());
                entryInfo.setUnitStandardCost(unitStandardcost);
                entryInfo.setStandardCost(standardcost);
            } else {
                entryInfo.setUnitStandardCost(SCMConstant.BIGDECIMAL_ZERO);
                entryInfo.setStandardCost(SCMConstant.BIGDECIMAL_ZERO);
            }
        }
    }

    private void doEntryPurchaseOrgUnit(Hashtable lineData, Context ctx, PurReceivalEntryInfo entryInfo) throws TaskExternalException, BOSException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$purchaseOrgUnit_number")).data;
        if (data != null && data.toString().trim().length() > 0) {
            PurchaseOrgUnitInfo info = null;
            String purOrgNumber = data.toString().trim();
            if (this.dataPool.getPurchaseOrgUnitInfo(purOrgNumber) == null) {
                IPurchaseOrgUnit purchaseOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = purchaseOrgUnit.getPurchaseOrgUnitCollection(this.getFilter(purOrgNumber));
                if (collection != null && collection.size() > 0) {
                    info = collection.get(0);
                    this.dataPool.setPurchaseOrgUnitInfo(purOrgNumber, info);
                }
            } else {
                info = this.dataPool.getPurchaseOrgUnitInfo(purOrgNumber);
            }
            if (info == null) {
                String str = PurReceivalImport.getResource(ctx, "PURORG_NOT_EXIST");
                throw new TaskExternalException(str);
            }
            entryInfo.setPurchaseOrgUnit(info);
        }
    }

    private void doEntryFilesByRI(PurReceivalEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        boolean flag = !InvAppUtils.isNegative(this.purReceivalBill.getTransactionType());
        for (String entryField2 : ENTRY_QTY_AMOUNT_FIELDS) {
            if (entryInfo.get(entryField2) == null) continue;
            if (flag) {
                value = (BigDecimal)entryInfo.get(entryField2);
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    private void doEntryOtherField(Hashtable lineData, PurReceivalEntryInfo entryInfo) {
        Object o = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (o != null) {
            String remark = o.toString().trim();
            if (remark.length() > 255) {
                remark = remark.substring(0, 255);
            }
            entryInfo.setRemark(remark);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "purreceival_export");
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.PurReceivalBillQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FSupplier_number", rs.getString("supplier.number"));
            this.putTable(result, "FSupplier_name_l2", rs.getString("supplier.name"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            this.putTable(result, "FTransactionType_number", rs.getString("transactionType.number"));
            this.putTable(result, "FTransactionType_name_l2", rs.getString("transactionType.name"));
            this.putTable(result, "FCreator_number", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("createTime")));
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name_l2", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FIsInitBill", rs.getString("isInitBill"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("department.number"));
            this.putTable(result, "FEntry$warehouse_number", rs.getString("warehouse.number"));
            this.putTable(result, "FEntry$location_number", rs.getString("lcoation.number"));
            this.putTable(result, "FEntry$stocker_number", rs.getString("stocker.number"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$material_name_l2", rs.getString("material.name"));
            this.putTable(result, "FEntry$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry$purchaseOrgUnit_number", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FEntry_supplierLotNo", rs.getString("entry.supplierLotNo"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString().length() < 1) {
                result.put("FEntry_qty", DataImportUtils.transformValue(null));
            } else {
                qty = new BigDecimal(rs.getString("entry.qty"));
                result.put("FEntry_qty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString().length() < 1) {
                result.put("FEntry_assistQty", DataImportUtils.transformValue(null));
            } else {
                BigDecimal assistQty = new BigDecimal(rs.getString("entry.assistQty"));
                result.put("FEntry_assistQty", ImRptAppUtils.fmtDecimalStr(ctx, assistQty));
            }
            this.putTable(result, "FEntry_lot", rs.getString("entry.lot"));
            this.putTable(result, "FEntry_mfg", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.mfg")));
            this.putTable(result, "FEntry_exp", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.exp")));
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
            this.putTable(result, "FEntry$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntry$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FEntry$qualityOrgUnit_name_l2", rs.getString("qualityOrgUnit.name"));
            this.putTable(result, "FEntry_isCheck", rs.getString("entry.isCheck"));
            this.putTable(result, "FEntry_isUrgentPass", rs.getString("entry.isUrgentPass"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.checkQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.checkQty")).toString().length() < 1) {
                result.put("FEntry_checkQty", DataImportUtils.transformValue(null));
            } else {
                qty = new BigDecimal(rs.getString("entry.checkQty"));
                result.put("FEntry_checkQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.qualifiedQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.qualifiedQty")).toString().length() < 1) {
                result.put("FEntry_qualifiedQty", DataImportUtils.transformValue(null));
            } else {
                qty = new BigDecimal(rs.getString("entry.qualifiedQty"));
                result.put("FEntry_qualifiedQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.unqualifiedQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.unqualifiedQty")).toString().length() < 1) {
                result.put("FEntry_unqualifiedQty", DataImportUtils.transformValue(null));
            } else {
                qty = new BigDecimal(rs.getString("entry.unqualifiedQty"));
                result.put("FEntry_unqualifiedQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.checkReturnedQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.checkReturnedQty")).toString().length() < 1) {
                result.put("FEntry_checkReturnedQty", DataImportUtils.transformValue(null));
            } else {
                qty = new BigDecimal(rs.getString("entry.checkReturnedQty"));
                result.put("FEntry_checkReturnedQty", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public String getImportPermissionItem() {
        return "purreceival_new";
    }
}

