/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowBizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractPurReceivalWebFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.PurContractCollection;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurReceivalWebFacadeControllerBean
extends AbstractPurReceivalWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.PurReceivalWebFacadeControllerBean");

    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        PurReceivalBillInfo info;
        Map<String, StorageOrgUnitInfo> map = new HashMap();
        if (StringUtils.isEmpty((String)oprtState)) {
            return null;
        }
        StorageOrgUnitInfo orgInfo = null;
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            orgInfo = (StorageOrgUnitInfo)ctx.get((Object)"purRec_storageOrgInfo");
            if (orgInfo == null) {
                orgInfo = ctx.get((Object)"purRec_addnew_storageOrgInfo") != null ? (StorageOrgUnitInfo)ctx.get((Object)"purRec_addnew_storageOrgInfo") : this.getDefaultMainOrg(ctx);
                map = this.getMap(ctx, orgInfo, oprtState, null);
                map.put("storageOrgUnit", orgInfo);
            } else {
                map = this.getMap(ctx, orgInfo, oprtState, null);
                map.put("isCopy", (StorageOrgUnitInfo)Boolean.valueOf(true));
                ctx.put((Object)"purRec_storageOrgInfo", null);
            }
        } else if (OprtStateConstant.EDIT.equals(oprtState)) {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            info = this.getBillInfoById(ctx, id);
            orgInfo = info.getStorageOrgUnit();
            map = this.getMap(ctx, info.getStorageOrgUnit(), oprtState, info);
            map.put("info", (StorageOrgUnitInfo)info);
        } else if (OprtStateConstant.VIEW.equals(oprtState)) {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            info = this.getBillInfoById(ctx, id);
            map.put("sourceBillType", (StorageOrgUnitInfo)info.getSourceBillType());
            map.put("cachePrecision", (StorageOrgUnitInfo)this.cachePrecision(ctx, info));
        }
        if (orgInfo != null) {
            CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)new PurReceivalBillInfo(), orgInfo.getId().toString());
            map.put("number_isEdit", (StorageOrgUnitInfo)Boolean.valueOf(true));
            if (ruleInfo != null) {
                map.put("number_isEdit", (StorageOrgUnitInfo)Boolean.valueOf(ruleInfo.isIsModifiable()));
            }
            Map paramMap = this.batchGetParamValue(ctx, orgInfo.getId().toString(), new String[]{"INM004", "INM008"});
            map.put("params", (StorageOrgUnitInfo)paramMap);
        }
        return map;
    }

    private Map cachePrecision(Context ctx, PurReceivalBillInfo info) throws BOSException, EASBizException {
        HashMap<String, ArrayList<Object>> cacheData = new HashMap<String, ArrayList<Object>>();
        if (info == null) {
            return null;
        }
        PurReceivalEntryCollection entryCol = info.getEntry();
        PurReceivalEntryInfo entryInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<Integer> precisionList = new ArrayList<Integer>();
        if (entryCol != null && entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                if (entryInfo.getMaterial() != null) {
                    materialSet.add(entryInfo.getMaterial().getId().toString());
                }
                if (entryInfo.getUnit() == null) continue;
                unitSet.add(entryInfo.getUnit().getId().toString());
            }
        }
        if (materialSet.size() == 0 || unitSet.size() == 0) {
            return null;
        }
        if (materialSet.size() > 0 && unitSet.size() > 0) {
            this.getMeasureUnitPrecision(ctx, entryCol, materialSet, unitSet, idList, precisionList);
        } else {
            this.getMaterialPrecision(ctx, materialSet, idList, precisionList);
        }
        cacheData.put("precisionIdList", idList);
        cacheData.put("precisionList", precisionList);
        return cacheData;
    }

    private void getMaterialPrecision(Context ctx, Set<String> materialSet, List<String> idList, List<Integer> precisionList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("pricePrecision"));
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        MaterialInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                idList.add(info.getId().toString());
                precisionList.add(info.getPricePrecision());
            }
        }
    }

    private void getMeasureUnitPrecision(Context ctx, PurReceivalEntryCollection entryCol, Set<String> materialSet, Set<String> unitSet, List<String> idList, List<Integer> precisionList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.pricePrecision"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        HashMap<String, Integer> precisionMap = new HashMap<String, Integer>();
        for (int i = 0; i < col.size(); ++i) {
            precisionMap.put(col.get(i).getMaterial().getId().toString() + col.get(i).getMeasureUnit().getId().toString(), col.get(i).getQtyPrecision());
        }
        Object info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                RowTypeInfo rowType = null;
                if (entryCol.get(i).getBillRowType() != null && entryCol.get(i).getBillRowType().getId() != null) {
                    rowType = (RowTypeInfo)RowTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(entryCol.get(i).getBillRowType().getId().toString()));
                }
                if (rowType != null && rowType.isIsHasMaterialNumber() && entryCol.get(i).getMaterial() != null && entryCol.get(i).getUnit() != null) {
                    idList.add(entryCol.get(i).getMaterial().getId().toString() + entryCol.get(i).getUnit().getId().toString());
                    precisionList.add((Integer)precisionMap.get(entryCol.get(i).getMaterial().getId().toString() + entryCol.get(i).getUnit().getId().toString()));
                    continue;
                }
                PurReceivalEntryInfo entryInfo = entryCol.get(i);
                if (entryInfo.getUnit() == null) continue;
                idList.add(entryInfo.getUnit().getId().toString());
                precisionList.add(entryInfo.getUnit().getQtyPrecision());
            }
        }
    }

    private StorageOrgUnitInfo getDefaultMainOrg(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Storage, null, "purreceival_new");
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(ctx, fullCompanyColl);
        return orgInfo;
    }

    private Map getMap(Context ctx, StorageOrgUnitInfo orgInfo, String oprtState, PurReceivalBillInfo info) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizTypeF7Filter", "billType.number = '101' and billBizType.selfmade = 1 and status=1 and id in (select fid from T_SCM_BizType where fbizcategoryid <> '+f4mYqj4xUGaNf69/HWRdqk4kCA=')");
        map.put("transactionTypeF7Filter", "billType.number = '101' and ritype.bizdirection = 1 ");
        map.put("storageOrgF7Filter", this.getMainOrgFilter(ctx));
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            map.put("baseStatus", BillBaseStatusEnum.ADD);
        }
        Calendar cal = Calendar.getInstance();
        map.put("bizDate", cal.getTime());
        BizTypeInfo bizType = null;
        TransactionTypeInfo tti = null;
        bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)"d8e80652-0106-1000-e000-04c5c0a812202407435C", (String)"50957179-0105-1000-e000-0157c0a812fd463ED552");
        if (bizType != null) {
            tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-0157c0a812fd463ED552", bizType.getId().toString());
        }
        if (OprtStateConstant.EDIT.equals(oprtState)) {
            tti = info.getTransactionType();
        }
        if (tti != null) {
            tti = this.getTransactionTypeInfo(ctx, tti.getId().toString());
        }
        map.put("transactionType", tti);
        map.put("bizType", bizType);
        if (orgInfo != null) {
            OrgUnitCollection companyOrgUnitCollection;
            OrgUnitCollection adminOrgUnitCollection = this.getOrgUnitColl(ctx, orgInfo.getId().toString(), OrgType.Storage, OrgType.Admin);
            if (adminOrgUnitCollection != null && adminOrgUnitCollection.size() > 0) {
                map.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, adminOrgUnitCollection));
            }
            if (orgInfo != null && orgInfo.getId() != null && (companyOrgUnitCollection = this.getOrgUnitColl(ctx, orgInfo.getId().toString(), OrgType.Storage, OrgType.Company)).size() > 0 && companyOrgUnitCollection.get(0).getId() != null) {
                map.put("supplierF7Filter", " usedStatus = 1 AND supplierCompany.usingStatus = 0 and companyOrgUnit.id in " + this.getOrgFilterStr(ctx, companyOrgUnitCollection));
            }
            String bizOrgCUID = CUIDGetterFacadeFactory.getRemoteInstance().getCUID(orgInfo.getId().toString());
            map.put("bizOrgCUID", bizOrgCUID);
        }
        map.put("defaultEntryMap", this.getEntryDefault(ctx, orgInfo, tti));
        map.put("companyOrgUnit", this.getCompanyOrgInfo(ctx, orgInfo));
        if (info != null) {
            HashSet<String> contractNumberSet = new HashSet<String>();
            PurReceivalEntryCollection entryCol = info.getEntry();
            PurReceivalEntryInfo entry = null;
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = entryCol.get(i);
                if (entry.getContractNumber() == null) continue;
                contractNumberSet.add(entry.getContractNumber());
            }
            if (contractNumberSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", contractNumberSet, CompareType.INCLUDE));
                view.setFilter(filter);
                PurContractCollection purContractCollection = PurContractFactory.getLocalInstance((Context)ctx).getPurContractCollection(view);
                HashMap<String, PurContractInfo> contractMap = new HashMap<String, PurContractInfo>();
                for (int i = 0; i < purContractCollection.size(); ++i) {
                    contractMap.put(purContractCollection.get(i).getNumber(), purContractCollection.get(i));
                }
                map.put("contractMap", contractMap);
            }
        }
        return map;
    }

    private TransactionTypeInfo getTransactionTypeInfo(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("riType.id"));
        sic.add(new SelectorItemInfo("riType.bizDirection"));
        TransactionTypeInfo info = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return info;
    }

    private Object getEntryDefault(Context ctx, StorageOrgUnitInfo orgInfo, TransactionTypeInfo tti) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("rowType.number"));
        view.setSorter(sort);
        CoreBaseCollection rowBizTypeCollection = RowBizTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (rowBizTypeCollection != null && rowBizTypeCollection.size() > 0) {
            map.put("billRowType", ((RowBizTypeInfo)rowBizTypeCollection.get(0)).getRowType());
            map.put("destinationType", ((RowBizTypeInfo)rowBizTypeCollection.get(0)).getRowType().getDestinationType());
        } else {
            map.put("billRowType", "");
            map.put("destinationType", "");
        }
        InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType("50957179-0105-1000-e000-0157c0a812fd463ED552", tti);
        map.put("invUpdateType", invUpdateTypeInfo);
        if (tti == null) {
            map.put("invUpdateTypeF7Filter", " status = 1");
        } else {
            map.put("invUpdateTypeF7Filter", "transactionType.id = " + tti.getId().toString() + "status  = 1");
        }
        QualityOrgUnitInfo qualityOrgUnitInfo = null;
        PurchaseOrgUnitInfo purOrgUnitInfo = null;
        if (orgInfo != null) {
            OrgUnitCollection purOrgUnitCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(orgInfo.getId().toString(), 4, 3);
            purOrgUnitInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(orgInfo.getId().toString());
            map.put("purchaseOrgUnit", purOrgUnitInfo);
            map.put("purchaseOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, purOrgUnitCollection));
            OrgUnitCollection qualityOrgUnitCollection = this.getOrgUnitColl(ctx, orgInfo.getId().toString(), OrgType.Storage, OrgType.Quality);
            QualityOrgUnitInfo qualityOrgUnit = ContextUtil.getCurrentQualityUnit((Context)ctx);
            if (qualityOrgUnit != null) {
                for (int i = 0; i < qualityOrgUnitCollection.size(); ++i) {
                    if (!qualityOrgUnit.getId().toString().equals(qualityOrgUnitCollection.get(i).getId().toString())) continue;
                    qualityOrgUnitInfo = (QualityOrgUnitInfo)qualityOrgUnitCollection.get(i);
                    break;
                }
            }
            if (qualityOrgUnitInfo == null) {
                qualityOrgUnitInfo = (QualityOrgUnitInfo)qualityOrgUnitCollection.get(0);
            }
            map.put("qualityOrgUnit", qualityOrgUnitInfo);
            map.put("qualityOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, qualityOrgUnitCollection));
            map.put("baseStatus", EntryBaseStatusEnum.ADD);
        }
        return map;
    }

    private OrgUnitCollection getOrgUnitColl(Context ctx, String orgId, OrgType fromOrgType, OrgType toOrgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = null;
        orgUnitCollection = toOrgType.equals((Object)OrgType.Storage) ? iOrgUnitRelation.getFromUnit(orgId, toOrgType.getValue(), fromOrgType.getValue()) : iOrgUnitRelation.getToUnit(orgId, fromOrgType.getValue(), toOrgType.getValue());
        return orgUnitCollection;
    }

    private OrgUnitInfo getDefaultMainBizOrg(Context ctx, FullOrgUnitCollection fullOrgColl) throws EASBizException, BOSException {
        HashSet<String> orgSet = new HashSet<String>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgSet.add(fullOrgColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Integer.valueOf("1")));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        view.setSelector(sic);
        view.setFilter(filter);
        StorageOrgUnitCollection orgUnitCollection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[orgUnitCollection.size()];
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            orgUnitInfos[i] = orgUnitCollection.get(i);
        }
        orgUnitInfos = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])orgUnitInfos, (boolean)true);
        StorageOrgUnitInfo currentOrgInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        if (currentOrgInfo != null && orgUnitInfos != null && orgUnitInfos.length > 0) {
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (!currentOrgInfo.getId().toString().equals(orgUnitInfos[i].getId().toString())) continue;
                return currentOrgInfo;
            }
        }
        if (orgUnitInfos != null && orgUnitInfos.length > 0) {
            return orgUnitInfos[0];
        }
        return null;
    }

    private PurReceivalBillInfo getBillInfoById(Context ctx, String id) throws EASBizException, BOSException {
        return (PurReceivalBillInfo)PurReceivalBillFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id), this.getSelector());
    }

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PurReceivalBillInfo purReceivalInfo = (PurReceivalBillInfo)info;
        SCMUtil.checkSupplierEnable((Context)ctx, (IObjectValue)info);
        TransactionTypeInfo transactionTypeInfo = purReceivalInfo.getTransactionType();
        transactionTypeInfo = this.getTransactionTypeInfo(ctx, transactionTypeInfo.getId().toString());
        purReceivalInfo.setTransactionType(transactionTypeInfo);
        PurReceivalEntryCollection receivalEntryCollection = (PurReceivalEntryCollection)purReceivalInfo.getEntries();
        HashSet<String> rowTypeIdSet = new HashSet<String>();
        for (int i = 0; i < receivalEntryCollection.size(); ++i) {
            if (receivalEntryCollection.get(i).getBillRowType() == null) continue;
            rowTypeIdSet.add(receivalEntryCollection.get(i).getBillRowType().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("requestOrgType"));
        sic.add(new SelectorItemInfo("precision"));
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", rowTypeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        RowTypeCollection rowTypeCollection = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeCollection(view);
        HashMap<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
        for (int i = 0; i < rowTypeCollection.size(); ++i) {
            rowTypeMap.put(rowTypeCollection.get(i).getId().toString(), rowTypeCollection.get(i));
        }
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        if (receivalEntryCollection.get(0).getInvUpdateType() != null) {
            String invUpdateTypeId = receivalEntryCollection.get(0).getInvUpdateType().getId().toString();
            sic.clear();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isNotUpdateInv"));
            invUpdateTypeInfo = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(invUpdateTypeId), sic);
        }
        String rowTypeId = null;
        for (int i = 0; i < receivalEntryCollection.size(); ++i) {
            if (receivalEntryCollection.get(i).getBillRowType() != null && rowTypeMap.containsKey(rowTypeId = receivalEntryCollection.get(i).getBillRowType().getId().toString())) {
                receivalEntryCollection.get(i).setBillRowType((RowTypeInfo)rowTypeMap.get(rowTypeId));
            }
            if (receivalEntryCollection.get(i).getInvUpdateType() == null) continue;
            receivalEntryCollection.get(i).setInvUpdateType(invUpdateTypeInfo);
        }
        return null;
    }

    @Override
    protected Map _getLocationFilter(Context ctx, Map request) throws BOSException, EASBizException {
        HashMap<String, LocationInfo> data = new HashMap<String, LocationInfo>();
        String storageOrgUnitId = (String)request.get("storageOrgUnitId");
        String materialId = (String)request.get("materialId");
        JSONObject wareHouse = JSONObject.fromObject(request.get("wareHouse"));
        if (wareHouse.isNullObject() && wareHouse.isEmpty()) {
            return null;
        }
        if (((Boolean)wareHouse.get("hasLocation")).booleanValue()) {
            LocationInfo defaultloc = this.getDefaultLocation(storageOrgUnitId, materialId, wareHouse, ctx);
            data.put("defaultloc", defaultloc);
        }
        return data;
    }

    private LocationInfo getDefaultLocation(String storageOrgUnitId, String materialId, JSONObject wareHouse, Context ctx) throws BOSException {
        try {
            if (!StringUtils.isEmpty((String)storageOrgUnitId) && !StringUtils.isEmpty((String)materialId)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)storageOrgUnitId.toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)materialId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)wareHouse.get("id").toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("isDefaultLocation", (Object)Boolean.TRUE));
                viewInfo.setFilter(filterInfo);
                IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
                if (imsa != null) {
                    IObjectPK[] pks = imsa.getPKList(filterInfo, null);
                    ILocation il = LocationFactory.getLocalInstance((Context)ctx);
                    int recs = pks.length;
                    if (recs > 0) {
                        if (imsa.getMaterialStorageAssignInfo(pks[0]).getLocation() != null) {
                            ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getLocation().getBOSUuid("id"));
                            return il.getLocationInfo((IObjectPK)pk);
                        }
                        return null;
                    }
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected Map _handleOrgChange(Context ctx, Map request) throws BOSException, EASBizException {
        OrgUnitCollection adminOrgUnitCollection;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String storageOrgUnitId = (String)request.get("orgId");
        StorageOrgUnitInfo orgInfo = new StorageOrgUnitInfo();
        orgInfo.setId(BOSUuid.read((String)storageOrgUnitId));
        OrgUnitCollection purOrgUnitCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnitId, 4, 3);
        if (purOrgUnitCollection.size() > 0) {
            PurchaseOrgUnitInfo purOrgInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(storageOrgUnitId);
            data.put("purchaseOrgUnit", purOrgInfo);
            data.put("purchaseOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, purOrgUnitCollection));
        } else {
            data.put("purchaseOrgUnit", "");
        }
        OrgUnitCollection qualityOrgUnitCollection = this.getOrgUnitColl(ctx, storageOrgUnitId, OrgType.Storage, OrgType.Quality);
        if (qualityOrgUnitCollection.size() > 0) {
            QualityOrgUnitInfo qualityOrgUnit = (QualityOrgUnitInfo)qualityOrgUnitCollection.get(0);
            data.put("qualityOrgUnit", qualityOrgUnit);
            data.put("qualityOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, qualityOrgUnitCollection));
        } else {
            data.put("qualityOrgUnit", "");
        }
        OrgUnitCollection companyOrgUnitCollection = this.getOrgUnitColl(ctx, storageOrgUnitId, OrgType.Storage, OrgType.Company);
        if (companyOrgUnitCollection.size() > 0 && companyOrgUnitCollection.get(0).getId() != null) {
            data.put("supplierF7Filter", " usedStatus = 1 AND supplierCompany.usingStatus = 0 and companyOrgUnit.id in " + this.getOrgFilterStr(ctx, companyOrgUnitCollection));
        }
        if ((adminOrgUnitCollection = this.getOrgUnitColl(ctx, storageOrgUnitId, OrgType.Storage, OrgType.Admin)) != null && adminOrgUnitCollection.size() > 0) {
            data.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, adminOrgUnitCollection));
        }
        data.put("companyOrgUnit", this.getCompanyOrgInfo(ctx, orgInfo));
        String bizOrgCUID = CUIDGetterFacadeFactory.getRemoteInstance().getCUID(orgInfo.getId().toString());
        data.put("bizOrgCUID", bizOrgCUID);
        Map paramMap = this.batchGetParamValue(ctx, orgInfo.getId().toString(), new String[]{"INM004", "INM008"});
        data.put("params", paramMap);
        return data;
    }

    @Override
    protected Map _handleTypeChange(Context ctx, Map request) throws BOSException, EASBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String fieldName = (String)request.get("fieldName");
        String typeId = (String)request.get("typeId");
        TransactionTypeInfo tti = null;
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        if (fieldName.equals("bizType")) {
            tti = InvCommonUtils.getDefaultTransactionType(null, "50957179-0105-1000-e000-0157c0a812fd463ED552", typeId);
            invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType("50957179-0105-1000-e000-0157c0a812fd463ED552", tti);
            data.put("transactionType", tti);
            data.put("invUpdateType", invUpdateTypeInfo);
        } else if (fieldName.equals("transactionType")) {
            invUpdateTypeInfo = TransactionTypeFactory.getLocalInstance((Context)ctx).getDefaultInvUpdateType(typeId);
            data.put("invUpdateType", invUpdateTypeInfo);
        }
        return data;
    }

    private CompanyOrgUnitInfo getCompanyOrgInfo(Context ctx, StorageOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection companyOrgUnitCollection;
        if (orgInfo != null && orgInfo.getId() != null && (companyOrgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(orgInfo.getId().toString(), 4, 1)) != null && companyOrgUnitCollection.size() > 0) {
            return (CompanyOrgUnitInfo)companyOrgUnitCollection.get(0);
        }
        return null;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = SCMSelectorFactory.getInvBillBaseSelector((boolean)true);
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.id"));
        selector.add(new SelectorItemInfo("entry.sourceBillType.number"));
        selector.add(new SelectorItemInfo("entry.billRowType.isHasMaterialNumber"));
        selector.add(new SelectorItemInfo("entry.billRowType.id"));
        selector.add(new SelectorItemInfo("entry.billRowType.number"));
        selector.add(new SelectorItemInfo("entry.billRowType.name"));
        selector.add(new SelectorItemInfo("entry.billRowType.destinationType"));
        selector.add(new SelectorItemInfo("entry.contractNumber"));
        return selector;
    }

    public String getPermissionItem() {
        return "purreceival_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }
}

