/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.app.AbstractRelationOfChildAndParentFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RelationOfChildAndParentFacadeControllerBean
extends AbstractRelationOfChildAndParentFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.RelationOfChildAndParentFacadeControllerBean");
    public static final String RES_InvUI = "com.kingdee.eas.scm.im.inv.app.RelationOfChildAndParentResource";
    private static final String RES = "com.kingdee.eas.scm.im.inv.MergeSplitedResource";

    @Override
    protected void _delete(Context ctx, BOSUuid billId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_IV_RelationOfChildAndParent");
        sql.append(" where FID = ");
        sql.append(billId.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _saleIssueAddChildOrderToParent(Context ctx, IObjectValue saleIssueBill, IObjectValue childSaleIssueBill, String motherEntryId, String childEntryId, String rootId) throws BOSException, EASBizException {
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)saleIssueBill;
        SaleIssueBillInfo childSaleIssueBillInfo = (SaleIssueBillInfo)childSaleIssueBill;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_IV_RelationOfChildAndParent (FID,FDocumentType,FMotherNumber,FMotherId,FMotherEntryId,FChildNumber,FChildId,FChildEntryId,FIsUnAudit,FRootID) ");
        sql.append(" VALUES ( ?,?,?,?,?,?,?,?,?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BOSUuid.create((String)"88888888").toString(), EASResource.getString((String)RES_InvUI, (String)"SaleIssue"), saleIssueBillInfo.getNumber(), saleIssueBillInfo.getId().toString(), motherEntryId, childSaleIssueBillInfo.getNumber(), childSaleIssueBillInfo.getId().toString(), childEntryId, 0, rootId});
    }

    @Override
    protected void _purInWarehsAddChildOrderToParent(Context ctx, IObjectValue purInWarehsBill, IObjectValue childPurInWarehsBill, String motherEntryId, String childEntryId, String rootId) throws BOSException, EASBizException {
        PurInWarehsBillInfo purInWarehsBillInfo = (PurInWarehsBillInfo)purInWarehsBill;
        PurInWarehsBillInfo childPurInWarehsBillInfo = (PurInWarehsBillInfo)childPurInWarehsBill;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO T_IV_RelationOfChildAndParent (FID,FDocumentType,FMotherNumber,FMotherId,FMotherEntryId,FChildNumber,FChildId,FChildEntryId,FIsUnAudit,FRootID) ");
        sql.append(" VALUES ( ?,?,?,?,?,?,?,?,?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{BOSUuid.create((String)"88888888").toString(), EASResource.getString((String)RES_InvUI, (String)"PurInWarehs"), purInWarehsBillInfo.getNumber(), purInWarehsBillInfo.getId().toString(), motherEntryId, childPurInWarehsBillInfo.getNumber(), childPurInWarehsBillInfo.getId().toString(), childEntryId, 0, rootId});
    }

    @Override
    protected void _updateRecordIsUnAudit(Context ctx, Map map) throws BOSException {
        String entryId = (String)map.get("entryId");
        StringBuffer sql = new StringBuffer();
        sql.append("update  T_IV_RelationOfChildAndParent set FIsUnAudit = 1 ");
        sql.append(" where ");
        sql.append("FChildEntryId = '");
        sql.append(entryId);
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private HashMap judgeIfHaveChildRecord(Context ctx, String rootId) throws BOSException, SQLException {
        IRowSet rs = null;
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FRootID from T_IV_RelationOfChildAndParent");
        sql.append(" where FMotherID = '");
        sql.append(rootId);
        sql.append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            resultMap.put("exist", true);
        }
        return resultMap;
    }

    private HashMap queryRootId(Context ctx, String motherId) throws BOSException, SQLException {
        String FRootID;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FRootID from T_IV_RelationOfChildAndParent");
        sql.append(" where FChildId = '");
        sql.append(motherId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next() && !StringUtil.isEmpty((String)(FRootID = rs.getString("FRootID")))) {
            resultMap.put("FRootID", FRootID);
        }
        return resultMap;
    }

    private HashMap getSpliteIdsAndInfo(Context ctx, HashSet set, String bosType) throws BOSException, SQLException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<String> idList = new ArrayList<String>();
        StringBuffer ids = new StringBuffer();
        Object[] obj = set.toArray();
        for (int i = 0; i < obj.length; ++i) {
            ids.append("'");
            ids.append(obj[i].toString());
            if (i < obj.length - 1) {
                ids.append("',");
                continue;
            }
            ids.append("'");
        }
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FMotherId from T_IV_RelationOfChildAndParent");
        sql.append(" where FMotherId in (");
        sql.append(ids);
        sql.append(")");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer childSql = new StringBuffer();
        childSql.append("select FChildId from T_IV_RelationOfChildAndParent");
        childSql.append(" where FChildId in (");
        childSql.append(ids);
        childSql.append(")");
        IRowSet childRs = DbUtil.executeQuery((Context)ctx, (String)childSql.toString());
        HashSet<String> idSet = new HashSet<String>();
        while (rs.next()) {
            String motherId = rs.getString("FMotherId");
            idList.add(motherId);
            idSet.add(motherId);
        }
        while (childRs.next()) {
            String childId = childRs.getString("FChildId");
            idList.add(childId);
            idSet.add(childId);
        }
        if (!idList.isEmpty()) {
            StringBuffer bf = new StringBuffer();
            for (String str : idSet) {
                bf.append(this.getAllChildInfo(ctx, str, bosType));
            }
            resultMap.put("childinfo", bf.toString());
        }
        resultMap.put("idList", idList);
        return resultMap;
    }

    private HashMap judgeEntryIfSplite(Context ctx, String entryId) throws BOSException, SQLException {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_IV_RelationOfChildAndParent");
        sql.append(" where FMotherEntryId = '");
        sql.append(entryId);
        sql.append("' or ");
        sql.append("FChildEntryId = '");
        sql.append(entryId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            resultMap.put("isUnAudit", true);
        }
        return resultMap;
    }

    @Override
    protected Map _queryInfoByMap(Context ctx, Map map) throws BOSException, EASBizException {
        if (map.get("rootId") != null) {
            Object rs = null;
            String rootId = (String)map.get("rootId");
            try {
                return this.judgeIfHaveChildRecord(ctx, rootId);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (map.get("motherId") != null) {
            String motherId = (String)map.get("motherId");
            try {
                return this.queryRootId(ctx, motherId);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (map.get("idSet") != null) {
            HashSet set = (HashSet)map.get("idSet");
            try {
                return this.getSpliteIdsAndInfo(ctx, set, (String)map.get("bosType"));
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (map.get("entryId") != null) {
            String entryId = (String)map.get("entryId");
            try {
                return this.judgeEntryIfSplite(ctx, entryId);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    @Override
    protected boolean _judgeCanMerge(Context ctx, String rootId, String bosType) throws BOSException, EASBizException {
        String billDateStrs;
        String endDateStrs;
        String billDateStr;
        Date billDate;
        StringBuffer hasChildSql = new StringBuffer();
        hasChildSql.append("select FRootID from T_IV_RelationOfChildAndParent");
        hasChildSql.append(" where FMotherID = '");
        hasChildSql.append(rootId);
        hasChildSql.append("'");
        IRowSet hasChild = DbUtil.executeQuery((Context)ctx, (String)hasChildSql.toString());
        try {
            if (!hasChild.next()) {
                throw new SplitBillException(SplitBillException.NOCHILD);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sqls = new StringBuffer(100);
        sqls.append(" select FISUNAUDIT from T_IV_RelationOfChildAndParent where FChildId = ");
        sqls.append("'");
        sqls.append(rootId);
        sqls.append("'");
        IRowSet rstest = DbUtil.executeQuery((Context)ctx, (String)sqls.toString());
        try {
            while (rstest.next()) {
                String isUnAudit = rstest.getString("FISUNAUDIT");
                if (!isUnAudit.equals("1")) continue;
                throw new SplitBillException(SplitBillException.ALREADYUNAUDIT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("voucher"));
        sic.add(new SelectorItemInfo("bizDate"));
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getBillCompanyInfo(ctx, rootId, bosType);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        Date beginDate = currentPeriod.getBeginDate();
        Timestamp endDate = currentPeriod.getEndDate();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String beginDateStr = format.format(beginDate);
        String endDateStr = format.format(endDate);
        boolean isClose = false;
        isClose = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (SCMConstant.BOSTYPE_PURINWAREHS.equals(bosType)) {
            PurInWarehsBillInfo purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(rootId), sic);
            if (purInWarehsBillInfo.getVoucher() != null) {
                throw new SplitBillException(SplitBillException.GENERATEDCREDENTIALS);
            }
            billDate = purInWarehsBillInfo.getBizDate();
            billDateStr = format.format(billDate);
            if (billDateStr.compareTo(beginDateStr) < 0) {
                throw new SplitBillException(SplitBillException.ALREADYCHECK);
            }
            if (isClose && (endDateStrs = endDateStr.substring(0, 7)).compareTo(billDateStrs = billDateStr.substring(0, 7)) >= 0) {
                throw new SplitBillException(SplitBillException.ALREADYCLOSING);
            }
        }
        if (SCMConstant.BOSTYPE_SALEISSUE.equals(bosType)) {
            SaleIssueBillInfo saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(rootId), sic);
            if (saleIssueBillInfo.getVoucher() != null) {
                throw new SplitBillException(SplitBillException.GENERATEDCREDENTIALS);
            }
            billDate = saleIssueBillInfo.getBizDate();
            billDateStr = format.format(billDate);
            if (billDateStr.compareTo(beginDateStr) < 0) {
                throw new SplitBillException(SplitBillException.ALREADYCHECK);
            }
            if (isClose && (endDateStrs = endDateStr.substring(0, 7)).compareTo(billDateStrs = billDateStr.substring(0, 7)) >= 0) {
                throw new SplitBillException(SplitBillException.ALREADYCLOSING);
            }
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select FID from t_bot_relation where FSRCOBJECTID = ");
        sql.append("'");
        sql.append(rootId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new SplitBillException(SplitBillException.PRESENCEOFDOWNSTREAMORDER);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sqlstr = new StringBuffer(100);
        sqlstr.append(" select FID from T_CL_WRITEOFFRECORD where fbillid = ");
        sqlstr.append("'");
        sqlstr.append(rootId);
        sqlstr.append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sqlstr.toString());
        try {
            if (rs.next()) {
                throw new SplitBillException(SplitBillException.VERIFICATIONHASBEENCARRIEDOUT);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private CompanyOrgUnitInfo getBillCompanyInfo(Context ctx, String billId, String bosType) throws EASBizException, BOSException {
        IInvBillBase iInvbillBase = (IInvBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("entry.companyOrgUnit"));
        InvBillBaseInfo invBillBaseInfo = iInvbillBase.getInvBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        CompanyOrgUnitInfo companyOrgInfo = ((InvBillBaseEntryInfo)invBillBaseInfo.getEntries().getObject(0)).getCompanyOrgUnit();
        return companyOrgInfo;
    }

    private String getAllChildInfo(Context ctx, String id, String bosType) throws BOSException, SQLException, EASBizException {
        int i;
        String compId;
        StringBuffer bf = new StringBuffer();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        String motherNumber = null;
        if (bosType.equals(SCMConstant.BOSTYPE_PURINWAREHS)) {
            PurInWarehsBillInfo purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            motherNumber = purInWarehsBillInfo.getNumber();
            compId = purInWarehsBillInfo.getId().toString();
        } else {
            SaleIssueBillInfo saleIssueBillInfo = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
            motherNumber = saleIssueBillInfo.getNumber();
            compId = saleIssueBillInfo.getId().toString();
        }
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("select distinct FRootId from T_IV_RelationOfChildAndParent");
        sqlStr.append(" where FMotherId = '");
        sqlStr.append(id);
        sqlStr.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        String rootId = null;
        if (!rs.next()) {
            bf.append(motherNumber);
            bf.append("\n");
            return bf.toString();
        }
        rootId = rs.getString("FRootId");
        ArrayList<String> motherIdList = new ArrayList<String>();
        ArrayList<String> childIdList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FMotherId,FChildId from T_IV_RelationOfChildAndParent");
        sql.append(" where FRootId = '");
        sql.append(rootId);
        sql.append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String motherId = rs.getString("FMotherId");
            String childId = rs.getString("FChildId");
            if (StringUtil.isEmpty((String)motherId)) continue;
            motherIdList.add(motherId);
            childIdList.add(childId);
        }
        List<String> resultList = this.getChildIdSetByMotherId(motherIdList, childIdList, compId);
        HashSet<String> set = new HashSet<String>();
        HashSet<String> unDeleteSet = new HashSet<String>();
        for (int i2 = 0; i2 < resultList.size(); ++i2) {
            set.add(resultList.get(i2));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        sics.add(new SelectorItemInfo("number"));
        view.setSelector(sics);
        view.setFilter(filterInfo);
        if (bosType.equals(SCMConstant.BOSTYPE_PURINWAREHS)) {
            PurInWarehsBillCollection purInWarehsBillCollection = PurInWarehsBillFactory.getLocalInstance(ctx).getPurInWarehsBillCollection(view);
            for (i = 0; i < purInWarehsBillCollection.size(); ++i) {
                unDeleteSet.add(purInWarehsBillCollection.get(i).getNumber().toString());
            }
        } else {
            SaleIssueBillCollection saleIssueBillCollection = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(view);
            for (i = 0; i < saleIssueBillCollection.size(); ++i) {
                unDeleteSet.add(saleIssueBillCollection.get(i).getNumber().toString());
            }
        }
        if (unDeleteSet.size() == 0) {
            bf.append(motherNumber);
        }
        Object[] diffMap = unDeleteSet.toArray();
        String[] s = new String[diffMap.length];
        for (int i3 = 0; i3 < diffMap.length; ++i3) {
            s[i3] = (String)diffMap[i3];
        }
        for (int j = 0; j < diffMap.length - 1; ++j) {
            for (int k = j + 1; k < diffMap.length; ++k) {
                if (s[j].compareTo(s[k]) <= 0) continue;
                String temp = s[j];
                s[j] = s[k];
                s[k] = temp;
            }
        }
        for (String info : s) {
            bf.append(motherNumber);
            bf.append("          ");
            bf.append((Object)info);
            bf.append("\n");
        }
        return bf.toString();
    }

    private List<String> getChildIdSetByMotherId(ArrayList<String> motherIdList, ArrayList<String> childIdList, String compId) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < motherIdList.size(); ++i) {
            String motherId = motherIdList.get(i);
            if (!motherId.equals(compId)) continue;
            result.add(childIdList.get(i));
        }
        if (result.size() == 0) {
            return result;
        }
        List<Object> resultList = new ArrayList();
        for (int i = 0; i < result.size(); ++i) {
            String childId = ((String)result.get(i)).toString();
            resultList = this.getChildIdSetByMotherId(motherIdList, childIdList, childId);
            for (String string : resultList) {
                result.add(string);
            }
        }
        return result;
    }
}

