/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.ST2TOUtilsFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ST2TOUtils {
    private String insertBillRelationSql = "insert into T_IM_TFOrderRelation (FTransferOrderID,FStockTransferID) values (?,?)";
    private PreparedStatement insertBillRelationStmt = null;
    private String updateBillRelationSql = "update T_IM_TFOrderRelation set FTransferOrderID = ? where FStockTransferID = ?";
    private PreparedStatement updateBillRelationStmt = null;
    private String insertEntryRelationSql = "insert into T_IM_TFOrderRelationEntry (FTransferOrderEntryID,FStockTransferEntryID) values (?,?)";
    private PreparedStatement insertEntryRelationStmt = null;
    private String updateEntryRelationSql = "update T_IM_TFOrderRelationEntry set FTransferOrderEntryID = ? where FStockTransferEntryID = ?";
    private PreparedStatement updateEntryRelationStmt = null;
    private Statement insertBillStmt = null;
    private Statement insertEntryStmt = null;
    private String updateBotpSrcBillRelationSql = "update T_BOT_RELATION set FSRCOBJECTID = ?, FSrcEntityID = ? where FSRCOBJECTID = ?";
    private PreparedStatement updateBotpSrcBillRelationStmt = null;
    private String updateBotpDestBillRelationSql = "update T_BOT_RELATION set FDESTOBJECTID = ? , FDestEntityID = ? where FDESTOBJECTID = ?";
    private PreparedStatement updateBotpDestBillRelationStmt = null;
    private String updateBotpSrcEntryRelationSql = "update T_BOT_RELATIONENTRY set FSRCENTRYID  = ? where FSRCENTRYID = ?";
    private PreparedStatement updateBotpSrcEntryRelationStmt = null;
    private String updateBotpDestEntryRelationSql = "update T_BOT_RELATIONENTRY set FDESTENTRYID  = ? where FDESTENTRYID = ?";
    private PreparedStatement updateBotpDestEntryRelationStmt = null;
    private String updateSaleIssueBillSql = new StringBuffer("update T_IM_SaleIssueBill set FSourceBillTypeID  = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where Fid in (select distinct FParentID from T_IM_SaleIssueEntry where FSourceBillID = ?)").toString();
    private PreparedStatement updateSaleIssueBillStmt = null;
    private String updatePurInBillSql = new StringBuffer("update T_IM_PurInWarehsBill set FSourceBillTypeID  = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where Fid in (select distinct FParentID from T_IM_PurInWarehsEntry where FSourceBillID = ?)").toString();
    private PreparedStatement updatePurInBillStmt = null;
    private String updatePostReqBillSql = new StringBuffer("update T_SD_PostRequisition set FSourceBillTypeID  = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where Fid in (select distinct FParentID from T_SD_PostRequisitionEntry where FSourceBillID = ?)").toString();
    private PreparedStatement updatePostReqBillStmt = null;
    private String updateArOtherBillSql = new StringBuffer("update T_AR_OtherBill set FSourceBillType = ").append(301).append(" where Fid in (select distinct FParentID from T_AR_OtherBillentry where FSourceBillID = ?)").toString();
    private PreparedStatement updateArOtherBillStmt = null;
    private String updateApOtherBillSql = new StringBuffer("update T_AP_OtherBill set FSourceBillType = ").append(301).append(" where Fid in (select distinct FParentID from T_AP_OtherBillentry where FSourceBillID = ?)").toString();
    private PreparedStatement updateApOtherBillStmt = null;
    private String updateSaleIssueEntrySrcSql = new StringBuffer("update T_IM_SaleIssueEntry set FSourceBillID  = ?,").append("FSourceBillEntryID = ?, FSourceBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where FSourceBillID = ? and FSourceBillEntryID = ?").toString();
    private PreparedStatement updateSaleIssueEntrySrcStmt = null;
    private String updateSaleIssueEntryCoreSql = new StringBuffer("update T_IM_SaleIssueEntry set FSaleOrderID  = ?,").append("FSaleOrderEntryID = ? where FSaleOrderID = ? and FSaleOrderEntryID = ?").toString();
    private PreparedStatement updateSaleIssueEntryCoreStmt = null;
    private String updatePurInEntrySrcSql = new StringBuffer("update T_IM_PurInWarehsEntry set FSourceBillID  = ?,").append("FSourceBillEntryID = ?, FSourceBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where FSourceBillID = ? and FSourceBillEntryID = ?").toString();
    private PreparedStatement updatePurInEntrySrcStmt = null;
    private String updatePurInEntryCoreSql = new StringBuffer("update T_IM_PurInWarehsEntry set FPurOrderID  = ?,").append("FPurOrderEntryID = ? where FPurOrderID = ? and FPurOrderEntryID = ?").toString();
    private PreparedStatement updatePurInEntryCoreStmt = null;
    private String updatePostReqEntrySrcSql = new StringBuffer("update T_SD_PostRequisitionEntry set FSourceBillID  = ?,").append("FSourceBillEntryID = ?, FSourceBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where FSourceBillID = ? and FSourceBillEntryID = ?").toString();
    private PreparedStatement updatePostReqEntrySrcStmt = null;
    private String updatePostReqEntryCoreSql = new StringBuffer("update T_SD_PostRequisitionEntry set FStockTransferBillID  = ?,").append("FStockTransferBillEntryID = ? where FStockTransferBillID = ? and FStockTransferBillEntryID = ?").toString();
    private PreparedStatement updatePostReqEntryCoreStmt = null;
    private String updateArOtherEntrySrcSql = new StringBuffer("update T_AR_OtherBillentry set FSourceBillID  = ?,").append("FSourceBillEntryID = ? where FSourceBillID = ? and FSourceBillEntryID = ?").toString();
    private PreparedStatement updateArOtherEntrySrcStmt = null;
    private String updateArOtherEntryCoreSql = new StringBuffer("update T_AR_OtherBillentry set FCoreBillId  = ?,").append("FCoreBillEntryId = ? ,FCoreBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where FCoreBillId = ? and FCoreBillEntryId = ?").toString();
    private PreparedStatement updateArOtherEntryCoreStmt = null;
    private String updateApOtherEntrySrcSql = new StringBuffer("update T_AP_OtherBillentry set FSourceBillID  = ?,").append("FSourceBillEntryID = ? where FSourceBillID = ? and FSourceBillEntryID = ?").toString();
    private PreparedStatement updateApOtherEntrySrcStmt = null;
    private String updateApOtherEntryCoreSql = new StringBuffer("update T_AP_OtherBillentry set FCoreBillId  = ?,").append("FCoreBillEntryId = ? ,FCoreBillTypeID = '").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' where FCoreBillId = ? and FCoreBillEntryId = ?").toString();
    private PreparedStatement updateApOtherEntryCoreStmt = null;
    private Connection conn = null;
    private static String createBillRelationSql = "Create Table T_IM_TFOrderRelation (FStockTransferID VARCHAR(44) NOT NULL ,FTransferOrderID VARCHAR(44) NOT NULL)";
    private static String createEntryRelationSql = "Create Table T_IM_TFOrderRelationEntry (FStockTransferEntryID VARCHAR(44) NOT NULL ,FTransferOrderEntryID VARCHAR(44) NOT NULL)";
    private static String[] createIndexSql = new String[]{"create index idx_btRety_src on T_BOT_RELATIONENTRY(FSRCENTRYID)", "create index idx_btRety_dst on T_BOT_RELATIONENTRY(FDESTENTRYID)", "create index idx_apO_id on T_AP_OtherBill(FID)", "create index idx_apOety_sid on T_AP_OtherBillentry(FSourceBillID)", "create index idx_arO_id on T_AR_OtherBill(FID)", "create index idx_arOety_sid on T_AR_OtherBillentry(FSourceBillID)", "create index idx_piEty_sid on T_IM_PurInWarehsEntry(FSourceBillID,FSourceBillEntryID)", "create index idx_piEty_cid on T_IM_PurInWarehsEntry(FPurOrderID,FPurOrderEntryID)", "create index idx_tfRb_to on T_IM_TFOrderRelation(FTransferOrderID)", "create index idx_tfRb_st on T_IM_TFOrderRelation(FStockTransferID)"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preCreate(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            try {
                stmt.execute(createBillRelationSql.toString());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                stmt.execute(createEntryRelationSql.toString());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            int size = createIndexSql.length;
            for (int i = 0; i < size; ++i) {
                try {
                    stmt.execute(createIndexSql[i]);
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public ST2TOUtils(Context ctx) throws SQLException {
        this.conn = EJBFactory.getConnection((Context)ctx);
        this.preCreate(this.conn);
        this.insertBillRelationStmt = this.conn.prepareStatement(this.insertBillRelationSql);
        this.updateBillRelationStmt = this.conn.prepareStatement(this.updateBillRelationSql);
        this.insertEntryRelationStmt = this.conn.prepareStatement(this.insertEntryRelationSql);
        this.updateEntryRelationStmt = this.conn.prepareStatement(this.updateEntryRelationSql);
        this.insertBillStmt = this.conn.createStatement();
        this.insertEntryStmt = this.conn.createStatement();
        this.updateBotpSrcBillRelationStmt = this.conn.prepareStatement(this.updateBotpSrcBillRelationSql);
        this.updateBotpDestBillRelationStmt = this.conn.prepareStatement(this.updateBotpDestBillRelationSql);
        this.updateBotpSrcEntryRelationStmt = this.conn.prepareStatement(this.updateBotpSrcEntryRelationSql);
        this.updateBotpDestEntryRelationStmt = this.conn.prepareStatement(this.updateBotpDestEntryRelationSql);
        this.updateSaleIssueBillStmt = this.conn.prepareStatement(this.updateSaleIssueBillSql);
        this.updatePurInBillStmt = this.conn.prepareStatement(this.updatePurInBillSql);
        this.updatePostReqBillStmt = this.conn.prepareStatement(this.updatePostReqBillSql);
        this.updateArOtherBillStmt = this.conn.prepareStatement(this.updateArOtherBillSql);
        this.updateApOtherBillStmt = this.conn.prepareStatement(this.updateApOtherBillSql);
        this.updateSaleIssueEntrySrcStmt = this.conn.prepareStatement(this.updateSaleIssueEntrySrcSql);
        this.updateSaleIssueEntryCoreStmt = this.conn.prepareStatement(this.updateSaleIssueEntryCoreSql);
        this.updatePurInEntrySrcStmt = this.conn.prepareStatement(this.updatePurInEntrySrcSql);
        this.updatePurInEntryCoreStmt = this.conn.prepareStatement(this.updatePurInEntryCoreSql);
        this.updatePostReqEntrySrcStmt = this.conn.prepareStatement(this.updatePostReqEntrySrcSql);
        this.updatePostReqEntryCoreStmt = this.conn.prepareStatement(this.updatePostReqEntryCoreSql);
        this.updateArOtherEntrySrcStmt = this.conn.prepareStatement(this.updateArOtherEntrySrcSql);
        this.updateArOtherEntryCoreStmt = this.conn.prepareStatement(this.updateArOtherEntryCoreSql);
        this.updateApOtherEntrySrcStmt = this.conn.prepareStatement(this.updateApOtherEntrySrcSql);
        this.updateApOtherEntryCoreStmt = this.conn.prepareStatement(this.updateApOtherEntryCoreSql);
    }

    public void writeUpdataRelation(String oldUpId, String sStockTransferid, String sTransferOrderid) throws SQLException, BOSException, EASBizException {
        if (oldUpId == null) {
            this.insertBillRelationStmt.setString(1, sTransferOrderid);
            this.insertBillRelationStmt.setString(2, sStockTransferid);
            this.insertBillRelationStmt.addBatch();
        } else {
            this.updateBillRelationStmt.setString(1, sTransferOrderid);
            this.updateBillRelationStmt.setString(2, sStockTransferid);
            this.updateBillRelationStmt.addBatch();
        }
    }

    public void writeUpdataEntryRelation(String oldUpEntryId, String stockTransferEntryID, String transferOrderEntryID) throws SQLException, BOSException, EASBizException {
        if (oldUpEntryId == null) {
            this.insertEntryRelationStmt.setString(1, transferOrderEntryID);
            this.insertEntryRelationStmt.setString(2, stockTransferEntryID);
            this.insertEntryRelationStmt.addBatch();
        } else {
            this.updateEntryRelationStmt.setString(1, transferOrderEntryID);
            this.updateEntryRelationStmt.setString(2, stockTransferEntryID);
            this.updateEntryRelationStmt.addBatch();
        }
    }

    public void copyHeadDataFromStockTransfer(String stBillId, String toBillId) throws SQLException, BOSException, EASBizException {
        String insertBillSql = new StringBuffer("insert into T_IM_TransferOrderBill (FID").append(",FCreatorID ,FCreateTime,FLastUpdateUserID,FLastUpdateTime ,FControlUnitID ,FNumber,FBizDate,FHandlerID ,FDescription,FHasEffected,FAuditorID").append(",FSourceBillID,FSourceFunction,FAuditTime,FBaseStatus,FBizTypeID ,FSourceBillTypeID ,FBillTypeID ,FYear,FPeriod,FModifierID").append(",FModificationTime,FIssueCompanyOrgUnitID ,FReceiptCompanyOrgUnitID ,FIssueStorageOrgUnitID ,FReceiptStorageOrgUnitID").append(",FIssueAdminOrgUnitID ,FReceiptAdminOrgUnitID ,FCurrencyID ,FIsShipment,FExchangeRate,FIsInitBill,FIsInTax)").append(" select '").append(toBillId).append("',FCreatorID ,FCreateTime,FLastUpdateUserID,FLastUpdateTime ,FControlUnitID ,FNumber,FBizDate,FHandlerID ,FDescription,isNull(FHasEffected,0),FAuditorID").append(",FSourceBillID,FSourceFunction,FAuditTime,isNull(FBaseStatus,0),FBizTypeID ,FSourceBillTypeID ,'").append("Eg5BUQEVEADgAAABwKgOEEY+1VI=").append("' ,isNull(FYear,0),isNull(FPeriod,0),FModifierID").append(",FModificationTime,FIssueCompanyOrgUnitID ,FReceiptCompanyOrgUnitID ,FIssueStorageOrgUnitID ,FReceiptStorageOrgUnitID").append(",FIssueAdminOrgUnitID ,FReceiptAdminOrgUnitID ,FCurrencyID ,isNull(FIsShipment,0),isNull(FExchangeRate,0),isNull(FIsInitBill,0),isNull(FIsInTax,0)").append(" From T_IM_StockTransferBill where Fid = '").append(stBillId).append("'").toString();
        this.insertBillStmt.addBatch(insertBillSql);
    }

    public void copyDetailDatayFromStockTransfer(String stEntryId, String toBillId, String toEntryId) throws SQLException, BOSException, EASBizException {
        String insertEntrySql = new StringBuffer("insert into T_IM_TransferOrderBillEntry (FID,FParentID").append(",FSeq,FMaterialID ,FAssistPropertyID ,FUnitID ").append(",FSourceBillID,FSourceBillNumber,FSourceBillEntryID,FSourceBillEntrySeq,FAssCoefficient,FBaseStatus,FAssociateQty,FSourceBillTypeID").append(",FBaseUnitID ,FAssistUnitID ,FRemark,FReasonCodeID , FIssueWarehouseID ,FIssueLocationID ,FReceiptWarehouseID ,FReceiptLocationID").append(",FLot,FQty,FAssistQty,FBaseQty,FReceiptPlanDate,FPrice,FAmount,FIssueQty,FReceiptQty,FMfg,FExp,FIsPresent,FTaxRate,FTax,FTaxPrice").append(",FTaxAmount,FSaleInvoiceQty,FPurInvoiceQty,FIssueBaseQty,FReceiptBaseQty,FSaleInvoiceBaseQty,FPurInvoiceBaseQty,FUnIssueBaseQty").append(",FReason,FPurInvoiceAmount,FSaleInvoiceAmount,FTotalAccountPayable,FTotalAccountReceivable,FIssueStorageOrgUnitID ,FIssueCompanyOrgUnitID").append(",FIssueSaleOrgUnitID ,FReceiveStorageOrgUnitID ,FReceiveCompanyOrgUnitID ,FSupplyRelationID ,FSupplySaleOrgUnitID ,FRequireSaleOrgUnitID").append(",FTotalIssueQty,FBalanceCostPrice,FBalanceCostRate,FActualPrice,FDiscountType,FDiscountRate,FActualTaxPrice,FLocalAmount,FLocalTax").append(",FLocalTaxAmount,FDiscountAmount,FLocalDiscountAmount,FArAssociateBaseQty,FApAssociateBaseQty,FNotControlQty,FQtyOverRate,FQtyLackRate)").append(" select '").append(toEntryId).append("','").append(toBillId).append("',FSeq,FMaterialID ,FAssistPropertyID ,FUnitID ").append(",FSourceBillID,FSourceBillNumber,FSourceBillEntryID,FSourceBillEntrySeq,isNull(FAssCoefficient,0),isNull(FBaseStatus,0),isNull(FAssociateQty,0),FSourceBillTypeID").append(",FBaseUnitID ,FAssistUnitID ,FRemark,FReasonCodeID , FIssueWarehouseID ,FIssueLocationID ,FReceiptWarehouseID ,FReceiptLocationID").append(",FLot,isNull(FQty,0),isNull(FAssistQty,0),isNull(FBaseQty,0),FReceiptPlanDate,isNull(FPrice,0),isNull(FAmount,0),isNull(FIssueQty,0),isNull(FReceiptQty,0),FMfg,FExp,isNull(FIsPresent,0),isNull(FTaxRate,0),isNull(FTax,0),isNull(FTaxPrice,0)").append(",isNull(FTaxAmount,0),isNull(FSaleInvoiceQty,0),isNull(FPurInvoiceQty,0),isNull(FIssueBaseQty,0),isNull(FReceiptBaseQty,0),isNull(FSaleInvoiceBaseQty,0),isNull(FPurInvoiceBaseQty,0),isNull(FUnIssueBaseQty,0)").append(",FReason,isNull(FPurInvoiceAmount,0),isNull(FSaleInvoiceAmount,0),isNull(FTotalAccountPayable,0),isNull(FTotalAccountReceivable,0),FIssueStorageOrgUnitID ,FIssueCompanyOrgUnitID").append(",FIssueSaleOrgUnitID ,FReceiveStorageOrgUnitID ,FReceiveCompanyOrgUnitID ,FSupplyRelationID ,FSupplySaleOrgUnitID ,FRequireSaleOrgUnitID").append(",isNull(FTotalIssueQty,0),isNull(FBalanceCostPrice,0),isNull(FBalanceCostRate,0),isNull(FActualPrice,0),isNull(FDiscountType,0),isNull(FDiscountRate,0),isNull(FActualTaxPrice,0),isNull(FLocalAmount,0),isNull(FLocalTax,0)").append(",isNull(FLocalTaxAmount,0),isNull(FDiscountAmount,0),isNull(FLocalDiscountAmount,0),isNull(FArAssociateBaseQty,0),isNull(FApAssociateBaseQty,0),1,0,0").append(" From T_IM_StockTransferBillEntry where Fid = '").append(stEntryId).append("'").toString();
        this.insertEntryStmt.addBatch(insertEntrySql);
    }

    public void updateBotpRetion(String stBillId, String toBillId, String toBosType) throws SQLException, BOSException, EASBizException {
        this.updateBotpSrcBillRelationStmt.setString(1, toBillId);
        this.updateBotpSrcBillRelationStmt.setString(2, toBosType);
        this.updateBotpSrcBillRelationStmt.setString(3, stBillId);
        this.updateBotpSrcBillRelationStmt.addBatch();
        this.updateBotpDestBillRelationStmt.setString(1, toBillId);
        this.updateBotpDestBillRelationStmt.setString(2, toBosType);
        this.updateBotpDestBillRelationStmt.setString(3, stBillId);
        this.updateBotpDestBillRelationStmt.addBatch();
    }

    public void updateBotpEntryRetion(String stEntryID, String toEntryID) throws SQLException, BOSException, EASBizException {
        this.updateBotpSrcEntryRelationStmt.setString(1, toEntryID);
        this.updateBotpSrcEntryRelationStmt.setString(2, stEntryID);
        this.updateBotpSrcEntryRelationStmt.addBatch();
        this.updateBotpDestEntryRelationStmt.setString(1, toEntryID);
        this.updateBotpDestEntryRelationStmt.setString(2, stEntryID);
        this.updateBotpDestEntryRelationStmt.addBatch();
    }

    public void updateBillSourceBillTypeID(String stBillId) throws SQLException, BOSException, EASBizException {
        this.updateSaleIssueBillStmt.setString(1, stBillId);
        this.updateSaleIssueBillStmt.addBatch();
        this.updatePurInBillStmt.setString(1, stBillId);
        this.updatePurInBillStmt.addBatch();
        this.updatePostReqBillStmt.setString(1, stBillId);
        this.updatePostReqBillStmt.addBatch();
        this.updateArOtherBillStmt.setString(1, stBillId);
        this.updateArOtherBillStmt.addBatch();
        this.updateApOtherBillStmt.setString(1, stBillId);
        this.updateApOtherBillStmt.addBatch();
    }

    public void updateBillSourceBillID(String stBillId, String stEntryId, String toBillId, String toEntryId) throws SQLException, BOSException, EASBizException {
        this.updateSaleIssueEntrySrcStmt.setString(1, toBillId);
        this.updateSaleIssueEntrySrcStmt.setString(2, toEntryId);
        this.updateSaleIssueEntrySrcStmt.setString(3, stBillId);
        this.updateSaleIssueEntrySrcStmt.setString(4, stEntryId);
        this.updateSaleIssueEntrySrcStmt.addBatch();
        this.updateSaleIssueEntryCoreStmt.setString(1, toBillId);
        this.updateSaleIssueEntryCoreStmt.setString(2, toEntryId);
        this.updateSaleIssueEntryCoreStmt.setString(3, stBillId);
        this.updateSaleIssueEntryCoreStmt.setString(4, stEntryId);
        this.updateSaleIssueEntryCoreStmt.addBatch();
        this.updatePurInEntrySrcStmt.setString(1, toBillId);
        this.updatePurInEntrySrcStmt.setString(2, toEntryId);
        this.updatePurInEntrySrcStmt.setString(3, stBillId);
        this.updatePurInEntrySrcStmt.setString(4, stEntryId);
        this.updatePurInEntrySrcStmt.addBatch();
        this.updatePurInEntryCoreStmt.setString(1, toBillId);
        this.updatePurInEntryCoreStmt.setString(2, toEntryId);
        this.updatePurInEntryCoreStmt.setString(3, stBillId);
        this.updatePurInEntryCoreStmt.setString(4, stEntryId);
        this.updatePurInEntryCoreStmt.addBatch();
        this.updatePostReqEntrySrcStmt.setString(1, toBillId);
        this.updatePostReqEntrySrcStmt.setString(2, toEntryId);
        this.updatePostReqEntrySrcStmt.setString(3, stBillId);
        this.updatePostReqEntrySrcStmt.setString(4, stEntryId);
        this.updatePostReqEntrySrcStmt.addBatch();
        this.updatePostReqEntryCoreStmt.setString(1, toBillId);
        this.updatePostReqEntryCoreStmt.setString(2, toEntryId);
        this.updatePostReqEntryCoreStmt.setString(3, stBillId);
        this.updatePostReqEntryCoreStmt.setString(4, stEntryId);
        this.updatePostReqEntryCoreStmt.addBatch();
        this.updateArOtherEntrySrcStmt.setString(1, toBillId);
        this.updateArOtherEntrySrcStmt.setString(2, toEntryId);
        this.updateArOtherEntrySrcStmt.setString(3, stBillId);
        this.updateArOtherEntrySrcStmt.setString(4, stEntryId);
        this.updateArOtherEntrySrcStmt.addBatch();
        this.updateArOtherEntryCoreStmt.setString(1, toBillId);
        this.updateArOtherEntryCoreStmt.setString(2, toEntryId);
        this.updateArOtherEntryCoreStmt.setString(3, stBillId);
        this.updateArOtherEntryCoreStmt.setString(4, stEntryId);
        this.updateArOtherEntryCoreStmt.addBatch();
        this.updateApOtherEntrySrcStmt.setString(1, toBillId);
        this.updateApOtherEntrySrcStmt.setString(2, toEntryId);
        this.updateApOtherEntrySrcStmt.setString(3, stBillId);
        this.updateApOtherEntrySrcStmt.setString(4, stEntryId);
        this.updateApOtherEntrySrcStmt.addBatch();
        this.updateApOtherEntryCoreStmt.setString(1, toBillId);
        this.updateApOtherEntryCoreStmt.setString(2, toEntryId);
        this.updateApOtherEntryCoreStmt.setString(3, stBillId);
        this.updateApOtherEntryCoreStmt.setString(4, stEntryId);
        this.updateApOtherEntryCoreStmt.addBatch();
    }

    public void executeRelationBatch() throws BOSException, SQLException {
        this.insertBillRelationStmt.executeBatch();
        this.updateBillRelationStmt.executeBatch();
        this.insertEntryRelationStmt.executeBatch();
        this.updateEntryRelationStmt.executeBatch();
        this.insertBillStmt.executeBatch();
        this.insertEntryStmt.executeBatch();
        this.updateBotpSrcBillRelationStmt.executeBatch();
        this.updateBotpDestBillRelationStmt.executeBatch();
        this.updateBotpSrcEntryRelationStmt.executeBatch();
        this.updateBotpDestEntryRelationStmt.executeBatch();
    }

    public void executeHeadBatch() throws BOSException, SQLException {
        this.updateSaleIssueBillStmt.executeBatch();
        this.updatePurInBillStmt.executeBatch();
        this.updatePostReqBillStmt.executeBatch();
        this.updateArOtherBillStmt.executeBatch();
        this.updateApOtherBillStmt.executeBatch();
    }

    public void executeEntryBatch() throws BOSException, SQLException {
        this.updateSaleIssueEntrySrcStmt.executeBatch();
        this.updateSaleIssueEntryCoreStmt.executeBatch();
        this.updatePurInEntrySrcStmt.executeBatch();
        this.updatePurInEntryCoreStmt.executeBatch();
        this.updatePostReqEntrySrcStmt.executeBatch();
        this.updatePostReqEntryCoreStmt.executeBatch();
        this.updateArOtherEntrySrcStmt.executeBatch();
        this.updateArOtherEntryCoreStmt.executeBatch();
        this.updateApOtherEntrySrcStmt.executeBatch();
        this.updateApOtherEntryCoreStmt.executeBatch();
    }

    public void cleanAndClose() throws BOSException, SQLException {
        this.insertBillRelationStmt.clearBatch();
        this.updateBillRelationStmt.clearBatch();
        this.insertEntryRelationStmt.clearBatch();
        this.updateEntryRelationStmt.clearBatch();
        this.insertBillStmt.clearBatch();
        this.insertEntryStmt.clearBatch();
        this.updateBotpSrcBillRelationStmt.clearBatch();
        this.updateBotpDestBillRelationStmt.clearBatch();
        this.updateBotpSrcEntryRelationStmt.clearBatch();
        this.updateBotpDestEntryRelationStmt.clearBatch();
        this.updateSaleIssueBillStmt.clearBatch();
        this.updatePurInBillStmt.clearBatch();
        this.updatePostReqBillStmt.clearBatch();
        this.updateArOtherBillStmt.clearBatch();
        this.updateApOtherBillStmt.clearBatch();
        this.updateSaleIssueEntrySrcStmt.clearBatch();
        this.updateSaleIssueEntryCoreStmt.clearBatch();
        this.updatePurInEntrySrcStmt.clearBatch();
        this.updatePurInEntryCoreStmt.clearBatch();
        this.updatePostReqEntrySrcStmt.clearBatch();
        this.updatePostReqEntryCoreStmt.clearBatch();
        this.updateArOtherEntrySrcStmt.clearBatch();
        this.updateArOtherEntryCoreStmt.clearBatch();
        this.updateApOtherEntrySrcStmt.clearBatch();
        this.updateApOtherEntryCoreStmt.clearBatch();
        this.insertBillRelationStmt.close();
        this.updateBillRelationStmt.close();
        this.insertEntryRelationStmt.close();
        this.updateEntryRelationStmt.close();
        this.insertBillStmt.close();
        this.insertEntryStmt.close();
        this.updateBotpSrcBillRelationStmt.close();
        this.updateBotpDestBillRelationStmt.close();
        this.updateBotpSrcEntryRelationStmt.close();
        this.updateBotpDestEntryRelationStmt.close();
        this.updateSaleIssueBillStmt.close();
        this.updatePurInBillStmt.close();
        this.updatePostReqBillStmt.close();
        this.updateArOtherBillStmt.close();
        this.updateApOtherBillStmt.close();
        this.updateSaleIssueEntrySrcStmt.close();
        this.updateSaleIssueEntryCoreStmt.close();
        this.updatePurInEntrySrcStmt.close();
        this.updatePurInEntryCoreStmt.close();
        this.updatePostReqEntrySrcStmt.close();
        this.updatePostReqEntryCoreStmt.close();
        this.updateArOtherEntrySrcStmt.close();
        this.updateArOtherEntryCoreStmt.close();
        this.updateApOtherEntrySrcStmt.close();
        this.updateApOtherEntryCoreStmt.close();
    }

    public void executeBatch() throws BOSException, SQLException {
        try {
            this.executeRelationBatch();
            this.executeHeadBatch();
            this.executeEntryBatch();
        }
        catch (SQLException e) {
            throw new BOSException("Failed to execute sql in batch!", (Throwable)e);
        }
        finally {
            this.cleanAndClose();
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    public void executeBatch(List sqlList) throws BOSException, SQLException {
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                statement.addBatch((String)sqlList.get(i));
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException("Failed to execute sql in batch!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creatFOrderUpdataRelationTable() throws BOSException, EASBizException {
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_IM_TFOrderRelation (FStockTransferID VARCHAR(44) NOT NULL ,FTransferOrderID VARCHAR(44) NOT NULL)");
        try {
            stmt = this.conn.createStatement();
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        sql = new StringBuffer();
        sql.append("Create Table T_IM_TFOrderRelationEntry (FStockTransferEntryID VARCHAR(44) NOT NULL ,FTransferOrderEntryID VARCHAR(44) NOT NULL)");
        try {
            stmt = this.conn.createStatement();
            stmt.execute(sql.toString());
        }
        catch (SQLException e) {
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
    }

    public String getOldUpdateID(String stBillId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            String string;
            stmt = null;
            rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FTransferOrderID From T_IM_TFOrderRelation where FStockTransferID = ? ");
            try {
                stmt = this.conn.prepareStatement(sql.toString());
                stmt.setString(1, stBillId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString("FTransferOrderID");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public String getOldUpdateEntryID(String stBillId) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            String string;
            stmt = null;
            rs = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FTransferOrderEntryID From T_IM_TFOrderRelationEntry where FStockTransferEntryID = ? ");
            try {
                stmt = this.conn.prepareStatement(sql.toString());
                stmt.setString(1, stBillId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString("FTransferOrderEntryID");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public void deleteOldUpdateData(String stBillId) throws BOSException, EASBizException {
        PreparedStatement stmt = null;
        StringBuffer sqlDetail = new StringBuffer();
        sqlDetail.append("delete T_IM_TransferOrderBillEntry where Fparentid = ? ");
        StringBuffer sqlhead = new StringBuffer();
        sqlhead.append("delete T_IM_TransferOrderBill where Fid = ? ");
        try {
            stmt = this.conn.prepareStatement(sqlDetail.toString());
            stmt.setString(1, stBillId);
            stmt.execute();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        try {
            stmt = this.conn.prepareStatement(sqlhead.toString());
            stmt.setString(1, stBillId);
            stmt.execute();
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
    }

    public static void initDataFromST(Context ctx, List billList) throws BOSException, EASBizException {
        if (billList != null) {
            StockTransferBillInfo billInfo = null;
            StockTransferBillEntryInfo stEntryInfo = null;
            String strckTransferID = null;
            String strckTransferEntryID = null;
            String oldUpId = null;
            String oldUpEntryId = null;
            String newID = "";
            String newEntryID = "";
            String toBosType = new TransferOrderBillInfo().getBOSType().toString();
            String toEntryBosType = new TransferOrderBillEntryInfo().getBOSType().toString();
            try {
                ST2TOUtils st2toUtils = ST2TOUtilsFactory.create(ctx);
                int size = billList.size();
                for (int i = 0; i < size; ++i) {
                    billInfo = (StockTransferBillInfo)billList.get(i);
                    strckTransferID = billInfo.getId().toString();
                    oldUpId = st2toUtils.getOldUpdateID(strckTransferID);
                    if (oldUpId != null) continue;
                    newID = BOSUuid.create((String)toBosType).toString();
                    st2toUtils.writeUpdataRelation(oldUpId, strckTransferID, newID);
                    st2toUtils.copyHeadDataFromStockTransfer(strckTransferID, newID);
                    if (oldUpId == null) {
                        oldUpId = strckTransferID;
                    }
                    st2toUtils.updateBotpRetion(oldUpId, newID, toBosType);
                    st2toUtils.updateBillSourceBillTypeID(oldUpId);
                    StockTransferBillEntryCollection entrys = billInfo.getEntry();
                    int entrySize = entrys.size();
                    for (int j = 0; j < entrySize; ++j) {
                        stEntryInfo = entrys.get(j);
                        strckTransferEntryID = stEntryInfo.getId().toString();
                        oldUpEntryId = st2toUtils.getOldUpdateEntryID(strckTransferEntryID);
                        newEntryID = BOSUuid.create((String)toEntryBosType).toString();
                        st2toUtils.writeUpdataEntryRelation(oldUpEntryId, strckTransferEntryID, newEntryID);
                        st2toUtils.copyDetailDatayFromStockTransfer(strckTransferEntryID, newID, newEntryID);
                        if (oldUpEntryId == null) {
                            oldUpEntryId = strckTransferEntryID;
                        }
                        st2toUtils.updateBotpEntryRetion(oldUpEntryId, newEntryID);
                        st2toUtils.updateBillSourceBillID(oldUpId, oldUpEntryId, newID, newEntryID);
                    }
                }
                st2toUtils.executeBatch();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

