/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.FetchPriceEnum;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillRelationOptionEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.calculate.PropertyCalculator;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.ITransferOrderBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueAlgorithm;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.PurInWarehsServerutils;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleIssueAlgorithmForInfo
extends SaleIssueAlgorithm {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.SaleIssueAlgorithmForInfo");
    private SaleIssueBillInfo info = null;
    private int localAmountPrecision;
    private int amountPrecision;
    private Map<String, BigDecimal> soBaseQtyMap = null;
    private Map<String, BigDecimal> soAssociateMap = null;
    private Map<String, SaleOrderInfo> saleOrderMap = new HashMap<String, SaleOrderInfo>();
    private Map<String, SaleOrderEntryInfo> saleOrderEntryMap = new HashMap<String, SaleOrderEntryInfo>();
    private final String res = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    public final String isCalQtyByBaseQty = "isCalQtyByBaseQty";
    private boolean isReFetchPrice = true;
    private static final Map<String, String> fieldMap = new HashMap<String, String>();

    public boolean isReFetchPrice() {
        return this.isReFetchPrice;
    }

    public void setReFetchPrice(boolean isReFetchPrice) {
        this.isReFetchPrice = isReFetchPrice;
    }

    public SaleIssueAlgorithmForInfo(SaleIssueBillInfo info, Context ctx) throws EASBizException, BOSException {
        this.info = info;
        this.ctx = ctx;
        this.checkBotp(info);
        this.sou = info.getStorageOrgUnit();
        if (this.sou == null) {
            this.sou = (StorageOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.Storage);
        }
        if (this.sou == null) {
            throw new InvBizException(InvBizException.STOREORG_IS_NULL);
        }
        info.setStorageOrgUnit(this.sou);
        this.cou = PurInWarehsServerutils.getCompany(ctx, this.sou);
        if (this.cou == null) {
            throw new InvBizException(InvBizException.COMPANYISNULL);
        }
        this.localAmountPrecision = this.cou.getBaseCurrency().getPrecision();
        this.amountPrecision = 2;
        if (info.getCurrency() != null) {
            if (info.getCurrency().getPrecision() == 0) {
                CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("SELECT id, precision WHERE id = '" + info.getCurrency().getId().toString() + "'");
                info.setCurrency(currency);
            }
            this.amountPrecision = info.getCurrency().getPrecision();
        }
    }

    public void doSplitBillEntry(SaleIssueEntryInfo aMotherEntryInfo, SaleIssueEntryInfo aChildEntryInfo) throws EASBizException, BOSException {
        SaleIssueEntryInfo srcBillEntryInfo = (SaleIssueEntryInfo)aMotherEntryInfo.clone();
        this.doSplitBillChildEntry(aMotherEntryInfo, aChildEntryInfo, srcBillEntryInfo);
        this.doSplitBillMotherEntry(aMotherEntryInfo, aChildEntryInfo, srcBillEntryInfo);
    }

    public void revalue() throws EASBizException, BOSException {
        String sourceBillTypeID;
        this.revalueInfo(this.sou, this.cou);
        BillTypeInfo coreBillType = this.info.getEntry().get(0).getCoreBillType();
        String coreBillTypeId = coreBillType == null ? null : coreBillType.getId().toString();
        BillTypeInfo sourceBillType = this.info.getSourceBillType();
        String string = sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        if (!this.info.isIsSysBill()) {
            if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId)) {
                this.revalueForCoreBillIsSaleOrder();
            } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeId)) {
                this.revalueForCoreBillIsSaleBack();
            } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeId) && this.info.getBizType() != null) {
                if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(this.info.getBizType().getId().toString()) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString())) {
                    this.revalueForCoreBillIsTransferOerder(this.cou);
                } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString()) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString())) {
                    this.revalueForCoreBillIsTransferOerder(this.cou);
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString()) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString())) {
                    this.revalueForCoreBillIsTransferOerder(this.cou);
                }
            }
            for (int i = 0; i < this.info.getEntry().size(); ++i) {
                MaterialInventoryInfo materialInventory;
                SaleIssueEntryInfo entry = this.info.getEntry().get(i);
                if (entry.getMaterial() == null || entry.getWarehouse() != null || (materialInventory = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString())) == null || materialInventory.getDefaultWarehouse() == null) continue;
                entry.setWarehouse(materialInventory.getDefaultWarehouse());
            }
        } else {
            if (!(this.info.getCurrency().getId().toString().equals(this.cou.getBaseCurrency().getId().toString()) || this.cou.getBaseExchangeTable() != null && this.getExchangeRate(this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId())) != null)) {
                throw new InvBizException(InvBizException.NULL_EXCHANGERATETABLE, new String[]{""});
            }
            if (this.info.get("isIsSquareBalance") == null) {
                if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId)) {
                    if (this.info.get("settlementRelation") == null) {
                        this.revalueForVirtualBillPurchasing();
                    } else if (this.info.get("VT_CompanyOrgUnitID") != null) {
                        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.info.get("VT_CompanyOrgUnitID").toString()));
                        this.initExchange(sourceCompanyOrgUnitInfo);
                    }
                } else if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId)) {
                    this.reValueForVirtualBillIssuing();
                } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeId)) {
                    this.reValueForVirtualBillSaleBack();
                } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeId) && this.info.getBizType() != null) {
                    this.reValueForVirtualBillTransfering();
                }
            } else {
                if (this.info.getEntry().get(0).getCoreBillType() == null) {
                    return;
                }
                String companyID = "";
                CurrencyInfo currency = null;
                if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(this.info.getEntry().get(0).getCoreBillType().getId().toString())) {
                    SaleReturnsInfo st = SaleReturnsFactory.getLocalInstance((Context)this.ctx).getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSaleOrder()));
                    currency = st.getCurrency();
                    companyID = st.getCompanyOrgUnit().getId().toString();
                }
                if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(this.info.getEntry().get(0).getCoreBillType().getId().toString())) {
                    SaleOrderInfo saleOrderInfo = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSaleOrder()));
                    currency = saleOrderInfo.getCurrency();
                    companyID = saleOrderInfo.getCompanyOrgUnit().getId().toString();
                }
                CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                if (currency != null) {
                    currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
                    this.info.setCurrency(currency);
                    this.amountPrecision = this.info.getCurrency().getPrecision();
                }
                this.initExchange(sourceCompanyOrgUnitInfo);
            }
            WarehouseInfo warehouseInfo = this.getDefaultWarehouseByStorageUnit(this.ctx, this.info.getStorageOrgUnit().getId().toString());
            SaleIssueEntryInfo entry = null;
            int n = this.info.getEntry().size();
            for (int i = 0; i < n; ++i) {
                entry = this.info.getEntry().get(i);
                MaterialInventoryInfo materialInventory = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString());
                if (entry.getWarehouse() == null) {
                    if (materialInventory != null && materialInventory.getDefaultWarehouse() != null) {
                        entry.setWarehouse(materialInventory.getDefaultWarehouse());
                    } else if (warehouseInfo != null) {
                        entry.setWarehouse(warehouseInfo);
                    } else {
                        throw new InvBizException(InvBizException.NOWAREHOUSEINVIRTUALBILL);
                    }
                }
                if (entry.getWarehouse() != null) {
                    WarehouseInfo warehouse = entry.getWarehouse();
                    if (null != warehouse.getId() && null == warehouse.getNumber()) {
                        IWarehouse iFactory = WarehouseFactory.getLocalInstance((Context)this.ctx);
                        warehouse = iFactory.getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouse.getId().toString()));
                    }
                    if (warehouse.isHasLocation() && entry.getLocation() == null) {
                        LocationInfo location = this.getDefaultLocation(entry.getMaterial().getId().toString(), warehouse.getId().toString(), this.sou.getId().toString());
                        if (location == null) {
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)warehouse.getId().toString(), CompareType.EQUALS));
                            view.setFilter(filter);
                            LocationCollection locationcoll = LocationFactory.getLocalInstance((Context)this.ctx).getLocationCollection(view);
                            if (locationcoll != null && locationcoll.size() > 0) {
                                location = locationcoll.get(0);
                            }
                        }
                        entry.setLocation(location);
                    }
                }
                if (entry.getWarehouse() == null || entry.getStocker() != null) continue;
                entry.setStocker(entry.getWarehouse().getWhman());
            }
        }
        boolean isBillRelation = BillRelationOptionEnum.BRINGIN.equals((Object)this.info.getBillRelationOption());
        boolean isBotpPriceSource = FetchPriceEnum.FROMBOTP.equals((Object)this.info.getPriceSource());
        boolean isTransfer = "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sourceBillTypeID);
        if (!isBillRelation || isTransfer && (!isBotpPriceSource || this.needRecalculate())) {
            this.calByUnitSource(this.ctx, (InvBillBaseInfo)this.info, (IObjectCollection)this.info.getEntry());
            this.reCalculate();
        } else {
            this.dealSaleOrderBillRelation(sourceBillTypeID);
        }
    }

    private boolean needRecalculate() {
        if (this.info == null || this.info.getEntry() == null || this.getEntrySize() == 0) {
            return false;
        }
        SaleIssueEntryCollection entryColl = this.info.getEntry();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entryInfo = entryColl.get(i);
            if (entryInfo == null || entryInfo.getPrice() != null && entryInfo.getTaxPrice() != null && entryInfo.getAmount() != null) continue;
            return true;
        }
        return false;
    }

    private void dealSaleOrderBillRelation(String sourceBillTypeID) throws EASBizException, BOSException {
        String coreBillTypeID;
        BillTypeInfo coreBillType = this.info.getEntry().get(0).getCoreBillType();
        String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID) || "510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID)) {
            boolean isDoChangePrice = false;
            if (this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice"))) {
                isDoChangePrice = true;
                this.info.remove("doSaleChangePrice");
            }
            this.reCalQtyFields();
            this.getSaleOrderEntryQty();
            String key = null;
            SaleIssueEntryInfo entry = null;
            BigDecimal baseQty = new BigDecimal("0.00");
            int size = this.info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entry = this.info.getEntry().get(i);
                if (entry.isIsBetweenCompanySend()) {
                    this.reCalEntryFields(i);
                    continue;
                }
                key = entry.getSourceBillEntryId();
                if ("510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID)) {
                    key = entry.getSaleOrderEntry();
                }
                if ((baseQty = this.soBaseQtyMap.get(key)) != null && baseQty.compareTo(entry.getBaseQty()) == 0 && !isDoChangePrice) {
                    this.checkBotp(entry);
                    continue;
                }
                this.reCalEntryFields(i);
            }
            this.reCalStandardCostFields();
            if (!isDoChangePrice) {
                this.reCalWriteOffFields();
            }
            this.calTotalFields();
        }
    }

    private void getSaleOrderEntryQty() throws EASBizException, BOSException {
        String coreBillTypeID;
        this.soBaseQtyMap = new HashMap<String, BigDecimal>();
        this.soAssociateMap = new HashMap<String, BigDecimal>();
        BillTypeInfo sourceBillType = this.info.getSourceBillType();
        String sourceBillTypeID = sourceBillType == null ? null : sourceBillType.getId().toString();
        BillTypeInfo coreBillType = this.info.getEntry().get(0).getCoreBillType();
        String string = coreBillTypeID = coreBillType == null ? null : coreBillType.getId().toString();
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeID) || "510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(sourceBillTypeID) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeID)) {
            if (this.saleOrderMap.isEmpty()) {
                this.getCoreBillInfoMap(this.ctx, this.saleOrderMap, this.saleOrderEntryMap);
            }
            Map.Entry<String, SaleOrderEntryInfo> mapEntry2 = null;
            for (Map.Entry<String, SaleOrderEntryInfo> mapEntry2 : this.saleOrderEntryMap.entrySet()) {
                this.soBaseQtyMap.put(mapEntry2.getKey(), mapEntry2.getValue().getBaseQty());
                this.soAssociateMap.put(mapEntry2.getKey(), mapEntry2.getValue().getAssociateQty());
            }
        }
    }

    private void checkBotp(SaleIssueEntryInfo saleissueEntry) throws BOSException, EASBizException {
        if (saleissueEntry == null) {
            return;
        }
        StringBuffer detail = new StringBuffer();
        StringBuffer errorMsg = new StringBuffer();
        if (!saleissueEntry.isIsPresent()) {
            if (saleissueEntry.getSalePrice() == null || BigDecimal.ZERO.compareTo(saleissueEntry.getSalePrice()) == 0) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"SALEPRICE", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getTaxPrice() == null || BigDecimal.ZERO.compareTo(saleissueEntry.getTaxPrice()) == 0) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAXPRICE", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getDiscountType() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"DISCOUNTTYPE", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getDiscount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"DISCOUNT", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getDiscountAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"DISCOUNTAMOUNT", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getActualPrice() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ACTUALPRICE", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getPrice() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"PRICE", (Context)this.ctx)).append(", ");
            }
            boolean isIgnore = false;
            DiscountModeEnum discountMode = saleissueEntry.getDiscountType();
            if (discountMode == DiscountModeEnum.PERUNIT) {
                if (this.info.isIsInTax()) {
                    if (saleissueEntry.getTaxPrice().compareTo(saleissueEntry.getDiscount()) == 0) {
                        isIgnore = true;
                    }
                } else if (saleissueEntry.getSalePrice().compareTo(saleissueEntry.getDiscount()) == 0) {
                    isIgnore = true;
                }
            } else if (discountMode == DiscountModeEnum.PERCENT && saleissueEntry.getDiscount().compareTo(new BigDecimal("100")) == 0) {
                isIgnore = true;
            }
            if (!(isIgnore || saleissueEntry.getNonTaxAmount() != null && BigDecimal.ZERO.compareTo(saleissueEntry.getNonTaxAmount()) != 0)) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"NONTAXAMOUNT", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getLocalNonTaxAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALNONTAXMOUNT", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getTaxRate() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAXRATE", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getTax() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"TAX", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getLocalTax() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALTAX", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"AMOUNT", (Context)this.ctx)).append(", ");
            }
            if (saleissueEntry.getLocalAmount() == null) {
                detail.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"LOCALAMOUNT", (Context)this.ctx));
            }
            if (detail.length() > 0) {
                errorMsg.append("\n");
                errorMsg.append(detail);
                throw new InvBizException(InvBizException.BILLRELATIONFIELDNOTNULL, new String[]{errorMsg.toString()});
            }
        }
    }

    private SelectorItemCollection getPurOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.precision"));
        return sic;
    }

    private void revalueForVirtualBillPurchasing() throws EASBizException, BOSException {
        PurInnerDealPriceInfo priceInfo = null;
        SupplierInfo supplier = null;
        CustomerInfo customer = null;
        if (this.info.get("PurInnerDealPrice") == null) {
            return;
        }
        PurInnerDealPriceCollection purPriceCol = (PurInnerDealPriceCollection)this.info.get("PurInnerDealPrice");
        priceInfo = purPriceCol.get(0);
        if (priceInfo != null) {
            CustomerCollection innerCustomerCol;
            SupplierCollection innerSupplierCollection;
            if (priceInfo.getSupCompanyOrg() != null && (innerSupplierCollection = SupplierFactory.getLocalInstance((Context)this.ctx).getInterSupplierCollection(priceInfo.getSupCompanyOrg().getId().toString(), null)) != null && innerSupplierCollection.size() > 0) {
                supplier = innerSupplierCollection.get(0);
            }
            if (priceInfo.getRecCompanyOrg() != null && (innerCustomerCol = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(priceInfo.getRecCompanyOrg().getId().toString(), null)) != null && innerCustomerCol.size() > 0) {
                customer = innerCustomerCol.get(0);
                this.info.setCustomer(customer);
            }
            this.info.setCurrency(priceInfo.getCurrency());
            this.amountPrecision = priceInfo.getCurrency().getPrecision();
            this.info.setExchangeRate(priceInfo.getExchangeRate());
        }
        Map<String, PurInnerDealPriceInfo> priceMap = this.mapInnerDealPrice(purPriceCol);
        SaleIssueEntryCollection saleIssueEntryCol = this.info.getEntry();
        SaleIssueEntryInfo entry = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("companyOrgUnit.id");
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            BigDecimal conversionRate;
            entry = saleIssueEntryCol.get(i);
            if (entry == null) continue;
            entry.setBalanceCustomer(customer);
            entry.setPaymentCustomer(customer);
            entry.setOrderCustomer(customer);
            entry.setSupplier(supplier);
            if (StringUtils.isEmpty((String)entry.getSaleOrderEntry()) || priceMap == null || !priceMap.containsKey(entry.getSaleOrderEntry())) continue;
            priceInfo = priceMap.get(entry.getSaleOrderEntry());
            if (null == this.info.getPriceSource()) {
                this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (priceInfo == null) continue;
            if (this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && !priceInfo.getPrice().equals(SysConstant.BIGZERO) && !priceInfo.getTaxPrice().equals(SysConstant.BIGZERO)) {
                entry.setSalePrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscount(priceInfo.getDiscount());
                entry.setTaxPrice(priceInfo.getTaxPrice());
                entry.setDiscountType(priceInfo.getDiscountMode());
            }
            entry.setSaleOrgUnit(priceInfo.getSaleOrgUnit());
            entry.setWarehouse(priceInfo.getSupWareHouse());
            entryUnit = entry.getUnit();
            orderUnit = priceInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entry.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entry.getTaxPrice() == null ? SysConstant.BIGZERO : entry.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
                entry.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entry.getPrice() == null ? SysConstant.BIGZERO : entry.getPrice();
            price = price.divide(conversionRate, entry.getMaterial().getPricePrecision(), 4);
            entry.setPrice(price);
        }
    }

    @Override
    protected BigDecimal getActualCost(int i) {
        return this.getBigDecimal("actualCost", i);
    }

    @Override
    protected BigDecimal getAmount(int i) {
        return this.getBigDecimal("nonTaxAmount", i);
    }

    @Override
    protected int getAmountPrecision() {
        return this.amountPrecision;
    }

    @Override
    protected MeasureUnitInfo getAssistUnit(int i) {
        return this.info.getEntry().get(i).getAssistUnit();
    }

    @Override
    protected BigDecimal getBaseQty(int i) {
        return this.getBigDecimal("baseQty", i);
    }

    @Override
    protected ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    protected BigDecimal getDiscountAmount(int i) {
        return this.getBigDecimal("discountAmount", i);
    }

    @Override
    protected BigDecimal getDiscountRate(int i) {
        return this.getBigDecimal("discount", i);
    }

    @Override
    protected DiscountModeEnum getDiscountType(int i) {
        return this.info.getEntry().get(i).getDiscountType();
    }

    @Override
    protected int getEntrySize() {
        return this.info.getEntry().size();
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return this.info.getExchangeRate() == null ? SCMConstant.BIGDECIMAL_ONE : this.info.getExchangeRate();
    }

    @Override
    protected BigDecimal getLocalAmount(int i) {
        return this.getBigDecimal("localNonTaxAmount", i);
    }

    @Override
    protected int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    protected BigDecimal getLocalPrice(int i) {
        return this.getBigDecimal("localPrice", i);
    }

    protected BigDecimal getLocalTax(int i) {
        return this.getBigDecimal("localTax", i);
    }

    @Override
    protected BigDecimal getLocalTaxAmount(int i) {
        return this.getBigDecimal("localAmount", i);
    }

    @Override
    protected MaterialInfo getMaterial(int i) {
        return this.info.getEntry().get(i).getMaterial();
    }

    @Override
    protected BigDecimal getPrice(int i) {
        return this.getBigDecimal("salePrice", i);
    }

    @Override
    protected int getPricePrecision(int i) {
        return this.info.getEntry().get(i).getMaterial().getPricePrecision();
    }

    @Override
    protected BigDecimal getQty(int i) {
        return this.getBigDecimal("qty", i);
    }

    protected BigDecimal getReturnBaseQty(int i) {
        return this.getBigDecimal("returnBaseQty", i);
    }

    @Override
    protected BigDecimal getStandardCost(int i) {
        return this.getBigDecimal("standardCost", i);
    }

    @Override
    protected BigDecimal getTax(int i) {
        return this.getBigDecimal("tax", i);
    }

    @Override
    protected BigDecimal getTaxAmount(int i) {
        return this.getBigDecimal("amount", i);
    }

    @Override
    protected BigDecimal getTaxPrice(int i) {
        return this.getBigDecimal("taxPrice", i);
    }

    @Override
    protected BigDecimal getTaxRate(int i) {
        return this.getBigDecimal("taxRate", i);
    }

    @Override
    protected TransactionTypeInfo getTransactionType() {
        return this.info.getTransactionType();
    }

    @Override
    protected MeasureUnitInfo getUnit(int i) {
        return this.info.getEntry().get(i).getUnit();
    }

    @Override
    protected WarehouseInfo getWarehouse(int i) {
        return this.info.getEntry().get(i).getWarehouse();
    }

    @Override
    protected BigDecimal getUnitStandardCost(int i) {
        return this.getBigDecimal("unitStandardCost", i);
    }

    @Override
    protected boolean isInTax() {
        return this.info.isIsInTax();
    }

    protected boolean isIsPresent(int i) {
        return this.info.getEntry().get(i).isIsPresent();
    }

    @Override
    protected boolean isIsReversed() {
        return this.info.isIsReversed();
    }

    @Override
    protected void setMaterial(MaterialInfo materialInfo, int i) {
        this.info.getEntry().get(i).setMaterial(materialInfo);
    }

    @Override
    protected void setActualCost(BigDecimal actualCost, int i) {
        this.info.getEntry().get(i).setActualCost(actualCost);
    }

    @Override
    protected void setActualPrice(BigDecimal actualPrice, int i) {
        this.info.getEntry().get(i).setActualPrice(actualPrice);
    }

    @Override
    protected void setActualTaxPrice(BigDecimal actualTaxPrice, int i) {
        this.info.getEntry().get(i).setPrice(actualTaxPrice);
    }

    @Override
    protected void setAmount(BigDecimal amount, int i) {
        this.info.getEntry().get(i).setNonTaxAmount(amount);
    }

    @Override
    protected void setAssistQty(BigDecimal assistQty, int i) {
        this.info.getEntry().get(i).setAssistQty(assistQty);
    }

    protected void setAssociateQty(BigDecimal associateQty, int i) {
        this.info.getEntry().get(i).setAssociateQty(associateQty);
    }

    @Override
    protected void setBaseQty(BigDecimal baseQty, int i) {
        this.info.getEntry().get(i).setBaseQty(baseQty);
    }

    protected void setCompanyOrgUnit(CompanyOrgUnitInfo cou, int i) {
        this.info.getEntry().get(i).setCompanyOrgUnit(cou);
    }

    @Override
    protected void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.info.getEntry().get(i).setDiscountAmount(discountAmount);
    }

    @Override
    protected void setLocalAmount(BigDecimal localAmount, int i) {
        this.info.getEntry().get(i).setLocalNonTaxAmount(localAmount);
    }

    protected void setLocalPrice(BigDecimal localPrice, int i) {
        this.info.getEntry().get(i).setLocalPrice(localPrice);
    }

    @Override
    protected void setLocalTax(BigDecimal localTax, int i) {
        this.info.getEntry().get(i).setLocalTax(localTax);
    }

    @Override
    protected void setLocalTaxAmount(BigDecimal localTaxAmount, int i) {
        this.info.getEntry().get(i).setLocalAmount(localTaxAmount);
    }

    @Override
    protected void setPrice(BigDecimal price, int i) {
        this.info.getEntry().get(i).setSalePrice(price);
    }

    @Override
    protected void setQty(BigDecimal qty, int i) {
        this.info.getEntry().get(i).setQty(qty);
    }

    protected void setReturnBaseQty(BigDecimal returnBaseQty, int i) {
        this.info.getEntry().get(i).setReturnBaseQty(returnBaseQty);
    }

    @Override
    protected void setStandardCost(BigDecimal standardCost, int i) {
        this.info.getEntry().get(i).setStandardCost(standardCost);
    }

    @Override
    protected void setTax(BigDecimal tax, int i) {
        this.info.getEntry().get(i).setTax(tax);
    }

    @Override
    protected void setTaxAmount(BigDecimal taxAmount, int i) {
        this.info.getEntry().get(i).setAmount(taxAmount);
    }

    @Override
    protected void setTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntry().get(i).setTaxPrice(taxPrice);
    }

    @Override
    protected void setTotalActualCost(BigDecimal totalActualCost) {
        this.info.setTotalActualCost(totalActualCost);
    }

    @Override
    protected void setTotalAmount(BigDecimal totalAmount) {
    }

    @Override
    protected void setTotalLocalAmount(BigDecimal totalLocalAmount) {
        this.info.setTotalLocalAmount(totalLocalAmount);
    }

    @Override
    protected void setTotalStandardCost(BigDecimal totalStandardCost) {
        this.info.setTotalStandardCost(totalStandardCost);
    }

    @Override
    protected void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setTotalAmount(totalTaxAmount);
    }

    @Override
    protected void setUnitActualCost(BigDecimal divide, int i) {
        this.info.getEntry().get(i).setUnitActualCost(divide);
    }

    @Override
    protected void setUnitStandardCost(BigDecimal unitStandardCost, int i) {
        this.info.getEntry().get(i).setUnitStandardCost(unitStandardCost);
    }

    protected void setUnReturnedBaseQty(BigDecimal unReturnedBaseQty, int i) {
        this.info.getEntry().get(i).setUnReturnedBaseQty(unReturnedBaseQty);
    }

    protected void setUnWriteOffAmount(BigDecimal unWriteOffAmount, int i) {
        this.info.getEntry().get(i).setUnWriteOffAmount(unWriteOffAmount);
    }

    protected void setUnWriteOffBaseQty(BigDecimal unWriteOffBaseQty, int i) {
        this.info.getEntry().get(i).setUnWriteOffBaseQty(unWriteOffBaseQty);
    }

    protected void setUnWriteOffQty(BigDecimal unWriteOffQty, int i) {
        this.info.getEntry().get(i).setUnWriteOffQty(unWriteOffQty);
    }

    protected void setWrittenOffAmount(BigDecimal writtenOffAmount, int i) {
        this.info.getEntry().get(i).setWrittenOffAmount(writtenOffAmount);
    }

    protected void setWrittenOffBaseQty(BigDecimal writtenOffBaseQty, int i) {
        this.info.getEntry().get(i).setWrittenOffBaseQty(writtenOffBaseQty);
    }

    protected void setWrittenOffQty(BigDecimal writtenOffQty, int i) {
        this.info.getEntry().get(i).setWrittenOffQty(writtenOffQty);
    }

    private void checkBotp(SaleIssueBillInfo info) throws InvBizException {
        if (info.get("isInTax") == null) {
            throw new InvBizException(InvBizException.BOTP_ISINTAXNOTCONFIG);
        }
        if (info.get("currency") == null) {
            throw new InvBizException(InvBizException.BOTP_CURRENCYNOTCONFIG);
        }
        if (info.getEntry() == null || info.getEntry().get(0) == null) {
            return;
        }
        if (info.isIsInTax()) {
            if (info.getEntry().get(0).get("taxPrice") == null && info.getEntry().get(0).get("amount") == null) {
                throw new InvBizException(InvBizException.BOTP_TAXPRICEORTAXAMOUNTNOTCONFIG);
            }
        } else if (info.getEntry().get(0).get("salePrice") == null && info.getEntry().get(0).get("nonTaxAmount") == null) {
            throw new InvBizException(InvBizException.BOTP_PRICEORAMOUNTNOTCONFIG);
        }
    }

    private void doSplitBillChildEntry(SaleIssueEntryInfo motherEntryInfo, SaleIssueEntryInfo childEntryInfo, SaleIssueEntryInfo srcBillEntryInfo) throws EASBizException, BOSException {
        PropertyCalculator pCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)childEntryInfo);
        pCalculator.evalForEntry("qty=" + srcBillEntryInfo.getUnWriteOffQty(), -1);
        pCalculator.evalForEntry("baseQty=" + srcBillEntryInfo.getUnWriteOffBaseQty(), -1);
        pCalculator.evalForEntry("actualCost=(qty/" + srcBillEntryInfo.getQty() + ")*" + srcBillEntryInfo.getActualCost(), this.getLocalAmountPrecision());
        pCalculator.evalForEntry("standardCost=(qty/" + srcBillEntryInfo.getQty() + ")*" + srcBillEntryInfo.getStandardCost(), this.getLocalAmountPrecision());
        pCalculator.evalForEntry("writtenOffQty=0", -1);
        pCalculator.evalForEntry("writtenOffAmount=0", -1);
        pCalculator.evalForEntry("UnReturnedBaseQty=baseqty", -1);
        pCalculator.evalForEntry("ReturnsQty=0", -1);
        pCalculator.evalForEntry("ReturnBaseQty=0", -1);
        pCalculator.evalForEntry("drewQty=0", -1);
        pCalculator.evalForEntry("writtenOffBaseQty=0", -1);
        pCalculator.evalForEntry("unWriteOffQty=qty", -1);
        pCalculator.evalForEntry("unWriteOffAmount=actualCost", -1);
        pCalculator.evalForEntry("assistQty=qty/" + srcBillEntryInfo.getQty() + "*" + srcBillEntryInfo.getAssistQty(), -1);
        pCalculator.evalForEntry("taxRate=" + srcBillEntryInfo.getTaxRate(), -1);
        childEntryInfo.setDiscountType(srcBillEntryInfo.getDiscountType());
        pCalculator.evalForEntry("discount=" + srcBillEntryInfo.getDiscount(), -1);
        if (this.isInTax()) {
            pCalculator.evalForEntry("taxPrice=" + srcBillEntryInfo.getTaxPrice(), -1);
            if (DiscountModeEnum.NULL.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            pCalculator.evalForEntry("amount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                pCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
                pCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            pCalculator.evalForEntry("tax=amount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                pCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
                pCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            pCalculator.evalForEntry("nonTaxAmount=amount-tax", this.getAmountPrecision());
            pCalculator.evalForEntry("localNonTaxAmount=localAmount-localTax", this.getLocalAmountPrecision());
            pCalculator.evalForEntry("salePrice=taxPrice/(1+taxRate/100)", -1);
            if (childEntryInfo.getDiscount().compareTo(SysConstant.BIGZERO) == 0) {
                pCalculator.evalForEntry("actualPrice=salePrice", -1);
            } else {
                pCalculator.evalForEntry("actualPrice=nonTaxAmount/qty", -1);
            }
            if (childEntryInfo.getDiscount().compareTo(SysConstant.BIGZERO) == 0) {
                pCalculator.evalForEntry("price=taxPrice", -1);
            } else {
                pCalculator.evalForEntry("price=amount/qty", -1);
            }
        } else {
            pCalculator.evalForEntry("salePrice=" + srcBillEntryInfo.getSalePrice(), -1);
            pCalculator.evalForEntry("taxPrice=salePrice*(1+taxRate/100)", -1);
            if (DiscountModeEnum.NULL.equals((Object)childEntryInfo.getDiscountType()) || DiscountModeEnum.PERCENT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("nonTaxAmount=qty*salePrice*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("nonTaxAmount=qty*(salePrice-discount/(1+taxRate/100))", this.getAmountPrecision());
            }
            if (DiscountModeEnum.NULL.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)childEntryInfo.getDiscountType())) {
                pCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            pCalculator.evalForEntry("localNonTaxAmount=nonTaxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            pCalculator.evalForEntry("tax=nonTaxAmount*(taxRate/100)", this.getAmountPrecision());
            pCalculator.evalForEntry("amount=nonTaxAmount+tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                pCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
                pCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            pCalculator.evalForEntry("localAmount=localNonTaxAmount+localTax", this.getLocalAmountPrecision());
            if (childEntryInfo.getDiscount().compareTo(SysConstant.BIGZERO) == 0) {
                pCalculator.evalForEntry("price=taxPrice", -1);
            } else {
                pCalculator.evalForEntry("price=amount/qty", -1);
            }
            if (childEntryInfo.getDiscount().compareTo(SysConstant.BIGZERO) == 0) {
                pCalculator.evalForEntry("actualPrice=salePrice", -1);
            } else {
                pCalculator.evalForEntry("actualPrice=nonTaxAmount/qty", -1);
            }
        }
    }

    private void doSplitBillMotherEntry(SaleIssueEntryInfo motherEntryInfo, SaleIssueEntryInfo childEntryInfo, SaleIssueEntryInfo srcBillEntryInfo) throws EASBizException, BOSException {
        PropertyCalculator pCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)motherEntryInfo);
        pCalculator.evalForEntry("qty=" + srcBillEntryInfo.getWrittenOffQty(), -1);
        pCalculator.evalForEntry("baseQty=" + srcBillEntryInfo.getWrittenOffBaseQty(), -1);
        pCalculator.evalForEntry("actualCost=" + srcBillEntryInfo.getActualCost().subtract(childEntryInfo.getActualCost()), -1);
        pCalculator.evalForEntry("standardCost=" + srcBillEntryInfo.getStandardCost().subtract(childEntryInfo.getStandardCost()), -1);
        pCalculator.evalForEntry("writtenOffQty=qty", -1);
        pCalculator.evalForEntry("writtenOffAmount=actualCost", -1);
        pCalculator.evalForEntry("unWriteOffQty=0", -1);
        pCalculator.evalForEntry("unWriteOffBaseQty=0", -1);
        pCalculator.evalForEntry("unWriteOffAmount=0", -1);
        pCalculator.evalForEntry("assistQty=" + srcBillEntryInfo.getAssistQty().subtract(childEntryInfo.getAssistQty()), -1);
        pCalculator.evalForEntry("salePrice=" + srcBillEntryInfo.getSalePrice(), -1);
        pCalculator.evalForEntry("taxRate=" + srcBillEntryInfo.getTaxRate(), -1);
        motherEntryInfo.setDiscountType(srcBillEntryInfo.getDiscountType());
        pCalculator.evalForEntry("discount=" + srcBillEntryInfo.getDiscount(), -1);
        pCalculator.evalForEntry("taxPrice=" + srcBillEntryInfo.getTaxPrice(), -1);
        pCalculator.evalForEntry("actualPrice=" + srcBillEntryInfo.getActualPrice(), -1);
        pCalculator.evalForEntry("price=" + srcBillEntryInfo.getPrice(), -1);
        pCalculator.evalForEntry("discountAmount=" + srcBillEntryInfo.getDiscountAmount().subtract(childEntryInfo.getDiscountAmount()), this.getAmountPrecision());
        pCalculator.evalForEntry("nonTaxAmount=" + srcBillEntryInfo.getNonTaxAmount().subtract(childEntryInfo.getNonTaxAmount()), this.getAmountPrecision());
        pCalculator.evalForEntry("localNonTaxAmount=" + srcBillEntryInfo.getLocalNonTaxAmount().subtract(childEntryInfo.getLocalNonTaxAmount()), this.getLocalAmountPrecision());
        pCalculator.evalForEntry("tax=" + srcBillEntryInfo.getTax().subtract(childEntryInfo.getTax()), this.getAmountPrecision());
        pCalculator.evalForEntry("localTax=" + srcBillEntryInfo.getLocalTax().subtract(childEntryInfo.getLocalTax()), this.getLocalAmountPrecision());
        pCalculator.evalForEntry("amount=" + srcBillEntryInfo.getAmount().subtract(childEntryInfo.getAmount()), this.getAmountPrecision());
        pCalculator.evalForEntry("localAmount=" + srcBillEntryInfo.getLocalAmount().subtract(childEntryInfo.getLocalAmount()), this.getLocalAmountPrecision());
    }

    private BigDecimal getBigDecimal(String fieldName, int i) {
        return this.nullToZero(this.info.getEntry().get(i).getBigDecimal(fieldName));
    }

    private PaymentTypeInfo getDefaultAPaymentTypeInfo() throws EASBizException, BOSException {
        return PaymentTypeFactory.getLocalInstance((Context)this.ctx).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
    }

    private ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    private SelectorItemCollection perpareSelectorForSaleOrder() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orderCustomer.id"));
        sic.add(new SelectorItemInfo("orderCustomer.number"));
        sic.add(new SelectorItemInfo("orderCustomer.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("balanceCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.isLocked"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.id"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.number"));
        sic.add(new SelectorItemInfo("entries.receiveCustomer.name"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.id"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.number"));
        sic.add(new SelectorItemInfo("entries.paymentCustomer.name"));
        sic.add(new SelectorItemInfo("entries.baseQty"));
        sic.add(new SelectorItemInfo("entries.associateQty"));
        return sic;
    }

    private void reCalculate() throws EASBizException, BOSException {
        this.reCalQtyFields();
        this.reCalEntryFields();
        this.reCalStandardCostFields();
        this.reCalWriteOffFields();
        this.calTotalFields();
    }

    private void reCalQtyFields() throws EASBizException, BOSException {
        boolean isNegativeBill = this.isNegativeBill();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.info.getBizType() == null || !"d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(this.info.getBizType().getId().toString()) || this.info.getSourceBillType() == null || !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
                if (this.info.getEntry().get(i).getBoolean("isCalQtyByBaseQty")) {
                    this.calQtyByBaseQty(i);
                } else {
                    this.setQty(isNegativeBill ? this.getQty(i).abs().negate() : this.getQty(i).abs(), i);
                    this.calBaseQtyByQty(i);
                }
                if (this.info.getEntry().get(i).getAssistQty() == null) {
                    this.calAssistQtyByBaseQty(i);
                }
                if (this.info.getEntry().get(i).getAssistQty() != null && this.info.getEntry().get(i).getAssistQty().compareTo(SysConstant.BIGZERO) != 0) {
                    this.setAssistQty(isNegativeBill ? this.info.getEntry().get(i).getAssistQty().abs().negate() : this.info.getEntry().get(i).getAssistQty().abs(), i);
                }
            }
            this.setReturnBaseQty(this.nullToZero(this.getReturnBaseQty(i)), i);
            this.setAssociateQty(this.getBaseQty(i).abs(), i);
            this.setUnReturnedBaseQty(this.getBaseQty(i).abs().subtract(this.getReturnBaseQty(i).abs()), i);
        }
    }

    private void reCalWriteOffFields() throws EASBizException, BOSException {
        boolean isNeedPresent2Ar = true;
        if (this.info.getEntry().size() > 0 && this.info.getEntry().get(0) != null && this.info.getEntry().get(0).getCompanyOrgUnit() != null) {
            isNeedPresent2Ar = this.isNeedPresent2Ar(this.info.getEntry().get(0).getCompanyOrgUnit().getId().toString());
        }
        if (this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice"))) {
            return;
        }
        boolean isNegativeBill = this.isNegativeBill();
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (!this.isIsPresent(i) || isNeedPresent2Ar) {
                this.setUnWriteOffQty(this.getQty(i), i);
                this.setUnWriteOffAmount(isNegativeBill ? this.getActualCost(i).abs().negate() : this.getActualCost(i), i);
                this.setUnWriteOffBaseQty(this.getBaseQty(i), i);
                this.setWrittenOffQty(SysConstant.BIGZERO, i);
                this.setWrittenOffBaseQty(SysConstant.BIGZERO, i);
                this.setWrittenOffAmount(SysConstant.BIGZERO, i);
                continue;
            }
            this.setUnWriteOffQty(SysConstant.BIGZERO, i);
            this.setUnWriteOffBaseQty(SysConstant.BIGZERO, i);
            this.setUnWriteOffAmount(SysConstant.BIGZERO, i);
            this.setWrittenOffQty(this.getQty(i), i);
            this.setWrittenOffBaseQty(this.getBaseQty(i), i);
            this.setWrittenOffAmount(this.getActualCost(i), i);
        }
    }

    private boolean isNeedPresent2Ar(String couId) throws EASBizException, BOSException {
        String paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectStringPK(couId), "AR_032");
        return null != paramValue && "true".equalsIgnoreCase(paramValue.trim());
    }

    private void reCalStandardCostFields() throws EASBizException, BOSException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        if (this.cou == null && this.sou != null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(this.sou.getId().toString(), 4, 1);
            this.cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        for (int i = 0; i < this.getEntrySize(); ++i) {
            if (this.sou == null || this.sou.getId() == null) {
                this.setUnitStandardCost(SysConstant.BIGZERO, i);
                this.setStandardCost(SysConstant.BIGZERO, i);
                continue;
            }
            this.calUnitStandardCost(i);
            this.calStandardCostByUnitStandardCost(i);
        }
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("balanceCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("balanceCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("balanceCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        return sic;
    }

    private void revalueForCoreBillIsSaleBack() throws EASBizException, BOSException {
        HashMap<String, SaleReturnsInfo> saleReturnsMap = new HashMap<String, SaleReturnsInfo>();
        HashMap saleReturnsEntryMap = new HashMap();
        this.getCoreBillInfoMap(this.ctx, saleReturnsMap, saleReturnsEntryMap);
        SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)saleReturnsMap.get(this.info.getEntry().get(0).getSaleOrder());
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = saleReturnsInfo.getCompanyOrgUnit();
        if (saleReturnsInfo.getCurrency() != null) {
            CurrencyInfo currency = saleReturnsInfo.getCurrency();
            this.info.setCurrency(currency);
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
        CustomerInfo customerInfo = null;
        HashMap<String, CustomerInfo> innerBalanceMap = new HashMap<String, CustomerInfo>();
        int n = this.info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            SaleReturnInnerDealPriceInfo priceInfo;
            SaleIssueEntryInfo entry = this.info.getEntry().get(i);
            saleReturnsInfo = (SaleReturnsInfo)saleReturnsMap.get(entry.getSaleOrder());
            if (saleReturnsInfo == null) {
                saleReturnsInfo = SaleReturnsFactory.getLocalInstance((Context)this.ctx).getSaleReturnsInfo((IObjectPK)new ObjectUuidPK(entry.getSaleOrder()), this.getSelectorItemCollection());
                saleReturnsMap.put(saleReturnsInfo.getId().toString(), saleReturnsInfo);
            }
            if (entry.isIsCenterBalance() && entry.isIsSquareBalance() && entry.isIsBetweenCompanySend()) {
                customerInfo = (CustomerInfo)innerBalanceMap.get(saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString());
                if (customerInfo == null) {
                    customerInfo = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString(), null).get(0);
                    innerBalanceMap.put(saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString(), customerInfo);
                }
                entry.setBalanceCustomer(customerInfo);
                entry.setPaymentCustomer(customerInfo);
                priceInfo = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entry.getSaleOrder(), entry.getSaleOrderEntry(), saleReturnsInfo.getEntries().get(0).getCompanyOrgUnit().getId().toString());
                if (null == this.info.getPriceSource()) {
                    this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
                }
                if (this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice")) || priceInfo == null || !this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO) || !this.isReFetchPrice()) continue;
                entry.setSalePrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscountType(priceInfo.getDiscountMode());
                entry.setDiscount(priceInfo.getDiscount());
                entry.setTaxPrice(priceInfo.getTaxPrice());
                continue;
            }
            if (!entry.isIsCenterBalance() || !entry.isIsBetweenCompanySend()) continue;
            customerInfo = (CustomerInfo)innerBalanceMap.get(saleReturnsInfo.getCompanyOrgUnit().getId().toString());
            this.info.setCurrency(sourceCompanyOrgUnitInfo.getBaseCurrency());
            this.amountPrecision = this.info.getCurrency().getPrecision();
            this.initExchange(sourceCompanyOrgUnitInfo);
            if (customerInfo == null) {
                customerInfo = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleReturnsInfo.getCompanyOrgUnit().getId().toString(), null).get(0);
                innerBalanceMap.put(saleReturnsInfo.getCompanyOrgUnit().getId().toString(), customerInfo);
            }
            entry.setBalanceCustomer(customerInfo);
            entry.setPaymentCustomer(entry.getBalanceCustomer());
            priceInfo = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entry.getSaleOrderEntry());
            if (null == this.info.getPriceSource()) {
                this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
            }
            if (this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice")) || priceInfo == null || !this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO) || !this.isReFetchPrice()) continue;
            entry.setSalePrice(priceInfo.getPrice());
            entry.setTaxRate(priceInfo.getTaxRate());
            entry.setDiscountType(priceInfo.getDiscountMode());
            entry.setDiscount(priceInfo.getDiscount());
            entry.setTaxPrice(priceInfo.getTaxPrice());
        }
    }

    private void revalueForCoreBillIsSaleOrder() throws EASBizException, BOSException {
        if (this.info.getEntry().get(0).getSaleOrder() == null) {
            return;
        }
        this.saleOrderMap = new HashMap<String, SaleOrderInfo>();
        this.saleOrderEntryMap = new HashMap<String, SaleOrderEntryInfo>();
        this.getCoreBillInfoMap(this.ctx, this.saleOrderMap, this.saleOrderEntryMap);
        SaleOrderInfo saleOrderInfo = this.saleOrderMap.get(this.info.getEntry().get(0).getSaleOrder());
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        if (this.info.getSourceBillType() == null || !"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
            sourceCompanyOrgUnitInfo = saleOrderInfo.getCompanyOrgUnit();
        }
        HashMap<String, CustomerInfo> mapSOCompanyInfo = new HashMap<String, CustomerInfo>();
        if (saleOrderInfo.getCurrency() != null) {
            this.info.setCurrency(saleOrderInfo.getCurrency());
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        SaleIssueEntryInfo entry = null;
        SaleOrderEntryInfo sourceEntryInfo = null;
        CustomerInfo customerInfo = null;
        HashMap<String, CustomerInfo> innerBalanceMap = new HashMap<String, CustomerInfo>();
        int size = this.info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            SaleInnerDealPriceInfo priceInfo;
            entry = this.info.getEntry().get(i);
            if (null == entry.getSaleOrder()) continue;
            saleOrderInfo = this.saleOrderMap.get(entry.getSaleOrder());
            if (saleOrderInfo == null) {
                saleOrderInfo = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo((IObjectPK)new ObjectUuidPK(entry.getSaleOrder()), this.perpareSelectorForSaleOrder());
                if (saleOrderInfo == null) continue;
                this.saleOrderMap.put(saleOrderInfo.getId().toString(), saleOrderInfo);
            }
            if ((sourceEntryInfo = this.saleOrderEntryMap.get(entry.getSaleOrderEntry())) == null) continue;
            if (sourceCompanyOrgUnitInfo == null) {
                sourceCompanyOrgUnitInfo = sourceEntryInfo.getCompanyOrgUnit();
            }
            if (entry.isIsCenterBalance() && entry.isIsSquareBalance() && entry.isIsBetweenCompanySend()) {
                CustomerCollection innerBalanceCustomerCollection;
                entry.setOrderCustomer(saleOrderInfo.getOrderCustomer());
                customerInfo = (CustomerInfo)innerBalanceMap.get(saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString());
                if (customerInfo == null && (innerBalanceCustomerCollection = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString(), null)) != null && innerBalanceCustomerCollection.size() > 0) {
                    customerInfo = innerBalanceCustomerCollection.get(0);
                    innerBalanceMap.put(saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString(), customerInfo);
                }
                entry.setBalanceCustomer(customerInfo);
                entry.setPaymentCustomer(customerInfo);
                priceInfo = SaleInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entry.getSaleOrder(), entry.getSaleOrderEntry(), sourceEntryInfo.getCompanyOrgUnit().getId().toString());
                if (null == this.info.getPriceSource()) {
                    this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
                }
                if (this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice")) || priceInfo == null || !this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO) || !this.isReFetchPrice()) continue;
                entry.setSalePrice(priceInfo.getPrice());
                entry.setTaxRate(priceInfo.getTaxRate());
                entry.setDiscountType(priceInfo.getDiscountMode());
                entry.setDiscount(priceInfo.getDiscount());
                entry.setTaxPrice(priceInfo.getTaxPrice());
                continue;
            }
            if (entry.isIsCenterBalance() && entry.isIsBetweenCompanySend()) {
                if (!mapSOCompanyInfo.containsKey(entry.getSaleOrder())) {
                    mapSOCompanyInfo.put(entry.getSaleOrder(), CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(saleOrderInfo.getCompanyOrgUnit().getId().toString(), null).get(0));
                }
                entry.setOrderCustomer(saleOrderInfo.getOrderCustomer());
                entry.setBalanceCustomer((CustomerInfo)mapSOCompanyInfo.get(entry.getSaleOrder()));
                entry.setPaymentCustomer((CustomerInfo)mapSOCompanyInfo.get(entry.getSaleOrder()));
                priceInfo = SaleInnerDealPriceFactory.getLocalInstance((Context)this.ctx).getInnerDealPrice(entry.getSaleOrder(), entry.getSaleOrderEntry());
                if (null == this.info.getPriceSource()) {
                    this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
                }
                if (!(this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice")) || priceInfo == null || !this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO) || !this.isReFetchPrice())) {
                    entry.setSalePrice(priceInfo.getPrice().multiply(this.getExchangeRate()));
                    entry.setTaxRate(priceInfo.getTaxRate());
                    entry.setDiscountType(priceInfo.getDiscountMode());
                    entry.setDiscount(priceInfo.getDiscount());
                    entry.setTaxPrice(priceInfo.getTaxPrice().multiply(this.getExchangeRate()));
                }
                this.info.setCurrency(sourceCompanyOrgUnitInfo.getBaseCurrency());
                this.amountPrecision = this.info.getCurrency().getPrecision();
                continue;
            }
            if (entry.getOrderCustomer() == null) {
                entry.setOrderCustomer(saleOrderInfo.getOrderCustomer());
            }
            if (entry.getBalanceCustomer() == null) {
                entry.setBalanceCustomer(sourceEntryInfo.getReceiveCustomer());
            }
            if (entry.getPaymentCustomer() != null) continue;
            entry.setPaymentCustomer(sourceEntryInfo.getPaymentCustomer());
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
    }

    private void revalueForCoreBillIsTransferOerder(CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        CustomerInfo customerHead = null;
        CustomerInfo customerEntry = null;
        String[] coreBillEntryIDs = new String[this.info.getEntry().size()];
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            SaleIssueEntryInfo entry = this.info.getEntry().get(i);
            coreBillEntryIDs[i] = entry.getSaleOrderEntry();
        }
        TransferOrderBillInfo sourceInfo = TransferOrderBillFactory.getLocalInstance(this.ctx).getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSaleOrder()));
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(sourceInfo.getIssueCompanyOrgUnit().getId()));
        if (sourceInfo.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(sourceInfo.getCurrency().getId()));
            this.info.setCurrency(currency);
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
        TransferOrderBillEntryInfo sourceEntryInfo = TransferOrderBillEntryFactory.getLocalInstance(this.ctx).getTransferOrderBillEntryInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSaleOrderEntry()));
        customerHead = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(sourceEntryInfo.getReceiveCompanyOrgUnit().getId().toString(), null).get(0);
        String bizType = this.info.getBizType().getId().toString();
        if (bizType.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            bizType = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            bizType = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            bizType = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        customerEntry = "d8e80652-0117-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizType) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equalsIgnoreCase(bizType) ? customerHead : CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(sourceInfo.getIssueCompanyOrgUnit().getId().toString(), null).get(0);
        this.info.setCustomer(customerHead);
        Map priceMap = MultiSidesTransferPricesFactory.getLocalInstance(this.ctx).getPriceInfos(coreBillEntryIDs, cou.getId().toString(), "102", bizType);
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            SaleIssueEntryInfo entry = this.info.getEntry().get(i);
            if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizType)) {
                MultiSidesTransferPricesInfo priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entry.getSaleOrderEntry());
                if (null == this.info.getPriceSource()) {
                    this.info.setPriceSource(FetchPriceEnum.FROMCOREBILL);
                }
                if (!(this.info.get("doSaleChangePrice") != null && "doSaleChangePrice".equals(this.info.get("doSaleChangePrice")) || priceInfo == null || !this.info.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || priceInfo.getPrice().equals(SysConstant.BIGZERO) || priceInfo.getTaxPrice().equals(SysConstant.BIGZERO) || !this.isReFetchPrice())) {
                    entry.setSalePrice(priceInfo.getPrice());
                    entry.setTaxRate(priceInfo.getTaxRate());
                    entry.setDiscountType(priceInfo.getDiscountType());
                    entry.setDiscount(priceInfo.getDiscountRate());
                    entry.setTaxPrice(priceInfo.getTaxPrice());
                }
            }
            entry.setBalanceCustomer(customerEntry);
            entry.setPaymentCustomer(customerEntry);
            entry.setOrderCustomer(this.info.getCustomer());
        }
    }

    private void revalueInfo(StorageOrgUnitInfo sou, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        if (this.info.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
            this.info.setBillType(billType);
        }
        this.resetEntryMaterialInfo();
        this.info.setActBizDate(this.info.getBizDate());
        this.info.setFiVouchered(false);
        if (this.info.getPaymentType() == null) {
            this.info.setPaymentType(this.getDefaultAPaymentTypeInfo());
        }
        for (int i = 0; i < this.info.getEntry().size(); ++i) {
            SaleIssueEntryInfo entry = this.info.getEntry().get(i);
            if (entry.getCompanyOrgUnit() != null) continue;
            entry.setCompanyOrgUnit(cou);
        }
    }

    @Override
    protected void calByAmount(int i) {
        SaleIssueEntryInfo entry = this.info.getEntry().get(i);
        PropertyCalculator siCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)entry, fieldMap);
        this.calByAmount(i, siCalculator);
    }

    @Override
    protected void calByPrice(int i) {
        SaleIssueEntryInfo entry = this.info.getEntry().get(i);
        PropertyCalculator siCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)entry, fieldMap);
        this.calByPrice(i, siCalculator);
    }

    @Override
    protected void calByTaxAmount(int i) {
        SaleIssueEntryInfo entry = this.info.getEntry().get(i);
        PropertyCalculator siCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)entry, fieldMap);
        this.calByTaxAmount(i, siCalculator);
    }

    @Override
    protected void calByTaxPrice(int i) {
        SaleIssueEntryInfo entry = this.info.getEntry().get(i);
        PropertyCalculator siCalculator = new PropertyCalculator((SCMBillEntryBaseInfo)entry, fieldMap);
        this.calByTaxPrice(i, siCalculator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initExchange(CompanyOrgUnitInfo sourceCompanyOrgUnitInfo) throws EASBizException, BOSException {
        if (null == this.info.getCurrency() || null == this.cou.getBaseCurrency() || null == sourceCompanyOrgUnitInfo.getBaseCurrency()) {
            this.info.setExchangeRate(new BigDecimal("1.00"));
            return;
        }
        if (!this.info.getCurrency().getId().toString().equals(this.cou.getBaseCurrency().getId().toString())) {
            ExchangeRateInfo exchangeRateInfo = null;
            if (this.cou.getBaseCurrency().getId().equals((Object)sourceCompanyOrgUnitInfo.getBaseCurrency().getId())) {
                if (this.info.get("exchangeRate") != null) return;
                exchangeRateInfo = this.getExchangeRate(this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
            } else {
                exchangeRateInfo = this.getExchangeRate(this.cou, (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
            }
            if (null == exchangeRateInfo) throw new InvBizException(InvBizException.RATEINFOISNULL);
            this.info.setExchangeRate(exchangeRateInfo.getConvertRate());
            return;
        } else {
            this.info.setExchangeRate(new BigDecimal("1.00"));
        }
    }

    private SelectorItemCollection getTransferOrderSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("issueCompanyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("receiptCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.seq"));
        sic.add(new SelectorItemInfo("entry.unit.id"));
        sic.add(new SelectorItemInfo("entry.unit.name"));
        sic.add(new SelectorItemInfo("entry.unit.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("entry.issueCompanyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entry.receiveCompanyOrgUnit.id"));
        return sic;
    }

    private void reValueForVirtualBillTransfering() throws EASBizException, BOSException {
        HashMap transferOrderMap = new HashMap();
        HashMap transferOrderEntryMap = new HashMap();
        this.getCoreBillInfoMap(this.ctx, transferOrderMap, transferOrderEntryMap);
        TransferOrderBillInfo sourceInfo = (TransferOrderBillInfo)transferOrderMap.get(this.info.getEntry().get(0).getSaleOrder());
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = null;
        if (this.info.getSourceBillType() != null && "50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
            sourceCompanyOrgUnitInfo = sourceInfo.getIssueCompanyOrgUnit();
        }
        if (sourceInfo.getCurrency() != null) {
            this.info.setCurrency(sourceInfo.getCurrency());
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        CustomerInfo customerHead = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(sourceInfo.getReceiptCompanyOrgUnit().getId().toString(), null).get(0);
        boolean is4Sides = false;
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString()) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equalsIgnoreCase(this.info.getBizType().getId().toString())) {
            is4Sides = true;
        }
        SaleIssueEntryCollection saleIssueEntryCol = this.info.getEntry();
        CustomerInfo customer = null;
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        HashSet<String> transEntryIDSet = new HashSet<String>();
        transEntryIDSet.add(this.info.getEntry().get(0).getSaleOrder());
        ITransferOrderBill iTransferOrder = TransferOrderBillFactory.getLocalInstance(this.ctx);
        TransferOrderBillEntryCollection transferOrderEntryCol = sourceInfo.getEntry();
        int size = saleIssueEntryCol.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal conversionRate;
            SaleIssueEntryInfo entryInfo;
            TransferOrderBillEntryInfo transferOrderEntryInfo;
            if (!transEntryIDSet.contains(this.info.getEntry().get(i).getSaleOrder())) {
                String curtransEntryID = this.info.getEntry().get(i).getSaleOrder();
                transEntryIDSet.add(curtransEntryID);
                sourceInfo = iTransferOrder.getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(i).getSaleOrder()), this.getTransferOrderSelector());
                transferOrderEntryCol = sourceInfo.getEntry();
            }
            if ((transferOrderEntryInfo = (TransferOrderBillEntryInfo)transferOrderEntryMap.get((entryInfo = saleIssueEntryCol.get(i)).getSaleOrderEntry())) == null) continue;
            if (!is4Sides) {
                entryInfo.setBalanceCustomer(this.info.getCustomer());
                entryInfo.setPaymentCustomer(this.info.getCustomer());
                entryInfo.setOrderCustomer(this.info.getCustomer());
            } else {
                if (transferOrderEntryInfo.getReceiveCompanyOrgUnit() != null) {
                    if (!customerMap.containsKey(transferOrderEntryInfo.getReceiveCompanyOrgUnit().getId().toString())) {
                        customer = CustomerFactory.getLocalInstance((Context)this.ctx).getInterCustomerCollection(transferOrderEntryInfo.getReceiveCompanyOrgUnit().getId().toString(), null).get(0);
                        customerMap.put(transferOrderEntryInfo.getReceiveCompanyOrgUnit().getId().toString(), customer);
                    } else {
                        customer = (CustomerInfo)customerMap.get(transferOrderEntryInfo.getReceiveCompanyOrgUnit().getId().toString());
                    }
                }
                this.info.setCustomer(customer);
                if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) {
                    entryInfo.setPaymentCustomer(customerHead);
                    entryInfo.setBalanceCustomer(customerHead);
                } else {
                    entryInfo.setPaymentCustomer(customer);
                    entryInfo.setBalanceCustomer(customer);
                }
                entryInfo.setOrderCustomer(customer);
            }
            if (sourceCompanyOrgUnitInfo == null) {
                sourceCompanyOrgUnitInfo = transferOrderEntryInfo.getIssueCompanyOrgUnit();
            }
            if (is4Sides && this.info.getSourceBillType() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(this.info.getSourceBillType().getId().toString())) continue;
            MeasureUnitInfo entryUnit = entryInfo.getUnit();
            MeasureUnitInfo orderUnit = transferOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
    }

    private void reValueForVirtualBillSaleBack() throws BOSException, EASBizException {
        HashMap saleReturnsMap = new HashMap();
        HashMap saleReturnsEntryMap = new HashMap();
        this.getCoreBillInfoMap(this.ctx, saleReturnsMap, saleReturnsEntryMap);
        SaleIssueEntryCollection saleIssueEntryCol = this.info.getEntry();
        int size = saleIssueEntryCol.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal conversionRate;
            SaleIssueEntryInfo entryInfo = saleIssueEntryCol.get(i);
            SaleReturnsEntryInfo saleReturnsEntryInfo = (SaleReturnsEntryInfo)saleReturnsEntryMap.get(entryInfo.getSaleOrderEntry());
            if (saleReturnsEntryInfo == null) continue;
            MeasureUnitInfo entryUnit = entryInfo.getUnit();
            MeasureUnitInfo orderUnit = saleReturnsEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
    }

    private void reValueForVirtualBillIssuing() throws EASBizException, BOSException {
        this.saleOrderMap = new HashMap<String, SaleOrderInfo>();
        this.saleOrderEntryMap = new HashMap<String, SaleOrderEntryInfo>();
        this.getCoreBillInfoMap(this.ctx, this.saleOrderMap, this.saleOrderEntryMap);
        SaleOrderInfo saleOrderInfo = this.saleOrderMap.get(this.info.getEntry().get(0).getSaleOrder());
        CompanyOrgUnitInfo sourceCompanyOrgUnitInfo = saleOrderInfo.getCompanyOrgUnit();
        if (saleOrderInfo.getCurrency() != null) {
            this.info.setCurrency(saleOrderInfo.getCurrency());
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        this.initExchange(sourceCompanyOrgUnitInfo);
        SaleIssueEntryCollection saleIssueEntryCol = this.info.getEntry();
        SaleIssueEntryInfo entryInfo = null;
        SaleOrderEntryInfo saleOrderEntryInfo = null;
        MeasureUnitInfo entryUnit = null;
        MeasureUnitInfo orderUnit = null;
        int size = this.info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            BigDecimal conversionRate;
            entryInfo = saleIssueEntryCol.get(i);
            saleOrderEntryInfo = this.saleOrderEntryMap.get(entryInfo.getSaleOrderEntry());
            if (saleOrderEntryInfo == null) continue;
            entryUnit = entryInfo.getUnit();
            orderUnit = saleOrderEntryInfo.getUnit();
            if (entryUnit == null || orderUnit == null || entryUnit.getId().toString().equals(orderUnit.getId().toString()) || (conversionRate = this.getConversionRate(entryInfo.getMaterial(), orderUnit, entryUnit)) == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) continue;
            if (this.info.isIsInTax()) {
                BigDecimal taxPrice = entryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : entryInfo.getTaxPrice();
                taxPrice = taxPrice.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
                entryInfo.setTaxPrice(taxPrice);
                continue;
            }
            BigDecimal price = entryInfo.getPrice() == null ? SysConstant.BIGZERO : entryInfo.getPrice();
            price = price.divide(conversionRate, entryInfo.getMaterial().getPricePrecision(), 4);
            entryInfo.setPrice(price);
        }
    }

    private BigDecimal getConversionRate(MaterialInfo materialInfo, MeasureUnitInfo fromUnit, MeasureUnitInfo toUnit) throws EASBizException, BOSException {
        if (materialInfo == null || fromUnit == null || toUnit == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
        String[] materialIds = new String[]{materialInfo.getId().toString(), materialInfo.getId().toString()};
        String[] unitIds = new String[]{fromUnit.getId().toString(), toUnit.getId().toString()};
        Map conversionRateMap = iMultiMeasureUnit.getConvRatesByMaterial(materialIds, unitIds);
        BigDecimal fromBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + fromUnit.getId().toString());
        BigDecimal toBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + toUnit.getId().toString());
        if (fromBaseConv == null || toBaseConv == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        return fromBaseConv.divide(toBaseConv, 16, 4);
    }

    @Override
    protected int getDiscountRatePrecision(int i) {
        return -1;
    }

    private void getCoreBillInfoMap(Context ctx, Map coreBillMap, Map coreBillEntryMap) throws BOSException {
        String coreBillTypeId = this.info.getEntry().get(0).getCoreBillTypeId();
        if (coreBillTypeId == null) {
            return;
        }
        HashSet<String> saleOrderID = new HashSet<String>();
        SaleIssueEntryInfo saleIssueEntryInfo = null;
        int size = this.info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            saleIssueEntryInfo = this.info.getEntry().get(i);
            if (saleIssueEntryInfo == null || StringUtil.isEmpty((String)saleIssueEntryInfo.getSaleOrder())) continue;
            saleOrderID.add(saleIssueEntryInfo.getSaleOrder());
        }
        if (saleOrderID.size() == 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", saleOrderID, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(coreBillTypeId)) {
            view.setSelector(this.perpareSelectorForSaleOrder());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)SaleOrderFactory.getLocalInstance((Context)ctx), view, "entries");
        } else if ("50957179-0105-1000-e008-8152c0a812fd463ED552".equals(coreBillTypeId)) {
            view.setSelector(this.getSelectorItemCollection());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)SaleReturnsFactory.getLocalInstance((Context)ctx), view, "entries");
        } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(coreBillTypeId)) {
            view.setSelector(this.getPurOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, (ISCMBillBase)PurOrderFactory.getLocalInstance((Context)ctx), view, "entries");
        } else if ("Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(coreBillTypeId)) {
            view.setSelector(this.getTransferOrderSelector());
            this.getCoreBillInfoMap(ctx, coreBillMap, coreBillEntryMap, TransferOrderBillFactory.getLocalInstance(ctx), view, "entry");
        }
    }

    private void getCoreBillInfoMap(Context ctx, Map coreBillMap, Map coreBillEntryMap, ISCMBillBase bizInterface, EntityViewInfo viewInfo, String entryKey) throws BOSException {
        CoreBaseCollection billCol = bizInterface.getCollection(viewInfo);
        IObjectCollection entryCol = null;
        IObjectValue billInfo = null;
        IObjectValue billEntryInfo = null;
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            billInfo = billCol.getObject(i);
            if (billInfo == null || billInfo.get("id") == null) continue;
            coreBillMap.put(billInfo.get("id").toString(), billInfo);
            entryCol = (IObjectCollection)billInfo.get(entryKey);
            int eSize = entryCol.size();
            for (int j = 0; j < eSize; ++j) {
                billEntryInfo = entryCol.getObject(j);
                if (billEntryInfo == null || billEntryInfo.get("id") == null) continue;
                coreBillEntryMap.put(billEntryInfo.get("id").toString(), billEntryInfo);
            }
        }
    }

    @Override
    protected void calByUnitSource(Context ctx, InvBillBaseInfo invBillBaseInfo, InvBillBaseEntryInfo invBillBaseEntryInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, invBillBaseInfo, invBillBaseEntryInfo);
        SaleIssueEntryInfo saleIssueEntryInfo = (SaleIssueEntryInfo)invBillBaseEntryInfo;
        String sourceBillEntryId = saleIssueEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = saleIssueEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = saleIssueEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)saleIssueEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)saleIssueEntryInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)saleIssueEntryInfo.getQty(), (SCMBillEntryBaseInfo)saleIssueEntryInfo, (String)sourceUnitId);
        saleIssueEntryInfo.setQty(qty);
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)invBillBaseInfo;
        BigDecimal price = null;
        if (saleIssueBillInfo.isIsInTax()) {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleIssueEntryInfo.getTaxPrice(), (SCMBillEntryBaseInfo)saleIssueEntryInfo, (String)sourceUnitId);
            saleIssueEntryInfo.setTaxPrice(price);
        } else {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)saleIssueEntryInfo.getPrice(), (SCMBillEntryBaseInfo)saleIssueEntryInfo, (String)sourceUnitId);
            saleIssueEntryInfo.setPrice(price);
        }
    }

    private Map<String, PurInnerDealPriceInfo> mapInnerDealPrice(PurInnerDealPriceCollection coll) {
        if (coll != null && coll.size() > 0) {
            PurInnerDealPriceInfo priceInfo = null;
            HashMap<String, PurInnerDealPriceInfo> map = new HashMap<String, PurInnerDealPriceInfo>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                priceInfo = coll.get(i);
                map.put(priceInfo.getPurOrderEntry().getId().toString(), priceInfo);
            }
            return map;
        }
        return null;
    }

    static {
        fieldMap.put("price", "salePrice");
        fieldMap.put("actualTaxPrice", "price");
        fieldMap.put("amount", "nonTaxAmount");
        fieldMap.put("localAmount", "localNonTaxAmount");
        fieldMap.put("taxAmount", "amount");
        fieldMap.put("localTaxAmount", "localAmount");
    }
}

