/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.ISCMBillParamValue;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamCollection;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMBillParamValueCollection;
import com.kingdee.eas.scm.common.SCMBillParamValueFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.framework.bizflow.BizFlowFacadeFactory;
import com.kingdee.eas.scm.im.inv.AbstractSaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillAgent;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueChangePriceVO;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryAgent;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillEntryRelationInfo;
import com.kingdee.eas.scm.im.inv.SplitBillForBIM;
import com.kingdee.eas.scm.im.inv.SplitBillInventoryLog;
import com.kingdee.eas.scm.im.inv.SplitBillRelationInfo;
import com.kingdee.eas.scm.im.inv.SplitBillTotalAmount;
import com.kingdee.eas.scm.im.inv.app.AbstractSaleIssueBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.AutoSaleIssueProcessor;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.reservation.ReservationCollection;
import com.kingdee.eas.scm.im.reservation.ReservationFactory;
import com.kingdee.eas.scm.im.reservation.service.BillReservationCancelService;
import com.kingdee.eas.scm.sd.sale.ConsignSaleBillEntryInfo;
import com.kingdee.eas.scm.sd.sale.ConsignSaleException;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SaleIssueBillControllerBean
extends AbstractSaleIssueBillControllerBean {
    private static final long serialVersionUID = 1333223333332L;
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.SaleIssueBillControllerBean");
    private boolean isActBill = true;
    private String vritualSaleIssueRelationId = null;
    private String vritualPurInWarehsRelationId = null;
    private String vritualSaleIssueId = null;
    private String vritualPurInWarehsId = null;
    private static final String msgNotAudit_key = "com.kingdee.eas.scm.im.inv.InvAddResource.BillNotAudit";
    private static final String msgEntry_key = "com.kingdee.eas.scm.im.inv.InvAddResource.Entry";
    private static final String msgWrittenOffQty_key = "com.kingdee.eas.scm.im.inv.InvAddResource.NotWritenoff";
    private static final String msgUnWrittenOffQty_key = "com.kingdee.eas.scm.im.inv.InvAddResource.UnWrittenOffQty";
    private static final String msgHasNextBill_key = "com.kingdee.eas.scm.im.inv.InvAddResource.HasNextBill";
    private static final String msgHasMSN_key = "com.kingdee.eas.scm.im.inv.InvAddResource.HasMSN";
    private static final String TABLENAME = "T_IM_SaleIssueBill";

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (null != ctx.get((Object)"SPLIT_ACTION") && ctx.get((Object)"SPLIT_ACTION") instanceof Boolean && ((Boolean)ctx.get((Object)"SPLIT_ACTION")).booleanValue()) {
            super._update(ctx, pk, model);
            return;
        }
        SaleIssueBillInfo actual = (SaleIssueBillInfo)this._getValue(ctx, pk);
        if (actual != null && actual.getBaseStatus() != null && BillBaseStatusEnum.AUDITED.equals((Object)actual.getBaseStatus()) && model.get("$BillQuery") == null) {
            return;
        }
        super._update(ctx, pk, model);
    }

    public void dealBillCost(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        SaleIssueEntryInfo entry = null;
        SaleIssueEntryCollection entries = info.getEntry();
        int amtPrecision = 2;
        BigDecimal totalActualCost = new BigDecimal("0.00");
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.FReverseQty as reverseQty");
        bf.append(" ,entry.freverseBaseQty as reverseBaseQty");
        bf.append(" ,entry.fbaseQty as baseQty");
        bf.append(" ,entry.fqty as qty");
        bf.append(" ,entry.funitActualCost as unitActualCost");
        bf.append(" ,entry.factualCost as actualCost");
        bf.append(" ,entry.fwrittenOffQty as writtenOffQty ");
        bf.append(" ,entry.funWriteOffQty as unWriteOffQty");
        bf.append(" ,entry.fwrittenOffAmount as writtenOffAmount");
        bf.append(" ,entry.funWriteOffAmount as unWriteOffAmount");
        bf.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf.append(" from T_IM_SaleIssueBill bill");
        bf.append(" inner join T_IM_SaleIssueEntry entry");
        bf.append(" on bill.fid=entry.fparentid");
        bf.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf.append(" where entry.fid=?");
        String sql = bf.toString();
        IRowSet rs = null;
        String entryID = "";
        try {
            int length = entries.size();
            for (int i = 0; i < length; ++i) {
                entry = entries.get(i);
                entryID = entry.getId().toString();
                BigDecimal actualCost = null != entry.getActualCost() ? entry.getActualCost() : new BigDecimal("0.00");
                BigDecimal unitActualCost = null != entry.getUnitActualCost() ? entry.getUnitActualCost() : new BigDecimal("0.00");
                entry.setActualCost(actualCost);
                entry.setUnitActualCost(unitActualCost);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{entryID});
                if (rs.next()) {
                    amtPrecision = rs.getInt("fprecision");
                    BigDecimal writtenOffQty = rs.getBigDecimal("writtenOffQty");
                    BigDecimal reverseQty = rs.getBigDecimal("reverseQty");
                    BigDecimal writtenOffAmount = writtenOffQty.compareTo(rs.getBigDecimal("qty")) == 0 ? actualCost : writtenOffQty.multiply(unitActualCost).setScale(amtPrecision, 4);
                    BigDecimal unWriteOffAmount = actualCost.subtract(writtenOffAmount);
                    entry.setReverseQty(reverseQty);
                    entry.setWrittenOffQty(writtenOffQty);
                    entry.setUnWriteOffQty(rs.getBigDecimal("unWriteOffQty"));
                    entry.setWrittenOffAmount(writtenOffAmount);
                    entry.setUnWriteOffAmount(unWriteOffAmount);
                    entry.setReverseBaseQty(rs.getBigDecimal("reverseBaseQty"));
                }
                totalActualCost = totalActualCost.add(actualCost);
            }
            info.setTotalActualCost(totalActualCost);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    @Override
    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue mode) throws BOSException, EASBizException {
        super._generateVoucher(ctx, mode);
    }

    @Override
    protected boolean isCheckSourceBill() {
        return true;
    }

    @Override
    protected void _checkIsHaveDestBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        SaleIssueBillInfo aSaleIssueBillInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
        if (aSaleIssueBillInfo.isIsSysBill()) {
            throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
        }
        AutoSaleIssueProcessor.getInstance().autoDelete(ctx, aInvBillBaseInfo);
        this._checkDestIncVisualBills(ctx, aInvBillBaseInfo);
    }

    @Override
    protected void afterUnPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.UNAUDIT);
        super.afterUnPassAudit(ctx, pk, aInvBillBaseInfo);
    }

    @Override
    protected void afterPassAudit(Context ctx, IObjectPK pk, InvBillBaseInfo billInfo) throws EASBizException, BOSException {
        super.afterPassAudit(ctx, pk, billInfo);
        this.updateUnSettleQty(ctx, (IObjectValue)billInfo);
    }

    private void updateUnSettleQty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        boolean isConsReturn = this.isConsReturnsSaleIssueBill(ctx, (SaleIssueBillInfo)model);
        if (info.getSourceBillType() == null && isConsReturn) {
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_IM_SaleIssueEntry SET FUnSettleQty = fqty, FUnSettleBaseQty = FBaseQty ");
            sql.append(" WHERE FParentID = '").append(info.getId().toString()).append("' ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private boolean isConsReturnsSaleIssueBill(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isConsReturn = false;
        TransactionTypeInfo transTypeInfo = invBillBaseInfo.getTransactionType();
        if (transTypeInfo != null && transTypeInfo.getRiType() != null) {
            String riTypeID = transTypeInfo.getRiType().getId().toString();
            return RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeID);
        }
        return isConsReturn;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("baseStatus"));
        SaleIssueBillInfo aSaleIssueBillInfo = this.getSaleIssueBillInfo(ctx, pk, sc);
        if (aSaleIssueBillInfo.getBaseStatus() == BillBaseStatusEnum.SUBMITED || aSaleIssueBillInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, CreditOperationEnum.DELETE);
        }
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < arrayPK.length; ++i) {
            set.add(arrayPK[i]);
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("fiVouchered"));
        entityView.setFilter(filter);
        SaleIssueBillCollection saleIssueBillCollection = this.getSaleIssueBillCollection(ctx, entityView);
        if (saleIssueBillCollection != null) {
            for (int i = 0; i < saleIssueBillCollection.size(); ++i) {
                SaleIssueBillInfo saleIssueInfo = saleIssueBillCollection.get(i);
                if (saleIssueInfo.isFiVouchered()) {
                    throw new ConsignSaleException(ConsignSaleException.SALEISSUE_BILL_HAS_VOUCHERED);
                }
                this.isCanDelete(ctx, arrayPK[i], (CoreBillBaseInfo)saleIssueInfo);
            }
        }
        super._delete(ctx, arrayPK);
    }

    @Override
    protected HashMap _splitBillByWrittenOffQty(Context ctx, String[] idList, HashMap param) throws BOSException, EASBizException {
        HashMap<String, String> msgHm = new HashMap<String, String>(0);
        StringBuffer notSplitMsg = new StringBuffer();
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idList.length; ++i) {
            idSet.add(idList[i]);
        }
        EntityViewInfo saleView = new EntityViewInfo();
        FilterInfo saleFilter = new FilterInfo();
        saleFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        saleView.setFilter(saleFilter);
        saleView.getSelector().add(new SelectorItemInfo("id"));
        saleView.getSelector().add(new SelectorItemInfo("number"));
        SaleIssueBillCollection coll = this.getSaleIssueBillCollection(ctx, saleView);
        for (int i = 0; i < coll.size(); ++i) {
            SaleIssueBillInfo billInfo = coll.get(i);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"48DA3A71", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"FC910EF3", CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)"2652E01E", CompareType.NOTEQUALS));
            filter.setMaskString("#0 and (#1 and #2 and #3)");
            view.setFilter(filter);
            view.getSelector().add("id");
            view.getSelector().add("srcObjectID");
            view.getSelector().add("destObjectID");
            view.getSelector().add("srcEntityID");
            view.getSelector().add("destEntityID");
            BOTRelationCollection bOTRelationCollection = ibotRelation.getCollection(view);
            if (bOTRelationCollection != null && bOTRelationCollection.size() > 0) {
                InvBillBaseInfo info;
                int j;
                LinkedHashSet<String> set = new LinkedHashSet<String>();
                for (int j2 = 0; j2 < bOTRelationCollection.size(); ++j2) {
                    set.add(bOTRelationCollection.get(j2).getDestObjectID());
                }
                view = new EntityViewInfo();
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("isSysBill", (Object)1, CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
                view.setFilter(filter);
                view.getSelector().add("id");
                SaleIssueBillCollection billCollSale = this.getSaleIssueBillCollection(ctx, view);
                PurInWarehsBillCollection billCollPur = iPurInWarehsBill.getPurInWarehsBillCollection(view);
                if (billCollSale.size() + billCollPur.size() + this.getBackBillsSize(set, ctx) < bOTRelationCollection.size()) {
                    notSplitMsg.append("[");
                    notSplitMsg.append(billInfo.getNumber());
                    notSplitMsg.append("]\t ");
                    notSplitMsg.append(this.getResourceString(ctx, msgHasNextBill_key));
                    notSplitMsg.append("\t\n ");
                    continue;
                }
                StringBuffer checkSql = new StringBuffer();
                checkSql.append("select 1 from T_IM_SaleIssueEntry mother ");
                checkSql.append("inner join T_IM_SaleIssueEntry childSale on mother.fid = childSale.fsourcebillentryid ");
                checkSql.append("inner join T_IM_PurInwarehsEntry childPur on mother.fid = childPur.fsourcebillentryid ");
                checkSql.append("where (mother.funwriteoffqty <> childSale.funwriteoffqty ");
                checkSql.append("or mother.funwriteoffqty <> childPur.funwriteoffqty ");
                checkSql.append("or childPur.funwriteoffqty <> childSale.funwriteoffqty) ");
                for (j = 0; j < billCollSale.size(); ++j) {
                    info = billCollSale.get(j);
                    checkSql.append(" and childSale.fparentid = '" + info.getId().toString() + "' ");
                }
                for (j = 0; j < billCollPur.size(); ++j) {
                    info = billCollPur.get(j);
                    checkSql.append(" and childPur.fparentid = '" + info.getId().toString() + "' ");
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                boolean isDifferent = false;
                try {
                    isDifferent = rs.next();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (!isDifferent) {
                    InvBillBaseInfo info2;
                    int j3;
                    for (j3 = 0; j3 < billCollSale.size(); ++j3) {
                        info2 = billCollSale.get(j3);
                        this.isActBill = false;
                        String tempError = this.splitBillByWrittenOFFQty(ctx, new String[]{info2.getId().toString()}, param);
                        if (tempError == null) continue;
                        notSplitMsg.append(tempError);
                    }
                    for (j3 = 0; j3 < billCollPur.size(); ++j3) {
                        HashMap msgMap;
                        String tempError;
                        info2 = billCollPur.get(j3);
                        if (param != null) {
                            param.put("isFromSaleIssue", Boolean.TRUE);
                        }
                        if ((tempError = (String)(msgMap = iPurInWarehsBill.splitBillByWrittenOffQty(new String[]{info2.getId().toString()}, param)).get("NotSplitMsg")) != null) {
                            notSplitMsg.append(tempError);
                        }
                        this.vritualPurInWarehsRelationId = (String)msgMap.get("vritualPurInWarehsRelationId");
                        this.vritualPurInWarehsId = (String)msgMap.get("vritualPurInWarehsId");
                    }
                }
            }
            this.isActBill = true;
            String tempError = this.splitBillByWrittenOFFQty(ctx, new String[]{billInfo.getId().toString()}, param);
            if (tempError != null) {
                notSplitMsg.append(tempError);
            }
            StringBuffer updateRelationSql = new StringBuffer();
            updateRelationSql.append("update T_BOT_RELATION set (FSRCOBJECTID) = ");
            updateRelationSql.append("(select split.FCHILDBILLID from T_BOT_RELATION bot ");
            updateRelationSql.append("inner join T_IM_SPLITBILLRELATION split on bot.FSRCOBJECTID = split.FMOTHERBILLID ");
            updateRelationSql.append("where T_BOT_RELATION.FID = bot.FID ");
            updateRelationSql.append("and T_BOT_RELATION.FID = ?) ");
            StringBuffer updateSaleIssueEntrySql = new StringBuffer();
            updateSaleIssueEntrySql.append("update T_IM_SALEISSUEENTRY set (FSOURCEBILLID, FSOURCEBILLNUMBER, FSOURCEBILLENTRYID) = ");
            updateSaleIssueEntrySql.append("(select split.FCHILDBILLID, split.FCHILDBILLNUMBER, splitEntry.FCHILDBILLENTRYID from T_IM_SALEISSUEBILL head ");
            updateSaleIssueEntrySql.append("inner join T_IM_SALEISSUEENTRY entry on head.FID = entry.FPARENTID ");
            updateSaleIssueEntrySql.append("inner join T_IM_SPLITBILLRELATION split on entry.FSOURCEBILLID = split.FMOTHERBILLID ");
            updateSaleIssueEntrySql.append("inner join T_IM_SPLITBILLENTRYRELATION splitEntry on entry.FSOURCEBILLENTRYID = splitEntry.FMOTHERBILLENTRYID ");
            updateSaleIssueEntrySql.append("where T_IM_SALEISSUEENTRY.FID = entry.FID ");
            updateSaleIssueEntrySql.append("and head.FID = ?) ");
            StringBuffer updatePurInWarehsEntrySql = new StringBuffer();
            updatePurInWarehsEntrySql.append("update T_IM_PURINWAREHSENTRY set (FSOURCEBILLID, FSOURCEBILLNUMBER, FSOURCEBILLENTRYID) = ");
            updatePurInWarehsEntrySql.append("(select split.FCHILDBILLID, split.FCHILDBILLNUMBER, splitEntry.FCHILDBILLENTRYID from T_IM_PURINWAREHSBILL head ");
            updatePurInWarehsEntrySql.append("inner join T_IM_PURINWAREHSENTRY entry on head.FID = entry.FPARENTID ");
            updatePurInWarehsEntrySql.append("inner join T_IM_SPLITBILLRELATION split on entry.FSOURCEBILLID = split.FMOTHERBILLID ");
            updatePurInWarehsEntrySql.append("inner join T_IM_SPLITBILLENTRYRELATION splitEntry on entry.FSOURCEBILLENTRYID = splitEntry.FMOTHERBILLENTRYID ");
            updatePurInWarehsEntrySql.append("where T_IM_PURINWAREHSENTRY.FID = entry.FID ");
            updatePurInWarehsEntrySql.append("and head.FID = ?) ");
            if (this.vritualSaleIssueRelationId != null && this.vritualPurInWarehsRelationId != null) {
                DbUtil.execute((Context)ctx, (String)updateRelationSql.toString(), (Object[])new Object[]{this.vritualSaleIssueRelationId});
                DbUtil.execute((Context)ctx, (String)updateRelationSql.toString(), (Object[])new Object[]{this.vritualPurInWarehsRelationId});
            }
            if (this.vritualSaleIssueId == null || this.vritualPurInWarehsId == null) continue;
            DbUtil.execute((Context)ctx, (String)updateSaleIssueEntrySql.toString(), (Object[])new Object[]{this.vritualSaleIssueId});
            DbUtil.execute((Context)ctx, (String)updatePurInWarehsEntrySql.toString(), (Object[])new Object[]{this.vritualPurInWarehsId});
        }
        if (notSplitMsg != null && notSplitMsg.length() > 0) {
            msgHm.put("NotSplitMsg", notSplitMsg.toString());
            throw new InvBizException(InvBizException.SPLITBILL_ERROR, new Object[]{notSplitMsg.toString()});
        }
        return msgHm;
    }

    private String splitBillByWrittenOFFQty(Context ctx, String[] idList, HashMap param) throws BOSException, EASBizException {
        SelectorItemCollection sic = null;
        Date now = new Date();
        int precision = 2;
        BigDecimal ZERO = new BigDecimal("0.00");
        StringBuffer notSplitMsg = new StringBuffer();
        IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
        Date splitDate = null;
        if (param.get("SplitDate") != null) {
            splitDate = (Date)param.get("SplitDate");
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(this.getSelector());
        ev.getSelector().add(new SelectorItemInfo("currency.precision"));
        ev.getSelector().add(new SelectorItemInfo("entry.companyOrgUnit.baseCurrency.precision"));
        FilterInfo filter = new FilterInfo();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < idList.length; ++i) {
            set.add(idList[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        SaleIssueBillCollection coll = this.getSaleIssueBillCollection(ctx, ev);
        int entrySize = 0;
        String motherBillID = "";
        String childBillID = "";
        String motherNumber = "";
        String childNumber = "";
        String motherBillEntryID = "";
        String childBillEntryID = "";
        Vector<SplitBillRelationInfo> vecSBRelation = new Vector<SplitBillRelationInfo>(0);
        Vector<SplitBillEntryRelationInfo> vecSBEntryRelation = new Vector<SplitBillEntryRelationInfo>(0);
        HashMap hsSB = new HashMap(0);
        HashMap<String, String> childMap = new HashMap<String, String>();
        Vector<SplitBillEntryRelationInfo> vecSBEntryByOneSB = new Vector<SplitBillEntryRelationInfo>(0);
        Vector<SplitBillInventoryLog> vecInvLog = new Vector<SplitBillInventoryLog>(0);
        for (int i = 0; i < coll.size(); ++i) {
            SaleIssueBillInfo aSaleIssueBillInfo = coll.get(i);
            motherBillID = aSaleIssueBillInfo.getId().toString();
            motherNumber = aSaleIssueBillInfo.getNumber();
            SplitBillTotalAmount motherSplitBillTotalAmount = new SplitBillTotalAmount();
            SplitBillTotalAmount childSplitBillTotalAmount = new SplitBillTotalAmount();
            precision = 2;
            vecSBEntryByOneSB.clear();
            if (aSaleIssueBillInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
                notSplitMsg.append("[").append(motherNumber).append("]\t ");
                notSplitMsg.append(this.getResourceString(ctx, msgNotAudit_key)).append("\t\n ");
                continue;
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)motherBillID));
            filter.setMaskString("");
            if (iMaterialSerialNumber.exists(filter)) {
                notSplitMsg.append("[").append(motherNumber).append("]\t ");
                notSplitMsg.append(this.getResourceString(ctx, msgHasMSN_key)).append("\t\n ");
                continue;
            }
            SaleIssueBillInfo aSplitBillInfo = (SaleIssueBillInfo)aSaleIssueBillInfo.clone();
            aSplitBillInfo.setId(BOSUuid.create((BOSObjectType)aSplitBillInfo.getBOSType()));
            childBillID = aSplitBillInfo.getId().toString();
            childNumber = this.getChileNumber(ctx, aSaleIssueBillInfo.getNumber(), 0);
            aSplitBillInfo.setNumber(childNumber);
            String billID = aSaleIssueBillInfo.getId().toString();
            AbstractSaleIssueBillInfo fSplitBillInfo = null;
            if (billID != null && billID.length() > 0) {
                StringBuffer childsql = new StringBuffer();
                childsql.append("select FMotherBillId, FChildBillID from T_IM_SPLITBILLRELATION");
                childsql.append(" where FChildBillID = ? ");
                IRowSet childrs = DbUtil.executeQuery((Context)ctx, (String)childsql.toString(), (Object[])new Object[]{billID.toString()});
                String motherID = null;
                try {
                    if (childrs.next()) {
                        motherID = childrs.getString(1);
                        boolean ishaveMotherID = true;
                        while (ishaveMotherID) {
                            StringBuffer sql = new StringBuffer();
                            sql.append("select FMotherBillId, FChildBillID from T_IM_SPLITBILLRELATION");
                            sql.append(" where FChildBillID = ? ");
                            IRowSet motherrs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{motherID});
                            try {
                                if (motherrs.next()) {
                                    ishaveMotherID = true;
                                    motherID = motherrs.getString(1);
                                    continue;
                                }
                                ishaveMotherID = false;
                            }
                            catch (SQLException e) {
                                throw new BOSException((Throwable)e);
                            }
                        }
                    } else {
                        motherID = billID.toString();
                    }
                }
                catch (SQLException e1) {
                    throw new BOSException((Throwable)e1);
                }
                ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
                ObjectUuidPK saleIssueBillPK = new ObjectUuidPK(motherID);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("actBizDate"));
                fSplitBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)saleIssueBillPK, sic);
            }
            if (splitDate != null) {
                if (null != fSplitBillInfo) {
                    aSplitBillInfo.setActBizDate(fSplitBillInfo.getActBizDate());
                }
                aSplitBillInfo.setBizDate(splitDate);
                int[] period = this.convertBizPeriod(ctx, (IObjectValue)aSplitBillInfo);
                aSplitBillInfo.setYear(period[0]);
                aSplitBillInfo.setPeriod(period[1]);
            }
            aSplitBillInfo.getEntry().clear();
            if (aSaleIssueBillInfo.getCurrency() != null) {
                precision = aSaleIssueBillInfo.getCurrency().getPrecision();
            }
            SaleIssueEntryCollection entryColl = aSaleIssueBillInfo.getEntry();
            entrySize = entryColl.size();
            boolean isEntryWrite = false;
            boolean isEntryUnWrite = false;
            boolean isEntryPartWrite = false;
            StringBuffer splitWriteMsg = new StringBuffer();
            for (int j = 0; j < entrySize; ++j) {
                SaleIssueEntryInfo aSaleIssueEntryInfo = entryColl.get(j);
                motherBillEntryID = aSaleIssueEntryInfo.getId().toString();
                if (aSaleIssueEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(this.getResourceString(ctx, msgEntry_key));
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(this.getResourceString(ctx, msgWrittenOffQty_key));
                    splitWriteMsg.append("\t\n ");
                    isEntryUnWrite = true;
                    continue;
                }
                if (aSaleIssueEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(motherNumber);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(this.getResourceString(ctx, msgEntry_key));
                    splitWriteMsg.append("[");
                    splitWriteMsg.append(j + 1);
                    splitWriteMsg.append("]\t ");
                    splitWriteMsg.append(this.getResourceString(ctx, msgUnWrittenOffQty_key));
                    splitWriteMsg.append("\t\n ");
                    isEntryWrite = true;
                    continue;
                }
                isEntryPartWrite = true;
            }
            if (isEntryWrite && !isEntryUnWrite && !isEntryPartWrite) {
                notSplitMsg.append(splitWriteMsg);
                continue;
            }
            ObjectUuidPK pk = new ObjectUuidPK(aSaleIssueBillInfo.getId());
            if (isEntryUnWrite && !isEntryWrite && !isEntryPartWrite) {
                if (fSplitBillInfo != null) {
                    aSaleIssueBillInfo.setActBizDate(fSplitBillInfo.getActBizDate());
                }
                if (splitDate != null) {
                    aSaleIssueBillInfo.setBizDate(splitDate);
                }
                aSaleIssueBillInfo.setYear(aSplitBillInfo.getYear());
                aSaleIssueBillInfo.setPeriod(aSplitBillInfo.getPeriod());
                aSaleIssueBillInfo.setNumber(aSaleIssueBillInfo.getNumber().toString() + "_A");
                this._update(ctx, (IObjectPK)pk, (IObjectValue)aSaleIssueBillInfo);
                continue;
            }
            if (fSplitBillInfo != null) {
                aSaleIssueBillInfo.setActBizDate(fSplitBillInfo.getActBizDate());
            }
            this._update(ctx, (IObjectPK)pk, (IObjectValue)aSaleIssueBillInfo);
            Vector<SaleIssueEntryInfo> vMatherBillEntry = new Vector<SaleIssueEntryInfo>(0);
            Vector<SplitBillEntryRelationInfo> vNotSplitEntry = new Vector<SplitBillEntryRelationInfo>(0);
            SaleIssueAlgorithmForInfo motherAlgorithm = new SaleIssueAlgorithmForInfo(aSaleIssueBillInfo, ctx);
            SaleIssueAlgorithmForInfo childAlgorithm = new SaleIssueAlgorithmForInfo(aSplitBillInfo, ctx);
            for (int j = 0; j < entrySize; ++j) {
                SaleIssueEntryInfo aChildEntryInfo;
                SaleIssueEntryInfo aSaleIssueEntryInfo = entryColl.get(j);
                motherBillEntryID = aSaleIssueEntryInfo.getId().toString();
                if (aSaleIssueEntryInfo.getWrittenOffQty().compareTo(ZERO) == 0) {
                    aChildEntryInfo = (SaleIssueEntryInfo)aSaleIssueEntryInfo.clone();
                    aChildEntryInfo.setId(BOSUuid.create((BOSObjectType)aChildEntryInfo.getBOSType()));
                    childBillEntryID = aChildEntryInfo.getId().toString();
                    this.resetCoreBillInfo(aSplitBillInfo, aChildEntryInfo, aSplitBillInfo.getEntry().size());
                    this.calHeadTotal(childSplitBillTotalAmount, aChildEntryInfo);
                    aSplitBillInfo.getEntry().add(aChildEntryInfo);
                    SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
                    aSplitBillEntryRelationInfo.setMotherBillEntryID(motherBillEntryID);
                    aSplitBillEntryRelationInfo.setChildBillEntryID(childBillEntryID);
                    aSplitBillEntryRelationInfo.setSplitQty(aChildEntryInfo.getQty());
                    vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
                    vecSBEntryByOneSB.add(aSplitBillEntryRelationInfo);
                    vNotSplitEntry.add(aSplitBillEntryRelationInfo);
                    continue;
                }
                if (aSaleIssueEntryInfo.getUnWriteOffQty().compareTo(ZERO) == 0) {
                    this.calHeadTotal(motherSplitBillTotalAmount, aSaleIssueEntryInfo);
                    this.resetCoreBillInfo(aSaleIssueBillInfo, aSaleIssueEntryInfo, vMatherBillEntry.size());
                    vMatherBillEntry.add(aSaleIssueEntryInfo);
                    continue;
                }
                aChildEntryInfo = (SaleIssueEntryInfo)aSaleIssueEntryInfo.clone();
                aChildEntryInfo.setId(BOSUuid.create((BOSObjectType)aChildEntryInfo.getBOSType()));
                childBillEntryID = aChildEntryInfo.getId().toString();
                motherAlgorithm.doSplitBillEntry(aSaleIssueEntryInfo, aChildEntryInfo);
                this.doSplitBillEntry(aSaleIssueEntryInfo, aChildEntryInfo, precision);
                this.resetCoreBillInfo(aSplitBillInfo, aChildEntryInfo, aSplitBillInfo.getEntry().size());
                this.resetCoreBillInfo(aSaleIssueBillInfo, aSaleIssueEntryInfo, vMatherBillEntry.size());
                vMatherBillEntry.add(aSaleIssueEntryInfo);
                SplitBillInventoryLog aSplitBillInventoryLog = new SplitBillInventoryLog();
                aSplitBillInventoryLog.setEntryID(motherBillEntryID);
                aSplitBillInventoryLog.setChildEntryID(childBillEntryID);
                aSplitBillInventoryLog.setChildBillID(childBillID);
                aSplitBillInventoryLog.setChildBillNumber(childNumber);
                aSplitBillInventoryLog.setMotherQty(aSaleIssueEntryInfo.getQty());
                aSplitBillInventoryLog.setMotherBaseQty(aSaleIssueEntryInfo.getBaseQty());
                aSplitBillInventoryLog.setMotherStandardCost(aSaleIssueEntryInfo.getStandardCost());
                aSplitBillInventoryLog.setMotherActualCost(aSaleIssueEntryInfo.getActualCost());
                aSplitBillInventoryLog.setChildQty(aChildEntryInfo.getQty());
                aSplitBillInventoryLog.setChildBaseQty(aChildEntryInfo.getBaseQty());
                aSplitBillInventoryLog.setChildStandardCost(aChildEntryInfo.getStandardCost());
                aSplitBillInventoryLog.setChildActualCost(aChildEntryInfo.getActualCost());
                aSplitBillInventoryLog.setYear(aSplitBillInfo.getYear());
                aSplitBillInventoryLog.setPeriod(aSplitBillInfo.getPeriod());
                aSplitBillInventoryLog.setChildBizDate(aSplitBillInfo.getBizDate());
                vecInvLog.add(aSplitBillInventoryLog);
                this.calHeadTotal(motherSplitBillTotalAmount, aSaleIssueEntryInfo);
                this.calHeadTotal(childSplitBillTotalAmount, aChildEntryInfo);
                aSplitBillInfo.getEntry().add(aChildEntryInfo);
                SplitBillEntryRelationInfo aSplitBillEntryRelationInfo = new SplitBillEntryRelationInfo();
                aSplitBillEntryRelationInfo.setMotherBillEntryID(motherBillEntryID);
                aSplitBillEntryRelationInfo.setChildBillEntryID(childBillEntryID);
                aSplitBillEntryRelationInfo.setSplitQty(aChildEntryInfo.getQty());
                vecSBEntryRelation.add(aSplitBillEntryRelationInfo);
                vecSBEntryByOneSB.add(aSplitBillEntryRelationInfo);
            }
            aSaleIssueBillInfo.getEntry().clear();
            for (int m = 0; m < vMatherBillEntry.size(); ++m) {
                aSaleIssueBillInfo.getEntry().add((SaleIssueEntryInfo)vMatherBillEntry.get(m));
            }
            motherAlgorithm.calTotalFields();
            childAlgorithm.calTotalFields();
            this._update(ctx, (IObjectPK)pk, (IObjectValue)aSaleIssueBillInfo);
            this._addnew(ctx, (IObjectValue)aSplitBillInfo);
            if (!this.isActBill) {
                this.vritualSaleIssueId = aSplitBillInfo.getId().toString();
            }
            SplitBillRelationInfo aSplitBillRelationInfo = new SplitBillRelationInfo();
            aSplitBillRelationInfo.setMotherBillID(motherBillID);
            aSplitBillRelationInfo.setMotherBillNumber(motherNumber);
            aSplitBillRelationInfo.setChildBillID(childBillID);
            aSplitBillRelationInfo.setChildBillNumber(childNumber);
            aSplitBillRelationInfo.setStorageOrgUnit(aSaleIssueBillInfo.getStorageOrgUnit());
            aSplitBillRelationInfo.setBillType(aSaleIssueBillInfo.getBillType());
            aSplitBillRelationInfo.setSplitTime(new Timestamp(now.getTime()));
            vecSBRelation.add(aSplitBillRelationInfo);
            if (aSaleIssueBillInfo.isFiVouchered()) {
                childMap.put(aSplitBillInfo.getId().toString(), aSplitBillInfo.getVoucher().getId().toString());
            }
            hsSB.put(motherBillID, vecSBEntryByOneSB);
            hsSB.put(motherBillID + motherBillID, vNotSplitEntry);
        }
        String relationId = this.saveBotpRelation(ctx, vecSBRelation, hsSB);
        if (!this.isActBill) {
            this.vritualSaleIssueRelationId = relationId;
        }
        SaleIssueBillControllerBean.saveBOTRelation(ctx, childMap);
        this.saveSplitBillRelation(ctx, vecSBRelation, vecSBEntryRelation);
        if (notSplitMsg.toString() != null && notSplitMsg.toString().length() > 0) {
            return notSplitMsg.toString();
        }
        return "";
    }

    private String getResourceString(Context ctx, String resName) {
        return ResourceBase.getString((String)resName, (Locale)ctx.getLocale());
    }

    private void resetCoreBillInfo(SaleIssueBillInfo billInfo, SaleIssueEntryInfo entryInfo, int entrySize) {
        if (entryInfo.getSaleOrder() == null || entryInfo.getSaleOrderEntry() == null) {
            entryInfo.setSaleOrderEntry(entryInfo.getId().toString());
            entryInfo.setSaleOrderEntrySeq(entrySize + 1);
            entryInfo.setSaleOrder(billInfo.getId().toString());
            entryInfo.setSaleOrderNumber(billInfo.getNumber());
        }
    }

    private void calHeadTotal(SplitBillTotalAmount splitBillTotalAmount, SaleIssueEntryInfo aSaleIssueEntryInfo) {
        if (aSaleIssueEntryInfo.getAmount() != null) {
            splitBillTotalAmount.setTTotalAmount(splitBillTotalAmount.getTTotalAmount().add(aSaleIssueEntryInfo.getAmount()));
        }
        if (aSaleIssueEntryInfo.getLocalAmount() != null) {
            splitBillTotalAmount.setTotalLocalAmount(splitBillTotalAmount.getTotalLocalAmount().add(aSaleIssueEntryInfo.getLocalAmount()));
        }
        if (aSaleIssueEntryInfo.getStandardCost() != null) {
            splitBillTotalAmount.setTotalStandardCost(splitBillTotalAmount.getTotalStandardCost().add(aSaleIssueEntryInfo.getStandardCost()));
        }
        if (aSaleIssueEntryInfo.getActualCost() != null) {
            splitBillTotalAmount.setTotalActualCost(splitBillTotalAmount.getTotalActualCost().add(aSaleIssueEntryInfo.getActualCost()));
        }
    }

    public String getChileNumber(Context ctx, String number, int n) throws EASBizException, BOSException {
        int a;
        int intA = a = 65;
        char end = (char)(intA + n);
        String addString = "_" + end;
        number = number + addString;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        if (this.exists(ctx, filter)) {
            return this.getChileNumber(ctx, number, n + 1);
        }
        return number;
    }

    public void doSplitBillEntry(SaleIssueEntryInfo aMotherEntryInfo, SaleIssueEntryInfo aChildEntryInfo, int precision) throws EASBizException, BOSException {
        int i;
        BigDecimal tempB = null;
        BigDecimal coefficient = null;
        SaleIssueEntryInfo aColneMotherEntryInfo = (SaleIssueEntryInfo)aMotherEntryInfo.clone();
        coefficient = aMotherEntryInfo.getQty().divide(aColneMotherEntryInfo.getQty(), 10, 4);
        SplitBillForBIM aSplitBillForBIM = new SplitBillForBIM();
        String[] amounts = aSplitBillForBIM.getBimAmount();
        String[] qtys = aSplitBillForBIM.getBimQty();
        if (qtys != null) {
            BigDecimal tempQty = null;
            for (i = 0; i < qtys.length; ++i) {
                if (aColneMotherEntryInfo.get(qtys[i]) == null) continue;
                tempQty = (BigDecimal)aColneMotherEntryInfo.get(qtys[i]);
                tempB = coefficient.multiply(tempQty);
                aMotherEntryInfo.put(qtys[i], tempB);
                aChildEntryInfo.put(qtys[i], tempQty.subtract(tempB));
            }
        }
        if (amounts != null) {
            BigDecimal tempAmount = null;
            for (i = 0; i < amounts.length; ++i) {
                if (aColneMotherEntryInfo.get(amounts[i]) == null) continue;
                tempAmount = (BigDecimal)aColneMotherEntryInfo.get(amounts[i]);
                tempB = coefficient.multiply(tempAmount);
                tempB = tempB.setScale(precision, 4);
                aMotherEntryInfo.put(amounts[i], tempB);
                aChildEntryInfo.put(amounts[i], tempAmount.subtract(tempB));
            }
        }
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e000-015bc0a812fd463ED552";
    }

    @Override
    protected boolean isCheckMatCompanyInfo() {
        return true;
    }

    @Override
    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_SALEISSUE, SCMConstant.BOSTYPE_SALEORDER});
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            SaleIssueBillInfo model = (SaleIssueBillInfo)collection.getObject(i);
            this.initBotpData(ctx, (IObjectValue)model);
            String coreOrderId = model.getEntry().get(0).getSaleOrder();
            boolean isCoreOrder = false;
            String coreOrderBosType = null;
            if (!StringUtils.isEmpty((String)coreOrderId)) {
                coreOrderBosType = BOSUuid.read((String)coreOrderId).getType().toString();
            }
            if (coreOrderBosType != null && (coreOrderBosType.equals(SCMConstant.BOSTYPE_PurOrder) || coreOrderBosType.equals(SCMConstant.BOSTYPE_SALEORDER))) {
                isCoreOrder = true;
            }
            if (isCoreOrder && model.isIsSysBill()) continue;
            this.setCurrency(ctx, (IObjectValue)model, (AbstractObjectCollection)model.get("entry"));
        }
    }

    private void setConvertMode(Context ctx, SaleIssueBillInfo info) throws EASBizException, BOSException {
        String sourceBillTypeID = info.getSourceBillType().getId().toString();
        if (!"Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sourceBillTypeID)) {
            return;
        }
        ObjectUuidPK sourceCurrPK = null;
        ObjectUuidPK destCurrPK = null;
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(info.getStorageOrgUnit().getId());
        sourceCurrPK = new ObjectUuidPK(info.getCurrency().getId());
        destCurrPK = new ObjectUuidPK(cou.getBaseCurrency().getId());
        ExchangeTableInfo exchangeTableInfo = cou.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo != null) {
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
            ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, info.getBizDate());
            if (exchangeRateInfo != null) {
                info.setConvertMode(exchangeRateInfo.getConvertMode());
            }
        }
    }

    @Override
    protected void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.initBotpData(ctx, model);
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        this.filterForTransferOrder(info);
        this.setTransType4RetTransferOrder(ctx, info);
        this.setConvertMode(ctx, info);
        new SaleIssueAlgorithmForInfo(info, ctx).revalue();
        this.setSaleOrgUnit(ctx, info);
        this.setTransTypeForArbill(ctx, info);
        this.setIsIncomeConfirm(ctx, info);
    }

    private void setSaleOrgUnit(Context ctx, SaleIssueBillInfo info) throws EASBizException, BOSException {
        if (info == null || info.getStorageOrgUnit() == null || info.getSourceBillType() == null) {
            return;
        }
        if (!("18b7FpLNSrmaD8V9SPcOhkY+1VI=".equals(info.getSourceBillType().getId().toString()) || info.getEntry().get(0).getSaleOrgUnit() == null && info.getEntry().get(0).getCoreBillType() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(info.getSourceBillType().getId().toString()) && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(info.getEntry().get(0).getCoreBillType().getId().toString()))) {
            return;
        }
        SaleOrgUnitInfo saleOrg = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(info.getStorageOrgUnit().getId().toString());
        if (saleOrg == null) {
            return;
        }
        SaleIssueEntryInfo entryInfo = null;
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            if (entryInfo.getSaleOrgUnit() != null) continue;
            entryInfo.setSaleOrgUnit(saleOrg);
        }
    }

    protected void filterForTransferOrder(SaleIssueBillInfo info) throws InvBizException {
        String sourceBillTypeID;
        String bizType;
        if (info.getBizType() != null && ((bizType = info.getBizType().getId().toString()).equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=") || bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=") || bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) && "Eg5BUQEVEADgAAABwKgOEEY+1VI=".equals(sourceBillTypeID = info.getSourceBillType().getId().toString())) {
            SaleIssueEntryInfo entryInfo = null;
            SaleIssueEntryCollection entryCol = info.getEntry();
            int k = info.getEntry().size();
            for (int i = 0; i < k; ++i) {
                entryInfo = info.getEntry().get(i);
                BigDecimal baseQty = entryInfo.getQty();
                if (baseQty == null || baseQty.compareTo(SysConstant.BIGZERO) < 0) continue;
                entryCol.removeObject(i);
                --i;
                --k;
            }
            if (entryCol.size() == 0) {
                throw new InvBizException(InvBizException.ERROR_CREATE_BOTP_SALEISSUE);
            }
        }
    }

    @Override
    protected boolean isCheckMaterialCost() {
        return true;
    }

    @Override
    protected void _checkPreReceived(Context ctx, Set saleOrderIds) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        HashSet<String> saleOrgIds = new HashSet<String>();
        IRowSet rs = null;
        sqlBuff.append("SELECT A.FSeq as FSeq,B.FNumber as FNumber,B.FSaleOrgUnitID as FSaleOrgUnigID,");
        sqlBuff.append("isnull(A.FUnPrereceivedAmount,0) as FUnPrereceivedAmount ");
        sqlBuff.append("FROM T_SD_SaleOrderEntry A  ");
        sqlBuff.append("inner join T_SD_SaleOrder B on A.FParentID = B.FID ");
        sqlBuff.append("left join T_BD_PaymentType D on B.FPAYMENTTYPEID  = D.FID ");
        sqlBuff.append("where D.FNumber in ('001','002') and A.FID in(");
        Iterator iter = saleOrderIds.iterator();
        while (iter.hasNext()) {
            sqlBuff.append("'").append(iter.next()).append("',");
        }
        sqlBuff.deleteCharAt(sqlBuff.length() - 1);
        sqlBuff.append(") order by A.FSeq ");
        int errors = 0;
        Object[] infoStr = new String[]{""};
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            while (rs.next()) {
                if (rs.getBigDecimal("FUnPrereceivedAmount").signum() != 1) continue;
                saleOrgIds.add(rs.getString("FSaleOrgUnigID"));
                infoStr[0] = infoStr[0] + "\n" + ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"SaleOrderForPurAccrodingSale", (String[])new String[]{rs.getString("FNumber"), String.valueOf(rs.getInt("FSeq")), rs.getBigDecimal("FUnPrereceivedAmount").toString()});
                ++errors;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (errors > 0) {
            HashSet<String> paramSet = new HashSet<String>();
            String paramValue = "1";
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            Iterator iter2 = saleOrgIds.iterator();
            while (iter2.hasNext()) {
                paramValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(((String)iter2.next()).toString()), "SALEORDER200");
                paramSet.add(paramValue);
            }
            if (paramSet.size() > 1) {
                throw new InvBizException(InvBizException.ORGPARAMVALUENOTSAME);
            }
            if (paramValue.equals("0")) {
                throw new InvUpdateException(InvUpdateException.SALEORDER_UNPREPAYMENT_OVERZERO_FORCE, infoStr);
            }
            if (paramValue.equals("1")) {
                throw new InvUpdateException(InvUpdateException.SALEORDER_UNPREPAYMENT_OVERZERO, infoStr);
            }
        }
    }

    public static int PeriodCompare(Context ctx, String sourceperiodInfoId, String targetperiodInfoId) throws BOSException, EASBizException {
        if (sourceperiodInfoId == null || targetperiodInfoId == null) {
            throw new PeriodException(PeriodException.PKNOTNULL);
        }
        PeriodInfo sourceperiodInfo = null;
        PeriodInfo targetperiodInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("periodYear"));
        sic.add(new SelectorItemInfo("periodNumber"));
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        sourceperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(sourceperiodInfoId), sic);
        targetperiodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(targetperiodInfoId), sic);
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return 1;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            if (sourceperiodInfo.getPeriodNumber() > targetperiodInfo.getPeriodNumber()) {
                return 1;
            }
            if (sourceperiodInfo.getPeriodNumber() == targetperiodInfo.getPeriodNumber()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    protected List getAddedSelector() {
        ArrayList<SelectorItemInfo> selList = new ArrayList<SelectorItemInfo>();
        selList.add(new SelectorItemInfo("*"));
        selList.add(new SelectorItemInfo("transactionType.*"));
        selList.add(new SelectorItemInfo("entry.*"));
        selList.add(new SelectorItemInfo("entry.material.*"));
        selList.add(new SelectorItemInfo("entry.warehouse.*"));
        return selList;
    }

    private int getBackBillsSize(Set set, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillType.id", (Object)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.riType.bizDirection", (Object)-1, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        view.setFilter(filter);
        view.getSelector().add("id");
        SaleIssueBillCollection backBills = this.getSaleIssueBillCollection(ctx, view);
        return backBills.size();
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        if (!"2652E01E".equals(bOTRelationInfos.get(0).getDestEntityID())) {
            return;
        }
        try {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                StringBuffer sql = new StringBuffer();
                StringBuffer sqlin = new StringBuffer();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sqlin.append(",");
                    }
                    sqlin.append("'").append(bOTRelationInfos.get(i).getDestObjectID()).append("'");
                }
                sql.append("update T_IM_SaleIssueBill set fvoucherid = null,ffivouchered = 0 ");
                sql.append(" where fvoucherid in (").append(sqlin).append(")");
                String sqlStr = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlStr);
            }
        }
        catch (BOSException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean checkPriceAndAmount(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)aSCMBillBaseInfo;
        boolean noPriceAndAmount = false;
        if (billInfo != null && billInfo.getEntry() != null) {
            Object[] msg = new String[1];
            int step = 0;
            StringBuffer materialNumber = new StringBuffer("");
            if (billInfo.isIsInTax()) {
                for (int i = 0; i < billInfo.getEntry().size(); ++i) {
                    if (billInfo.getEntry().get(i).isIsPresent() || billInfo.getEntry().get(i).getTaxPrice() != null && billInfo.getEntry().get(i).getAmount() != null && billInfo.getEntry().get(i).getTaxPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 && billInfo.getEntry().get(i).getAmount().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
                    noPriceAndAmount = true;
                    if (step == 0) {
                        materialNumber.append(i + 1 + "");
                    } else {
                        materialNumber.append("\u3001" + (i + 1) + "");
                    }
                    ++step;
                }
            } else {
                for (int i = 0; i < billInfo.getEntry().size(); ++i) {
                    if (billInfo.getEntry().get(i).isIsPresent() || billInfo.getEntry().get(i).getPrice() != null && billInfo.getEntry().get(i).getNonTaxAmount() != null && billInfo.getEntry().get(i).getPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 && billInfo.getEntry().get(i).getNonTaxAmount().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
                    noPriceAndAmount = true;
                    if (step == 0) {
                        materialNumber.append(i + 1 + "");
                    } else {
                        materialNumber.append("\u3001" + (i + 1) + "");
                    }
                    ++step;
                }
            }
            if (noPriceAndAmount) {
                msg[0] = String.valueOf(materialNumber);
                if (billInfo.isIsInTax()) {
                    throw new SCMBillException(SCMBillException.ENTRYSNOTAXPRICEANDTAXAMOUNT, msg);
                }
                throw new SCMBillException(SCMBillException.ENTRYSNOPRICEANDAMOUNT, msg);
            }
        }
        return true;
    }

    @Override
    protected String getCoreBillEntryId(Context ctx, InvBillBaseInfo info) {
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)info;
        SaleIssueEntryCollection col = billInfo.getEntry();
        StringBuffer inSql = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getSaleOrderEntry() == null) continue;
            inSql.append("'").append(col.get(i).getSaleOrderEntry()).append("',");
        }
        if (inSql.length() > 0) {
            inSql.setLength(inSql.length() - 1);
            return inSql.toString();
        }
        return null;
    }

    @Override
    protected Map getCoreBillType(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)info;
        SaleIssueEntryCollection col = billInfo.getEntry();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            if (col.get(i).getCoreBillType() == null || col.get(i).getCoreBillType().getId() == null) continue;
            map.put(col.get(i).getCoreBillType().getId().toString(), col.get(i).getCoreBillType().getId().toString());
        }
        if (map.size() > 0) {
            return map;
        }
        return null;
    }

    @Override
    protected boolean checkEntryCoreBillType(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
        SaleIssueEntryCollection collection = billInfo.getEntry();
        String CoreBillTypeid = null;
        if (collection.get(0).getCoreBillType() != null && collection.get(0).getCoreBillType().getId() != null) {
            CoreBillTypeid = collection.get(0).getCoreBillType().getId().toString();
        }
        for (int i = 1; i < collection.size(); ++i) {
            if (collection.get(i).getCoreBillType() != null && collection.get(i).getCoreBillType().getId() != null && !collection.get(i).getCoreBillType().getId().toString().equals(CoreBillTypeid)) {
                return false;
            }
            if (collection.get(i).getCoreBillType() != null || CoreBillTypeid == null) continue;
            return false;
        }
        return true;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchActionEnum);
    }

    @Override
    protected void checkUnPassAduit(Context ctx, InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        if (this.isHasConsSettle(ctx, invBillBaseInfo)) {
            throw new InvBizException(InvBizException.CONSIS_NOT_UNAUDIT);
        }
        super.checkUnPassAduit(ctx, invBillBaseInfo);
    }

    private boolean isHasConsSettle(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        boolean isConsSettleBill = false;
        if (invBillBaseInfo != null && invBillBaseInfo.getId() != null && invBillBaseInfo.getTransactionType() != null && invBillBaseInfo.getBizType() != null && invBillBaseInfo.getTransactionType().getRiType() != null) {
            String riTypeID = invBillBaseInfo.getTransactionType().getRiType().getId().toString();
            if ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(invBillBaseInfo.getBizType().getId().toString()) && (RecIssueTypeConstant.CONSIGNOUT_RITYPEID.equals(riTypeID) || RecIssueTypeConstant.CONSIGNRT_RITYPEID.equals(riTypeID))) {
                String sql = "select * from T_SD_ConsignSaleBillEntry where FSourceBillMID='" + invBillBaseInfo.getId().toString() + "'";
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (rs.next()) {
                        isConsSettleBill = true;
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return isConsSettleBill;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getSaleIssueBillSelector((boolean)true);
    }

    @Override
    public IObjectCollection _createNewAuditBillBySettle(Context ctx, Map settledEntriesMap, Set srcBillIdSet) throws BOSException, EASBizException {
        IParamControl ipc;
        String paramvalue;
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        FilterInfo entryFilter = new FilterInfo(EntryFilterType.NORMAL);
        entryFilter.setEntryName("entry");
        Set settledEntriesIdsSet = settledEntriesMap.keySet();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", settledEntriesIdsSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.getEntryFilters().add(entryFilter);
        FilterItemInfo billHeadFilter = new FilterItemInfo("id", (Object)srcBillIdSet, CompareType.INCLUDE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(billHeadFilter);
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        CoreBillBaseCollection coreBillBaseColl = iSaleIssueBill.getCoreBillBaseCollection(view);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOSObjectType dstBosType = BOSObjectType.create((String)SCMConstant.BOSTYPE_SALEISSUE);
        BTPTransformResult transformResult = null;
        try {
            transformResult = iBTPManager.transformForBotp(coreBillBaseColl, dstBosType.toString(), (IObjectPK)new ObjectStringPK("p/rJ5pFnTgC88vBkwbjlXgRRIsQ="));
        }
        catch (ObjectNotFoundException e) {
            throw new InvBizException(InvBizException.SALEIS_SALEIS001_BOTP_NOT_EXISTS);
        }
        if (transformResult == null) {
            throw new InvBizException(InvBizException.CANNOT_CREATE_SETTLEDSALEISSUEBILL);
        }
        IObjectCollection destColl = transformResult.getBills();
        HashSet<String> orgIdSet = new HashSet<String>();
        SaleIssueBillInfo billInfo = null;
        int count = destColl.size();
        for (int i = 0; i < count; ++i) {
            billInfo = (SaleIssueBillInfo)destColl.getObject(i);
            if (billInfo.getStorageOrgUnit() == null) continue;
            orgIdSet.add(billInfo.getStorageOrgUnit().getId().toString());
        }
        Map<String, Boolean> orgParamMap = this.getSubmitAuditParamByOrg(ctx, "SCM_Submit_01", orgIdSet, "50957179-0105-1000-e000-015bc0a812fd463ED552", 4);
        CoreBillBaseCollection coll = new CoreBillBaseCollection();
        String companyOrgID = null;
        int count2 = destColl.size();
        for (int i = 0; i < count2; ++i) {
            CompanyOrgUnitInfo companyOrg;
            billInfo = (SaleIssueBillInfo)destColl.getObject(i);
            if (companyOrgID == null && (companyOrg = SaleIssueBillControllerBean.getCompanyInfo(ctx, billInfo.getStorageOrgUnit())) != null) {
                companyOrgID = companyOrg.getId().toString();
            }
            if (billInfo.getNumber() == null) {
                billInfo.setNumber(SCMServerUtils.getCurrentDateTime());
            }
            if (ctx.get((Object)"bizDate") != null && ctx.get((Object)"bizDate") instanceof Date) {
                billInfo.setBizDate((Date)ctx.get((Object)"bizDate"));
            }
            billInfo = this.splitPresentEntryInfo(settledEntriesMap, billInfo, ctx);
            try {
                this.initBotpData(ctx, (IObjectValue)billInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            ctx.put((Object)"isSettleBill", (Object)true);
            this.processSettledEntryQty(ctx, billInfo, settledEntriesMap);
            this.processSettledEntryCost(ctx, billInfo);
            boolean isAutoAudit = true;
            String orgUnitID = billInfo.getStorageOrgUnit().getId().toString();
            Boolean isAutoAuditObj = orgParamMap.get(orgUnitID);
            if (isAutoAuditObj != null) {
                isAutoAudit = isAutoAuditObj;
            }
            this.saveMaterialSN4ConsignSVirtualBill(ctx, settledEntriesMap, billInfo);
            if (billInfo.get("bizFlowMap") != null) {
                this._save(ctx, (IObjectValue)billInfo);
                Map bizFlowMap = (Map)billInfo.get("bizFlowMap");
                if (bizFlowMap != null && bizFlowMap.size() > 0) {
                    InvServerUtils.writeBizFlowRelation(ctx, bizFlowMap, "T_IM_SaleIssueEntry");
                }
            }
            ctx.put((Object)"isCreateNewAuditBillBySettle", (Object)true);
            this._submit(ctx, (IObjectValue)billInfo);
            if (!isAutoAudit) {
                this._passAudit(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId().toString()), (IObjectValue)billInfo);
            }
            ctx.remove((Object)"isCreateNewAuditBillBySettle");
            coll.add((CoreBillBaseInfo)billInfo);
            ctx.remove((Object)"isSettleBill");
        }
        if (billInfo != null && coll.size() > 0 && companyOrgID != null && Boolean.valueOf(paramvalue = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "Consignment001")).booleanValue()) {
            BOTMappingInfo btpMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo((IObjectPK)new ObjectUuidPK("UdI4msB2Q3KE0nDqpHUpIQRRIsQ="));
            if (!btpMappingInfo.getExtRule().isIsEffected()) {
                // empty if block
            }
            if (btpMappingInfo != null && btpMappingInfo.getId() != null) {
                iBTPManager.transformForBotp(coll, "FC910EF3", (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()));
            }
        }
        return destColl;
    }

    @Override
    public void _deleteBillByUnSettle(Context ctx, Set billIdSet) throws BOSException, EASBizException {
        SaleIssueBillInfo billInfo;
        int i;
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterItemInfo billFilter = new FilterItemInfo("id", (Object)billIdSet, CompareType.INCLUDE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(billFilter);
        view.setFilter(filterInfo);
        view.setSelector(this.getSelector());
        ctx.put((Object)"isSettleAction", (Object)true);
        CoreBillBaseCollection coreBillBaseColl = iSaleIssueBill.getCoreBillBaseCollection(view);
        int count = coreBillBaseColl.size();
        for (i = 0; i < count; ++i) {
            billInfo = (SaleIssueBillInfo)coreBillBaseColl.getObject(i);
            this._unpassAudit(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), (IObjectValue)billInfo);
        }
        ctx.remove((Object)"isSettleAction");
        count = coreBillBaseColl.size();
        for (i = 0; i < count; ++i) {
            billInfo = (SaleIssueBillInfo)coreBillBaseColl.getObject(i);
            this._delete(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()));
        }
    }

    private Map<String, Boolean> getSubmitAuditParamByOrg(Context ctx, String paramNumber, Set orgIdSet, String billTypeID, int orgType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orgUnitID.id"));
        sic.add(new SelectorItemInfo("paramValue"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgType", (Object)new Integer(orgType)));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID.id", (Object)orgIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("param.number", (Object)paramNumber));
        filterInfo.getFilterItems().add(new FilterItemInfo("param.billType.id", (Object)billTypeID));
        view.setFilter(filterInfo);
        ISCMBillParamValue iSCMBillParamValue = SCMBillParamValueFactory.getLocalInstance((Context)ctx);
        SCMBillParamValueCollection sCMBillParamValueCollection = iSCMBillParamValue.getSCMBillParamValueCollection(view);
        HashMap<String, Boolean> orgParamMap = new HashMap<String, Boolean>();
        String defaultValue = null;
        StringBuffer oqlDefalut = new StringBuffer("select * where number = '");
        oqlDefalut.append(paramNumber);
        oqlDefalut.append("' ");
        oqlDefalut.append("and billType.id = '");
        oqlDefalut.append(billTypeID);
        oqlDefalut.append("' ");
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        int count = sCMBillParamValueCollection.size();
        for (int i = 0; i < count; ++i) {
            if (sCMBillParamValueCollection.get(i).getOrgUnitID() == null) continue;
            String orgUnitID = sCMBillParamValueCollection.get(i).getOrgUnitID().getId().toString();
            String paramValue = sCMBillParamValueCollection.get(i).getParamValue();
            boolean isAutoAudit = false;
            if (paramValue.trim().length() != 0 && "1".equals(paramValue.trim())) {
                isAutoAudit = true;
            } else {
                SCMBillParamCollection sCMBillParamCollection;
                if (null == defaultValue && (sCMBillParamCollection = iSCMBillParam.getSCMBillParamCollection(oqlDefalut.toString())) != null && sCMBillParamCollection.size() > 0) {
                    defaultValue = sCMBillParamCollection.get(0).getDefaultValue();
                }
                isAutoAudit = defaultValue != null ? "true".equals(defaultValue) : isAutoAudit;
            }
            orgParamMap.put(orgUnitID, isAutoAudit);
        }
        return orgParamMap;
    }

    private void processSettledEntryCost(Context ctx, InvBillBaseInfo invBillBaseInfo) throws BOSException, EASBizException {
        SaleIssueEntryCollection entries = ((SaleIssueBillInfo)invBillBaseInfo).getEntry();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entryInfo = entries.get(i);
            if (entryInfo.getUnitActualCost() == null) {
                entryInfo.setUnitActualCost(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (entryInfo.getQty() == null) {
                entryInfo.setQty(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (entryInfo.getLocalAmount() == null) {
                entryInfo.setLocalAmount(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (entryInfo.getUnitStandardCost() == null) {
                entryInfo.setUnitStandardCost(SCMConstant.BIGDECIMAL_ZERO);
            }
            if (entryInfo.getStandardCost() != null) continue;
            entryInfo.setStandardCost(entryInfo.getUnitStandardCost().multiply(entryInfo.getQty()).setScale(entryInfo.getLocalAmount().scale(), 4));
        }
    }

    private void processSettledEntryQty(Context ctx, InvBillBaseInfo invBillBaseInfo, Map settledEntriesMap) throws BOSException, EASBizException {
        SaleIssueEntryCollection entries = ((SaleIssueBillInfo)invBillBaseInfo).getEntry();
        SaleIssueEntryCollection sourceEntrys = null;
        BigDecimal unissueSettlebaseQty = SysConstant.BIGZERO;
        sourceEntrys = this.getSourceBillEntry(ctx, entries);
        BigDecimal baseQty = SysConstant.BIGZERO;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueEntryInfo entryInfo = entries.get(i);
            entryInfo.setUnSettleQty(SysConstant.BIGZERO);
            entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
            ConsignSaleBillEntryInfo consignEntryInfo = (ConsignSaleBillEntryInfo)settledEntriesMap.get(entryInfo.getSourceBillEntryId());
            for (int t = 0; t < sourceEntrys.size(); ++t) {
                if (!sourceEntrys.get(t).getId().toString().equals(entryInfo.getSourceBillEntryId())) continue;
                SaleIssueEntryInfo sourceEntry = sourceEntrys.get(t);
                unissueSettlebaseQty = sourceEntry.getUnSettleBaseQty();
                break;
            }
            if (unissueSettlebaseQty.subtract((BigDecimal)consignEntryInfo.get("baseqty")).signum() == -1) {
                throw new ConsignSaleException(ConsignSaleException.DATA_ERROR);
            }
            entryInfo.setTotalSettleQty(entryInfo.getQty());
            entryInfo.setTotalSettleBaseQty(entryInfo.getBaseQty());
        }
    }

    private SaleIssueEntryCollection getSourceBillEntry(Context ctx, SaleIssueEntryCollection entries) throws BOSException {
        SaleIssueEntryCollection sourceEntrys = null;
        HashSet<String> issueIds = new HashSet<String>();
        int size = entries.size();
        for (int j = 0; j < size; ++j) {
            SaleIssueEntryInfo entryInfo = entries.get(j);
            issueIds.add(entryInfo.getSourceBillEntryId());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", issueIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("unSettleBaseQty"));
        viewInfo.setSelector(selector);
        sourceEntrys = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(viewInfo);
        return sourceEntrys;
    }

    @Override
    protected boolean isCheckMaterialInventory() {
        return true;
    }

    @Override
    protected boolean isUseBusinessChain() {
        return true;
    }

    private void setTransTypeForArbill(Context ctx, SaleIssueBillInfo info) throws EASBizException, BOSException {
        if (info.getBillType() == null || info.getBizType() == null) {
            return;
        }
        String billTypeId = info.getBillType().getId().toString();
        String bizTypeId = info.getBizType().getId().toString();
        String sourceBillTypeId = info.getSourceBillType().getId().toString();
        if ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            boolean isUpdateByARBILL = false;
            CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            String isInvUpdateByARBillStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(cou.getId()), "CONSIGNSALES");
            if (!StringUtils.isEmpty((String)isInvUpdateByARBillStr) && "true".equalsIgnoreCase(isInvUpdateByARBillStr.trim())) {
                isUpdateByARBILL = true;
            }
            TransactionTypeCollection coll = InvCommonUtils.getDefaultTransactionTypeCol(ctx, billTypeId, bizTypeId);
            HashSet<String> ids = new HashSet<String>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ids.add(coll.get(i).getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sic = new SorterItemCollection();
            SorterItemInfo riType = new SorterItemInfo("riType.bizDirection");
            riType.setSortType(SortType.DESCEND);
            SorterItemInfo number = new SorterItemInfo("number");
            sic.add(riType);
            sic.add(number);
            view.setSorter(sic);
            view.setSelector(SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            if (isUpdateByARBILL) {
                if ("d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                    filter.getFilterItems().add(new FilterItemInfo("riType.number", (Object)"016", CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)true, CompareType.EQUALS));
                } else if ("d8e80652-0113-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                    filter.getFilterItems().add(new FilterItemInfo("riType.number", (Object)"015", CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)true, CompareType.EQUALS));
                }
            } else if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(sourceBillTypeId)) {
                filter.getFilterItems().add(new FilterItemInfo("riType.number", (Object)"015", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)false, CompareType.EQUALS));
            } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(sourceBillTypeId)) {
                if ("d8e80652-0114-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
                    filter.getFilterItems().add(new FilterItemInfo("riType.number", (Object)"015", CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)false, CompareType.EQUALS));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("riType.number", (Object)"003", CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("isWriteOff", (Object)true, CompareType.EQUALS));
                }
            }
            view.setFilter(filter);
            ITransactionType itt = ctx == null ? TransactionTypeFactory.getRemoteInstance() : TransactionTypeFactory.getLocalInstance((Context)ctx);
            coll = itt.getTransactionTypeCollection(view);
            if (!coll.isEmpty()) {
                TransactionTypeInfo transaction = coll.get(0);
                TransactionTypeInfo oldTransaction = info.getTransactionType();
                if (oldTransaction != null && oldTransaction.getId().toString().equals(transaction.getId().toString())) {
                    return;
                }
                info.setTransactionType(transaction);
                SaleIssueEntryCollection entries = info.getEntry();
                InvUpdateTypeInfo updateType = InvCommonUtils.getDefaultInvUpdateType(ctx, billTypeId, transaction);
                int size2 = entries.size();
                for (int i = 0; i < size2; ++i) {
                    SaleIssueEntryInfo entry = entries.get(i);
                    entry.setInvUpdateType(updateType);
                }
            }
        }
    }

    private void setTransType4RetTransferOrder(Context ctx, SaleIssueBillInfo info) throws EASBizException, BOSException {
        if (info.getBizType() != null) {
            String bizType = info.getBizType().getId().toString();
            TransactionTypeInfo transactionTypeInfo = null;
            TransactionTypeCollection ttcol = null;
            boolean isSysBill = info.isIsSysBill();
            String billType = "50957179-0105-1000-e000-015bc0a812fd463ED552";
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            if ((!this.isBotpConfigTransactionType.booleanValue() && "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType) || !isSysBill && ("ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType))) && (ttcol = itt.getCollection(billType, bizType)) != null && ttcol.size() > 0) {
                transactionTypeInfo = ttcol.get(0);
            }
            if (transactionTypeInfo != null) {
                info.setTransactionType(transactionTypeInfo);
                int size = info.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    SaleIssueEntryInfo entryInfo = info.getEntry().get(i);
                    this.inverseEntryInfo(entryInfo);
                }
            }
        }
    }

    public BigDecimal formatBigDecimal(BigDecimal value) {
        return value == null ? SysConstant.BIGZERO : value;
    }

    private void inverseEntryInfo(SaleIssueEntryInfo entryInfo) {
        entryInfo.setQty(this.formatBigDecimal(entryInfo.getQty()).abs().negate());
        entryInfo.setBaseQty(this.formatBigDecimal(entryInfo.getBaseQty()).abs().negate());
        entryInfo.setAssistQty(this.formatBigDecimal(this.formatBigDecimal(entryInfo.getAssistQty())).abs().negate());
        entryInfo.setAmount(this.formatBigDecimal(entryInfo.getAmount()).abs().negate());
        entryInfo.setLocalAmount(this.formatBigDecimal(entryInfo.getLocalAmount()).abs().negate());
        entryInfo.setStandardCost(this.formatBigDecimal(entryInfo.getStandardCost()).abs().negate());
        entryInfo.setActualCost(this.formatBigDecimal(entryInfo.getActualCost()).abs().negate());
        entryInfo.setWrittenOffAmount(this.formatBigDecimal(entryInfo.getWrittenOffAmount()).abs().negate());
        entryInfo.setUnWriteOffAmount(this.formatBigDecimal(entryInfo.getUnWriteOffAmount()).abs().negate());
        entryInfo.setWrittenOffQty(this.formatBigDecimal(entryInfo.getWrittenOffQty()).abs().negate());
        entryInfo.setUnWriteOffQty(this.formatBigDecimal(entryInfo.getUnWriteOffQty()).abs().negate());
        entryInfo.setUnWriteOffBaseQty(this.formatBigDecimal(entryInfo.getUnWriteOffBaseQty()).abs().negate());
        entryInfo.setLocalNonTaxAmount(this.formatBigDecimal(entryInfo.getLocalNonTaxAmount()).abs().negate());
        entryInfo.setNonTaxAmount(this.formatBigDecimal(entryInfo.getNonTaxAmount()).abs().negate());
        entryInfo.setLocalTax(this.formatBigDecimal(entryInfo.getLocalTax()).abs().negate());
        entryInfo.setTax(this.formatBigDecimal(entryInfo.getTax()).abs().negate());
    }

    @Override
    protected IObjectCollection getNewEntryCollection() {
        return new SaleIssueEntryCollection();
    }

    @Override
    protected InvBillBaseEntryInfo getCloneEntryInfo(InvBillBaseEntryInfo source) {
        SaleIssueEntryInfo result = new SaleIssueEntryInfo();
        result.putAll((IObjectValue)source);
        return result;
    }

    @Override
    protected String getEntryBOSUuid() {
        return "BBC07FBE";
    }

    @Override
    protected void reCalByQty(Context ctx, InvBillBaseInfo invInfo) throws EASBizException, BOSException {
        super.reCalByQty(ctx, invInfo);
        try {
            new SaleIssueAlgorithmForInfo((SaleIssueBillInfo)invInfo, ctx).revalue();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _changePrice(Context ctx, IObjectPK pk, String description, List list) throws BOSException, EASBizException {
        SaleIssueBillInfo info = this.getSaleIssueBillInfo(ctx, pk, this.getSelector());
        IRowSet rs = CreditUpdateHelper.getPreUpdateData((Context)ctx, (Object[])new Object[]{info.getId()});
        info.setDescription(description);
        boolean isInTax = info.isIsInTax();
        int count = info.getEntry().size();
        for (int i = 0; i < count; ++i) {
            SaleIssueEntryInfo entryInfo = info.getEntry().get(i);
            String entryID = entryInfo.getId().toString();
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                SaleIssueChangePriceVO vo = (SaleIssueChangePriceVO)list.get(j);
                if (!entryID.equals(vo.getEntryID())) continue;
                if (vo.getIsChangePrice() == null || vo.getIsChangePrice().booleanValue()) {
                    if (isInTax) {
                        entryInfo.setTaxPrice(vo.getPrice());
                    } else {
                        entryInfo.setSalePrice(vo.getPrice());
                    }
                } else if (isInTax) {
                    entryInfo.setTaxPrice(SCMConstant.BIGDECIMAL_ZERO);
                    entryInfo.setAmount(vo.getAmount());
                } else {
                    entryInfo.setSalePrice(SCMConstant.BIGDECIMAL_ZERO);
                    entryInfo.setNonTaxAmount(vo.getAmount());
                }
                entryInfo.setRemark(vo.getRemark());
            }
        }
        try {
            boolean isFiVouchered = info.isFiVouchered();
            info.put("doSaleChangePrice", "doSaleChangePrice");
            SaleIssueAlgorithmForInfo saleAlg = new SaleIssueAlgorithmForInfo(info, ctx);
            saleAlg.setReFetchPrice(false);
            saleAlg.revalue();
            info.setFiVouchered(isFiVouchered);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        super._update(ctx, pk, (IObjectValue)info);
        if (!info.isIsSysBill()) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{pk}, rs, CreditOperationEnum.ALTER);
        }
    }

    protected boolean checkWriteoffRecode(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean canChangePrice = true;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT 1 FROM T_CL_WriteOffRecord WHERE FParentID IN ");
        sql.append("(SELECT FParentID FROM T_CL_WriteOffRecord WHERE FBillID = ?) AND FBillTypeNumber = '330' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
        try {
            if (rs.next()) {
                canChangePrice = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return canChangePrice;
    }

    protected boolean checkChangePriceBill(Context ctx, IObjectPK pk, String sql) throws BOSException, EASBizException {
        boolean canChangePrice = true;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        try {
            if (rs.next()) {
                canChangePrice = false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return canChangePrice;
    }

    public boolean getParamValue(Context ctx, String paramNumber, IObjectPK orgPK, boolean defaultValue) throws BOSException, EASBizException {
        String paramValueStr = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(orgPK, paramNumber);
        if (String.valueOf(!defaultValue).equals(paramValueStr)) {
            return !defaultValue;
        }
        return defaultValue;
    }

    @Override
    protected String _checkChangePrice(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String checkCreateARBillSql;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("isReversed"));
        selector.add(new SelectorItemInfo("storageOrgUnit"));
        selector.add(new SelectorItemInfo("transactionType"));
        SaleIssueBillInfo info = this.getSaleIssueBillInfo(ctx, pk, selector);
        int i = 0;
        StringBuffer errorMsg = new StringBuffer();
        if (info.getBaseStatus().getValue() != 4) {
            errorMsg.append(++i + "." + InvServerUtils.getResource(ctx, "CHANGEPRICE_UNAUDITED") + "\n");
        }
        if (info.isIsReversed()) {
            errorMsg.append(++i + "." + InvServerUtils.getResource(ctx, "CHANGEPRICE_ISREVERSED") + "\n");
        }
        if (!this.checkChangePriceBill(ctx, pk, checkCreateARBillSql = "select top 1 FID from T_AR_OtherBillentry where FSourceBillID = ?")) {
            errorMsg.append(++i + "." + InvServerUtils.getResource(ctx, "CHANGEPRICE_ISCREATEARBILL") + "\n");
        }
        if (!this.checkWriteoffRecode(ctx, pk)) {
            errorMsg.append(++i + "." + InvServerUtils.getResource(ctx, "CHANGEPRICE_ISCREATEWRITEOFFRECORD4AR") + "\n");
        }
        StringBuffer checkCustIsCreditedSB = new StringBuffer();
        checkCustIsCreditedSB.append("select top 1 bill.FID from t_im_saleissuebill bill ");
        checkCustIsCreditedSB.append("inner join T_BD_Customer cust on cust.FID = bill.FCustomerID  ");
        checkCustIsCreditedSB.append("where bill.FID =? ");
        checkCustIsCreditedSB.append("and cust.FIsCredited = 1 ");
        boolean checkCanCustIsCredited = this.checkChangePriceBill(ctx, pk, checkCustIsCreditedSB.toString());
        String companyID = SaleIssueBillControllerBean.getCompanyInfo(ctx, info.getStorageOrgUnit()).getId().toString();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyID);
        boolean G004Value = this.getParamValue(ctx, "G004", (IObjectPK)companyPK, false);
        boolean G005Value = this.getParamValue(ctx, "G005", null, false);
        boolean CreditParam03Value = false;
        if (G005Value) {
            String sqlTopCU = "select fvalue_l2 parmaValue from t_bas_paramitem where fkeyid in (select fid from t_bas_param where fnumber='CreditParam03') and forgunitid in (select top 1 fid from T_ORG_Company where fparentid is null) ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlTopCU);
            String tempValue = null;
            try {
                if (rs.next()) {
                    tempValue = rs.getString("parmaValue");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            CreditParam03Value = Boolean.valueOf(tempValue);
        } else {
            CreditParam03Value = this.getParamValue(ctx, "CreditParam03", (IObjectPK)companyPK, true);
        }
        if (!checkCanCustIsCredited && G004Value && CreditParam03Value) {
            errorMsg.append(++i + "." + InvServerUtils.getResource(ctx, "CHANGEPRICE_ISCUSTOMERCREDIT") + "\n");
        }
        return errorMsg.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeDiffQty2CoreBillSaleOrder(Context ctx, IObjectValue model, boolean isAudit) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        StringBuffer ids = new StringBuffer();
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        if (info.getSourceBillType() == null) return;
        if (!"510b6503-0105-1000-e000-011bc0a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            return;
        }
        if (info.getEntry() == null) {
            return;
        }
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        for (int i = 0; i < info.getEntry().size(); ++i) {
            String paramValue;
            if (info.getEntry().get(i) == null || info.getEntry().get(i).getSaleOrgUnit() == null) continue;
            String saleOrgUnitID = info.getEntry().get(i).getSaleOrgUnit().getId().toString();
            String string = paramValue = paramValueMap.get(saleOrgUnitID) != null ? ((String)paramValueMap.get(saleOrgUnitID)).toString() : ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(saleOrgUnitID), (String)"SALEORDER005");
            if (Boolean.valueOf(paramValue).booleanValue()) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append("'").append(info.getEntry().get(i).getId().toString()).append("'");
            }
            paramValueMap.put(saleOrgUnitID, paramValue);
        }
        if (ids.length() < 1) {
            return;
        }
        if (StringUtil.isEmpty((String)ids.toString())) {
            return;
        }
        Connection con = null;
        PreparedStatement updatePstmt = null;
        IRowSet rs = null;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select (case\n");
        selectSql.append("         when pre.fqty < pre.fshippedqty - sie.fqty then\n");
        selectSql.append("          sie.fqty\n");
        selectSql.append("         when pre.fqty < pre.fshippedqty then\n");
        selectSql.append("          pre.fshippedqty-pre.fqty\n");
        selectSql.append("       end) diffQty,\n");
        selectSql.append("       (case\n");
        selectSql.append("         when pre.fbaseqty < pre.fshippedbaseqty - sie.fbaseqty then\n");
        selectSql.append("          sie.fbaseqty\n");
        selectSql.append("         when pre.fbaseqty < pre.fshippedbaseqty then\n");
        selectSql.append("          pre.fshippedbaseqty-pre.fbaseqty\n");
        selectSql.append("       end) diffBaseQty,\n");
        selectSql.append("       mu.FBaseConvsRate FBaseConvsRate, sie.fsaleorderentryid FID\n");
        selectSql.append("  from t_im_saleissuebill si ");
        selectSql.append(" inner join t_im_saleissueentry sie on sie.fparentid = si.fid\n");
        selectSql.append(" inner join t_sd_saleorderentry soe on sie.fsaleorderentryid = soe.fid\n");
        selectSql.append(" inner join t_sd_postrequisitionentry pre on pre.fid =\n");
        selectSql.append("                                             sie.fsourcebillentryid\n");
        selectSql.append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ");
        selectSql.append(" where si.FIsReversed=0 and sie.fid in(").append(ids).append(")");
        String updateSql = "update t_sd_saleorderentry set FTotalUnIssueQty = FTotalUnIssueQty+?, FTotalUnIssueBaseQty = FTotalUnIssueBaseQty+? where FID = ?";
        try {
            con = this.getConnection(ctx);
            updatePstmt = con.prepareStatement(updateSql);
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                do {
                    BigDecimal diffQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("diffQty")).abs();
                    BigDecimal diffBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("diffBaseQty")).abs();
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    diffQty = diffBaseQty.divide(baseConvsRate, diffQty.scale(), 4);
                    updatePstmt.setBigDecimal(1, isAudit ? diffQty.negate() : diffQty);
                    updatePstmt.setBigDecimal(2, isAudit ? diffBaseQty.negate() : diffBaseQty);
                    updatePstmt.setString(3, rs.getString("FID"));
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
            }
        }
        catch (BOSException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (SQLException e2) {
                    logger.error((Object)e2);
                    throw new BOSException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, updatePstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)updatePstmt, (Connection)con);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleIssueBillInfo info = this.getSaleIssueBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)TABLENAME);
        SaleIssueBillInfo info = this.getSaleIssueBillInfo(ctx, pk, this.getSelector());
        if (ctx.get((Object)"isSettleBill") == null) {
            this.setUnSettleQtyDefaultValue(ctx, (IObjectValue)info);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)TABLENAME);
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        SaleIssueBillInfo info = this.getSaleIssueBillInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx.get((Object)"isSettleBill") == null) {
            this.setUnSettleQtyDefaultValue(ctx, (IObjectValue)((SaleIssueBillInfo)model));
        }
        IObjectPK pk = null;
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            pk = super.submitWithoutBusiness(ctx, model);
        } else {
            BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
            entries[0].add((Object)model);
            this.batchSubmitRelations(ctx, entries);
            pk = new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
        }
        return pk;
    }

    private boolean isReturnRIType(TransactionTypeInfo transactionType) {
        if (transactionType == null) {
            return false;
        }
        int bizDirection = transactionType.getRiType().getBizDirection().getValue();
        return bizDirection == -1;
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        return super.batchExecute(ctx, entries, batchActionEnum);
    }

    private void setUnSettleQtyDefaultValue(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return;
        }
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        SaleIssueEntryCollection entries = info.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)entries)) {
            return;
        }
        SaleIssueEntryInfo entry = null;
        ArrayList idList = new ArrayList();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (entry == null) continue;
            entry.setUnSettleQty(entry.getQty());
            entry.setUnSettleBaseQty(entry.getBaseQty());
        }
    }

    private SaleIssueBillInfo splitPresentEntryInfo(Map settledEntriesMap, SaleIssueBillInfo billInfo, Context ctx) throws EASBizException, BOSException {
        Map<String, String> flowMap;
        SaleIssueEntryCollection entries = billInfo.getEntry();
        SaleIssueEntryCollection sourceEntrys = null;
        BigDecimal settleQty = SysConstant.BIGZERO;
        BigDecimal settleBaseQty = SysConstant.BIGZERO;
        BigDecimal presentQty = SysConstant.BIGZERO;
        BigDecimal unissueSettlebaseQty = SysConstant.BIGZERO;
        SaleIssueEntryCollection newEntries = new SaleIssueEntryCollection();
        ConsignSaleBillEntryInfo consignEntryInfo = null;
        HashSet<String> setIds = new HashSet<String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap mapRelation = null;
        sourceEntrys = this.getSourceBillEntry(ctx, entries);
        int size = entries.size();
        for (int j = 0; j < size; ++j) {
            SaleIssueEntryInfo entryInfo = entries.get(j);
            consignEntryInfo = (ConsignSaleBillEntryInfo)settledEntriesMap.get(entryInfo.getSourceBillEntryId());
            BigDecimal oldQty = BigDecimal.ZERO;
            for (int t = 0; t < sourceEntrys.size(); ++t) {
                if (!sourceEntrys.get(t).getId().toString().equals(entryInfo.getSourceBillEntryId())) continue;
                SaleIssueEntryInfo sourceEntry = sourceEntrys.get(t);
                unissueSettlebaseQty = sourceEntry.getUnSettleBaseQty();
                break;
            }
            oldQty = entryInfo.getQty();
            settleQty = consignEntryInfo.getWriteOffQty();
            entryInfo.setQty(settleQty);
            if (oldQty.compareTo(settleQty) != 0 || entryInfo.getActualCost() == null || entryInfo.getActualCost().compareTo(SCMConstant.BIGDECIMAL_ZERO) == 0) {
                entryInfo.setActualCost(entryInfo.getUnitActualCost().multiply(entryInfo.getQty()).setScale(entryInfo.getLocalAmount().scale(), 4));
            }
            boolean isSplitEntry = false;
            presentQty = (BigDecimal)consignEntryInfo.get("presentQty");
            if (presentQty != null && presentQty.compareTo(SysConstant.BIGZERO) > 0 && presentQty.compareTo(settleQty) < 0) {
                isSplitEntry = true;
            }
            if (isSplitEntry) {
                setIds.add(entryInfo.getId().toString());
                SaleIssueEntryAgent aEntryInfo = null;
                int splitNum = 2;
                for (int k = 0; k < splitNum; ++k) {
                    aEntryInfo = SaleIssueEntryAgent.copyOvAsNewAgent((IObjectValue)entryInfo);
                    BigDecimal assistQty = (BigDecimal)consignEntryInfo.get("assistQty");
                    if (k == 0) {
                        aEntryInfo.setId(entryInfo.getId());
                        aEntryInfo.setIsPresent(false);
                        aEntryInfo.setQty(settleQty.subtract(presentQty));
                        aEntryInfo.put("ispresent", false);
                        if (billInfo.isIsInTax()) {
                            aEntryInfo.setTaxPrice(consignEntryInfo.getVerifyTaxPrice());
                        } else {
                            aEntryInfo.setSalePrice(consignEntryInfo.getVerifyPrice());
                        }
                        aEntryInfo.setDiscount(consignEntryInfo.getVerifyDiscount());
                        if (assistQty != null && assistQty.compareTo(SysConstant.BIGZERO) > 0) {
                            aEntryInfo.setAssistQty(((BigDecimal)consignEntryInfo.get("assistQty")).multiply(settleQty.subtract(presentQty)).divide(settleQty));
                        }
                    }
                    if (k == 1) {
                        aEntryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
                        aEntryInfo.setIsPresent(true);
                        aEntryInfo.setQty(presentQty);
                        aEntryInfo.put("ispresent", true);
                        if (billInfo.isIsInTax()) {
                            aEntryInfo.setTaxPrice(SysConstant.BIGZERO);
                            aEntryInfo.setPrice(SysConstant.BIGZERO);
                            aEntryInfo.setAmount(SysConstant.BIGZERO);
                        } else {
                            aEntryInfo.setSalePrice(SysConstant.BIGZERO);
                            aEntryInfo.setActualPrice(SysConstant.BIGZERO);
                        }
                        aEntryInfo.setDiscount(SysConstant.BIGZERO);
                        aEntryInfo.setActualPrice(SysConstant.BIGZERO);
                        aEntryInfo.setPrice(SysConstant.BIGZERO);
                        if (assistQty != null && assistQty.compareTo(SysConstant.BIGZERO) > 0) {
                            aEntryInfo.setAssistQty(((BigDecimal)consignEntryInfo.get("assistQty")).multiply(presentQty).divide(settleQty));
                        }
                        idMap.put(entryInfo.getId().toString(), aEntryInfo.getIdentity().toString());
                    }
                    newEntries.add(aEntryInfo);
                }
                continue;
            }
            if (presentQty != null && presentQty.compareTo(settleQty) == 0) {
                entryInfo.setIsPresent(true);
            }
            entryInfo.setAssistQty((BigDecimal)consignEntryInfo.get("assistQty"));
            entryInfo.setBaseQty((BigDecimal)consignEntryInfo.get("baseqty"));
            if (billInfo.isIsInTax()) {
                entryInfo.setTaxPrice(consignEntryInfo.getVerifyTaxPrice());
            } else {
                entryInfo.setSalePrice(consignEntryInfo.getVerifyPrice());
            }
            entryInfo.setDiscount(consignEntryInfo.getVerifyDiscount());
            if (entryInfo.isIsPresent()) {
                entryInfo.setActualPrice(SysConstant.BIGZERO);
                entryInfo.setPrice(SysConstant.BIGZERO);
                entryInfo.setTaxPrice(SysConstant.BIGZERO);
                entryInfo.setSalePrice(SysConstant.BIGZERO);
                entryInfo.setAmount(SysConstant.BIGZERO);
                entryInfo.setNonTaxAmount(SysConstant.BIGZERO);
                entryInfo.setLocalNonTaxAmount(SysConstant.BIGZERO);
                entryInfo.setLocalAmount(SysConstant.BIGZERO);
            }
            newEntries.add(entryInfo);
        }
        if (setIds != null && setIds.size() > 0 && (flowMap = InvServerUtils.getBillBizFlowRelation(ctx, setIds, "T_IM_SaleIssueEntry")) != null && flowMap.size() > 0) {
            Iterator its = setIds.iterator();
            String id = null;
            mapRelation = new HashMap();
            while (its.hasNext()) {
                id = its.next().toString();
                mapRelation.put(idMap.get(id), flowMap.get(id) + "#" + (String)idMap.get(id));
            }
        }
        billInfo.getEntry().clear();
        billInfo.getEntry().addCollection(newEntries);
        if (mapRelation != null && mapRelation.size() > 0) {
            billInfo.put("bizFlowMap", mapRelation);
        }
        return billInfo;
    }

    protected String getBizFlowNumber(String entryBosType, String entryId, Context ctx) throws EASBizException, BOSException {
        String bizFlowNumber = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        entryIdSet.add(entryId);
        Map bizFlowSplitMap = BizFlowFacadeFactory.getLocalInstance((Context)ctx).setBizFlowRelBySplitLine(entryIdSet, entryBosType);
        if (bizFlowSplitMap != null && bizFlowSplitMap.size() > 0 && bizFlowSplitMap.containsKey(entryId)) {
            bizFlowNumber = bizFlowSplitMap.get(entryId).toString();
        }
        return bizFlowNumber;
    }

    public BatchActionResults batchDiscard(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults result = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        Set idSet = result.getToDoIdsSet();
        this.reservationCheck(ctx, idSet);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("baseStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(this.getBOSType(), view);
        IObjectValue obj = null;
        String id = null;
        StringBuilder sb = new StringBuilder(1024);
        HashSet<String> creditIdSet = new HashSet<String>();
        BillReservationCancelService billReservationCancelService = BillReservationCancelService.getInstance();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            obj = coll.getObject(i);
            id = String.valueOf(obj.get("id"));
            if (1 == (Integer)obj.get("baseStatus") || 2 == (Integer)obj.get("baseStatus")) {
                result.addSuccess(id);
                sb.append("'").append(id).append("',");
                if (2 == (Integer)obj.get("baseStatus")) {
                    creditIdSet.add(id);
                }
                billReservationCancelService.doBillReservationCancel(ctx, obj);
                continue;
            }
            result.addError(id, (Exception)new SCMBillException(SCMBillException.CANNOT_DISCARD));
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            String tableName = loader.getEntity(this.getBOSType()).getTable().getName();
            DbUtil.execute((Context)ctx, (String)("UPDATE " + tableName + " SET FBaseStatus = " + 3 + " WHERE FID IN (" + sb.toString() + ")"));
        }
        Object[] pks = creditIdSet.toArray();
        CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(pks, CreditOperationEnum.DISCARD);
        return result;
    }

    public void reservationCheck(Context ctx, Set IDs) throws BOSException {
        try {
            Object[] oArray = IDs.toArray(new Object[0]);
            String ids = ArrayUtil.getStringFromArr((Object[])oArray);
            String filter = "(RequireBillID IN (" + ids + ") OR SupplierBillID IN (" + ids + ")) AND isAutoReservation <> 1";
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            ReservationCollection reservationcoll = ReservationFactory.getLocalInstance(ctx).getReservationCollection(view);
            if (reservationcoll.size() > 0) {
                String error = ResourceBase.getString((String)"com.kingdee.eas.scm.im.reservation.InvReservationResource", (String)"ISEXIST_HANDRESERVATION_RECORD", (Locale)ctx.getLocale());
                throw new BOSException(error);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected IObjectValue _changeSaleIsseInfoForCredit(Context ctx, IObjectValue billInfo) throws BOSException {
        if (billInfo != null) {
            SaleIssueBillInfo saleIssueInfo = (SaleIssueBillInfo)billInfo;
            try {
                new SaleIssueAlgorithmForInfo(saleIssueInfo, ctx).revalue();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            return saleIssueInfo;
        }
        return null;
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou;
        BigDecimal ZERO = BigDecimal.ZERO;
        SaleIssueBillInfo billInfo = null;
        billInfo = isUseAgent ? SaleIssueBillAgent.create() : new SaleIssueBillInfo();
        billInfo.setPaymentType(this.getAPaymentTypeInfo(ctx));
        billInfo.setTotalStandardCost(ZERO);
        billInfo.setTotalActualCost(ZERO);
        billInfo.setTotalQty(ZERO);
        billInfo.setTotalAmount(ZERO);
        billInfo.setTotalLocalAmount(ZERO);
        billInfo.setHasEffected(false);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        Calendar cal = Calendar.getInstance();
        Timestamp serverDate = new Timestamp(cal.getTimeInMillis());
        billInfo.setBizDate(serverDate);
        billInfo.setActBizDate(billInfo.getBizDate());
        billInfo.setAuditTime(null);
        billInfo.setCreateTime(serverDate);
        billInfo.setCurrency(null);
        billInfo.setExchangeRate(new BigDecimal("1.00"));
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        billInfo.setCreator(aUserInfo);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        billInfo.setBillType(aBillTypeInfo);
        billInfo.setFiVouchered(false);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billBizType.selfmade"));
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"d8e80652-010e-1000-e000-04c5c0a812202407435C", (String)"50957179-0105-1000-e000-015bc0a812fd463ED552");
        billInfo.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-015bc0a812fd463ED552", bizType.getId().toString());
            billInfo.setTransactionType(tti);
        }
        if ((sou = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "saleissue_new")) == null) {
            billInfo.getEntry().add((SaleIssueEntryInfo)this.createNewDetailData(isUseAgent));
            return billInfo;
        }
        CompanyOrgUnitInfo cou = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)sou.getId().toString()));
        if (cou != null) {
            billInfo.setStorageOrgUnit(sou);
            billInfo.setCurrency(cou.getBaseCurrency());
        }
        SaleIssueEntryInfo entryInfo = (SaleIssueEntryInfo)this.createNewDetailData(isUseAgent);
        SaleOrgUnitInfo aSaleOrgUnitInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(sou.getId().toString());
        entryInfo.setSaleOrgUnit(aSaleOrgUnitInfo);
        if (cou != null) {
            entryInfo.setStorageOrgUnit(sou);
            entryInfo.setCompanyOrgUnit(cou);
        }
        billInfo.setIsInTax(true);
        billInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        billInfo.setCurrency(cou == null ? null : cou.getBaseCurrency());
        billInfo.setExchangeRate(SCMConstant.BIGDECIMAL_ONE.setScale(2));
        if (billInfo.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultInvUpdateType(ctx, "50957179-0105-1000-e000-015bc0a812fd463ED552", billInfo.getTransactionType());
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        billInfo.getEntry().add(entryInfo);
        return billInfo;
    }

    private PaymentTypeInfo getAPaymentTypeInfo(Context ctx) throws BOSException, EASBizException {
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeInfo aPaymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        return aPaymentTypeInfo;
    }

    private IObjectValue createNewDetailData(boolean isUseAgent) throws BOSException, EASBizException {
        BigDecimal ZERO = BigDecimal.ZERO;
        SaleIssueEntryInfo entryInfo = null;
        entryInfo = isUseAgent ? SaleIssueEntryAgent.create() : new SaleIssueEntryInfo();
        entryInfo.setId(BOSUuid.create((String)"BBC07FBE"));
        entryInfo.setActualCost(ZERO);
        entryInfo.setBaseStatus(EntryBaseStatusEnum.NULL);
        entryInfo.setUnReturnedBaseQty(ZERO);
        entryInfo.setReturnBaseQty(ZERO);
        entryInfo.setBaseQty(ZERO);
        entryInfo.setUnitActualCost(ZERO);
        entryInfo.setAssociateQty(ZERO);
        entryInfo.setUnReturnedBaseQty(ZERO);
        entryInfo.setUndeliverQty(ZERO);
        entryInfo.setUndeliverBaseQty(ZERO);
        entryInfo.setUnInQty(ZERO);
        entryInfo.setUnInBaseQty(ZERO);
        entryInfo.setTotalInWarehsQty(ZERO);
        entryInfo.setStandardCost(ZERO);
        entryInfo.setAmount(ZERO);
        entryInfo.setLocalAmount(ZERO);
        entryInfo.setLocalNonTaxAmount(ZERO);
        entryInfo.setNonTaxAmount(ZERO);
        entryInfo.setTax(ZERO);
        entryInfo.setLocalTax(ZERO);
        entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        entryInfo.setUnitActualCost(SysConstant.BIGZERO);
        entryInfo.setDiscount(SysConstant.BIGZERO);
        entryInfo.setDiscountAmount(SysConstant.BIGZERO);
        entryInfo.setUnSettleQty(SysConstant.BIGZERO);
        entryInfo.setUnSettleBaseQty(SysConstant.BIGZERO);
        entryInfo.setUnVmiSettleBaseQty(ZERO);
        entryInfo.setTotalVmiSettleBaseQty(ZERO);
        return entryInfo;
    }

    private void setIsIncomeConfirm(Context ctx, SaleIssueBillInfo info) throws BOSException {
        if (info == null || null == info.getEntry() || info.getEntry().isEmpty()) {
            return;
        }
        SaleIssueEntryInfo entryInfo = null;
        StringBuffer sqlin = new StringBuffer();
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntry().get(i);
            String saleOrderEntryId = null;
            if (null != entryInfo.getSourceBillType() && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(entryInfo.getSourceBillType().getId().toString())) {
                saleOrderEntryId = entryInfo.getSourceBillEntryId();
            } else if (null != entryInfo.getCoreBillType() && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(entryInfo.getCoreBillType().getId().toString())) {
                saleOrderEntryId = entryInfo.getSaleOrderEntry();
            }
            if (null == saleOrderEntryId) continue;
            sqlin.append("'").append(saleOrderEntryId).append("',");
        }
        if (sqlin.length() == 0) {
            return;
        }
        String in = sqlin.substring(0, sqlin.length() - 1);
        String sql = "select FID,FISINCOMECONFIRM from t_SD_saleorderentry where fid in (" + in + ")";
        HashMap<String, String> caheMap = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                caheMap.put(rs.getString("FID"), rs.getString("FISINCOMECONFIRM"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int size2 = info.getEntry().size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = info.getEntry().get(i);
            String saleOrderEntryId = null;
            if (null != entryInfo.getSourceBillType() && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(entryInfo.getSourceBillType().getId().toString())) {
                saleOrderEntryId = entryInfo.getSourceBillEntryId();
            } else if (null != entryInfo.getCoreBillType() && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(entryInfo.getCoreBillType().getId().toString())) {
                saleOrderEntryId = entryInfo.getSaleOrderEntry();
            }
            if (null == saleOrderEntryId || null == caheMap.get(saleOrderEntryId)) continue;
            String s = (String)caheMap.get(saleOrderEntryId);
            if ("1".equals(s)) {
                entryInfo.setIsIncomeConfirm(true);
                continue;
            }
            if (!"0".equals(s)) continue;
            entryInfo.setIsIncomeConfirm(false);
        }
    }

    private void saveMaterialSN4ConsignSVirtualBill(Context ctx, Map settledEntriesMap, SaleIssueBillInfo info) throws BOSException, EASBizException {
        CoreBaseCollection msCols = new CoreBaseCollection();
        MaterialSerialNumberInfo msInfo = null;
        MaterialSerialNumberEntryInfo msEntry = null;
        SaleIssueEntryCollection entryColls = null;
        SaleIssueEntryInfo entry = null;
        String sourceEntryId = null;
        ConsignSaleBillEntryInfo cEntry = null;
        List snList = null;
        entryColls = info.getEntry();
        for (int j = 0; j < entryColls.size(); ++j) {
            entry = entryColls.get(j);
            sourceEntryId = entry.getSourceBillEntryId();
            cEntry = (ConsignSaleBillEntryInfo)settledEntriesMap.get(sourceEntryId);
            snList = (List)cEntry.get("snList");
            if (snList == null || snList.size() == 0) continue;
            msInfo = new MaterialSerialNumberInfo();
            msInfo.setBillID(info.getId().toString());
            msInfo.setBillEntryID(entry.getId().toString());
            msInfo.setBillNumber(info.getNumber());
            msInfo.setBillEntrySeq(entry.getSeq());
            msInfo.setBillType(info.getBillType());
            msInfo.setIsReversed(info.isIsReversed());
            msInfo.setBillBizDate(info.getBizDate());
            msInfo.setBillBaseStatus(info.getBaseStatus());
            msInfo.setMaterial(entry.getMaterial());
            msInfo.setSnUnit(entry.getUnit());
            msInfo.setSnQty(entry.getQty());
            msInfo.setWarehouse(entry.getWarehouse());
            msInfo.setLocation(entry.getLocation());
            msInfo.setStorageOrgUnit(info.getStorageOrgUnit());
            msInfo.setTransactionType(info.getTransactionType());
            for (int k = 0; k < snList.size(); ++k) {
                msEntry = new MaterialSerialNumberEntryInfo();
                msEntry.setParent(msInfo);
                msEntry.setSerialNumber((String)snList.get(k));
                msEntry.setSeq(k + 1);
                msInfo.getEntry().add(msEntry);
            }
            msCols.add((CoreBaseInfo)msInfo);
        }
        if (msCols.size() > 0) {
            MaterialSerialNumberFactory.getLocalInstance(ctx).addnewBatchData(msCols);
        }
    }
}

