/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.myeas.PersonalParamFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.credit.CreditControlFacadeFactory;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.app.AbstractSaleIssueBillEditUIHandler;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;

public class SaleIssueBillEditUIHandler
extends AbstractSaleIssueBillEditUIHandler {
    @Override
    protected void _handleActionCalculateLot(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionOffset(RequestContext request, ResponseContext response, Context context) throws Exception {
        String id = request.getId();
        if (id != null) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SaleIssueBillInfo value = (SaleIssueBillInfo)SaleIssueBillFactory.getLocalInstance(context).getValue((IObjectPK)pk, request.getSelectorItemCollection());
            request.setValue((CoreBaseInfo)value);
        }
        this.fetchData(request, response, context);
        this.fillCurrentPeriod(request, response, context);
        this.fillDefaultBillType(request, response, context);
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSplitBill(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddNew(request, response, context);
    }

    @Override
    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAudit(request, response, context);
        this.fillParamValue(request, response, context);
        this.fillSaleOrgBySou(request, response, context);
        this.fillSaleOrgColBySou(request, response, context);
        SaleIssueBillInfo ivbInfo = (SaleIssueBillInfo)request.getValue();
        this.fillAdminOrgUnitInfo(ivbInfo.getStorageOrgUnit(), response, context);
        this.fillInitFiledProperty(request, response, context);
        this.fillPersonalParam(request, response, context);
    }

    @Override
    protected void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCopy(request, response, context);
        this.fillInitFiledProperty(request, response, context);
    }

    protected void _handleActionCreateFrom(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCreateFrom(request, response, context);
    }

    protected void _handleActionMaterialView(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionMaterialView(request, response, context);
        this.fillDefaultTransactionType(request, response, context);
    }

    @Override
    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNext(request, response, context);
        this.fillInitFiledProperty(request, response, context);
    }

    @Override
    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPre(request, response, context);
        this.fillInitFiledProperty(request, response, context);
    }

    protected void _handleActionPrint(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPrint(request, response, context);
    }

    protected void _handleActionPrintPreview(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPrintPreview(request, response, context);
    }

    protected void _handleActionQueryByMaterial(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionQueryByMaterial(request, response, context);
        this.fillDefaultTransactionType(request, response, context);
        this.fillDefaultTransactionType(request, response, context);
        String materialID = (String)request.get("SaleIssueMatID");
        if (materialID != null) {
            MaterialFactory.getLocalInstance((Context)context).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
        }
    }

    protected void _handleActionQueryGeneralInventory(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionQueryGeneralInventory(request, response, context);
    }

    @Override
    public void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionRemove(request, response, context);
        this.fillTransactionCollection(request, response, context);
    }

    @Override
    public void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
    }

    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.loadFields(request, response, context);
    }

    @Override
    protected void _handleActionSerialNumber(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSerialNumber(request, response, context);
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        this.fillSubmit(request, response, context);
    }

    protected void _handleActionTraceDown(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionTraceDown(request, response, context);
    }

    protected void _handleActionTraceUp(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionTraceUp(request, response, context);
    }

    @Override
    protected void _handleActionUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionUnAudit(request, response, context);
    }

    protected void _handleActionWorkFlowG(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionWorkFlowG(request, response, context);
    }

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        CompanyOrgUnitInfo cou;
        if (request.get("BATCH_ACTION") != null) {
            return;
        }
        if (request.getState() == null || request.getState().equals("ADDNEW")) {
            if (request.getBotpValue() != null) {
                request.setValue((CoreBaseInfo)request.getBotpValue());
            } else {
                SaleIssueBillInfo info = (SaleIssueBillInfo)SaleIssueBillFactory.getLocalInstance(context).createNewData(true);
                request.setValue((CoreBaseInfo)info);
            }
        } else {
            String id = request.getId();
            if (id != null) {
                SaleIssueBillInfo info = (SaleIssueBillInfo)SaleIssueBillFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(id), request.getSelectorItemCollection());
                request.setValue((CoreBaseInfo)info);
            }
        }
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            SaleIssueBillInfo ivbInfo = (SaleIssueBillInfo)request.getValue();
            if (ivbInfo == null) {
                return;
            }
            this.fillAdminOrgUnitInfo(ivbInfo.getStorageOrgUnit(), response, context);
        }
        ParamControlFactory.getLocalInstance((Context)context).getParamValue(null, "DISCOUNTRATEPRECISION");
        StorageOrgUnitInfo mainOrg = ((SaleIssueBillInfo)request.getValue()).getStorageOrgUnit();
        if (mainOrg != null) {
            this.getAdminOrgUnitInfo(mainOrg.getId().toString(), context);
        }
        if ((cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU")) != null && cou.getBaseCurrency() != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId().toString()));
        }
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.createNewData(request, response, context);
        SaleIssueBillInfo ivbInfo = new SaleIssueBillInfo();
        ivbInfo.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        request.setValue((CoreBaseInfo)ivbInfo);
        this.fillServerDate(response, context);
        this.fillPaymentType(request, response, context);
        this.fillAdminOrgUnitInfo(ivbInfo.getStorageOrgUnit(), response, context);
        this.fillSaleOrgBySou(request, response, context);
        this.fillSaleOrgColBySou(request, response, context);
        this.fillLocalCurrency(request, response, context);
        return request.getValue();
    }

    private void fillInitFiledProperty(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        SaleIssueBillInfo siInfo = (SaleIssueBillInfo)request.getValue();
        if (siInfo == null) {
            return;
        }
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)request.get("INV_MAIN_COU");
        if (cou != null) {
            CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        } else {
            if (siInfo.getStorageOrgUnit() == null) {
                return;
            }
            cou = InvServerUtils.getCompanyInfoForStorage(ctx, siInfo.getStorageOrgUnit());
        }
        ArrayList<MaterialInfo> materials = new ArrayList<MaterialInfo>();
        SaleIssueEntryCollection entries = siInfo.getEntry();
        int rows = entries.size();
        if (rows > 0 && cou != null) {
            for (int i = 0; i < rows; ++i) {
                MaterialInfo mi = entries.get(i).getMaterial();
                if (mi == null) continue;
                materials.add(mi);
            }
            if (materials.size() > 0) {
                StringBuffer oqlWhere = new StringBuffer();
                oqlWhere.append("select id,mateial.id,company.id where ");
                oqlWhere.append("mateial.id  in(");
                int size = materials.size();
                for (int i = 0; i < size; ++i) {
                    if (StringUtils.isEmpty((String)((MaterialInfo)materials.get(i)).getId().toString())) continue;
                    oqlWhere.append("'").append(((MaterialInfo)materials.get(i)).getId().toString()).append("',");
                }
                oqlWhere.delete(oqlWhere.length() - 1, oqlWhere.length());
                oqlWhere.append(")");
                oqlWhere.append(" and company.id = '").append(cou.getId().toString()).append("' ");
                SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getMaterialCompanyCollection(oqlWhere.toString());
            }
        }
    }

    private void fillPersonalParam(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String osql = "where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "'";
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection(osql);
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='returnOlnyRecord'");
        PersonalParamFactory.getLocalInstance((Context)ctx).getPersonalParamCollection("where user.id='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "' and paramName='f7CapitalSensitiveQuery'");
    }

    private void fillSubmit(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        SaleIssueBillInfo siInfo = (SaleIssueBillInfo)request.getValue();
        if (siInfo == null) {
            return;
        }
        if (!siInfo.isIsInitBill()) {
            CreditControlFacadeFactory.getLocalInstance((Context)ctx).verifyCreditAtSubmit((Object)siInfo);
        }
    }

    private void fillTransactionCollection(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        String bizTypeID = null;
        String srcBillTypeID = null;
        SaleIssueBillInfo ivbInfo = (SaleIssueBillInfo)request.getValue();
        if (ivbInfo == null) {
            return;
        }
        if (ivbInfo.getBizType() != null && ivbInfo.getSourceBillType() != null) {
            bizTypeID = ivbInfo.getBizType().getId().toString();
            srcBillTypeID = ivbInfo.getSourceBillType().getId().toString();
        }
        if (bizTypeID != null && srcBillTypeID != null) {
            TransactionTypeFactory.getLocalInstance((Context)ctx).getCollection("50957179-0105-1000-e000-015bc0a812fd463ED552", bizTypeID);
        }
    }

    private void fillParamValue(RequestContext request, ResponseContext response, Context ctx) throws Exception {
    }

    private void fillSaleOrgBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        SaleOrgUnitInfo info;
        SaleIssueBillInfo ivbInfo = (SaleIssueBillInfo)request.getValue();
        StorageOrgUnitInfo souInfo = ivbInfo.getStorageOrgUnit();
        if (souInfo != null && souInfo.getId() != null && (info = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(souInfo.getId().toString())) != null) {
            OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(info.getId().toString(), 2, 1);
        }
    }

    private void fillSaleOrgColBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        SaleIssueBillInfo ivbInfo = (SaleIssueBillInfo)request.getValue();
        StorageOrgUnitInfo souInfo = ivbInfo.getStorageOrgUnit();
        if (souInfo != null && souInfo.getId() != null) {
            OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(souInfo.getId().toString(), 4, 2);
        }
    }

    @Override
    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
    }

    @Override
    protected void _handleActionCalculateDynQty(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected SCMFetchDataCondition getNormalCondtion() {
        SCMFetchDataCondition condition = null;
        if (this.isFetchData()) {
            condition = super.getNormalCondtion();
            condition.setFetchCurrency(true);
            condition.setFetchDurability(true);
            condition.setFetchCouBySou(true);
            condition.setFetchSaleOrgBySou(true);
            condition.setFetchCouBySaleOrg(true);
            condition.setFetchSaleOrgsBySou(true);
            condition.setFetchParamValue(true);
            condition.setFetchSaleOrgsByCou(true);
        }
        return condition;
    }

    @Override
    protected void _handleActionViewWriteOffRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void setConditionContents(InvBillBaseInfo invbInfo, SCMFetchDataCondition condition, CompanyOrgUnitInfo couInfo) {
        condition.setCurrency(((SaleIssueBillInfo)invbInfo).getCurrency());
        if (invbInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            condition.setFetchInventoryUnit(false);
            condition.setFetchMaterialCompany(false);
            condition.setFetchDefaultWarehouse(false);
            condition.setFetchDefaultLocation(false);
            condition.setFetchBaseUnit(false);
            condition.setFetchAssistUnit(false);
        }
        super.setConditionContents(invbInfo, condition, couInfo);
    }
}

