/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityCollection;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityFactory;
import com.kingdee.eas.scm.im.inv.DateOfMinDurabilityInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitTypeEnum;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SaleIssueImport
extends InvDataImport {
    SaleIssueBillInfo saleIssueBillInfo = null;
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    private static final String[] QTY_PROPERTY = new String[]{"qty"};
    private static final String[] ASSISTQTY_PROPERTY = new String[]{"assistQty"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT = new String[]{"entryQTY", "assistQty", "actualCost", "entry.discountAmount", "entry.amount", "entry.localAmount", "entry.tax", "entry.localTax", "entry.taxAmount", "entry.localTaxAmount"};
    private static final String[] DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT_KEY = new String[]{"qty", "assistQty", "actualCost", "discountAmount", "nonTaxAmount", "localNonTaxAmount", "tax", "localTax", "amount", "localAmount"};
    private static final String[] DECIMAL_ENTRY_PRICE_PROPERTY = new String[]{"unitActualCost", "entry.price", "entry.taxRate", "entry.taxPrice", "entry.discount", "entry.actualPrice", "entry.actualTaxPrice"};
    private static final String[] DECIMAL_ENTRY_PRICE_PROPERTY_KEY = new String[]{"unitActualCost", "salePrice", "taxRate", "taxPrice", "discount", "actualPrice", "price"};
    private final String[] priceFields = new String[]{"unitActualCost", "taxPrice", "salePrice", "actualPrice", "price", "actualTaxPrice"};
    private final String[] amountFields = new String[]{"actualCost", "discountAmount", "nonTaxAmount", "tax", "amount"};
    private final String[] localAmountFields = new String[]{"localNonTaxAmount", "localTax", "localAmount"};
    private static final String[] DATE_BILL_PROPERTY = new String[]{"bizDate", "createTime"};
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    private static String resources = "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource";
    StorageOrgUnitInfo sou = null;
    ExchangeRateInfo exchangeRateInfo = null;
    TransactionTypeInfo tti = null;
    CompanyOrgUnitInfo cou = null;
    ImportDataCache dataPool = new ImportDataCache();
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleIssueBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.saleIssueBillInfo = null;
        super.getMainField();
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.saleIssueBillInfo = this.transmitHead(lineData, ctx);
                    if (this.saleIssueBillInfo == null) {
                        return null;
                    }
                    this.afterBuildHead(ctx, this.saleIssueBillInfo, lineData);
                }
                catch (TaskExternalException ex) {
                    tex.addEntryErrorReason(i, ex.getMessage());
                    this.recycleNumber(ctx, this.saleIssueBillInfo);
                    break;
                }
            }
            try {
                SaleIssueEntryInfo entry = this.transmitEntry(lineData, ctx);
                int seq = this.saleIssueBillInfo.getEntry().size() + 1;
                entry.setSeq(seq);
                entry.setParent(this.saleIssueBillInfo);
                entry.setStorageOrgUnit(this.sou);
                entry.setCompanyOrgUnit(this.cou);
                this.setValueByPresent(entry);
                this.afterBuildEntry(ctx, this.saleIssueBillInfo, entry, lineData);
                this.saleIssueBillInfo.getEntry().add(entry);
                continue;
            }
            catch (TaskExternalException ex) {
                tex.addEntryErrorReason(i, ex.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.saleIssueBillInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() == 0) {
            try {
                new SaleIssueAlgorithmForInfo(this.saleIssueBillInfo, ctx).calTotalFields();
            }
            catch (BOSException ex) {
                tex.addEntryErrorReason(0, ex.getMessage());
            }
            catch (EASBizException ex) {
                tex.addEntryErrorReason(0, ex.getMessage());
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.saleIssueBillInfo;
    }

    private SaleIssueBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        block31: {
            this.saleIssueBillInfo = new SaleIssueBillInfo();
            for (int i = 0; i < DATE_BILL_PROPERTY.length; ++i) {
                Object date = ((DataToken)lineData.get((Object)SaleIssueImport.DATE_BILL_PROPERTY[i])).data;
                if (date != null && date.toString().length() > 0) {
                    if ((date = ImRptAppUtils.formatNationalDate(ctx, date.toString())) == null || !(date instanceof Date)) continue;
                    this.saleIssueBillInfo.setDate(DATE_BILL_PROPERTY[i], (Date)date);
                    continue;
                }
                if (!DATE_BILL_PROPERTY[i].equals("bizDate")) continue;
                throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)resources) + date.toString());
            }
            DataToken descriptionObj = (DataToken)lineData.get("FDescription");
            if (descriptionObj != null && descriptionObj.data != null && descriptionObj.data.toString().trim().length() > 0) {
                String DeTemp = (String)descriptionObj.data;
                if (DeTemp.length() > 80) {
                    DeTemp = DeTemp.substring(0, 80);
                }
                this.saleIssueBillInfo.setDescription(DeTemp);
            } else {
                this.saleIssueBillInfo.setDescription("");
            }
            try {
                this.loadStorageOrgUnit(lineData, ctx, "number", "storageOrgUnit");
            }
            catch (Exception e_number) {
                try {
                    this.loadStorageOrgUnit(lineData, ctx, "name", "storageOrgUnitName");
                }
                catch (Exception e_name) {
                    throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
                }
            }
            try {
                this.loadBizType(lineData, ctx, "number", "FBizType_number");
            }
            catch (Exception e_number) {
                try {
                    this.loadBizType(lineData, ctx, "name", "FBizType_name_l2");
                }
                catch (Exception e_name) {
                    throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
                }
            }
            try {
                this.loadTransaction(lineData, ctx, "number", "transactionType");
            }
            catch (Exception e_number) {
                try {
                    this.loadTransaction(lineData, ctx, "name", "transactionTypeName");
                }
                catch (Exception e_name) {
                    throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
                }
            }
            Object customerObj = ((DataToken)lineData.get((Object)"customer")).data;
            CustomerInfo customer = this.getCustomer(ctx, customerObj);
            if (customer == null) {
                throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"SendCustomerNotExists", (String)resources));
            }
            this.saleIssueBillInfo.setCustomer(customer);
            Object adminOrgUnitObj = ((DataToken)lineData.get((Object)"adminOrgUnit")).data;
            AdminOrgUnitInfo adminOrgUnit = this.getAdminOrgUnit(ctx, "number", adminOrgUnitObj);
            this.saleIssueBillInfo.setAdminOrgUnit(adminOrgUnit);
            this.setPaymentType(lineData, ctx);
            try {
                Object souData = ((DataToken)lineData.get((Object)"isInitBill")).data;
                if (souData != null && souData.toString().trim().length() > 0) {
                    if ("true".equals(souData) || "\u662f".equals(souData) || "YES".equals(souData) || "yes".equals(souData)) {
                        this.saleIssueBillInfo.setIsInitBill(true);
                    }
                } else {
                    this.saleIssueBillInfo.setIsInitBill(false);
                }
            }
            catch (Exception e) {
                this.saleIssueBillInfo.setIsInitBill(false);
            }
            try {
                this.saleIssueBillInfo.setCU(this.sou.getCU());
                this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
                Object number = ((DataToken)lineData.get((Object)"creator")).data;
                UserInfo creator = this.getCreator(ctx, number);
                this.saleIssueBillInfo.setCreator(creator);
                if (this.saleIssueBillInfo.getCreateTime() == null) {
                    this.saleIssueBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
                }
                this.saleIssueBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                this.doCurrency(ctx, lineData);
                this.doExchangeRate(ctx, lineData);
                try {
                    Object souData = ((DataToken)lineData.get((Object)"isInTax")).data;
                    if (souData != null && souData.toString().trim().length() > 0) {
                        if ("true".equals(souData) || "\u662f".equals(souData) || "YES".equals(souData) || "yes".equals(souData)) {
                            this.saleIssueBillInfo.setIsInTax(true);
                        } else {
                            this.saleIssueBillInfo.setIsInTax(false);
                        }
                        break block31;
                    }
                    this.saleIssueBillInfo.setIsInTax(true);
                }
                catch (Exception e) {
                    this.saleIssueBillInfo.setIsInTax(false);
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        aBillTypeInfo.setNumber("102");
        this.saleIssueBillInfo.setBillType(aBillTypeInfo);
        return this.saleIssueBillInfo;
    }

    private void setPaymentType(Map lineData, Context ctx) throws TaskExternalException {
        try {
            PaymentTypeInfo aou;
            PaymentTypeCollection collection;
            Object souData = ((DataToken)lineData.get((Object)"paymentTypeName")).data;
            if (souData != null && souData.toString().trim().length() > 0) {
                IPaymentType isou = PaymentTypeFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)souData.toString().trim(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                collection = isou.getPaymentTypeCollection(viewInfo);
                aou = new PaymentTypeInfo();
                if (collection == null || collection.size() <= 0) {
                    throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"payType_NotExist", (String)resources));
                }
            } else {
                throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"payType_Notnull", (String)resources));
            }
            aou = collection.get(0);
            this.saleIssueBillInfo.setPaymentType(aou);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public static SaleBackProfitTypeEnum getSaleBackProfitTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value != null) {
            if (SaleIssueImport.EnumEqualByAlias(value, (Enum)SaleBackProfitTypeEnum.CUSTOMER)) {
                return SaleBackProfitTypeEnum.CUSTOMER;
            }
            throw new TaskExternalException(DataImportTools.getResString((String)"SaleBackProfitTypeError", (Context)ctx));
        }
        return null;
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }

    private EntityViewInfo getFilterByName(String name) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)name, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal assistQty;
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "bizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            this.putTable(result, "transactionType", rs.getString("transactionType.number"));
            this.putTable(result, "transactionTypeName", rs.getString("transactionType.name"));
            this.putTable(result, "customer", rs.getString("customer.number"));
            this.putTable(result, "storageOrgUnit", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "storageOrgUnitName", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "adminOrgUnit", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "paymentTypeName", rs.getString("paymentType.name"));
            this.putTable(result, "isInitBill", rs.getString("isInitBill"));
            this.putTable(result, "material", rs.getString("material.number"));
            this.putTable(result, "materialModel", rs.getString("material.model"));
            this.putTable(result, "materialName", rs.getString("material.name"));
            this.putTable(result, "assistProperty", rs.getString("assistProperty.number"));
            this.putTable(result, "entryLOT", rs.getString("entry.lot"));
            this.putTable(result, "entryMFG", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.mfg")));
            this.putTable(result, "entryEXP", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("entry.exp")));
            this.putTable(result, "unit", rs.getString("unit.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString().length() < 1) {
                result.put("entryQTY", DataImportUtils.transformValue(null));
            } else {
                BigDecimal qty = new BigDecimal(rs.getString("entry.qty"));
                result.put("entryQTY", ImRptAppUtils.fmtDecimalStr(ctx, qty));
            }
            this.putTable(result, "assistUnit", rs.getString("assistUnit.number"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")).toString().length() < 1) {
                result.put("assistQty", DataImportUtils.transformValue(null));
            } else {
                assistQty = new BigDecimal(rs.getString("entry.assistQty"));
                result.put("assistQty", ImRptAppUtils.fmtDecimalStr(ctx, assistQty));
            }
            this.putTable(result, "warehouse", rs.getString("warehouse.number"));
            this.putTable(result, "stocker", rs.getString("stocker.number"));
            this.putTable(result, "location", rs.getString("location.number"));
            this.putTable(result, "isPresent", rs.getString("entry.isPresent"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.unitActualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.unitActualCost")).toString().length() < 1) {
                result.put("unitActualCost", DataImportUtils.transformValue(null));
            } else {
                assistQty = new BigDecimal(rs.getString("entry.unitActualCost"));
                result.put("unitActualCost", ImRptAppUtils.fmtDecimalStr(ctx, assistQty));
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.actualCost")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.actualCost")).toString().length() < 1) {
                result.put("actualCost", DataImportUtils.transformValue(null));
            } else {
                assistQty = new BigDecimal(rs.getString("entry.actualCost"));
                result.put("actualCost", ImRptAppUtils.fmtDecimalStr(ctx, assistQty));
            }
            this.putTable(result, "orderNumber", rs.getString("entry.orderNumber"));
            this.putTable(result, "remark", rs.getString("entry.remark"));
            this.putTable(result, "saleOrgUnit", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "saleGroup", rs.getString("saleGroup.number"));
            this.putTable(result, "salePerson", rs.getString("salePerson.number"));
            this.putTable(result, "balanceCustomer", rs.getString("balanceCustomer.number"));
            this.putTable(result, "orderCustomer", rs.getString("orderCustomer.number"));
            this.putTable(result, "paymentCustomer", rs.getString("paymentCustomer.number"));
            this.putTable(result, "sendAddress", rs.getString("entry.sendAddress"));
            this.putTable(result, "creator", rs.getString("creator.number"));
            this.putTable(result, "createTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("createTime")));
            this.putTable(result, "currency", rs.getString("currency.number"));
            this.putTable(result, "exchangeRate", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("exchangeRate")));
            this.putTable(result, "convertMode", rs.getString("convertMode"));
            this.putTable(result, "isInTax", rs.getString("isInTax"));
            this.putTable(result, "totalTaxAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("totalTaxAmount")));
            this.putTable(result, "totalLocalTaxAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("totalLocalTaxAmount")));
            this.putTable(result, "entry.price", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.salePrice")));
            this.putTable(result, "entry.taxRate", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.taxRate")));
            this.putTable(result, "entry.taxPrice", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.taxPrice")));
            this.putTable(result, "entry.discountType", rs.getString("entry.discountType"));
            this.putTable(result, "entry.discountAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.discountAmount")));
            this.putTable(result, "entry.discount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.discount")));
            this.putTable(result, "entry.actualPrice", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.actualPrice")));
            this.putTable(result, "entry.actualTaxPrice", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.price")));
            this.putTable(result, "entry.amount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.nonTaxAmount")));
            this.putTable(result, "entry.localAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.localNonTaxAmount")));
            this.putTable(result, "entry.tax", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.tax")));
            this.putTable(result, "entry.localTax", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.localTax")));
            this.putTable(result, "entry.taxAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.amount")));
            this.putTable(result, "entry.localTaxAmount", ImRptAppUtils.fmtDecimalStr(ctx, rs.getString("entry.localAmount")));
            if (rs.getString("project.number") != null) {
                this.putTable(result, "entry.projectNumber", rs.getString("project.number"));
            }
            if (rs.getString("trackNumber.number") != null) {
                this.putTable(result, "entry.trackNumber", rs.getString("trackNumber.number"));
            }
            if (rs.getString("invUpdateType.number") != null) {
                this.putTable(result, "FInvUpdateType_number", rs.getString("invUpdateType.number"));
            }
            if (rs.getString("invUpdateType.name") != null) {
                this.putTable(result, "FInvUpdateType_name_l2", rs.getString("invUpdateType.name"));
            }
            this.putTable(result, "FEntry_isIncomeConfirm", rs.getString("entry.isIncomeConfirm"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "saleissue_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.SaleIssueBillQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public static IsUseableEnum getIsUseableEnum(String value, Context ctx) throws TaskExternalException {
        if (value != null && value.length() > 0) {
            if (SaleIssueImport.enumCompareByAlias(value, (Enum)IsUseableEnum.UnUseable)) {
                return IsUseableEnum.UnUseable;
            }
            if (SaleIssueImport.enumCompareByAlias(value, (Enum)IsUseableEnum.Useable)) {
                return IsUseableEnum.Useable;
            }
        }
        return IsUseableEnum.UnUseable;
    }

    public static boolean enumCompareByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }

    public static boolean getBooleanValue(String value, Context ctx) throws TaskExternalException {
        if (SaleIssueImport.enumCompareByAlias(value, (Enum)UpdataStorageEnum.YES)) {
            return true;
        }
        if (SaleIssueImport.enumCompareByAlias(value, (Enum)UpdataStorageEnum.NO)) {
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SaleIssueEntryInfo transmitEntry(Map hsData, Context ctx) throws TaskExternalException {
        StringBuffer errorString;
        SaleIssueEntryInfo entryInfo;
        block79: {
            ProjectCollection coll;
            FilterInfo filter2;
            FilterInfo filter;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            String number;
            Object data;
            block78: {
                if (hsData == null) {
                    return null;
                }
                entryInfo = new SaleIssueEntryInfo();
                MaterialInfo materialInfo = new MaterialInfo();
                MeasureUnitInfo mui = new MeasureUnitInfo();
                MaterialCompanyInfoInfo materialCompanyInfo = null;
                MaterialInventoryInfo materialInventory = null;
                int pricePrecision = 0;
                this.sou = this.saleIssueBillInfo.getStorageOrgUnit();
                errorString = new StringBuffer();
                this.checkNumberAndAmount(entryInfo, ctx, hsData, DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT_KEY, DECIMAL_ENTRY_PRICE_PROPERTY_KEY, true);
                try {
                    String value;
                    CustomerInfo customer;
                    MultiMeasureUnitInfo mmu;
                    int i;
                    String number2 = null;
                    Object data2 = ((DataToken)hsData.get((Object)"material")).data;
                    if (data2 == null || data2.toString().length() <= 0) throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                    number2 = data2.toString();
                    if (number2 != null && number2.trim().length() > 0) {
                        if (this.dataPool.getMaterialInfoInfo(number2) == null) {
                            IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                            MaterialCollection collection = imaterial.getMaterialCollection(this.getFilter(number2));
                            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data2.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                            MaterialInfo info = collection.get(0);
                            if (info == null) throw new TaskExternalException(data2.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"MaterialNotExists", (String)resources));
                            entryInfo.setMaterial(info);
                            materialInfo = info;
                            this.dataPool.setMaterialInfo(number2, materialInfo);
                            pricePrecision = materialInfo.getPricePrecision();
                            materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialInfo.getId().toString(), this.sou.getId().toString());
                            if (materialInventory == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + " " + this.sou.getNumber() + " " + SaleIssueImport.getResource((Context)ctx, (String)"NO_INVENTORY_PROPERTY", (String)resources));
                            }
                            this.dataPool.setMaterialInventoryInfo(number2, materialInventory);
                            materialCompanyInfo = imaterial.getCompanyInfo(materialInfo.getId().toString(), this.cou.getId().toString());
                            if (materialCompanyInfo == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + " " + this.cou.getNumber() + " " + SaleIssueImport.getResource((Context)ctx, (String)"NO_COMPANY_PROPERTY", (String)resources));
                            }
                            this.dataPool.setMaterialCompanyInfoInfo(number2, materialCompanyInfo);
                        } else {
                            materialInfo = this.dataPool.getMaterialInfoInfo(number2);
                            pricePrecision = materialInfo.getPricePrecision();
                            materialInventory = this.dataPool.getMaterialInventoryInfo(number2);
                            materialCompanyInfo = this.dataPool.getMaterialCompanyInfoInfo(number2);
                            entryInfo.setMaterial(materialInfo);
                        }
                    }
                    this.doEntryQty(hsData, ctx, entryInfo);
                    data2 = ((DataToken)hsData.get((Object)"entryLOT")).data;
                    if (this.checkLotInfo(ctx, materialInfo, data2, this.sou, entryInfo, materialInventory)) {
                        entryInfo.setLot(null);
                    } else {
                        entryInfo.setLot(data2.toString().trim());
                    }
                    if (data2 == null || data2.toString() == null || data2.toString().trim().length() == 0) {
                        entryInfo.setLot(null);
                    } else {
                        entryInfo.setLot(data2.toString().trim());
                    }
                    String mid = entryInfo.getMaterial().getId().toString();
                    if (materialInventory.isIsPeriodValid()) {
                        String lot = ((DataToken)hsData.get((Object)"entryLOT")).data.toString();
                        if (this.dataPool.getDateOfMinDurabilityInfo(mid + lot) == null) {
                            EntityViewInfo view = new EntityViewInfo();
                            FilterInfo filterInfo = new FilterInfo();
                            filterInfo.getFilterItems().add(new FilterItemInfo("lot", (Object)lot, CompareType.EQUALS));
                            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)mid, CompareType.EQUALS));
                            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)this.sou.getId().toString(), CompareType.EQUALS));
                            view.setFilter(filterInfo);
                            DateOfMinDurabilityCollection dateCol = null;
                            try {
                                dateCol = DateOfMinDurabilityFactory.getLocalInstance(ctx).getDateOfMinDurabilityCollection(view);
                            }
                            catch (BOSException e) {
                                throw new TaskExternalException(e.getMessage(), e.getCause());
                            }
                            if (dateCol != null && dateCol.size() > 0) {
                                DateOfMinDurabilityInfo dateInfo = dateCol.get(0);
                                entryInfo.setMfg(dateInfo.getMfg());
                                entryInfo.setExp(dateInfo.getExp());
                                this.dataPool.setDateOfMinDurabilityInfo(mid + lot, dateInfo);
                            } else {
                                String[] DATE_ENTRY_PROPERTY = new String[]{"entryMFG", "entryEXP"};
                                for (i = 0; i < DATE_ENTRY_PROPERTY.length; ++i) {
                                    Date value2;
                                    Object o = ((DataToken)hsData.get((Object)DATE_ENTRY_PROPERTY[i])).data;
                                    if (o == null || o.toString().length() <= 0 || (o = ImRptAppUtils.formatNationalDate(ctx, o.toString())) == null || !(o instanceof Date) || (value2 = (Date)o) == null || !materialInventory.isIsPeriodValid()) continue;
                                    if (i == 0) {
                                        entryInfo.setMfg(value2);
                                        continue;
                                    }
                                    entryInfo.setExp(value2);
                                }
                            }
                        } else {
                            DateOfMinDurabilityInfo dateInfo = this.dataPool.getDateOfMinDurabilityInfo(mid + lot);
                            entryInfo.setMfg(dateInfo.getMfg());
                            entryInfo.setExp(dateInfo.getExp());
                        }
                        if (entryInfo.getExp() == null || entryInfo.getMfg() == null) {
                            throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"IsPeriodValidNoExpandMfg", (String)resources));
                        }
                    }
                    data2 = ((DataToken)hsData.get((Object)"assistProperty")).data;
                    this.checkMaterialInfo(ctx, materialInfo, data2, 3);
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        if (this.dataPool.getAsstAttrValueInfo(materialInfo.getId() + number2) == null) {
                            if (materialInfo != null && materialInfo.getAssistAttr() != null) {
                                IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                                String oql = "";
                                oql = "select id,number,name where number='" + number2 + "' and (compondingType.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "' or basictype.id = '" + entryInfo.getMaterial().getAssistAttr().getId().toString() + "')";
                                AsstAttrValueCollection collection = iasstAttrValue.getAsstAttrValueCollection(oql);
                                if (collection == null || collection.size() <= 0) throw new TaskExternalException(number2 + SaleIssueImport.getResource((Context)ctx, (String)"AsstAttrValueExists", (String)resources));
                                AsstAttrValueInfo info = collection.get(0);
                                if (info != null) {
                                    entryInfo.setAssistProperty(info);
                                    this.dataPool.setAsstAttrValueInfo(materialInfo.getId() + number2, info);
                                }
                            }
                        } else {
                            AsstAttrValueInfo info = this.dataPool.getAsstAttrValueInfo(materialInfo.getId() + number2);
                            entryInfo.setAssistProperty(info);
                        }
                    }
                    data2 = ((DataToken)hsData.get((Object)"warehouse")).data;
                    WarehouseInfo warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data2);
                    entryInfo.setWarehouse(warehouseInfo);
                    data2 = ((DataToken)hsData.get((Object)"location")).data;
                    LocationInfo location = this.getLocation(ctx, data2, warehouseInfo);
                    entryInfo.setLocation(location);
                    data2 = ((DataToken)hsData.get((Object)"stocker")).data;
                    if (data2 != null && StringUtils.isNotBlank((CharSequence)data2.toString())) {
                        PersonInfo stocker = this.getPerson(ctx, data2, resources, "stockerNotExists");
                        entryInfo.setStocker(stocker);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"unit")).data) == null || StringUtils.isBlank((CharSequence)data2.toString())) {
                        throw new TaskExternalException(SaleIssueImport.getResource((Context)ctx, (String)"UnitCanNotBeNull", (String)resources));
                    }
                    number2 = data2.toString();
                    MeasureUnitInfo measureUnitInfo = this.getMeasureUnitByNumber(ctx, number2);
                    if (measureUnitInfo == null) {
                        throw new TaskExternalException(data2.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
                    }
                    entryInfo.setUnit(measureUnitInfo);
                    mui = measureUnitInfo;
                    if (entryInfo.getUnit() != null && (mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), entryInfo.getUnit().getId().toString())) != null) {
                        int qtyPrecision = mmu.getQtyPrecision();
                        for (i = 0; i < QTY_PROPERTY.length; ++i) {
                            if (entryInfo.getBigDecimal(QTY_PROPERTY[i]) == null) continue;
                            entryInfo.setBigDecimal(QTY_PROPERTY[i], entryInfo.getBigDecimal(QTY_PROPERTY[i]).setScale(qtyPrecision, 4));
                        }
                    }
                    entryInfo.setAssistUnit(materialInfo.getAssistUnit());
                    if (entryInfo.getAssistUnit() != null) {
                        entryInfo.setAssistQty((BigDecimal)entryInfo.get("assistQty"));
                    } else {
                        entryInfo.setAssistQty(ZERO);
                    }
                    data2 = ((DataToken)hsData.get((Object)"orderNumber")).data;
                    if (data2 != null) {
                        String orderNumber = data2.toString().length() <= 80 ? data2.toString() : data2.toString().substring(0, 80);
                        entryInfo.setOrderNumber(orderNumber);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"remark")).data) != null) {
                        String remark = data2.toString().length() <= 255 ? data2.toString() : data2.toString().substring(0, 255);
                        entryInfo.setRemark(remark);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"sendAddress")).data) != null) {
                        String sendAddress = data2.toString().length() <= 255 ? data2.toString() : data2.toString().substring(0, 255);
                        entryInfo.setSendAddress(sendAddress);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"saleOrgUnit")).data) != null && StringUtils.isNotBlank((CharSequence)data2.toString())) {
                        number2 = data2.toString();
                        SaleOrgUnitInfo saleOrgUnit = this.getSaleOrgUnit(ctx, "number", number2);
                        entryInfo.setSaleOrgUnit(saleOrgUnit);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"saleGroup")).data) != null && StringUtils.isNotBlank((CharSequence)data2.toString())) {
                        number2 = data2.toString();
                        SaleGroupInfo saleGroup = this.dataPool.getSaleGroup(number2);
                        if (saleGroup == null) {
                            SaleGroupCollection collection = SaleGroupFactory.getLocalInstance((Context)ctx).getSaleGroupCollection(this.getFilter(number2));
                            if (collection == null || collection.size() == 0 || collection.get(0) == null) {
                                throw new TaskExternalException(data2.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"saleGroupNotExists", (String)resources));
                            }
                            saleGroup = collection.get(0);
                            this.dataPool.setSaleGroup(number2, saleGroup);
                        }
                        entryInfo.setSaleGroup(saleGroup);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"salePerson")).data) != null && StringUtils.isNotBlank((CharSequence)data2.toString())) {
                        PersonInfo salePerson = this.getPerson(ctx, data2, resources, "salePersonNotExists");
                        entryInfo.setSalePerson(salePerson);
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"balanceCustomer")).data) != null) {
                        number2 = data2.toString();
                        if (StringUtils.isNotBlank((CharSequence)number2)) {
                            customer = this.getCustomer(ctx, data2);
                            entryInfo.setBalanceCustomer(customer);
                        } else {
                            entryInfo.setBalanceCustomer(this.saleIssueBillInfo.getCustomer());
                        }
                    }
                    entryInfo.setOrderCustomer(this.saleIssueBillInfo.getCustomer());
                    data2 = ((DataToken)hsData.get((Object)"paymentCustomer")).data;
                    if (data2 != null) {
                        number2 = data2.toString();
                        if (StringUtils.isNotBlank((CharSequence)number2)) {
                            customer = this.getCustomer(ctx, data2);
                            entryInfo.setPaymentCustomer(customer);
                        } else {
                            entryInfo.setPaymentCustomer(this.saleIssueBillInfo.getCustomer());
                        }
                    }
                    if ((data2 = ((DataToken)hsData.get((Object)"isPresent")).data) != null && data2.toString().trim().length() > 0) {
                        value = data2.toString();
                        entryInfo.setIsPresent(this.getBooleanValue(value));
                    } else {
                        entryInfo.setIsPresent(false);
                    }
                    data2 = ((DataToken)hsData.get((Object)"FEntry_isIncomeConfirm")).data;
                    if (data2 != null && data2.toString().trim().length() > 0) {
                        value = data2.toString();
                        entryInfo.setIsIncomeConfirm(this.getBooleanValue(value));
                    } else {
                        entryInfo.setIsIncomeConfirm(false);
                    }
                    data2 = ((DataToken)hsData.get((Object)"entry.discountType")).data;
                    if (data2 != null && data2.toString().trim().length() > 0) {
                        DiscountModeEnum discountType = DiscountModeEnum.getEnum((int)Integer.parseInt(data2.toString()));
                        entryInfo.setDiscountType(discountType);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                this.doEntryFilesByRI(entryInfo);
                try {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                    MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                    entryInfo.setBaseUnit(baseUnit);
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal baseQty = InvAppUtils.getBaseUnitQty(ctx, mui, baseUnit, materialInfo, qty);
                    entryInfo.setBaseQty(baseQty);
                    if (materialCompanyInfo != null) {
                        BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                        if (AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType()) && standardCost != null) {
                            BigDecimal unitstandardcost = InvAppUtils.getUnitPrice(ctx, materialInfo, standardCost, baseUnit, mui);
                            BigDecimal standardcost = unitstandardcost.multiply(entryInfo.getQty());
                            entryInfo.setUnitStandardCost(unitstandardcost);
                            entryInfo.setStandardCost(standardcost);
                            entryInfo.setUnitActualCost(unitstandardcost);
                            entryInfo.setActualCost(standardcost);
                        } else {
                            Object dataActualCost = ((DataToken)hsData.get((Object)"actualCost")).data;
                            if (dataActualCost == null || "".equals(dataActualCost.toString().trim())) {
                                dataActualCost = "0";
                            }
                            BigDecimal actualCost = ImRptAppUtils.getDataDeciaml(ctx, (String)dataActualCost);
                            BigDecimal dataUnitCost = actualCost.divide(qty, pricePrecision, 4);
                            entryInfo.setUnitActualCost(dataUnitCost.abs());
                            if (InvAppUtils.isNegative(this.saleIssueBillInfo.getTransactionType())) {
                                entryInfo.setActualCost(actualCost.abs().negate());
                            } else {
                                entryInfo.setActualCost(actualCost.abs());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    data = ((DataToken)hsData.get((Object)"entry.projectNumber")).data;
                    if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block78;
                    if (this.dataPool.getProjectNumber(number) == null) {
                        IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                        viewInfo = new EntityViewInfo();
                        status = new HashSet<Integer>();
                        status.add(new Integer(4));
                        filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                        filter2 = new FilterInfo();
                        CtrlUnitInfo cu = this.sou.getCU();
                        ObjectUuidPK cuPK = null;
                        cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                        try {
                            filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                        }
                        catch (EASBizException e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                        catch (BOSException e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                        if (filter2 != null) {
                            filter.mergeFilter(filter2, "and");
                        }
                        viewInfo.setFilter(filter);
                        coll = iProject.getProjectCollection(viewInfo);
                        if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"PROJECT_NUMBER_ERROR", (String)resources));
                        ProjectInfo projectInfo = coll.get(0);
                        this.dataPool.setProjectNumber(number, projectInfo);
                        entryInfo.setProject(projectInfo);
                        break block78;
                    }
                    entryInfo.setProject(this.dataPool.getProjectNumber(number));
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            try {
                data = ((DataToken)hsData.get((Object)"entry.trackNumber")).data;
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block79;
                if (this.dataPool.getTrackNumber(number) == null) {
                    ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    status = new HashSet();
                    status.add(new Integer(10));
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                    filter2 = new FilterInfo();
                    CtrlUnitInfo cu = this.sou.getCU();
                    ObjectUuidPK cuPK = null;
                    cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                    try {
                        filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    if (filter2 != null) {
                        filter.mergeFilter(filter2, "and");
                    }
                    viewInfo.setFilter(filter);
                    coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                    if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + SaleIssueImport.getResource((Context)ctx, (String)"TRACK_NUMBER_ERROR", (String)resources));
                    TrackNumberInfo trackNumberInfo = coll.get(0);
                    this.dataPool.setTrackNumber(number, trackNumberInfo);
                    entryInfo.setTrackNumber(trackNumberInfo);
                    break block79;
                }
                entryInfo.setTrackNumber(this.dataPool.getTrackNumber(number));
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        if (errorString.length() > 0) {
            throw new TaskExternalException(errorString.toString());
        }
        this.doEntryInvUpdateType(ctx, hsData, entryInfo);
        try {
            this.calLocalTaxAndAmount(ctx, entryInfo);
            this.checkQtyPrecision(ctx, entryInfo);
            return entryInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doEntryQty(Map lineData, Context ctx, SaleIssueEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"entryQTY")).data;
        if (data != null && data.toString().length() > 0) {
            try {
                BigDecimal qty = ImRptAppUtils.getDataDeciaml(ctx, data.toString());
                entryInfo.setQty(qty);
            }
            catch (Exception e) {
                throw new TaskExternalException(SaleIssueImport.getResource(ctx, "QTY_ERROR"));
            }
        } else {
            throw new TaskExternalException(SaleIssueImport.getResource(ctx, "QTY_ERROR"));
        }
        if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(ZERO) == 0) {
            throw new TaskExternalException(SaleIssueImport.getResource(ctx, "QTY_ERROR"));
        }
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resources, (String)strKey, (Context)ctx);
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, SaleIssueEntryInfo entryInfo, MaterialInventoryInfo materialInventory) throws TaskExternalException, BOSException, EASBizException {
        boolean isLotNumber = materialInventory.isIsLotNumber();
        if (!isLotNumber && data != null && data.toString().length() > 0) {
            return false;
        }
        if (isLotNumber && (data == null || data.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
        }
        return true;
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"NotSetAssistProperty", (String)resources));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"SetAssistProperty", (String)resources));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"NotSetAssistUnit", (String)resources));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"SetAssistUnit", (String)resources));
            }
        }
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + SaleIssueImport.getResource((Context)ctx, (String)"RelationNotExists", (String)resources));
        }
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + SaleIssueImport.getResource((Context)ctx, (String)"UnitNotExists", (String)resources));
        }
    }

    private void loadBizType(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        BizTypeInfo bizType = this.getBizType(ctx, "50957179-0105-1000-e000-015bc0a812fd463ED552", byProperty, souData);
        this.saleIssueBillInfo.setBizType(bizType);
    }

    private void loadTransaction(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        TransactionTypeInfo transactionTypeInfo;
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.tti = transactionTypeInfo = this.getTransaction(ctx, byProperty, souData, "50957179-0105-1000-e000-015bc0a812fd463ED552", this.saleIssueBillInfo.getBizType());
        this.saleIssueBillInfo.setTransactionType(this.tti);
    }

    private void loadStorageOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        String[] msgArr = new String[]{"StorageOrgUnitNotNull", "StorageOrgUnitIsNotBizUnit", "StorageOrgUnitNotExists"};
        this.sou = this.getStorageOrgUnit(ctx, byProperty, souData, resources, msgArr);
        this.saleIssueBillInfo.setStorageOrgUnit(this.sou);
    }

    private boolean getBooleanValue(String value) {
        if (value == null) {
            return false;
        }
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0") && !value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("\u5426");
    }

    private void checkNumberAndAmount(SaleIssueEntryInfo entryInfo, Context ctx, Map lineData, String[] qtyAmList, String[] priceList, boolean checkBackType) throws TaskExternalException {
        BigDecimal value;
        int i;
        for (i = 0; i < DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT.length; ++i) {
            try {
                Object o = ((DataToken)lineData.get((Object)SaleIssueImport.DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    value = ImRptAppUtils.getDataDeciaml(ctx, o.toString());
                    if (value != null) {
                        entryInfo.setBigDecimal(qtyAmList[i], value);
                        continue;
                    }
                    entryInfo.setBigDecimal(qtyAmList[i], ZERO);
                    continue;
                }
                if (DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT[i].equalsIgnoreCase(QTY_PROPERTY[0])) {
                    throw new TaskExternalException(DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT[i] + SaleIssueImport.getResource((Context)ctx, (String)"Numbercannotbenull", (String)resources));
                }
                if (DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT[i].equals(ASSISTQTY_PROPERTY[0])) continue;
                entryInfo.setBigDecimal(qtyAmList[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT[i] + SaleIssueImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
            }
        }
        for (i = 0; i < DECIMAL_ENTRY_PRICE_PROPERTY.length; ++i) {
            try {
                Object po = ((DataToken)lineData.get((Object)SaleIssueImport.DECIMAL_ENTRY_PRICE_PROPERTY[i])).data;
                if (po != null && po.toString().trim().length() > 0) {
                    value = ImRptAppUtils.getDataDeciaml(ctx, po.toString());
                    if (value != null) {
                        entryInfo.setBigDecimal(priceList[i], value);
                        continue;
                    }
                    entryInfo.setBigDecimal(priceList[i], ZERO);
                    continue;
                }
                entryInfo.setBigDecimal(priceList[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                throw new TaskExternalException(DECIMAL_ENTRY_PRICE_PROPERTY[i] + SaleIssueImport.getResource((Context)ctx, (String)"FormatMustBeNumber", (String)resources));
            }
        }
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = SaleIssueImport.getMulUnit(mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = SaleIssueImport.getMulUnit(baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException baseException) {
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    private void doEntryFilesByRI(SaleIssueEntryInfo entryInfo) {
        String entryField2 = null;
        BigDecimal value = null;
        for (String entryField2 : DECIMAL_ENTRY_PRICE_PROPERTY_KEY) {
            if (entryInfo.get(entryField2) == null) continue;
            value = (BigDecimal)entryInfo.get(entryField2);
            if (entryField2.equals("discount")) {
                entryInfo.put(entryField2, value);
                continue;
            }
            entryInfo.put(entryField2, value.abs());
        }
        boolean flag = !InvAppUtils.isNegative(this.saleIssueBillInfo.getTransactionType());
        for (String entryField2 : DECIMAL_ENTRY_PROPERTY_QTY_AMOUNT_KEY) {
            if (entryInfo.get(entryField2) == null) continue;
            if (flag) {
                value = (BigDecimal)entryInfo.get(entryField2);
                if (entryField2.equals("discountAmount")) {
                    entryInfo.put(entryField2, value);
                    continue;
                }
                entryInfo.put(entryField2, value.abs());
                continue;
            }
            value = (BigDecimal)entryInfo.get(entryField2);
            if (entryField2.equals("discountAmount")) {
                entryInfo.put(entryField2, value.negate());
                continue;
            }
            entryInfo.put(entryField2, value.abs().negate());
        }
    }

    private void setValueByPresent(SaleIssueEntryInfo entryInfo) {
        if (entryInfo == null || !entryInfo.isIsPresent()) {
            return;
        }
        String[] fields = new String[]{"price", "taxPrice", "discountAmount", "discount", "actualPrice", "actualTaxPrice", "amount", "localAmount", "tax", "localTax", "taxAmount", "localTaxAmount", "localNonTaxAmount", "localPrice", "salePrice", "nonTaxAmount", "localNonTaxAmount"};
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            entryInfo.put(fields[i], ZERO);
        }
    }

    private void doEntryInvUpdateType(Context ctx, Map lineData, SaleIssueEntryInfo entryInfo) throws TaskExternalException {
        try {
            this.loadInvUpdateType(lineData, ctx, "number", "FInvUpdateType_number", entryInfo);
        }
        catch (Exception e_number) {
            try {
                this.loadInvUpdateType(lineData, ctx, "name", "FInvUpdateType_name_l2", entryInfo);
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void loadInvUpdateType(Map lineData, Context ctx, String byProperty, String propertyName, SaleIssueEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        boolean flag;
        TransactionInvUpdateTypeCollection collections;
        InvUpdateTypeInfo invUpdateTypeInfo;
        block11: {
            boolean flag2;
            Object souData;
            block10: {
                souData = ((DataToken)lineData.get((Object)propertyName)).data;
                invUpdateTypeInfo = null;
                if (souData != null && souData.toString().trim().length() > 0) {
                    TransactionTypeInfo transInfo = this.saleIssueBillInfo.getTransactionType();
                    collections = InvCommonUtils.getTransactionInvUpdateTypeCol(ctx, this.getFilter(transInfo.getId().toString(), "transactiontype"));
                    if (this.dataPool.getInvUpdateTypeInfo(souData.toString().trim()) == null) {
                        InvUpdateTypeCollection collection = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeCollection(this.getFilter(souData.toString().trim(), byProperty));
                        if (collection != null && collection.size() > 0 && collections != null && collections.size() > 0) {
                            invUpdateTypeInfo = collection.get(0);
                            flag2 = false;
                            break block10;
                        } else {
                            String str = SaleIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                            throw new TaskExternalException(str);
                        }
                    }
                    if (collections != null && collections.size() > 0) {
                        invUpdateTypeInfo = this.dataPool.getInvUpdateTypeInfo(souData.toString().trim());
                        flag = false;
                        break block11;
                    } else {
                        String str = SaleIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
                        throw new TaskExternalException(str);
                    }
                }
                String str = SaleIssueImport.getResource((Context)ctx, (String)"InvUpdateType_isNull", (String)resources);
                throw new TaskExternalException(str);
            }
            for (int i = 0; i < collections.size(); ++i) {
                TransactionInvUpdateTypeInfo tt = collections.get(i);
                if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
                flag2 = true;
                break;
            }
            if (flag2) {
                entryInfo.setInvUpdateType(invUpdateTypeInfo);
                this.dataPool.setInvUpdateTypeMapInfo(souData.toString().trim(), invUpdateTypeInfo);
                return;
            }
            String str = SaleIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
            throw new TaskExternalException(str);
        }
        for (int i = 0; i < collections.size(); ++i) {
            TransactionInvUpdateTypeInfo tt = collections.get(i);
            if (!invUpdateTypeInfo.getId().toString().equals(tt.getInvUpdateType().getId().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
            return;
        }
        String str = SaleIssueImport.getResource((Context)ctx, (String)"InvUpdateType_NOT_EXIST", (String)resources);
        throw new TaskExternalException(str);
    }

    @Override
    public void afterBuildEntry(Context ctx, InvBillBaseInfo info, InvBillBaseEntryInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, info, entry, lineData);
        this.checkEntryValue(ctx, (SaleIssueEntryInfo)entry);
    }

    private void checkEntryValue(Context ctx, SaleIssueEntryInfo entry) throws TaskExternalException {
        BigDecimal tax = this.setNullToZero(entry.getTax());
        BigDecimal amount = this.setNullToZero(entry.getNonTaxAmount());
        BigDecimal taxAmount = this.setNullToZero(entry.getAmount());
        if (tax.add(amount).compareTo(taxAmount) != 0) {
            String str = SaleIssueImport.getResource((Context)ctx, (String)"TAXAMOUNT_NOTEQUALS_OTHERAMOUNT", (String)"com.kingdee.eas.scm.im.inv.app.PurInImportResource");
            throw new TaskExternalException(str);
        }
    }

    private SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private void calLocalTaxAndAmount(Context ctx, SaleIssueEntryInfo entry) throws EASBizException, BOSException {
        CurrencyInfo currency = this.saleIssueBillInfo.getCurrency();
        CurrencyInfo baseCurrency = this.cou.getBaseCurrency();
        int scale = baseCurrency.getPrecision();
        BigDecimal taxAmount = entry.getAmount();
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = this.saleIssueBillInfo.getExchangeRate();
        if (this.exchangeRateInfo != null && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            if (this.exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalAmount(taxAmount.divide(exchangerate, scale, 4));
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
            entry.setLocalNonTaxAmount(entry.getLocalAmount().subtract(entry.getLocalTax()));
        } else {
            entry.setLocalAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        }
    }

    protected String[] getPriceFields() {
        return this.priceFields;
    }

    protected String[] getAmountFields() {
        return this.amountFields;
    }

    protected String[] getLocalAmountFields() {
        return this.localAmountFields;
    }

    protected String getDiscountField() {
        return "discount";
    }

    protected String getTaxRateField() {
        return "taxRate";
    }

    public String getImportPermissionItem() {
        return "saleissue_new";
    }

    private void doCurrency(Context ctx, Map lineData) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)"currency")).data;
        CurrencyInfo info = null;
        if (souData != null && souData.toString().trim().length() > 0) {
            String currencyNumber = souData.toString().trim();
            if (this.dataPool.getCurrencyInfo(currencyNumber) == null) {
                CurrencyCollection currencyColl = null;
                try {
                    ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    currencyColl = iCurrency.getCurrencyCollection(this.getCurrencyFilter(currencyNumber, "number"));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (currencyColl != null && currencyColl.size() > 0) {
                    info = currencyColl.get(0);
                    this.saleIssueBillInfo.setCurrency(info);
                    this.dataPool.setCurrencyInfo(currencyNumber, info);
                }
            } else {
                info = this.dataPool.getCurrencyInfo(currencyNumber);
                this.saleIssueBillInfo.setCurrency(info);
            }
        } else {
            throw new TaskExternalException(SCMUtils.getResource((String)resources, (String)"CurrencyNotNull", (Context)ctx));
        }
        if (info == null && this.cou != null && this.cou.getBaseCurrency() != null) {
            CurrencyInfo currencyInfo = null;
            try {
                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()), this.getCurrencySelector());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            this.saleIssueBillInfo.setCurrency(currencyInfo);
        }
    }

    private EntityViewInfo getCurrencyFilter(String value, String byProperty) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)value, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(this.getCurrencySelector());
        return viewInfo;
    }

    private void doExchangeRate(Context ctx, Map lineData) throws TaskExternalException {
        try {
            CurrencyInfo currency = this.saleIssueBillInfo.getCurrency();
            if (currency != null) {
                this.exchangeRateInfo = SCMUtils.getExchangeRateInfo((Context)ctx, (CompanyOrgUnitInfo)this.cou, (CurrencyInfo)this.saleIssueBillInfo.getCurrency(), (CurrencyInfo)this.cou.getBaseCurrency(), (Date)this.saleIssueBillInfo.getBizDate());
            }
            if (currency != null && this.cou != null && this.cou.getBaseCurrency() != null && this.cou.getBaseCurrency().getId().equals((Object)currency.getId())) {
                this.saleIssueBillInfo.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
            } else {
                BigDecimal exchangeRate = null;
                if (this.exchangeRateInfo != null) {
                    this.saleIssueBillInfo.setExchangeRate(this.exchangeRateInfo.getConvertRate());
                } else {
                    Object exchangeRateData = ((DataToken)lineData.get((Object)"exchangeRate")).data;
                    if (StringUtil.isEmptyString((String)((String)exchangeRateData))) {
                        String str = SaleIssueImport.getResource(ctx, "EXCHANGERATE_NOT_NULL");
                        throw new TaskExternalException(str);
                    }
                    exchangeRate = ImRptAppUtils.getDataDeciaml(ctx, exchangeRateData.toString());
                    this.saleIssueBillInfo.setExchangeRate(exchangeRate);
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }
}

