/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractUniteBill;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class SaleIssueUniteCalculate
extends AbstractUniteBill {
    @Override
    public HashMap executeUniteBill(Context ctx, String id) throws BOSException, EASBizException {
        BigDecimal ZERO;
        HashMap msgHm = this.check(ctx, id);
        if (msgHm.containsKey("NotUniteMsg")) {
            return msgHm;
        }
        String motherBillId = (String)msgHm.get("MotherBillId");
        String childBillId = (String)msgHm.get("ChildBillId");
        ObjectUuidPK motherPK = new ObjectUuidPK(motherBillId);
        ObjectUuidPK childPK = new ObjectUuidPK(childBillId);
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        SaleIssueBillInfo motherIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)motherPK);
        SaleIssueBillInfo tempMotherIssueBillInfo = (SaleIssueBillInfo)motherIssueBillInfo.clone();
        SaleIssueBillInfo childIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)childPK);
        SaleIssueEntryCollection motherIssueEntry = motherIssueBillInfo.getEntry();
        SaleIssueEntryCollection tempMotherIssueEntry = tempMotherIssueBillInfo.getEntry();
        SaleIssueEntryCollection childIssueEntry = childIssueBillInfo.getEntry();
        ArrayList<SaleIssueEntryInfo> childEntryList = new ArrayList<SaleIssueEntryInfo>();
        BigDecimal totalQty = ZERO = new BigDecimal("0.00");
        BigDecimal totalAmount = ZERO;
        BigDecimal totalLocalAmount = ZERO;
        BigDecimal totalStandardCost = ZERO;
        BigDecimal totalActualCost = ZERO;
        motherIssueEntry.clear();
        int motherSize = tempMotherIssueEntry.size();
        for (int i = 0; i < motherSize; ++i) {
            SaleIssueEntryInfo tempMotherIssueEntryInfo = tempMotherIssueEntry.get(i);
            int childSize = childIssueEntry.size();
            for (int j = 0; j < childSize; ++j) {
                SaleIssueEntryInfo childIssueEntryInfo = childIssueEntry.get(j);
                if (!this.compareTo(tempMotherIssueEntryInfo, childIssueEntryInfo)) continue;
                this.processUniteBillEntry(ctx, tempMotherIssueEntryInfo, childIssueEntryInfo);
                childEntryList.add(childIssueEntryInfo);
                totalQty = totalQty.add(tempMotherIssueEntryInfo.getQty());
                totalAmount = totalAmount.add(tempMotherIssueEntryInfo.getAmount());
                totalLocalAmount = totalLocalAmount.add(tempMotherIssueEntryInfo.getLocalAmount());
                totalStandardCost = totalStandardCost.add(tempMotherIssueEntryInfo.getStandardCost());
                totalActualCost = totalActualCost.add(tempMotherIssueEntryInfo.getActualCost());
                motherIssueEntry.add(tempMotherIssueEntryInfo);
                childIssueEntry.remove(childIssueEntryInfo);
                break;
            }
            if (motherIssueEntry.contains(tempMotherIssueEntryInfo)) continue;
            motherIssueEntry.add(tempMotherIssueEntryInfo);
        }
        int childSize = childIssueEntry.size();
        for (int j = 0; j < childSize; ++j) {
            SaleIssueEntryInfo childIssueEntryInfo = childIssueEntry.get(j);
            childIssueEntryInfo.setSeq(motherIssueEntry.size() + 1);
            childIssueEntryInfo.setParent(motherIssueBillInfo);
            motherIssueEntry.add(childIssueEntryInfo);
            totalQty = totalQty.add(childIssueEntryInfo.getQty());
            totalAmount = totalAmount.add(childIssueEntryInfo.getAmount());
            totalLocalAmount = totalLocalAmount.add(childIssueEntryInfo.getLocalAmount());
            totalStandardCost = totalStandardCost.add(childIssueEntryInfo.getStandardCost());
            totalActualCost = totalActualCost.add(childIssueEntryInfo.getActualCost());
        }
        motherIssueBillInfo.setTotalQty(totalQty);
        motherIssueBillInfo.setTotalAmount(totalAmount);
        motherIssueBillInfo.setTotalLocalAmount(totalLocalAmount);
        motherIssueBillInfo.setTotalStandardCost(totalStandardCost);
        motherIssueBillInfo.setTotalActualCost(totalActualCost);
        this.delete(ctx, childBillId, motherBillId);
        iSaleIssueBill.addnew((CoreBaseInfo)motherIssueBillInfo);
        return msgHm;
    }

    private boolean compareTo(SaleIssueEntryInfo tempMotherIssueEntryInfo, SaleIssueEntryInfo childIssueEntryInfo) {
        boolean flag = false;
        flag = tempMotherIssueEntryInfo.getSaleOrderEntry().equals(childIssueEntryInfo.getSaleOrderEntry());
        boolean bl = flag = flag && tempMotherIssueEntryInfo.getSaleOrderEntrySeq() == childIssueEntryInfo.getSaleOrderEntrySeq();
        boolean bl2 = null != tempMotherIssueEntryInfo.getAssistProperty() ? flag && tempMotherIssueEntryInfo.getAssistProperty().equals((Object)childIssueEntryInfo.getAssistProperty()) : (flag = flag && null == childIssueEntryInfo.getAssistProperty());
        boolean bl3 = null != tempMotherIssueEntryInfo.getUnit() ? flag && tempMotherIssueEntryInfo.getUnit().equals((Object)childIssueEntryInfo.getUnit()) : (flag = flag && null == childIssueEntryInfo.getUnit());
        boolean bl4 = null != tempMotherIssueEntryInfo.getLot() ? flag && tempMotherIssueEntryInfo.getLot().equals(childIssueEntryInfo.getLot()) : (flag = flag && null == childIssueEntryInfo.getLot());
        boolean bl5 = null != tempMotherIssueEntryInfo.getMfg() ? flag && tempMotherIssueEntryInfo.getMfg().equals(childIssueEntryInfo.getMfg()) : (flag = flag && null == childIssueEntryInfo.getMfg());
        boolean bl6 = null != tempMotherIssueEntryInfo.getExp() ? flag && tempMotherIssueEntryInfo.getExp().equals(childIssueEntryInfo.getExp()) : (flag = flag && null == childIssueEntryInfo.getExp());
        boolean bl7 = null != tempMotherIssueEntryInfo.getWarehouse() ? flag && tempMotherIssueEntryInfo.getWarehouse().equals((Object)childIssueEntryInfo.getWarehouse()) : (flag = flag && null == childIssueEntryInfo.getWarehouse());
        flag = null != tempMotherIssueEntryInfo.getLocation() ? flag && tempMotherIssueEntryInfo.getLocation().equals((Object)childIssueEntryInfo.getLocation()) : flag && null == childIssueEntryInfo.getLocation();
        return flag;
    }

    private void delete(Context ctx, String childBillId, String motherBillId) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM T_IM_SplitBillRelation WHERE FChildBillId = ?");
        String deleteSplitBillRelationSQL = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_IM_SaleIssueEntry WHERE FParentID = ?");
        String deleteSaleIssueEntrySQL = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_IM_SaleIssueBill WHERE FID = ?");
        String deleteSaleIssueBillSQL = bf.toString();
        DbUtil.execute((Context)ctx, (String)deleteSplitBillRelationSQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deleteSaleIssueEntrySQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deleteSaleIssueBillSQL, (Object[])new Object[]{childBillId});
        DbUtil.execute((Context)ctx, (String)deleteSaleIssueEntrySQL, (Object[])new Object[]{motherBillId});
        DbUtil.execute((Context)ctx, (String)deleteSaleIssueBillSQL, (Object[])new Object[]{motherBillId});
    }

    private void processUniteBillEntry(Context ctx, SaleIssueEntryInfo tempMotherIssueEntryInfo, SaleIssueEntryInfo childIssueEntryInfo) throws BOSException, EASBizException {
        int precision = CalculateUtil.getLocalCurrencyPrecision2((Context)ctx, (CompanyOrgUnitInfo)tempMotherIssueEntryInfo.getCompanyOrgUnit());
        tempMotherIssueEntryInfo.setQty(tempMotherIssueEntryInfo.getQty().add(childIssueEntryInfo.getQty()));
        tempMotherIssueEntryInfo.setBaseQty(tempMotherIssueEntryInfo.getBaseQty().add(childIssueEntryInfo.getBaseQty()));
        tempMotherIssueEntryInfo.setActualCost(tempMotherIssueEntryInfo.getQty().multiply(tempMotherIssueEntryInfo.getUnitActualCost()).setScale(precision));
        tempMotherIssueEntryInfo.setStandardCost(tempMotherIssueEntryInfo.getQty().multiply(tempMotherIssueEntryInfo.getUnitStandardCost()).setScale(precision));
        tempMotherIssueEntryInfo.setWrittenOffQty(tempMotherIssueEntryInfo.getWrittenOffQty().add(childIssueEntryInfo.getWrittenOffQty()));
        tempMotherIssueEntryInfo.setWrittenOffBaseQty(tempMotherIssueEntryInfo.getWrittenOffBaseQty().add(childIssueEntryInfo.getWrittenOffBaseQty()));
        tempMotherIssueEntryInfo.setUnWriteOffQty(tempMotherIssueEntryInfo.getUnWriteOffQty().add(childIssueEntryInfo.getUnWriteOffQty()));
        tempMotherIssueEntryInfo.setUnWriteOffBaseQty(tempMotherIssueEntryInfo.getUnWriteOffBaseQty().add(childIssueEntryInfo.getUnWriteOffBaseQty()));
        tempMotherIssueEntryInfo.setWrittenOffAmount(tempMotherIssueEntryInfo.getWrittenOffAmount().add(childIssueEntryInfo.getWrittenOffAmount()));
        tempMotherIssueEntryInfo.setUnWriteOffAmount(tempMotherIssueEntryInfo.getUnWriteOffAmount().add(childIssueEntryInfo.getUnWriteOffAmount()));
        tempMotherIssueEntryInfo.setAssistQty(tempMotherIssueEntryInfo.getAssistQty().add(childIssueEntryInfo.getAssistQty()));
        tempMotherIssueEntryInfo.setAmount(tempMotherIssueEntryInfo.getQty().multiply(tempMotherIssueEntryInfo.getPrice()).setScale(precision));
        tempMotherIssueEntryInfo.setNonTaxAmount(tempMotherIssueEntryInfo.getNonTaxAmount().add(childIssueEntryInfo.getNonTaxAmount()));
        tempMotherIssueEntryInfo.setLocalNonTaxAmount(tempMotherIssueEntryInfo.getLocalNonTaxAmount().add(childIssueEntryInfo.getLocalNonTaxAmount()));
        tempMotherIssueEntryInfo.setLocalAmount(tempMotherIssueEntryInfo.getQty().multiply(tempMotherIssueEntryInfo.getLocalPrice()).setScale(precision));
        tempMotherIssueEntryInfo.setTax(tempMotherIssueEntryInfo.getTax().add(childIssueEntryInfo.getTax()));
        tempMotherIssueEntryInfo.setLocalTax(tempMotherIssueEntryInfo.getLocalTax().add(childIssueEntryInfo.getLocalTax()));
        tempMotherIssueEntryInfo.setAssociateQty(tempMotherIssueEntryInfo.getAssociateQty().add(childIssueEntryInfo.getAssociateQty()));
        tempMotherIssueEntryInfo.setUndeliverQty(tempMotherIssueEntryInfo.getUndeliverQty().add(childIssueEntryInfo.getUndeliverQty()));
        tempMotherIssueEntryInfo.setUndeliverBaseQty(tempMotherIssueEntryInfo.getUndeliverBaseQty().add(childIssueEntryInfo.getUndeliverBaseQty()));
        tempMotherIssueEntryInfo.setUnInQty(tempMotherIssueEntryInfo.getUnInQty().add(childIssueEntryInfo.getUnInQty()));
        tempMotherIssueEntryInfo.setUnInBaseQty(tempMotherIssueEntryInfo.getUnInBaseQty().add(childIssueEntryInfo.getUnInBaseQty()));
        tempMotherIssueEntryInfo.setTotalInWarehsQty(tempMotherIssueEntryInfo.getTotalInWarehsQty().add(childIssueEntryInfo.getTotalInWarehsQty()));
        tempMotherIssueEntryInfo.setUnReturnedBaseQty(tempMotherIssueEntryInfo.getUnReturnedBaseQty().add(childIssueEntryInfo.getUnReturnedBaseQty()));
        tempMotherIssueEntryInfo.setDrewQty(tempMotherIssueEntryInfo.getDrewQty().add(childIssueEntryInfo.getDrewQty()));
        tempMotherIssueEntryInfo.setDrewBaseQty(tempMotherIssueEntryInfo.getDrewBaseQty().add(childIssueEntryInfo.getDrewBaseQty()));
        tempMotherIssueEntryInfo.setConfirmQty(tempMotherIssueEntryInfo.getConfirmQty().add(childIssueEntryInfo.getConfirmQty()));
        tempMotherIssueEntryInfo.setConfirmBaseQty(tempMotherIssueEntryInfo.getConfirmBaseQty().add(childIssueEntryInfo.getConfirmBaseQty()));
        tempMotherIssueEntryInfo.setAssociateBaseQty(tempMotherIssueEntryInfo.getAssociateBaseQty().add(childIssueEntryInfo.getAssociateBaseQty()));
        tempMotherIssueEntryInfo.setReverseQty(tempMotherIssueEntryInfo.getReverseQty().add(childIssueEntryInfo.getReverseQty()));
        tempMotherIssueEntryInfo.setReverseBaseQty(tempMotherIssueEntryInfo.getReverseBaseQty().add(childIssueEntryInfo.getReverseBaseQty()));
        tempMotherIssueEntryInfo.setReturnsQty(tempMotherIssueEntryInfo.getReturnsQty().add(childIssueEntryInfo.getReturnsQty()));
        tempMotherIssueEntryInfo.setReturnBaseQty(tempMotherIssueEntryInfo.getReturnBaseQty().add(childIssueEntryInfo.getReturnBaseQty()));
    }

    private HashMap check(Context ctx, String id) throws BOSException, EASBizException {
        HashMap map;
        HashMap<String, String> msgHm = new HashMap<String, String>();
        boolean flag = false;
        StringBuffer notUniteMsg = new StringBuffer();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        SaleIssueBillInfo saleIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)pk);
        if (BillBaseStatusEnum.AUDITED != saleIssueBillInfo.getBaseStatus()) {
            notUniteMsg.append("[");
            notUniteMsg.append(saleIssueBillInfo.getNumber());
            notUniteMsg.append("]\t ");
            notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"NotAudit", (Locale)ctx.getOriginLocale()));
            notUniteMsg.append("\t\n ");
            flag = true;
        }
        if (saleIssueBillInfo.isFiVouchered()) {
            notUniteMsg.append("[");
            notUniteMsg.append(saleIssueBillInfo.getNumber());
            notUniteMsg.append("]\t ");
            notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"HasFiVouchered", (Locale)ctx.getOriginLocale()));
            notUniteMsg.append("\t\n ");
            flag = true;
        }
        if ((map = this.getMotherBillIdAndChildBillId(ctx, id)).containsKey("NotUniteMsg")) {
            String tempError = (String)map.get("NotUniteMsg");
            notUniteMsg.append(tempError);
            flag = true;
        } else {
            String motherBillId = (String)map.get("MotherBillId");
            String childBillId = (String)map.get("ChildBillId");
            msgHm.put("MotherBillId", motherBillId);
            msgHm.put("ChildBillId", childBillId);
            if (SCMServerUtils.hasDestBill((Context)ctx, (String)childBillId)) {
                ObjectUuidPK childPK = new ObjectUuidPK(childBillId);
                SaleIssueBillInfo childIssueBillInfo = iSaleIssueBill.getSaleIssueBillInfo((IObjectPK)childPK);
                notUniteMsg.append("[");
                notUniteMsg.append(childIssueBillInfo.getNumber());
                notUniteMsg.append("]\t ");
                notUniteMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"ChildHasNextBill", (Locale)ctx.getOriginLocale()));
                notUniteMsg.append("\t\n ");
                flag = true;
            }
        }
        if (flag) {
            msgHm.put("NotUniteMsg", notUniteMsg.toString());
        }
        return msgHm;
    }
}

