/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerDeliveryAddressInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.ISaleIssueBillSplitFacade;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillSplitFacadeFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.SplitBillException;
import com.kingdee.eas.scm.im.inv.app.AbstractSaleIssueWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleContractCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.util.InvWebUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SaleIssueWebFacadeControllerBean
extends AbstractSaleIssueWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.SaleIssueWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo billInfo = (SaleIssueBillInfo)model;
        billInfo.setPaymentType(this.getAPaymentTypeInfo(ctx));
        billInfo.setTotalStandardCost(ZERO);
        billInfo.setTotalActualCost(ZERO);
        billInfo.setTotalQty(ZERO);
        billInfo.setTotalAmount(ZERO);
        billInfo.setTotalLocalAmount(ZERO);
        billInfo.setHasEffected(false);
        billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        billInfo.setBizDate(serverDate);
        billInfo.setActBizDate(billInfo.getBizDate());
        billInfo.setAuditTime(null);
        billInfo.setCreateTime(serverDate);
        billInfo.setCurrency(null);
        UserInfo aUserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        billInfo.setCreator(aUserInfo);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
        billInfo.setBillType(aBillTypeInfo);
        billInfo.setFiVouchered(false);
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo((Context)ctx, (String)"d8e80652-010e-1000-e000-04c5c0a812202407435C", (String)"50957179-0105-1000-e000-015bc0a812fd463ED552");
        billInfo.setBizType(bizType);
        if (bizType != null) {
            TransactionTypeInfo tti = InvCommonUtils.getDefaultTransactionType(ctx, "50957179-0105-1000-e000-015bc0a812fd463ED552", bizType.getId().toString());
            billInfo.setTransactionType(tti);
        }
        StorageOrgUnitInfo sou = null;
        sou = billInfo.getStorageOrgUnit() != null ? billInfo.getStorageOrgUnit() : (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, OrgType.Storage, "saleissue_new");
        if (sou == null) {
            return billInfo;
        }
        if (sou.getCU() != null) {
            billInfo.setCU(sou.getCU());
        }
        billInfo.setStorageOrgUnit(sou);
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, sou.getId().toString());
        if (cou != null) {
            billInfo.setCurrency(cou.getBaseCurrency());
        }
        billInfo.setIsInTax(true);
        billInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        billInfo.setExchangeRate(SCMConstant.BIGDECIMAL_ONE.setScale(2));
        SaleIssueEntryInfo entryInfo = (SaleIssueEntryInfo)this.createNewDetailData(ctx);
        SaleOrgUnitInfo aSaleOrgUnitInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(sou.getId().toString());
        entryInfo.setSaleOrgUnit(aSaleOrgUnitInfo);
        entryInfo.setIsIncomeConfirm(false);
        if (cou != null) {
            entryInfo.setStorageOrgUnit(sou);
            entryInfo.setCompanyOrgUnit(cou);
        }
        if (billInfo.getTransactionType() != null) {
            InvUpdateTypeInfo invUpdateTypeInfo = InvCommonUtils.getDefaultWebInvUpdateType(ctx, "50957179-0105-1000-e000-015bc0a812fd463ED552", billInfo.getTransactionType());
            entryInfo.setInvUpdateType(invUpdateTypeInfo);
        }
        billInfo.getEntry().add(entryInfo);
        return billInfo;
    }

    private PaymentTypeInfo getAPaymentTypeInfo(Context ctx) throws BOSException, EASBizException {
        PaymentTypeInfo aPaymentTypeInfo = null;
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        aPaymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
        return aPaymentTypeInfo;
    }

    public IObjectValue createNewDetailData(Context context) throws BOSException, EASBizException {
        SaleIssueEntryInfo entryInfo = new SaleIssueEntryInfo();
        entryInfo.setBaseStatus(EntryBaseStatusEnum.NULL);
        entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        entryInfo.setIsPresent(false);
        entryInfo.setIsFullWriteOff(false);
        return entryInfo;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        int i;
        FilterInfo filter;
        HashMap<String, Object> map = new HashMap<String, Object>();
        SaleIssueBillInfo info = (SaleIssueBillInfo)model;
        String storageOrgFilter = this.getMainOrgFilter(ctx);
        map.put("storageOrgFilter", storageOrgFilter);
        if (info.getStorageOrgUnit() == null) {
            return map;
        }
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getStorageOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getStorageOrgUnit().getId().toString());
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        if (info.getSourceBillType() == null) {
            map.put("saleOu", SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(info.getStorageOrgUnit().getId().toString()));
        }
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        Map paramMap = this.getParamsMap(ctx, info.getStorageOrgUnit().getId().toString(), cou.getId().toString());
        map.put("params", paramMap);
        String isSplitBill = (String)info.get("isSplitBill");
        if (Boolean.TRUE.toString().equals(paramMap.get("INM100")) && isSplitBill != null && "1".equals(isSplitBill)) {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo(null, (Date)info.getBizDate(), (CompanyOrgUnitInfo)cou);
            if (pInfo.getNumber() >= periodInfo.getNumber()) {
                PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)pInfo);
                if (nextPeriodInfo.isIsAdjustPeriod()) {
                    map.put("childDate", PeriodUtils.getNextPeriodInfo((PeriodInfo)nextPeriodInfo).getBeginDate());
                } else {
                    map.put("childDate", nextPeriodInfo.getBeginDate());
                }
            }
        }
        info.setCU(info.getStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleIssueBillInfo(), info.getStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getStorageOrgUnit().getId().toString()));
            }
        }
        SaleIssueEntryInfo entry = null;
        SaleIssueEntryCollection entryColl = info.getEntry();
        HashSet<String> contractNumberSet = new HashSet<String>();
        HashSet<String> sendAddressInfoSet = new HashSet<String>();
        HashMap<String, Map> entryParamMap = new HashMap<String, Map>();
        SaleOrgUnitInfo saleOu = null;
        for (int i2 = 0; i2 < entryColl.size(); ++i2) {
            entry = entryColl.get(i2);
            saleOu = entry.getSaleOrgUnit();
            if (saleOu != null && !entryParamMap.containsKey(saleOu.getId().toString())) {
                entryParamMap.put(saleOu.getId().toString(), this.batchGetParamValue(ctx, saleOu.getId().toString(), new String[]{"SALEBILL001"}));
            }
            if (entry.getContractNumber() != null) {
                contractNumberSet.add(entry.getContractNumber());
            }
            if (entry.getSendAddress() == null) continue;
            sendAddressInfoSet.add(entry.getSendAddress());
        }
        map.put("entryParamMap", entryParamMap);
        if (contractNumberSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", contractNumberSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleContractCollection saleContractCollection = SaleContractFactory.getLocalInstance((Context)ctx).getSaleContractCollection(view);
            HashMap<String, SaleContractInfo> contractMap = new HashMap<String, SaleContractInfo>();
            for (i = 0; i < saleContractCollection.size(); ++i) {
                contractMap.put(saleContractCollection.get(i).getNumber(), saleContractCollection.get(i));
            }
            map.put("contractMap", contractMap);
        }
        if (sendAddressInfoSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("address", sendAddressInfoSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection addressCollection = CustomerDeliveryAddressFactory.getLocalInstance((Context)ctx).getCollection(view);
            HashMap<String, CustomerDeliveryAddressInfo> sendAddressInfoMap = new HashMap<String, CustomerDeliveryAddressInfo>();
            for (i = 0; i < addressCollection.size(); ++i) {
                sendAddressInfoMap.put(((CustomerDeliveryAddressInfo)addressCollection.get(i)).getAddress(), (CustomerDeliveryAddressInfo)addressCollection.get(i));
            }
            map.put("sendAddressInfoMap", sendAddressInfoMap);
        }
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        map.put("currentPeriodinfo", currentPeriodinfo);
        return map;
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM100", "INM008", "INM160"});
        paramMap.putAll(souParamMap);
        Map couParamMap = this.batchGetParamValue(ctx, couId, new String[]{"CONSIGNSALES", "AR_032"});
        paramMap.putAll(couParamMap);
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    public String getPermissionItem() {
        return "saleissue_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    @Override
    protected Map _getDataForOrgChanged(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = (String)requestMap.get("orgId");
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        responseMap.put("cou", cou);
        SaleOrgUnitInfo saleOu = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getSaleOrgByStorageOrg(orgId);
        responseMap.put("saleOu", saleOu);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        responseMap.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        responseMap.put("params", this.getParamsMap(ctx, orgId, cou.getId().toString()));
        HashMap<String, Map> entryParamMap = new HashMap<String, Map>();
        if (saleOu != null) {
            entryParamMap.put(saleOu.getId().toString(), this.batchGetParamValue(ctx, saleOu.getId().toString(), new String[]{"SALEBILL001"}));
        }
        responseMap.put("entryParamMap", entryParamMap);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        responseMap.put("currentPeriodinfo", currentPeriodinfo);
        SaleIssueBillInfo info = new SaleIssueBillInfo();
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        info.setStorageOrgUnit(sou);
        info.setCU(sou.getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, orgId);
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)info, orgId));
            }
        }
        return responseMap;
    }

    @Override
    protected void _checkSplitBillByWrittenOff(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList orgIDs = (ArrayList)paramMap.get("ids");
        Object errHeadStr = null;
        if (orgIDs != null && orgIDs.size() > 1) {
            int size = orgIDs.size();
            BOSUuid[] bosIDs = new BOSUuid[size];
            for (int index = 0; index < size; ++index) {
                if (orgIDs.get(index) == null) continue;
                bosIDs[index] = BOSUuid.read((String)((String)orgIDs.get(index)));
            }
            ISCMBillCommonFacade iScmBillCommon = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            Map map = iScmBillCommon.getCompanyInfos(bosIDs);
            HashMap compareMap = new HashMap();
            HashSet<String> couSet = new HashSet<String>();
            if (map != null) {
                Set set = map.keySet();
                for (String id : set) {
                    CompanyOrgUnitInfo company;
                    if (map.get(id) == null || (company = (CompanyOrgUnitInfo)map.get(id)) == null) continue;
                    couSet.add(company.getId().toString());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", couSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)SystemEnum.INVENTORYMANAGEMENT));
                view.setFilter(filter);
                SystemStatusCtrolCollection coll = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(view);
                HashSet<String> periodIdSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    periodIdSet.add(coll.get(i).getCurrentPeriod() == null ? null : coll.get(i).getCurrentPeriod().getId().toString());
                }
                if (periodIdSet.size() > 1) {
                    throw new SplitBillException(SplitBillException.ALLCOUHASNOTSAMEPERIOD);
                }
            }
        }
    }

    @Override
    protected Map _isSaleIssueBillSplitChangeDate(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Comparable<Boolean>> resultMap = new HashMap<String, Comparable<Boolean>>();
        String billTypeId = (String)paramMap.get("billTypeId");
        String storageUnitID = (String)paramMap.get("souId");
        String billBizDate = (String)paramMap.get("billBizDate");
        boolean isChangeDate = false;
        Date bizDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (billBizDate != null) {
                bizDate = dateFormat.parse(billBizDate);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        sou.setId(BOSUuid.read((String)storageUnitID));
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, sou);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Timestamp currentLastDate = null;
        currentLastDate = billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate()) ? currentPeriodinfo.getEndDate() : billPeriodInfo.getEndDate();
        long time = ((Date)currentLastDate).getTime() + 86400000L;
        Date nextDate = new Date(time);
        if (!billPeriodInfo.getBeginDate().before(currentPeriodinfo.getBeginDate())) {
            isChangeDate = InvWebUtils.isSaleIssueBillSplitChangeDate((String)billTypeId, (String)storageUnitID);
        }
        resultMap.put("isChangeDate", Boolean.valueOf(isChangeDate));
        resultMap.put("nextDate", nextDate);
        resultMap.put("beginDate", currentPeriodinfo.getBeginDate());
        return resultMap;
    }

    @Override
    protected Map _splitBillByWrittenOff(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String idsStr = (String)paramMap.get("ids");
        String storageUnitID = (String)paramMap.get("souId");
        String billBizDate = (String)paramMap.get("billBizDate");
        String[] ids = idsStr.split(",");
        Date bizDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (paramMap.get("billBizDate") != null) {
                bizDate = dateFormat.parse((String)paramMap.get("billBizDate"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        if (bizDate == null) {
            throw new IllegalArgumentException(" billBizDate can't be null");
        }
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        sou.setId(BOSUuid.read((String)storageUnitID));
        CompanyOrgUnitInfo cou = InvServerUtils.getCompanyInfoForStorage(ctx, sou);
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)cou);
        PeriodInfo currentPeriodinfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Boolean isCloseAccounts = bizDate.before(currentPeriodinfo.getBeginDate());
        Date setDate = bizDate;
        if (setDate.before(currentPeriodinfo.getBeginDate()) && !isCloseAccounts.booleanValue()) {
            throw new SplitBillException(SplitBillException.CHILDBIZDATEBEFORECURRENTPERIOD);
        }
        Object msgMap = null;
        HashMap<String, Date> param = new HashMap<String, Date>();
        ISaleIssueBillSplitFacade splitFacade = SaleIssueBillSplitFacadeFactory.getLocalInstance(ctx);
        param.put("SplitDate", bizDate);
        IObjectPK[] pks = this.changetToPKs(ids);
        return splitFacade.split(pks, bizDate);
    }

    protected IObjectPK[] changetToPKs(String[] ids) {
        HashSet<String> pkSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            pkSet.add(ids[i]);
        }
        Object[] pks = pkSet.toArray();
        IObjectPK[] pkIDs = new IObjectPK[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            pkIDs[i] = new ObjectStringPK((String)pks[i]);
        }
        return pkIDs;
    }
}

