/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrolChecker;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ScmImSystemStatusCtrolChecker
implements ISystemStatusCtrolChecker {
    private static final Logger logger = Logger.getLogger(ScmImSystemStatusCtrolChecker.class);

    public void check(Context ctx, SystemStatusCtrolCollection objCol) throws PeriodException {
        try {
            SystemStatusCtrolInfo info = null;
            for (int i = 0; i < objCol.size(); ++i) {
                info = objCol.get(i);
                if (info.getSystemStatus().getName() != SystemEnum.INVENTORYMANAGEMENT) continue;
                PeriodInfo startPeriod = info.getStartPeriod();
                if (info.isIsStart() || startPeriod == null || startPeriod.getBeginDate() == null) continue;
                this.checkHasBillInPeriod(ctx, info, startPeriod);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private void checkHasBillInPeriod(Context ctx, SystemStatusCtrolInfo info, PeriodInfo startPeriod) throws EASBizException, BOSException {
        Date beginDate = startPeriod.getBeginDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String whereSql = " where FBizDate < to_date('" + sdf.format(beginDate) + "') ";
        StringBuffer storageOrgIds = this.getStorageIds(ctx, info);
        if (storageOrgIds.length() > 0) {
            whereSql = whereSql + " and FStorageOrgUnitId in (" + storageOrgIds + ")";
        }
        String[] tableNames = new String[]{"T_IM_PurReceivalBill", "T_IM_PurInWarehsBill", "T_IM_ManufactureRecBill", "T_IM_MoveInWarehsBill", "T_IM_OtherInWarehsBill", "T_IM_SaleIssueBill", "T_IM_MaterialReqBill", "T_IM_MoveIssueBill", "T_IM_OtherIssueBill", "T_IM_MoveLocationBill", "T_IM_InvStateAdjustBill", "T_IM_DecomposeBill", "T_CL_CostAdjustBill"};
        List<String> tables = Arrays.asList(tableNames);
        IRowSet rs = null;
        String sql = "";
        for (int j = 0; j < tables.size(); ++j) {
            sql = "select 1 from " + tables.get(j) + whereSql;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rs.next()) continue;
                InvException ex = new InvException(InvException.HASBILLINPERIOD);
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)ex, new Object[]{ex.getMessage()});
            }
            catch (Exception e) {
                throw new PeriodException(PeriodException.SYSTEM_STATUS_CTROL_CHECK_ERROR, (Throwable)e, new Object[]{e.getMessage()});
            }
        }
    }

    private StringBuffer getStorageIds(Context ctx, SystemStatusCtrolInfo info) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = info.getCompany();
        OrgUnitCollection orgs = null;
        if (!company.isIsCompanyOrgUnit()) {
            throw new InvException(InvException.NOT_REAL_COMPANY_ORG_OR_COMPANY_HAVENT_REAL_STORGE_ORG);
        }
        if (!company.isIsBizUnit()) {
            throw new InvException(InvException.NOT_REAL_COMPANY_ORG_OR_COMPANY_HAVENT_REAL_STORGE_ORG);
        }
        orgs = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(company.getId().toString(), 1, 4);
        StringBuffer storageOrgIds = new StringBuffer();
        if (orgs != null && orgs.size() > 0) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                storageOrgIds.append("'" + orgs.get(i).getId().toString() + "'");
                if (i == size - 1) continue;
                storageOrgIds.append(",");
            }
        } else {
            throw new InvException(InvException.NOT_REAL_COMPANY_ORG_OR_COMPANY_HAVENT_REAL_STORGE_ORG);
        }
        return storageOrgIds;
    }
}

