/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.im.inv.app.AbstractSerialNumberAddEntriesFacadeControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SerialNumberAddEntriesFacadeControllerBean
extends AbstractSerialNumberAddEntriesFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)SerialNumberAddEntriesFacadeControllerBean.class.getName());
    private static final String resFile = "com.kingdee.eas.scm.im.inv.MaterialSNResource";

    public RptParams createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        boolean ckShowBalance = params.getBoolean("ckShowBalance");
        boolean ckShowHistoryData = params.getBoolean("ckShowHistoryData");
        boolean ckShowExceptionData = params.getBoolean("ckShowExceptionData");
        String tempTable = null;
        if (ckShowHistoryData || ckShowExceptionData) {
            tempTable = this.createTempTable(ctx, this.getCreateTempTableSQL(params));
            params.setString("tempTable", tempTable);
        }
        if (ckShowBalance) {
            int balanceQty = this.getBalanceQty(ctx, params);
            params.setInt("balanceQty", balanceQty);
        }
        if (ckShowHistoryData) {
            this.updateHistoryData(ctx, tempTable, params);
        }
        if (ckShowExceptionData) {
            this.updateExceptionData(ctx, tempTable, params);
        }
        return params;
    }

    private void updateExceptionData(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        String materialID = params.getString("materialID");
        String txtSerialNumber = params.getString("txtSerialNumber");
        HashSet<String> inventoryIDSet = new HashSet<String>();
        String selectSQL = "select fid from T_IM_Inventory where fmaterialid = ? and fcurstoreQty = 0";
        RptRowSet selectRs = this.executeQuery(selectSQL, new SqlParams(new Object[]{materialID}), ctx);
        while (selectRs.next()) {
            String inventoryID = selectRs.getString("fid");
            inventoryIDSet.add(inventoryID);
        }
        if (inventoryIDSet.size() == 0) {
            return;
        }
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" insert into ").append(tempTable).append(" (fid, fmaterialid, fmaterialnumber, fserialnumber, ftype) ");
        updateSQL.append(" select sn.fid as fid, sn.fmaterialid as fmaterialid, mat.fnumber as fmaterialnumber, sn.fserialnumber as fserialnumber, '");
        updateSQL.append(ResourceUtil.getMessage((String)resFile, (String)"SERIALNUMBER_EXCEPTIONDATA")).append("' as ftype from T_IV_MaterialSNInventory sn ");
        updateSQL.append(" left outer join T_BD_Material mat on sn.fmaterialid = mat.fid ");
        updateSQL.append(" where sn.finventoryid in (").append(CollectionUtil.convertList2String(new ArrayList(inventoryIDSet))).append(") ");
        updateSQL.append(" and sn.fsnstatus = 2 and sn.fmaterialid = ? ");
        if (!StringUtils.isEmpty((String)txtSerialNumber)) {
            updateSQL.append(" and sn.fserialnumber like '%").append(txtSerialNumber).append("%' ");
        }
        SqlParams sqlParams = new SqlParams((Object[])new String[]{materialID});
        this.executeUpdate(ctx, updateSQL.toString(), sqlParams);
    }

    private void updateHistoryData(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        String materialID = params.getString("materialID");
        String txtSerialNumber = params.getString("txtSerialNumber");
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" insert into ").append(tempTable).append(" (fid, fmaterialid, fmaterialnumber, fserialnumber, ftype) ");
        updateSQL.append(" select sn.fid as fid, sn.fmaterialid as fmaterialid, mat.fnumber as fmaterialnumber, sn.fserialnumber as fserialnumber, '");
        updateSQL.append(ResourceUtil.getMessage((String)resFile, (String)"SERIALNUMBER_HISTORYDATA")).append("' as ftype from T_IV_MaterialSNInventory sn ");
        updateSQL.append(" left outer join T_BD_Material mat on sn.fmaterialid = mat.fid ");
        updateSQL.append(" where sn.fmaterialid = ? and sn.finventoryid is null and (sn.fsnstatus = 2 or sn.fsnstatus = 3) ");
        if (!StringUtils.isEmpty((String)txtSerialNumber)) {
            updateSQL.append(" and sn.fserialnumber like '%").append(txtSerialNumber).append("%' ");
        }
        SqlParams sqlParams = new SqlParams((Object[])new String[]{materialID});
        this.executeUpdate(ctx, updateSQL.toString(), sqlParams);
    }

    private int getBalanceQty(Context ctx, RptParams params) throws BOSException {
        String inventoryID = params.getString("inventoryID");
        String countSQL = "select count(*) as qty from T_IV_MaterialSNInventory where finventoryid = ? and (fsnstatus = 2 or fsnstatus = 3)";
        SqlParams sqlParams = new SqlParams(new Object[]{inventoryID});
        RptRowSet rsCount = this.executeQuery(countSQL, sqlParams, ctx);
        rsCount.next();
        int count = rsCount.getInt("qty");
        BigDecimal curStoreQty = params.getBigDecimal("curStoreQty");
        int balanceQty = curStoreQty.intValue() - count;
        return balanceQty;
    }

    public RptParams query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sqlBuffer = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sqlBuffer.append("select fid, fmaterialid, fmaterialnumber, fserialnumber, ftype from ").append(tempTable);
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, from, len, ctx);
        RptParams result = new RptParams();
        result.setObject("rowset", (Object)rs);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        result.setInt("totalCount", count);
        return result;
    }

    private String getCreateTempTableSQL(RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44), FMaterialID varchar(44),");
        sql.append("FMaterialNumber nvarchar(255), FSerialNumber varchar(80), FType varchar(80));");
        logger.info((Object)("\u8865\u5f55\u5e8f\u5217\u53f7\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }
}

