/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockReqCollection;
import com.kingdee.eas.scm.im.inv.StockReqEntryCollection;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockReqEntryControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StockReqEntryControllerBean
extends AbstractStockReqEntryControllerBean {
    @Override
    protected IObjectCollection _close(Context ctx, List entryIDList, List idList) throws BOSException, EASBizException {
        StockReqEntryInfo entryInfo = null;
        StockReqInfo bill = null;
        StockReqEntryCollection resultCol = new StockReqEntryCollection();
        StockReqEntryCollection entryColl = null;
        if (entryIDList == null || entryIDList.size() == 0) {
            return null;
        }
        StringBuffer oql = new StringBuffer();
        HashSet idSet = new HashSet(entryIDList);
        String ids = InvServerUtils.getInStringFromList(new ArrayList(idSet));
        oql.append("select id,seq,baseStatus,parent.id,parent.number,parent.reqStorage.id where id in ").append(ids);
        StockReqEntryCollection entrys = this.getStockReqEntryCollection(ctx, oql.toString());
        if (entrys.size() != idSet.size()) {
            throw new ObjectNotFoundException();
        }
        HashSet<String> parentIdSet = new HashSet<String>();
        HashSet<String> entryIdSet = new HashSet<String>();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entrys.get(i);
            if (4 == entryInfo.getBaseStatus().getValue()) {
                parentIdSet.add(entryInfo.getParent().getId().toString());
                entryIdSet.add(entryInfo.getId().toString());
                continue;
            }
            resultCol.add(entryInfo);
        }
        String tableName = "T_IM_StockReqEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            StockReqCollection coll = StockReqFactory.getLocalInstance(ctx).getStockReqCollection(view);
            if (coll != null && coll.size() > 0) {
                int size2 = coll.size();
                for (int i = 0; i < size2; ++i) {
                    bill = coll.get(i);
                    entryColl = (StockReqEntryCollection)((Object)bill.getEntry().clone());
                    bill.getEntry().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        bill.getEntry().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)bill, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        StringBuilder sql = new StringBuilder();
        if (entryIdSet.size() > 0) {
            sql.append("update ").append(tableName).append(" set FBaseStatus = 7 where FID in ").append(SCMServerUtils.getInStringFromSet(entryIdSet));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        int size3 = entrys.size();
        for (int i = 0; i < size3; ++i) {
            entryInfo = entrys.get(i);
            if (4 == entryInfo.getBaseStatus().getValue()) {
                this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), "OPERATOR_CLOSE", true);
                continue;
            }
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), "OPERATOR_CLOSE", false);
        }
        if (parentIdSet.size() > 0) {
            sql.setLength(0);
            sql.append("update T_IM_StockReq set FBaseStatus = 7 where fid in ").append(SCMServerUtils.getInStringFromSet(parentIdSet));
            sql.append(" and FID not in (select FParentId from ").append(tableName).append(" where FParentId in ");
            sql.append(SCMServerUtils.getInStringFromSet(parentIdSet)).append(" and FBaseStatus <> 7 )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return resultCol;
    }

    @Override
    protected IObjectCollection _unClose(Context ctx, List entryIDList, List idList) throws BOSException, EASBizException {
        StockReqEntryInfo entryInfo = null;
        StockReqInfo bill = null;
        StockReqEntryCollection resultCol = new StockReqEntryCollection();
        StockReqEntryCollection entryColl = null;
        if (entryIDList == null || entryIDList.size() == 0) {
            return null;
        }
        HashSet idSet = new HashSet(entryIDList);
        String ids = InvServerUtils.getInStringFromList(new ArrayList(idSet));
        StockReqEntryCollection entrys = this.getStockReqEntryCollection(ctx, "select id,seq,baseStatus,parent.id,parent.number,parent.reqStorage.id where id in " + ids);
        if (entrys.size() != idSet.size()) {
            throw new ObjectNotFoundException();
        }
        HashSet<String> parentIdSet = new HashSet<String>();
        HashSet<String> entryIdSet = new HashSet<String>();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entrys.get(i);
            if (7 == entryInfo.getBaseStatus().getValue()) {
                parentIdSet.add(entryInfo.getParent().getId().toString());
                entryIdSet.add(entryInfo.getId().toString());
                continue;
            }
            resultCol.add(entryInfo);
        }
        String tableName = "T_IM_StockReqEntry";
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashSet billIdSet = new HashSet();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdSet.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            StockReqCollection coll = StockReqFactory.getLocalInstance(ctx).getStockReqCollection(view);
            if (coll != null && coll.size() > 0) {
                int size2 = coll.size();
                for (int i = 0; i < size2; ++i) {
                    bill = coll.get(i);
                    entryColl = (StockReqEntryCollection)((Object)bill.getEntry().clone());
                    bill.getEntry().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                        bill.getEntry().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)bill, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        StringBuilder sql = new StringBuilder();
        if (entryIdSet.size() > 0) {
            sql.append("update ").append(tableName).append(" set FBaseStatus = 4 where FID in ").append(SCMServerUtils.getInStringFromSet(entryIdSet));
            sql.append(" and FBaseStatus = ").append(7);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        int size3 = entrys.size();
        for (int i = 0; i < size3; ++i) {
            entryInfo = entrys.get(i);
            if (7 == entryInfo.getBaseStatus().getValue()) {
                this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), "OPERATOR_UNCLOSE", true);
                continue;
            }
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), "OPERATOR_UNCLOSE", false);
        }
        if (parentIdSet.size() > 0) {
            sql.setLength(0);
            sql.append("update T_IM_StockReq set FBaseStatus = ").append(4);
            sql.append(" where FID in (");
            sql.append("select fparentid from T_IM_StockReqEntry where FParentId in ");
            sql.append(SCMServerUtils.getInStringFromSet(parentIdSet));
            sql.append(" and FBaseStatus = ").append(4);
            sql.append(") and FBaseStatus = ").append(7);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        return resultCol;
    }

    @Override
    protected void _autoClose(Context ctx, List entryIDList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select id, parent.id, auditBaseQty, totalStockBaseQty,lessDeliveryRate where id in ");
        sql.append(InvServerUtils.getInStringFromList(entryIDList));
        StockReqEntryCollection coll = this.getStockReqEntryCollection(ctx, sql.toString());
        if (coll == null || coll.size() == 0) {
            return;
        }
        ArrayList<String> closeEntryList = new ArrayList<String>();
        ArrayList<String> closeList = new ArrayList<String>();
        BigDecimal lessDeliveryRate = BigDecimal.ZERO;
        for (int i = 0; i < coll.size(); ++i) {
            StockReqEntryInfo entry = coll.get(i);
            lessDeliveryRate = entry.getLessDeliveryRate();
            if (lessDeliveryRate == null) {
                lessDeliveryRate = BigDecimal.ZERO;
            }
            if (entry.getTotalStockBaseQty().compareTo(entry.getAuditBaseQty().multiply(BigDecimal.valueOf(100L).subtract(lessDeliveryRate)).multiply(BigDecimal.valueOf(0.01))) < 0) continue;
            closeEntryList.add(entry.getId().toString());
            closeList.add(entry.getParent().getId().toString());
        }
        this._close(ctx, closeEntryList, closeList);
    }

    @Override
    protected void _autoUnClose(Context ctx, List entryIDList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select id, parent.id, auditBaseQty, totalStockBaseQty where id in ");
        sql.append(InvServerUtils.getInStringFromList(entryIDList));
        StockReqEntryCollection coll = this.getStockReqEntryCollection(ctx, sql.toString());
        if (coll == null || coll.size() == 0) {
            return;
        }
        ArrayList<String> unCloseEntryList = new ArrayList<String>();
        ArrayList<String> unCloseList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            StockReqEntryInfo entry = coll.get(i);
            if (entry.getTotalStockBaseQty().compareTo(entry.getAuditBaseQty()) >= 0) continue;
            unCloseEntryList.add(entry.getId().toString());
            unCloseList.add(entry.getParent().getId().toString());
        }
        this._unClose(ctx, unCloseEntryList, unCloseList);
    }

    private List getNeedCloseEntries(Context ctx, Map destSrcEntryMap, String destTableName) throws BOSException, EASBizException {
        ArrayList<String> entries = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select srcEntry.Fid ");
        sql.append("from T_IM_StockReqEntry srcEntry ");
        sql.append("inner join " + destTableName + " destEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("where srcEntry.Fisuncontrolqty = 1 ");
        sql.append("and isnull(srcEntry.Ftotalstockbaseqty,0) >= isnull(srcEntry.FAuditBaseQty,0) ");
        sql.append("and destEntry.fid =?  ");
        sql.append("and srcEntry.fid =? ");
        sql.append("union all ");
        sql.append("select srcEntry.Fid ");
        sql.append("from T_IM_StockReqEntry srcEntry ");
        sql.append("inner join " + destTableName + " destEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("where srcEntry.Fisuncontrolqty = 0 ");
        sql.append("and isnull(srcEntry.Ftotalstockbaseqty,0) >= round(isnull(srcEntry.FAuditBaseQty,0) * (1 - round(isnull(srcEntry.Flessdeliveryrate,0) / 100, 4)),8) ");
        sql.append("and destEntry.fid =?  ");
        sql.append("and srcEntry.fid =? ");
        Set destIDS = destSrcEntryMap.keySet();
        Iterator it = destIDS.iterator();
        String destID = null;
        String srcID = null;
        IRowSet rs = null;
        while (it.hasNext()) {
            try {
                destID = (String)it.next();
                srcID = (String)destSrcEntryMap.get(destID);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{destID, srcID, destID, srcID});
                while (rs.next()) {
                    entries.add(rs.getString("Fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException("execute QuerySQL exception : " + sql, (Throwable)e);
            }
        }
        return entries;
    }

    private List getNeedUnCloseEntries(Context ctx, Map destSrcEntryMap, String destTableName) throws BOSException, EASBizException {
        ArrayList<String> entries = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select srcEntry.Fid ");
        sql.append("from T_IM_StockReqEntry srcEntry ");
        sql.append("inner join " + destTableName + " destEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("where srcEntry.Fisuncontrolqty = 1 ");
        sql.append("and isnull(srcEntry.Ftotalstockbaseqty,0) <= isnull(srcEntry.FAuditBaseQty,0) ");
        sql.append("and destEntry.fid =?  ");
        sql.append("and srcEntry.fid =? ");
        sql.append("union all ");
        sql.append("select srcEntry.Fid ");
        sql.append("from T_IM_StockReqEntry srcEntry ");
        sql.append("inner join " + destTableName + " destEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("where srcEntry.Fisuncontrolqty = 0 ");
        sql.append("and isnull(srcEntry.Ftotalstockbaseqty,0) <= round(isnull(srcEntry.FAuditBaseQty,0) * (1 + round(isnull(srcEntry.Foverdeliveryrate,0) / 100, 4)),8) ");
        sql.append("and destEntry.fid =?  ");
        sql.append("and srcEntry.fid =? ");
        Set destIDS = destSrcEntryMap.keySet();
        Iterator it = destIDS.iterator();
        String destID = null;
        String srcID = null;
        IRowSet rs = null;
        while (it.hasNext()) {
            try {
                destID = (String)it.next();
                srcID = (String)destSrcEntryMap.get(destID);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{destID, srcID, destID, srcID});
                while (rs.next()) {
                    entries.add(rs.getString("Fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException("execute QuerySQL exception : " + sql, (Throwable)e);
            }
        }
        return entries;
    }

    @Override
    protected void _autoClose(Context ctx, Map destSrcEntryMap, String destTableName) throws BOSException, EASBizException {
        List closeEntryList = this.getNeedCloseEntries(ctx, destSrcEntryMap, destTableName);
        if (closeEntryList == null || closeEntryList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select id, parent.id where id in ");
        sql.append(InvServerUtils.getInStringFromList(closeEntryList));
        StockReqEntryCollection coll = this.getStockReqEntryCollection(ctx, sql.toString());
        ArrayList<String> closeList = new ArrayList<String>();
        StockReqEntryInfo entry = null;
        for (int i = 0; i < coll.size(); ++i) {
            entry = coll.get(i);
            closeList.add(entry.getParent().getId().toString());
        }
        this._close(ctx, closeEntryList, closeList);
    }

    @Override
    protected void _autoUnClose(Context ctx, Map destSrcEntryMap, String destTableName) throws BOSException, EASBizException {
        List unCloseEntryList = this.getNeedUnCloseEntries(ctx, destSrcEntryMap, destTableName);
        if (unCloseEntryList == null || unCloseEntryList.size() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select id, parent.id where id in ");
        sql.append(InvServerUtils.getInStringFromList(unCloseEntryList));
        StockReqEntryCollection coll = this.getStockReqEntryCollection(ctx, sql.toString());
        ArrayList<String> unCloseList = new ArrayList<String>();
        StockReqEntryInfo entry = null;
        for (int i = 0; i < coll.size(); ++i) {
            entry = coll.get(i);
            unCloseList.add(entry.getParent().getId().toString());
        }
        this._unClose(ctx, unCloseEntryList, unCloseList);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockReqEntryInfo entry = (StockReqEntryInfo)this.getValue(ctx, pk);
        StockReqInfo bill = StockReqFactory.getLocalInstance(ctx).getStockReqInfo((IObjectPK)new ObjectUuidPK(entry.getParent().getId()));
        return bill.getNumber() + "  " + entry.getSeq();
    }

    private boolean isCanClose(StockReqInfo bill) {
        int size = bill.getEntry().size();
        for (int i = 0; i < size; ++i) {
            if (EntryBaseStatusEnum.CLOSED.equals((Object)bill.getEntry().get(i).getBaseStatus())) continue;
            return false;
        }
        return true;
    }

    private void writeLog(Context ctx, StockReqInfo bill, StockReqEntryInfo entry, IObjectPK pk, String resName, boolean isSuccesse) throws EASBizException, BOSException {
        String companyId = bill.getReqStorage().getId().toString();
        String operate = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)resName, null);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_handleClose", (BOSObjectType)entry.getBOSType(), (IObjectPK)pk, (String)this._getLogInfo(ctx, pk), (String)"im_stockReq_close", (String)companyId, (String)operate);
        if (isSuccesse) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    @Override
    protected void _handleClose(Context ctx, IObjectPK id, IObjectPK entryId) throws BOSException, EASBizException {
        StockReqEntryCollection cantCloseColl = this.close(ctx, Arrays.asList(entryId), Arrays.asList(id));
        if (cantCloseColl.size() > 0) {
            throw new InvBizException(InvBizException.MUST_AUDIT_BILL);
        }
    }

    @Override
    protected void _handleUnClose(Context ctx, IObjectPK id, IObjectPK entryId) throws BOSException, EASBizException {
        StockReqEntryCollection cantUnCloseColl = this.unClose(ctx, Arrays.asList(entryId), Arrays.asList(entryId));
        if (cantUnCloseColl.size() > 0) {
            throw new InvBizException(InvBizException.MUST_AUDIT_BILL);
        }
    }
}

