/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockReqFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class StockReqFacadeControllerBean
extends AbstractStockReqFacadeControllerBean {
    private static final long serialVersionUID = -1253174159078955347L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.StockReqFacadeControllerBean");

    @Override
    protected EntityViewInfo _getPouFilterByReceiveStorageAndSupplyCompany(Context ctx, String receiveStorageID, String supplyCompanyID) throws BOSException, EASBizException {
        HashSet set = new HashSet();
        if (!StringUtils.isEmpty((String)receiveStorageID) && !StringUtils.isEmpty((String)supplyCompanyID)) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection pouColl1 = iUnitRel.getToUnit(receiveStorageID, 4, 3);
            HashSet<String> set1 = new HashSet<String>();
            if (pouColl1 != null) {
                int n = pouColl1.size();
                for (int i = 0; i < n; ++i) {
                    set1.add(pouColl1.get(i).getId().toString());
                }
            }
            OrgUnitCollection pouColl2 = iUnitRel.getFromUnit(supplyCompanyID, 1, 3);
            HashSet<String> set2 = new HashSet<String>();
            if (pouColl2 != null) {
                int n = pouColl2.size();
                for (int i = 0; i < n; ++i) {
                    set2.add(pouColl2.get(i).getId().toString());
                }
            }
            set1.retainAll(set2);
            set = set1;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set.size() <= 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"XXX", CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        return view;
    }

    @Override
    protected EntityViewInfo _getSaleouFilterByReceiveStorageAndReceiveCompany(Context ctx, String receiveStorageID, String receiveCompanyID) throws BOSException, EASBizException {
        HashSet set = new HashSet();
        if (!StringUtils.isEmpty((String)receiveStorageID) && !StringUtils.isEmpty((String)receiveCompanyID)) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection saleouColl1 = iUnitRel.getToUnit(receiveStorageID, 4, 2);
            HashSet<String> set1 = new HashSet<String>();
            if (saleouColl1 != null) {
                int n = saleouColl1.size();
                for (int i = 0; i < n; ++i) {
                    set1.add(saleouColl1.get(i).getId().toString());
                }
            }
            OrgUnitCollection saleouColl2 = iUnitRel.getFromUnit(receiveCompanyID, 1, 2);
            HashSet<String> set2 = new HashSet<String>();
            if (saleouColl2 != null) {
                int n = saleouColl2.size();
                for (int i = 0; i < n; ++i) {
                    set2.add(saleouColl2.get(i).getId().toString());
                }
            }
            set1.retainAll(set2);
            set = set1;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (set.size() <= 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"XXX", CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        return view;
    }

    @Override
    protected boolean _checkSrcBillStockReqAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BillTypeInfo billType;
        boolean canAudit = true;
        if (model == null) {
            return canAudit;
        }
        String sql = null;
        if (model instanceof StockReqInfo) {
            billType = ((StockReqInfo)model).getSourceBillType();
            if (billType == null) {
                return true;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return true;
            }
            sql = this.getCheckAuditSQL(ctx, "T_IM_StockReqEntry", "T_IM_StockReq", new String[]{pk.toString()});
        } else if (model instanceof PurOrderInfo) {
            billType = ((PurOrderInfo)model).getSourceBillType();
            if (billType == null) {
                return true;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return true;
            }
            sql = this.getCheckAuditSQL(ctx, "T_SM_PurOrderEntry", "T_SM_PurOrder", new String[]{pk.toString()});
        } else if (model instanceof SaleOrderInfo) {
            billType = ((SaleOrderInfo)model).getSourceBillType();
            if (billType == null) {
                return true;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return true;
            }
            sql = this.getCheckAuditSQL4SO(ctx, "T_SD_SaleOrderEntry", "T_SD_SaleOrder", new String[]{pk.toString()});
        } else if (model instanceof TransferOrderBillInfo) {
            billType = ((TransferOrderBillInfo)model).getSourceBillType();
            if (billType == null) {
                return true;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return true;
            }
            sql = this.getCheckAuditSQL(ctx, "T_IM_TransferOrderBillEntry", "T_IM_TransferOrderBill", new String[]{pk.toString()});
        }
        if (sql != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, sql);
            ArrayList<String> errls = new ArrayList<String>();
            int errors = 0;
            String stringNo = InvServerUtils.getResource(ctx, "No");
            String stringRow = InvServerUtils.getResource(ctx, "Row");
            String overQtyStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"OverQty", (Context)ctx);
            try {
                while (rs.next()) {
                    if (rs.getBigDecimal("FOverQty") == null || rs.getBigDecimal("FOverQty").signum() != 1) continue;
                    BigDecimal overQty = rs.getBigDecimal("FOverQty");
                    BigDecimal allowQty = rs.getBigDecimal("FBaseQty").multiply(new BigDecimal("0.0001"));
                    if (overQty.abs().subtract(allowQty).signum() != 1) continue;
                    overQty = overQty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                    String content = stringNo + rs.getInt("FSeq") + stringRow + rs.getString("FMaterialName") + " " + overQtyStr + overQty.toString() + rs.getString("FUnitName") + "\n";
                    errls.add(content);
                    if (++errors < 5) continue;
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException("execute QuerySQL exception : " + sql, (Throwable)e);
            }
            if (errors > 0) {
                canAudit = false;
                String measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("\n");
                int count = errls.size();
                for (int i = 0; i < count; ++i) {
                    errorMsg.append(errls.get(i));
                }
                errorMsg.append(measureUnitTransError);
                throw new InvBizException(InvBizException.REQ_QTY_OVER_STOCKREQ_QTY, new String[]{errorMsg.toString()});
            }
        }
        return canAudit;
    }

    private String getCheckAuditSQL(Context ctx, String destEntryTableName, String destBillTableName, String[] ids) {
        String locName = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select destEntry.Fid as FID, ");
        sql.append("destEntry.FSeq as FSeq, ");
        sql.append("isnull(destEntry.Fbaseqty,0) + isnull(srcEntry.Ftotalstockbaseqty,0) - round(isnull(srcEntry.FAuditBaseQty,0) * (1 + round(isnull(srcEntry.Foverdeliveryrate,0)/100, 4)),8) as FOverQty, ");
        sql.append("isnull(destEntry.Fbaseqty,0) as FBaseQty, ");
        sql.append("ma." + locName + " as FMaterialName, ");
        sql.append("mu." + locName + " as FUnitName, ");
        sql.append("mult.FBaseConvsRate as FBaseConvsRate, ");
        sql.append("mult.FQtyPrecision as FQtyPrecision ");
        sql.append("from " + destEntryTableName + " destEntry  ");
        sql.append("inner join " + destBillTableName + " destBill on destEntry.Fparentid = destBill.Fid ");
        sql.append("inner join T_IM_StockReqEntry srcEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("inner join T_BD_Material ma on destEntry.Fmaterialid = ma.fid ");
        sql.append("inner join t_bd_multimeasureunit mult on destEntry.Fmaterialid = mult.FMaterialID and destEntry.Funitid=mult.Fmeasureunitid ");
        sql.append("inner join t_bd_measureunit mu on destEntry.Funitid=mu.FID ");
        sql.append("where destBill.fid in " + InvServerUtils.getInStringFromArray(ids) + " ");
        sql.append("and srcEntry.Fisuncontrolqty = 0 ");
        sql.append("order by destEntry.fseq asc ");
        return sql.toString();
    }

    private String getCheckAuditSQL4SO(Context ctx, String destEntryTableName, String destBillTableName, String[] ids) {
        String locName = "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select destEntry.Fid as FID, ");
        sql.append("destEntry.FSeq as FSeq, ");
        sql.append(" case when destBill.FBaseStatus = 2 then ");
        sql.append("isnull(tmp.Fbaseqty,0) + isnull(srcEntry.Ftotalstockbaseqty,0) - round(isnull(srcEntry.FAuditBaseQty,0) * (1 + round(isnull(srcEntry.Foverdeliveryrate,0)/100, 4)),8) ");
        sql.append(" else isnull(srcEntry.Ftotalstockbaseqty,0) - round(isnull(srcEntry.FAuditBaseQty,0) * (1 + round(isnull(srcEntry.Foverdeliveryrate,0)/100, 4)),8) end as FOverQty , ");
        sql.append("isnull(tmp.Fbaseqty,0) as FBaseQty, ");
        sql.append("ma." + locName + " as FMaterialName, ");
        sql.append("mu." + locName + " as FUnitName, ");
        sql.append("mult.FBaseConvsRate as FBaseConvsRate, ");
        sql.append("mult.FQtyPrecision as FQtyPrecision ");
        sql.append("from " + destEntryTableName + " destEntry  ");
        sql.append("inner join " + destBillTableName + " destBill on destEntry.Fparentid = destBill.Fid ");
        sql.append("inner join T_IM_StockReqEntry srcEntry on destEntry.Fsourcebillentryid = srcEntry.Fid ");
        sql.append("inner join (select sum(isnull(destEntry.Fbaseqty,0)) as FbaseQty,destEntry.FSOURCEBILLENTRYID as FSOURCEBILLENTRYID ");
        sql.append("from " + destEntryTableName + " destEntry where destEntry.FPARENTID in  (" + InvServerUtils.getInStringFromArray(ids) + ") ");
        sql.append("group by destEntry.FSOURCEBILLENTRYID) tmp on tmp.FSOURCEBILLENTRYID = srcEntry.fid ");
        sql.append("inner join T_BD_Material ma on destEntry.Fmaterialid = ma.fid ");
        sql.append("inner join t_bd_multimeasureunit mult on destEntry.Fmaterialid = mult.FMaterialID and destEntry.Funitid=mult.Fmeasureunitid ");
        sql.append("inner join t_bd_measureunit mu on destEntry.Funitid=mu.FID ");
        sql.append("where destBill.fid in " + InvServerUtils.getInStringFromArray(ids) + " ");
        sql.append("and srcEntry.Fisuncontrolqty = 0 ");
        sql.append("order by destEntry.fseq asc ");
        return sql.toString();
    }

    @Override
    protected void _batchCheckSrcBillStockReqAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BillTypeInfo billType;
        if (ids.length == 0) {
            return;
        }
        BOSObjectType type = BOSUuid.read((String)ids[0]).getType();
        IObjectValue model = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(ids[0]));
        String sql = null;
        if (model instanceof StockReqInfo) {
            billType = ((StockReqInfo)model).getSourceBillType();
            if (billType == null) {
                return;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return;
            }
            sql = this.getCheckAuditSQL(ctx, "T_IM_StockReqEntry", "T_IM_StockReq", ids);
        } else if (model instanceof PurOrderInfo) {
            billType = ((PurOrderInfo)model).getSourceBillType();
            if (billType == null) {
                return;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return;
            }
            sql = this.getCheckAuditSQL4SO(ctx, "T_SM_PurOrderEntry", "T_SM_PurOrder", ids);
        } else if (model instanceof SaleOrderInfo) {
            billType = ((SaleOrderInfo)model).getSourceBillType();
            if (billType == null) {
                return;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return;
            }
            sql = this.getCheckAuditSQL4SO(ctx, "T_SD_SaleOrderEntry", "T_SD_SaleOrder", ids);
        } else if (model instanceof TransferOrderBillInfo) {
            billType = ((TransferOrderBillInfo)model).getSourceBillType();
            if (billType == null) {
                return;
            }
            if (!"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(billType.getId().toString())) {
                return;
            }
            sql = this.getCheckAuditSQL(ctx, "T_IM_TransferOrderBillEntry", "T_IM_TransferOrderBill", ids);
        }
        if (sql != null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, sql);
            ArrayList<String> errls = new ArrayList<String>();
            int errors = 0;
            String stringNo = InvServerUtils.getResource(ctx, "No");
            String stringRow = InvServerUtils.getResource(ctx, "Row");
            String overQtyStr = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"OverQty", (Context)ctx);
            boolean isFirst = true;
            String measureUnitTransError = null;
            try {
                while (rs.next()) {
                    if (rs.getBigDecimal("FOverQty") == null || rs.getBigDecimal("FOverQty").signum() != 1) continue;
                    BigDecimal overQty = rs.getBigDecimal("FOverQty");
                    BigDecimal allowQty = rs.getBigDecimal("FBaseQty").multiply(new BigDecimal("0.0001"));
                    if (overQty.abs().subtract(allowQty).signum() != 1) continue;
                    if ((overQty = overQty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4)).signum() == 0 && isFirst) {
                        measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                        isFirst = false;
                    }
                    String content = stringNo + rs.getInt("FSeq") + stringRow + rs.getString("FMaterialName") + " " + overQtyStr + overQty.toString() + rs.getString("FUnitName") + "\n";
                    errls.add(content);
                    if (++errors < 5) continue;
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException("execute QuerySQL exception : " + sql, (Throwable)e);
            }
            if (errors > 0) {
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("\n");
                int count = errls.size();
                for (int i = 0; i < count; ++i) {
                    errorMsg.append(errls.get(i));
                }
                if (!StringUtil.isEmpty(measureUnitTransError)) {
                    errorMsg.append(measureUnitTransError);
                }
                throw new InvBizException(InvBizException.REQ_QTY_OVER_STOCKREQ_QTY, new String[]{errorMsg.toString()});
            }
        }
    }
}

