/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IStockTransferBill;
import com.kingdee.eas.scm.im.inv.IStockTransferBillEntry;
import com.kingdee.eas.scm.im.inv.StockTransferBillCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockTransferBillEntryControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.reservation.service.ReservationBillCloseService;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StockTransferBillEntryControllerBean
extends AbstractStockTransferBillEntryControllerBean {
    private static final long serialVersionUID = 7661381325465905357L;

    private StockTransferBillEntryInfo getEntryFromBill(String entryPk, StockTransferBillInfo bill) {
        StockTransferBillEntryCollection entrys = bill.getEntry();
        for (int h = 0; h < entrys.size(); ++h) {
            if (!entrys.get(h).getId().toString().equals(entryPk)) continue;
            return entrys.get(h);
        }
        return null;
    }

    private void closeBill(Context ctx, StockTransferBillInfo bill, ArrayList entryPKS) throws EASBizException, BOSException {
        StockTransferBillEntryCollection entrys = bill.getEntry();
        StockTransferBillEntryInfo entry = null;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entry = entrys.get(i);
            if (entry.getBaseStatus().getValue() == 7 || entryPKS.contains(entry.getId().toString())) continue;
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update T_IM_StockTransferBill set FBaseStatus = ").append(7);
        sb.append(" where fid = '").append(bill.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected IObjectCollection _handleCloseOneEntry(Context ctx, IObjectValue entryId) throws BOSException {
        return null;
    }

    @Override
    protected IObjectCollection _handleCloseOneBill(Context ctx, IObjectPK[] pks, String reasonCode) throws BOSException, EASBizException {
        IStockTransferBillEntry ientry = StockTransferBillEntryFactory.getLocalInstance(ctx);
        IStockTransferBill ibill = StockTransferBillFactory.getLocalInstance(ctx);
        StockTransferBillEntryInfo entry = ientry.getStockTransferBillEntryInfo(pks[0]);
        ObjectUuidPK billID = new ObjectUuidPK(entry.getParent().getId());
        StockTransferBillInfo bill = ibill.getStockTransferBillInfo((IObjectPK)billID);
        ArrayList<String> entryPKS = new ArrayList<String>();
        int length = pks.length;
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        ArrayList<String[]> paramsList = new ArrayList<String[]>();
        String[] idArr = null;
        for (int i = 0; i < pks.length; ++i) {
            ids.add(pks[i]);
            idArr = new String[]{pks[i].toString(), pks[i].toString()};
            paramsList.add(idArr);
        }
        Object closePeriodPreStmt = null;
        StockTransferBillEntryCollection entryCol = this.getEntryCol(ctx, ids, EntryBaseStatusEnum.AUDITED);
        boolean isSuccess = false;
        for (int i = 0; i < length; ++i) {
            isSuccess = false;
            entry = this.getEntryFromBill(pks[i].toString(), bill);
            int entryStatus = entry.getBaseStatus().getValue();
            if (entryStatus == 4) {
                entry.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                entry.setReason(reasonCode);
                entry.put("parentNum", bill.getNumber());
                super.handleCloseOneEntry(ctx, entry);
                ientry.update(pks[i], (CoreBaseInfo)entry);
                entryPKS.add(pks[i].toString());
                isSuccess = true;
            }
            this.writeLog(ctx, bill, entry, pks[i], "OPERATOR_CLOSE", isSuccess);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry SET FClosePeriod = (");
        sql.append(" SELECT isnull(MAX(a.FYEAR*100 + a.FPERIOD),199901)  FROM T_IM_MOVEINWAREHSBILL a ");
        sql.append(" INNER join T_IM_MOVEINWAREHSBILLENTRY  b on a.fid = b.FPARENTID ");
        sql.append(" WHERE b.FSTOCKTRANSBILLENTRYID = ?) where fid = ?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        paramsList.clear();
        sql.setLength(0);
        this.closeBill(ctx, bill, entryPKS);
        InvServerUtils.handleReqPlan(billID.toString(), "50957179-0105-1000-e003-3152c0a812fd463ED552", BizActionEnum.CLOSE, ctx);
        try {
            ReservationBillCloseService reservationBillCloseService = ReservationBillCloseService.getInstance();
            reservationBillCloseService.doBillReservationCancel(ctx, pks);
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return entryCol;
    }

    @Override
    protected IObjectCollection _handleClose(Context ctx, IObjectPK[] pks, String reasonCode) throws BOSException, EASBizException {
        IStockTransferBillEntry ientry = StockTransferBillEntryFactory.getLocalInstance(ctx);
        IStockTransferBill ibill = StockTransferBillFactory.getLocalInstance(ctx);
        StockTransferBillEntryInfo entry = null;
        StockTransferBillInfo bill = null;
        String parentID = "";
        ArrayList<String> entryPKS = new ArrayList<String>();
        HashMap bills = new HashMap();
        HashMap<String, StockTransferBillInfo> allBills = new HashMap<String, StockTransferBillInfo>();
        HashSet<IObjectPK> ids = new HashSet<IObjectPK>();
        for (int i = 0; i < pks.length; ++i) {
            ids.add(pks[i]);
        }
        StockTransferBillEntryCollection entryCol = this.getEntryCol(ctx, ids, EntryBaseStatusEnum.AUDITED);
        boolean isSuccesse = false;
        ArrayList<String[]> paramsList = new ArrayList<String[]>();
        String[] idArr = null;
        for (int i = 0; i < pks.length; ++i) {
            int entryStatus;
            idArr = new String[2];
            isSuccesse = false;
            entry = ientry.getStockTransferBillEntryInfo(pks[i]);
            parentID = entry.getParent().getId().toString();
            if (!allBills.containsKey(parentID)) {
                bill = ibill.getStockTransferBillInfo((IObjectPK)new ObjectUuidPK(parentID));
                allBills.put(parentID, bill);
            }
            if ((entryStatus = entry.getBaseStatus().getValue()) == 4) {
                isSuccesse = true;
                if (!bills.containsKey(parentID)) {
                    bills.put(parentID, allBills.get(parentID));
                }
                entry = this.getEntryFromBill(pks[i].toString(), (StockTransferBillInfo)bills.get(parentID));
                entry.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                entry.setReason(reasonCode);
                ientry.update(pks[i], (CoreBaseInfo)entry);
                entryPKS.add(pks[i].toString());
                idArr[0] = pks[i].toString();
                idArr[1] = pks[i].toString();
                paramsList.add(idArr);
                entry.put("parentNum", ((StockTransferBillInfo)bills.get(parentID)).getNumber());
                super.handleCloseOneEntry(ctx, entry);
            }
            this.writeLog(ctx, bill, entry, pks[i], "OPERATOR_CLOSE", isSuccesse);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_StockTransferBillEntry SET FClosePeriod = (");
        sql.append(" SELECT isnull(MAX(FYEAR*100 + FPERIOD),199901)  FROM T_IM_MOVEINWAREHSBILL a ");
        sql.append(" INNER join T_IM_MOVEINWAREHSBILLENTRY  b on a.fid = b.FPARENTID ");
        sql.append(" WHERE b.FSTOCKTRANSBILLENTRYID = ?) where fid = ?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
        paramsList.clear();
        Iterator iterator = bills.keySet().iterator();
        while (iterator.hasNext()) {
            bill = (StockTransferBillInfo)bills.get(iterator.next());
            this.closeBill(ctx, bill, entryPKS);
            InvServerUtils.handleReqPlan(bill.getId().toString(), "50957179-0105-1000-e003-3152c0a812fd463ED552", BizActionEnum.CLOSE, ctx);
        }
        try {
            ReservationBillCloseService reservationBillCloseService = ReservationBillCloseService.getInstance();
            reservationBillCloseService.doBillReservationCancel(ctx, pks);
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return entryCol;
    }

    private StockTransferBillEntryCollection getEntryCol(Context ctx, Set ids, EntryBaseStatusEnum status) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.NOTEQUALS));
        view.setFilter(filter);
        view.getSelector().add("seq");
        view.getSelector().add("baseStatus");
        view.getSelector().add("parent.number");
        return this.getStockTransferBillEntryCollection(ctx, view);
    }

    private void writeLog(Context ctx, StockTransferBillInfo bill, StockTransferBillEntryInfo entry, IObjectPK pk, String resName, boolean isSuccesse) throws EASBizException, BOSException {
        String companyId = bill.getIssueStorageOrgUnit().getId().toString();
        String operate = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)resName, null);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_handleClose", (BOSObjectType)entry.getBOSType(), (IObjectPK)pk, (String)this._getLogInfo(ctx, pk), (String)"im_transferOrder_close", (String)companyId, (String)operate);
        if (isSuccesse) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockTransferBillEntryInfo entry = (StockTransferBillEntryInfo)this.getValue(ctx, pk);
        StockTransferBillInfo bill = StockTransferBillFactory.getLocalInstance(ctx).getStockTransferBillInfo((IObjectPK)new ObjectUuidPK(entry.getParent().getId()));
        return bill.getNumber() + "  " + entry.getSeq();
    }

    @Override
    protected IObjectCollection _handleUnClose(Context ctx, List entryIDList, List idList) throws BOSException, EASBizException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StockTransferBillEntryCollection resultCol = new StockTransferBillEntryCollection();
        StockTransferBillInfo bill = null;
        StockTransferBillEntryInfo entry = null;
        HashMap bills = new HashMap();
        HashMap<String, StockTransferBillInfo> allBills = new HashMap<String, StockTransferBillInfo>();
        try {
            int i;
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            if (entryIDList == null || entryIDList.size() == 0) {
                IObjectCollection iObjectCollection = null;
                return iObjectCollection;
            }
            String ids = InvServerUtils.getInStringFromList(entryIDList);
            StockTransferBillEntryCollection entrys = this.getStockTransferBillEntryCollection(ctx, "select seq, baseStatus, parent.number, parent.id where id in " + ids);
            String oql = "select id, issueStorageOrgUnit.id, entry.id, entry.baseStatus where id in " + InvServerUtils.getInStringFromList(idList);
            StockTransferBillCollection coll = StockTransferBillFactory.getLocalInstance(ctx).getStockTransferBillCollection(oql.toString());
            int size = coll.size();
            for (i = 0; i < size; ++i) {
                allBills.put(coll.get(i).getId().toString(), coll.get(i));
            }
            for (i = 0; i < idList.size(); ++i) {
                if (allBills.get(idList.get(i)) != null) continue;
                throw new ObjectNotFoundException();
            }
            String parentID = null;
            boolean isSuccess = false;
            int size22 = entrys.size();
            for (int i2 = 0; i2 < size22; ++i2) {
                isSuccess = false;
                entry = entrys.get(i2);
                parentID = entry.getParent().getId().toString();
                bill = (StockTransferBillInfo)allBills.get(parentID);
                if (EntryBaseStatusEnum.CLOSED.equals((Object)entrys.get(i2).getBaseStatus())) {
                    if (!bills.containsKey(parentID)) {
                        bills.put(parentID, allBills.get(parentID));
                    }
                    isSuccess = true;
                } else {
                    resultCol.add(entrys.get(i2));
                }
                this.writeLog(ctx, bill, entry, (IObjectPK)new ObjectUuidPK(entry.getId().toString()), "OPERATOR_UNCLOSE", isSuccess);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("update T_IM_StockTransferBillEntry set FBaseStatus = ").append(4);
            sql.append(" , FReason = null where FID in ");
            sql.append(InvServerUtils.getInStringFromList(entryIDList));
            sql.append(" and FBaseStatus = ").append(7);
            stmt.execute(sql.toString());
            if (coll == null || coll.size() == 0) {
                StockTransferBillEntryCollection size22 = resultCol;
                return size22;
            }
            sql.setLength(0);
            sql.append("update T_IM_StockTransferBill set FBaseStatus = ").append(4);
            sql.append(" where FID in (");
            sql.append("select fparentid from T_IM_StockTransferBillEntry where fid in ");
            sql.append(ids);
            sql.append(" and FBaseStatus <> ").append(7);
            sql.append(") and FBaseStatus = ").append(7);
            stmt.execute(sql.toString());
            Iterator iterator = bills.keySet().iterator();
            while (iterator.hasNext()) {
                bill = (StockTransferBillInfo)bills.get(iterator.next());
                InvServerUtils.handleReqPlan(bill.getId().toString(), "50957179-0105-1000-e003-3152c0a812fd463ED552", BizActionEnum.UNCLOSE, ctx);
            }
            StockTransferBillEntryCollection stockTransferBillEntryCollection = resultCol;
            return stockTransferBillEntryCollection;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
    }
}

