/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvImportException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class StockTransferBillImport
extends InvDataImport {
    StockTransferBillInfo stockTransferInfo = null;
    StorageOrgUnitInfo issueStorage = null;
    ImportDataCache dataPool = new ImportDataCache();
    Set<String> manufactureStrategy = new HashSet<String>();
    private static String resources = "com.kingdee.eas.scm.im.inv.app.StockTransferImportResource";
    public static final BigDecimal MAXVAL = new BigDecimal("1000000000000");

    public StockTransferBillImport() {
        this.manufactureStrategy.add("MTS10");
        this.manufactureStrategy.add("MTS11");
        this.manufactureStrategy.add("MTS20");
        this.manufactureStrategy.add("ETO10");
        this.manufactureStrategy.add("ETO20");
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return StockTransferBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.stockTransferInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(i);
            if (i == 0) {
                try {
                    this.stockTransferInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, this.stockTransferInfo, lineData);
                    if (this.stockTransferInfo == null) {
                        return null;
                    }
                }
                catch (TaskExternalException ex) {
                    tex.addEntryErrorReason(i, ex.getMessage());
                    this.recycleNumber(ctx, this.stockTransferInfo);
                    break;
                }
            }
            try {
                StockTransferBillEntryInfo entryInfo = null;
                entryInfo = this.transmitEntry(lineData, ctx);
                this.afterBuildEntry(entryInfo);
                continue;
            }
            catch (TaskExternalException ex) {
                tex.addEntryErrorReason(i, ex.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, this.stockTransferInfo);
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.stockTransferInfo;
    }

    private void afterBuildEntry(StockTransferBillEntryInfo entryInfo) {
        int seq = this.stockTransferInfo.getEntry().size() + 1;
        entryInfo.setSeq(seq);
        entryInfo.setParent(this.stockTransferInfo);
        this.stockTransferInfo.getEntry().add(entryInfo);
    }

    private StockTransferBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.stockTransferInfo = new StockTransferBillInfo();
        this.doIssueStorageOrgUnit(ctx, lineData);
        this.stockTransferInfo.setCU(this.issueStorage.getCU());
        this.doBizTypeInfo(ctx, lineData);
        Object dateO = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (dateO == null || dateO.toString().trim().equals("")) {
            throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"BIZDATE_NOT_NULL", (String)resources));
        }
        Date bizDate = this.doDate(ctx, lineData, "FBizDate", false);
        this.stockTransferInfo.setBizDate(bizDate);
        this.stockTransferInfo.setIssueCompanyOrgUnit(this.getCompanyOrgFromStorageOrg(ctx, this.issueStorage));
        this.doInStorageOrgUnit(lineData, ctx);
        if (this.stockTransferInfo.getReceiptStorageOrgUnit() != null && this.stockTransferInfo.getReceiptStorageOrgUnit().getId() != null) {
            this.stockTransferInfo.setReceiptCompanyOrgUnit(this.getCompanyOrgFromStorageOrg(ctx, this.stockTransferInfo.getReceiptStorageOrgUnit()));
        }
        this.stockTransferInfo.setIssueAdminOrgUnit(this.getDepartment(lineData, ctx, "number", "FIssueAdminOrgUnit_number"));
        this.stockTransferInfo.setReceiptAdminOrgUnit(this.getDepartment(lineData, ctx, "number", "FReceiptAdminOrgUnit_number"));
        this.doCreator(ctx, lineData);
        this.doCreateDate(ctx, lineData);
        this.stockTransferInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        aBillTypeInfo.setNumber("140");
        this.stockTransferInfo.setBillType(aBillTypeInfo);
        return this.stockTransferInfo;
    }

    private void doCreateDate(Context ctx, Map lineData) throws TaskExternalException {
        this.stockTransferInfo.setCreateTime(new Timestamp(new Date().getTime()));
    }

    private void doCreator(Context ctx, Map lineData) throws TaskExternalException {
        Object dateO = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        this.stockTransferInfo.setCreator(this.getCreator(ctx, dateO));
    }

    private Date doDate(Context ctx, Map lineData, String fileName, boolean hasDefaultValue) throws TaskExternalException {
        Object dateO = ((DataToken)lineData.get((Object)fileName)).data;
        Date date = this.getDate(ctx, dateO);
        return date;
    }

    private void doInStorageOrgUnit(Map lineData, Context ctx) throws TaskExternalException {
        String bizTypeNumber = this.stockTransferInfo.getBizType().getNumber();
        StorageOrgUnitInfo inStorage = null;
        if (bizTypeNumber.equals("330") || bizTypeNumber.equals("331")) {
            inStorage = this.stockTransferInfo.getIssueStorageOrgUnit();
        } else {
            String[] msgs = new String[]{"InSTORAGE_NOT_NULL", "InSTORAGE_NOT_BIZUNIT", "InSTORAGE_NOT_EXIST"};
            inStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FReceiptStorageOrgUnit_number", msgs);
            if (inStorage.getNumber().equals(this.stockTransferInfo.getIssueStorageOrgUnit().getNumber())) {
                throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"STORAGE_NOT_VAILD", (String)resources));
            }
        }
        this.stockTransferInfo.setReceiptStorageOrgUnit(inStorage);
    }

    private void doIssueStorageOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        String[] msgs = new String[]{"OutSTORAGE_NOT_NULL", "OutSTORAGE_NOT_BIZUNIT", "OutSTORAGE_NOT_EXIST"};
        this.issueStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FIssueStorageOrgUnit_number", msgs);
        this.stockTransferInfo.setIssueStorageOrgUnit(this.issueStorage);
    }

    private StorageOrgUnitInfo getStorageOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName, String[] msgs) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        storageOrgUnitInfo = this.getStorageOrgUnit(ctx, byProperty, souData, resources, msgs);
        return storageOrgUnitInfo;
    }

    private AdminOrgUnitInfo getDepartment(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object adminData = ((DataToken)lineData.get((Object)propertyName)).data;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        adminOrgUnitInfo = this.getAdminOrgUnit(ctx, byProperty, adminData);
        return adminOrgUnitInfo;
    }

    private void doBizTypeInfo(Context ctx, Map lineData) throws TaskExternalException {
        try {
            this.loadBizType(lineData, ctx, "number", "FBizType_number");
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
    }

    private void loadBizType(Map lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        this.stockTransferInfo.setBizType(this.getBizType(ctx, "50957179-0105-1000-e003-3152c0a812fd463ED552", byProperty, souData));
    }

    private StockTransferBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException {
        StockTransferBillEntryInfo entryInfo = new StockTransferBillEntryInfo();
        this.doEntryMaterial(lineData, ctx, entryInfo);
        this.doEntryAssistProperty(lineData, ctx, entryInfo);
        Object data = ((DataToken)lineData.get((Object)"FEntry_isMrpCal")).data;
        entryInfo.setIsMrpCal(DataImportUtils.getBooleanValue((Object)data, (boolean)true));
        this.doEntryLot(lineData, ctx, entryInfo);
        this.doEntryMfgExp(ctx, lineData, entryInfo);
        this.doEntryUnit(lineData, ctx, entryInfo);
        this.doEntryQty(lineData, ctx, entryInfo);
        this.doEntryBaseUnit(ctx, lineData, entryInfo);
        this.doEntryAssistUnit(ctx, entryInfo, lineData);
        this.doInvType(ctx, entryInfo, lineData);
        this.doInvStatus(ctx, entryInfo, lineData);
        this.doCustomerAndSupp(ctx, entryInfo, lineData);
        this.doWarehouse(ctx, entryInfo, lineData);
        this.doLocation(ctx, entryInfo, lineData);
        Object IsPresentdata = ((DataToken)lineData.get((Object)"FEntry_isPresent")).data;
        entryInfo.setIsPresent(DataImportUtils.getBooleanValue((Object)IsPresentdata, (boolean)false));
        if (!entryInfo.isIsPresent()) {
            this.doEntryAmountPrice(ctx, entryInfo, lineData);
        }
        this.doEntryProjectNum(ctx, lineData, entryInfo);
        this.doEntryTrackNum(ctx, lineData, entryInfo);
        entryInfo.setReceiptPlanDate(this.doDate(ctx, lineData, "FEntry_receiptPlanDate", true));
        entryInfo.setIssuePlanDate(this.doDate(ctx, lineData, "FEntry_issuePlanDate", true));
        try {
            this.checkQtyPrecision(ctx, entryInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (InvImportException e) {
            e.printStackTrace();
        }
        return entryInfo;
    }

    private void doWarehouse(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        Object issueWarehouseObj = ((DataToken)lineData.get((Object)"FEntry$issueWarehouse_number")).data;
        Object receiptWarehouseObj = ((DataToken)lineData.get((Object)"FEntry$receiptWarehouse_number")).data;
        WarehouseInfo issueWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)this.issueStorage, issueWarehouseObj, resources, "WAREHS_NOT_ENABLE", "WAREHS_NOT_EXIST", null, "RelationNotExists");
        entryInfo.setIssueWarehouse(issueWarehouse);
        WarehouseInfo receiptWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)this.stockTransferInfo.getReceiptStorageOrgUnit(), receiptWarehouseObj, resources, "WAREHS_NOT_ENABLE", "WAREHS_NOT_EXIST", null, "RelationNotExists");
        entryInfo.setReceiptWarehouse(receiptWarehouse);
    }

    private void doLocation(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        Object issueLocationObj = ((DataToken)lineData.get((Object)"FEntry$issueLocation_number")).data;
        Object receiptLocationObj = ((DataToken)lineData.get((Object)"FEntry$receiptLocation_number")).data;
        LocationInfo issueLocation = this.getLocation(ctx, "number", issueLocationObj, entryInfo.getIssueWarehouse(), resources, "LOCATION_NOT_ENABLE", "LOCATION_NOT_FIND", "LOCATION_NOT_NULL", null);
        entryInfo.setIssueLocation(issueLocation);
        LocationInfo receiptLocation = this.getLocation(ctx, "number", receiptLocationObj, entryInfo.getReceiptWarehouse(), resources, "LOCATION_NOT_ENABLE", "LOCATION_NOT_FIND", "LOCATION_NOT_NULL", null);
        entryInfo.setReceiptLocation(receiptLocation);
    }

    private void doEntryProjectNum(Context ctx, Map lineData, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getMaterial() != null && this.issueStorage != null) {
            MaterialPlanInfo mpInfo = this.getMaterialPlan(ctx, entryInfo.getMaterial(), this.issueStorage, resources, null);
            ProjectInfo pro = this.getProject(ctx, data, this.issueStorage.getCU());
            if (mpInfo != null) {
                ManufactureStrategyInfo strategy = mpInfo.getManufactureStrategy();
                if (strategy == null || this.manufactureStrategy.contains(strategy.getNumber())) {
                    entryInfo.setProject(pro);
                }
            } else {
                entryInfo.setProject(pro);
            }
        }
    }

    private void doEntryTrackNum(Context ctx, Map lineData, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        if (data != null && data.toString().length() > 0) {
            TrackNumberInfo info = null;
            info = this.getTrackNumber(ctx, data, this.issueStorage.getCU());
            entryInfo.setTrackNumber(info);
        }
    }

    private void doEntryAmountPrice(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        BigDecimal price = this.getAmountOrPrice(ctx, entryInfo, lineData, "FEntry_price");
        MaterialInfo material = entryInfo.getMaterial();
        BigDecimal amount = this.getAmountOrPrice(ctx, entryInfo, lineData, "FEntry_amount");
        int precision = 2;
        CurrencyInfo localCurrency = this.stockTransferInfo.getIssueCompanyOrgUnit().getBaseCurrency();
        if (localCurrency != null && localCurrency.getId() != null) {
            SelectorItemCollection selectColl = new SelectorItemCollection();
            selectColl.add(new SelectorItemInfo("id"));
            selectColl.add(new SelectorItemInfo("precision"));
            try {
                localCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(localCurrency.getId().toString()), selectColl);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            precision = localCurrency.getPrecision();
        }
        amount.setScale(precision, RoundingMode.HALF_UP);
        entryInfo.setAmount(amount);
        price = price.setScale(material.getPricePrecision(), RoundingMode.HALF_UP);
        entryInfo.setPrice(price);
        BigDecimal resutlAmount = price.multiply(entryInfo.getQty()).setScale(precision, RoundingMode.HALF_UP);
        if (resutlAmount.compareTo(amount) != 0) {
            throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"notEqual", (String)resources));
        }
    }

    private BigDecimal getAmountOrPrice(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData, String filedName) throws TaskExternalException {
        BigDecimal value = null;
        Object o = ((DataToken)lineData.get((Object)filedName)).data;
        try {
            if (o.toString().trim().length() == 0) {
                value = SCMConstant.BIGDECIMAL_ZERO;
            } else {
                value = new BigDecimal(o.toString());
                if (value.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                    throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"priceOrAmt_not_nagtive", (String)resources));
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"priceOrAmt_ERROR", (String)resources));
        }
        return value;
    }

    private void doCustomerAndSupp(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        StoreTypeInfo storeType = entryInfo.getStoreType();
        StoreFlagEnum storeFlagEnum = storeType.getStoreFlag();
        CustomerInfo customer = null;
        Object customerData = ((DataToken)lineData.get((Object)"FEntry$customer_number")).data;
        if (!"".equals(customerData)) {
            customer = this.getCustomer(ctx, customerData);
            entryInfo.setCustomer(customer);
        }
        if ((storeFlagEnum == StoreFlagEnum.CUSTOMER || storeFlagEnum == StoreFlagEnum.TOCUSTOMER) && customer == null) {
            throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"CUSTOMER_NOT_NULL", (String)resources));
        }
        SupplierInfo supplierInfo = null;
        Object supplierData = ((DataToken)lineData.get((Object)"FEntry$supplier_number")).data;
        if (!"".equals(supplierData)) {
            supplierInfo = this.getSupplier(ctx, "number", supplierData);
            entryInfo.setSupplier(supplierInfo);
        }
        if ((storeFlagEnum == StoreFlagEnum.SUPPLIER || storeFlagEnum == StoreFlagEnum.TOSUPPLIER) && supplierInfo == null) {
            throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"SUPPLIER_NOT_NULL", (String)resources));
        }
    }

    private void doInvType(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        Object invTypeData = ((DataToken)lineData.get((Object)"FEntry$storeType_number")).data;
        StoreTypeInfo storeType = this.getStoreType(ctx, invTypeData);
        if (storeType == null) {
            storeType = new StoreTypeInfo();
            storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
            storeType.setNumber("G");
        }
        entryInfo.setStoreType(storeType);
    }

    private void doInvStatus(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        Object invStatusData = ((DataToken)lineData.get((Object)"FEntry$storeState_number")).data;
        StoreStateInfo storeStateInfo = this.getStoreState(ctx, invStatusData);
        if (storeStateInfo == null) {
            storeStateInfo = new StoreStateInfo();
            storeStateInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            storeStateInfo.setNumber("1");
        }
        entryInfo.setStoreState(storeStateInfo);
    }

    private void doEntryAssistUnit(Context ctx, StockTransferBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
        if (entryInfo.getAssistUnit() != null) {
            Object cellData = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
            BigDecimal assistQty = DataImportUtils.getDataDeciaml((Context)ctx, (String)cellData.toString());
            if (assistQty.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                throw new TaskExternalException(assistQty.toString() + StockTransferBillImport.getResource((Context)ctx, (String)"assistQty_nagtive", (String)resources));
            }
            if (!this.isVaildDigDecimal(assistQty)) {
                throw new TaskExternalException(assistQty.toString() + StockTransferBillImport.getResource((Context)ctx, (String)"QTY_TOO_LONG", (String)resources));
            }
            entryInfo.setAssistQty(assistQty);
        } else {
            entryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryBaseUnit(Context ctx, Map lineData, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getBaseUnit() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                BigDecimal baseUnitQty = null;
                try {
                    baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                entryInfo.setBaseQty(baseUnitQty);
            }
        }
    }

    private void doEntryQty(Map lineData, Context ctx, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        if (data != null && data.toString().length() > 0) {
            try {
                BigDecimal qty = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
                if (qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                    throw new TaskExternalException(StockTransferBillImport.getResource((Context)ctx, (String)"qty_nagtive", (String)resources));
                }
                if (!this.isVaildDigDecimal(qty)) {
                    throw new TaskExternalException(qty.toString() + StockTransferBillImport.getResource((Context)ctx, (String)"QTY_TOO_LONG", (String)resources));
                }
                entryInfo.setQty(qty);
            }
            catch (Exception e) {
                String str = StockTransferBillImport.getResource((Context)ctx, (String)"QTY_ERROR", (String)resources);
                throw new TaskExternalException(str);
            }
        } else {
            String str = StockTransferBillImport.getResource((Context)ctx, (String)"QTY_NOT_NULL", (String)resources);
            throw new TaskExternalException(str);
        }
    }

    private boolean isVaildDigDecimal(BigDecimal data) {
        return data.abs().compareTo(MAXVAL) < 0;
    }

    private void doEntryUnit(Map lineData, Context ctx, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        MeasureUnitInfo unitInfo = this.getMeasureUnit(ctx, data, entryInfo.getMaterial());
        entryInfo.setUnit(unitInfo);
    }

    private void doEntryMfgExp(Context ctx, Map lineData, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object mfg = ((DataToken)lineData.get((Object)"FEntry_mfg")).data;
        Object exp = ((DataToken)lineData.get((Object)"FEntry_exp")).data;
        Date[] date = this.getMfgAndExp(ctx, entryInfo.getMaterial(), entryInfo.getLot(), this.issueStorage, mfg, exp, false);
        if (date != null) {
            entryInfo.setMfg(date[0]);
            entryInfo.setExp(date[1]);
        }
    }

    private void doEntryLot(Map lineData, Context ctx, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
        if (this.checkLotInfo(ctx, entryInfo.getMaterial(), this.issueStorage)) {
            if (data != null && data.toString().trim().length() > 0) {
                entryInfo.setLot(data.toString().trim());
            }
        } else {
            entryInfo.setLot(null);
        }
    }

    private void doEntryAssistProperty(Map lineData, Context ctx, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        AsstAttrValueInfo asstAttr = this.getAsstAttr(ctx, data, entryInfo.getMaterial().getAssistAttr());
        entryInfo.setAssistProperty(asstAttr);
    }

    private void doEntryMaterial(Map lineData, Context ctx, StockTransferBillEntryInfo entryInfo) throws TaskExternalException {
        Object materialNumber = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        MaterialInfo materialInfo = this.getMaterial(ctx, materialNumber, resources, "MATERIAL_NOT_NULL", "MATERIAL_NOT_NULL", new OrgUnitInfo[]{this.issueStorage, this.stockTransferInfo.getIssueCompanyOrgUnit()});
        if (materialInfo != null) {
            entryInfo.setMaterial(materialInfo);
        }
    }

    public boolean isSupporNumberRule(Context ctx) {
        return super.isSupporNumberRule(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.StockTransferBillExportQuery";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FIssueStorageOrgUnit_number", rs.getString("moveOutStorageOrgUnit.number"));
            this.putTable(result, "FIssueStorageOrgUnit_name_l2", rs.getString("moveOutStorageOrgUnit.name"));
            this.putTable(result, "FReceiptStorageOrgUnit_number", rs.getString("moveInStorageOrgUnit.number"));
            this.putTable(result, "FReceiptStorageOrgUnit_name_l2", rs.getString("moveInStorageOrgUnit.name"));
            this.putTable(result, "FIssueAdminOrgUnit_number", rs.getString("moveOutDepartment.number"));
            this.putTable(result, "FReceiptAdminOrgUnit_number", rs.getString("moveInDepartment.number"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$material_name_l2", rs.getString("material.name"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry_isMrpCal", rs.getString("entry.isMrpCal"));
            this.putTable(result, "FEntry_lot", rs.getString("entry.lot"));
            this.putTable(result, "FEntry_mfg", rs.getString("entry.mfg"));
            this.putTable(result, "FEntry_exp", rs.getString("entry.exp"));
            this.putTable(result, "FEntry$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntry_qty", rs.getBigDecimal("entry.qty"));
            this.putTable(result, "FEntry_assistQty", rs.getBigDecimal("entry.assistQty"));
            this.putTable(result, "FEntry$storeType_number", rs.getString("storeType.number"));
            this.putTable(result, "FEntry$storeState_number", rs.getString("storeState.number"));
            this.putTable(result, "FEntry$customer_number", rs.getString("customer.number"));
            this.putTable(result, "FEntry$supplier_number", rs.getString("supplier.number"));
            this.putTable(result, "FEntry$issueWarehouse_number", rs.getString("moveOutWarehouse.number"));
            this.putTable(result, "FEntry$issueLocation_number", rs.getString("issueLocation.number"));
            this.putTable(result, "FEntry$receiptWarehouse_number", rs.getString("moveInWarehouse.number"));
            this.putTable(result, "FEntry$receiptLocation_number", rs.getString("receiptLocation.number"));
            this.putTable(result, "FEntry_isPresent", rs.getString("entry.isPresent"));
            this.putTable(result, "FEntry_price", rs.getBigDecimal("entry.price"));
            this.putTable(result, "FEntry_amount", rs.getBigDecimal("entry.amount"));
            this.putTable(result, "FEntry$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntry$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FEntry_receiptPlanDate", rs.getString("entry.receiptPlanDate"));
            this.putTable(result, "FEntry_issuePlanDate", rs.getString("entry.issuePlanDate"));
            this.putTable(result, "FCreator_number", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("createTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public int getSubmitType() {
        return 1;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "stocktransfer_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("moveOutStorageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return oldFilterInfo;
    }

    private void checkQtyPrecision(Context ctx, StockTransferBillEntryInfo entryInfo) throws BOSException, InvImportException {
        MultiMeasureUnitInfo multiAssistUnitInfo;
        int nowPrecision;
        MultiMeasureUnitInfo multiUnitInfo;
        MaterialInfo materialInfo = entryInfo.getMaterial();
        MeasureUnitInfo unitInfo = entryInfo.getUnit();
        MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
        MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
        if (materialInfo == null || unitInfo == null) {
            return;
        }
        if (this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString()) == null) {
            HashSet<String> materialIdSet = new HashSet<String>();
            HashSet<String> unitIdSet = new HashSet<String>();
            if (materialInfo != null) {
                materialIdSet.add(materialInfo.getId().toString());
            }
            if (unitInfo != null) {
                unitIdSet.add(unitInfo.getId().toString());
            }
            if (baseUnitInfo != null) {
                unitIdSet.add(baseUnitInfo.getId().toString());
            }
            if (assistUnitInfo != null) {
                unitIdSet.add(assistUnitInfo.getId().toString());
            }
            if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
                Map<String, MultiMeasureUnitInfo> multiUnitMap = InvServerUtils.getMultiMeasureUnitMap(ctx, materialIdSet, unitIdSet);
                this.dataPool.putMultiMeasureUnitMap(multiUnitMap);
            }
        }
        if (unitInfo != null && (multiUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString())) != null) {
            int qtyPrecision = multiUnitInfo.getQtyPrecision();
            BigDecimal qty = entryInfo.getQty();
            if (qty != null && qtyPrecision < (nowPrecision = qty.scale())) {
                throw new InvImportException(InvImportException.QTY_PRECISION_INVALID, new String[]{materialInfo.getName(), unitInfo.getName(), qtyPrecision + ""});
            }
        }
        if (assistUnitInfo != null && (multiAssistUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + assistUnitInfo.getId().toString())) != null) {
            int assistQtyPrecision = multiAssistUnitInfo.getQtyPrecision();
            BigDecimal assistQty = entryInfo.getAssistQty();
            if (assistQty != null && assistQtyPrecision < (nowPrecision = assistQty.scale())) {
                throw new InvImportException(InvImportException.ASSISTQTY_PRECISION_INVALID, new String[]{materialInfo.getName(), assistQtyPrecision + ""});
            }
        }
    }

    public String getImportPermissionItem() {
        return "stocktransfer_new";
    }
}

