/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SupplyRelationServerUtils {
    private static EntityViewInfo nullView;

    private static final SupplyRelationInfo findAndSetSupplyRelationFromGenerated(TransferOrderBillInfo info, TransferOrderBillEntryInfo entry, Set srSet) {
        SupplyRelationInfo srInfo2 = null;
        for (SupplyRelationInfo srInfo2 : srSet) {
            if (!SCMUtils.equalsID((ObjectBaseInfo)srInfo2.getRequireStorageOrgUnit(), (ObjectBaseInfo)info.getReceiptStorageOrgUnit()) || !SCMUtils.equalsID((ObjectBaseInfo)srInfo2.getSupplyStorageOrgUnit(), (ObjectBaseInfo)info.getIssueStorageOrgUnit()) || !SCMUtils.equalsID((ObjectBaseInfo)srInfo2.getIssueStorageOrgUnit(), (ObjectBaseInfo)entry.getIssueStorageOrgUnit()) || !SCMUtils.equalsID((ObjectBaseInfo)srInfo2.getReceiveStorageOrgUnit(), (ObjectBaseInfo)entry.getReceiveStorageOrgUnit())) continue;
            entry.setSupplyRelation(srInfo2);
            return srInfo2;
        }
        return null;
    }

    public static final Map generateSupplyRelationByTransferOrder(Context ctx, TransferOrderBillInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        HashMap<BOSUuid, BOSUuid> map = new HashMap<BOSUuid, BOSUuid>(info.getEntry().size());
        HashMap<String, CtrlUnitInfo> cuMap = new HashMap<String, CtrlUnitInfo>(info.getEntry().size() * 2 + 2);
        HashSet<SupplyRelationInfo> srSet = new HashSet<SupplyRelationInfo>();
        TransferOrderBillEntryInfo entry = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int size = info.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entry = info.getEntry().get(i);
            if (entry.getSupplyRelation() != null && entry.getSupplyRelation().size() != 1) continue;
            entry.setSupplyRelation(null);
            filter.appendFilterItem("requireStorageOrgUnit", (Object)info.getReceiptStorageOrgUnit().getId());
            filter.appendFilterItem("supplyStorageOrgUnit", (Object)info.getIssueStorageOrgUnit().getId());
            filter.appendFilterItem("issueStorageOrgUnit", (Object)entry.getIssueStorageOrgUnit().getId());
            filter.appendFilterItem("receiveStorageOrgUnit", (Object)entry.getReceiveStorageOrgUnit().getId());
        }
        StringBuffer maskString = new StringBuffer();
        int size2 = filter.getFilterItems().size();
        for (int i = 0; i < size2; i += 4) {
            maskString.append("#").append(i).append(" and #").append(i + 1).append(" and #");
            maskString.append(i + 2).append(" and #").append(i + 3).append(" or ");
        }
        if (maskString.length() > 0) {
            maskString.delete(maskString.length() - 4, maskString.length() - 1);
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            SupplyRelationCollection srCol = SupplyRelationFactory.getLocalInstance(ctx).getSupplyRelationCollection(viewInfo);
            int size3 = srCol.size();
            for (int i = 0; i < size3; ++i) {
                srSet.add(srCol.get(i));
            }
        }
        String bizTypeID = info.getBizType().getId().toString();
        SupplyRelationInfo[] srInfos = new SupplyRelationInfo[info.getEntry().size()];
        if (info.getIssueCompanyOrgUnit().getCU() != null) {
            cuMap.put(info.getIssueCompanyOrgUnit().getId().toString(), info.getIssueCompanyOrgUnit().getCU());
        }
        if (info.getReceiptCompanyOrgUnit().getCU() != null) {
            cuMap.put(info.getReceiptCompanyOrgUnit().getId().toString(), info.getReceiptCompanyOrgUnit().getCU());
        }
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        HashSet<SupplyRelationInfo> resultSet = new HashSet<SupplyRelationInfo>();
        HashMap<String, SupplyRelationInfo> srMap = new HashMap<String, SupplyRelationInfo>();
        int n = info.getEntry().size();
        for (int i = 0; i < n; ++i) {
            SupplyRelationInfo sri;
            entry = info.getEntry().get(i);
            CompanyOrgUnitInfo issueCou = entry.getIssueCompanyOrgUnit();
            CompanyOrgUnitInfo recCou = entry.getReceiveCompanyOrgUnit();
            if (entry.getSupplyRelation() == null) {
                if (SupplyRelationServerUtils.findAndSetSupplyRelationFromGenerated(info, entry, srSet) == null) {
                    sri = new SupplyRelationInfo();
                    sri.setId(BOSUuid.create((String)"1D50E909"));
                    sri.setRequireStorageOrgUnit(info.getReceiptStorageOrgUnit());
                    sri.setRequireCompanyOrgUnit(info.getReceiptCompanyOrgUnit());
                    sri.setSupplyStorageOrgUnit(info.getIssueStorageOrgUnit());
                    sri.setSupplyCompanyOrgUnit(info.getIssueCompanyOrgUnit());
                    sri.setIssueStorageOrgUnit(entry.getIssueStorageOrgUnit());
                    sri.setIssueCompanyOrgUnit(issueCou);
                    sri.setReceiveStorageOrgUnit(entry.getReceiveStorageOrgUnit());
                    sri.setReceiveCompanyOrgUnit(recCou);
                    entry.setSupplyRelation(sri);
                    srSet.add(sri);
                    resultSet.add(sri);
                }
                map.put(entry.getId(), entry.getSupplyRelation().getId());
            }
            if (issueCou.getCU() != null && !cuMap.containsKey(issueCou.getId().toString())) {
                cuMap.put(issueCou.getId().toString(), issueCou.getCU());
            }
            if (recCou.getCU() != null && !cuMap.containsKey(recCou.getId().toString())) {
                cuMap.put(recCou.getId().toString(), recCou.getCU());
            }
            srInfos[i] = entry.getSupplyRelation();
            if (srInfos[i] == null || srInfos[i].getIssueCompanyOrgUnit() != null) continue;
            sri = (SupplyRelationInfo)srMap.get(srInfos[i].getId().toString());
            if (null == sri) {
                sri = isr.getSupplyRelationInfo((IObjectPK)new ObjectUuidPK(srInfos[i].getId().toString()));
                srMap.put(srInfos[i].getId().toString(), sri);
            }
            srInfos[i] = sri;
        }
        SupplyRelationServerUtils.setOuOfStorageUnit(ctx, srInfos, bizTypeID, cuMap);
        Iterator iter = resultSet.iterator();
        while (iter.hasNext()) {
            isr.addnew((CoreBaseInfo)iter.next());
        }
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID)) {
            SupplyRelationServerUtils.verifySupplierAndCustomerFor2Sides(ctx, srInfos);
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            SupplyRelationServerUtils.verifySupplierAndCustomerFor3Sides(ctx, srInfos);
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID)) {
            SupplyRelationServerUtils.verifySupplierAndCustomerFor4Sides(ctx, srInfos);
        }
        return map;
    }

    private static void verifySupplierAndCustomerFor2Sides(Context ctx, SupplyRelationInfo[] srInfos) throws BOSException, EASBizException {
        int length = srInfos.length;
        HashMap supMap = new HashMap(length);
        HashMap cusMap = new HashMap(length);
        String key = null;
        SupplyRelationInfo srInfo = null;
        for (int i = 0; i < length; ++i) {
            HashMap<String, Object> map;
            srInfo = srInfos[i];
            key = srInfo.getIssueCompanyOrgUnit().getId().toString() + srInfo.getReceiveCompanyOrgUnit().getCU().getId().toString();
            if (!supMap.containsKey(key)) {
                map = new HashMap<String, Object>(2);
                map.put("internalcompanyorg", srInfo.getIssueCompanyOrgUnit());
                map.put("controlunit", srInfo.getReceiveCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (cusMap.containsKey(key = srInfo.getReceiveCompanyOrgUnit().getId().toString() + srInfo.getIssueCompanyOrgUnit().getCU().getId().toString())) continue;
            map = new HashMap(2);
            map.put("internalcompanyorg", srInfo.getReceiveCompanyOrgUnit());
            map.put("controlunit", srInfo.getIssueCompanyOrgUnit().getCU());
            cusMap.put(key, map);
        }
        SupplyRelationServerUtils.checkInnerCustomers(ctx, cusMap);
        SupplyRelationServerUtils.checkInnerSuppliers(ctx, supMap);
    }

    private static void verifySupplierAndCustomerFor3Sides(Context ctx, SupplyRelationInfo[] srInfos) throws BOSException, EASBizException {
        int length = srInfos.length;
        HashMap supMap = new HashMap(3 * length);
        HashMap cusMap = new HashMap(3 * length);
        SupplyRelationInfo srInfo = null;
        String key = null;
        for (int i = 0; i < length; ++i) {
            HashMap<String, Object> map;
            srInfo = srInfos[i];
            key = srInfo.getIssueCompanyOrgUnit().getId().toString() + srInfo.getSupplyCompanyOrgUnit().getCU().getId().toString();
            if (!supMap.containsKey(key)) {
                map = new HashMap<String, Object>(2);
                map.put("internalcompanyorg", srInfo.getIssueCompanyOrgUnit());
                map.put("controlunit", srInfo.getSupplyCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (!supMap.containsKey(key = srInfo.getSupplyCompanyOrgUnit().getId().toString() + srInfo.getReceiveCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getSupplyCompanyOrgUnit());
                map.put("controlunit", srInfo.getReceiveCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (!cusMap.containsKey(key = srInfo.getReceiveCompanyOrgUnit().getId().toString() + srInfo.getSupplyCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getReceiveCompanyOrgUnit());
                map.put("controlunit", srInfo.getSupplyCompanyOrgUnit().getCU());
                cusMap.put(key, map);
            }
            if (cusMap.containsKey(key = srInfo.getSupplyCompanyOrgUnit().getId().toString() + srInfo.getIssueCompanyOrgUnit().getCU().getId().toString())) continue;
            map = new HashMap(2);
            map.put("internalcompanyorg", srInfo.getSupplyCompanyOrgUnit());
            map.put("controlunit", srInfo.getIssueCompanyOrgUnit().getCU());
            cusMap.put(key, map);
        }
        SupplyRelationServerUtils.checkInnerSuppliers(ctx, supMap);
        SupplyRelationServerUtils.checkInnerCustomers(ctx, cusMap);
    }

    private static void verifySupplierAndCustomerFor4Sides(Context ctx, SupplyRelationInfo[] srInfos) throws BOSException, EASBizException {
        int length = srInfos.length;
        HashMap supMap = new HashMap(length * 3);
        HashMap cusMap = new HashMap(length * 3);
        SupplyRelationInfo srInfo = null;
        String key = null;
        for (int i = 0; i < length; ++i) {
            HashMap<String, Object> map;
            srInfo = srInfos[i];
            key = srInfo.getIssueCompanyOrgUnit().getId().toString() + srInfo.getSupplyCompanyOrgUnit().getCU().getId().toString();
            if (!supMap.containsKey(key)) {
                map = new HashMap<String, Object>(2);
                map.put("internalcompanyorg", srInfo.getIssueCompanyOrgUnit());
                map.put("controlunit", srInfo.getSupplyCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (!supMap.containsKey(key = srInfo.getSupplyCompanyOrgUnit().getId().toString() + srInfo.getRequireCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getSupplyCompanyOrgUnit());
                map.put("controlunit", srInfo.getRequireCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (!supMap.containsKey(key = srInfo.getRequireCompanyOrgUnit().getId().toString() + srInfo.getReceiveCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getRequireCompanyOrgUnit());
                map.put("controlunit", srInfo.getReceiveCompanyOrgUnit().getCU());
                supMap.put(key, map);
            }
            if (!cusMap.containsKey(key = srInfo.getReceiveCompanyOrgUnit().getId().toString() + srInfo.getRequireCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getReceiveCompanyOrgUnit());
                map.put("controlunit", srInfo.getRequireCompanyOrgUnit().getCU());
                cusMap.put(key, map);
            }
            if (!cusMap.containsKey(key = srInfo.getRequireCompanyOrgUnit().getId().toString() + srInfo.getSupplyCompanyOrgUnit().getCU().getId().toString())) {
                map = new HashMap(2);
                map.put("internalcompanyorg", srInfo.getRequireCompanyOrgUnit());
                map.put("controlunit", srInfo.getSupplyCompanyOrgUnit().getCU());
                cusMap.put(key, map);
            }
            if (cusMap.containsKey(key = srInfo.getSupplyCompanyOrgUnit().getId().toString() + srInfo.getIssueCompanyOrgUnit().getCU().getId().toString())) continue;
            map = new HashMap(2);
            map.put("internalcompanyorg", srInfo.getSupplyCompanyOrgUnit());
            map.put("controlunit", srInfo.getIssueCompanyOrgUnit().getCU());
            cusMap.put(key, map);
        }
        SupplyRelationServerUtils.checkInnerSuppliers(ctx, supMap);
        SupplyRelationServerUtils.checkInnerCustomers(ctx, cusMap);
    }

    private static void checkInnerSuppliers(Context ctx, Map param) throws BOSException, EASBizException {
        int size = param.size();
        if (param == null || size == 0) {
            return;
        }
        SupplierFactory.getLocalInstance((Context)ctx).createSupplierByTransfer(SupplyRelationServerUtils.transformMap(param.size(), param));
    }

    private static Map transformMap(int size, Map param) {
        CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[size];
        CtrlUnitInfo[] cuInfos = new CtrlUnitInfo[size];
        Map<String, CtrlUnitInfo[]> map = null;
        int i = 0;
        Iterator iter = param.keySet().iterator();
        while (iter.hasNext()) {
            map = (Map)param.get(iter.next());
            couInfos[i] = (CompanyOrgUnitInfo)map.get("internalcompanyorg");
            cuInfos[i] = (CtrlUnitInfo)map.get("controlunit");
            ++i;
        }
        map = new HashMap(2);
        map.put("internalcompanyorg", (CtrlUnitInfo[])couInfos);
        map.put("controlunit", cuInfos);
        return map;
    }

    private static void checkInnerCustomers(Context ctx, Map param) throws BOSException, EASBizException {
        if (param == null || param.size() == 0) {
            return;
        }
        CustomerFactory.getLocalInstance((Context)ctx).createCustomerByTransfer(SupplyRelationServerUtils.transformMap(param.size(), param));
    }

    private static void setOuOfStorageUnit(Context ctx, SupplyRelationInfo[] srInfos, String bizTypeId, Map cuMap) throws BOSException, EASBizException {
        for (SupplyRelationInfo sri : srInfos) {
            if (sri.getIssueCompanyOrgUnit().getCU() == null || sri.getIssueCompanyOrgUnit().getCU().getNumber() == null) {
                sri.getIssueCompanyOrgUnit().setCU(SupplyRelationServerUtils.getCU(ctx, sri.getIssueCompanyOrgUnit(), cuMap));
            }
            if (sri.getReceiveCompanyOrgUnit().getCU() == null || sri.getReceiveCompanyOrgUnit().getCU().getNumber() == null) {
                sri.getReceiveCompanyOrgUnit().setCU(SupplyRelationServerUtils.getCU(ctx, sri.getReceiveCompanyOrgUnit(), cuMap));
            }
            if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                if (sri.getSupplyCompanyOrgUnit().getCU() != null && sri.getSupplyCompanyOrgUnit().getCU().getNumber() != null) continue;
                sri.getSupplyCompanyOrgUnit().setCU(SupplyRelationServerUtils.getCU(ctx, sri.getSupplyCompanyOrgUnit(), cuMap));
                continue;
            }
            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) continue;
            if (sri.getSupplyCompanyOrgUnit().getCU() == null || sri.getSupplyCompanyOrgUnit().getCU().getNumber() == null) {
                sri.getSupplyCompanyOrgUnit().setCU(SupplyRelationServerUtils.getCU(ctx, sri.getSupplyCompanyOrgUnit(), cuMap));
            }
            if (sri.getRequireCompanyOrgUnit().getCU() != null && sri.getRequireCompanyOrgUnit().getCU().getNumber() != null) continue;
            sri.getRequireCompanyOrgUnit().setCU(SupplyRelationServerUtils.getCU(ctx, sri.getRequireCompanyOrgUnit(), cuMap));
        }
    }

    private static CtrlUnitInfo getCU(Context ctx, CompanyOrgUnitInfo couInfo, Map cuMap) throws BOSException, EASBizException {
        String key = couInfo.getId().toString();
        if (!cuMap.containsKey(key)) {
            SelectorItemCollection selCol = new SelectorItemCollection();
            selCol.add(new SelectorItemInfo("id"));
            selCol.add(new SelectorItemInfo("name"));
            selCol.add(new SelectorItemInfo("number"));
            selCol.add(new SelectorItemInfo("cu.id"));
            selCol.add(new SelectorItemInfo("cu.name"));
            selCol.add(new SelectorItemInfo("cu.number"));
            couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(couInfo.getId()), selCol);
            cuMap.put(key, couInfo.getCU());
        }
        return (CtrlUnitInfo)cuMap.get(key);
    }

    public static ITransferRule getTransferRuleByType(Context ctx, String bizTypeId) throws BOSException {
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
            return TransferRule2Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
            return TransferRule3Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
            return TransferRule4Factory.getLocalInstance(ctx);
        }
        return null;
    }

    public static SelectorItemCollection getTransferRuleSelectorByType(Context ctx, String bizTypeID) throws BOSException {
        SelectorItemCollection selector = null;
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
            selector = new TransferRule2Info().getSelectorItemCollection();
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
            selector = new TransferRule3Info().getSelectorItemCollection();
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
            selector = new TransferRule4Info().getSelectorItemCollection();
        }
        return selector;
    }

    public static ITransferRule getTransferRuleByBizCategoryId(Context ctx, String bizCategoryId) throws BOSException {
        if ("88a7587a-e019-497b-9f86-b8f00ab2fe72A9389020".equals(bizCategoryId)) {
            return TransferRule2Factory.getLocalInstance(ctx);
        }
        if ("eQQgnQESEADgAAAAwKgS/ak4kCA=".equals(bizCategoryId)) {
            return TransferRule3Factory.getLocalInstance(ctx);
        }
        if ("eQQgnQESEADgAAABwKgS/ak4kCA=".equals(bizCategoryId)) {
            return TransferRule4Factory.getLocalInstance(ctx);
        }
        return null;
    }

    private static final EntityViewInfo getNullView() {
        if (nullView == null) {
            nullView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
            nullView.setFilter(filter);
        }
        return nullView;
    }

    public static final EntityViewInfo getStorageOrgUnitViewBySupplyRelation(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, OrgUnitInfo[] authOrgs, String param) throws EASBizException, BOSException {
        if (toRole == null) {
            return SupplyRelationServerUtils.getNullView();
        }
        Set<String> setDestSouID = new HashSet();
        setDestSouID = !StringUtils.isEmpty((String)bizTypeID) && "true".equalsIgnoreCase(param) ? SupplyRelationServerUtils.getStorageViewBySupplyRelationForRule(ctx, mainOrgID, bizTypeID, fromStorageIDs, fromCompanyIDs, fromRoles, toRole, authOrgs) : SupplyRelationServerUtils.getStorageViewBySupplyRelationForNoRule(ctx, mainOrgID, bizTypeID, fromStorageIDs, fromCompanyIDs, fromRoles, toRole, authOrgs);
        EntityViewInfo viewSou = new EntityViewInfo();
        FilterInfo filterSou = new FilterInfo();
        setDestSouID.add("111__not__existed__id");
        filterSou.getFilterItems().add(new FilterItemInfo("id", setDestSouID, CompareType.INCLUDE));
        filterSou.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
        viewSou.setFilter(filterSou);
        return viewSou;
    }

    public static final EntityViewInfo getStorageOrgUnitViewBySupplyRelation(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, String permItem, Map couMap, Map authOrgMap, String parameter) {
        if (toRole == null) {
            return SupplyRelationServerUtils.getNullView();
        }
        try {
            HashSet<Object> setDestSouID = new HashSet<Object>();
            String param = "false";
            if (parameter != null) {
                param = parameter;
            } else if (mainOrgID != null) {
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                param = ipc.getParamValue((IObjectPK)new ObjectUuidPK(mainOrgID), "INM007");
            }
            if ("false".equalsIgnoreCase(param)) {
                Map map = SupplyRelationServerUtils.getAuthOrgByPermItem(ctx, authOrgMap);
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    setDestSouID.add(iter.next());
                }
            }
            if (!StringUtils.isEmpty((String)bizTypeID) && "true".equalsIgnoreCase(param)) {
                if (fromRoles != null) {
                    EntityViewInfo viewRule = new EntityViewInfo();
                    FilterInfo filterRule = new FilterInfo();
                    filterRule.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
                    filterRule.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizTypeID));
                    int n = fromRoles.length;
                    for (int i = 0; i < n; ++i) {
                        if (fromStorageIDs[i] == null) continue;
                        if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                        filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                    }
                    viewRule.setFilter(filterRule);
                    ITransferRule itr = null;
                    SelectorItemCollection selector = null;
                    if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule2Factory.getLocalInstance(ctx);
                        selector = new TransferRule2Info().getSelectorItemCollection();
                    } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule3Factory.getLocalInstance(ctx);
                        selector = new TransferRule3Info().getSelectorItemCollection();
                    } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule4Factory.getLocalInstance(ctx);
                        selector = new TransferRule4Info().getSelectorItemCollection();
                    } else {
                        return SupplyRelationServerUtils.getNullView();
                    }
                    if (selector != null) {
                        viewRule.setSelector(selector);
                    }
                    TransferRuleCollection rules = itr.getTransferRuleCollection(viewRule);
                    int n2 = rules.size();
                    for (int i = 0; i < n2; ++i) {
                        String souID = "";
                        if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getRequireStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getSupplyStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getIssueStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getReceiveStorageOrgUnit().getId().toString();
                        }
                        setDestSouID.add(souID);
                    }
                }
            } else {
                EntityViewInfo viewRelation = new EntityViewInfo();
                FilterInfo filterRelation = new FilterInfo();
                if (fromRoles != null) {
                    int n = fromRoles.length;
                    for (int i = 0; i < n; ++i) {
                        if (fromStorageIDs[i] == null) continue;
                        if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                        filterRelation.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                    }
                }
                viewRelation.setFilter(filterRelation);
                viewRelation.getSelector().add(new SelectorItemInfo("id"));
                viewRelation.getSelector().add(new SelectorItemInfo("status"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireStorageOrgUnit.id"));
                SupplyRelationCollection relations = SupplyRelationFactory.getLocalInstance(ctx).getSupplyRelationCollection(viewRelation);
                int n = relations.size();
                for (int i = 0; i < n; ++i) {
                    String souID = "";
                    if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                        souID = relations.get(i).getRequireStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                        souID = relations.get(i).getSupplyStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                        souID = relations.get(i).getIssueStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                        souID = relations.get(i).getReceiveStorageOrgUnit().getId().toString();
                    }
                    setDestSouID.add(souID);
                }
                if (fromRoles != null && fromCompanyIDs != null) {
                    String couId = null;
                    String souId = null;
                    Object[] souIds = setDestSouID.toArray();
                    HashSet<String> result = new HashSet<String>(souIds.length);
                    boolean shouldAdd = true;
                    int count = setDestSouID.size();
                    BOSUuid[] bosSouIds = new BOSUuid[count];
                    Iterator iterator = setDestSouID.iterator();
                    int k = 0;
                    while (iterator.hasNext()) {
                        bosSouIds[k] = BOSUuid.read((String)iterator.next().toString());
                        ++k;
                    }
                    Map couMaps = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfos(bosSouIds);
                    CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[bosSouIds.length];
                    int length = bosSouIds.length;
                    for (int i = 0; i < length && bosSouIds[i] != null; ++i) {
                        couInfos[i] = (CompanyOrgUnitInfo)couMaps.get(bosSouIds[i].toString());
                    }
                    for (int j = 0; j < couInfos.length; ++j) {
                        int i;
                        int size;
                        souId = (String)souIds[j];
                        if (couInfos[j] == null) continue;
                        couId = couInfos[j].getId().toString();
                        shouldAdd = true;
                        if (BizRoleTypeEnum.SupplySide.equals((Object)toRole) && bizTypeID == null) {
                            size = fromStorageIDs.length;
                            for (i = 0; i < size; ++i) {
                                if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                                break;
                            }
                        } else if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                            size = fromStorageIDs.length;
                            for (i = 0; i < size; ++i) {
                                if ((BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                    shouldAdd = false;
                                } else {
                                    if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                    shouldAdd = false;
                                }
                                break;
                            }
                        } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                            size = fromCompanyIDs.length;
                            for (i = 0; i < size; ++i) {
                                if ((BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                    shouldAdd = false;
                                } else {
                                    if (!"LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && !"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                    shouldAdd = false;
                                }
                                break;
                            }
                        } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                            size = fromCompanyIDs.length;
                            for (i = 0; i < size; ++i) {
                                if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                    shouldAdd = false;
                                } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                    shouldAdd = false;
                                } else {
                                    if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                    shouldAdd = false;
                                }
                                break;
                            }
                        } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                            size = fromCompanyIDs.length;
                            for (i = 0; i < size; ++i) {
                                if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                                break;
                            }
                        }
                        if (!shouldAdd) continue;
                        result.add(souId);
                    }
                    setDestSouID = result;
                }
            }
            EntityViewInfo viewSou = null;
            if (setDestSouID.size() > 0) {
                viewSou = new EntityViewInfo();
                FilterInfo filterSou = new FilterInfo();
                filterSou.getFilterItems().add(new FilterItemInfo("id", setDestSouID, CompareType.INCLUDE));
                filterSou.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
                filterSou.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
                viewSou.setFilter(filterSou);
            }
            return viewSou;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return SupplyRelationServerUtils.getNullView();
        }
    }

    private static final Map getAuthOrgByPermItem(Context ctx, Map authOrgMap) throws EASBizException, BOSException {
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        String key = userId.toString();
        if (authOrgMap == null) {
            authOrgMap = new HashMap<String, Map>();
        }
        if (!authOrgMap.containsKey(key)) {
            authOrgMap.put(key, PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(userId), OrgType.Storage, (IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000074F2827FD"), null, null));
        }
        return (Map)authOrgMap.get(key);
    }

    public static final Set getStorageViewBySupplyRelationForNoRule(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, OrgUnitInfo[] authOrgs) throws EASBizException, BOSException {
        HashSet<String> setDestSouID = new HashSet<String>();
        int size = authOrgs.length;
        for (int i = 0; i < size; ++i) {
            setDestSouID.add(authOrgs[i].getId().toString());
        }
        EntityViewInfo viewRelation = new EntityViewInfo();
        FilterInfo filterRelation = new FilterInfo();
        if (fromRoles != null) {
            int n = fromRoles.length;
            for (int i = 0; i < n; ++i) {
                if (fromStorageIDs[i] == null) continue;
                if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                    filterRelation.getFilterItems().add(new FilterItemInfo("requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                    filterRelation.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                    filterRelation.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                filterRelation.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
            }
        }
        viewRelation.setFilter(filterRelation);
        viewRelation.getSelector().add(new SelectorItemInfo("id"));
        viewRelation.getSelector().add(new SelectorItemInfo("status"));
        viewRelation.getSelector().add(new SelectorItemInfo("requireCompanyOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("receiveCompanyOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("supplyCompanyOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("issueStorageOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("receiveStorageOrgUnit.id"));
        viewRelation.getSelector().add(new SelectorItemInfo("requireStorageOrgUnit.id"));
        SupplyRelationCollection relations = SupplyRelationFactory.getLocalInstance(ctx).getSupplyRelationCollection(viewRelation);
        int n = relations.size();
        for (int i = 0; i < n; ++i) {
            String souID = "";
            if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                souID = relations.get(i).getRequireStorageOrgUnit().getId().toString();
            } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                souID = relations.get(i).getSupplyStorageOrgUnit().getId().toString();
            } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                souID = relations.get(i).getIssueStorageOrgUnit().getId().toString();
            } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                souID = relations.get(i).getReceiveStorageOrgUnit().getId().toString();
            }
            setDestSouID.add(souID);
        }
        if (fromRoles != null && fromCompanyIDs != null) {
            String couId = null;
            String souId = null;
            Object[] souIds = setDestSouID.toArray();
            HashSet<String> result = new HashSet<String>(souIds.length);
            boolean shouldAdd = true;
            int count = setDestSouID.size();
            BOSUuid[] bosSouIds = new BOSUuid[count];
            Iterator iterator = setDestSouID.iterator();
            int k = 0;
            while (iterator.hasNext()) {
                bosSouIds[k] = BOSUuid.read((String)iterator.next().toString());
                ++k;
            }
            Map couMaps = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfos(bosSouIds);
            CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[bosSouIds.length];
            int length = bosSouIds.length;
            for (int i = 0; i < length && bosSouIds[i] != null; ++i) {
                couInfos[i] = (CompanyOrgUnitInfo)couMaps.get(bosSouIds[i].toString());
            }
            for (int j = 0; j < couInfos.length; ++j) {
                int i;
                int size2;
                souId = (String)souIds[j];
                if (couInfos[j] == null) continue;
                couId = couInfos[j].getId().toString();
                shouldAdd = true;
                if (BizRoleTypeEnum.SupplySide.equals((Object)toRole) && bizTypeID == null) {
                    size2 = fromStorageIDs.length;
                    for (i = 0; i < size2; ++i) {
                        if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                        shouldAdd = false;
                        break;
                    }
                } else if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                    size2 = fromStorageIDs.length;
                    for (i = 0; i < size2; ++i) {
                        if ((BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                            shouldAdd = false;
                        } else {
                            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                        }
                        break;
                    }
                } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                    size2 = fromCompanyIDs.length;
                    for (i = 0; i < size2; ++i) {
                        if ((BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                            shouldAdd = false;
                        } else {
                            if (!"LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && !"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                        }
                        break;
                    }
                } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                    size2 = fromCompanyIDs.length;
                    for (i = 0; i < size2; ++i) {
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                            shouldAdd = false;
                        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                            shouldAdd = false;
                        } else {
                            if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                        }
                        break;
                    }
                } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                    size2 = fromCompanyIDs.length;
                    for (i = 0; i < size2; ++i) {
                        if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                        shouldAdd = false;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                result.add(souId);
            }
            setDestSouID = result;
        }
        return setDestSouID;
    }

    public static final Set getStorageViewBySupplyRelationForRule(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, OrgUnitInfo[] authOrgs) throws BOSException {
        HashSet<String> setDestSouID = new HashSet<String>();
        if (fromRoles != null) {
            EntityViewInfo viewRule = new EntityViewInfo();
            FilterInfo filterRule = new FilterInfo();
            filterRule.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
            filterRule.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizTypeID));
            int n = fromRoles.length;
            for (int i = 0; i < n; ++i) {
                if (fromStorageIDs[i] == null) continue;
                if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                    filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                    filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                    filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                    continue;
                }
                if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
            }
            viewRule.setFilter(filterRule);
            ITransferRule itr = null;
            SelectorItemCollection selector = SupplyRelationServerUtils.getTransferRuleSelectorByType(ctx, bizTypeID);
            itr = SupplyRelationServerUtils.getTransferRuleByType(ctx, bizTypeID);
            if (selector == null) {
                return setDestSouID;
            }
            viewRule.setSelector(selector);
            TransferRuleCollection rules = itr.getTransferRuleCollection(viewRule);
            int n2 = rules.size();
            for (int i = 0; i < n2; ++i) {
                String souID = "";
                if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                    souID = rules.get(i).getSupplyRelation().getRequireStorageOrgUnit().getId().toString();
                } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                    souID = rules.get(i).getSupplyRelation().getSupplyStorageOrgUnit().getId().toString();
                } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                    souID = rules.get(i).getSupplyRelation().getIssueStorageOrgUnit().getId().toString();
                } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                    souID = rules.get(i).getSupplyRelation().getReceiveStorageOrgUnit().getId().toString();
                }
                setDestSouID.add(souID);
            }
        }
        return setDestSouID;
    }

    public static final EntityViewInfo getStorageOrgUnitViewBySupplyRelationForMaterialBill(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, String permItem, Map couMap, Map authOrgMap) {
        return SupplyRelationServerUtils.getStorageOrgUnitViewBySupplyRelationForMaterialBill(ctx, mainOrgID, bizTypeID, fromStorageIDs, fromCompanyIDs, fromRoles, toRole, permItem, couMap, authOrgMap, null);
    }

    public static final EntityViewInfo getStorageOrgUnitViewBySupplyRelationForMaterialBill(Context ctx, String mainOrgID, String bizTypeID, String[] fromStorageIDs, String[] fromCompanyIDs, BizRoleTypeEnum[] fromRoles, BizRoleTypeEnum toRole, String permItem, Map couMap, Map authOrgMap, String parameter) {
        if (toRole == null) {
            return SupplyRelationServerUtils.getNullView();
        }
        try {
            HashSet<Object> setDestSouID = new HashSet<Object>();
            String param = "false";
            if (parameter != null) {
                param = parameter;
            } else if (mainOrgID != null) {
                IParamControl ipc = ParamControlFactory.getRemoteInstance();
                param = ipc.getParamValue((IObjectPK)new ObjectUuidPK(mainOrgID), "INM007");
            }
            if ("false".equalsIgnoreCase(param)) {
                Map map = SupplyRelationServerUtils.getAuthOrgByPermItem(ctx, authOrgMap);
                Iterator iter = map.keySet().iterator();
                while (iter.hasNext()) {
                    setDestSouID.add(iter.next());
                }
            }
            if (!StringUtils.isEmpty((String)bizTypeID) && "true".equalsIgnoreCase(param)) {
                if (fromRoles != null) {
                    EntityViewInfo viewRule = new EntityViewInfo();
                    FilterInfo filterRule = new FilterInfo();
                    filterRule.getFilterItems().add(new FilterItemInfo("status", (Object)UseStatusEnum.ACTIVE));
                    filterRule.getFilterItems().add(new FilterItemInfo("bizType", (Object)bizTypeID));
                    int n = fromRoles.length;
                    for (int i = 0; i < n; ++i) {
                        if (fromStorageIDs[i] == null) continue;
                        if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                            filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                        filterRule.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                    }
                    viewRule.setFilter(filterRule);
                    ITransferRule itr = null;
                    SelectorItemCollection selector = null;
                    if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule2Factory.getRemoteInstance();
                        selector = new TransferRule2Info().getSelectorItemCollection();
                    } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule3Factory.getRemoteInstance();
                        selector = new TransferRule3Info().getSelectorItemCollection();
                    } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeID)) {
                        itr = TransferRule4Factory.getRemoteInstance();
                        selector = new TransferRule4Info().getSelectorItemCollection();
                    } else {
                        return SupplyRelationServerUtils.getNullView();
                    }
                    if (selector != null) {
                        viewRule.setSelector(selector);
                    }
                    TransferRuleCollection rules = itr.getTransferRuleCollection(viewRule);
                    int n2 = rules.size();
                    for (int i = 0; i < n2; ++i) {
                        String souID = "";
                        if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getRequireStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getSupplyStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getIssueStorageOrgUnit().getId().toString();
                        } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                            souID = rules.get(i).getSupplyRelation().getReceiveStorageOrgUnit().getId().toString();
                        }
                        setDestSouID.add(souID);
                    }
                    if (setDestSouID.size() > 0) {
                        EntityViewInfo viewSou = null;
                        viewSou = new EntityViewInfo();
                        FilterInfo filterSou = new FilterInfo();
                        filterSou.getFilterItems().add(new FilterItemInfo("id", setDestSouID, CompareType.INCLUDE));
                        filterSou.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
                        filterSou.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
                        viewSou.setFilter(filterSou);
                        return viewSou;
                    }
                }
            } else {
                EntityViewInfo viewRelation = new EntityViewInfo();
                FilterInfo filterRelation = new FilterInfo();
                if (fromRoles != null) {
                    int n = fromRoles.length;
                    for (int i = 0; i < n; ++i) {
                        if (fromStorageIDs[i] == null) continue;
                        if (BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("requireStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) {
                            filterRelation.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit", (Object)fromStorageIDs[i]));
                            continue;
                        }
                        if (!BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i])) continue;
                        filterRelation.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit", (Object)fromStorageIDs[i]));
                    }
                }
                viewRelation.setFilter(filterRelation);
                viewRelation.getSelector().add(new SelectorItemInfo("id"));
                viewRelation.getSelector().add(new SelectorItemInfo("status"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("issueStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("supplyStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("receiveStorageOrgUnit.id"));
                viewRelation.getSelector().add(new SelectorItemInfo("requireStorageOrgUnit.id"));
                SupplyRelationCollection relations = SupplyRelationFactory.getRemoteInstance().getSupplyRelationCollection(viewRelation);
                int n = relations.size();
                for (int i = 0; i < n; ++i) {
                    String souID = "";
                    if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                        souID = relations.get(i).getRequireStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                        souID = relations.get(i).getSupplyStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                        souID = relations.get(i).getIssueStorageOrgUnit().getId().toString();
                    } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                        souID = relations.get(i).getReceiveStorageOrgUnit().getId().toString();
                    }
                    setDestSouID.add(souID);
                }
            }
            if (setDestSouID.isEmpty()) {
                EntityViewInfo viewStorage = new EntityViewInfo();
                FilterInfo filterStorage = new FilterInfo();
                filterStorage.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0));
                viewStorage.getSelector().add(new SelectorItemInfo("id"));
                StorageOrgUnitCollection colls = StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitCollection(viewStorage);
                if (colls != null && colls.size() > 0) {
                    int n = colls.size();
                    for (int i = 0; i < n; ++i) {
                        setDestSouID.add(colls.get(i).getId().toString());
                    }
                }
            }
            if (setDestSouID.size() > 0 && fromRoles != null && fromCompanyIDs != null) {
                String couId = null;
                String souId = null;
                Object[] souIds = setDestSouID.toArray();
                HashSet<String> result = new HashSet<String>(souIds.length);
                boolean shouldAdd = true;
                int count = setDestSouID.size();
                BOSUuid[] bosSouIds = new BOSUuid[count];
                Iterator iterator = setDestSouID.iterator();
                int k = 0;
                while (iterator.hasNext()) {
                    bosSouIds[k] = BOSUuid.read((String)iterator.next().toString());
                    ++k;
                }
                Map couMaps = SCMBillCommonFacadeFactory.getRemoteInstance().getCompanyInfos(bosSouIds);
                CompanyOrgUnitInfo[] couInfos = new CompanyOrgUnitInfo[bosSouIds.length];
                int length = bosSouIds.length;
                for (int i = 0; i < length && bosSouIds[i] != null; ++i) {
                    couInfos[i] = (CompanyOrgUnitInfo)couMaps.get(bosSouIds[i].toString());
                }
                for (int j = 0; j < couInfos.length; ++j) {
                    int i;
                    int size;
                    souId = (String)souIds[j];
                    if (couInfos[j] == null) continue;
                    couId = couInfos[j].getId().toString();
                    shouldAdd = true;
                    if (BizRoleTypeEnum.SupplySide.equals((Object)toRole) && bizTypeID == null) {
                        size = fromStorageIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                            break;
                        }
                    } else if (BizRoleTypeEnum.RequireSide.equals((Object)toRole)) {
                        size = fromStorageIDs.length;
                        for (i = 0; i < size; ++i) {
                            if ((BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.IssueSide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if ((BizRoleTypeEnum.ReceiveSide.equals((Object)fromRoles[i]) || BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i])) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && !"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.ReceiveSide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (BizRoleTypeEnum.IssueSide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) && BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) && couId.equals(fromCompanyIDs[i])) {
                                shouldAdd = false;
                            } else {
                                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeID) || !BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) && !BizRoleTypeEnum.SupplySide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                                shouldAdd = false;
                            }
                            break;
                        }
                    } else if (BizRoleTypeEnum.SupplySide.equals((Object)toRole)) {
                        size = fromCompanyIDs.length;
                        for (i = 0; i < size; ++i) {
                            if (!BizRoleTypeEnum.RequireSide.equals((Object)fromRoles[i]) || !couId.equals(fromCompanyIDs[i])) continue;
                            shouldAdd = false;
                            break;
                        }
                    }
                    if (!shouldAdd) continue;
                    result.add(souId);
                }
                setDestSouID = result;
            }
            EntityViewInfo viewSou = null;
            viewSou = new EntityViewInfo();
            FilterInfo filterSou = new FilterInfo();
            if (setDestSouID.size() > 0) {
                filterSou.getFilterItems().add(new FilterItemInfo("id", setDestSouID, CompareType.INCLUDE));
            }
            filterSou.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true));
            filterSou.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)false));
            viewSou.setFilter(filterSou);
            return viewSou;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return SupplyRelationServerUtils.getNullView();
        }
    }
}

