/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.control.IStockGatherMove;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.ISCMFetchDataFacade;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.im.inv.AbstractTransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractTransferOrderBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.ST2TOUtils;
import com.kingdee.eas.scm.im.inv.app.TransferOrderAlgorithmForInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TransferOrderBillControllerBean
extends AbstractTransferOrderBillControllerBean {
    private static final long serialVersionUID = -3099988289393938L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.TransferOrderBillControllerBean");
    private static String[] fields = new String[]{"qty", "baseQty", "price", "amount", "taxAmount", "saleInvoiceQty", "taxPrice", "tax", "issueQty", "receiptQty", "purInvoiceQty", "issueBaseQty", "receiptBaseQty", "saleInvoiceBaseQty", "purInvoiceBaseQty", "unIssueBaseQty", "purInvoiceAmount", "saleInvoiceAmount", "totalAccountPayable", "totalAccountReceivable", "totalIssueQty", "balanceCostPrice", "balanceCostRate", "actualPrice", "discountRate", "actualTaxPrice", "localAmount", "localTax", "localTaxAmount", "discountAmount", "localDiscountAmount", "arAssociateBaseQty", "apAssociateBaseQty", "assCoefficient", "baseStatus", "associateQty", "qtyOverRate", "qtyLackRate", "totalPurReturnBaseQty", "totalPurReturnQty", "totalSaleReturnBaseQty", "totalSaleReturnQty", "taxRate"};
    private static String[] subFields = new String[]{"discountAmount", "tax", "discountRate", "totalIssueQty", "planDeliveryQty"};
    private static String[] headFields = new String[]{"baseStatus", "year", "period", "exchangeRate"};
    private SelectorItemCollection materialSelector = null;
    private Map matCouMap = null;
    private Map matInvMap = null;
    private Map paramMap = new HashMap();
    private ExchangeRateInfo exchangeRateInfo;
    private static BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue billinfo) throws BOSException, EASBizException {
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    private String checkQtyValid(Context ctx, IObjectPK pk, IObjectValue model, BizActionEnum action) throws EASBizException, BOSException {
        StringBuffer msg;
        block18: {
            msg = new StringBuffer();
            if (pk == null && model == null) {
                return msg.toString();
            }
            TransferOrderBillInfo billInfo = (TransferOrderBillInfo)model;
            if (billInfo == null || billInfo.getId() == null) {
                billInfo = this.getTransferOrderBillInfo(ctx, pk);
            }
            if (billInfo.getSourceBillType() == null || billInfo.getSourceBillType().getId() == null) break block18;
            int size = billInfo.getEntry().size();
            TransferOrderBillEntryInfo entry = null;
            if (size > 0) {
                entry = billInfo.getEntry().get(0);
                BigDecimal validQty = new BigDecimal("0.00");
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getLocalInstance(ctx);
                    PurInWarehsEntryInfo piwEntryInfo = null;
                    BigDecimal purEntryQty = new BigDecimal("0.00");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        purEntryQty = entry.getQty();
                        piwEntryInfo = ipe.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!piwEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            purEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), piwEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            validQty = piwEntryInfo.getQty().subtract(piwEntryInfo.getTotalMoveQty().add(purEntryQty));
                            validQty = validQty.subtract(piwEntryInfo.getReverseQty());
                            if ((validQty = validQty.setScale(6, 4)).signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = piwEntryInfo.getQty().subtract(piwEntryInfo.getTotalMoveQty()).subtract(piwEntryInfo.getReverseQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, purEntryQty, purEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg.append("\n").append(tmp);
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            piwEntryInfo.setTotalMoveQty(piwEntryInfo.getTotalMoveQty().add(purEntryQty));
                            ipe.update((IObjectPK)new ObjectUuidPK(piwEntryInfo.getId()), (CoreBaseInfo)piwEntryInfo);
                            continue;
                        }
                        piwEntryInfo.setTotalMoveQty(piwEntryInfo.getTotalMoveQty().subtract(purEntryQty));
                        ipe.update((IObjectPK)new ObjectUuidPK(piwEntryInfo.getId()), (CoreBaseInfo)piwEntryInfo);
                    }
                } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    PurOrderEntryInfo poEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    BigDecimal ordEntryQty = new BigDecimal("0");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        ordEntryQty = entry.getQty();
                        poEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!poEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            ordEntryQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), poEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        validQty = poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty().add(ordEntryQty));
                        if (BizActionEnum.AUDIT.equals((Object)action)) {
                            if (validQty.signum() < 0) {
                                validQty = validQty.setScale(6, 4);
                                BigDecimal moreMoveQty = poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty());
                                String tmp = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TransferQtyIllegeal", (String[])new String[]{String.valueOf(i + 1), InvAppUtils.getDecimalFormatString(ctx, ordEntryQty, ordEntryQty.scale()), InvAppUtils.getDecimalFormatString(ctx, moreMoveQty, moreMoveQty.scale())});
                                msg.append("\n").append(tmp);
                                continue;
                            }
                            if (msg.length() > 0) continue;
                            poEntryInfo.setTotalMoveQty(poEntryInfo.getTotalMoveQty().add(ordEntryQty));
                            if (poEntryInfo.getQty().subtract(poEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                                poEntryInfo.setCanInvMoveQty(poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty()));
                            } else {
                                poEntryInfo.setCanInvMoveQty(poEntryInfo.getTotalReceiptQty().subtract(poEntryInfo.getTotalMoveQty()));
                            }
                            ipo.update((IObjectPK)new ObjectUuidPK(poEntryInfo.getId()), (CoreBaseInfo)poEntryInfo);
                            continue;
                        }
                        poEntryInfo.setTotalMoveQty(poEntryInfo.getTotalMoveQty().subtract(ordEntryQty));
                        if (poEntryInfo.getQty().subtract(poEntryInfo.getTotalReceiptQty()).signum() >= 0) {
                            poEntryInfo.setCanInvMoveQty(poEntryInfo.getQty().subtract(poEntryInfo.getTotalMoveQty()));
                        } else {
                            poEntryInfo.setCanInvMoveQty(poEntryInfo.getTotalReceiptQty().subtract(poEntryInfo.getTotalMoveQty()));
                        }
                        ipo.update((IObjectPK)new ObjectUuidPK(poEntryInfo.getId()), (CoreBaseInfo)poEntryInfo);
                    }
                }
            }
        }
        return msg.toString();
    }

    protected boolean _checkPrice(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)aSCMBillBaseInfo;
        boolean noPrice = false;
        if (billInfo != null && billInfo.getEntry() != null) {
            Object[] msg = new String[1];
            StringBuffer materialNumber = new StringBuffer("");
            if (billInfo.isIsInTax()) {
                for (int i = 0; i < billInfo.getEntry().size(); ++i) {
                    if (billInfo.getEntry().get(i).isIsPresent() || billInfo.getEntry().get(i).getPrice().compareTo(ZERO) != 0 && billInfo.getEntry().get(i).getPrice().compareTo(ZERO) >= 0) continue;
                    noPrice = true;
                    materialNumber.append(i + 1 + "");
                }
                if (noPrice) {
                    msg[0] = String.valueOf(materialNumber);
                    throw new SCMBillException(SCMBillException.ENTRIESTAXPRICENOTNULL, msg);
                }
            } else {
                for (int i = 0; i < billInfo.getEntry().size(); ++i) {
                    if (billInfo.getEntry().get(i).getTaxPrice().compareTo(ZERO) != 0 && billInfo.getEntry().get(i).getPrice().compareTo(ZERO) >= 0) continue;
                    noPrice = true;
                    if (billInfo.getEntry().get(i).isIsPresent()) {
                        noPrice = false;
                    }
                    materialNumber.append(i + 1 + "");
                }
                if (noPrice) {
                    msg[0] = String.valueOf(materialNumber);
                    throw new SCMBillException(SCMBillException.ENTRIESPRICENOTNULL, msg);
                }
            }
        }
        return true;
    }

    private void setInnerBizPrices(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)model;
        BizRoleTypeEnum bizRoleType = null;
        String bizType = billInfo.getBizType().getId().toString();
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.IssueSide;
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType)) {
            bizRoleType = BizRoleTypeEnum.SupplySide;
        }
        if (bizRoleType == null) {
            return;
        }
        TransferOrderBillEntryCollection stb = billInfo.getEntry();
        TransferOrderBillEntryInfo entryInfo = null;
        int size = stb.size();
        ArrayList<PriceInfo> listPrice = new ArrayList<PriceInfo>(3 * size);
        for (int i = 0; i < size; ++i) {
            entryInfo = stb.get(i);
            BigDecimal qty = entryInfo.getQty();
            if (qty == null || qty.compareTo(ZERO) == 0) {
                listPrice.add(i, null);
                continue;
            }
            listPrice.add(i, entryInfo.isIsPresent() ? null : this.getPriceInfoByBill(billInfo, stb.get(i), BizRoleTypeEnum.IssueSide));
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
            CompanyOrgUnitInfo supplyCouInfo = billInfo.getIssueCompanyOrgUnit();
            this.exchangeRateInfo = this.getExchangeRate(ctx, supplyCouInfo, (IObjectPK)new ObjectUuidPK(billInfo.getCurrency().getId()));
            if (this.exchangeRateInfo != null) {
                this.exchangeRateInfo.setConvertRate(billInfo.getExchangeRate());
            }
            PriceParamInfo[] paramInfos = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType) ? new PriceParamInfo[size] : new PriceParamInfo[2 * size];
            Map<String, MaterialCompanyInfoInfo> matCouMap = this.getMaterialCouMap(stb, ctx);
            for (int i = 0; i < size; ++i) {
                entryInfo = stb.get(i);
                BigDecimal qty = entryInfo.getQty();
                if (qty == null || qty.compareTo(ZERO) == 0) {
                    paramInfos[i] = null;
                } else {
                    PriceParamInfo priceParamInfo = paramInfos[i] = entryInfo.isIsPresent() ? null : this.getPriceParamInfo(ctx, billInfo, entryInfo, BizRoleTypeEnum.SupplySide, matCouMap);
                }
                if (!"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(billInfo.getBizType().getId().toString()) && !"ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(billInfo.getBizType().getId().toString())) continue;
                paramInfos[size + i] = qty == null || qty.compareTo(ZERO) == 0 ? null : (entryInfo.isIsPresent() ? null : this.getPriceParamInfo(ctx, billInfo, entryInfo, BizRoleTypeEnum.RequireSide, matCouMap));
            }
            List list = MultiSidesTransferPriceFacadeFactory.getLocalInstance(ctx).getPriceCollection(paramInfos);
            int length = paramInfos.length;
            for (int i = 0; i < length; ++i) {
                listPrice.add(size + i, (PriceInfo)list.get(i));
            }
        }
        MultiSidesTransferPricesFactory.getLocalInstance(ctx).saveByPriceInfo(listPrice, billInfo);
    }

    private ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK) throws EASBizException, BOSException {
        if (companyOrgUnitInfo.getBaseCurrency() == null || companyOrgUnitInfo.getBaseExchangeTable() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()), sic);
        }
        ObjectUuidPK destCurrPK = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId());
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, (IObjectPK)destCurrPK);
        return exchangeRateInfo;
    }

    private PriceInfo getPriceInfoByBill(TransferOrderBillInfo billInfo, TransferOrderBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType) {
        PriceInfo priceInfo = new PriceInfo();
        priceInfo.setBizRoleType(bizRoleType);
        priceInfo.setStockTransferID(billInfo.getId().toString());
        priceInfo.setStockTransferEntryID(entryInfo.getId().toString());
        priceInfo.setPricePrecision(entryInfo.getMaterial().getPricePrecision());
        priceInfo.setPrice(entryInfo.getPrice());
        priceInfo.setTaxPrice(entryInfo.getTaxPrice());
        priceInfo.setTaxRate(entryInfo.getTaxRate());
        priceInfo.setActualPrice(entryInfo.getActualPrice());
        priceInfo.setDiscountType(entryInfo.getDiscountType());
        priceInfo.setDiscountRate(entryInfo.getDiscountRate());
        priceInfo.setActualTaxPrice(entryInfo.getActualTaxPrice());
        return priceInfo;
    }

    private PriceParamInfo getPriceParamInfo(Context ctx, TransferOrderBillInfo billInfo, TransferOrderBillEntryInfo entryInfo, BizRoleTypeEnum bizRoleType, Map<String, MaterialCompanyInfoInfo> matCouMap) throws EASBizException, BOSException {
        PriceParamInfo paramInfo = new PriceParamInfo();
        StorageOrgUnitInfo issueSou = entryInfo.getIssueStorageOrgUnit();
        paramInfo.setStockTransferID(billInfo.getId().toString());
        paramInfo.setStockTransferEntryID(entryInfo.getId().toString());
        String tempBizTypeID = billInfo.getBizType().getId().toString();
        if (tempBizTypeID.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            tempBizTypeID = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        } else if (tempBizTypeID.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            tempBizTypeID = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        } else if (tempBizTypeID.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            tempBizTypeID = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        BizTypeInfo tempBiztypeInfo = new BizTypeInfo();
        tempBiztypeInfo.setId(BOSUuid.read((String)tempBizTypeID));
        paramInfo.setBizTypeInfo(tempBiztypeInfo);
        paramInfo.setCompanyOrgUnit(billInfo.getIssueCompanyOrgUnit());
        paramInfo.setStorageOrgUnit(billInfo.getIssueStorageOrgUnit());
        paramInfo.setRequireCompanyOrgUnitInfo(billInfo.getReceiptCompanyOrgUnit());
        paramInfo.setRequireStorageOrgUnitInfo(billInfo.getReceiptStorageOrgUnit());
        paramInfo.setIssueCompanyOrgUnitInfo(entryInfo.getIssueCompanyOrgUnit());
        paramInfo.setMateial(entryInfo.getMaterial());
        paramInfo.setCurrencyInfo(billInfo.getCurrency());
        paramInfo.setTransferOrderBillTaxRate(entryInfo.getTaxRate());
        paramInfo.setQty(entryInfo.getQty());
        paramInfo.setUnit(entryInfo.getUnit());
        paramInfo.setBaseUnit(entryInfo.getBaseUnit());
        paramInfo.setSupplyRelation(entryInfo.getSupplyRelation());
        paramInfo.setBizRole(bizRoleType);
        paramInfo.setCostBizRole(bizRoleType);
        paramInfo.setIssueSaleOrgUnitInfo(entryInfo.getIssueSaleOrgUnit());
        paramInfo.setSupplySaleOrgUnitInfo(entryInfo.getSupplySaleOrgUnit());
        paramInfo.setRequireSaleOrgUnitInfo(entryInfo.getRequireSaleOrgUnit());
        paramInfo.setIssueStorageOrgUnitInfo(issueSou);
        paramInfo.setIssueWarehsInfo(entryInfo.getIssueWarehouse());
        paramInfo.setExchangeRageInfo(this.exchangeRateInfo);
        if (issueSou == null) {
            paramInfo.setCalType(null);
            paramInfo.setMoveAverage(false);
        } else {
            AccountType accType = matCouMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getIssueCompanyOrgUnit().getId().toString()).getAccountType();
            paramInfo.setMoveAverage(accType == null ? false : accType.equals((Object)AccountType.MOVE_ADD_AVERAGE));
            paramInfo.setCalType(this.getCalType(entryInfo.getIssueCompanyOrgUnit(), ctx));
        }
        this.setLotCalculate(entryInfo, paramInfo, entryInfo.getMaterial().getId().toString(), matCouMap);
        return paramInfo;
    }

    private Map<String, MaterialCompanyInfoInfo> getMaterialCouMap(TransferOrderBillEntryCollection entryCol, Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            TransferOrderBillEntryInfo entryInfo = entryCol.get(i);
            filter.appendFilterItem("Mateial", (Object)entryInfo.getMaterial().getId().toString());
            filter.appendFilterItem("Company", (Object)entryInfo.getIssueCompanyOrgUnit().getId().toString());
        }
        StringBuffer maskString = new StringBuffer();
        int size2 = filter.getFilterItems().size();
        for (int i = 0; i < size2; i += 2) {
            maskString.append("#").append(i).append(" and ").append("#").append(i + 1);
            if (i >= size2 - 2) continue;
            maskString.append(" or ");
        }
        filter.setMaskString(maskString.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("Mateial"));
        view.getSelector().add(new SelectorItemInfo("Company"));
        view.getSelector().add(new SelectorItemInfo("AccountType"));
        MaterialCompanyInfoCollection matCouCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
        HashMap<String, MaterialCompanyInfoInfo> result = new HashMap<String, MaterialCompanyInfoInfo>(matCouCol.size());
        int size3 = matCouCol.size();
        for (int i = 0; i < size3; ++i) {
            MaterialCompanyInfoInfo matCouInfo = matCouCol.get(i);
            result.put(matCouInfo.getMateial().getId().toString() + matCouInfo.getCompany().getId().toString(), matCouInfo);
        }
        return result;
    }

    private String getCalType(CompanyOrgUnitInfo issueCou, Context ctx) throws BOSException, EASBizException {
        String key = "SCM_CAL_002" + issueCou.getId().toString();
        if (!this.paramMap.containsKey(key)) {
            this.paramMap.put(key, ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(issueCou.getId().toString()), "SCM_CAL_002"));
        }
        return (String)this.paramMap.get(key);
    }

    private void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TransferOrderBillInfo toInfo = (TransferOrderBillInfo)model;
        if (toInfo == null || toInfo.getEntry() == null || toInfo.getEntry().size() <= 0) {
            return;
        }
        this.calByUnitSource(ctx, toInfo, (IObjectCollection)toInfo.getEntry());
        this.setNULLToZERO((IObjectValue)toInfo);
        SCMBizDataVO dataVO = new SCMBizDataVO();
        SCMEntryDataVO scmEntryDataVO = new SCMEntryDataVO();
        dataVO.setScmEntryDataVO(scmEntryDataVO);
        this.initSCMBizDataVO(ctx, dataVO, toInfo.getEntry());
        scmEntryDataVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(dataVO.getScmEntryDataVO());
        try {
            Class<TransferOrderBillEntryInfo> clazz = TransferOrderBillEntryInfo.class;
            TransferOrderBillControllerBean.formatQtyPrecision((AbstractObjectCollection)toInfo.getEntry(), (Method)clazz.getMethod("getQty", new Class[0]), (Method)clazz.getMethod("setBaseQty", BigDecimal.class), (Method)clazz.getMethod("setAssistQty", BigDecimal.class), (Method)clazz.getMethod("setAssistUnit", MeasureUnitInfo.class), (Method)clazz.getMethod("getAssistQty", new Class[0]), (SCMEntryDataVO)scmEntryDataVO);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        try {
            new TransferOrderAlgorithmForInfo(toInfo, ctx).revalue();
        }
        catch (Exception e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private void setNULLToZERO(IObjectValue invBill) {
        int headSize = headFields.length;
        for (int i = 0; i < headSize; ++i) {
            if (invBill.get(headFields[i]) != null) continue;
            invBill.setBigDecimal(headFields[i], ZERO);
        }
        TransferOrderBillInfo TransferOrderBillInfo2 = (TransferOrderBillInfo)invBill;
        IObjectCollection entrys = null;
        entrys = (IObjectCollection)TransferOrderBillInfo2.get("entry");
        if (entrys != null) {
            TransferOrderBillEntryInfo entry = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                int j;
                entry = (TransferOrderBillEntryInfo)entrys.getObject(i);
                for (j = 0; j < fields.length; ++j) {
                    if (entry.get(fields[j]) != null) continue;
                    entry.setBigDecimal(fields[j], ZERO);
                }
                for (j = 0; j < subFields.length; ++j) {
                    if (!entry.containsKey(subFields[j]) || entry.get(subFields[j]) != null) continue;
                    entry.setBigDecimal(subFields[j], ZERO);
                }
            }
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getInnerCusSup(Context ctx, String pk, boolean isSupplier) throws BOSException, EASBizException {
        String outCompanyId = null;
        String inCompanyId = null;
        ObjectUuidPK billPK = new ObjectUuidPK(pk);
        TransferOrderBillInfo billInfo = this.getTransferOrderBillInfo(ctx, (IObjectPK)billPK);
        outCompanyId = billInfo.getIssueCompanyOrgUnit().getId().toString();
        inCompanyId = billInfo.getReceiptCompanyOrgUnit().getId().toString();
        SupplierInfo csuSup = null;
        if (isSupplier) {
            SupplierCollection csuSups = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollectionByInter(outCompanyId);
            if (csuSups != null && csuSups.size() > 0) {
                csuSup = csuSups.get(0);
            }
        } else {
            CustomerCollection csuSups = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollectionByInter(inCompanyId);
            if (csuSups != null && csuSups.size() > 0) {
                csuSup = csuSups.get(0);
            }
        }
        return csuSup;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage = ((TransferOrderBillInfo)model).getIssueStorageOrgUnit();
        String storageID = null;
        if (storage != null) {
            storageID = storage.getId().toString();
        }
        return storageID;
    }

    protected void _checkAutoTransfer(Context ctx, String billID) throws BOSException, EASBizException {
        ISCMFetchDataFacade iSCMFetchDataFacade = SCMFetchDataFacadeFactory.getLocalInstance((Context)ctx);
        if (billID == null) {
            throw new TransferOrderBillException(TransferOrderBillException.IDISNULL);
        }
        TransferOrderBillInfo bill = (TransferOrderBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billID));
        StorageOrgUnitInfo sou = bill.getIssueStorageOrgUnit();
        SCMFetchData fetchData = iSCMFetchDataFacade.fetchData(TransferOrderBillControllerBean.buildCondition(ctx, bill).toEntiryView());
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            TransferOrderBillEntryInfo entry = bill.getEntry().get(i);
            String materialID = entry.getMaterial().getId().toString();
            if (!fetchData.getIsLotNumber(materialID, sou.getId().toString()) || !StringUtils.isEmpty((String)entry.getLot())) continue;
            throw new TransferOrderBillException(TransferOrderBillException.LOTISNULL, new Object[]{new Integer(entry.getSeq())});
        }
    }

    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TransferOrderBillInfo aTransferOrderBillInfo = (TransferOrderBillInfo)model;
        if (aTransferOrderBillInfo.getBillType() != null) {
            String billTypeId = aTransferOrderBillInfo.getBillType().getId().toString();
            String orgUnitID = aTransferOrderBillInfo.getIssueStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().equalsIgnoreCase("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    protected SelectorItemCollection getSelectors(Context ctx) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        sic.add("entry.issueWarehouse.hasLocation");
        sic.add("entry.receiptWarehouse.hasLocation");
        return sic;
    }

    protected static SCMFetchDataCondition buildCondition(Context ctx, TransferOrderBillInfo bill) {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        ArrayList<String> materialPKList = new ArrayList<String>();
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            materialPKList.add(bill.getEntry().get(i).getMaterial().getId().toString());
        }
        String[] materialPKs = new String[materialPKList.size()];
        materialPKList.toArray(materialPKs);
        condition.setMaterialPKs(materialPKs);
        condition.setSou(bill.getIssueStorageOrgUnit());
        condition.setFetchSou(true);
        condition.setFetchIsLotNumber(true);
        condition.setFetchIsPeriodValid(true);
        return condition;
    }

    @Override
    protected void _initDataFromStockTransfer(Context ctx) throws BOSException, EASBizException {
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillInfo info = this.getTransferOrderBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (pk == null && model == null) {
            return;
        }
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)model;
        billInfo = model == null ? this.getTransferOrderBillInfo(ctx, pk, this.getSelector()) : this.getTransferOrderBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId().toString()), this.getSelector());
        if (pk == null) {
            pk = new ObjectUuidPK(billInfo.getId());
        }
        if (billInfo.getBaseStatus().getValue() == -2) {
            this._agreeAlter(ctx, pk);
            int bizDirection = 1;
            if (billInfo.getBizDirection() != null) {
                bizDirection = billInfo.getBizDirection().getValue();
            }
            this.setTransOrderStatus(ctx, billInfo.getId().toString(), bizDirection);
            return;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{billInfo})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillInfo info = this.getTransferOrderBillInfo(ctx, pk, this.getSelector());
        this.unpassAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        return batchResults;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchActionEnum);
    }

    @Override
    protected void _initDataFromST(Context ctx, Vector billList) throws BOSException, EASBizException {
        ST2TOUtils.initDataFromST(ctx, billList);
    }

    protected String getMatOrgMaskString(int size, int interval) {
        interval = 2;
        StringBuffer maskString = new StringBuffer();
        int length = size;
        for (int i = 0; i < length; i += interval) {
            maskString.append("(#").append(i).append(" and ");
            maskString.append("#").append(i + 1).append(")");
            if (i >= length - interval) continue;
            maskString.append(" or ");
        }
        return maskString.toString();
    }

    private void init4Check(Context ctx, TransferOrderBillEntryCollection entryCol, String requireSouId, String requireCouId, String supplyCouId) throws InvBizException, BOSException, EASBizException {
        HashSet<String> matSet = new HashSet<String>();
        HashSet<String> souSet = new HashSet<String>();
        souSet.add(requireSouId);
        HashSet<String> couSet = new HashSet<String>();
        couSet.add(supplyCouId);
        couSet.add(requireCouId);
        int size = entryCol.size();
        TransferOrderBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            matSet.add(entryInfo.getMaterial().getId().toString());
            souSet.add(entryInfo.getIssueStorageOrgUnit().getId().toString());
            souSet.add(entryInfo.getReceiveStorageOrgUnit().getId().toString());
            couSet.add(entryInfo.getIssueCompanyOrgUnit().getId().toString());
            couSet.add(entryInfo.getReceiveCompanyOrgUnit().getId().toString());
        }
        FilterInfo souFilter = new FilterInfo();
        souFilter.getFilterItems().add(new FilterItemInfo("material", matSet, CompareType.INCLUDE));
        souFilter.getFilterItems().add(new FilterItemInfo("orgUnit", souSet, CompareType.INCLUDE));
        FilterInfo couFilter = new FilterInfo();
        couFilter.getFilterItems().add(new FilterItemInfo("mateial", matSet, CompareType.INCLUDE));
        couFilter.getFilterItems().add(new FilterItemInfo("company", couSet, CompareType.INCLUDE));
        EntityViewInfo matInvView = new EntityViewInfo();
        matInvView.setFilter(souFilter);
        matInvView.getSelector().add("id");
        matInvView.getSelector().add("orgUnit");
        matInvView.getSelector().add("orgUnit.number");
        matInvView.getSelector().add("orgUnit.name");
        matInvView.getSelector().add("material");
        matInvView.getSelector().add("material.number");
        matInvView.getSelector().add("material.name");
        matInvView.getSelector().add("status");
        MaterialInventoryCollection matInvCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(matInvView);
        this.matInvMap = new HashMap(size * 4);
        this.matCouMap = new HashMap(size * 4);
        int length = matInvCol.size();
        for (int i = 0; i < length; ++i) {
            MaterialInventoryInfo matInvInfo = matInvCol.get(i);
            this.matInvMap.put(matInvInfo.getMaterial().getId().toString() + matInvInfo.getOrgUnit().getId().toString(), matInvInfo);
        }
        EntityViewInfo matCouView = new EntityViewInfo();
        matCouView.setFilter(couFilter);
        matCouView.getSelector().add("id");
        matCouView.getSelector().add("company");
        matCouView.getSelector().add("mateial");
        matCouView.getSelector().add("status");
        MaterialCompanyInfoCollection matCouCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(matCouView);
        int length2 = matCouCol.size();
        for (int i = 0; i < length2; ++i) {
            MaterialCompanyInfoInfo matCouInfo = matCouCol.get(i);
            this.matCouMap.put(matCouInfo.getMateial().getId().toString() + matCouInfo.getCompany().getId().toString(), matCouInfo);
        }
    }

    private void checkMaterialInvAndComInfo(Context ctx, IMaterial ima, TransferOrderBillEntryCollection entryCol, String requireSouId, String requireCouId, String supplyCouId) throws InvBizException, BOSException, EASBizException {
        TransferOrderBillEntryInfo entryInfo = null;
        IMaterialInventory imi = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        int size = entryCol.size();
        this.init4Check(ctx, entryCol, requireSouId, requireCouId, supplyCouId);
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            MaterialInfo material = entryInfo.getMaterial();
            String materialId = entryInfo.getMaterial().getId().toString();
            if (material.getNumber() == null) {
                material = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId), this.materialSelector);
            }
            String matNumber = material.getNumber();
            if (this.getCompanyInfo(ima, materialId, supplyCouId) == null || this.getCompanyInfo(ima, materialId, supplyCouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_MOVEISSUE_COM_NULL, new String[]{matNumber});
            }
            if (this.getInventoryInfo(imi, materialId, requireSouId) == null || this.getInventoryInfo(imi, materialId, requireSouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_MOVEIN_INV_NULL, new String[]{matNumber});
            }
            if (this.getCompanyInfo(ima, materialId, requireCouId) == null || this.getCompanyInfo(ima, materialId, requireCouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_MOVEIN_COM_NULL, new String[]{matNumber});
            }
            if (this.getCompanyInfo(ima, materialId, entryInfo.getIssueCompanyOrgUnit().getId().toString()) == null || this.getCompanyInfo(ima, materialId, entryInfo.getIssueCompanyOrgUnit().getId().toString()).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_ISSUE_COM_NULL, new String[]{matNumber});
            }
            if (this.getInventoryInfo(imi, materialId, entryInfo.getIssueStorageOrgUnit().getId().toString()) == null || this.getInventoryInfo(imi, materialId, entryInfo.getIssueStorageOrgUnit().getId().toString()).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_ISSUE_SOU_NULL, new String[]{matNumber});
            }
            if (this.getCompanyInfo(ima, materialId, entryInfo.getReceiveCompanyOrgUnit().getId().toString()) == null || this.getCompanyInfo(ima, materialId, entryInfo.getReceiveCompanyOrgUnit().getId().toString()).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_RECEIVE_COM_NULL, new String[]{matNumber});
            }
            if (this.getInventoryInfo(imi, materialId, entryInfo.getReceiveStorageOrgUnit().getId().toString()) != null && !this.getInventoryInfo(imi, materialId, entryInfo.getReceiveStorageOrgUnit().getId().toString()).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) continue;
            throw new InvBizException(InvBizException.MATERIAL_RECEIVE_SOU_NULL, new String[]{matNumber});
        }
    }

    private MaterialCompanyInfoInfo getCompanyInfo(IMaterial ima, String materialId, String couId) throws BOSException {
        String key = materialId + couId;
        if (!this.matCouMap.containsKey(key)) {
            this.matCouMap.put(key, ima.getCompanyInfo(materialId, couId));
        }
        return (MaterialCompanyInfoInfo)this.matCouMap.get(key);
    }

    private MaterialInventoryInfo getInventoryInfo(IMaterialInventory ima, String materialId, String souId) throws BOSException, EASBizException {
        String key = materialId + souId;
        if (!this.matInvMap.containsKey(key)) {
            this.matInvMap.put(key, ima.getInventoryInfo(materialId, souId));
        }
        return (MaterialInventoryInfo)this.matInvMap.get(key);
    }

    @Override
    protected IObjectValue _createNewData(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0117-1000-e000-04c5c0a812202407435C"));
        if (!this.isBizTypeValid(ctx, null, "Eg5BUQEVEADgAAABwKgOEEY+1VI=", bizTypeInfo, true).booleanValue()) {
            ((TransferOrderBillInfo)billInfo).setBizType(null);
        } else {
            ((TransferOrderBillInfo)billInfo).setBizType(bizTypeInfo);
        }
        StorageOrgUnitInfo supplySouInfo = ((TransferOrderBillInfo)billInfo).getIssueStorageOrgUnit();
        CompanyOrgUnitInfo supplyCouInfo = null;
        if (supplySouInfo != null) {
            supplyCouInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(supplySouInfo.getId());
        }
        if (supplyCouInfo != null) {
            if (supplyCouInfo.getBaseCurrency() != null) {
                supplyCouInfo.setBaseCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(supplyCouInfo.getBaseCurrency().getId())));
            }
            ((TransferOrderBillInfo)billInfo).setIssueCompanyOrgUnit(supplyCouInfo);
            ((TransferOrderBillInfo)billInfo).setCurrency(supplyCouInfo.getBaseCurrency());
        }
        Timestamp ts = new Timestamp(Calendar.getInstance().getTimeInMillis());
        ((TransferOrderBillInfo)billInfo).setBizDate(ts);
        ((TransferOrderBillInfo)billInfo).setCreateTime(ts);
        return billInfo;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            TransferOrderBillInfo billInfo = (TransferOrderBillInfo)collection.getObject(i);
            if (billInfo.getBillType() == null) {
                BillTypeInfo billType = new BillTypeInfo();
                billType.setId(BOSUuid.read((String)"Eg5BUQEVEADgAAABwKgOEEY+1VI="));
                billInfo.setBillType(billType);
            }
            this.setDefaultTaxRate(ctx, billInfo);
            this.initBotpData(ctx, (IObjectValue)billInfo);
            if (billInfo.getReceiptCompanyOrgUnit() != null && billInfo.getIssueCompanyOrgUnit() != null && billInfo.getBizType() == null) {
                ObjectUuidPK pk = new ObjectUuidPK("d8e80652-0117-1000-e000-04c5c0a812202407435C");
                BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)pk);
                billInfo.setBizType(bizTypeInfo);
            }
            Map materialPlanMap = new HashMap();
            materialPlanMap = this.getMaterialPlanMap(ctx, billInfo);
            TransferOrderBillEntryCollection entryCol = billInfo.getEntry();
            TransferOrderBillEntryInfo entryInfo = null;
            SaleOrgUnitInfo issueLouInfos = new SaleOrgUnitInfo();
            int num = entryCol.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = entryCol.get(j);
                if (entryInfo.getReceiptPlanDate() == null) {
                    entryInfo.setReceiptPlanDate(new Date());
                }
                if (entryInfo.getIssuePlanDate() == null) {
                    entryInfo.setIssuePlanDate(new Date());
                }
                if (entryInfo.getDiscountType() == null) {
                    entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
                }
                MaterialPlanInfo matPlanInfo = null;
                entryInfo.setIsMrpCal(false);
                if (entryInfo.getIssueStorageOrgUnit() == null || entryInfo.getIssueStorageOrgUnit().getId() == null || entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
                String materialID = entryInfo.getMaterial().getId().toString();
                String orgUnitID = entryInfo.getIssueStorageOrgUnit().getId().toString();
                issueLouInfos = InvServerUtils.getOrgInfoFromOrgInfo(ctx, (OrgUnitInfo)entryInfo.getIssueStorageOrgUnit(), 4, 2, issueLouInfos);
                if (entryInfo.getIssueSaleOrgUnit() == null) {
                    entryInfo.setIssueSaleOrgUnit(issueLouInfos);
                }
                if (!materialPlanMap.containsKey(materialID + orgUnitID) || (matPlanInfo = (MaterialPlanInfo)materialPlanMap.get(materialID + orgUnitID)) == null || matPlanInfo.getStatus() != UsedStatusEnum.APPROVED || matPlanInfo.getPlanningMode() == null || !matPlanInfo.getPlanningMode().equals((Object)PlanningModeEnum.MRP) && !matPlanInfo.getPlanningMode().equals((Object)PlanningModeEnum.MPS)) continue;
                entryInfo.setIsMrpCal(true);
            }
        }
    }

    private void setDefaultTaxRate(Context ctx, TransferOrderBillInfo billInfo) throws EASBizException, BOSException {
        OrgUnitCollection saleOrgColl;
        if (billInfo == null) {
            return;
        }
        TransferOrderBillEntryCollection collection = billInfo.getEntry();
        String strPurParam = null;
        StorageOrgUnitInfo storageOrgUnitInfo = billInfo.getIssueStorageOrgUnit();
        OrgUnitInfo saleInfo = SCMGroupServerUtils.getDefaultOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Sale, (String)storageOrgUnitInfo.getId().toString());
        if (saleInfo == null && (saleOrgColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(storageOrgUnitInfo.getId().toString(), 4, 2)).size() > 0) {
            saleInfo = saleOrgColl.get(0);
        }
        if (saleInfo != null) {
            strPurParam = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(saleInfo.getId()), "SALEBILL001");
        }
        if (strPurParam == null || strPurParam.trim().length() == 0) {
            return;
        }
        if (strPurParam.trim().equalsIgnoreCase("true")) {
            this.setDefaultTaxRateByRecCustomer(ctx, collection);
        } else {
            this.setDefaultTaxRateByRecSaleOrg(ctx, collection, saleInfo);
        }
    }

    private void setDefaultTaxRateByRecCustomer(Context ctx, TransferOrderBillEntryCollection collection) throws EASBizException, BOSException {
        BigDecimal defaultTaxRate = SCMConstant.DefaultTaxRate;
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        StorageOrgUnitInfo org = null;
        TransferOrderBillEntryInfo entryInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            CustomerInfo custmerInfo = null;
            entryInfo = collection.get(i);
            if (entryInfo.getTaxRate() != null) continue;
            org = entryInfo.getReceiveStorageOrgUnit();
            if (org == null) {
                return;
            }
            if (customerMap.get(org.getId().toString()) == null) {
                OrgUnitCollection coll = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Storage, (OrgType)OrgType.Company, (String)org.getId().toString());
                OrgUnitInfo requireCouInfo = coll.get(0);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("taxRate"));
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)requireCouInfo.getId().toString()));
                ev.setFilter(fi);
                ev.setSelector(sic);
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                CustomerCollection cusCol = iCustomer.getCustomerCollection(ev);
                custmerInfo = cusCol.get(0);
                customerMap.put(org.getId().toString(), custmerInfo);
            } else {
                custmerInfo = (CustomerInfo)customerMap.get(org.getId().toString());
            }
            if (custmerInfo != null) {
                entryInfo.setTaxRate(custmerInfo.getTaxRate());
                if (custmerInfo.getTaxRate() != null) continue;
                entryInfo.setTaxRate(defaultTaxRate);
                continue;
            }
            entryInfo.setTaxRate(defaultTaxRate);
        }
    }

    private void setDefaultTaxRateByRecSaleOrg(Context ctx, TransferOrderBillEntryCollection collection, OrgUnitInfo saleInfo) throws BOSException {
        BigDecimal defaultTaxRate = SCMConstant.DefaultTaxRate;
        HashSet<String> matIdSet = new HashSet<String>();
        TransferOrderBillEntryInfo entryInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            entryInfo = collection.get(i);
            matIdSet.add(entryInfo.getMaterial().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        view.getSelector().add(new SelectorItemInfo("taxRate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", matIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)saleInfo.getId().toString(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        MaterialSalesCollection matSaleCol = MaterialSalesFactory.getLocalInstance((Context)ctx).getMaterialSalesCollection(view);
        HashMap<String, MaterialSalesInfo> matSaleMap = new HashMap<String, MaterialSalesInfo>();
        for (int i = 0; i < matSaleCol.size(); ++i) {
            entryInfo = collection.get(i);
            if (entryInfo.getTaxRate() != null) continue;
            matSaleMap.put(matSaleCol.get(i).getMaterial().getId().toString(), matSaleCol.get(i));
        }
        if (matSaleMap.isEmpty()) {
            return;
        }
        MaterialSalesInfo materialSalesInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            entryInfo = collection.get(i);
            materialSalesInfo = (MaterialSalesInfo)matSaleMap.get(entryInfo.getMaterial().getId().toString());
            if (materialSalesInfo == null) continue;
            if (materialSalesInfo.getTaxRate() == null) {
                entryInfo.setTaxRate(defaultTaxRate);
                continue;
            }
            entryInfo.setTaxRate(materialSalesInfo.getTaxRate());
        }
    }

    @Override
    protected void _checkAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillInfo info = this.getTransferOrderBillInfo(ctx, pk);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getIssueStorageOrgUnit().getId().toString()), "transferorder_alter");
        BillBaseStatusEnum baseStatus = info.getBaseStatus();
        if (baseStatus != null && baseStatus.getValue() != 4) {
            throw new TransferOrderBillException(TransferOrderBillException.BILLBASESTATUS_CANNOT_ALERT, new String[]{baseStatus.toString()});
        }
    }

    protected void _checkAlterData(Context ctx, IObjectValue oldModel, IObjectValue newModel) throws BOSException, EASBizException {
        TransferOrderBillInfo oldInfo = (TransferOrderBillInfo)oldModel;
        TransferOrderBillInfo newInfo = (TransferOrderBillInfo)newModel;
        TransferOrderBillEntryCollection oldEntries = oldInfo.getEntry();
        TransferOrderBillEntryCollection newEntries = newInfo.getEntry();
        TransferOrderBillEntryInfo oldEntryInfo = null;
        AbstractTransferOrderBillEntryInfo newEntryInfo = null;
        boolean isError = false;
        StringBuffer errorMsg = new StringBuffer();
        boolean isOK = true;
        int size = oldEntries.size();
        for (int i = 0; i < size; ++i) {
            oldEntryInfo = oldEntries.get(i);
            if (oldEntryInfo.getBaseStatus().getValue() == 6 || oldEntryInfo.getBaseStatus().getValue() == 7) continue;
            isOK = false;
        }
        if (isOK && oldEntries.size() == newEntries.size()) {
            throw new TransferOrderBillException(TransferOrderBillException.CANNOT_ALTER);
        }
        boolean isPurOrderBotpBill = newInfo.getSourceBillType() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(newInfo.getSourceBillType().getId().toString());
        boolean isPurInBotpBill = newInfo.getSourceBillType() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(newInfo.getSourceBillType().getId().toString());
        StringBuffer msg = new StringBuffer();
        IPurOrderEntry ipoe = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        IPurInWarehsEntry ipiw = PurInWarehsEntryFactory.getLocalInstance(ctx);
        PurInWarehsEntryInfo purInwarehsEntryInfo = null;
        PurOrderEntryInfo purOrderEntryInfo = null;
        int num = oldEntries.size();
        for (int i = 0; i < num; ++i) {
            BigDecimal validQty;
            oldEntryInfo = oldEntries.get(i);
            if (oldEntryInfo.getBaseStatus().getValue() == 6 || oldEntryInfo.getBaseStatus().getValue() == 7) continue;
            newEntryInfo = null;
            for (int x = 0; x < newEntries.size(); ++x) {
                if (oldEntryInfo == null || oldEntryInfo.getId() == null || newEntries.get(x) == null || newEntries.get(x).getId() == null || !oldEntryInfo.getId().toString().equals(newEntries.get(x).getId().toString())) continue;
                newEntryInfo = newEntries.get(x);
            }
            if (newEntryInfo == null) continue;
            if (oldEntryInfo.getBaseStatus().getValue() != 4 && !ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)oldEntryInfo, newEntryInfo)) {
                if (isError) {
                    errorMsg.append(", ");
                }
                errorMsg.append(i + 1);
                isError = true;
                continue;
            }
            BigDecimal oldQty = oldEntryInfo.getQty().abs();
            BigDecimal newQty = newEntryInfo.getQty().abs();
            boolean isAlterCanGreatQty = this.isAlterCanGreatQty(ctx, oldInfo.getIssueStorageOrgUnit().getId().toString());
            if (!isAlterCanGreatQty && newQty.compareTo(oldQty) > 0) {
                throw new TransferOrderBillException(TransferOrderBillException.ALERT_QTY_CANNOT_GT_OLDQTY);
            }
            if (oldQty.compareTo(newQty) != 0) {
                BigDecimal issueQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getIssueQty()).abs();
                BigDecimal receiptQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getReceiptQty()).abs();
                BigDecimal saleInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getSaleInvoiceQty()).abs();
                BigDecimal purInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getPurInvoiceQty()).abs();
                BigDecimal carryQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getPlanDeliveryQty()).abs();
                BigDecimal totalSaleReturnQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getTotalSaleReturnQty()).abs();
                BigDecimal totalPurReturnQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getTotalPurReturnQty()).abs();
                BigDecimal biggestQty = issueQty.compareTo(receiptQty) > 0 ? issueQty : receiptQty;
                biggestQty = biggestQty.compareTo(saleInvoiceQty) > 0 ? biggestQty : saleInvoiceQty;
                biggestQty = biggestQty.compareTo(purInvoiceQty) > 0 ? biggestQty : purInvoiceQty;
                biggestQty = biggestQty.compareTo(carryQty) > 0 ? biggestQty : carryQty;
                biggestQty = biggestQty.compareTo(totalSaleReturnQty) > 0 ? biggestQty : totalSaleReturnQty;
                BigDecimal bigDecimal = biggestQty = biggestQty.compareTo(totalPurReturnQty) > 0 ? biggestQty : totalPurReturnQty;
                if (newQty.compareTo(biggestQty) < 0) {
                    throw new TransferOrderBillException(TransferOrderBillException.ALERT_QTY_CANNOT_LT_IMPLQTY, new String[]{newEntryInfo.getSeq() + ""});
                }
            }
            BigDecimal alterQty = newEntryInfo.getQty().subtract(oldEntryInfo.getQty());
            if (isPurOrderBotpBill) {
                purOrderEntryInfo = ipoe.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newEntryInfo.getSourceBillEntryId())));
                if (!purOrderEntryInfo.getUnit().getId().equals((Object)newEntryInfo.getUnit().getId())) {
                    alterQty = InvAppUtils.getMultiUnitQty(ctx, purOrderEntryInfo.getUnit(), newEntryInfo.getUnit(), newEntryInfo.getMaterial(), alterQty);
                }
                if ((validQty = purOrderEntryInfo.getQty().subtract(purOrderEntryInfo.getTotalMoveQty().add(alterQty))).signum() < 0 && !isAlterCanGreatQty) {
                    validQty = validQty.setScale(6, 4);
                    BigDecimal oldQty2 = InvAppUtils.getMultiUnitQty(ctx, purOrderEntryInfo.getUnit(), newEntryInfo.getUnit(), newEntryInfo.getMaterial(), oldQty);
                    msg.append("\n").append(i + 1).append(": ").append(ResourceUtil.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"udpateQtyBigger", (Locale)ctx.getLocale()));
                }
            }
            if (!isPurInBotpBill) continue;
            purInwarehsEntryInfo = ipiw.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newEntryInfo.getSourceBillEntryId())));
            if (!purInwarehsEntryInfo.getUnit().getId().equals((Object)newEntryInfo.getUnit().getId())) {
                alterQty = InvAppUtils.getMultiUnitQty(ctx, purInwarehsEntryInfo.getUnit(), newEntryInfo.getUnit(), newEntryInfo.getMaterial(), alterQty);
            }
            if ((validQty = purInwarehsEntryInfo.getQty().subtract(purInwarehsEntryInfo.getTotalMoveQty().add(purInwarehsEntryInfo.getReverseQty()).add(alterQty))).signum() >= 0) continue;
            msg.append("\n " + (i + 1) + ": " + purInwarehsEntryInfo.getQty().add(oldQty).subtract(purInwarehsEntryInfo.getTotalMoveQty().add(purInwarehsEntryInfo.getReverseQty())).setScale(6, 4).doubleValue());
            msg.append(MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(purInwarehsEntryInfo.getUnit().getId())).getName());
        }
        if (isError) {
            throw new TransferOrderBillException(TransferOrderBillException.ENTRYBASESTATUS_CANNOT_ALERT, new String[]{errorMsg.toString()});
        }
        if (msg.length() > 0) {
            throw new InvUpdateException(InvUpdateException.MOVEQTYVALID, new String[]{msg.toString()});
        }
        int size2 = newEntries.size();
        for (int j = 0; j < size2; ++j) {
            String errorStr;
            TransferOrderBillEntryInfo transferOrderBillEntryInfo = newEntries.get(j);
            if (transferOrderBillEntryInfo.isIsPresent()) continue;
            if (newInfo.isIsInTax()) {
                if (transferOrderBillEntryInfo.getTaxPrice() != null && transferOrderBillEntryInfo.getTaxPrice().compareTo(BigDecimal.ZERO) > 0) continue;
                errorStr = ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"TAXPRICELESSZERO", (Locale)ctx.getLocale(), (Object[])new Object[]{j + 1});
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{errorStr});
            }
            if (transferOrderBillEntryInfo.getPrice() != null && transferOrderBillEntryInfo.getPrice().compareTo(BigDecimal.ZERO) > 0) continue;
            errorStr = ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.InvAddResource", (String)"PriceLessZero", (Locale)ctx.getLocale(), (Object[])new Object[]{j + 1});
            throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{errorStr});
        }
    }

    protected boolean isAlterCanGreatQty(Context ctx, String orgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK orgUnitPK;
        boolean isAlterCanGreatQty = true;
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = paramControl.getParamValue((IObjectPK)(orgUnitPK = orgUnitID == null ? null : new ObjectUuidPK(orgUnitID)), "INM111");
        if (paramValue != null && paramValue.trim().length() != 0 && paramValue.trim().equalsIgnoreCase("true")) {
            isAlterCanGreatQty = true;
        }
        if (paramValue != null && paramValue.trim().length() != 0 && paramValue.trim().equalsIgnoreCase("false")) {
            isAlterCanGreatQty = false;
        }
        return isAlterCanGreatQty;
    }

    @Override
    protected void _alter(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        int i;
        TransferOrderBillInfo oldInfo = this.getTransferOrderBillInfo(ctx, pk);
        TransferOrderBillInfo newInfo = (TransferOrderBillInfo)model;
        TransferOrderBillEntryCollection oldEntries = oldInfo.getEntry();
        TransferOrderBillEntryCollection newEntries = newInfo.getEntry();
        TransferOrderBillEntryInfo oldEntryInfo = null;
        TransferOrderBillEntryInfo newEntryInfo = null;
        this._checkAlter(ctx, pk);
        this._checkAlterData(ctx, (IObjectValue)oldInfo, (IObjectValue)newInfo);
        int oldVersion = oldInfo.getVersion();
        if (oldVersion <= 0) {
            oldVersion = 1;
        }
        newInfo.setVersion(oldVersion + 1);
        newInfo.setOldBillStatus(newInfo.getBaseStatus());
        newInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        String requireSouId = newInfo.getReceiptStorageOrgUnit().getId().toString();
        String requireCouId = newInfo.getReceiptCompanyOrgUnit().getId().toString();
        String supplyCouId = newInfo.getIssueCompanyOrgUnit().getId().toString();
        this.checkMaterialInvAndComInfo(ctx, MaterialFactory.getLocalInstance((Context)ctx), newEntries, requireSouId, requireCouId, supplyCouId);
        int num = newEntries.size();
        for (i = 0; i < num; ++i) {
            newEntryInfo = newEntries.get(i);
            EntryBaseStatusEnum entryBaseStatus = newEntryInfo.getBaseStatus();
            if (entryBaseStatus == null || entryBaseStatus.getValue() == 0 || entryBaseStatus.getValue() == 1 || entryBaseStatus.getValue() == 2) {
                entryBaseStatus = EntryBaseStatusEnum.AUDITED;
                newEntryInfo.setBaseStatus(entryBaseStatus);
            }
            newEntryInfo.setOldBillEntryStatus(entryBaseStatus);
            if (entryBaseStatus.getValue() != 4) continue;
            newEntryInfo.setBaseStatus(EntryBaseStatusEnum.ALTERING);
        }
        oldInfo.setOldBillID(oldInfo.getId());
        oldInfo.setId(null);
        oldInfo.setVersion(oldVersion);
        oldInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
        oldInfo.setAlterDate(new Timestamp(new Date().getTime()));
        oldInfo.setOldBillStatus(oldInfo.getBaseStatus());
        oldInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
        num = oldEntries.size();
        for (i = 0; i < num; ++i) {
            oldEntryInfo = oldEntries.get(i);
            oldEntryInfo.setOldBillEntryID(oldEntryInfo.getId());
            oldEntryInfo.setId(null);
            oldEntryInfo.setOldBillEntryStatus(oldEntryInfo.getBaseStatus());
            oldEntryInfo.setBaseStatus(EntryBaseStatusEnum.VERSION);
        }
        this.setNULLToZERO((IObjectValue)oldInfo);
        this.innerAddnew(ctx, (IObjectValue)oldInfo);
        this.setNULLToZERO((IObjectValue)newInfo);
        this.innerUpdate(ctx, pk, (IObjectValue)newInfo);
        SCMServerUtils.setBizFlowRelationForAlter((Context)ctx, (IObjectValue)oldInfo, (IObjectValue)newInfo);
        InvServerUtils.handleReqPlan(newInfo.getId().toString(), "Eg5BUQEVEADgAAABwKgOEEY+1VI=", BizActionEnum.ALTER, ctx);
        this._fixBizFlowNO(ctx, model.getString("id"), "t_im_transferorderbill", "t_im_transferorderbillentry", "FOLDBILLENTRYID");
    }

    @Override
    protected void _agreeAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillInfo info = this.getTransferOrderBillInfo(ctx, pk, this.getSelector());
        info.setBaseStatus(info.getOldBillStatus());
        TransferOrderBillEntryCollection entries = info.getEntry();
        int num = entries.size();
        for (int i = 0; i < num; ++i) {
            TransferOrderBillEntryInfo entryInfo = entries.get(i);
            BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getBaseQty());
            entryInfo.setBaseStatus(entryInfo.getOldBillEntryStatus());
            entryInfo.setUnIssueBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getIssueBaseQty())));
            entryInfo.setAssociateQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getReceiptBaseQty())));
            entryInfo.setArAssociateBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getSaleInvoiceBaseQty())));
            entryInfo.setApAssociateBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPurInvoiceBaseQty())));
        }
        this.setNULLToZERO((IObjectValue)info);
        this._update(ctx, pk, (IObjectValue)info);
        this.writeBackByAgreeAlter(ctx, info);
        BizBillValueChangeUtil.handleBillAlter((Context)ctx, (IObjectValue)info, (String)"version", (String)"oldBillID", (String)"oldBillEntryID");
        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.ALTER);
    }

    protected void writeBackByAgreeAlter(Context ctx, TransferOrderBillInfo info) throws BOSException, EASBizException {
        block12: {
            int i;
            TransferOrderBillInfo oldInfo;
            block15: {
                Object[] msgs;
                block14: {
                    block13: {
                        int i2;
                        oldInfo = this.getPreviousVersionInfo(ctx, info);
                        if (oldInfo != null) {
                            this.setInnerBizPrices(ctx, (IObjectValue)info);
                        }
                        String entryTableName = "T_IM_TransferOrderBillEntry";
                        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)"T_IM_TransferOrderBillEntry")) {
                            String billID;
                            String string = billID = info.getId() == null ? null : info.getId().toString();
                            if (SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)"T_IM_TransferOrderBillEntry", (String)billID)) {
                                return;
                            }
                        }
                        if (oldInfo == null) break block12;
                        if (!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI=")) break block13;
                        TransferOrderBillEntryCollection entries = info.getEntry();
                        ArrayList<String> srcBillList = new ArrayList<String>();
                        ArrayList<String> srcEntryIds = new ArrayList<String>();
                        HashMap<String, String> destSrcEntryMap = new HashMap<String, String>();
                        int num = entries.size();
                        for (int i3 = 0; i3 < num; ++i3) {
                            TransferOrderBillEntryInfo entryInfo = entries.get(i3);
                            srcBillList.add(entryInfo.getSourceBillId());
                            srcEntryIds.add(entryInfo.getSourceBillEntryId());
                            destSrcEntryMap.put(entryInfo.getId().toString(), entryInfo.getSourceBillEntryId());
                        }
                        if (srcEntryIds != null && srcEntryIds.size() > 0) {
                            StockReqEntryFactory.getLocalInstance(ctx).autoUnClose(destSrcEntryMap, "T_IM_TransferOrderBillEntry");
                        }
                        if (srcEntryIds != null && srcEntryIds.size() > 0) {
                            StockReqEntryFactory.getLocalInstance(ctx).autoClose(destSrcEntryMap, "T_IM_TransferOrderBillEntry");
                        }
                        String[] srcBillIds = srcBillList.toArray(new String[0]);
                        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)oldInfo.getBOSType(), (String[])srcBillIds);
                        int length = handlers.length;
                        for (i2 = 0; i2 < length; ++i2) {
                            if (handlers[i2] == null) continue;
                            handlers[i2].handle(ctx, BizActionEnum.UNAUDIT, new String[]{oldInfo.getId().toString()}, (String[][])null);
                        }
                        handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)oldInfo.getBOSType(), (String[])srcBillIds);
                        length = handlers.length;
                        for (i2 = 0; i2 < length; ++i2) {
                            if (handlers[i2] == null) continue;
                            handlers[i2].handle(ctx, BizActionEnum.AUDIT, new String[]{info.getId().toString()}, (String[][])null);
                        }
                        break block12;
                    }
                    if (!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) break block14;
                    this.checkQtyValid(ctx, null, (IObjectValue)oldInfo, BizActionEnum.UNAUDIT);
                    msgs = new String[]{this.checkQtyValid(ctx, null, (IObjectValue)info, BizActionEnum.AUDIT)};
                    if (msgs[0].length() > 0) {
                        throw new InvUpdateException(InvUpdateException.MOVEQTYVALID, msgs);
                    }
                    break block12;
                }
                if (!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"50957179-0105-1000-e000-015fc0a812fd463ED552")) break block15;
                this.checkQtyValid(ctx, null, (IObjectValue)oldInfo, BizActionEnum.UNAUDIT);
                msgs = new String[]{this.checkQtyValid(ctx, null, (IObjectValue)info, BizActionEnum.AUDIT)};
                if (msgs[0].length() > 0) {
                    throw new InvUpdateException(InvUpdateException.MOVEQTYVALID, msgs);
                }
                break block12;
            }
            if (!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-0113c0a812fd463ED552")) break block12;
            IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)oldInfo.getBOSType(), (AbstractObjectCollection)oldInfo.getEntry(), (String)"sourceBillId");
            int length = handlers.length;
            for (i = 0; i < length; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].handle(ctx, BizActionEnum.UNAUDIT, new String[]{oldInfo.getId().toString()}, (String[][])null);
            }
            handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)oldInfo.getBOSType(), (AbstractObjectCollection)oldInfo.getEntry(), (String)"sourceBillId");
            length = handlers.length;
            for (i = 0; i < length; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].handle(ctx, BizActionEnum.AUDIT, new String[]{info.getId().toString()}, (String[][])null);
            }
        }
    }

    protected TransferOrderBillInfo getPreviousVersionInfo(Context ctx, TransferOrderBillInfo currentVersionInfo) throws BOSException, EASBizException {
        String billID = currentVersionInfo.getId().toString();
        int oldVersion = currentVersionInfo.getVersion() - 1;
        String oql = "where oldBillID = '" + billID + "' and version = " + String.valueOf(oldVersion);
        TransferOrderBillInfo previousVersionInfo = this.getTransferOrderBillInfo(ctx, oql);
        return previousVersionInfo;
    }

    @Override
    protected void _disaccordAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("version");
        TransferOrderBillInfo info = this.getTransferOrderBillInfo(ctx, pk, sic);
        TransferOrderBillInfo oldInfo = this.getPreviousVersionInfo(ctx, info);
        if (oldInfo != null) {
            oldInfo.setAlterPerson(null);
            oldInfo.setAlterDate(null);
            oldInfo.setBaseStatus(oldInfo.getOldBillStatus());
            TransferOrderBillEntryCollection oldEntries = oldInfo.getEntry();
            TransferOrderBillEntryInfo oldEntryInfo = null;
            int num = oldEntries.size();
            for (int i = 0; i < num; ++i) {
                oldEntryInfo = oldEntries.get(i);
                oldEntryInfo.setId(oldEntryInfo.getOldBillEntryID());
                oldEntryInfo.setBaseStatus(oldEntryInfo.getOldBillEntryStatus());
            }
            ObjectUuidPK oldPK = new ObjectUuidPK(oldInfo.getId().toString());
            this.innerDelete(ctx, new IObjectPK[]{pk, oldPK});
            this.setNULLToZERO((IObjectValue)oldInfo);
            oldInfo.setId(oldInfo.getOldBillID());
            oldInfo.setOldBillID(null);
            oldInfo.setOldBillStatus(BillBaseStatusEnum.ADD);
            this.innerAddnew(ctx, pk, (IObjectValue)oldInfo);
        }
    }

    protected void _checkUnAudit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TransferOrderBillInfo info = (TransferOrderBillInfo)model;
        if (info.getBaseStatus() != null && info.getBaseStatus().getValue() == -2) {
            throw new TransferOrderBillException(TransferOrderBillException.CANNOT_UNAUDIT, new Object[]{info.getBaseStatus().toString()});
        }
        if (info.getVersion() > 1) {
            throw new TransferOrderBillException(TransferOrderBillException.ALERT_CANNOT_UNAUDIT);
        }
    }

    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getTransferOrderBillSelector((boolean)true);
    }

    protected String getBillTypeId() {
        return "Eg5BUQEVEADgAAABwKgOEEY+1VI=";
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        SCMBillBaseInfo scmInfo = null;
        if (entries != null && entries.length > 0) {
            Object obj = entries[0].get(0);
            if (obj instanceof IObjectValue) {
                scmInfo = (SCMBillBaseInfo)entries[0].get(0);
            } else if (obj instanceof String) {
                scmInfo = this.getTransferOrderBillInfo(ctx, (IObjectPK)new ObjectUuidPK(obj.toString()));
            }
        }
        if (null == scmInfo) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(scmInfo.getId());
        if (1 == scmInfo.getOperateState()) {
            ServiceStateManager.getInstance().enableNextCallServices();
            this.alter(ctx, (IObjectPK)pk, (TransferOrderBillInfo)scmInfo);
            return null;
        }
        return super.batchSubmitRelations(ctx, entries);
    }

    protected Map getDelegateToUnitMap(Context ctx, Set fromUnitIDSet, int fromType, int toType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("fromUnit"));
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        view.getSelector().add(new SelectorItemInfo("isDefault"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", (Object)fromUnitIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        OrgUnitRelationCollection ourCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        HashMap<String, String> delegateToUnitMap = new HashMap<String, String>(ourCollection.size() * 2 + 1);
        OrgUnitRelationInfo orgUnitRelationInfo = null;
        int n = ourCollection.size();
        for (int i = 0; i < n; ++i) {
            orgUnitRelationInfo = ourCollection.get(i);
            String fromUnitID = orgUnitRelationInfo.getFromUnit().getId().toString();
            String toUnitID = orgUnitRelationInfo.getToUnit().getId().toString();
            if (delegateToUnitMap.containsKey(fromUnitID) && !orgUnitRelationInfo.isIsDefault()) continue;
            delegateToUnitMap.put(fromUnitID, toUnitID);
        }
        return delegateToUnitMap;
    }

    private void writeBackNumberProductionOrder(Context ctx, TransferOrderBillInfo transferOrderBillInfo) throws BOSException, EASBizException {
        if (transferOrderBillInfo != null && transferOrderBillInfo.getSourceBillType() != null && transferOrderBillInfo.getSourceBillType().getId() != null && "PJSZtgEhEADgAAJ8fwAAAUY+1VI=".equalsIgnoreCase(transferOrderBillInfo.getSourceBillType().getId().toString())) {
            String billId = transferOrderBillInfo.getId().toString();
            String sourceBillId = transferOrderBillInfo.getSourceBillId().toString();
            TransferOrderBillEntryCollection tobEntryCollection = transferOrderBillInfo.getEntry();
            if (tobEntryCollection != null && tobEntryCollection.size() > 0) {
                TransferOrderBillEntryInfo tobEntryInfo = null;
                HashSet<String> souceEntryIds = new HashSet<String>();
                int n = tobEntryCollection.size();
                for (int i = 0; i < n; ++i) {
                    tobEntryInfo = tobEntryCollection.get(i);
                    if (tobEntryInfo.getSourceBillEntryId() == null) continue;
                    souceEntryIds.add(tobEntryInfo.getSourceBillEntryId().toString());
                }
                IStockGatherMove stockGatherMove = StockGatherMoveFactory.getLocalInstance((Context)ctx);
                stockGatherMove.backWriteDeleteTransferBill(billId, sourceBillId, souceEntryIds, true);
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillInfo billInfo = this.getTransferOrderBillInfo(ctx, pk);
        if (billInfo.getBaseStatus().getValue() == -2) {
            throw new InvBizException(InvBizException.ALTERING_NO_REMOVE);
        }
        InvServerUtils.handleReqPlan(pk.toString(), "Eg5BUQEVEADgAAABwKgOEEY+1VI=", BizActionEnum.DELETE, ctx);
        InvServerUtils.deleteSerialNumber(ctx, pk);
        super._delete(ctx, pk);
        this.writeBackNumberProductionOrder(ctx, billInfo);
    }

    protected void setTransOrderStatus(Context ctx, String billID, int bizDirection) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement preStmt = null;
        Statement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        Statement preStmt4 = null;
        int updateLine = 0;
        int updateLine3 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        IRowSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,a.FBaseStatus as FBaseStatus,");
            if (bizDirection == 2) {
                sqlBuff.append("round(decimal(abs(a.FBaseQty) * decimal(1 - ISNULL(a.FQtyLackRate,0)/100 ,21,8) ,21,8) ,b.FQtyPrecision) - abs(a.FTotalPurReturnBaseQty) as FBaseQty");
            } else {
                sqlBuff.append("round(decimal(a.FBaseQty * decimal(1 - ISNULL(a.FQtyLackRate,0)/100 ,21,8) ,21,8) ,b.FQtyPrecision) - a.FReceiptBaseQty as FBaseQty");
            }
            sqlBuff.append(" FROM ");
            sqlBuff.append("T_IM_TransferOrderBillEntry a inner join t_bd_multimeasureunit b ");
            sqlBuff.append("on a.fmaterialid = b.fmaterialid and a.fbaseunitid = b.fmeasureunitid ");
            sqlBuff.append("WHERE ");
            sqlBuff.append(" a.FParentID = '" + billID + "'");
            String sqlStr = sqlBuff.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            preStmt = conn.prepareStatement("UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 7  WHERE FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_IM_TransferOrderBill SET FBaseStatus = 7  WHERE FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                closeOrder = false;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup(preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup(preStmt4);
    }

    private Map getMaterialPlanMap(Context ctx, TransferOrderBillInfo billInfo) throws BOSException, EASBizException {
        HashMap<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
        TransferOrderBillEntryCollection tmpEntries = billInfo.getEntry();
        TransferOrderBillEntryInfo entryInfo = null;
        StringBuffer storageId = new StringBuffer();
        StringBuffer materialId = new StringBuffer();
        MaterialPlanCollection materialPlanCollection = null;
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = tmpEntries.get(i);
            if (entryInfo.getIssueStorageOrgUnit() != null && entryInfo.getIssueStorageOrgUnit().getId() != null) {
                storageId.append("'").append(entryInfo.getIssueStorageOrgUnit().getId().toString()).append("',");
            }
            if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
            materialId.append("'").append(entryInfo.getMaterial().getId().toString()).append("',");
        }
        if (storageId != null && storageId.length() > 0) {
            storageId.setLength(storageId.length() - 1);
        }
        if (materialId != null && materialId.length() > 0) {
            materialId.setLength(materialId.length() - 1);
        }
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        if (materialId != null && storageId != null) {
            materialPlanCollection = iMaterialPlan.getMaterialPlanCollection(" select id,material.id,orgUnit.id,manufactureStrategy.id,manufactureStrategy.number,isolatedRule,status,planningMode  where material.id in ( " + materialId.toString() + " ) and orgUnit.id in ( " + storageId.toString() + ")");
        }
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo info = materialPlanCollection.get(i);
                if (info == null || info.getMaterial() == null || info.getMaterial().getId() == null || info.getOrgUnit() == null || info.getOrgUnit().getId() == null) continue;
                materialPlanMap.put(info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString(), info);
            }
        }
        return materialPlanMap;
    }

    public String getParamCon4Audit() {
        return "INM103";
    }

    public String getParamCon4UnAudit() {
        return "INM104";
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        TransferOrderBillInfo model = this.getTransferOrderBillInfo(ctx, (IObjectPK)new ObjectStringPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        TransferOrderBillEntryInfo transferOrderBillEntryInfo = (TransferOrderBillEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = transferOrderBillEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = transferOrderBillEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = transferOrderBillEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)transferOrderBillEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)transferOrderBillEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        transferOrderBillEntryInfo.setQty(qty);
    }

    private void setLotCalculate(TransferOrderBillEntryInfo entry, PriceParamInfo priceParamInfo, String materialId, Map matCouMap) throws BOSException {
        String companyOrgUnitID = null;
        if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
            companyOrgUnitID = priceParamInfo.getCompanyOrgUnit().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
            companyOrgUnitID = priceParamInfo.getIssueCompanyOrgUnitInfo().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
            companyOrgUnitID = priceParamInfo.getRequireCompanyOrgUnitInfo().getId().toString();
        }
        MaterialCompanyInfoInfo matCouInfo = (MaterialCompanyInfoInfo)matCouMap.get(materialId + companyOrgUnitID);
        if (matCouInfo != null && AccountType.SPECIAL_ACCT.equals((Object)matCouInfo.getAccountType())) {
            AsstAttrValueInfo info;
            priceParamInfo.setSpecialAcct(true);
            priceParamInfo.setLot(matCouInfo.isIsLot());
            priceParamInfo.setAssistProperty(matCouInfo.isIsAssistProperty());
            priceParamInfo.setProject(matCouInfo.isIsProject());
            priceParamInfo.setTrackNumber(matCouInfo.isIsTrackNumber());
            if (entry.getLot() != null) {
                priceParamInfo.setLot(entry.getLot());
            }
            if (entry.getAssistProperty() != null) {
                info = entry.getAssistProperty();
                priceParamInfo.setAssistProperty(info.getId().toString());
            }
            if (entry.getProject() != null) {
                info = entry.getProject();
                priceParamInfo.setProject(info.getId().toString());
            }
            if (entry.getTrackNumber() != null) {
                info = entry.getTrackNumber();
                priceParamInfo.setTrackNumber(info.getId().toString());
            }
        }
    }
}

