/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractTransferOrderBillEntryControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.reservation.service.ReservationBillCloseService;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransferOrderBillEntryControllerBean
extends AbstractTransferOrderBillEntryControllerBean {
    private static final long serialVersionUID = 344677234565656561L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.TransferOrderBillEntryControllerBean");

    @Override
    protected void _handleClose(Context ctx, IObjectPK billId, IObjectPK entryId, String reasonCode) throws BOSException, EASBizException {
        this.handleCloseOrUnClose(ctx, billId, entryId, reasonCode, true);
    }

    @Override
    protected void _handleUnClose(Context ctx, IObjectPK billId, IObjectPK entryId) throws BOSException, EASBizException {
        this.handleCloseOrUnClose(ctx, billId, entryId, null, false);
    }

    protected void handleCloseOrUnClose(Context ctx, IObjectPK billId, IObjectPK entryId, String reasonCode, boolean isClose) throws BOSException, EASBizException {
        if (entryId != null && billId != null) {
            TransferOrderBillInfo billInfo = TransferOrderBillFactory.getLocalInstance(ctx).getTransferOrderBillInfo(billId);
            TransferOrderBillEntryInfo entryInfo = this.getTransferOrderBillEntryInfo(ctx, entryId, SCMSelectorFactory.getTransferOrderEntrySelector4CloseOrUnClose());
            if (entryInfo == null) {
                throw new ObjectNotFoundException();
            }
            this.checkStatus4CloseOrUnClose(entryInfo, isClose);
            String tableName = "T_IM_TransferOrderBillEntry";
            this.executeBizFlow(ctx, entryId, billInfo, tableName, isClose ? BatchActionEnum.CLOSE : BatchActionEnum.UNCLOSE);
            StringBuilder sql = new StringBuilder();
            if (isClose) {
                sql.append("update ").append(tableName).append(" set FBaseStatus = 7, FReason = '").append(reasonCode).append("' where FId = '").append(entryId).append("'");
            } else {
                sql.append("update ").append(tableName).append(" set FBaseStatus = 4,FReason = '' where FID = '").append(entryId).append("'");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            if (isClose) {
                sql.append("update T_IM_TransferOrderBill set FBaseStatus = ").append(7);
                sql.append(" where FId = '").append(billId).append("'");
                sql.append(" and FId not in (select FParentId from T_IM_TransferOrderBillEntry where FParentId = '");
                sql.append(billId).append("' and FBaseStatus <> 7 )");
            } else {
                sql.append("update T_IM_TransferOrderBill set FBaseStatus = ").append(4);
                sql.append(" where FId in (select FParentId from T_IM_TransferOrderBillEntry where FId = '");
                sql.append(entryId).append("' and FBaseStatus = ").append(4);
                sql.append(") and FBaseStatus = ").append(7);
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            InvServerUtils.handleReqPlan(billInfo.getId().toString(), "Eg5BUQEVEADgAAABwKgOEEY+1VI=", isClose ? BizActionEnum.CLOSE : BizActionEnum.UNCLOSE, ctx);
            if (isClose) {
                ReservationBillCloseService reservationBillCloseService = ReservationBillCloseService.getInstance();
                reservationBillCloseService.doBillReservationCancel(ctx, new IObjectPK[]{entryId});
            }
            this.writeLog(ctx, entryInfo, isClose);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TransferOrderBillEntryInfo entry = (TransferOrderBillEntryInfo)this.getValue(ctx, pk);
        TransferOrderBillInfo bill = TransferOrderBillFactory.getLocalInstance(ctx).getTransferOrderBillInfo((IObjectPK)new ObjectUuidPK(entry.getParent().getId()));
        return bill.getNumber() + "  " + entry.getSeq();
    }

    private void checkStatus4CloseOrUnClose(TransferOrderBillEntryInfo entryInfo, boolean isClose) throws InvBizException {
        if (isClose && entryInfo.getBaseStatus() != EntryBaseStatusEnum.AUDITED) {
            throw new InvBizException(InvBizException.ERROR_NOT_AUDIT_CANT_CLOSE);
        }
        if (!isClose && entryInfo.getBaseStatus() != EntryBaseStatusEnum.CLOSED) {
            throw new InvBizException(InvBizException.ERROR_NOT_CLOSED_CAN_UNCLOSE);
        }
    }

    private void writeLog(Context ctx, TransferOrderBillEntryInfo entryInfo, boolean isClose) throws EASBizException, BOSException {
        int checkStatus;
        String resName = isClose ? "OPERATOR_CLOSE" : "OPERATOR_UNCLOSE";
        int n = checkStatus = isClose ? 4 : 7;
        if (checkStatus == entryInfo.getBaseStatus().getValue()) {
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), entryInfo.getParent().getIssueStorageOrgUnit().getId().toString(), "_handleClose", "manual_default_logitem", "com.kingdee.eas.scm.im.inv.InvAddResource", resName, false, true);
        } else {
            this.writeLog(ctx, entryInfo.getParent(), entryInfo, (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), entryInfo.getParent().getIssueStorageOrgUnit().getId().toString(), "_handleClose", "manual_default_logitem", "com.kingdee.eas.scm.im.inv.InvAddResource", resName, false, false);
        }
    }

    private void executeBizFlow(Context ctx, IObjectPK entryId, TransferOrderBillInfo billInfo, String tableName, BatchActionEnum action) throws BOSException, EASBizException {
        HashSet<IObjectPK> entryIdSet = new HashSet<IObjectPK>();
        entryIdSet.add(entryId);
        Map flowMap = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (flowMap != null && flowMap.size() > 0) {
            HashMap billIdsMap = new HashMap();
            for (Map.Entry entry : flowMap.entrySet()) {
                billIdsMap.put(entry.getValue(), entry.getValue());
            }
            if (billIdsMap.containsKey(billInfo.getId().toString())) {
                TransferOrderBillEntryCollection entryColl = (TransferOrderBillEntryCollection)((Object)billInfo.getEntry().clone());
                billInfo.getEntry().clear();
                int n = entryColl.size();
                for (int j = 0; j < n; ++j) {
                    TransferOrderBillEntryInfo entryInfo = entryColl.get(j);
                    if (!flowMap.containsKey(entryInfo.getId().toString())) continue;
                    billInfo.getEntry().add(entryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)billInfo, (BatchActionEnum)action);
            }
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, view);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }
}

