/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InvImportException;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class TransferOrderBillImport
extends InvDataImport {
    TransferOrderBillInfo info = null;
    StorageOrgUnitInfo issueStorage = null;
    Set<String> manufactureStrategy = null;
    private int cprecision = 2;
    public static final BigDecimal MAXVAL = new BigDecimal("1000000000000");
    private static String resources = "com.kingdee.eas.scm.im.inv.app.TransferOrderImportResource";
    private static final String[] BIGDECIMAL_FIELDS = new String[]{"FEntry_price", "FEntry_taxRate", "FEntry_actualPrice", "FEntry_taxPrice", "FEntry_actualTaxPrice", "FEntry_discountAmount", "FEntry_amount", "FEntry_localAmount", "FEntry_tax", "FEntry_taxAmount", "FEntry_localTax", "FEntry_localTaxAmount"};
    private static final String[] BIGDECIMAL_OBJ_EN = new String[]{"price", "taxRate", "actualPrice", "taxPrice", "actualTaxPrice", "discountAmount", "amount", "localAmount", "tax", "taxAmount", "localTax", "localTaxAmount"};
    private final String[] priceFields = new String[]{"price", "actualPrice", "taxPrice", "actualTaxPrice"};
    private final String[] amountFields = new String[]{"discountAmount", "amount", "tax", "taxAmount"};
    private final String[] localAmountFields = new String[]{"localTax", "localTaxAmount", "localAmount"};

    public TransferOrderBillImport() {
        this.manufactureStrategy = new HashSet<String>();
        this.manufactureStrategy.add("MTS10");
        this.manufactureStrategy.add("MTS11");
        this.manufactureStrategy.add("MTS20");
        this.manufactureStrategy.add("ETO10");
        this.manufactureStrategy.add("ETO20");
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TransferOrderBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.info = null;
        TaskExternalException tex = new TaskExternalException("");
        int k = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            block14: {
                Map lineData = (Map)hsData.get(i);
                if (k == 0) {
                    try {
                        this.transmitHead(lineData, ctx);
                        if (this.info == null) {
                            return null;
                        }
                        this.afterBuildHead(ctx, this.info, lineData);
                    }
                    catch (BOSException e) {
                        tex.addEntryErrorReason(i, e.getMessage());
                        this.recycleNumber(ctx, this.info);
                        break;
                    }
                    catch (EASBizException e) {
                        tex.addEntryErrorReason(i, e.getMessage());
                        this.recycleNumber(ctx, this.info);
                        break;
                    }
                    catch (TaskExternalException e) {
                        tex.addEntryErrorReason(i, e.getMessage());
                        this.recycleNumber(ctx, this.info);
                        break;
                    }
                }
                TransferOrderBillEntryInfo entryInfo = null;
                try {
                    entryInfo = this.transmitEntry(lineData, ctx);
                    this.afterBuildEntry(entryInfo);
                    this.afterBuildEntry(ctx, this.info, entryInfo, lineData);
                }
                catch (EASBizException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    if (tex.getEntryErrorReasons().size() == 1) {
                        this.recycleNumber(ctx, this.info);
                    }
                }
                catch (BOSException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    if (tex.getEntryErrorReasons().size() == 1) {
                        this.recycleNumber(ctx, this.info);
                    }
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    if (tex.getEntryErrorReasons().size() != 1) break block14;
                    this.recycleNumber(ctx, this.info);
                }
            }
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.info;
    }

    private void afterBuildEntry(TransferOrderBillEntryInfo entryInfo) {
        int seq = this.info.getEntry().size() + 1;
        entryInfo.setSeq(seq);
        entryInfo.setParent(this.info);
        this.info.getEntry().add(entryInfo);
    }

    private void transmitHead(Map lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        this.info = new TransferOrderBillInfo();
        this.doIssueStorageOrgUnit(ctx, lineData);
        this.info.setCU(this.issueStorage.getCU());
        this.doBizTypeInfo(ctx, lineData);
        Date bizDate = this.doDate(ctx, lineData, "FBizDate", new Date());
        this.info.setBizDate(bizDate);
        this.info.setIssueCompanyOrgUnit(this.getCompanyOrgFromStorageOrg(ctx, this.issueStorage));
        this.doInStorageOrgUnitAndCompany(lineData, ctx);
        this.info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.doCurrency(ctx, lineData);
        Object data = ((DataToken)lineData.get((Object)"FIsInTax")).data;
        this.info.setIsInTax(DataImportUtils.getBooleanValue((Object)data, (boolean)true));
        this.info.setIsInitBill(false);
        this.doBizDirection();
        Object remark = ((DataToken)lineData.get((Object)"FDescription")).data;
        if (!this.isEmpty(remark)) {
            if (remark.toString().length() > 255) {
                remark = remark.toString().substring(0, 255);
            }
            this.info.setDescription(remark.toString());
        }
        this.doCreator(ctx, lineData);
        this.doCreateDate(ctx, lineData);
        this.info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void doCreateDate(Context ctx, Map lineData) throws TaskExternalException {
        this.info.setCreateTime(new Timestamp(new Date().getTime()));
    }

    private void doCreator(Context ctx, Map lineData) throws TaskExternalException {
        Object dateO = ((DataToken)lineData.get((Object)"FCreator_number")).data;
        this.info.setCreator(this.getCreator(ctx, dateO));
    }

    private void doBizDirection() {
        BizTypeInfo bizType = this.info.getBizType();
        String bizNumber = bizType.getNumber();
        if (bizNumber.equals("311") || bizNumber.equals("371") || bizNumber.equals("381")) {
            this.info.setBizDirection(BizDirectionEnum.REVERSE);
        } else {
            this.info.setBizDirection(BizDirectionEnum.POSITIVE);
        }
    }

    private void doCurrency(Context ctx, Map lineData) throws BOSException, TaskExternalException, EASBizException {
        Object souData = ((DataToken)lineData.get((Object)"FCurrency_number")).data;
        CurrencyInfo currency = null;
        if (souData != null && souData.toString().trim().length() > 0) {
            String currencyNumber = souData.toString().trim();
            if (this.dataPool.getCurrencyInfo(currencyNumber) == null) {
                ICurrency icurrentcy = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyCollection cyrrencys = icurrentcy.getCurrencyCollection(this.getFilter(currencyNumber));
                if (cyrrencys != null && cyrrencys.size() > 0) {
                    currency = cyrrencys.get(0);
                    this.info.setCurrency(currency);
                    this.dataPool.setCurrencyInfo(currencyNumber, currency);
                }
            } else {
                currency = this.dataPool.getCurrencyInfo(currencyNumber);
                this.info.setCurrency(currency);
            }
        }
        CompanyOrgUnitInfo issueCompany = this.info.getIssueCompanyOrgUnit();
        if (currency == null && issueCompany != null && issueCompany.getBaseCurrency() != null) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(issueCompany.getBaseCurrency().getId()), this.getCurrencySelector());
            this.info.setCurrency(currencyInfo);
            this.info.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
        }
        if (this.info.getCurrency() != null) {
            this.cprecision = this.info.getCurrency().getPrecision();
        }
        if (issueCompany != null && issueCompany.getBaseCurrency() != null && this.info.getCurrency() != null) {
            if (this.dataPool.getExchangeRate(this.info.getCurrency().getId().toString() + issueCompany.getBaseCurrency().getId().toString()) == null) {
                ExchangeRateInfo exchangeRateInfo;
                BigDecimal exchangeRate = SCMConstant.BIGDECIMAL_ONE;
                CurrencyInfo localCurrencyInfo = issueCompany.getBaseCurrency();
                CurrencyInfo destCurrencyInfo = this.info.getCurrency();
                if (!localCurrencyInfo.getId().toString().equals(destCurrencyInfo.getId().toString()) && (exchangeRateInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)issueCompany, (IObjectPK)new ObjectUuidPK(destCurrencyInfo.getId()), (IObjectPK)new ObjectUuidPK(localCurrencyInfo.getId()))) != null) {
                    exchangeRate = exchangeRateInfo.getConvertRate();
                }
                this.info.setExchangeRate(exchangeRate);
                this.dataPool.setExchangeRate(destCurrencyInfo.getId().toString() + localCurrencyInfo.getId().toString(), exchangeRate);
            } else {
                this.info.setExchangeRate(this.dataPool.getExchangeRate(this.info.getCurrency().getId().toString() + issueCompany.getBaseCurrency().getId().toString()));
            }
        }
    }

    private SelectorItemCollection getCurrencySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    private void doInStorageOrgUnitAndCompany(Map lineData, Context ctx) throws TaskExternalException, BOSException {
        String bizTypeNumber = this.info.getBizType().getNumber();
        StorageOrgUnitInfo inStorage = null;
        String[] msg = new String[]{"INSTORAGE_NOT_NULL", "INSTORAGE_NOT_BIZUNIT", "INSTORAGE_NOT_EXIST"};
        try {
            inStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FReceiptStorageOrgUnit_number", msg);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        CompanyOrgUnitInfo inCompany = this.getCompanyOrgFromStorageOrg(ctx, inStorage);
        CompanyOrgUnitInfo issueCompany = this.info.getIssueCompanyOrgUnit();
        if (issueCompany != null && inCompany != null && inCompany.getId().toString().equals(issueCompany.getId().toString())) {
            throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"Company_IS_SAME", (String)resources));
        }
        this.info.setReceiptStorageOrgUnit(inStorage);
        this.info.setReceiptCompanyOrgUnit(inCompany);
    }

    private Date doDate(Context ctx, Map lineData, String fileName, Date defaultValue) throws TaskExternalException {
        Object dateO = ((DataToken)lineData.get((Object)fileName)).data;
        Date date = this.getDate(ctx, dateO);
        if (date == null) {
            date = defaultValue;
        }
        return date;
    }

    private void doBizTypeInfo(Context ctx, Map lineData) throws TaskExternalException {
        try {
            BizTypeCollection collection;
            Object souData = ((DataToken)lineData.get((Object)"FBizType_number")).data;
            if (souData != null && souData.toString().trim().length() > 0) {
                collection = InvCommonUtils.getBizTypeCollection(ctx, "Eg5BUQEVEADgAAABwKgOEEY+1VI=", this.getFilter(souData.toString().trim()));
                if (collection == null || collection.size() <= 0) {
                    String str = TransferOrderBillImport.getResource((Context)ctx, (String)"BIZTYPE_NOT_EXIST", (String)resources);
                    throw new TaskExternalException(str);
                }
            } else {
                String str = TransferOrderBillImport.getResource((Context)ctx, (String)"BIZTYPE_NOT_NULL", (String)resources);
                throw new TaskExternalException(str);
            }
            this.info.setBizType(collection.get(0));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doIssueStorageOrgUnit(Context ctx, Map lineData) throws TaskExternalException {
        try {
            String[] msg = new String[]{"ISSUESTORAGE_NOT_NULL", "ISSUESTORAGE_NOT_BIZUNIT", "ISSUESTORAGE_NOT_EXIST"};
            this.issueStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FIssueStorageOrgUnit_number", msg);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        this.info.setIssueStorageOrgUnit(this.issueStorage);
    }

    private StorageOrgUnitInfo getStorageOrgUnit(Map lineData, Context ctx, String byProperty, String propertyName, String[] msg) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)lineData.get((Object)propertyName)).data;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        storageOrgUnitInfo = this.getStorageOrgUnit(ctx, byProperty, souData, resources, msg);
        return storageOrgUnitInfo;
    }

    private TransferOrderBillEntryInfo transmitEntry(Map lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        TransferOrderBillEntryInfo entryInfo = new TransferOrderBillEntryInfo();
        this.doEntryMaterial(lineData, ctx, entryInfo);
        this.doEntryAssistProperty(lineData, ctx, entryInfo);
        this.doEntryLot(lineData, ctx, entryInfo);
        this.doEntryMfgExp(ctx, lineData, entryInfo);
        this.doEntryUnit(lineData, ctx, entryInfo);
        this.doEntryQty(lineData, ctx, entryInfo);
        this.doEntryBaseUnit(ctx, lineData, entryInfo);
        this.doEntryAssistUnit(ctx, entryInfo, lineData);
        this.doGiveStorage(ctx, entryInfo, lineData);
        entryInfo.setIssueCompanyOrgUnit(this.getCompanyOrgFromStorageOrg(ctx, entryInfo.getIssueStorageOrgUnit()));
        this.doIssueSaleOrgUnit(ctx, entryInfo, lineData);
        this.getWarehs(ctx, entryInfo, lineData, entryInfo.getIssueStorageOrgUnit());
        this.getLocation(ctx, entryInfo, lineData);
        this.doReciveStorage(ctx, entryInfo, lineData);
        entryInfo.setReceiveCompanyOrgUnit(this.getCompanyOrgFromStorageOrg(ctx, entryInfo.getReceiveStorageOrgUnit()));
        Object isPresent = ((DataToken)lineData.get((Object)"FEntry_isPresent")).data;
        entryInfo.setIsPresent(DataImportUtils.getBooleanValue((Object)isPresent, (boolean)false));
        this.doEntryAmountPriceField(ctx, entryInfo, lineData);
        this.doEntryDiscountType(ctx, entryInfo, lineData);
        this.doDiscountRate(ctx, entryInfo, lineData);
        entryInfo.setReceiptPlanDate(this.doDate(ctx, lineData, "FEntry_receiptPlanDate", this.info.getBizDate()));
        entryInfo.setIssuePlanDate(this.doDate(ctx, lineData, "FEntry_issuePlanDate", this.info.getBizDate()));
        this.doEntryProjectNum(ctx, lineData, entryInfo);
        this.doEntryTrackNum(ctx, lineData, entryInfo);
        Object data = ((DataToken)lineData.get((Object)"FEntry_notControlQty")).data;
        entryInfo.setNotControlQty(DataImportUtils.getBooleanValue((Object)data, (boolean)false));
        this.doQtyOverRate(ctx, lineData, entryInfo);
        this.doQtyLackRate(ctx, lineData, entryInfo);
        entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        Object remark = ((DataToken)lineData.get((Object)"FEntry_remark")).data;
        if (remark != null && !remark.toString().equals("")) {
            String remarkStr = remark.toString();
            if (remarkStr.length() > 255) {
                remarkStr = remarkStr.substring(0, 255);
            }
            entryInfo.setRemark(remarkStr);
        }
        this.doDataByBizDirection(entryInfo);
        this.checkQtyPrecision(ctx, entryInfo);
        return entryInfo;
    }

    private void doDataByBizDirection(TransferOrderBillEntryInfo entryInfo) {
        BigDecimal value = new BigDecimal("-1");
        if (this.info.getBizDirection() == BizDirectionEnum.REVERSE && !entryInfo.isIsPresent()) {
            String[] temp = new String[]{"discountAmount", "amount", "localAmount", "tax", "taxAmount", "localTax", "localTaxAmount", "qty"};
            for (int i = 0; i < temp.length; ++i) {
                entryInfo.put(temp[i], entryInfo.getBigDecimal(temp[i]).abs().multiply(value));
            }
        }
    }

    private void doQtyOverRate(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qtyOverRate")).data;
        BigDecimal qtyOverRate = SCMConstant.BIGDECIMAL_ZERO;
        if (data != null && data.toString().length() > 0) {
            try {
                qtyOverRate = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
            }
            catch (Exception e) {
                qtyOverRate = SCMConstant.BIGDECIMAL_ZERO;
            }
        }
        if (qtyOverRate.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
            throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"QtyOverRate_Not_nagtive", (String)resources));
        }
        entryInfo.setQtyOverRate(qtyOverRate);
    }

    private void doQtyLackRate(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qtyLackRate")).data;
        BigDecimal qtyLackRate = SCMConstant.BIGDECIMAL_ZERO;
        if (data != null && data.toString().length() > 0) {
            try {
                qtyLackRate = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
            }
            catch (Exception e) {
                qtyLackRate = SCMConstant.BIGDECIMAL_ZERO;
            }
        }
        this.checkRateValid(ctx, qtyLackRate, "qtyLackRate_not_valid");
        entryInfo.setQtyLackRate(qtyLackRate);
    }

    private void doEntryProjectNum(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FEntry$project_number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getMaterial() != null && this.issueStorage != null) {
            MaterialPlanInfo mpInfo = this.getMaterialPlan(ctx, entryInfo.getMaterial(), this.issueStorage, resources, null);
            ProjectInfo pro = this.getProject(ctx, data, this.issueStorage.getCU());
            if (mpInfo != null) {
                ManufactureStrategyInfo strategy = mpInfo.getManufactureStrategy();
                if (strategy == null || this.manufactureStrategy.contains(strategy.getNumber())) {
                    entryInfo.setProject(pro);
                }
            } else {
                entryInfo.setProject(pro);
            }
        }
    }

    private void doEntryTrackNum(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$trackNumber_number")).data;
        if (data != null && data.toString().length() > 0) {
            TrackNumberInfo info = null;
            info = this.getTrackNumber(ctx, data, this.issueStorage.getCU());
            entryInfo.setTrackNumber(info);
        }
    }

    private void doDiscountRate(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_discountRate")).data;
        BigDecimal discountRate = SCMConstant.BIGDECIMAL_ZERO;
        if (data != null && data.toString().length() > 0) {
            discountRate = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
        }
        this.checkRateValid(ctx, discountRate, "discountRate_not_valid");
        entryInfo.setDiscountRate(discountRate);
    }

    private void checkRateValid(Context ctx, BigDecimal val, String resCode) throws TaskExternalException {
        if (val.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0 || val.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
            throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)resCode, (String)resources));
        }
    }

    private void doEntryDiscountType(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) {
        Object data = ((DataToken)lineData.get((Object)"FEntry_discountType")).data;
        String value = null;
        if (data != null && (value = data.toString()) != null) {
            entryInfo.setDiscountType(this.getDiscountModeEnumValue(value));
        }
    }

    private DiscountModeEnum getDiscountModeEnumValue(String value) {
        DiscountModeEnum tSaved = DiscountModeEnum.PERCENT;
        if (value != null) {
            value = value.trim();
            List EnumList = DiscountModeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                DiscountModeEnum enumList = (DiscountModeEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private void doEntryAmountPriceField(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        BigDecimal value = null;
        for (int i = 0; i < BIGDECIMAL_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)TransferOrderBillImport.BIGDECIMAL_FIELDS[i])).data;
            if (o.toString().trim().length() == 0) {
                o = SCMConstant.BIGDECIMAL_ZERO;
            }
            value = DataImportUtils.getDataDeciaml((Context)ctx, (String)o.toString());
            if ((BIGDECIMAL_FIELDS[i].equals("FEntry_price") || BIGDECIMAL_FIELDS[i].equals("FEntry_taxPrice")) && value.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"price_Not_negtive", (String)resources));
            }
            if (BIGDECIMAL_FIELDS[i].equals("FEntry_taxRate")) {
                if (value.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                    throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"taxRate_Not_negtive", (String)resources));
                }
                if (value.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
                    throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"taxRate_Not_ONEHUNDRED", (String)resources));
                }
            }
            if (entryInfo.isIsPresent() && !BIGDECIMAL_OBJ_EN[i].equals("taxRate")) continue;
            entryInfo.put(BIGDECIMAL_OBJ_EN[i], value.abs());
        }
        BigDecimal amt = entryInfo.getAmount() == null ? SCMConstant.BIGDECIMAL_ZERO : entryInfo.getAmount();
        BigDecimal tax = entryInfo.getTax() == null ? SCMConstant.BIGDECIMAL_ZERO : entryInfo.getTax();
        BigDecimal taxAmt = entryInfo.getTaxAmount() == null ? SCMConstant.BIGDECIMAL_ZERO : entryInfo.getTaxAmount();
        BigDecimal taxAmountResult = amt.add(tax).setScale(this.cprecision, RoundingMode.HALF_UP);
        if (taxAmountResult.compareTo(taxAmt) != 0) {
            throw new TaskExternalException(TransferOrderBillImport.getResource((Context)ctx, (String)"invalidData", (String)resources));
        }
    }

    private void doReciveStorage(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        StorageOrgUnitInfo reciveStorage = null;
        try {
            String[] msg = new String[]{"RECPSTORAGE_NOT_NULL", "RECPSTORAGE_NOT_BIZUNIT", "RECPSTORAGE_NOT_EXIST"};
            reciveStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FEntry$receiveStorageOrgUnit_number", msg);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        entryInfo.setReceiveStorageOrgUnit(reciveStorage);
    }

    private void getLocation(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws BOSException, TaskExternalException {
        Object issueLocationObj = ((DataToken)lineData.get((Object)"FEntry$issueLocation_number")).data;
        Object recLocationObj = ((DataToken)lineData.get((Object)"FEntry$receiptLocation_number")).data;
        LocationInfo issueLocation = this.getLocation(ctx, "number", issueLocationObj, entryInfo.getIssueWarehouse(), resources, "LOCATION_NOT_ENABLE", "LOCATION_NOT_FIND", "LOCATION_NOT_NULL", null);
        entryInfo.setIssueLocation(issueLocation);
        LocationInfo receiptLocation = this.getLocation(ctx, "number", recLocationObj, entryInfo.getReceiptWarehouse(), resources, "LOCATION_NOT_ENABLE", "LOCATION_NOT_FIND", null, null);
        entryInfo.setReceiptLocation(receiptLocation);
    }

    private void getWarehs(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, TaskExternalException, EASBizException {
        if (storageOrgUnitInfo != null) {
            Object issueWarehsObj = ((DataToken)lineData.get((Object)"FEntry$issueWarehouse_number")).data;
            Object recWarehsObj = ((DataToken)lineData.get((Object)"FEntry$receiptWarehouse_number")).data;
            Object suppWarehsObj = ((DataToken)lineData.get((Object)"FEntry$supplyWarehouse_number")).data;
            Object reqWarehsObj = ((DataToken)lineData.get((Object)"FEntry$requireWarehouse_number")).data;
            WarehouseInfo issueWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)storageOrgUnitInfo, issueWarehsObj, resources, "GievWarehouseNotExistOrInvalid", "GievWarehouseNotExistOrInvalid", null, null);
            entryInfo.setIssueWarehouse(issueWarehouse);
            WarehouseInfo receiptWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)storageOrgUnitInfo, recWarehsObj, resources, "RecWarehouseNotExistOrInvalid", "RecWarehouseNotExistOrInvalid", null, null);
            entryInfo.setReceiptWarehouse(receiptWarehouse);
            WarehouseInfo supplyWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)storageOrgUnitInfo, suppWarehsObj, resources, "suppWarehsNotEnable", "suppWarehsNotExist", null, null);
            entryInfo.setSupplyWarehouse(supplyWarehouse);
            WarehouseInfo requireWarehouse = this.getWarehouse(ctx, "number", (OrgUnitInfo)storageOrgUnitInfo, reqWarehsObj, resources, "reqWarehsNotEnable", "reqWarehsNotExist", null, null);
            entryInfo.setRequireWarehouse(requireWarehouse);
        }
    }

    private void doIssueSaleOrgUnit(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws EASBizException, BOSException {
        String reqSouId;
        String supplySouId;
        TransferRuleInfo ruleInfo = null;
        SaleOrgUnitInfo sale = null;
        SCMFetchData fetchData = new SCMFetchData();
        String bizTypeId = this.info.getBizType().getId().toString();
        ruleInfo = fetchData.getTransferRule(bizTypeId, supplySouId = this.issueStorage.getId().toString(), reqSouId = this.info.getReceiptStorageOrgUnit().getId().toString(), ctx);
        sale = ruleInfo == null || ruleInfo.getId() == null ? this.getSaleOrgUnitInfo(entryInfo.getIssueStorageOrgUnit().getId().toString(), ctx) : ruleInfo.getIssueSaleOrgUnit();
        entryInfo.setIssueSaleOrgUnit(sale);
    }

    private SaleOrgUnitInfo getSaleOrgUnitInfo(String storageId, Context ctx) throws BOSException {
        SaleOrgUnitInfo sale = this.dataPool.getSaleOrgUnit(storageId);
        if (sale == null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selectors = new SelectorItemCollection();
            filter.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)storageId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("typeRelation.id", (Object)"00000000-0000-0000-0000-0000000000090FE9F8B5"));
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer("1")));
            view.setFilter(filter);
            selectors.add(new SelectorItemInfo("toUnit.id"));
            selectors.add(new SelectorItemInfo("id"));
            view.setSelector(selectors);
            CoreBaseCollection orgCol = iUnitRel.getCollection(view);
            if (orgCol != null && orgCol.size() > 0) {
                FullOrgUnitInfo fullOrg = ((OrgUnitRelationInfo)orgCol.get(0)).getToUnit();
                sale = new SaleOrgUnitInfo();
                sale.setId(fullOrg.getId());
                this.dataPool.setSaleOrgUnit(storageId, sale);
            }
        }
        return sale;
    }

    private void doGiveStorage(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws TaskExternalException {
        StorageOrgUnitInfo giveStorage = null;
        try {
            String[] msg = new String[]{"GIVESTORAGE_NOT_NULL", "GIVESTORAGE_NOT_BIZUNIT", "GIVESTORAGE_NOT_EXIST"};
            giveStorage = this.getStorageOrgUnit(lineData, ctx, "number", "FEntry$issueStorageOrgUnit_number", msg);
        }
        catch (Exception e_number) {
            throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
        }
        entryInfo.setIssueStorageOrgUnit(giveStorage);
    }

    private void doEntryAssistUnit(Context ctx, TransferOrderBillEntryInfo entryInfo, Map lineData) throws TaskExternalException, EASBizException, BOSException {
        entryInfo.setAssistUnit(entryInfo.getMaterial().getAssistUnit());
        if (entryInfo.getAssistUnit() != null) {
            Object cellData = ((DataToken)lineData.get((Object)"FEntry_assistQty")).data;
            BigDecimal assistQty = DataImportUtils.getDataDeciaml((Context)ctx, (String)cellData.toString());
            if (assistQty.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                throw new TaskExternalException(assistQty.toString() + TransferOrderBillImport.getResource((Context)ctx, (String)"assistQty_nagtive", (String)resources));
            }
            if (!this.isVaildDigDecimal(assistQty)) {
                throw new TaskExternalException(assistQty.toString() + TransferOrderBillImport.getResource((Context)ctx, (String)"QTY_TOO_LONG", (String)resources));
            }
            entryInfo.setAssistQty(assistQty);
        } else {
            entryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryBaseUnit(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws BOSException, EASBizException {
        if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getBaseUnit() != null) {
            entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
            if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                entryInfo.setBaseQty(baseUnitQty);
            }
        }
    }

    private boolean isVaildDigDecimal(BigDecimal data) {
        return MAXVAL.compareTo(data.abs()) >= 1;
    }

    private void doEntryQty(Map lineData, Context ctx, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_qty")).data;
        BigDecimal qty = null;
        if (data != null && data.toString().length() > 0) {
            qty = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString());
            if (qty.compareTo(SCMConstant.BIGDECIMAL_ZERO) < 0) {
                throw new TaskExternalException(qty.toString() + TransferOrderBillImport.getResource((Context)ctx, (String)"qty_nagtive", (String)resources));
            }
            if (!this.isVaildDigDecimal(qty)) {
                throw new TaskExternalException(qty.toString() + TransferOrderBillImport.getResource((Context)ctx, (String)"QTY_TOO_LONG", (String)resources));
            }
        } else {
            String str = TransferOrderBillImport.getResource((Context)ctx, (String)"QTY_NOT_NULL", (String)resources);
            throw new TaskExternalException(str);
        }
        entryInfo.setQty(qty);
    }

    private void doEntryUnit(Map lineData, Context ctx, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        Object data = ((DataToken)lineData.get((Object)"FEntry$unit_number")).data;
        MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, data, entryInfo.getMaterial());
        entryInfo.setUnit(measureUnitInfo);
    }

    private void doEntryMfgExp(Context ctx, Map lineData, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        Object mfg = ((DataToken)lineData.get((Object)"FEntry_mfg")).data;
        Object exp = ((DataToken)lineData.get((Object)"FEntry_exp")).data;
        Date[] date = this.getMfgAndExp(ctx, entryInfo.getMaterial(), entryInfo.getLot(), this.issueStorage, mfg, exp, false);
        if (date != null) {
            entryInfo.setMfg(date[0]);
            entryInfo.setExp(date[1]);
        }
    }

    private void doEntryLot(Map lineData, Context ctx, TransferOrderBillEntryInfo entryInfo) throws BOSException, EASBizException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntry_lot")).data;
        if (this.checkLotInfo(ctx, entryInfo.getMaterial(), this.issueStorage)) {
            if (data != null && data.toString().trim().length() > 0) {
                entryInfo.setLot(data.toString().trim());
            }
        } else {
            entryInfo.setLot(null);
        }
    }

    private void doEntryAssistProperty(Map lineData, Context ctx, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException {
        if (entryInfo.getMaterial().getAssistAttr() == null) {
            return;
        }
        Object data = ((DataToken)lineData.get((Object)"FEntry$assistProperty_number")).data;
        AsstAttrValueInfo info = this.getAsstAttr(ctx, data, entryInfo.getMaterial().getAssistAttr());
        entryInfo.setAssistProperty(info);
    }

    private void doEntryMaterial(Map lineData, Context ctx, TransferOrderBillEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        Object materialNumber = ((DataToken)lineData.get((Object)"FEntry$material_number")).data;
        MaterialInfo materialInfo = this.getMaterial(ctx, materialNumber, resources, "MATERIAL_NOT_FIND", "MATERIAL_NOT_NULL", new OrgUnitInfo[]{this.issueStorage, this.info.getIssueCompanyOrgUnit()});
        if (materialInfo != null) {
            entryInfo.setMaterial(materialInfo);
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.TransferOrderBillQuery";
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FIssueStorageOrgUnit_number", rs.getString("moveOutStorageOrgUnit.number"));
            this.putTable(result, "FReceiptStorageOrgUnit_number", rs.getString("moveInStorageOrgUnit.number"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FIsInTax", rs.getString("isInTax"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FEntry$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntry$material_name_l2", rs.getString("material.name"));
            this.putTable(result, "FEntry$material_model", rs.getString("material.model"));
            this.putTable(result, "FEntry$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntry_lot", rs.getString("entry.lot"));
            this.putTable(result, "FEntry_mfg", rs.getString("entry.mfg"));
            this.putTable(result, "FEntry_exp", rs.getString("entry.exp"));
            this.putTable(result, "FEntry$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntry_qty", rs.getBigDecimal("entry.qty"));
            this.putTable(result, "FEntry_assistQty", rs.getBigDecimal("entry.assistQty"));
            this.putTable(result, "FEntry$issueStorageOrgUnit_number", rs.getString("issueStorageOrgUnitE.number"));
            this.putTable(result, "FEntry$issueWarehouse_number", rs.getString("moveOutWarehouse.number"));
            this.putTable(result, "FEntry$issueLocation_number", rs.getString("issueLocation.number"));
            this.putTable(result, "FEntry$receiveStorageOrgUnit_number", rs.getString("receiveStorageOrgUnit.number"));
            this.putTable(result, "FEntry$receiptWarehouse_number", rs.getString("moveInWarehouse.number"));
            this.putTable(result, "FEntry$receiptLocation_number", rs.getString("receiptLocation.number"));
            this.putTable(result, "FEntry$supplyWarehouse_number", rs.getString("supplyWarehouse.number"));
            this.putTable(result, "FEntry$requireWarehouse_number", rs.getString("requireWarehouse.number"));
            this.putTable(result, "FEntry_isPresent", rs.getString("entry.isPresent"));
            this.putTable(result, "FEntry_price", rs.getBigDecimal("entry.price"));
            this.putTable(result, "FEntry_discountType", rs.getString("entry.discountType"));
            this.putTable(result, "FEntry_discountRate", rs.getBigDecimal("entry.discountRate"));
            this.putTable(result, "FEntry_taxRate", rs.getBigDecimal("entry.taxRate"));
            this.putTable(result, "FEntry_actualPrice", rs.getBigDecimal("entry.actualPrice"));
            this.putTable(result, "FEntry_taxPrice", rs.getBigDecimal("entry.taxPrice"));
            this.putTable(result, "FEntry_actualTaxPrice", rs.getBigDecimal("entry.actualTaxPrice"));
            this.putTable(result, "FEntry_discountAmount", rs.getBigDecimal("entry.discountAmount"));
            this.putTable(result, "FEntry_amount", rs.getBigDecimal("entry.amount"));
            this.putTable(result, "FEntry_localAmount", rs.getBigDecimal("entry.localAmount"));
            this.putTable(result, "FEntry_tax", rs.getBigDecimal("entry.tax"));
            this.putTable(result, "FEntry_taxAmount", rs.getBigDecimal("entry.taxAmount"));
            this.putTable(result, "FEntry_localTax", rs.getBigDecimal("entry.localTax"));
            this.putTable(result, "FEntry_localTaxAmount", rs.getBigDecimal("entry.localTaxAmount"));
            this.putTable(result, "FEntry_receiptPlanDate", rs.getString("entry.receiptPlanDate"));
            this.putTable(result, "FEntry_issuePlanDate", rs.getString("entry.issuePlanDate"));
            this.putTable(result, "FEntry$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntry$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FEntry_notControlQty", rs.getString("entry.notControlQty"));
            this.putTable(result, "FEntry_qtyOverRate", rs.getString("entry.qtyOverRate"));
            this.putTable(result, "FEntry_qtyLackRate", rs.getString("entry.qtyLackRate"));
            this.putTable(result, "FEntry_remark", rs.getString("entry.remark"));
            this.putTable(result, "FCreator_number", rs.getString("Creator.number"));
            this.putTable(result, "FCreateTime", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("createTime")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = InvServerUtils.getAuthOrgByPermItem(ctx, OrgType.Storage, "transferorder_export");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("moveOutStorageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        if (oldFilterInfo == null) {
            if (StringUtils.isEmpty((CharSequence)filterItems)) {
                oldFilterInfo = new FilterInfo();
            } else {
                try {
                    oldFilterInfo = new FilterInfo(filterItems);
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
            }
        }
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return oldFilterInfo;
    }

    private void checkQtyPrecision(Context ctx, TransferOrderBillEntryInfo entryInfo) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiAssistUnitInfo;
        int nowPrecision;
        MultiMeasureUnitInfo multiUnitInfo;
        MaterialInfo materialInfo = entryInfo.getMaterial();
        MeasureUnitInfo unitInfo = entryInfo.getUnit();
        MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
        MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
        if (materialInfo == null || unitInfo == null) {
            return;
        }
        if (this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString()) == null) {
            HashSet<String> materialIdSet = new HashSet<String>();
            HashSet<String> unitIdSet = new HashSet<String>();
            if (materialInfo != null) {
                materialIdSet.add(materialInfo.getId().toString());
            }
            if (unitInfo != null) {
                unitIdSet.add(unitInfo.getId().toString());
            }
            if (baseUnitInfo != null) {
                unitIdSet.add(baseUnitInfo.getId().toString());
            }
            if (assistUnitInfo != null) {
                unitIdSet.add(assistUnitInfo.getId().toString());
            }
            if (materialIdSet.size() > 0 && unitIdSet.size() > 0) {
                Map<String, MultiMeasureUnitInfo> multiUnitMap = InvServerUtils.getMultiMeasureUnitMap(ctx, materialIdSet, unitIdSet);
                this.dataPool.putMultiMeasureUnitMap(multiUnitMap);
            }
        }
        if (unitInfo != null && (multiUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + unitInfo.getId().toString())) != null) {
            int qtyPrecision = multiUnitInfo.getQtyPrecision();
            BigDecimal qty = entryInfo.getQty();
            if (qty != null && qtyPrecision < (nowPrecision = qty.scale())) {
                throw new InvImportException(InvImportException.QTY_PRECISION_INVALID, new String[]{materialInfo.getName(), unitInfo.getName(), qtyPrecision + ""});
            }
        }
        if (assistUnitInfo != null && (multiAssistUnitInfo = this.dataPool.getMultiMeasureUnitInfo(materialInfo.getId().toString() + assistUnitInfo.getId().toString())) != null) {
            int assistQtyPrecision = multiAssistUnitInfo.getQtyPrecision();
            BigDecimal assistQty = entryInfo.getAssistQty();
            if (assistQty != null && assistQtyPrecision < (nowPrecision = assistQty.scale())) {
                throw new InvImportException(InvImportException.ASSISTQTY_PRECISION_INVALID, new String[]{materialInfo.getName(), assistQtyPrecision + ""});
            }
        }
    }

    public void afterBuildEntry(Context ctx, SCMBillBaseInfo info, SCMBillEntryBaseInfo entry, Map lineData) throws TaskExternalException {
        super.afterBuildEntry(ctx, info, entry, lineData);
        this.checkEntryValue(ctx, (TransferOrderBillEntryInfo)entry);
    }

    private void checkEntryValue(Context ctx, TransferOrderBillEntryInfo entry) throws TaskExternalException {
        BigDecimal tax = this.setNullToZero(entry.getTax());
        BigDecimal amount = this.setNullToZero(entry.getAmount());
        BigDecimal taxAmount = this.setNullToZero(entry.getTaxAmount());
        if (tax.add(amount).compareTo(taxAmount) != 0) {
            String str = TransferOrderBillImport.getResources((Context)ctx, (String)"TAXAMOUNT_NOTEQUALS_OTHERAMOUNT", (String)"com.kingdee.eas.scm.im.inv.app.PurInImportResource");
            throw new TaskExternalException(str);
        }
    }

    protected String[] getPriceFields() {
        return this.priceFields;
    }

    protected String[] getAmountFields() {
        return this.amountFields;
    }

    protected String[] getLocalAmountFields() {
        return this.localAmountFields;
    }

    protected String getDiscountField() {
        return "discountRate";
    }

    protected String getTaxRateField() {
        return "taxRate";
    }

    public String getImportPermissionItem() {
        return "transferorder_new";
    }
}

