/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.StockTypeEnum;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractTransferOrderWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.SupplyRelationServerUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TransferOrderWebFacadeControllerBean
extends AbstractTransferOrderWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.TransferOrderWebFacadeControllerBean");
    private Map authOrgMap = new HashMap();
    private String permItemNew = "transferorder_new";
    private Map couMap = new HashMap();
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public String getMainOrgUnitName() {
        return "issueStorageOrgUnit";
    }

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return TransferOrderBillFactory.getLocalInstance(context);
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        return this.createNewData(context, model, null);
    }

    public IObjectValue createNewData(Context context, IObjectValue model, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        TransferOrderBillInfo info = (TransferOrderBillInfo)model;
        if (info == null) {
            info = new TransferOrderBillInfo();
        }
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"Eg5BUQEVEADgAAABwKgOEEY+1VI="));
        info.setBillType(billType);
        info.setIsShipment(true);
        info.setIsInTax(true);
        if (sou == null) {
            StorageOrgUnitInfo supplySouInfo = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(context);
            info.setIssueStorageOrgUnit(supplySouInfo);
        } else {
            info.setIssueStorageOrgUnit(sou);
        }
        info.setCU(info.getIssueStorageOrgUnit().getCU());
        info = TransferOrderBillFactory.getRemoteInstance().createNewData(info);
        if (info.getIssueCompanyOrgUnit() == null) {
            return info;
        }
        info.setExchangeRate(new BigDecimal("1.00"));
        info.setBizDirection(BizDirectionEnum.POSITIVE);
        UserInfo user = UserFactory.getLocalInstance((Context)context).getUserInfo(context.getCaller());
        info.setCreator(user);
        if (info.getEntry() != null) {
            TransferOrderBillEntryInfo entry = null;
            Object issueSale = null;
            for (int i = 0; i < 5; ++i) {
                entry = (TransferOrderBillEntryInfo)this.createNewDetailData(context, model);
                info.getEntry().add(entry);
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException, EASBizException {
        TransferOrderBillEntryInfo entry = new TransferOrderBillEntryInfo();
        entry.setReason("");
        entry.setAssociateQty(ZERO);
        entry.setSupplyType(StockTypeEnum.Null);
        entry.setIssueQty(ZERO);
        entry.setReceiptQty(ZERO);
        entry.setBaseQty(ZERO);
        entry.setReceiptPlanDate(new Date());
        entry.setIssuePlanDate(new Date());
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setDiscountType(DiscountModeEnum.PERCENT);
        entry.setDiscountRate(ZERO);
        entry.setNotControlQty(true);
        entry.setQtyOverRate(ZERO);
        entry.setQtyLackRate(ZERO);
        entry.setPlanDeliveryQty(ZERO);
        entry.setTotalPurReturnBaseQty(ZERO);
        entry.setTotalPurReturnQty(ZERO);
        entry.setTotalSaleReturnBaseQty(ZERO);
        entry.setTotalSaleReturnQty(ZERO);
        entry.setIsMrpCal(true);
        entry.setTotalPurReturnBaseQty(ZERO);
        entry.setTotalPurReturnQty(ZERO);
        entry.setTotalSaleReturnBaseQty(ZERO);
        entry.setTotalSaleReturnQty(ZERO);
        entry.setIsPresent(false);
        return entry;
    }

    public String getPermissionItem() {
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "transferorder_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "transferorder_view";
        }
        return "transferorder_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public void initData(Context context, Map initData, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, initData, model);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)model.get(this.getMainOrgUnitName());
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)model.get("issueCompanyOrgUnit");
        if (sou == null || cou == null) {
            return;
        }
        String issueCompanyFilter = null;
        EntityViewInfo couViewInfo = SCMBillCommonFacadeFactory.getRemoteInstance().getAuthCompanyView((IObjectPK)new ObjectUuidPK(context.getCaller().toString()), this.getMainOrgType(), this.getPermissionItem());
        issueCompanyFilter = couViewInfo.getFilter().toString();
        ExchangeRateCollection exRateColl = (ExchangeRateCollection)this.getExchangeRateCollByCou(context, cou.getId().toString());
        ICurrency ic = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        OrgUnitCollection saleOrgCol = OrgUtils.getToOrgUnitColl((Context)context, (String)sou.getId().toString(), (OrgType)OrgType.Storage, (OrgType)OrgType.Sale);
        initData.put("issueSale", saleOrgCol.get(0));
        initData.put("baseCurrency", currency);
        initData.put("exchangeRateCol", exRateColl);
        initData.put("issueCompanyFilter", issueCompanyFilter);
        initData.put("params", this.getParamsMap(context));
        initData.put("orgParams", this.getOrgParamsMap(context, sou.getId().toString(), cou.getId().toString()));
    }

    private Map getParamsMap(Context ctx) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map noOrgParamMap = this.batchGetParamValue(ctx, null, new String[]{"DISCOUNTRATEPRECISION"});
        paramMap.putAll(noOrgParamMap);
        return paramMap;
    }

    private Map getOrgParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM008", "INM007", "INM110"});
        String paramName = null;
        for (Object key : souParamMap.keySet()) {
            paramName = (String)key;
            paramMap.put(souId + paramName, souParamMap.get(key));
        }
        return paramMap;
    }

    private Map dealMainCouChange(Context ctx, Map params) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String orgId = (String)params.get("orgId");
        OrgUnitCollection orgCol = OrgUtils.getFromOrgUnitColl((Context)ctx, (String)orgId, (OrgType)OrgType.Company, (OrgType)OrgType.Storage);
        String filter = " id in " + OrgUtils.getOrgFilterStr((Context)ctx, (OrgUnitCollection)orgCol);
        ICompanyOrgUnit icou = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo cou = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        ICurrency ic = CurrencyFactory.getRemoteInstance();
        CurrencyInfo currency = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId()));
        ExchangeRateCollection exRateColl = (ExchangeRateCollection)this.getExchangeRateCollByCou(ctx, orgId);
        map.put("sou_filter", filter);
        map.put("currency", (String)currency);
        map.put("exchangeRateCol", (String)exRateColl);
        return map;
    }

    @Override
    protected Map _handlDataChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        String dataName = null;
        dataName = (String)requestMap.get("dataName");
        if (StringUtils.isEmpty((CharSequence)dataName)) {
            return null;
        }
        if (dataName.equals("issueCompanyOrgUnit")) {
            return this.dealMainCouChange(ctx, requestMap);
        }
        if (dataName.equals("issueStorageOrgUnit")) {
            return this.dealMainOrgChange(ctx, requestMap);
        }
        if (dataName.equals("receiptStorageOrgUnit")) {
            return this.dealReciptSouChange(ctx, requestMap);
        }
        if (dataName.equals("bizType")) {
            return this.dealBizTypeChange(ctx, requestMap);
        }
        return null;
    }

    private Map dealBizTypeChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String bizTypeId = (String)requestMap.get("bizTypeId");
        String supplySouId = (String)requestMap.get("supplySouId");
        String reqSouId = (String)requestMap.get("reqSouId");
        String supplyCouId = (String)requestMap.get("supplyCouId");
        String reqCouId = (String)requestMap.get("reqCouId");
        List entryOrgs = (List)requestMap.get("entryOrgs");
        String sourceBillTypeId = (String)requestMap.get("sourceBillTypeId");
        int size = entryOrgs.size();
        if (size == 0) {
            map.put("canChange", true);
            return map;
        }
        String[] issueSouIds = new String[size];
        String[] recSouIds = new String[size];
        String[] issueCouIds = new String[size];
        String[] recCouIds = new String[size];
        String[] materialIds = new String[size];
        LinkedTreeMap treeMap = null;
        for (int i = 0; i < size; ++i) {
            treeMap = (LinkedTreeMap)entryOrgs.get(i);
            issueSouIds[i] = (String)treeMap.get((Object)"issueSouId");
            recSouIds[i] = (String)treeMap.get((Object)"recSouId");
            issueCouIds[i] = (String)treeMap.get((Object)"issueCouId");
            recCouIds[i] = (String)treeMap.get((Object)"recCouId");
            materialIds[i] = (String)treeMap.get((Object)"materialId");
        }
        HashMap mapTransferRule = new HashMap();
        TransferRuleInfo[] trInfos = new TransferRuleInfo[entryOrgs.size()];
        String param = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(supplySouId), "INM007");
        String bizString = "";
        StringBuffer warningString = new StringBuffer();
        String RESOURCE_MAutoGenerateResource = "com.kingdee.eas.scm.im.IMAutoGenerateResource";
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            bizString = EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"62_TransferOrderBillEditUI");
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            bizString = EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"63_TransferOrderBillEditUI");
        } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            bizString = EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"64_TransferOrderBillEditUI");
        }
        String tempBizTypeId = this.getTempBizTypeId(bizTypeId);
        boolean isBotpBill = false;
        if (sourceBillTypeId != null && sourceBillTypeId.equals("MmEE6VBsR0KaUDQmebwhP0Y+1VI=")) {
            isBotpBill = true;
        }
        if (isBotpBill && param.equals("true")) {
            this.initTransferRuleByBotpBill(ctx, mapTransferRule, tempBizTypeId, supplySouId, reqSouId, recSouIds);
        } else {
            this.initTransferRule(ctx, mapTransferRule, tempBizTypeId, supplySouId, reqSouId, issueSouIds, recSouIds);
        }
        if (param.equals("true")) {
            TransferRuleInfo trInfo = null;
            for (int i = 0; i < size; ++i) {
                trInfo = isBotpBill ? this.getTransferRuleByBotpBill(mapTransferRule, tempBizTypeId, supplySouId, reqSouId, recSouIds[i]) : this.getTransferRule(mapTransferRule, tempBizTypeId, supplySouId, reqSouId, issueSouIds[i], recSouIds[i]);
                if (trInfo == null) {
                    if (StringUtils.isEmpty((CharSequence)issueSouIds[i]) && StringUtils.isEmpty((CharSequence)recSouIds[i])) continue;
                    if (!StringUtils.isEmpty((CharSequence)issueSouIds[i]) || !StringUtils.isEmpty((CharSequence)recSouIds[i])) {
                        warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"66_TransferOrderBillEditUI_1") + (i + 1) + EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"66_TransferOrderBillEditUI"));
                        if (!StringUtils.isEmpty((CharSequence)issueSouIds[i])) {
                            warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"67_TransferOrderBillEditUI"));
                        }
                        if (!StringUtils.isEmpty((CharSequence)recSouIds[i])) {
                            if (!StringUtils.isEmpty((CharSequence)issueSouIds[i])) {
                                warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"66_TransferOrderBillEditUI_he"));
                            }
                            warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"68_TransferOrderBillEditUI"));
                        }
                        warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"66_TransferOrderBillEditUI_yu"));
                    }
                    warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"69_TransferOrderBillEditUI"));
                    if (!StringUtils.isEmpty((CharSequence)reqSouId)) {
                        warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"70_TransferOrderBillEditUI"));
                    }
                    warningString.append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"71_TransferOrderBillEditUI")).append(bizString).append(EASResource.getString((String)RESOURCE_MAutoGenerateResource, (String)"72_TransferOrderBillEditUI")).append(bizString);
                    map.put("warningString", warningString);
                    map.put("canChange", false);
                    map.put("INM007", param);
                    return map;
                }
                trInfos[i] = trInfo;
            }
        } else if (param.equals("false")) {
            String RESOURCE_SCM_IM = "com.kingdee.eas.scm.im.SCM_IMResource";
            for (int i = 0; i < size; ++i) {
                if (StringUtils.isEmpty((CharSequence)materialIds[i])) continue;
                if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                    if (supplyCouId.equals(issueCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER3SIDES_deliver", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                    if (supplyCouId.equals(recCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER3SIDES_rec", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                } else if ("ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
                    if (supplyCouId.equals(issueCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER3SIDES_deliver", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                    if (supplyCouId.equals(recCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER3SIDES_rec", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                    if (supplyCouId.equals(issueCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER4SIDES_deliver", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                    if (reqCouId.equals(recCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER4SIDES_rec", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                } else if ("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
                    if (supplyCouId.equals(issueCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER4SIDES_deliver", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                    if (reqCouId.equals(recCouIds[i])) {
                        warningString.append(ResourceUtils.getMessageInOrder((String)RESOURCE_SCM_IM, (String)"CannotTRANSFER4SIDES_rec", (String[])new String[]{BigDecimal.valueOf(i + 1).toString()}));
                        break;
                    }
                }
                trInfos[i] = this.getTransferRule(mapTransferRule, tempBizTypeId, supplySouId, reqSouId, issueSouIds[i], recSouIds[i]);
            }
            if (!StringUtils.isEmpty((CharSequence)warningString.toString())) {
                map.put("warningString", warningString);
                map.put("canChange", false);
                map.put("INM007", param);
                return map;
            }
        }
        map.put("canChange", true);
        map.put("trInfos", trInfos);
        return map;
    }

    private Map dealMainOrgChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String issueStroageId = (String)requestMap.get("orgId");
        String bizTypeId = (String)requestMap.get("bizTypeId");
        StorageOrgUnitInfo issueStorageInfo = new StorageOrgUnitInfo();
        issueStorageInfo.setId(BOSUuid.read((String)issueStroageId));
        TransferOrderBillInfo info = new TransferOrderBillInfo();
        info.setIssueStorageOrgUnit(issueStorageInfo);
        this.createNewData(ctx, (IObjectValue)info, issueStorageInfo);
        map.put("newModel", info);
        OrgUnitCollection saleOrgCol = OrgUtils.getToOrgUnitColl((Context)ctx, (String)info.getIssueStorageOrgUnit().getId().toString(), (OrgType)OrgType.Storage, (OrgType)OrgType.Sale);
        map.put("issueSale", saleOrgCol.get(0));
        CompanyOrgUnitInfo issueCompany = info.getIssueCompanyOrgUnit();
        Map params = this.getParamsMap(ctx);
        map.put("params", params);
        Map orgParams = this.getOrgParamsMap(ctx, issueStroageId, issueCompany.getId().toString());
        map.put("orgParams", orgParams);
        this.initData(ctx, map, (IObjectValue)info);
        return map;
    }

    private Map dealReciptSouChange(Context ctx, Map requestMap) throws BOSException, EASBizException {
        IOrgUnitRelation iUnitRel;
        String inm007;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String supplySouId = (String)requestMap.get("issueSouId");
        String supplyCouId = (String)requestMap.get("issueCouId");
        String bizTypeId = (String)requestMap.get("bizTypeId");
        String reqSouId = (String)requestMap.get("orgId");
        if (StringUtils.isEmpty((CharSequence)supplySouId) || StringUtils.isEmpty((CharSequence)supplyCouId) || StringUtils.isEmpty((CharSequence)bizTypeId) || StringUtils.isEmpty((CharSequence)reqSouId)) {
            return map;
        }
        StorageOrgUnitInfo reqSouInfo = new StorageOrgUnitInfo();
        reqSouInfo.setId(BOSUuid.read((String)reqSouId));
        CompanyOrgUnitInfo reqCompanyInfo = OrgUnitUtil.getCompanyFromStorage(null, (StorageOrgUnitInfo)reqSouInfo);
        map.put("reqCou", reqCompanyInfo);
        SaleOrgUnitInfo reqSale = OrgUnitUtil.getSaleOrgFromStorage((Context)ctx, (StorageOrgUnitInfo)reqSouInfo);
        map.put("reqSale", reqSale);
        StorageOrgUnitInfo entryIssueSou = null;
        StorageOrgUnitInfo entryRecSou = null;
        CompanyOrgUnitInfo entryIssueCou = null;
        CompanyOrgUnitInfo entryRecCou = null;
        SaleOrgUnitInfo entryIssueSale = null;
        SaleOrgUnitInfo entrySupplySale = null;
        SaleOrgUnitInfo entryReqSale = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplyRelation.requireStorageOrgUnit", (Object)reqSouId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("supplyRelation.issueStorageOrgUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("supplyRelation.receiveCompanyOrgUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("supplyRelation.receiveStorageOrgUnit.*"));
        evi.getSelector().add(new SelectorItemInfo("issueSaleOrgUnit.*"));
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
            evi.getSelector().add(new SelectorItemInfo("supplySaleOrgUnit.*"));
            filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)"LyS5ouN3YEPgQAB/AQBJsCQHQ1w=", CompareType.EQUALS));
        } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
            evi.getSelector().add(new SelectorItemInfo("supplySaleOrgUnit.*"));
            evi.getSelector().add(new SelectorItemInfo("requireSaleOrgUnit.*"));
            filter.getFilterItems().add(new FilterItemInfo("bizType", (Object)"LyS5ouN4YEPgQAB/AQBJsCQHQ1w=", CompareType.EQUALS));
        }
        evi.setFilter(filter);
        TransferRuleCollection trc = SupplyRelationServerUtils.getTransferRuleByType(ctx, bizTypeId).getTransferRuleCollection(evi);
        if (trc.size() > 0 || "d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
            if (trc.size() > 0) {
                TransferRuleInfo tri = trc.get(0);
                entryIssueSou = tri.getSupplyRelation().getIssueStorageOrgUnit();
                entryRecSou = tri.getSupplyRelation().getReceiveStorageOrgUnit();
                entryIssueCou = tri.getSupplyRelation().getIssueCompanyOrgUnit();
                entryRecCou = tri.getSupplyRelation().getReceiveCompanyOrgUnit();
                entryIssueSale = tri.getIssueSaleOrgUnit();
                if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".endsWith(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
                    entrySupplySale = ((TransferRule3Info)tri).getSupplySaleOrgUnit();
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
                    entrySupplySale = ((TransferRule4Info)tri).getSupplySaleOrgUnit();
                    entryReqSale = ((TransferRule4Info)tri).getRequireSaleOrgUnit();
                }
            } else if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
                entryIssueSou = new StorageOrgUnitInfo();
                entryIssueSou.setId(BOSUuid.read((String)supplySouId));
                entryIssueCou = new CompanyOrgUnitInfo();
                entryIssueCou.setId(BOSUuid.read((String)supplyCouId));
                entryRecSou = reqSouInfo;
                entryRecCou = reqCompanyInfo;
                entryReqSale = reqSale;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)supplySouId) && entryIssueSale == null && StringUtils.equalsIgnoreCase((CharSequence)(inm007 = ParamControlFactory.getRemoteInstance().getParamValue((IObjectPK)new ObjectUuidPK(supplySouId), "INM007")), (CharSequence)"false") && (entryIssueSale = (SaleOrgUnitInfo)(iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getDefaultToUnit(supplySouId, 4, 2)) == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(supplySouId, 4, 2);
            entryIssueSale = (SaleOrgUnitInfo)orgCol.get(0);
        }
        map.put("entryIssueSou", entryIssueSou);
        map.put("entryRecSou", entryRecSou);
        map.put("entryIssueCou", entryIssueCou);
        map.put("entryRecCou", entryRecCou);
        map.put("entryIssueSale", entryIssueSale);
        map.put("entrySupplySale", entrySupplySale);
        map.put("entryReqSale", entryReqSale);
        return map;
    }

    @Override
    protected Map _getFilter(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String f7Name = (String)requestMap.get("f7Name");
        if (StringUtils.isEmpty((CharSequence)f7Name)) {
            return map;
        }
        String filter = null;
        if (f7Name.equals("receiptStorageOrgUnit")) {
            filter = this.getReceiptStorageFilter(ctx, requestMap, true);
        } else if (f7Name.equals("entryStorage")) {
            filter = this.getReceiptStorageFilter(ctx, requestMap, false);
        }
        map.put("filter", filter);
        return map;
    }

    private String getReceiptStorageFilter(Context ctx, Map requestMap, boolean isHead) throws EASBizException, BOSException {
        String issueStorageId = (String)requestMap.get("supplySouId");
        String issueCompanyId = (String)requestMap.get("supplyCouId");
        if (StringUtils.isEmpty((CharSequence)issueStorageId) || StringUtils.isEmpty((CharSequence)issueCompanyId)) {
            return null;
        }
        String bizTypeId = (String)requestMap.get("bizTypeId");
        Map params = this.getParamsMap(ctx);
        OrgUnitInfo[] mainOrgs = OrgUnitUtils.getMainBizOrgList((Context)ctx, (OrgType)this.getMainOrgType(), (String)this.getPermissionItem());
        ObjectUuidPK orgPk = new ObjectUuidPK(issueStorageId);
        String isStartTransferRule = ParamManager.getParamValue((Context)ctx, (IObjectPK)orgPk, (String)"INM007");
        if (StringUtils.isEmpty((CharSequence)isStartTransferRule)) {
            isStartTransferRule = "false";
        }
        String tempBizTypeID = this.getTempBizTypeId(bizTypeId);
        if (isHead) {
            return this.getHeadReceiptStorageFilter(ctx, requestMap, mainOrgs, issueStorageId, issueCompanyId, tempBizTypeID, isStartTransferRule);
        }
        return this.getEntyReceiptStorageFilter(ctx, requestMap, mainOrgs, issueStorageId, issueCompanyId, bizTypeId, tempBizTypeID, isStartTransferRule);
    }

    private String getHeadReceiptStorageFilter(Context ctx, Map requestMap, OrgUnitInfo[] mainOrgs, String issueSouId, String issueCouId, String bizTypeId, String isStartRule) throws EASBizException, BOSException {
        String[] fromStorageIDs = new String[]{issueSouId};
        String[] fromCompanyIDs = new String[]{issueCouId};
        BizRoleTypeEnum[] fromRoles = new BizRoleTypeEnum[]{BizRoleTypeEnum.SupplySide};
        BizRoleTypeEnum toRole = BizRoleTypeEnum.RequireSide;
        EntityViewInfo viewInfo = SupplyRelationServerUtils.getStorageOrgUnitViewBySupplyRelation(ctx, issueCouId, bizTypeId, fromStorageIDs, fromCompanyIDs, fromRoles, toRole, this.permItemNew, this.couMap, this.authOrgMap, null);
        if (viewInfo != null) {
            return viewInfo.getFilter().toSql();
        }
        return "id in ('XXXXX-XXXXX') ";
    }

    private String getEntyReceiptStorageFilter(Context ctx, Map requestMap, OrgUnitInfo[] mainOrgs, String issueSouId, String issueCouId, String bizTypeId, String tempBizTypeID, String isStartRule) throws EASBizException, BOSException {
        String supplySouId = (String)requestMap.get("supplySouId");
        String supplyCouId = (String)requestMap.get("supplyCouId");
        String reqSouId = (String)requestMap.get("reqSouId");
        String reqCouId = (String)requestMap.get("reqCouId");
        String entrySouId = (String)requestMap.get("entrySouId");
        String roleTypeStr = (String)requestMap.get("roleType");
        BizRoleTypeEnum roleType = BizRoleTypeEnum.getEnum(roleTypeStr);
        String[] fromStIds = new String[]{null, null, null};
        String[] fromCpIds = new String[]{null, null, null};
        BizRoleTypeEnum[] fromTypes = new BizRoleTypeEnum[]{null, null, null};
        if (!StringUtils.isEmpty((CharSequence)supplySouId)) {
            fromStIds[0] = supplySouId;
            fromCpIds[0] = supplyCouId;
            fromTypes[0] = BizRoleTypeEnum.SupplySide;
        }
        if (!StringUtils.isEmpty((CharSequence)reqSouId)) {
            fromStIds[1] = reqSouId;
            fromCpIds[1] = reqCouId;
            fromTypes[1] = BizRoleTypeEnum.RequireSide;
        }
        if (!StringUtils.isEmpty((CharSequence)entrySouId)) {
            fromStIds[2] = entrySouId;
            StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
            storage.setId(BOSUuid.read((String)entrySouId));
            CompanyOrgUnitInfo entryCou = OrgUnitUtil.getCompanyFromStorage(null, (StorageOrgUnitInfo)storage);
            fromCpIds[2] = entryCou == null ? null : entryCou.getId().toString();
            fromTypes[2] = roleType;
        }
        BizRoleTypeEnum toRole = BizRoleTypeEnum.ReceiveSide;
        if (roleType.equals((Object)BizRoleTypeEnum.ReceiveSide)) {
            toRole = BizRoleTypeEnum.IssueSide;
        }
        EntityViewInfo viewInfo = SupplyRelationServerUtils.getStorageOrgUnitViewBySupplyRelation(ctx, issueSouId, tempBizTypeID, fromStIds, fromCpIds, fromTypes, toRole, mainOrgs, isStartRule);
        return viewInfo.getFilter().toSql();
    }

    private String getTempBizTypeId(String bizTypeId) {
        if (bizTypeId.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
            return "d8e80652-0117-1000-e000-04c5c0a812202407435C";
        }
        if (bizTypeId.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
            return "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
        }
        if (bizTypeId.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
            return "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
        }
        return bizTypeId;
    }

    public void initTransferRuleByBotpBill(Context ctx, Map mapTransferRule, String bizTypeId, String supplySouId, String reqSouId, String[] recSouIds) throws EASBizException, BOSException {
        if (supplySouId == null || recSouIds == null || bizTypeId == null || reqSouId == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> recSouSet = new HashSet<String>();
        int length = recSouIds.length;
        for (int i = 0; i < length; ++i) {
            if (recSouIds[i] == null) continue;
            recSouSet.add(recSouIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", recSouSet, CompareType.INCLUDE));
        if (filter.getFilterItems().size() != 0) {
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
        } else {
            filter.appendFilterItem("bizType.number", (Object)"nonexistedtransferrulebiztypeid");
        }
        view.setFilter(filter);
        SelectorItemCollection sic = SupplyRelationServerUtils.getTransferRuleSelectorByType(ctx, bizTypeId);
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("supplyRelation.issueCompanyOrgUnit.number"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        TransferRuleCollection col = SupplyRelationServerUtils.getTransferRuleByType(ctx, bizTypeId).getTransferRuleCollection(view);
        SupplyRelationInfo supRInfo = null;
        StorageOrgUnitInfo reqSou = null;
        StorageOrgUnitInfo recSou = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            TransferRuleInfo trInfo = col.get(i);
            supRInfo = trInfo.getSupplyRelation();
            if (trInfo == null || supRInfo == null || supRInfo.getRequireStorageOrgUnit() == null || supRInfo.getReceiveStorageOrgUnit() == null) continue;
            reqSou = supRInfo.getRequireStorageOrgUnit();
            recSou = supRInfo.getReceiveStorageOrgUnit();
            if (mapTransferRule.containsKey(bizTypeId + supplySouId + reqSou.getId().toString() + recSou.getId().toString())) continue;
            mapTransferRule.put(bizTypeId + supplySouId + reqSou.getId().toString() + recSou.getId().toString(), trInfo);
        }
    }

    public void initTransferRule(Context ctx, Map mapTransferRule, String bizTypeId, String supplySouId, String reqSouId, String[] issueSouIds, String[] recSouIds) throws EASBizException, BOSException {
        int i;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouIds[i]);
            filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouIds[i]);
        }
        if (filter.getFilterItems().size() != 0) {
            filter.appendFilterItem("bizType", (Object)bizTypeId);
            filter.appendFilterItem("status", (Object)new Integer(1));
            filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
            filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
            filter.setMaskString(this.getTransferRuleMask(filter.getFilterItems().size()));
        } else {
            filter.appendFilterItem("bizType.number", (Object)"nonexistedtransferrulebiztypeid");
        }
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)SupplyRelationServerUtils.getTransferRuleSelectorByType(ctx, bizTypeId));
        length = issueSouIds.length;
        for (i = 0; i < length; ++i) {
            if (issueSouIds[i] == null || recSouIds[i] == null) continue;
            mapTransferRule.put(bizTypeId + supplySouId + reqSouId + issueSouIds[i] + recSouIds[i], null);
        }
        TransferRuleCollection col = SupplyRelationServerUtils.getTransferRuleByType(ctx, bizTypeId).getTransferRuleCollection(view);
        int size = col.size();
        for (int i2 = 0; i2 < size; ++i2) {
            TransferRuleInfo trInfo = col.get(i2);
            mapTransferRule.put(bizTypeId + supplySouId + reqSouId + trInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString() + trInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), trInfo);
        }
    }

    private String getTransferRuleMask(int size) {
        int i;
        StringBuffer maskString = new StringBuffer();
        maskString.append(" ( ");
        int length = size - 4;
        for (i = 0; i < length; i += 2) {
            maskString.append(" #").append(i).append(" and ").append("#").append(i + 1);
            if (i >= length - 2) continue;
            maskString.append(" or ");
        }
        maskString.append(" ) ");
        for (i = 4; i > 0; --i) {
            maskString.append(" and #").append(size - i);
        }
        return maskString.toString();
    }

    public TransferRuleInfo getTransferRuleByBotpBill(Map mapTransferRule, String bizTypeId, String supplySouId, String reqSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null || reqSouId == null || recSouId == null) {
            return null;
        }
        return (TransferRuleInfo)mapTransferRule.get(bizTypeId + supplySouId + reqSouId + recSouId);
    }

    public TransferRuleInfo getTransferRule(Map mapTransferRule, String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        return (TransferRuleInfo)mapTransferRule.get(bizTypeId + supplySouId + reqSouId + issueSouId + recSouId);
    }
}

