/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.app.calculate.InvBillPriceCalculate;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.AbstractTransferPriceAdjustFacadeControllerBean;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransferPriceAdjustFacadeControllerBean
extends AbstractTransferPriceAdjustFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.TransferPriceAdjustFacadeControllerBean");
    private String resFile = "com.kingdee.eas.scm.im.inv.TransferPriceAdjustResource";
    private String language = "L2";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.language = this.getLoc(ctx);
        String action = params.getString("ACTION");
        String tempTable = params.getString("tempTable");
        if ("fetch".equals(action)) {
            this.verdictIsGetDaulPrice(ctx, params, tempTable);
            this.updateAdjustPrice(ctx, params, tempTable);
        } else {
            this.dropTable(params.getString("tempTable"), ctx);
            tempTable = this.getTempTableName("tempTable", ctx);
            this.executeSQL(ctx, this.getTempTableSQL(tempTable));
            params.setString("tempTable", tempTable);
            this.insertBillData(ctx, params);
        }
        RptTableHeader header = this.buildHead(ctx, params);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int start, int length) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        bf.append("BILL.FNumber,").append("\r\n");
        bf.append("ENTRY.FSeq,").append("\r\n");
        bf.append("MATERIAL.FNumber AS FMaterialNumber,").append("\r\n");
        bf.append("MATERIAL.FName_").append(this.language).append(" As FMaterialName,").append("\r\n");
        bf.append("MATERIAL.FModel AS FModel,").append("\r\n");
        bf.append("BIZTYPE.FName_").append(this.language).append(" AS FBizTypeName,").append("\r\n");
        bf.append("BILL.FBizDate,").append("\r\n");
        bf.append("ISSUECOMPANYORGUNIT.FName_").append(this.language).append(" AS FIssueCompanyName,").append("\r\n");
        bf.append("ISSUEStorageORGUNIT.FName_").append(this.language).append(" AS FIssueStorageName,").append("\r\n");
        bf.append("RECEIPTCOMPANYORGUNIT.FName_").append(this.language).append(" AS FReceiptCompanyName,").append("\r\n");
        bf.append("RECEIPTStorageORGUNIT.FName_").append(this.language).append(" AS FReceiptStorageName,").append("\r\n");
        bf.append("StorageORGUNIT.FName_").append(this.language).append(" AS FStorageName,").append("\r\n");
        bf.append("TempT.FActualBaseUnitCost,").append("\r\n");
        bf.append("TempT.FPrice,").append("\r\n");
        bf.append("CASE WHEN ENTRY.FDiscountType = 0 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"45_TransferPriceAdjustFacadeControllerBean", (Locale)ctx.getLocale()) + "' ");
        bf.append("WHEN ENTRY.FDiscountType = 1 THEN '" + ResourceBase.getString((String)"com.kingdee.eas.scm.im.IMAutoGenerateResource", (String)"46_TransferPriceAdjustFacadeControllerBean", (Locale)ctx.getLocale()) + "' ");
        bf.append("ELSE '' END,");
        bf.append("ENTRY.FDiscountRate,").append("\r\n");
        bf.append("TempT.FActualPrice,").append("\r\n");
        bf.append("ENTRY.FTaxRate,").append("\r\n");
        bf.append("TempT.FTaxPrice,").append("\r\n");
        bf.append("TempT.FActualTaxPrice,").append("\r\n");
        bf.append("TempT.FPricePrecision,").append("\r\n");
        bf.append("TempT.FLocalCurrencyPrecision,").append("\r\n");
        bf.append("TempT.FID").append("\r\n");
        bf.append(" FROM T_IM_TransferOrderBill AS BILL ").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry AS ENTRY ON BILL.FID = ENTRY.FParentID").append("\r\n");
        bf.append(" INNER JOIN ").append(tempTable).append(" AS TempT ON ENTRY.FID = TempT.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_ORG_Company AS ISSUECOMPANYORGUNIT ON BILL.FIssueCompanyOrgUnitID = ISSUECOMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Company AS RECEIPTCOMPANYORGUNIT ON BILL.FReceiptCompanyOrgUnitID = RECEIPTCOMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Storage AS ISSUEStorageORGUNIT ON BILL.FIssueStorageOrgUnitID = ISSUEStorageORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Storage AS RECEIPTStorageORGUNIT ON BILL.FReceiptStorageOrgUnitID = RECEIPTStorageORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Storage AS StorageORGUNIT ON ENTRY.FIssueStorageOrgUnitID = StorageORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON");
        bf.append(" ISSUECOMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ON BILL.FBizTypeID = BIZTYPE.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS ISSUEWAREHOUSE ON ENTRY.FIssueWarehouseID = ISSUEWAREHOUSE.FID");
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS RECEIPTWAREHOUSE ON ENTRY.FReceiptWarehouseID = RECEIPTWAREHOUSE.FID");
        String sql = bf.toString();
        RptRowSet rs = this.executeQuery(sql, null, start, length, ctx);
        RptParams para = new RptParams();
        para.setObject("rowset", (Object)rs);
        return para;
    }

    private void updateAdjustPrice(Context ctx, RptParams params, String tempTable) throws BOSException {
        boolean flag = params.getBoolean("isWriteZeroPrice");
        if (!flag) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" SET FActualBaseUnitCost = 0 WHERE FPrice = 0");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void insertBillData(Context ctx, RptParams params) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(params.getString("tempTable"));
        bf.append(" (FID,FCompanyOrgUnitID,FMaterialID,FActualBaseUnitCost,FPrice,FActualPrice,FTaxPrice,FActualTaxPrice,FAmount,");
        bf.append("FLocalAmount,FTax,FLocalTax,FTaxAmount,FLocalTaxAmount,FDiscountAmount,FLocalDiscountAmount,");
        bf.append("FBASEQTY,FPricePrecision,FLocalCurrencyPrecision,FYear,FPeriod)").append("\r\n");
        bf.append("SELECT ").append("\r\n");
        bf.append("ENTRY.FID AS FID,").append("\r\n");
        bf.append("ENTRY.FIssueCompanyOrgUnitID,").append("\r\n");
        bf.append("ENTRY.FMaterialID,").append("\r\n");
        bf.append("ENTRY.FPrice,").append("\r\n");
        bf.append("ENTRY.FPrice,").append("\r\n");
        bf.append("ENTRY.FActualPrice,").append("\r\n");
        bf.append("ENTRY.FTaxPrice,").append("\r\n");
        bf.append("ENTRY.FActualTaxPrice,").append("\r\n");
        bf.append("ENTRY.FAmount,").append("\r\n");
        bf.append("ENTRY.FLocalAmount,").append("\r\n");
        bf.append("ENTRY.FTax,").append("\r\n");
        bf.append("ENTRY.FLocalTax,").append("\r\n");
        bf.append("ENTRY.FTaxAmount,").append("\r\n");
        bf.append("ENTRY.FLocalTaxAmount,").append("\r\n");
        bf.append("ENTRY.FDiscountAmount,").append("\r\n");
        bf.append("ENTRY.FLocalDiscountAmount,").append("\r\n");
        bf.append("ENTRY.FBaseQty,").append("\r\n");
        bf.append("MATERIAL.FPricePrecision AS FPricePrecision,").append("\r\n");
        bf.append("BASECURRENCY.FPrecision AS FPrecision,").append("\r\n");
        bf.append("BILL.FYear,").append("\r\n");
        bf.append("BILL.FPeriod").append("\r\n");
        bf.append(" FROM T_IM_TransferOrderBill AS BILL ").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry AS ENTRY ON BILL.FID = ENTRY.FParentID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT ON BILL.FIssueCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON");
        bf.append(" COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ON BILL.FBizTypeID = BIZTYPE.FID").append("\r\n");
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS ISSUEWAREHOUSE ON ENTRY.FIssueWarehouseID = ISSUEWAREHOUSE.FID");
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS RECEIPTWAREHOUSE ON ENTRY.FReceiptWarehouseID = RECEIPTWAREHOUSE.FID");
        bf.append(this.getSQLWhere(ctx, params));
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private String getSQLWhere(Context ctx, RptParams params) {
        String id;
        int i;
        int length;
        Object[] obj;
        CompanyOrgUnitInfo issueCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("issueCompanyOrgUnit");
        CompanyOrgUnitInfo receiptCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("receiptCompanyOrgUnit");
        Object issueStorageOrgUnit = params.getObject("issueStorageOrgUnit");
        Object receiptStorageOrgUnit = params.getObject("receiptStorageOrgUnit");
        BizTypeInfo bizTypeFrom = (BizTypeInfo)params.getObject("bizTypeFrom");
        BizTypeInfo bizTypeTo = (BizTypeInfo)params.getObject("bizTypeTo");
        String billNumFrom = params.getString("billNumFrom");
        String billNumTo = params.getString("billNumTo");
        MaterialInfo materialNumFrom = (MaterialInfo)params.getObject("materialNumFrom");
        MaterialInfo materialNumTo = (MaterialInfo)params.getObject("materialNumTo");
        Date bizDateFrom = (Date)params.getObject("bizDateFrom");
        Date bizDateTo = (Date)params.getObject("bizDateTo");
        WarehouseInfo issueWarehouseFrom = (WarehouseInfo)params.getObject("issueWarehouseFrom");
        WarehouseInfo issueWarehouseTo = (WarehouseInfo)params.getObject("issueWarehouseTo");
        WarehouseInfo receiptWarehouseFrom = (WarehouseInfo)params.getObject("receiptWarehouseFrom");
        WarehouseInfo receiptWarehouseTo = (WarehouseInfo)params.getObject("receiptWarehouseTo");
        String issueStorageOrgUnitIDs = null;
        String receiptStorageOrgUnitIDs = null;
        StringBuffer bf = new StringBuffer();
        if (issueStorageOrgUnit instanceof Object[]) {
            obj = (Object[])issueStorageOrgUnit;
            bf.append("(");
            length = obj.length;
            for (i = 0; i < length; ++i) {
                id = ((StorageOrgUnitInfo)obj[i]).getId().toString();
                bf.append("'").append(id).append("'");
                if (i == length - 1) continue;
                bf.append(",");
            }
            bf.append(")");
            issueStorageOrgUnitIDs = bf.toString();
        }
        bf.setLength(0);
        if (receiptStorageOrgUnit instanceof Object[]) {
            obj = (Object[])receiptStorageOrgUnit;
            bf.append("(");
            length = obj.length;
            for (i = 0; i < length; ++i) {
                id = ((StorageOrgUnitInfo)obj[i]).getId().toString();
                bf.append("'").append(id).append("'");
                if (i == length - 1) continue;
                bf.append(",");
            }
            bf.append(")");
            receiptStorageOrgUnitIDs = bf.toString();
        }
        bf.setLength(0);
        bf.append(" WHERE BILL.FIssueCompanyOrgUnitID = '").append(issueCompanyOrgUnitInfo.getId().toString()).append("'");
        if (receiptCompanyOrgUnitInfo != null) {
            bf.append(" AND BILL.FReceiptCompanyOrgUnitID = '").append(receiptCompanyOrgUnitInfo.getId().toString()).append("'");
        }
        if (issueStorageOrgUnitIDs != null) {
            bf.append(" AND BILL.FIssueStorageOrgUnitID IN ").append(issueStorageOrgUnitIDs).append("\r\n");
        }
        if (receiptStorageOrgUnitIDs != null) {
            bf.append(" AND BILL.FIssueStorageOrgUnitID IN ").append(receiptStorageOrgUnitIDs).append("\r\n");
        }
        if (bizDateFrom != null) {
            bf.append(" AND BILL.FBizDate >= TO_DATE('" + IMRptUtils.getFilterBeginDate(bizDateFrom) + "') ");
        }
        if (bizDateTo != null) {
            bf.append(" AND BILL.FBizDate <= TO_DATE('" + IMRptUtils.getFilterEndDate(bizDateTo) + "') ");
        }
        if (bizTypeFrom != null) {
            bf.append(" AND BIZTYPE.FNumber >= '").append(bizTypeFrom.getNumber()).append("'").append("\r\n");
        }
        if (bizTypeTo != null) {
            bf.append(" AND BIZTYPE.FNumber <= '").append(bizTypeTo.getNumber()).append("'").append("\r\n");
        }
        if (billNumFrom != null && billNumFrom.trim().length() != 0 && !"".equals(billNumFrom.trim())) {
            bf.append(" AND BILL.FNumber >= '").append(billNumFrom).append("'").append("\r\n");
        }
        if (billNumFrom != null && billNumFrom.trim().length() != 0 && !"".equals(billNumFrom.trim())) {
            bf.append(" AND BILL.FNumber <= '").append(billNumTo).append("'").append("\r\n");
        }
        if (materialNumFrom != null) {
            bf.append(" AND MATERIAL.FNumber >= '").append(materialNumFrom.getNumber()).append("'").append("\r\n");
        }
        if (materialNumTo != null) {
            bf.append(" AND MATERIAL.FNumber >= '").append(materialNumTo.getNumber()).append("'").append("\r\n");
        }
        if (issueWarehouseFrom != null) {
            bf.append(" AND ISSUEWAREHOUSE.FNumber >= '").append(issueWarehouseFrom.getNumber()).append("'").append("\r\n");
        }
        if (issueWarehouseTo != null) {
            bf.append(" AND ISSUEWAREHOUSE.FNumber >= '").append(issueWarehouseTo.getNumber()).append("'").append("\r\n");
        }
        if (receiptWarehouseFrom != null) {
            bf.append(" AND RECEIPTWAREHOUSE.FNumber >= '").append(receiptWarehouseFrom.getNumber()).append("'").append("\r\n");
        }
        if (receiptWarehouseTo != null) {
            bf.append(" AND RECEIPTWAREHOUSE.FNumber >= '").append(receiptWarehouseTo.getNumber()).append("'").append("\r\n");
        }
        return bf.toString();
    }

    private RptTableHeader buildHead(Context ctx, RptParams params) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        ArrayList<String> list = new ArrayList<String>();
        col = new RptTableColumn("FBillNum");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"billNum", (Context)ctx));
        col = new RptTableColumn("FBillSeq");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"billSeq", (Context)ctx));
        col = new RptTableColumn("FMaterialNumber");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"materialNumber", (Context)ctx));
        col = new RptTableColumn("FMaterial");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"material", (Context)ctx));
        col = new RptTableColumn("FModel");
        col.setWidth(100);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"model", (Context)ctx));
        col = new RptTableColumn("FBizType");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"bizType", (Context)ctx));
        col = new RptTableColumn("FBizDate");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"bizDate", (Context)ctx));
        col = new RptTableColumn("FIssueCompanyOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"issueCompanyOrgUnit", (Context)ctx));
        col = new RptTableColumn("FIssueStorageOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"issueStorageOrgUnit", (Context)ctx));
        col = new RptTableColumn("FReceiptCompanyOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"receiptCompanyOrgUnit", (Context)ctx));
        col = new RptTableColumn("FReceiptStorageOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"receiptStorageOrgUnit", (Context)ctx));
        col = new RptTableColumn("FStorageOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"storageOrgUnit", (Context)ctx));
        col = new RptTableColumn("FAdjustPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"adjustPrice", (Context)ctx));
        col = new RptTableColumn("FPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"price", (Context)ctx));
        col = new RptTableColumn("FDiscountType");
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"discountType", (Context)ctx));
        col = new RptTableColumn("FDiscountRate");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"discountRate", (Context)ctx));
        col = new RptTableColumn("FActualPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"actualPrice", (Context)ctx));
        col = new RptTableColumn("FTaxRate");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"taxRate", (Context)ctx));
        col = new RptTableColumn("FTaxPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"taxPrice", (Context)ctx));
        col = new RptTableColumn("FActualTaxPrice");
        col.setAligment(2);
        col.setWidth(120);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"actualTaxPrice", (Context)ctx));
        col = new RptTableColumn("FPricePrecision");
        col.setAligment(2);
        col.setHided(true);
        col.setWidth(0);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"FPricePrecision", (Context)ctx));
        col = new RptTableColumn("FLocalCurrencyPrecision");
        col.setAligment(2);
        col.setHided(true);
        col.setWidth(0);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"FLocalCurrencyPrecision", (Context)ctx));
        col = new RptTableColumn("FID");
        col.setHided(true);
        col.setWidth(0);
        header.addColumn(col);
        list.add(SCMUtils.getResource((String)this.resFile, (String)"FID", (Context)ctx));
        int length = list.size();
        Object[][] obj = new Object[1][length];
        for (int i = 0; i < length; ++i) {
            obj[0][i] = list.get(i);
        }
        header.setLabels(obj, true);
        return header;
    }

    private String getTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ").append(tempTable).append(" (");
        sql.append("FID Varchar(44),").append("\r\n");
        sql.append("FCompanyOrgUnitID Varchar(44),").append("\r\n");
        sql.append("FMaterialID Varchar(44),").append("\r\n");
        sql.append("FBASEQTY Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FActualBaseUnitCost Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FActualCost Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FPrice Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FActualPrice Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FTaxPrice Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FActualTaxPrice Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FLocalAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FTax Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FLocalTax Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FTaxAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FLocalTaxAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FDiscountAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FLocalDiscountAmount Decimal(28,16) Not Null Default 0,").append("\r\n");
        sql.append("FPricePrecision INT DEFAULT 0 NOT NULL,").append("\r\n");
        sql.append("FLocalCurrencyPrecision INT DEFAULT 0 NOT NULL,").append("\r\n");
        sql.append("FIsEditTransferOrder INT DEFAULT 0 NOT NULL,").append("\r\n");
        sql.append("FIsEditPurInWarehs INT DEFAULT 0 NOT NULL,").append("\r\n");
        sql.append("FIsEditSaleIssue INT DEFAULT 0 NOT NULL,").append("\r\n");
        sql.append("FYear INT,").append("\r\n");
        sql.append("FPeriod INT").append("\r\n");
        sql.append(" );");
        return sql.toString();
    }

    private void updateAdjustPrice(Context ctx, Map map, String tempTableName) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTableName).append(" SET FActualBaseUnitCost = ? WHERE FID = ?");
        String sql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(sql);
            String id2 = null;
            BigDecimal adjustPrice = null;
            for (String id2 : map.keySet()) {
                adjustPrice = (BigDecimal)map.get(id2);
                pm.setBigDecimal(1, adjustPrice);
                pm.setString(2, id2);
                pm.addBatch();
            }
            pm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pm, (Connection)conn);
    }

    private void verdictIsGetDaulPrice(Context ctx, RptParams params, String tempTableName) throws BOSException, EASBizException {
        if (params.getObject("PRICE_ENUM") != null) {
            int priceEnum = params.getInt("PRICE_ENUM");
            CalculateParams calparams = new CalculateParams();
            calparams.setString("COMPANY_ID", params.getString("COMPANY_ID"));
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("issueCompanyOrgUnit");
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (periodInfo == null) {
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, (Object[])new String[]{""});
            }
            InvBillPriceCalculate iiwc = new InvBillPriceCalculate();
            String devInWarehsTempTable = DBUtil.createTempTable((Context)ctx, (String)"BEGINAVGPRICE", (String[][])this.getBeginDataTableField());
            if (priceEnum == 0) {
                DbUtil.execute((Context)ctx, (String)iiwc.getBeginDataSQL(periodInfo, tempTableName, devInWarehsTempTable));
                DbUtil.execute((Context)ctx, (String)iiwc.updateBeginWeightedAveragePrice(periodInfo, tempTableName, devInWarehsTempTable));
            } else if (priceEnum == 1) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateUnitStandardPrice(periodInfo, tempTableName));
            } else if (priceEnum == 2) {
                iiwc.updateLastTimeNewPayoutPrice(ctx, periodInfo, tempTableName, calparams);
            } else if (priceEnum == 4) {
                iiwc.updateNewInpourPrice(ctx, periodInfo, tempTableName, calparams);
            } else if (priceEnum == 5) {
                iiwc.updateNewPayoutPrice(ctx, periodInfo, tempTableName, calparams);
            } else if (priceEnum == 6) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAverageInpourPrice(periodInfo, tempTableName, null, calparams));
            } else if (priceEnum == 7) {
                DbUtil.execute((Context)ctx, (String)iiwc.updateThisPeriodAveragePayoutPrice(periodInfo, tempTableName, null, calparams));
            }
        }
    }

    private String[][] getBeginDataTableField() {
        String[][] fields = new String[][]{{"FMaterialId", "varchar(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    private void updateTempTablePrice(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        String strTaxRate = CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FTaxRate/100").toString();
        bf.setLength(0);
        String strDiscountRate = CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FDiscountRate/100").toString();
        bf.setLength(0);
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FPrice,FActualPrice,FTaxPrice)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT TempT.FActualBaseUnitCost,").append("\r\n");
        bf.append("CASE WHEN ENTRY.FDiscountType = 0 THEN ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)("TempT.FActualBaseUnitCost * (1 - " + strDiscountRate + ")"))).append(",TempT.FPricePrecision)").append("\r\n");
        bf.append(" WHEN ENTRY.FDiscountType = 1 THEN ").append("\r\n");
        bf.append(" ROUND(TempT.FActualBaseUnitCost - ").append(CalculateUtil.TO_DECIMAL_SUM((String)("FDiscountRate/(1 + " + strTaxRate + ")"))).append(",TempT.FPricePrecision)").append("\r\n");
        bf.append(" ELSE TempT.FActualBaseUnitCost END,").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)("TempT.FActualBaseUnitCost * (1 + " + strTaxRate + ")"))).append(",TempT.FPricePrecision)").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" WHERE T.FID = TempT.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void updateTempTableAmount(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        String strTaxRate = CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FTaxRate/100").toString();
        bf.setLength(0);
        String strDiscountRate = CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FDiscountRate/100").toString();
        bf.setLength(0);
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FAmount,FTax,FDiscountAmount,FActualTaxPrice)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FQty * TempT.FActualPrice")).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)(CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FQty * TempT.FActualPrice") + "*" + strTaxRate))).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" CASE WHEN ENTRY.FDiscountType = 0 THEN ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FTaxPrice * ENTRY.FQty") + "*" + strDiscountRate))).append(",TempT.FLocalCurrencyPrecision)").append("\r\n");
        bf.append(" WHEN ENTRY.FDiscountType = 1 THEN ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"ENTRY.FQty * ENTRY.FDiscountRate")).append(",TempT.FLocalCurrencyPrecision)").append("\r\n");
        bf.append(" ELSE 0 END,").append("\r\n");
        bf.append(" CASE WHEN ENTRY.FDiscountType = 0 THEN ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)("TempT.FTaxPrice * (1 - " + strDiscountRate + ")"))).append(",TempT.FPricePrecision)").append("\r\n");
        bf.append(" WHEN ENTRY.FDiscountType = 1 THEN ").append("\r\n");
        bf.append(" ROUND(TempT.FTaxPrice - ").append(CalculateUtil.TO_DECIMAL_SUM((String)("FDiscountRate/(1 + " + strTaxRate + ")"))).append(",TempT.FPricePrecision)").append("\r\n");
        bf.append(" ELSE TempT.FTaxPrice END").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" WHERE T.FID = TempT.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void updateTempTableLocalAmount(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FLocalAmount,FLocalTax,FLocalDiscountAmount,FTaxAmount,FLocalTaxAmount)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT ").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FAmount * BILL.FExchangeRate")).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FTax * BILL.FExchangeRate")).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FDiscountAmount * BILL.FExchangeRate")).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" TempT.FAmount + TempT.FTax,").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FAmount * BILL.FExchangeRate")).append(",TempT.FLocalCurrencyPrecision) ").append("\r\n");
        bf.append("+").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FTax * BILL.FExchangeRate")).append(",TempT.FLocalCurrencyPrecision)").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBill BILL ON BILL.FID = ENTRY.FParentID").append("\r\n");
        bf.append(" WHERE T.FID = TempT.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void isEditTransferOrder(Context ctx, String tempTable, PeriodInfo periodInfo) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FIsEditTransferOrder)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT 1").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBill BILL ON BILL.FID = ENTRY.FParentID").append("\r\n");
        bf.append(" WHERE BILL.FBizDate >= TO_DATE('" + IMRptUtils.getFilterBeginDate(periodInfo.getBeginDate()) + "') ");
        bf.append(" AND (ENTRY.FSaleInvoiceQty = 0 OR ENTRY.FPurInvoiceQty = 0)").append("\r\n");
        bf.append(" AND (ENTRY.FIssueQty = 0 OR ENTRY.FReceiptQty = 0)").append("\r\n");
        bf.append(" AND T.FID = TempT.FID )").append("\r\n");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void isEditPurInWarehs(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FIsEditTransferOrder,FIsEditPurInWarehs)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT 1,1 FROM (").append("\r\n");
        bf.append("SELECT 1,1,TempT.FID").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" INNER JOIN T_IM_PurInWarehsEntry T1 ON TempT.FID = T1.FPurOrderEntryID").append("\r\n");
        bf.append(" INNER JOIN T_IM_PurInWarehsBill T2 ON T2.FID = T1.FParentID").append("\r\n");
        bf.append(" WHERE ENTRY.FReceiptQty <> 0 ").append("\r\n");
        bf.append(" AND (ENTRY.FPurInvoiceQty = 0 AND T1.FWrittenOffQty = 0 AND T2.FFiVouchered = 0)");
        bf.append(" GROUP BY TempT.FID) AS T3").append("\r\n");
        bf.append(" WHERE T3.FID = T.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void isEditSaleIssue(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTable).append(" AS T");
        bf.append(" SET(FIsEditTransferOrder,FIsEditSaleIssue)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT 1,1 FROM (").append("\r\n");
        bf.append("SELECT 1,1,TempT.FID").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" INNER JOIN T_IM_SaleIssueEntry T1 ON TempT.FID = T1.FSaleOrderEntryID").append("\r\n");
        bf.append(" INNER JOIN T_IM_SaleIssueBill T2 ON T2.FID = T1.FParentID").append("\r\n");
        bf.append(" WHERE ENTRY.FIssueQty <> 0 ").append("\r\n");
        bf.append(" AND (ENTRY.FSaleInvoiceQty = 0 AND T1.FWrittenOffQty = 0 AND T2.FFiVouchered = 0)");
        bf.append(" GROUP BY TempT.FID) AS T3").append("\r\n");
        bf.append(" WHERE T3.FID = T.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void updateTransferOrder(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE T_IM_TransferOrderBillEntry AS T");
        bf.append(" SET(FPrice,FActualPrice,FTaxPrice,FActualTaxPrice,FAmount,FLocalAmount,");
        bf.append("FTax,FLocalTax,FTaxAmount,FLocalTaxAmount,FDiscountAmount,FLocalDiscountAmount)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT TempT.FPrice,").append("\r\n");
        bf.append("TempT.FActualPrice,").append("\r\n");
        bf.append("TempT.FTaxPrice,").append("\r\n");
        bf.append("TempT.FActualTaxPrice,").append("\r\n");
        bf.append("TempT.FAmount,").append("\r\n");
        bf.append("TempT.FLocalAmount,").append("\r\n");
        bf.append("TempT.FTax,").append("\r\n");
        bf.append("TempT.FLocalTax,").append("\r\n");
        bf.append("TempT.FTaxAmount,").append("\r\n");
        bf.append("TempT.FLocalTaxAmount,").append("\r\n");
        bf.append("TempT.FDiscountAmount,").append("\r\n");
        bf.append("TempT.FLocalDiscountAmount").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_TransferOrderBillEntry ENTRY ON TempT.FID = ENTRY.FID").append("\r\n");
        bf.append(" WHERE TempT.FIsEditTransferOrder = 1 AND TempT.FID = T.FID )").append("\r\n");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private void updatePurInwarehs(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE T_IM_PurInWarehsEntry AS T");
        bf.append(" SET (FUnitActualCost,FActualCost,FUnWriteOffAmount)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT TempT.FActualPrice,").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FActualPrice * T1.FQty")).append(",TempT.FLocalCurrencyPrecision),").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FActualPrice * T1.FQty")).append(",TempT.FLocalCurrencyPrecision)").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_PurInWarehsEntry T1 ON TempT.FID = T1.FPurOrderEntryID").append("\r\n");
        bf.append(" WHERE TempT.FIsEditTransferOrder = 1 AND TempT.FIsEditPurInWarehs = 1").append("\r\n");
        bf.append(" AND T.FID = T1.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
        this.executeSQL(ctx, this.getUpdatePurInWarehsSQL(tempTable));
    }

    private void updateSaleIssue(Context ctx, String tempTable) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE T_IM_SaleIssueEntry AS T");
        bf.append(" SET (FPrice,FAmount)");
        bf.append(" = ( ").append("\r\n");
        bf.append("SELECT TempT.FActualTaxPrice,").append("\r\n");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM((String)"TempT.FActualTaxPrice * T1.FQty")).append(",TempT.FLocalCurrencyPrecision)").append("\r\n");
        bf.append(" FROM ").append(tempTable).append(" AS TempT").append("\r\n");
        bf.append(" INNER JOIN T_IM_SaleIssueEntry T1 ON TempT.FID = T1.FSaleOrderEntryID").append("\r\n");
        bf.append(" WHERE TempT.FIsEditTransferOrder = 1 AND TempT.FIsEditSaleIssue = 1").append("\r\n");
        bf.append(" AND T.FID = T1.FID )");
        String sql = bf.toString();
        this.executeSQL(ctx, sql);
    }

    private String getUpdatePurInWarehsSQL(String tempTable) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update T_IM_PurInWarehsEntry as t1 set (FPurchaseCost, FUnitPurchaseCost, FUnWriteOffAmount,FAmount,");
        sSQL.append("FLocalTax,FTax,FTaxAmount,FLocalTaxAmount,FDiscountAmount,FTaxPrice,FPrice,FActualPrice,FActualTaxPrice) = (");
        sSQL.append("select (t.FActualCost-t.FPurchaseFee-t.FMaterialCost),");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost) / t.FQty, 21,8), temp.FPricePrecision),");
        sSQL.append("(t.FActualCost-t.FPurchaseFee-t.FMaterialCost-t.FWrittenOffAmount), ");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost),21,8), t2.FPriceprecision),");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*");
        sSQL.append("(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t.FTaxRate/(100-t.FTaxRate),21,8) else t.FTaxRate/100 end),21,8), t2.FPriceprecision),");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*");
        sSQL.append("(case t3.FIsPriceInTax when 0 then TO_DECIMAL(t.FTaxRate/(100-t.FTaxRate),21,8) else t.FTaxRate/100 end),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL(((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(100/(100-t.FTaxRate),21,8) else 1+t.FTaxRate/100 end)),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL(((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(100/(100-t.FTaxRate),21,8) else 1+t.FTaxRate/100 end)),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(100/(100-t.FTaxRate),21,8) else 1+t.FTaxRate/100 end)*t.FDiscountRate/100/(1-TO_DECIMAL(t.FDiscountRate/100,21,8)),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL(((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(100/(100-t.FTaxRate),21,8) else 1+t.FTaxRate/100 end))/t.FQty/(1-TO_DECIMAL(t.FDiscountRate/100,21,8)),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)/t.FQty,21,8)/(1-TO_DECIMAL(t.FDiscountRate/100,21,8)),21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)/t.FQty,21,8), t2.FPriceprecision), ");
        sSQL.append("ROUND(TO_DECIMAL((t.FActualCost-t.FPurchaseFee-t.FMaterialCost)*(case t3.FIsPriceInTax when 0 then TO_DECIMAL(100/(100-t.FTaxRate),21,8) else 1+t.FTaxRate/100 end)/t.FQty,21,8), t2.FPriceprecision) ");
        sSQL.append("from T_IM_PurInWarehsEntry as t, T_BD_Material t2 , T_IM_PurInWarehsBill t3, t_org_company t4 , T_BD_ExchangeTable t5, " + tempTable + " temp ");
        sSQL.append("where temp.FIsEditPurInWarehs = 1 and (t3.FFiVouchered = 0 or t3.FFiVouchered is NULL) ");
        sSQL.append("and t2.fid = t.fmaterialid and t3.fid = t.fparentid  and t.fcompanyorgunitid = t4.fid ");
        sSQL.append("and t4.fbaseexgtableid = t5.fid and t.FPurOrderEntryID = temp.fid ");
        sSQL.append("and t3.fcurrencyid = t4.fbasecurrencyid ");
        sSQL.append("and t.fid = t1.fid )");
        return sSQL.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    @Override
    protected void _calculate(Context ctx, Map map, CompanyOrgUnitInfo companyOrgUnitInfo, String tempTable) throws BOSException, EASBizException {
        if (tempTable == null || map.isEmpty()) {
            return;
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (periodInfo == null) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, (Object[])new String[]{""});
        }
        this.updateAdjustPrice(ctx, map, tempTable);
        this.updateTempTablePrice(ctx, tempTable);
        this.updateTempTableAmount(ctx, tempTable);
        this.updateTempTableLocalAmount(ctx, tempTable);
        this.isEditTransferOrder(ctx, tempTable, periodInfo);
        this.isEditPurInWarehs(ctx, tempTable);
        this.isEditSaleIssue(ctx, tempTable);
        this.updateTransferOrder(ctx, tempTable);
        this.updatePurInwarehs(ctx, tempTable);
        this.updateSaleIssue(ctx, tempTable);
    }
}

