/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.ArAndApHandlerFactory;
import com.kingdee.eas.scm.im.inv.app.IVirtualBill;
import com.kingdee.eas.scm.im.inv.app.SaleIssueVirtualHandler;

public class VirtualBillFactory {
    private IVirtualBill iVirtualBill = null;

    public VirtualBillFactory(IObjectValue model) {
        if (model instanceof SaleIssueBillInfo) {
            this.iVirtualBill = new SaleIssueVirtualHandler();
        } else if (model.getBOSType().toString().equals("FC910EF3")) {
            try {
                this.iVirtualBill = ArAndApHandlerFactory.createHandler("ar");
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        } else if (model.getBOSType().toString().equals("48DA3A71")) {
            try {
                this.iVirtualBill = ArAndApHandlerFactory.createHandler("ap");
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        } else {
            this.iVirtualBill = null;
        }
    }

    public IVirtualBill getInstonce() {
        return this.iVirtualBill;
    }
}

