/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.dataloader.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.dataloader.app.AbstractServerDataLoader;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import java.util.HashMap;
import java.util.HashSet;

public class MaterialCompanyDataLoader
extends AbstractServerDataLoader {
    private String companyPropertyName = "companyOrgUnit";

    public String getCompanyPropertyName() {
        return this.companyPropertyName;
    }

    public void setCompanyPropertyName(String companyPropertyName) {
        this.companyPropertyName = companyPropertyName;
    }

    public MaterialCompanyDataLoader(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<?> clazz) {
        return MatAssembleBillInfo.class.isAssignableFrom(clazz) || MatDisassembleBillInfo.class.isAssignableFrom(clazz);
    }

    public void load(IObjectCollection objectCol, IDataCache dataCache) throws BOSException, EASBizException {
        assert (objectCol != null);
        assert (dataCache != null);
        if (objectCol.size() == 0) {
            return;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> companyIdSet = new HashSet<String>();
        int len = objectCol.size();
        for (int index = 0; index < len; ++index) {
            InvBillBaseInfo invInfo = (InvBillBaseInfo)objectCol.getObject(index);
            if (invInfo == null || invInfo.get(this.getEntryName(invInfo)) == null || ((IObjectCollection)invInfo.get(this.getEntryName(invInfo))).size() == 0) continue;
            IObjectCollection entryCol = (IObjectCollection)invInfo.get(this.getEntryName(invInfo));
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo companyOrgUnitInfo;
                SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entryCol.getObject(i);
                if (entryInfo.getMaterial() == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
                if (entryInfo.get(this.companyPropertyName) instanceof IObjectValue && (companyOrgUnitInfo = (CompanyOrgUnitInfo)entryInfo.getObjectValue(this.companyPropertyName)) != null) {
                    companyIdSet.add(companyOrgUnitInfo.getId().toString());
                }
                IObjectCollection entry1Col = (IObjectCollection)entryInfo.get(this.getEntry1Name(invInfo));
                for (int j = 0; j < entry1Col.size(); ++j) {
                    SCMBillEntryBaseInfo entry1Info = (SCMBillEntryBaseInfo)entry1Col.getObject(j);
                    if (entry1Info.getMaterial() == null) continue;
                    materialIdSet.add(entry1Info.getMaterial().getId().toString());
                    if (!(entry1Info.get(this.companyPropertyName) instanceof IObjectValue) || (companyOrgUnitInfo = (CompanyOrgUnitInfo)entry1Info.getObjectValue(this.companyPropertyName)) == null) continue;
                    companyIdSet.add(companyOrgUnitInfo.getId().toString());
                }
            }
        }
        if (materialIdSet.size() == 0 || companyIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        view.setSelector(selector);
        MaterialCompanyInfoCollection matCompanyCol = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx()).getMaterialCompanyInfoCollection(view);
        HashMap<String, MaterialCompanyInfoInfo> tMap = new HashMap<String, MaterialCompanyInfoInfo>();
        int size = matCompanyCol.size();
        for (int i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo info = matCompanyCol.get(i);
            String key = info.getMateial().getId().toString() + info.getCompany().getId().toString();
            tMap.put(key, info);
            dataCache.put(key, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        }
    }

    protected String getEntryName(InvBillBaseInfo invBillInfo) {
        if (invBillInfo instanceof MatAssembleBillInfo) {
            return "entry";
        }
        return "entries";
    }

    protected String getEntry1Name(InvBillBaseInfo invBillInfo) {
        if (invBillInfo instanceof MatAssembleBillInfo) {
            return "entry1";
        }
        return "entries";
    }
}

