/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.engin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.RealTimeBalanceCalculator;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.InventoryCollection;
import com.kingdee.eas.scm.im.inv.InventoryFactory;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.IDecompose;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class InvDecomposeCalculator
extends RealTimeBalanceCalculator
implements IDecompose {
    private static final String UNIT = "FUnitID";
    private static final String BASEUNIT = "FBaseUnitID";
    private static final String ASSISTUNIT = "FAssistUnitID";
    private static final String QTY = "FCurStoreQty";
    private static final String BASEQTY = "FBaseQty";
    private static final String ASSISTQTY = "FAssistQty";
    private static final String MATERIALNUMBER = "materialNumber";
    private static final String MATERIALNAME = "materialName";
    private static final String UNITNAME = "unitName";
    private static final String QTYPRECISION = "unitPrecision";
    private static final String WAREHOUSENUMBER = "warehouseNumber";
    private static final String WAREHOUSENAME = "warehouseName";
    private Map<String, List> invRecordMap = new HashMap<String, List>();

    private InvDecomposeCalculator(Context ctx, BalanceModelInfo balanceModelInfo) throws EASBizException, BOSException {
        super(ctx, balanceModelInfo);
    }

    public static IDecompose getInstance(Context ctx) throws EASBizException, BOSException {
        InvDecomposeCalculator decomposeCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), BalanceEnginUtil.getBalanceModelSelector());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        decomposeCalculator = new InvDecomposeCalculator(ctx, balanceModelInfo);
        return decomposeCalculator;
    }

    @Override
    public Map doDecompose(String billID, String bosType) throws BOSException, EASBizException {
        super.calculate(bosType, billID, OperationTypeEnum.Positive);
        return this.invRecordMap;
    }

    protected void calculateStep() throws BOSException, EASBizException {
        this.takeBillData();
        if (this.isTempTableNull()) {
            return;
        }
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.groupDetailDataToFinalTable();
        this.updateBalanceIdToTempTable();
        this.calculateBalance();
        this.calculateDecomposeInventory();
    }

    private void calculateDecomposeInventory() throws EASBizException, BOSException {
        String inventoryId = null;
        Map invModel = null;
        List<String> tmpIdList = null;
        HashSet<String> invIdSet = new HashSet<String>();
        ArrayList<String> allIdList = new ArrayList<String>();
        List<Map> recList = this.getLackQtyRecordList();
        HashMap<String, Map> invModelMap = new HashMap<String, Map>();
        for (int i = 0; i < recList.size(); ++i) {
            invModel = recList.get(i);
            tmpIdList = this.getDecomposeInvIdList(invModel);
            if (tmpIdList == null || tmpIdList.size() <= 0) continue;
            allIdList.addAll(tmpIdList);
            inventoryId = tmpIdList.get(0);
            invIdSet.add(inventoryId);
            invModelMap.put(inventoryId, invModel);
        }
        List lackQtyInvInfoList = this.getLackQtyInvInfoList(invIdSet, invModelMap);
        if (recList.size() > 0 && lackQtyInvInfoList.size() == 0) {
            String errorInfo = this.buildDetailErrorMsg(recList);
            throw new InvUpdateException(InvUpdateException.IM_ONHAND_NOT_ENOUGH, new String[]{errorInfo});
        }
        this.invRecordMap.put("InventoryIDList", allIdList);
        this.invRecordMap.put("ShortQtyInvInfoList", lackQtyInvInfoList);
    }

    private String getCheckExistingQtySQL(String finalTempTable) {
        String localeString = LocaleUtils.getLocaleString((Locale)ContextUtils.getLocaleFromEnv());
        String matName = "material.FName_" + localeString;
        String unitName = "unitMu.FName_" + localeString;
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(BalanceEnginUtil.getBalanceModelFieldStr((BalanceModelInfo)this.balanceModelInfo, (String)"tmp")).append(",");
        sql.append("material.FNumber as ").append(MATERIALNUMBER).append(",");
        sql.append(matName).append(" as ").append(MATERIALNAME).append(",");
        sql.append(unitName).append(" as ").append(UNITNAME).append(",");
        sql.append("wh.fname_").append(localeString).append(" as ").append(WAREHOUSENAME).append(",");
        sql.append("wh.fnumber").append(" as ").append(WAREHOUSENUMBER).append(",");
        sql.append("ummu.FQtyPrecision as ").append(QTYPRECISION).append("\r\n");
        sql.append("FROM ").append(finalTempTable).append(" tmp ");
        sql.append("INNER JOIN T_BD_Material material on material.FID = tmp.FMaterialID ");
        sql.append("INNER JOIN T_BD_MaterialInventory mi ON tmp.FMaterialID = mi.FMaterialID AND tmp.FStorageOrgUnitID = mi.FOrgUnit ");
        sql.append("INNER JOIN T_BD_MeasureUnit unitMu on tmp.FUnitID = unitMu.FId ");
        sql.append("INNER JOIN T_BD_MultiMeasureUnit ummu ON tmp.FMaterialID = ummu.FMaterialID AND tmp.FUnitID = ummu.FMEASUREUNITID ");
        sql.append("INNER JOIN t_db_warehouse wh on wh.fid = tmp.fwarehouseid ");
        sql.append("WHERE ISNULL(mi.FIsNegative, 0) = 0 AND (tmp.FCurStoreQty < 0 OR tmp.FBaseQty < 0)");
        return sql.toString();
    }

    private List<Map> getLackQtyRecordList() throws BOSException {
        String sSQL = this.getCheckExistingQtySQL(this.finalTempTable);
        IRowSet rs = KsqlUtil.executeQuery((Context)this.ctx, (String)sSQL);
        try {
            return this.assemble2Map((ResultSet)rs);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private List<Map> assemble2Map(ResultSet rs) throws SQLException {
        ArrayList<Map> list = new ArrayList<Map>();
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        int size = coll.size();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < size; ++i) {
                fieldInfo = coll.get(i);
                map.put(fieldInfo.getFieldName(), rs.getObject(fieldInfo.getFieldName()));
            }
            map.put(MATERIALNUMBER, rs.getString(MATERIALNUMBER));
            map.put(MATERIALNAME, rs.getString(MATERIALNAME));
            map.put(UNITNAME, rs.getString(UNITNAME));
            map.put(QTYPRECISION, rs.getInt(QTYPRECISION));
            map.put(WAREHOUSENAME, rs.getString(WAREHOUSENAME));
            map.put(WAREHOUSENUMBER, rs.getString(WAREHOUSENUMBER));
            list.add(map);
        }
        return list;
    }

    private List<String> getDecomposeInvIdList(Map invModel) throws BOSException {
        ArrayList<String> tmpIdList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement preStmtDecompose = null;
        ResultSet rsDecompose = null;
        BigDecimal invBaseQty = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            preStmtDecompose = conn.prepareStatement(this.getInventorySql());
            this.setPreStmtDecomposeParams(preStmtDecompose, invModel);
            rsDecompose = preStmtDecompose.executeQuery();
            tmpIdList.clear();
            invBaseQty = BigDecimal.ZERO;
            while (rsDecompose.next()) {
                invBaseQty = rsDecompose.getBigDecimal(BASEQTY).add(invBaseQty);
                if (rsDecompose.getString(UNIT).equals(invModel.get(UNIT))) continue;
                tmpIdList.add(rsDecompose.getString("FID"));
            }
            if (invBaseQty.compareTo((BigDecimal)invModel.get(BASEQTY)) < 0) {
                tmpIdList.clear();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsDecompose, preStmtDecompose, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsDecompose, (Statement)preStmtDecompose, (Connection)conn);
        return tmpIdList;
    }

    private void setPreStmtDecomposeParams(PreparedStatement preStmtDecompose, Map invModel) throws SQLException {
        int index = 1;
        Object value = null;
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) || fieldInfo.getFieldName().equalsIgnoreCase(UNIT) || fieldInfo.getFieldName().equalsIgnoreCase(BASEUNIT) || fieldInfo.getFieldName().equalsIgnoreCase(ASSISTUNIT)) continue;
            value = invModel.get(fieldInfo.getFieldName());
            if (value == null) {
                preStmtDecompose.setObject(index++, value);
                continue;
            }
            preStmtDecompose.setObject(index++, value);
        }
    }

    public String getInventorySql() {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT FID AS FID,FBaseQty AS FBaseQty,FUnitID AS FUnitID ");
        sqlBuff.append("FROM T_IM_Inventory ");
        sqlBuff.append(this.getInvDimWhereSQL());
        return sqlBuff.toString();
    }

    private String getInvDimWhereSQL() {
        StringBuffer sqlBuff = new StringBuffer("WHERE ");
        boolean isFirst = true;
        BalanceFieldModelInfo fieldInfo = null;
        BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
        for (int i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) || fieldInfo.getFieldName().equalsIgnoreCase(UNIT) || fieldInfo.getFieldName().equalsIgnoreCase(BASEUNIT) || fieldInfo.getFieldName().equalsIgnoreCase(ASSISTUNIT)) continue;
            if (!isFirst) {
                sqlBuff.append(" AND ");
            }
            sqlBuff.append(fieldInfo.getFieldName()).append(" = ? ");
            isFirst = false;
        }
        return sqlBuff.toString();
    }

    private List getLackQtyInvInfoList(Set<String> invIdSet, Map<String, Map> invModelMap) throws BOSException, EASBizException {
        ArrayList<InventoryInfo> lackQtyInvInfoList = new ArrayList<InventoryInfo>();
        if (invIdSet.size() == 0) {
            return lackQtyInvInfoList;
        }
        Map invModel = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", invIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getInvntorySelector());
        InventoryCollection coll = InventoryFactory.getLocalInstance(this.ctx).getInventoryCollection(view);
        InventoryInfo inventoryInfo = null;
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
        for (int i = 0; coll != null && i < coll.size(); ++i) {
            inventoryInfo = coll.get(i);
            invModel = invModelMap.get(inventoryInfo.getId().toString());
            inventoryInfo.setCurStoreQty((BigDecimal)invModel.get(QTY));
            inventoryInfo.setCurStoreAssistQty((BigDecimal)invModel.get(ASSISTQTY));
            inventoryInfo.setBaseQty((BigDecimal)invModel.get(BASEQTY));
            inventoryInfo.setUnit(iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK((String)invModel.get(UNIT))));
            lackQtyInvInfoList.add(coll.get(i));
        }
        return lackQtyInvInfoList;
    }

    public SelectorItemCollection getInvntorySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("companyOrgUnit.id");
        sic.add("companyOrgUnit.number");
        sic.add("companyOrgUnit.name");
        sic.add("storageOrgUnit.id");
        sic.add("storageOrgUnit.number");
        sic.add("storageOrgUnit.name");
        sic.add("warehouse.id");
        sic.add("warehouse.number");
        sic.add("warehouse.name");
        sic.add("location.id");
        sic.add("location.number");
        sic.add("location.name");
        sic.add("storetype.id");
        sic.add("storetype.number");
        sic.add("storetype.name");
        sic.add("storestatus.id");
        sic.add("storestatus.number");
        sic.add("storestatus.name");
        sic.add("supplier.id");
        sic.add("supplier.number");
        sic.add("supplier.name");
        sic.add("customer.id");
        sic.add("customer.number");
        sic.add("customer.name");
        sic.add("material.id");
        sic.add("material.number");
        sic.add("material.name");
        sic.add("material.model");
        sic.add("material.pricePrecision");
        sic.add("unit.id");
        sic.add("unit.number");
        sic.add("unit.name");
        sic.add("assistUnit.id");
        sic.add("assistUnit.number");
        sic.add("assistUnit.name");
        sic.add("baseUnit.id");
        sic.add("baseUnit.number");
        sic.add("baseUnit.name");
        sic.add("assistProperty.id");
        sic.add("assistProperty.number");
        sic.add("assistProperty.name");
        return sic;
    }

    private String buildDetailErrorMsg(List<Map> recList) {
        StringBuffer errorInfo = new StringBuffer();
        boolean isNagetive = false;
        String shortQtyTitle = "";
        String qtyStr = "";
        String unitName = "";
        Map invModel = null;
        String entrySeq = "";
        for (int i = 0; i < recList.size(); ++i) {
            invModel = recList.get(i);
            entrySeq = invModel.get("FEntrySeq");
            String materialNumber = (String)invModel.get(MATERIALNUMBER);
            String materialName = (String)invModel.get(MATERIALNAME);
            String warehouseNumber = (String)invModel.get(WAREHOUSENUMBER);
            String warehouseName = (String)invModel.get(WAREHOUSENAME);
            BigDecimal qty = (BigDecimal)invModel.get(QTY);
            BigDecimal baseQty = (BigDecimal)invModel.get(BASEQTY);
            int unitPrecision = (Integer)invModel.get(QTYPRECISION);
            unitName = (String)invModel.get(UNITNAME);
            isNagetive = false;
            if (qty.signum() == -1 && baseQty.signum() == -1) {
                qty = qty.setScale(unitPrecision).abs();
                shortQtyTitle = ResourceUtil.getMessage((Context)this.ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CurStoreQty", null);
                qtyStr = InvAppUtils.getDecimalFormatString(this.ctx, qty, qty.scale());
                isNagetive = true;
            }
            if (!isNagetive) continue;
            String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ShortQtyMessage", (Locale)this.ctx.getLocale()), entrySeq, materialName, materialNumber, shortQtyTitle, qtyStr, unitName, warehouseNumber, warehouseName);
            errorInfo.append(msg).append("\n");
        }
        return errorInfo.toString();
    }
}

