/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.engin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.UpdateTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceDataModelSQLBuilder;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InventoryRenovatorSQLBuilder
extends BalanceDataModelSQLBuilder {
    private static final String FIELD_STORAGEID = "0gOHzMZiQFG3/EyNXrWMilpFjOY=";
    private static final String FIELD_WAREHOUSEID = "ICuMIzetTEiO44JQbCChBFpFjOY=";
    private static final String FIELD_MATERIALID = "XCYTLj+ZSQy75cIprO5omVpFjOY=";
    private Context ctx;
    private Map params;
    private String storageId;

    public InventoryRenovatorSQLBuilder(Context ctx, BalanceModelInfo balanceModelInfo, BalanceDataModelInfo dataModelInfo, Map params) {
        super(balanceModelInfo, dataModelInfo);
        this.ctx = ctx;
        this.params = params;
    }

    public String getSQL() throws BOSException, BalanceModelException {
        this.initStorageId();
        if (this.isARBillDataModel() && !this.isUpdateByARBill()) {
            return null;
        }
        return super.getSQL();
    }

    private void initStorageId() throws BalanceModelException {
        this.storageId = (String)this.params.get("StorageID");
        if (StringUtil.isEmpty((String)this.storageId)) {
            throw new BalanceModelException(BalanceModelException.STORAGEISNULL);
        }
    }

    protected String getFieldDataModelSQL(BalanceFieldModelInfo fieldModel, BalanceFieldDataModelInfo fieldDataModel) {
        String result = super.getFieldDataModelSQL(fieldModel, fieldDataModel);
        if (BizDataTypeEnum.HappenData.equals((Object)fieldModel.getBizDataType()) && UpdateTypeEnum.Sub.equals((Object)this.dataModelInfo.getUpdateType())) {
            result = "(-1) * " + result;
        }
        return result;
    }

    protected FilterInfo getExtendFilter() throws BalanceModelException, BOSException {
        Set material;
        FilterInfo filter = new FilterInfo();
        String mainTable = this.dataModelInfo.getDataQuery().getMainTable().getTableAlias();
        if (this.isARBillDataModel()) {
            String baseStatus = mainTable + ".FBillStatus";
            filter.getFilterItems().add(new FilterItemInfo(baseStatus, (Object)3));
        } else {
            String baseStatus = mainTable + ".FBaseStatus";
            if (this.dataModelInfo.getDataQuery().getBillBosType().equals("15F2BD83")) {
                HashSet<Integer> set = new HashSet<Integer>();
                set.add(4);
                set.add(7);
                filter.getFilterItems().add(new FilterItemInfo(baseStatus, set, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(baseStatus, (Object)4));
            }
        }
        String storageId = (String)this.params.get("StorageID");
        filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameById(FIELD_STORAGEID), (Object)storageId));
        Set warehouse = (Set)this.params.get("WarehouseIDs");
        if (warehouse != null && warehouse.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameById(FIELD_WAREHOUSEID), (Object)warehouse, CompareType.INCLUDE));
        }
        if ((material = (Set)this.params.get("MaterialIDs")) != null && material.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(this.getFieldNameById(FIELD_MATERIALID), (Object)material, CompareType.INCLUDE));
        }
        return filter;
    }

    private boolean isARBillDataModel() {
        String billBOSType = this.dataModelInfo.getDataQuery().getBillBosType();
        return "FC910EF3".equals(billBOSType);
    }

    private boolean isUpdateByARBill() throws BalanceModelException, BOSException {
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        try {
            OrgUnitCollection coll = iUnitRel.getToUnit(this.storageId, 4, 1);
            if (coll.size() == 0) {
                throw new BalanceModelException(BalanceModelException.STORAGEISNOTTOCOMPANY);
            }
            String companyOrgUnitId = coll.get(0).getId().toString();
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
            String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgUnitId), "CONSIGNSALES");
            if (isUpdateByARBILL != null) {
                return isUpdateByARBILL.trim().equals("true");
            }
        }
        catch (EASBizException e) {
            throw new BalanceModelException(new NumericExceptionSubItem(e.getCode(), e.getMessage()));
        }
        return false;
    }
}

