/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.plugin.BalancePlugInAdapter;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;

public class InvRealTimeBalanceSerialNumberPlugInHandler
extends BalancePlugInAdapter {
    public void handleAfterDetailData(Context ctx, String detailTempTable, HandlerParameter params) throws BOSException, EASBizException {
    }

    public void handleAfterFinalDataBeforeLock(Context ctx, String finalTempTable, HandlerParameter params) throws BOSException, EASBizException {
        String detailTempTable = params.getDetailTempTable();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        StringBuffer buff = new StringBuffer();
        buff.append(" select t1.fid as finventoryid, t1.fstorageorgunitid as fstorageorgunitid, t1.fcurstoreqty as fcurstoreqty, ");
        buff.append(" t5.finventoryid as finventoryidSN, t4.fmaterialid, t4.fserialnumber, t5.fsnstatus from ");
        buff.append(detailTempTable).append(" t1 ");
        buff.append(" inner join (select fbillentryid, fmaterialid, fserialnumber from T_IV_MaterialSerialNumber t2 ");
        buff.append(" inner join T_IV_MaterialSerialNumberEntry t3 on t2.fid = t3.fparentid) t4 on t1.fbillentryid = t4.fbillentryid ");
        buff.append(" inner join T_IV_MaterialSNInventory t5 on t4.fmaterialid = t5.fmaterialid and t4.fserialnumber = t5.fserialnumber ");
        buff.append(" order by t1.fbillentryid asc, t1.fcurstoreqty ");
        if (params.getOPType() == OperationTypeEnum.Positive) {
            buff.append("asc");
        } else if (params.getOPType() == OperationTypeEnum.Reverse) {
            buff.append("desc");
        }
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)buff.toString());
        try {
            String updateSql = " update T_IV_MaterialSNInventory set finventoryid = ? where fmaterialid = ? and fserialnumber = ? ";
            Object[][] conditions = new String[rs.size()][3];
            int i = 0;
            while (rs.next()) {
                String inventoryID = rs.getString("finventoryid");
                String materialID = rs.getString("fmaterialid");
                String serialNumber = rs.getString("fserialnumber");
                String inventoryIDSN = rs.getString("finventoryidSN");
                int snStatus = rs.getInt("fsnstatus");
                String storageOrgUnitID = rs.getString("fstorageorgunitid");
                BigDecimal curStoreQty = rs.getBigDecimal("fcurstoreqty");
                if (snStatus == 1) {
                    this.checkOutInvInventoryID(ctx, paramMap, storageOrgUnitID, inventoryID, inventoryIDSN);
                    conditions[i][0] = null;
                } else if (snStatus == 2) {
                    conditions[i][0] = inventoryID;
                } else {
                    if (snStatus != 3) continue;
                    if (curStoreQty == null || curStoreQty.compareTo(BigDecimal.ZERO) == 0) {
                        conditions[i][0] = inventoryID;
                    } else if (params.getOPType() == OperationTypeEnum.Positive && curStoreQty.compareTo(BigDecimal.ZERO) > 0 || params.getOPType() == OperationTypeEnum.Reverse && curStoreQty.compareTo(BigDecimal.ZERO) < 0) {
                        conditions[i][0] = inventoryID;
                    } else {
                        this.checkOutInvInventoryID(ctx, paramMap, storageOrgUnitID, inventoryID, inventoryIDSN);
                        conditions[i][0] = null;
                    }
                }
                conditions[i][1] = materialID;
                conditions[i][2] = serialNumber;
                ++i;
            }
            KsqlUtil.executeBatch((Context)ctx, (String)updateSql, (Object[][])conditions);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkOutInvInventoryID(Context ctx, HashMap<String, String> paramMap, String storageOrgUnitID, String inventoryID, String inventoryIDSN) throws BOSException {
        try {
            boolean paramBoolean = true;
            if (!StringUtils.isEmpty((String)storageOrgUnitID)) {
                String param = paramMap.get(storageOrgUnitID + "INM002");
                if (StringUtils.isEmpty((String)param)) {
                    String getParamSQL = "select fvalue_l2 from t_bas_paramitem t1 inner join t_bas_param t2 on t1.fkeyid = t2.fid  where t2.fnumber = 'INM002' and t1.forgunitid = '" + storageOrgUnitID + "'";
                    IRowSet paramRs = DbUtil.executeQuery((Context)ctx, (String)getParamSQL);
                    if (paramRs.next()) {
                        param = paramRs.getString("fvalue_l2");
                        paramMap.put(storageOrgUnitID.toString() + "INM002", param);
                        paramBoolean = "true".equalsIgnoreCase(param);
                    }
                } else {
                    boolean bl = paramBoolean = !"false".equalsIgnoreCase(StringUtils.trim((String)param));
                }
            }
            if (paramBoolean && !inventoryID.equals(inventoryIDSN)) {
                String errorMessage = ResourceUtil.getMessage((String)"com.kingdee.eas.scm.im.inv.MaterialSNResource", (String)"CANNOT_OUTINV_SNINFOERROR");
                throw new BOSException(errorMessage);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

