/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.writeback.IInvReWriteOrder;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.im.reservation.service.BillReservationCancelService;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractReWriteOrder
implements IInvReWriteOrder {
    @Override
    public void reWrite(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, EASBizException, BOSException {
        this.updatePrecisionAndRate(ctx, invUpdPara, 1);
        this.reWriteCoreOrder(ctx, invUpdPara);
        this.updatePrecisionAndRate(ctx, invUpdPara, 2);
        this.reWriteSourceOrder(ctx, invUpdPara);
    }

    protected void updatePrecisionAndRate(Context ctx, WriteBackParamInfo invUpdPara, int type) throws BOSException {
        try {
            String needUpdateTbl;
            String coreBillType = invUpdPara.getCoreBillType();
            String srcBillType = invUpdPara.getSourceBillType();
            String tempTableName = invUpdPara.getTempTableName();
            if (type == 1) {
                needUpdateTbl = SCMServerUtil.getEntryTableNameByBillType((Context)ctx, (String)coreBillType);
            } else {
                needUpdateTbl = this.getSpecialSrcRewriteTbl(invUpdPara);
                if (needUpdateTbl == null) {
                    needUpdateTbl = SCMServerUtil.getEntryTableNameByBillType((Context)ctx, (String)srcBillType);
                }
            }
            if (needUpdateTbl == null) {
                return;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("update ").append(tempTableName).append(" tempTbl set (FBaseConvsRate,FQtyPrecision) = ");
            sql.append("(SELECT mmu.FBASECONVSRATE,mmu.FQTYPRECISION from ").append(tempTableName).append(" t1 ");
            sql.append("inner join ").append(needUpdateTbl).append(" needUpdateEntry on ");
            sql.append("t1.").append(type == 1 ? "FCOREBILLENTRYID" : "FSourceBillEntryId").append(" = needUpdateEntry.fid ");
            sql.append("inner join t_bd_multimeasureunit mmu on needUpdateEntry.FMATERIALID = mmu.FMATERIALID and needUpdateEntry.FUNITID = mmu.FMEASUREUNITID ");
            sql.append("where tempTbl.FBillEntryID = t1.FBillEntryID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getSpecialSrcRewriteTbl(WriteBackParamInfo invUpdPara) {
        String needUpdateTbl = null;
        if ("104".equals(invUpdPara.getBillTypeNo()) && "901".equals(invUpdPara.getSourceBillType())) {
            needUpdateTbl = "T_SM_SubMaterialList";
        } else if ("107".equals(invUpdPara.getBillTypeNo()) && "107".equals(invUpdPara.getSourceBillType())) {
            needUpdateTbl = "T_IM_MoveIssueBillEntry";
        } else if ("106".equals(invUpdPara.getBillTypeNo()) && "106".equals(invUpdPara.getSourceBillType())) {
            needUpdateTbl = "T_IM_StockTransferBillEntry";
        }
        return needUpdateTbl;
    }

    abstract void reWriteCoreOrder(Context var1, WriteBackParamInfo var2) throws InvUpdateException, EASBizException, BOSException;

    abstract void reWriteSourceOrder(Context var1, WriteBackParamInfo var2) throws InvUpdateException, EASBizException, BOSException;

    protected void rewriteReversedSource(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, EASBizException, BOSException {
        String billEntryTable = invUpdPara.getBillEntryTable();
        String tempTableName = invUpdPara.getTempTableName();
        boolean isAudit = invUpdPara.getBizAction().getValue() == 103;
        String sign = isAudit ? "+" : "-";
        String reSign = isAudit ? "-" : "+";
        StringBuffer sql = new StringBuffer();
        sql.append("update " + billEntryTable + " as T set (FReverseQty,FReverseBaseQty,FAssociateQty) = ");
        sql.append("(select ");
        sql.append("T.FReverseQty ").append(sign).append(" a.FQty,");
        sql.append("T.FReverseBaseQty ").append(sign).append(" a.FBaseQty,");
        sql.append("T.FAssociateQty ").append(reSign).append(" a.FBaseQty ");
        sql.append("from ");
        sql.append(tempTableName + " a ");
        sql.append("where ");
        sql.append("T.fid = a.FSourceBillEntryId");
        sql.append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void setPurOrderStatus(Context ctx, String purOrderID, String tempTable) throws EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT a.FIsManualClose as FIsManualClose,");
            sqlBuff.append("a.FID as FID,a.FMaterialID as FMaterialID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("round(isnull(a.FTotalReceiptBaseQty,0) - decimal(isnull(a.FBaseQty,0) * decimal((100 - isnull(a.FReceiveOwingRate,0)),21,8),21,8)/100  - decimal(isnull(a.ftotalSupplyStockBaseQty,0) * isnull(b.FBaseConvsRate,0),21,8),b.FQtyPrecision) as FBaseQty,");
            sqlBuff.append("a.FIsQuantityUnCtrl as FIsQuantityUnCtrl ");
            sqlBuff.append("FROM ");
            sqlBuff.append(" T_SM_PurOrderEntry a left join t_bd_multimeasureunit b ");
            sqlBuff.append(" on a.fmaterialid = b.fmaterialid and a.fbaseunitid = b.fmeasureunitid ");
            sqlBuff.append(" left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            sqlBuff.append(" WHERE ");
            sqlBuff.append(" a.FParentID = '" + purOrderID + "' ");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SM_PurOrderEntry SET FBaseStatus = 7 ,FCloseDate = to_date('" + IMRptUtils.getFmtDateAndTime(new Date()) + "') WHERE FID = ? ");
            preStmt2 = conn.prepareStatement("UPDATE T_SM_PurOrderEntry SET FBaseStatus = 4,FCloseDate = null,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID = ?  ");
            preStmt3 = conn.prepareStatement("UPDATE T_SM_PurOrder SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SM_PurOrder SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND  FID = ?");
            while (rs.next()) {
                if (rs.getString("FMaterialID") == null) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    closeOrder = false;
                    continue;
                }
                if (rs.getBigDecimal("FBaseQty") != null && rs.getBigDecimal("FBaseQty").signum() >= 0 && rs.getString("tFID") != null) {
                    if (rs.getBoolean("FIsManualClose") || rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getBoolean("FIsManualClose")) continue;
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, purOrderID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, purOrderID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setPurOrderStatusForRecv(Context ctx, String purOrderID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("a.FBaseQty -  round(decimal(decimal(a.FBaseQty * a.FReceiveOwingRate,21,8)/100,21,8),b.FQtyPrecision) ");
            sqlBuff.append(" - a.FTotalReceiveBaseQty as FBaseQty,");
            sqlBuff.append("a.FIsQuantityUnCtrl as FIsQuantityUnCtrl");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_SM_PurOrderEntry a inner join t_bd_multimeasureunit b ");
            sqlBuff.append("on a.fmaterialid = b.fmaterialid and a.fbaseunitid = b.fmeasureunitid ");
            sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            sqlBuff.append("WHERE ");
            sqlBuff.append(" FParentID = '" + purOrderID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SM_PurOrderEntry SET FBaseStatus = 7,FCloseDate = to_date('" + IMRptUtils.getFmtDateAndTime(new Date()) + "')  WHERE FID = ?  ");
            preStmt2 = conn.prepareStatement("UPDATE T_SM_PurOrderEntry SET FBaseStatus = 4,FCloseDate = null,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID = ? ");
            preStmt3 = conn.prepareStatement("UPDATE T_SM_PurOrder SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SM_PurOrder SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND  FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7 || rs.getString("tFID") == null) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, purOrderID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, purOrderID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setSaleOrderStatus(Context ctx, String saleOrderID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("isnull(a.FBaseQty,0) -   round(decimal(isnull(a.FBaseQty ,0)* isnull(a.FSendOwingRate,0),21,8)/100,isnull(b.FQtyPrecision,0))");
            sqlBuff.append("- isnull(a.FTotalIssueBaseQty,0)+isnull(a.FTotalSupplyStockQty,0) as FBaseQty,");
            sqlBuff.append("isnull(a.FBaseQty,0) - isnull(a.FTotalIssueBaseQty,0)+ round(decimal(isnull(a.FTotalSupplyStockQty,0)*isnull(b.FBaseConvsRate,0),21,8),isnull(b.FQtyPrecision,0)) ");
            sqlBuff.append(" - round(decimal(isnull(a.FBaseQty,0) * isnull(a.FSendOwingRate,0),21,8)/100,isnull(b.FQtyPrecision,0)) as FOtherBaseQty,");
            sqlBuff.append("a.FQuantityUnCtrl as FQuantityUnCtrl ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_SD_SaleOrderEntry a inner join t_bd_multimeasureunit b ").append("on a.fmaterialid = b.fmaterialid and a.fbaseunitid = b.fmeasureunitid ");
            sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("FParentID = '" + saleOrderID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SD_SaleOrderEntry SET FBaseStatus = 7  WHERE FID = ? ");
            preStmt2 = conn.prepareStatement("UPDATE T_SD_SaleOrderEntry SET FBaseStatus = 4,freasoncodeid = null ,freason = null  WHERE FBaseStatus = 7 AND FID = ? ");
            preStmt3 = conn.prepareStatement("UPDATE T_SD_SaleOrder SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SD_SaleOrder SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") != 7 && rs.getString("tFID") != null) {
                        preStmt.setString(1, rs.getString("FID"));
                        preStmt.addBatch();
                        ++updateLine;
                    }
                } else {
                    if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                        closeOrder = false;
                    }
                    if (rs.getInt("FBaseStatus") == 7 && rs.getString("tFID") != null) {
                        preStmt2.setString(1, rs.getString("FID"));
                        preStmt2.addBatch();
                        ++updateLine2;
                    }
                }
                if (rs.getBigDecimal("FOtherBaseQty").signum() <= 0) continue;
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, saleOrderID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, saleOrderID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
                IDynamicObject iDynamicObject = null;
                ObjectUuidPK orderPk = new ObjectUuidPK(saleOrderID);
                iDynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
                IObjectValue orderInfo = iDynamicObject.getValue(orderPk.getObjectType(), (IObjectPK)orderPk);
                BillReservationCancelService billReservationCancelService = BillReservationCancelService.getInstance();
                billReservationCancelService.doBillReservationCancel(ctx, orderInfo);
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setPurReturnStatus(Context ctx, String billID, String tempTable, boolean isCoreBill) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,t.FBillID as tFID, a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("a.FBaseQty - ISNULL(a.FReturnedBaseQty,0) as FBaseQty ");
            sqlBuff.append("FROM T_SM_PurReturnsEntry a ");
            if (isCoreBill) {
                sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            } else {
                sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FSourceBillEntryId ");
            }
            sqlBuff.append("WHERE ");
            sqlBuff.append("FParentID = '" + billID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SM_PurReturnsEntry SET FBaseStatus = 7,FClosedDate = to_date('" + IMRptUtils.getFmtDateAndTime(new Date()) + "')  WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_SM_PurReturnsEntry SET FBaseStatus = 4,FClosedDate = null,freasoncodeid = null  WHERE  FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_SM_PurReturns SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SM_PurReturns SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0 && rs.getString("tFID") != null) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setSaleReturnStatus(Context ctx, String billID, String tempTable, boolean isCoreBillType, boolean isCarryBill) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,");
            if (isCarryBill) {
                sqlBuff.append("t.FSourceBillEntryId as tFID,");
            } else if (isCoreBillType) {
                sqlBuff.append("t.FCoreBillEntryId as tFID,");
            } else {
                sqlBuff.append("t.FSourceBillEntryId as tFID,");
            }
            sqlBuff.append("a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("a.FBaseQty - a.FReturnsBaseQty as FBaseQty ");
            sqlBuff.append("FROM  T_SD_SaleReturnsEntry a ");
            sqlBuff.append("left join ").append(tempTable).append(" t ");
            if (isCarryBill) {
                sqlBuff.append(" on a.FSourceBillEntryID  = t.FCoreBillEntryId ");
            } else if (isCoreBillType) {
                sqlBuff.append(" on a.fid  = t.FCoreBillEntryId ");
            } else {
                sqlBuff.append(" on a.fid  = t.FSourceBillEntryId ");
            }
            sqlBuff.append("WHERE ");
            sqlBuff.append("FParentID = '" + billID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SD_SaleReturnsEntry SET FBaseStatus = 7  WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_SD_SaleReturnsEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE  FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_SD_SaleReturns SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SD_SaleReturns SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0 && rs.getString("tFID") != null) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setStockTransStatus(Context ctx, String billID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        PreparedStatement closePeriodPreStmt = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("stbe.FID as FID,stbe.FBaseStatus as FBaseStatus, ");
            sqlBuff.append("decimal(stbe.FBaseQty* (  1 -  decimal(ISNULL(stbe.FQuarityArreRate,0) / 100,21,8)),21,8) - stbe.FReceiptBaseQty as FBaseQty, ");
            sqlBuff.append("t.FCoreBillEntryId as tFID ");
            sqlBuff.append("FROM T_IM_StockTransferBillEntry stbe ");
            sqlBuff.append(" left join ").append(tempTable).append(" t on stbe.fid  = t.FCoreBillEntryId ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("stbe.FParentID = '" + billID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_IM_StockTransferBillEntry SET FBaseStatus = 7  WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_IM_StockTransferBillEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_IM_StockTransferBill SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_IM_StockTransferBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            closePeriodPreStmt = conn.prepareStatement("UPDATE T_IM_StockTransferBillEntry SET FClosePeriod = ( SELECT MAX(a.FYEAR*100 + a.FPERIOD)  FROM T_IM_MOVEINWAREHSBILL a  INNER join T_IM_MOVEINWAREHSBILLENTRY  b on a.fid = b.FPARENTID  WHERE b.FSTOCKTRANSBILLENTRYID = ?) where fid = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    closePeriodPreStmt.setString(1, rs.getString("FID"));
                    closePeriodPreStmt.setString(2, rs.getString("FID"));
                    preStmt.addBatch();
                    closePeriodPreStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getString("tFID") == null || rs.getInt("FBaseStatus") != 7) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
                closePeriodPreStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                SQLUtils.cleanup(closePeriodPreStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
        SQLUtils.cleanup((Statement)closePeriodPreStmt);
    }

    protected void setTransOrderStatus(Context ctx, String billID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        PreparedStatement preStmt5 = null;
        PreparedStatement preStmt6 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        boolean flag = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("round(decimal( a.FBaseQty * round(decimal(1 - ISNULL(a.FQtyLackRate,0)/100,21,8),4) ,21,8) ,b.FQtyPrecision)  - a.FReceiptBaseQty as FBaseQty,");
            sqlBuff.append("a.FIssueBaseQty - a.FReceiptBaseQty as FBaseQty2,");
            sqlBuff.append("a.FNotControlQty as FNotControlQty ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_IM_TransferOrderBillEntry a  ");
            sqlBuff.append("inner join T_IM_TransferOrderBill c on a.FParentID = c.FID ");
            sqlBuff.append("inner join t_bd_multimeasureunit b on a.fmaterialid = b.fmaterialid and a.fbaseunitid = b.fmeasureunitid ");
            sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            sqlBuff.append("WHERE c.FBizDirection = 1 and a.FParentID = '" + billID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 7  WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_IM_TransferOrderBillEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_IM_TransferOrderBill SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_IM_TransferOrderBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            preStmt5 = conn.prepareStatement("UPDATE T_IV_MaterialSerialNumber SET FBillBaseStatus = 7  WHERE FBillID = ?");
            preStmt6 = conn.prepareStatement("UPDATE T_IV_MaterialSerialNumber SET FBillBaseStatus = 4 WHERE FBillBaseStatus = 7 AND FBillID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0 && rs.getString("tFID") != null) {
                    if (rs.getInt("FBaseStatus") != 7) {
                        preStmt.setString(1, rs.getString("FID"));
                        preStmt.addBatch();
                        ++updateLine;
                    }
                } else {
                    if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                        closeOrder = false;
                    }
                    if (rs.getInt("FBaseStatus") == 7 && rs.getString("tFID") != null) {
                        preStmt2.setString(1, rs.getString("FID"));
                        preStmt2.addBatch();
                        ++updateLine2;
                    }
                }
                flag = true;
            }
            if (closeOrder && flag) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                preStmt5.setString(1, billID);
                preStmt5.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                preStmt6.setString(1, billID);
                preStmt6.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt5.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt6.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setMaterialRequestStatus(Context ctx, String billID, String tempTable, boolean isReversed) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            if (isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
                sqlBuff.append("a.FApprovedQty*(1 - decimal(ISNULL(A.FQuarityArreRate,0)/100 ,21,8)) - a.FTotalFinishQty as FQty ");
                sqlBuff.append("FROM ");
                sqlBuff.append("T_IM_MaterialRequestBillEntry a ");
                sqlBuff.append("left join ").append("(select t1.fid as FBillID,t1.FSourceBillEntryId as FSourceBillEntryId from ");
                sqlBuff.append(tempTable).append(" t0, t_im_materialreqbillentry t1 where t0.FSourceBillEntryId = t1.fid  ) ");
                sqlBuff.append(" t on a.fid  = t.FSourceBillEntryId ");
                sqlBuff.append("WHERE ");
                sqlBuff.append("a.FParentID = '" + billID + "'");
            } else {
                sqlBuff.append("SELECT ");
                sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
                sqlBuff.append("a.FApprovedQty*(1 - decimal(ISNULL(A.FQuarityArreRate,0)/100 ,21,8)) - a.FTotalFinishQty as FQty ");
                sqlBuff.append("FROM ");
                sqlBuff.append("T_IM_MaterialRequestBillEntry a ");
                sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FSourceBillEntryId ");
                sqlBuff.append("WHERE ");
                sqlBuff.append("a.FParentID = '" + billID + "'");
            }
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_IM_MaterialRequestBillEntry SET FBaseStatus = 7  WHERE FID = ? ");
            preStmt2 = conn.prepareStatement("UPDATE T_IM_MaterialRequestBillEntry SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ? ");
            preStmt3 = conn.prepareStatement("UPDATE T_IM_MaterialRequestBill SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_IM_MaterialRequestBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7 || rs.getString("tFID") == null) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setSaleSendStatus(Context ctx, String billID, String tempTable, WriteBackParamInfo invUpdPara) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        PreparedStatement preStmt5 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        int updateLine5 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer preStmt5SqlBuff = new StringBuffer();
        ResultSet rs = null;
        boolean isReversed = invUpdPara.isReversed();
        boolean isUnAudit = invUpdPara.getBizAction().getValue() == 109;
        String unSign = "+";
        if (isUnAudit) {
            unSign = "-";
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            if (!isReversed) {
                sqlBuff.append("SELECT ");
                sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
                sqlBuff.append("a.FBaseQty - a.FShippedBaseQty as FBaseQty ");
                sqlBuff.append("FROM  T_SD_PostRequisitionEntry a ");
                sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FSourceBillEntryId ");
                sqlBuff.append("WHERE ");
                sqlBuff.append("a.FParentID = '" + billID + "'");
                preStmt5SqlBuff.append("update T_SD_SaleOrderEntry set (FTotalUnIssueBaseQty,FTotalUnIssueQty)=");
                preStmt5SqlBuff.append(" ( select ");
                preStmt5SqlBuff.append(" T_SD_SaleOrderEntry.FTotalUnIssueBaseQty").append(unSign).append("(pre.FBaseQty-t.FBaseQty),");
                preStmt5SqlBuff.append(" T_SD_SaleOrderEntry.FTotalUnIssueQty").append(unSign).append("(pre.FQty-t.FQty)");
                preStmt5SqlBuff.append(" from T_SD_PostRequisitionEntry pre,  ");
                preStmt5SqlBuff.append("  (");
                preStmt5SqlBuff.append("   select FSourceBillEntryId,decimal(sum(sie.FBaseqty),21,8) as fbaseqty,decimal(sum(sie.FQty),21,8) as fqty");
                preStmt5SqlBuff.append("   from T_IM_SaleIssueEntry sie where sie.FSourceBillEntryId=? group by FSourceBillEntryId");
                preStmt5SqlBuff.append("  ) t");
                preStmt5SqlBuff.append("  where t.FSourceBillEntryId=pre.fid");
                preStmt5SqlBuff.append("  and pre.FSourceBillEntryId=T_SD_SaleOrderEntry.FID");
                preStmt5SqlBuff.append(")");
                preStmt5SqlBuff.append(" where T_SD_SaleOrderEntry.fid in (select FSourceBillEntryId from ").append(tempTable).append(") ");
            } else {
                sqlBuff.append("SELECT ");
                sqlBuff.append("a.FID as FID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
                sqlBuff.append("a.FBaseQty - a.FShippedBaseQty as FBaseQty ");
                sqlBuff.append("FROM  T_SD_PostRequisitionEntry a ");
                sqlBuff.append("left join ").append("( select s.FSourceBillEntryId as FBillID,").append("s.FSourceBillEntryId as FSourceBillEntryId  from t_im_saleissueentry s, ").append(tempTable).append(" p where s.fid  = p.FSourceBillEntryId ").append(" group by s.FSourceBillEntryId) t ").append("on a.fid  = t.FSourceBillEntryId ");
                sqlBuff.append("WHERE ");
                sqlBuff.append("a.FParentID = '" + billID + "'");
            }
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String paramvalue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(PostRequisitionFactory.getLocalInstance((Context)ctx).getPostRequisitionInfo((IObjectPK)new ObjectUuidPK(billID)).getSaleOrgUnit().getId()), "SALEORDER005");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SD_PostRequisitionEntry SET FBaseStatus = 7  WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_SD_PostRequisitionEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE  FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_SD_PostRequisition SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SD_PostRequisition SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            preStmt5 = conn.prepareStatement(preStmt5SqlBuff.toString());
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0 && rs.getString("tFID") != null) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
                if (!Boolean.valueOf(paramvalue).booleanValue() || isReversed) continue;
                preStmt5.setString(1, rs.getString("FID"));
                preStmt5.addBatch();
                ++updateLine5;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
            if (updateLine5 > 0) {
                preStmt5.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setSubContractOrderStatus(Context ctx, String subContractOrderID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Locale loc = ctx.getLocale();
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT t.FBillNumber as piwNumber,t.FSeq as piwSeq, po.FNumber as poNumber,poe.FSeq as poSeq, ");
            sqlBuff.append("ROUND((poe.FTotalReceiptQty-poe.FTotalReturnStockQty ");
            sqlBuff.append("- DECIMAL(poe.FQty * DECIMAL(1 + poe.FReceiveOverRate/100,21,8),28,10)),mmu.FQtyPrecision) AS FOverQty ");
            sqlBuff.append("FROM T_SM_SubContractOrderEntry poe LEFT JOIN " + tempTable + " t ON t.FCoreBillEntryId = poe.FId ");
            sqlBuff.append("LEFT JOIN T_SM_SubContractOrder po ON po.FId = poe.FParentId ");
            sqlBuff.append("LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMeasureUnitId = poe.FUnitId AND mmu.FMaterialId = poe.FMaterialId ");
            sqlBuff.append("WHERE poe.FIsQtyUnCtrl = 0 AND po.FId = '").append(subContractOrderID).append("' ");
            sqlBuff.append("AND poe.FTotalReceiptBaseQty - poe.FTotalReturnStockBaseQty ");
            sqlBuff.append("- DECIMAL(poe.FBaseQty * DECIMAL(1 + poe.FReceiveOverRate/100,28,10),28,10) > 0");
            rs = stmt.executeQuery(sqlBuff.toString());
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.scm.im.inv.SCMInvResource", (String)"ReWriteOrder_info2", (Locale)ctx.getOriginLocale()));
            boolean isError = false;
            while (rs.next()) {
                isError = true;
                errorMsg.append(rs.getString("piwNumber")).append("    ");
                errorMsg.append(rs.getInt("piwSeq")).append("         ");
                errorMsg.append(rs.getString("poNumber")).append("    ");
                errorMsg.append(rs.getInt("poSeq")).append("         ");
                errorMsg.append(rs.getBigDecimal("FOverQty")).append("         \n");
            }
            if (isError) {
                throw new SCMBillException(SCMBillException.WRITE_BACE_ERROR, (Object[])new String[]{errorMsg.toString()});
            }
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT  a.FIsManualClose as FIsManualClose,");
            sqlBuff.append("a.FID as FID,a.FMaterialID as FMaterialID,t.FBillID as tFID,a.FBaseStatus as FBaseStatus,");
            sqlBuff.append("round(a.FTotalReceiptBaseQty - decimal(a.FBaseQty * (100 - a.FReceiveOwingRate),21,8)/100  - a.FTotalInStockNeedBaseQty,b.FQtyPrecision) as FBaseQty,");
            sqlBuff.append("a.FIsQtyUnCtrl as FIsQuantityUnCtrl ");
            sqlBuff.append("FROM ");
            sqlBuff.append("T_SM_SubContractOrderEntry a left join t_bd_multimeasureunit b ");
            sqlBuff.append("on a.fmaterialid = b.fmaterialid and a.funitid = b.fmeasureunitid ");
            sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FCoreBillEntryId ");
            sqlBuff.append("WHERE ");
            sqlBuff.append(" a.FParentID = '" + subContractOrderID + "' ");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_SM_SubContractOrderEntry SET FBaseStatus = 7 ,FCloseDate = to_date('" + IMRptUtils.getFmtDateAndTime(new Date()) + "') WHERE FID = ? ");
            preStmt2 = conn.prepareStatement("UPDATE T_SM_SubContractOrderEntry SET FBaseStatus = 4,FCloseDate = null,freason_" + loc + " = null  WHERE FBaseStatus = " + 7 + " AND FID = ?  ");
            preStmt3 = conn.prepareStatement("UPDATE T_SM_SubContractOrder SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_SM_SubContractOrder SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND  FID = ?");
            while (rs.next()) {
                if (rs.getString("FMaterialID") == null) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    closeOrder = false;
                    continue;
                }
                if (rs.getBigDecimal("FBaseQty").signum() >= 0 && rs.getString("tFID") != null) {
                    if (rs.getBoolean("FIsManualClose") || rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getBoolean("FIsManualClose")) continue;
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, subContractOrderID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, subContractOrderID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }

    protected void setPurReceivalStatus(Context ctx, String billID, String tempTable) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        PreparedStatement preStmt = null;
        PreparedStatement preStmt2 = null;
        PreparedStatement preStmt3 = null;
        PreparedStatement preStmt4 = null;
        int updateLine = 0;
        int updateLine2 = 0;
        int updateLine3 = 0;
        int updateLine4 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            sqlBuff.append("SELECT ");
            sqlBuff.append("a.FID as FID,t.FBillID as tFID, a.FBaseStatus as FBaseStatus,a.FQTY - (a.FCheckReturnedQty + a.FReceiptQty + a.FReverseQty) as FQTY,");
            sqlBuff.append("a.FBaseQty - ISNULL(a.FReceiptBaseQty,0) as FBaseQty ");
            sqlBuff.append("FROM T_IM_PurReceivalEntry a ");
            sqlBuff.append("left join ").append(tempTable).append(" t on a.fid  = t.FSourceBillEntryId ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("FParentID = '" + billID + "'");
            rs = stmt.executeQuery(sqlBuff.toString());
            preStmt = conn.prepareStatement("UPDATE T_IM_PurReceivalEntry SET FBaseStatus = 7 WHERE FID = ?");
            preStmt2 = conn.prepareStatement("UPDATE T_IM_PurReceivalEntry SET FBaseStatus = 4,freasoncodeid = null  WHERE  FBaseStatus = 7 AND FID = ?");
            preStmt3 = conn.prepareStatement("UPDATE T_IM_PurReceivalBill SET FBaseStatus = 7  WHERE FID = ?");
            preStmt4 = conn.prepareStatement("UPDATE T_IM_PurReceivalBill SET FBaseStatus = 4 WHERE FBaseStatus = 7 AND FID = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0 && rs.getString("tFID") != null || rs.getBigDecimal("FQTY").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    preStmt.setString(1, rs.getString("FID"));
                    preStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                if (rs.getString("tFID") != null || rs.getInt("FBaseStatus") != 7) {
                    closeOrder = false;
                }
                if (rs.getInt("FBaseStatus") != 7 || rs.getString("tFID") == null) continue;
                preStmt2.setString(1, rs.getString("FID"));
                preStmt2.addBatch();
                ++updateLine2;
            }
            if (closeOrder) {
                preStmt3.setString(1, billID);
                preStmt3.addBatch();
                ++updateLine3;
            } else {
                preStmt4.setString(1, billID);
                preStmt4.addBatch();
                ++updateLine4;
            }
            if (updateLine > 0) {
                preStmt.executeBatch();
            }
            if (updateLine2 > 0) {
                preStmt2.executeBatch();
            }
            if (updateLine3 > 0) {
                preStmt3.executeBatch();
            }
            if (updateLine4 > 0) {
                preStmt4.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                SQLUtils.cleanup(preStmt);
                SQLUtils.cleanup(preStmt2);
                SQLUtils.cleanup(preStmt3);
                SQLUtils.cleanup(preStmt4);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)preStmt);
        SQLUtils.cleanup((Statement)preStmt2);
        SQLUtils.cleanup((Statement)preStmt3);
        SQLUtils.cleanup((Statement)preStmt4);
    }
}

